/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.mq.impl.aliyun;

import com.alibaba.fastjson.JSON;
import com.aliyun.ons20190214.Client;
import com.aliyun.ons20190214.models.OnsDLQMessagePageQueryByGroupIdRequest;
import com.aliyun.ons20190214.models.OnsDLQMessagePageQueryByGroupIdResponse;
import com.aliyun.ons20190214.models.OnsDLQMessagePageQueryByGroupIdResponseBody;
import com.aliyun.ons20190214.models.OnsDLQMessageResendByIdRequest;
import com.aliyun.ons20190214.models.OnsDLQMessageResendByIdResponse;
import com.aliyun.ons20190214.models.OnsGroupSubDetailRequest;
import com.aliyun.ons20190214.models.OnsGroupSubDetailResponse;
import com.aliyun.ons20190214.models.OnsGroupSubDetailResponseBody;
import com.aliyun.ons20190214.models.OnsMessageGetByKeyRequest;
import com.aliyun.ons20190214.models.OnsMessageGetByKeyResponse;
import com.aliyun.ons20190214.models.OnsMessageGetByKeyResponseBody;
import com.aliyun.ons20190214.models.OnsMessageGetByMsgIdRequest;
import com.aliyun.ons20190214.models.OnsMessageGetByMsgIdResponse;
import com.aliyun.ons20190214.models.OnsTraceGetResultRequest;
import com.aliyun.ons20190214.models.OnsTraceGetResultResponse;
import com.aliyun.ons20190214.models.OnsTraceQueryByMsgIdRequest;
import com.aliyun.ons20190214.models.OnsTraceQueryByMsgIdResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teautil.models.RuntimeOptions;
import com.xinqiyi.framework.mq.IXinQiYiRocketMqService;
import com.xinqiyi.framework.mq.XinQiYiRocketMqType;
import com.xinqiyi.framework.mq.impl.aliyun.AliyunRockMqClientBuilder;
import com.xinqiyi.framework.mq.response.DeadMqMessage;
import com.xinqiyi.framework.mq.response.DeadMqMessageConverter;
import com.xinqiyi.framework.mq.response.MqGroupOnlineResponse;
import com.xinqiyi.framework.mq.response.MqMessageInfo;
import com.xinqiyi.framework.mq.response.MqMessageInfoConverter;
import com.xinqiyi.framework.mq.response.MqTraceConverter;
import com.xinqiyi.framework.mq.response.MqTraceResponse;
import com.xinqiyi.framework.mq.response.ResendMqResponse;
import com.xinqiyi.framework.mq.response.SelectDeadMqResponse;
import com.xinqiyi.framework.mq.response.SelectMqResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@XinQiYiRocketMqType(code="aliyun", desc="\u963f\u91cc\u4e91RocketMQ")
public class AliyunRocketMqServiceImpl
implements IXinQiYiRocketMqService {
    private static final Logger log = LoggerFactory.getLogger(AliyunRocketMqServiceImpl.class);
    private final AliyunRockMqClientBuilder mqClientBuilder;

    @Override
    public SelectMqResponse selectRocketMqByMessageId(String mqInstanceId, String topic, String messageId) throws Exception {
        SelectMqResponse selectMqResponse = new SelectMqResponse();
        selectMqResponse.setExist(false);
        ArrayList<MqMessageInfo> messageInfoList = new ArrayList<MqMessageInfo>();
        Client onsClient = this.mqClientBuilder.buildOnsClient();
        OnsMessageGetByMsgIdRequest getRequest = new OnsMessageGetByMsgIdRequest();
        getRequest.setInstanceId(mqInstanceId);
        getRequest.setTopic(topic);
        getRequest.setMsgId(messageId);
        try {
            OnsMessageGetByMsgIdResponse response = onsClient.onsMessageGetByMsgId(getRequest);
            if (response.getBody() != null && response.getBody().getData() != null) {
                selectMqResponse.setExist(true);
                MqMessageInfo msgInfo = MqMessageInfoConverter.convertMqMessage(response.getBody().getData());
                messageInfoList.add(msgInfo);
            } else {
                selectMqResponse.setMessage(messageId + ": Response.Body.Data Null");
            }
            selectMqResponse.setMessageInfoList(messageInfoList);
        }
        catch (TeaException ex) {
            selectMqResponse.setExist(false);
            selectMqResponse.setMessage(ex.getMessage());
        }
        catch (Exception ex) {
            log.error("selectRocketMqByMessageKey.Error", (Throwable)ex);
            selectMqResponse.setMessage(ex.getMessage());
        }
        return selectMqResponse;
    }

    @Override
    public SelectMqResponse selectRocketMqByMessageKey(String mqInstanceId, String topic, String messageKey) throws Exception {
        SelectMqResponse selectMqResponse = new SelectMqResponse();
        selectMqResponse.setExist(false);
        ArrayList<MqMessageInfo> messageInfoList = new ArrayList<MqMessageInfo>();
        Client onsClient = this.mqClientBuilder.buildOnsClient();
        OnsMessageGetByKeyRequest onsMessageGetByKeyRequest = new OnsMessageGetByKeyRequest();
        onsMessageGetByKeyRequest.setInstanceId(mqInstanceId);
        onsMessageGetByKeyRequest.setTopic(topic);
        onsMessageGetByKeyRequest.setKey(messageKey);
        try {
            OnsMessageGetByKeyResponse response = onsClient.onsMessageGetByKey(onsMessageGetByKeyRequest);
            if (response.getBody() != null && response.getBody().getData() != null) {
                if (CollectionUtils.isNotEmpty((Collection)response.getBody().getData().getOnsRestMessageDo())) {
                    selectMqResponse.setExist(true);
                    for (OnsMessageGetByKeyResponseBody.OnsMessageGetByKeyResponseBodyDataOnsRestMessageDo messageDo : response.getBody().getData().getOnsRestMessageDo()) {
                        MqMessageInfo msgInfo = MqMessageInfoConverter.convertMqMessage(messageDo);
                        messageInfoList.add(msgInfo);
                    }
                } else {
                    selectMqResponse.setMessage(messageKey + ": Response.Body.Data.MessageDoList.Empty");
                }
            } else {
                selectMqResponse.setMessage(messageKey + ": Response.Body.Data Null");
            }
            selectMqResponse.setMessageInfoList(messageInfoList);
        }
        catch (TeaException ex) {
            selectMqResponse.setExist(false);
            selectMqResponse.setMessage(ex.getMessage());
        }
        catch (Exception ex) {
            log.error("selectRocketMqByMessageKey.Error", (Throwable)ex);
            selectMqResponse.setMessage(ex.getMessage());
        }
        return selectMqResponse;
    }

    @Override
    public MqTraceResponse selectRocketMqTrace(String traceQueryId) throws Exception {
        Client onsClient = this.mqClientBuilder.buildOnsClient();
        OnsTraceGetResultRequest getResultRequest = new OnsTraceGetResultRequest();
        getResultRequest.setQueryId(traceQueryId);
        OnsTraceGetResultResponse getResultResponse = onsClient.onsTraceGetResult(getResultRequest);
        return MqTraceConverter.convertMqConsumeTraceInfo(getResultResponse);
    }

    @Override
    public MqTraceResponse selectRocketMqTrace(String mqInstanceId, String topic, String messageId, Date beginTime, Date endTime) throws Exception {
        Client onsClient = this.mqClientBuilder.buildOnsClient();
        MqTraceResponse mqConsumeTraceResponse = new MqTraceResponse();
        OnsTraceQueryByMsgIdRequest traceRequest = new OnsTraceQueryByMsgIdRequest();
        traceRequest.setInstanceId(mqInstanceId);
        traceRequest.setTopic(topic);
        traceRequest.setMsgId(messageId);
        traceRequest.setBeginTime(Long.valueOf(beginTime.getTime()));
        traceRequest.setEndTime(Long.valueOf(endTime.getTime()));
        try {
            OnsTraceQueryByMsgIdResponse response = onsClient.onsTraceQueryByMsgId(traceRequest);
            if (log.isDebugEnabled()) {
                log.debug("selectRocketMqTrace.MqInstanceId={};Topic={};MessageId={};BeginTime={};EndTime={};TraceQueryByMsgIdResponse={}", new Object[]{mqInstanceId, topic, messageId, FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(beginTime), FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(endTime), JSON.toJSONString((Object)response)});
            }
            String traceQueryId = response.getBody().getQueryId();
            boolean getSuccess = false;
            for (int queryTimes = 0; queryTimes < 5; ++queryTimes) {
                OnsTraceGetResultRequest getResultRequest = new OnsTraceGetResultRequest();
                getResultRequest.setQueryId(traceQueryId);
                OnsTraceGetResultResponse getResultResponse = onsClient.onsTraceGetResult(getResultRequest);
                if (log.isDebugEnabled()) {
                    log.debug("selectRocketMqTrace.MqInstanceId={};Topic={};MessageId={};BeginTime={};EndTime={};TraceGetResultResponse={}", new Object[]{mqInstanceId, topic, messageId, FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(beginTime), FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(endTime), JSON.toJSONString((Object)getResultResponse)});
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)getResultResponse.getBody().getTraceData().status, (CharSequence)"working")) {
                    Thread.sleep(10L);
                    continue;
                }
                getSuccess = true;
                mqConsumeTraceResponse = MqTraceConverter.convertMqConsumeTraceInfo(getResultResponse);
                break;
            }
            if (getSuccess) {
                mqConsumeTraceResponse.setSuccess(true);
                mqConsumeTraceResponse.setMessage("\u83b7\u53d6MQ\u6d88\u8d39\u8f68\u8ff9\u6210\u529f\uff01");
            } else {
                mqConsumeTraceResponse.setTraceQueryId(traceQueryId);
                mqConsumeTraceResponse.setMessage("\u83b7\u53d6MQ\u6d88\u8d39\u8f68\u8ff9\u83b7\u53d65\u6b21\u4e00\u76f4\u5904\u4e8eWorking\u4e2d\uff0c\u8bf7\u7a0d\u5019\u4f7f\u7528TraceQueryId\u8fdb\u884c\u518d\u6b21\u83b7\u53d6");
            }
            return mqConsumeTraceResponse;
        }
        catch (Exception ex) {
            log.error("selectRocketMqTrace.Error", (Throwable)ex);
            String errorMsg = String.format("\u83b7\u53d6MQ\u6d88\u8d39\u8f68\u8ff9\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0=%s", ex.getMessage());
            mqConsumeTraceResponse.setMessage(errorMsg);
            return mqConsumeTraceResponse;
        }
    }

    @Override
    public SelectDeadMqResponse selectRocketMqDeadMq(String mqInstanceId, String topic, String mqGroupId, Date beginDate, Date endDate) throws Exception {
        Client onsClient = this.mqClientBuilder.buildOnsClient();
        SelectDeadMqResponse selectDeadMqResponse = new SelectDeadMqResponse();
        ArrayList<DeadMqMessage> deadMqMessageList = new ArrayList<DeadMqMessage>();
        int currentPage = 1;
        int defaultPageSize = 50;
        Long totalPageNumber = 1L;
        OnsDLQMessagePageQueryByGroupIdRequest dlqRequest = new OnsDLQMessagePageQueryByGroupIdRequest();
        dlqRequest.setBeginTime(Long.valueOf(beginDate.getTime()));
        dlqRequest.setEndTime(Long.valueOf(endDate.getTime()));
        dlqRequest.setInstanceId(mqInstanceId);
        dlqRequest.setCurrentPage(Integer.valueOf(currentPage));
        dlqRequest.setPageSize(Integer.valueOf(defaultPageSize));
        dlqRequest.setGroupId(mqGroupId);
        selectDeadMqResponse.setSuccess(false);
        try {
            OnsDLQMessagePageQueryByGroupIdResponse dlqResponse = onsClient.onsDLQMessagePageQueryByGroupId(dlqRequest);
            if (log.isDebugEnabled()) {
                log.debug("selectRocketMqDeadMq.InstanceId={};GroupId={};CurrentPage={};Response={}", new Object[]{mqInstanceId, mqGroupId, currentPage, JSON.toJSONString((Object)dlqResponse)});
            }
            if (dlqResponse != null && dlqResponse.getBody() != null && dlqResponse.getBody().getMsgFoundDo() != null) {
                for (OnsDLQMessagePageQueryByGroupIdResponseBody.OnsDLQMessagePageQueryByGroupIdResponseBodyMsgFoundDoMsgFoundListOnsRestMessageDo messageDo : dlqResponse.getBody().getMsgFoundDo().getMsgFoundList().getOnsRestMessageDo()) {
                    DeadMqMessage deadMqMessage = DeadMqMessageConverter.convertDeadMqMessage(messageDo);
                    deadMqMessageList.add(deadMqMessage);
                }
                if (dlqResponse.getBody().getMsgFoundDo().getMaxPageCount() != null) {
                    totalPageNumber = dlqResponse.getBody().getMsgFoundDo().getMaxPageCount();
                    selectDeadMqResponse.setTotalMqPageNumber(totalPageNumber);
                }
                while ((long)currentPage < totalPageNumber) {
                    String taskId = dlqResponse.getBody().getMsgFoundDo().getTaskId();
                    ++currentPage;
                    dlqRequest = new OnsDLQMessagePageQueryByGroupIdRequest();
                    dlqRequest.setBeginTime(Long.valueOf(beginDate.getTime()));
                    dlqRequest.setEndTime(Long.valueOf(endDate.getTime()));
                    dlqRequest.setInstanceId(mqInstanceId);
                    dlqRequest.setCurrentPage(Integer.valueOf(currentPage));
                    dlqRequest.setPageSize(Integer.valueOf(defaultPageSize));
                    dlqRequest.setGroupId(mqGroupId);
                    dlqRequest.setTaskId(taskId);
                    dlqResponse = onsClient.onsDLQMessagePageQueryByGroupId(dlqRequest);
                    if (log.isDebugEnabled()) {
                        log.debug("selectRocketMqDeadMq.InstanceId={};GroupId={};CurrentPage={};Response={}", new Object[]{mqInstanceId, mqGroupId, currentPage, JSON.toJSONString((Object)dlqResponse)});
                    }
                    if (dlqResponse == null || dlqResponse.getBody() == null || dlqResponse.getBody().getMsgFoundDo() == null) break;
                    for (OnsDLQMessagePageQueryByGroupIdResponseBody.OnsDLQMessagePageQueryByGroupIdResponseBodyMsgFoundDoMsgFoundListOnsRestMessageDo messageDo : dlqResponse.getBody().getMsgFoundDo().getMsgFoundList().getOnsRestMessageDo()) {
                        DeadMqMessage deadMqMessage = DeadMqMessageConverter.convertDeadMqMessage(messageDo);
                        deadMqMessageList.add(deadMqMessage);
                    }
                }
            }
            selectDeadMqResponse.setSuccess(true);
            selectDeadMqResponse.setMessage("\u83b7\u53d6Mq\u6b7b\u4fe1\u961f\u5217\u6210\u529f\uff01");
        }
        catch (Exception ex) {
            log.error("selectRocketMqDeadMq.Error", (Throwable)ex);
            String errorMsg = String.format("\u83b7\u53d6MQ\u6d88\u8d39\u8f68\u8ff9\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0=%s", ex.getMessage());
            selectDeadMqResponse.setMessage(errorMsg);
        }
        selectDeadMqResponse.setDeadMqList(deadMqMessageList);
        return selectDeadMqResponse;
    }

    @Override
    public ResendMqResponse resendDeadMq(String mqInstanceId, String topic, String mqGroupId, String msgId) throws Exception {
        Client onsClient = this.mqClientBuilder.buildOnsClient();
        ResendMqResponse response = new ResendMqResponse();
        OnsDLQMessageResendByIdRequest resendByIdRequest = new OnsDLQMessageResendByIdRequest();
        resendByIdRequest.setGroupId(mqGroupId);
        resendByIdRequest.setInstanceId(mqInstanceId);
        resendByIdRequest.setMsgId(msgId);
        try {
            OnsDLQMessageResendByIdResponse resendResponse = onsClient.onsDLQMessageResendById(resendByIdRequest);
            if (log.isDebugEnabled()) {
                log.debug("resendDeadMq.InstanceId={};GroupId={};MessageId={}.Response={}", new Object[]{mqInstanceId, mqGroupId, msgId, JSON.toJSONString((Object)resendResponse)});
            }
            response.setSuccess(true);
            response.setMessage("\u91cd\u53d1\u6b7b\u4fe1MQ\u6210\u529f\uff01");
        }
        catch (Exception ex) {
            log.error("selectRocketMqDeadMq.Error", (Throwable)ex);
            String errorMsg = String.format("\u83b7\u53d6MQ\u6d88\u8d39\u8f68\u8ff9\u5931\u8d25\uff0c\u5f02\u5e38\u539f\u56e0=%s", ex.getMessage());
            response.setMessage(errorMsg);
        }
        System.out.println(JSON.toJSONString((Object)response));
        return response;
    }

    @Override
    public MqGroupOnlineResponse getMqGroupOnlineInfo(String mqInstanceId, String mqGroupId) throws Exception {
        Client clientV4 = this.mqClientBuilder.buildOnsClient();
        OnsGroupSubDetailRequest onsGroupSubDetailRequest = new OnsGroupSubDetailRequest();
        try {
            onsGroupSubDetailRequest = onsGroupSubDetailRequest.setGroupId(mqGroupId);
            onsGroupSubDetailRequest = onsGroupSubDetailRequest.setInstanceId(mqInstanceId);
            RuntimeOptions runtime = new RuntimeOptions();
            OnsGroupSubDetailResponse detailResponse = clientV4.onsGroupSubDetailWithOptions(onsGroupSubDetailRequest, runtime);
            if (detailResponse.getBody() != null && detailResponse.getBody().getData() != null) {
                OnsGroupSubDetailResponseBody.OnsGroupSubDetailResponseBodyData bodyData = detailResponse.getBody().getData();
                MqGroupOnlineResponse onlineResponse = new MqGroupOnlineResponse();
                onlineResponse.setOnline(bodyData.getOnline());
                onlineResponse.setGroupId(bodyData.getGroupId());
                if (CollectionUtils.isNotEmpty((Collection)bodyData.getSubscriptionDataList().getSubscriptionDataList())) {
                    ArrayList<String> onlineIpList = new ArrayList<String>();
                    for (OnsGroupSubDetailResponseBody.OnsGroupSubDetailResponseBodyDataSubscriptionDataListSubscriptionDataList dataList : bodyData.getSubscriptionDataList().getSubscriptionDataList()) {
                        onlineIpList.add(dataList.getSubString());
                    }
                    onlineResponse.setOnlineIpList(onlineIpList);
                }
                return onlineResponse;
            }
            return null;
        }
        catch (Exception ex) {
            log.error("getMqGroupOnlineInfo.error", (Throwable)ex);
            return null;
        }
    }

    public AliyunRocketMqServiceImpl(AliyunRockMqClientBuilder mqClientBuilder) {
        this.mqClientBuilder = mqClientBuilder;
    }
}

