/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.mq.impl.tencent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tencentcloudapi.tdmq.v20200217.models.ConsumerStats;
import com.tencentcloudapi.tdmq.v20200217.models.DescribeRocketMQConsumeStatsRequest;
import com.tencentcloudapi.tdmq.v20200217.models.DescribeRocketMQConsumeStatsResponse;
import com.tencentcloudapi.tdmq.v20200217.models.DescribeRocketMQMsgRequest;
import com.tencentcloudapi.tdmq.v20200217.models.DescribeRocketMQMsgResponse;
import com.tencentcloudapi.tdmq.v20200217.models.DescribeRocketMQMsgTraceRequest;
import com.tencentcloudapi.tdmq.v20200217.models.DescribeRocketMQMsgTraceResponse;
import com.tencentcloudapi.tdmq.v20200217.models.DescribeRocketMQTopicMsgsRequest;
import com.tencentcloudapi.tdmq.v20200217.models.DescribeRocketMQTopicMsgsResponse;
import com.tencentcloudapi.tdmq.v20200217.models.RocketMQMsgLog;
import com.tencentcloudapi.tdmq.v20200217.models.SendRocketMQMessageRequest;
import com.tencentcloudapi.tdmq.v20200217.models.SendRocketMQMessageResponse;
import com.tencentcloudapi.tdmq.v20200217.models.TraceResult;
import com.xinqiyi.framework.mq.IXinQiYiRocketMqService;
import com.xinqiyi.framework.mq.XinQiYiRocketMqType;
import com.xinqiyi.framework.mq.impl.tencent.TencentRocketMqClientBuilder;
import com.xinqiyi.framework.mq.impl.tencent.config.TencentRocketMqSdkConfig;
import com.xinqiyi.framework.mq.response.DeadMqMessage;
import com.xinqiyi.framework.mq.response.MqConsumeStatus;
import com.xinqiyi.framework.mq.response.MqConsumeTraceInfo;
import com.xinqiyi.framework.mq.response.MqGroupOnlineResponse;
import com.xinqiyi.framework.mq.response.MqMessageInfo;
import com.xinqiyi.framework.mq.response.MqProduceStatus;
import com.xinqiyi.framework.mq.response.MqProduceTraceInfo;
import com.xinqiyi.framework.mq.response.MqTraceResponse;
import com.xinqiyi.framework.mq.response.ResendMqResponse;
import com.xinqiyi.framework.mq.response.SelectDeadMqResponse;
import com.xinqiyi.framework.mq.response.SelectMqResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@XinQiYiRocketMqType(code="tencent", desc="\u817e\u8baf\u4e91RocketMQ")
public class TencentRocketMqServiceImpl
implements IXinQiYiRocketMqService {
    private static final Logger log = LoggerFactory.getLogger(TencentRocketMqServiceImpl.class);
    private final TencentRocketMqSdkConfig rocketMqSdkConfig;
    private final TencentRocketMqClientBuilder mqClientBuilder;

    @Override
    public SelectMqResponse selectRocketMqByMessageId(String mqInstanceId, String topic, String messageId) throws Exception {
        SelectMqResponse selectMqResponse = new SelectMqResponse();
        selectMqResponse.setExist(false);
        try {
            DescribeRocketMQMsgRequest req = new DescribeRocketMQMsgRequest();
            req.setClusterId(mqInstanceId);
            req.setEnvironmentId(this.rocketMqSdkConfig.getEnvironmentId());
            req.setTopicName(topic);
            req.setMsgId(messageId);
            req.setPulsarMsgId(messageId);
            DescribeRocketMQMsgResponse resp = this.mqClientBuilder.buildRocketMqClient().DescribeRocketMQMsg(req);
            JSONObject mqProperties = JSONObject.parseObject((String)resp.getProperties());
            MqMessageInfo messageInfo = new MqMessageInfo();
            messageInfo.setMessageId(mqProperties.getString("UNIQ_KEY"));
            messageInfo.setMessageKey(mqProperties.getString("KEYS"));
            messageInfo.setTopic(resp.getShowTopicName());
            messageInfo.setMessageTag(mqProperties.getString("TAGS"));
            messageInfo.setBornHostInfo(resp.getProducerAddr());
            messageInfo.setMessageBody(resp.getBody());
            Date bornDateTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss,SSS").parse(resp.getProduceTime());
            messageInfo.setBornDateTime(bornDateTime);
            selectMqResponse.setExist(true);
            selectMqResponse.setMessageInfoList(Collections.singletonList(messageInfo));
        }
        catch (Exception ex) {
            log.error("selectRocketMqByMessageId.Exception", (Throwable)ex);
            selectMqResponse.setExist(false);
            selectMqResponse.setMessage(ex.getMessage());
        }
        return selectMqResponse;
    }

    @Override
    public SelectMqResponse selectRocketMqByMessageKey(String mqInstanceId, String topic, String messageKey) throws Exception {
        SelectMqResponse selectMqResponse = new SelectMqResponse();
        selectMqResponse.setExist(false);
        try {
            DescribeRocketMQTopicMsgsRequest req = new DescribeRocketMQTopicMsgsRequest();
            req.setClusterId(mqInstanceId);
            req.setEnvironmentId(this.rocketMqSdkConfig.getEnvironmentId());
            req.setTopicName(topic);
            req.setMsgKey(messageKey);
            String endTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(new Date());
            String startTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(DateUtils.addDays((Date)new Date(), (int)-4));
            req.setStartTime(startTime);
            req.setEndTime(endTime);
            DescribeRocketMQTopicMsgsResponse resp = this.mqClientBuilder.buildRocketMqClient().DescribeRocketMQTopicMsgs(req);
            if (ArrayUtils.isNotEmpty((Object[])resp.getTopicMsgLogSets())) {
                ArrayList<MqMessageInfo> mqMessageInfoList = new ArrayList<MqMessageInfo>();
                for (RocketMQMsgLog mqMsgLog : resp.getTopicMsgLogSets()) {
                    MqMessageInfo messageInfo = new MqMessageInfo();
                    messageInfo.setMessageId(mqMsgLog.getMsgId());
                    messageInfo.setMessageKey(mqMsgLog.getMsgKey());
                    messageInfo.setTopic(topic);
                    messageInfo.setMessageTag(mqMsgLog.getMsgTag());
                    messageInfo.setBornHostInfo(mqMsgLog.getProducerAddr());
                    Date bornDateTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss,SSS").parse(mqMsgLog.getProduceTime());
                    messageInfo.setBornDateTime(bornDateTime);
                    mqMessageInfoList.add(messageInfo);
                }
                selectMqResponse.setExist(true);
                selectMqResponse.setMessageInfoList(mqMessageInfoList);
            } else {
                selectMqResponse.setMessage("\u67e5\u8be2\u7ed3\u679c\u503c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception ex) {
            log.error("selectRocketMqByMessageKey.Exception", (Throwable)ex);
            selectMqResponse.setExist(false);
            selectMqResponse.setMessage(ex.getMessage());
        }
        return selectMqResponse;
    }

    @Override
    public MqTraceResponse selectRocketMqTrace(String traceQueryId) throws Exception {
        throw new RuntimeException("\u817e\u8baf\u4e91\u672a\u652f\u6301\u8be5\u65b9\u6cd5\uff0c\u672a\u5b9e\u73b0\uff01");
    }

    @Override
    public MqTraceResponse selectRocketMqTrace(String mqInstanceId, String topic, String messageId, Date beginTime, Date endTime) throws Exception {
        MqTraceResponse mqTraceResponse = new MqTraceResponse();
        try {
            DescribeRocketMQMsgTraceRequest req = new DescribeRocketMQMsgTraceRequest();
            req.setClusterId(mqInstanceId);
            req.setEnvironmentId(this.rocketMqSdkConfig.getEnvironmentId());
            req.setTopicName(topic);
            req.setMsgId(messageId);
            DescribeRocketMQMsgTraceResponse resp = this.mqClientBuilder.buildRocketMqClient().DescribeRocketMQMsgTrace(req);
            if (ArrayUtils.isNotEmpty((Object[])resp.getResult())) {
                mqTraceResponse.setSuccess(true);
                mqTraceResponse.setMqTopic(resp.getShowTopicName());
                mqTraceResponse.setMessage("\u67e5\u8be2\u6d88\u606f\u6d88\u8d39\u8f68\u8ff9\u6210\u529f\uff01");
                for (TraceResult traceResult : resp.getResult()) {
                    JSONObject consumeJson;
                    JSONArray consumeLogs;
                    if (StringUtils.equalsIgnoreCase((CharSequence)"produce", (CharSequence)traceResult.getStage())) {
                        JSONObject produceJson = JSONObject.parseObject((String)traceResult.getData());
                        MqProduceTraceInfo produceTraceInfo = new MqProduceTraceInfo();
                        produceTraceInfo.setBornHostInfo(produceJson.getString("ProducerAddr"));
                        Date bornDateTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss,SSS").parse(produceJson.getString("ProduceTime"));
                        produceTraceInfo.setProduceDateTime(bornDateTime);
                        Long duration = produceJson.getLong("Duration");
                        produceTraceInfo.setCostTime(duration == null ? -999L : duration);
                        Integer status = produceJson.getInteger("Status");
                        MqProduceStatus produceStatus = status == 0 ? MqProduceStatus.SEND_SUCCESS : MqProduceStatus.SEND_FAILED;
                        produceTraceInfo.setProduceStatus(produceStatus);
                        mqTraceResponse.setProduceTraceInfo(produceTraceInfo);
                        continue;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"consume", (CharSequence)traceResult.getStage()) || (consumeLogs = (consumeJson = JSONObject.parseObject((String)traceResult.getData())).getJSONArray("RocketMqConsumeLogs")) == null || consumeLogs.isEmpty()) continue;
                    ArrayList<MqConsumeTraceInfo> consumeTraceList = new ArrayList<MqConsumeTraceInfo>();
                    for (int itemIndex = 0; itemIndex < consumeLogs.size(); ++itemIndex) {
                        JSONObject consumeLogJson = consumeLogs.getJSONObject(itemIndex);
                        MqConsumeTraceInfo consumeTraceInfo = new MqConsumeTraceInfo();
                        consumeTraceInfo.setConsumeClientIp(consumeLogJson.getString("ConsumerAddr"));
                        consumeTraceInfo.setIndex(itemIndex);
                        consumeTraceInfo.setCostTime(1L);
                        Integer status = consumeLogJson.getInteger("Status");
                        MqConsumeStatus consumeStatus = MqConsumeStatus.CONSUME_NOT_RETURN;
                        if (status == 2) {
                            consumeStatus = MqConsumeStatus.CONSUME_SUCCESS;
                        } else if (status == 3) {
                            consumeStatus = MqConsumeStatus.CONSUME_FAILED;
                        } else if (status == 5) {
                            consumeStatus = MqConsumeStatus.MQ_DEAD;
                        }
                        consumeTraceInfo.setConsumeStatus(consumeStatus);
                        Date pushTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss,SSS").parse(consumeLogJson.getString("PushTime"));
                        consumeTraceInfo.setConsumeDateTime(pushTime);
                        consumeTraceList.add(consumeTraceInfo);
                    }
                    mqTraceResponse.setConsumeTraceList(consumeTraceList);
                }
            } else {
                mqTraceResponse.setSuccess(false);
                mqTraceResponse.setMessage("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6d88\u8d39\u8f68\u8ff9\u4fe1\u606f\uff01");
            }
        }
        catch (Exception ex) {
            log.error("selectRocketMqTrace.Exception", (Throwable)ex);
            mqTraceResponse.setSuccess(false);
            mqTraceResponse.setMessage(ex.getMessage());
        }
        return mqTraceResponse;
    }

    @Override
    public SelectDeadMqResponse selectRocketMqDeadMq(String mqInstanceId, String topic, String mqGroupId, Date beginDate, Date endDate) throws Exception {
        SelectDeadMqResponse selectDeadMqResponse = new SelectDeadMqResponse();
        try {
            DescribeRocketMQTopicMsgsRequest req = new DescribeRocketMQTopicMsgsRequest();
            req.setClusterId(mqInstanceId);
            req.setEnvironmentId(this.rocketMqSdkConfig.getEnvironmentId());
            req.setTopicName(topic);
            req.setQueryDeadLetterMessage(Boolean.valueOf(true));
            req.setLimit(Long.valueOf(100L));
            String endTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(endDate);
            String startTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(beginDate);
            req.setStartTime(startTime);
            req.setEndTime(endTime);
            DescribeRocketMQTopicMsgsResponse resp = this.mqClientBuilder.buildRocketMqClient().DescribeRocketMQTopicMsgs(req);
            if (ArrayUtils.isNotEmpty((Object[])resp.getTopicMsgLogSets())) {
                ArrayList<DeadMqMessage> mqMessageInfoList = new ArrayList<DeadMqMessage>();
                for (RocketMQMsgLog mqMsgLog : resp.getTopicMsgLogSets()) {
                    DeadMqMessage deadMsgInfo = new DeadMqMessage();
                    deadMsgInfo.setMessageId(mqMsgLog.getMsgId());
                    deadMsgInfo.setMessageKey(mqMsgLog.getMsgKey());
                    deadMsgInfo.setTopic(topic);
                    deadMsgInfo.setMessageTag(mqMsgLog.getMsgTag());
                    deadMsgInfo.setBornHostInfo(mqMsgLog.getProducerAddr());
                    Date bornDateTime = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss,SSS").parse(mqMsgLog.getProduceTime());
                    deadMsgInfo.setBornDateTime(bornDateTime);
                    mqMessageInfoList.add(deadMsgInfo);
                }
                selectDeadMqResponse.setTotalMqPageNumber(resp.getTotalCount());
                selectDeadMqResponse.setDeadMqList(mqMessageInfoList);
            } else {
                selectDeadMqResponse.setMessage("\u67e5\u8be2\u7ed3\u679c\u503c\u4e3a\u7a7a\uff01");
            }
            selectDeadMqResponse.setSuccess(true);
        }
        catch (Exception ex) {
            log.error("selectRocketMqDeadMq.Exception", (Throwable)ex);
            selectDeadMqResponse.setSuccess(false);
            selectDeadMqResponse.setMessage(ex.getMessage());
        }
        return selectDeadMqResponse;
    }

    @Override
    public ResendMqResponse resendDeadMq(String mqInstanceId, String topic, String mqGroupId, String msgId) throws Exception {
        ResendMqResponse resendMqResponse = new ResendMqResponse();
        try {
            SelectMqResponse selectMqResponse = this.selectRocketMqByMessageId(mqInstanceId, topic, msgId);
            if (selectMqResponse.isExist()) {
                SendRocketMQMessageRequest req = new SendRocketMQMessageRequest();
                req.setClusterId(mqInstanceId);
                req.setNamespaceId(this.rocketMqSdkConfig.getEnvironmentId());
                MqMessageInfo existMessageInfo = selectMqResponse.getMessageInfoList().get(0);
                req.setMsgBody(existMessageInfo.getMessageBody());
                req.setTopicName(topic);
                req.setMsgKey(existMessageInfo.getMessageKey());
                req.setMsgTag(existMessageInfo.getMessageTag());
                SendRocketMQMessageResponse resp = this.mqClientBuilder.buildRocketMqClient().SendRocketMQMessage(req);
                resendMqResponse.setResendMsgId(resp.getMsgId());
                resendMqResponse.setSuccess(resp.getResult());
            } else {
                resendMqResponse.setSuccess(false);
                resendMqResponse.setMessage("\u91cd\u65b0\u53d1\u9001\u6b7b\u4fe1\u6d88\u606f\u5931\u8d25\uff01");
            }
        }
        catch (Exception ex) {
            log.error("resendDeadMq.Exception", (Throwable)ex);
            resendMqResponse.setSuccess(false);
            resendMqResponse.setMessage(ex.getMessage());
        }
        return resendMqResponse;
    }

    @Override
    public MqGroupOnlineResponse getMqGroupOnlineInfo(String mqInstanceId, String mqGroupId) throws Exception {
        MqGroupOnlineResponse groupOnlineResponse = new MqGroupOnlineResponse();
        try {
            DescribeRocketMQConsumeStatsRequest req = new DescribeRocketMQConsumeStatsRequest();
            req.setClusterId(mqInstanceId);
            req.setNamespaceId(this.rocketMqSdkConfig.getEnvironmentId());
            req.setConsumerGroup(mqGroupId);
            DescribeRocketMQConsumeStatsResponse resp = this.mqClientBuilder.buildRocketMqClient().DescribeRocketMQConsumeStats(req);
            if (ArrayUtils.isEmpty((Object[])resp.getConsumerStatsList())) {
                groupOnlineResponse.setOnline(false);
                groupOnlineResponse.setGroupId(mqGroupId);
            } else {
                groupOnlineResponse.setOnline(true);
                ArrayList<String> consumerIpList = new ArrayList<String>();
                for (ConsumerStats consumerStats : resp.getConsumerStatsList()) {
                    if (consumerIpList.contains(consumerStats.getConsumerClientId())) continue;
                    consumerIpList.add(consumerStats.getConsumerClientId());
                }
                groupOnlineResponse.setOnlineIpList(consumerIpList);
            }
        }
        catch (Exception ex) {
            log.error("getMqGroupOnlineInfo.Exception", (Throwable)ex);
            groupOnlineResponse.setOnline(false);
            groupOnlineResponse.setGroupId(mqGroupId);
        }
        return groupOnlineResponse;
    }

    public TencentRocketMqServiceImpl(TencentRocketMqSdkConfig rocketMqSdkConfig, TencentRocketMqClientBuilder mqClientBuilder) {
        this.rocketMqSdkConfig = rocketMqSdkConfig;
        this.mqClientBuilder = mqClientBuilder;
    }
}

