/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.framework.mq.response;

import com.aliyun.ons20190214.models.OnsMessageGetByKeyResponseBody;
import com.aliyun.ons20190214.models.OnsMessageGetByMsgIdResponseBody;
import com.xinqiyi.framework.mq.response.MqMessageInfo;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MqMessageInfoConverter {
    private static String parseMqMessageProperty(OnsMessageGetByKeyResponseBody.OnsMessageGetByKeyResponseBodyDataOnsRestMessageDoPropertyList propertyList, String propertyName) {
        if (CollectionUtils.isEmpty((Collection)propertyList.getMessageProperty())) {
            return "";
        }
        OnsMessageGetByKeyResponseBody.OnsMessageGetByKeyResponseBodyDataOnsRestMessageDoPropertyListMessageProperty findProperty = propertyList.getMessageProperty().stream().filter(x -> StringUtils.equalsIgnoreCase((CharSequence)x.getName(), (CharSequence)propertyName)).findFirst().orElse(null);
        if (findProperty != null) {
            return findProperty.getValue();
        }
        return "";
    }

    private static String parseMqMessageProperty(OnsMessageGetByMsgIdResponseBody.OnsMessageGetByMsgIdResponseBodyDataPropertyList propertyList, String propertyName) {
        if (CollectionUtils.isEmpty((Collection)propertyList.getMessageProperty())) {
            return "";
        }
        OnsMessageGetByMsgIdResponseBody.OnsMessageGetByMsgIdResponseBodyDataPropertyListMessageProperty findProperty = propertyList.getMessageProperty().stream().filter(x -> StringUtils.equalsIgnoreCase((CharSequence)x.getName(), (CharSequence)propertyName)).findFirst().orElse(null);
        if (findProperty != null) {
            return findProperty.getValue();
        }
        return "";
    }

    public static MqMessageInfo convertMqMessage(OnsMessageGetByKeyResponseBody.OnsMessageGetByKeyResponseBodyDataOnsRestMessageDo messageDo) {
        MqMessageInfo mqMessage = new MqMessageInfo();
        mqMessage.setMessageId(messageDo.getMsgId());
        String messageKey = MqMessageInfoConverter.parseMqMessageProperty(messageDo.getPropertyList(), "KEYS");
        mqMessage.setMessageKey(messageKey);
        mqMessage.setBornDateTime(new Date(messageDo.getBornTimestamp()));
        mqMessage.setBornHostInfo(messageDo.getBornHost());
        mqMessage.setTopic(messageDo.getTopic());
        String shardingKey = MqMessageInfoConverter.parseMqMessageProperty(messageDo.getPropertyList(), "__SHARDINGKEY");
        mqMessage.setShardingKey(shardingKey);
        String consumeStartTime = MqMessageInfoConverter.parseMqMessageProperty(messageDo.getPropertyList(), "CONSUME_START_TIME");
        mqMessage.setConsumeStartTime(new Date(Long.parseLong(consumeStartTime)));
        String messageTag = MqMessageInfoConverter.parseMqMessageProperty(messageDo.getPropertyList(), "TAGS");
        mqMessage.setMessageTag(messageTag);
        String consumeTimes = MqMessageInfoConverter.parseMqMessageProperty(messageDo.getPropertyList(), "RECONSUME_TIME");
        if (StringUtils.isNotEmpty((CharSequence)consumeTimes)) {
            mqMessage.setReconsumeTimes(Integer.parseInt(consumeTimes));
        }
        return mqMessage;
    }

    public static MqMessageInfo convertMqMessage(OnsMessageGetByMsgIdResponseBody.OnsMessageGetByMsgIdResponseBodyData responseBodyData) {
        MqMessageInfo mqMessage = new MqMessageInfo();
        mqMessage.setMessageId(responseBodyData.getMsgId());
        String messageKey = MqMessageInfoConverter.parseMqMessageProperty(responseBodyData.getPropertyList(), "KEYS");
        mqMessage.setMessageKey(messageKey);
        mqMessage.setBornDateTime(new Date(responseBodyData.getBornTimestamp()));
        mqMessage.setBornHostInfo(responseBodyData.getBornHost());
        mqMessage.setTopic(responseBodyData.getTopic());
        String shardingKey = MqMessageInfoConverter.parseMqMessageProperty(responseBodyData.getPropertyList(), "__SHARDINGKEY");
        mqMessage.setShardingKey(shardingKey);
        String consumeStartTime = MqMessageInfoConverter.parseMqMessageProperty(responseBodyData.getPropertyList(), "CONSUME_START_TIME");
        mqMessage.setConsumeStartTime(new Date(Long.parseLong(consumeStartTime)));
        String messageTag = MqMessageInfoConverter.parseMqMessageProperty(responseBodyData.getPropertyList(), "TAGS");
        mqMessage.setMessageTag(messageTag);
        String consumeTimes = MqMessageInfoConverter.parseMqMessageProperty(responseBodyData.getPropertyList(), "RECONSUME_TIME");
        if (StringUtils.isNotEmpty((CharSequence)consumeTimes)) {
            mqMessage.setReconsumeTimes(Integer.parseInt(consumeTimes));
        }
        return mqMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqMessageInfoConverter)) {
            return false;
        }
        MqMessageInfoConverter other = (MqMessageInfoConverter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqMessageInfoConverter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "MqMessageInfoConverter()";
    }
}

