/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xinqiyi.dynamicform.dao.repository.DictRedisRepository;
import com.xinqiyi.dynamicform.dao.repository.SynTableRedisRepository;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.mdm.api.CauseDeptApi;
import com.xinqiyi.mdm.api.CompanyApi;
import com.xinqiyi.mdm.api.DistrictCountriesApi;
import com.xinqiyi.mdm.api.LogisticsCompanyApi;
import com.xinqiyi.mdm.api.MdmPlatformApi;
import com.xinqiyi.mdm.api.ProductGroupApi;
import com.xinqiyi.mdm.api.SalesmanApi;
import com.xinqiyi.mdm.api.SalesmanBrandApi;
import com.xinqiyi.mdm.api.ShopRenovationApi;
import com.xinqiyi.mdm.api.SystemConfigApi;
import com.xinqiyi.mdm.api.UserApi;
import com.xinqiyi.mdm.api.model.vo.causedept.CauseDeptVO;
import com.xinqiyi.mdm.api.model.vo.districtcountries.DistrictCountriesVO;
import com.xinqiyi.mdm.api.model.vo.logisticscompany.LogisticsCompanyPlatformVO;
import com.xinqiyi.mdm.api.model.vo.platform.MdmPlatformVO;
import com.xinqiyi.mdm.api.model.vo.renovation.MdmProductGroupVO;
import com.xinqiyi.mdm.api.model.vo.renovation.ShopRenovationVO;
import com.xinqiyi.mdm.api.model.vo.salesman.SalesmanVO;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.mdm.api.model.vo.user.UserVO;
import com.xinqiyi.mdm.model.dto.MdmPlatformBatchQueryDTO;
import com.xinqiyi.mdm.model.dto.causedept.CauseDeptStatusDTO;
import com.xinqiyi.mdm.model.dto.districtcountries.DistrictCountriesDTO;
import com.xinqiyi.mdm.model.dto.logisticscompany.LogisticsQueryDTO;
import com.xinqiyi.mdm.model.dto.renovation.QueryShopRenovationDTO;
import com.xinqiyi.mdm.model.dto.salesman.BrandDTO;
import com.xinqiyi.mdm.model.dto.salesman.SalesmanBrandSaveDTO;
import com.xinqiyi.mdm.model.dto.salesman.SalesmanDTO;
import com.xinqiyi.mdm.model.dto.salesman.SalesmanQueryDTO;
import com.xinqiyi.mdm.model.dto.systemconfig.SystemConfigDTO;
import com.xinqiyi.mdm.model.dto.user.UserDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.HttpRequestUtil;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MdmAdapter {
    private static final Logger log = LoggerFactory.getLogger(MdmAdapter.class);
    private final HttpRequestUtil httpRequestUtil;
    @Autowired
    private DistrictCountriesApi districtCountriesApi;
    @Autowired
    private SalesmanBrandApi salesmanBrandApi;
    @Autowired
    private SystemConfigApi systemConfigApi;
    @Autowired
    private SalesmanApi salesmanApi;
    @Autowired
    private CauseDeptApi causeDeptApi;
    @Resource
    private ShopRenovationApi shopRenovationApi;
    @Resource
    private CompanyApi companyApi;
    @Resource
    private ProductGroupApi productGroupApi;
    @Resource
    private LogisticsCompanyApi logisticsCompanyApi;
    @Resource
    private UserApi userApi;
    @Autowired
    private SynTableRedisRepository synTableRedisRepository;
    @Autowired
    private MdmPlatformApi mdmPlatformApi;
    @Autowired
    private DictRedisRepository dictRedisRepository;

    public MdmAdapter(HttpRequestUtil httpRequestUtil) {
        this.httpRequestUtil = httpRequestUtil;
    }

    public UserVO queryUserByUserId(Long userId) {
        UserDTO userDTO = new UserDTO();
        userDTO.setId(userId);
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)userDTO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u57fa\u7840\u670d\u52a1\uff0c\u67e5\u8be2\u5458\u5de5\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)userDTO));
        }
        ApiResponse apiResponse = this.userApi.queryDetail(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u53c2\u6570\u8fd4\u56de,{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        return (UserVO)apiResponse.getContent();
    }

    public String selectDistrictCountries(Long countriesId) {
        log.info("\u8c03\u7528\u670d\u52a1\u83b7\u53d6\u56fd\u7c4d\u540d\u79f0countriesId={}", (Object)countriesId);
        ApiRequest districtCountriesDTOApiRequest = new ApiRequest();
        DistrictCountriesDTO dto = new DistrictCountriesDTO();
        dto.setId(countriesId);
        districtCountriesDTOApiRequest.setJsonData((Object)dto);
        ApiResponse districtCountriesVOApiResponse = this.districtCountriesApi.queryDistrictCountriesById(districtCountriesDTOApiRequest);
        Assert.isTrue((boolean)districtCountriesVOApiResponse.isSuccess(), (String)districtCountriesVOApiResponse.getDesc());
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)districtCountriesVOApiResponse.getContent()), (String)"\u83b7\u53d6\u56fd\u7c4d\u540d\u79f0\u5931\u8d25,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        return ((DistrictCountriesVO)districtCountriesVOApiResponse.getContent()).getCname();
    }

    public List<DistrictCountriesVO> selectDistrictCountries(List<Long> countriesIds) {
        log.info("\u8c03\u7528\u670d\u52a1\u6279\u91cf\u83b7\u53d6\u56fd\u7c4d\u540d\u79f0countriesIds={}", countriesIds);
        ApiRequest districtCountriesDTOApiRequest = new ApiRequest();
        DistrictCountriesDTO dto = new DistrictCountriesDTO();
        dto.setIds(countriesIds);
        districtCountriesDTOApiRequest.setJsonData((Object)dto);
        ApiResponse districtCountriesVOApiResponse = this.districtCountriesApi.queryDistrictCountriesByIds(districtCountriesDTOApiRequest);
        Assert.isTrue((boolean)districtCountriesVOApiResponse.isSuccess(), (String)districtCountriesVOApiResponse.getDesc());
        Assert.notEmpty((Collection)((Collection)districtCountriesVOApiResponse.getContent()), (String)"\u83b7\u53d6\u56fd\u7c4d\u6570\u636e\u5931\u8d25,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        return (List)districtCountriesVOApiResponse.getContent();
    }

    public SystemConfigVO queryBySystemConfigKeyCode(String keyCode) {
        SystemConfigDTO systemConfigDTO = new SystemConfigDTO();
        systemConfigDTO.setKeyCode(keyCode);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u57fa\u7840\u670d\u52a1\uff0c\u67e5\u8be2\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u4e3a{}", (Object)keyCode);
        }
        ApiResponse apiResponse = this.systemConfigApi.queryBySystemConfigKeyCode(systemConfigDTO);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u8fd4\u56de,{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        return (SystemConfigVO)apiResponse.getContent();
    }

    public void saveFullBrand(List<Brand> salesmanBrandList) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u57fa\u7840\u670d\u52a1\uff0c\u65b0\u589e\u8d1f\u8d23\u5168\u54c1\u724csalesmanBrandList\uff1a{}", salesmanBrandList);
        }
        List<BrandDTO> brandVOS = BeanConvertUtil.convertList(salesmanBrandList, BrandDTO.class);
        SalesmanBrandSaveDTO salesmanBrandSaveDTO = new SalesmanBrandSaveDTO();
        salesmanBrandSaveDTO.setBrands(brandVOS);
        ApiResponse voidApiResponse = this.salesmanBrandApi.saveFullBrand(salesmanBrandSaveDTO);
        if (log.isDebugEnabled()) {
            log.debug("\u65b0\u589e\u8d1f\u8d23\u5168\u54c1\u724c\u53c2\u6570\u8fd4\u56de,{}", (Object)JSON.toJSONString((Object)voidApiResponse));
        }
        Assert.isTrue((boolean)voidApiResponse.isSuccess(), (String)voidApiResponse.getDesc());
    }

    public List<SalesmanVO> queryMarketingList(SalesmanDTO salesmanDTO) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u54c1\u724c\u884c\u9500\u4eba\u5458\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)salesmanDTO));
        }
        salesmanDTO.setIsRepeat(Integer.valueOf(0));
        ApiResponse response = this.salesmanApi.queryByBrandIds(salesmanDTO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u54c1\u724c\u884c\u9500\u4eba\u5458\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u54c1\u724c\u884c\u9500\u4eba\u5458\u5931\u8d25\uff01{}" + response.getDesc()));
        if (ObjectUtil.isNotNull((Object)response.getContent())) {
            return (List)response.getContent();
        }
        throw new IllegalArgumentException("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u54c1\u724c\u884c\u9500\u4eba\u5458\u5931\u8d25");
    }

    public List<SalesmanVO> querySalesmanBatch(List<Long> ids) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u4e1a\u52a1\u5458\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(ids));
        }
        SalesmanDTO salesmanDTO = new SalesmanDTO();
        salesmanDTO.setIds(ids);
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)salesmanDTO);
        ApiResponse response = this.salesmanApi.querySalesmanBatch(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u4e1a\u52a1\u5458\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u54c1\u724c\u4e1a\u52a1\u5458\uff01{}" + response.getDesc()));
        if (ObjectUtil.isNotNull((Object)response.getContent())) {
            return (List)response.getContent();
        }
        throw new IllegalArgumentException("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u54c1\u724c\u4e1a\u52a1\u5458\u5931\u8d25");
    }

    public List<CauseDeptVO> queryDeptAllList(List<Long> deptIds) {
        CauseDeptStatusDTO causeDeptStatusDTO = new CauseDeptStatusDTO();
        causeDeptStatusDTO.setIds(deptIds);
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)causeDeptStatusDTO);
        ApiResponse apiResponse = this.causeDeptApi.queryDeptAllList(apiRequest);
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        return (List)apiResponse.getContent();
    }

    public String selectMdmSystemConfig(String key) {
        if (log.isInfoEnabled()) {
            log.info("\u8c03\u7528\u57fa\u7840\u670d\u52a1,\u67e5\u8be2\u57fa\u7840\u914d\u7f6e\u53c2key,{}", (Object)key);
        }
        String value = this.synTableRedisRepository.getSystemParameter(key);
        if (log.isInfoEnabled()) {
            log.info("\u8c03\u7528\u57fa\u7840\u670d\u52a1,\u67e5\u8be2\u57fa\u7840\u914d\u7f6e\u51fa\u53c2,{}", (Object)value);
        }
        return value;
    }

    public List<ShopRenovationVO> queryRenovationByShopId(QueryShopRenovationDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u88c5\u4fee\u5e97\u94fa\u662f\u5426\u5f15\u7528spu\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)dto);
        ApiResponse response = this.shopRenovationApi.queryByShopId(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u88c5\u4fee\u5e97\u94fa\u662f\u5426\u5f15\u7528spu\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u88c5\u4fee\u5e97\u94fa\u662f\u5426\u5f15\u7528spu\uff01{}" + response.getDesc()));
        if (ObjectUtil.isNotNull((Object)response.getContent())) {
            return (List)response.getContent();
        }
        throw new IllegalArgumentException("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u88c5\u4fee\u5e97\u94fa\u662f\u5426\u5f15\u7528spu\u5931\u8d25\uff01");
    }

    public List<MdmProductGroupVO> queryRenovationProductGroupByShopId(QueryShopRenovationDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u5e97\u94fasku\u662f\u5426\u88ab\u88c5\u4fee\u5546\u54c1\u7ec4\u5f15\u7528\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)dto);
        ApiResponse response = this.productGroupApi.queryByShopId(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u5e97\u94fasku\u662f\u5426\u88ab\u88c5\u4fee\u5546\u54c1\u7ec4\u5f15\u7528\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u5e97\u94fasku\u662f\u5426\u88ab\u88c5\u4fee\u5546\u54c1\u7ec4\u5f15\u7528\uff01{}" + response.getDesc()));
        if (ObjectUtil.isNotNull((Object)response.getContent())) {
            return (List)response.getContent();
        }
        throw new IllegalArgumentException("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u5e97\u94fasku\u662f\u5426\u88ab\u88c5\u4fee\u5546\u54c1\u7ec4\u5f15\u7528\u5931\u8d25\uff01");
    }

    public Map<String, List<Long>> querySearchKeysRelatedStoreIds(List<String> searchKeys) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u901a\u8fc7\u5173\u952e\u8bcd\u96c6\u5408\u67e5\u8be2\u5173\u8054\u5e97\u94fa\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(searchKeys));
        }
        ApiResponse response = this.shopRenovationApi.querySearchKeysRelatedStoreIds(searchKeys);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u901a\u8fc7\u5173\u952e\u8bcd\u96c6\u5408\u67e5\u8be2\u5173\u8054\u5e97\u94fa\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u901a\u8fc7\u5173\u952e\u8bcd\u96c6\u5408\u67e5\u8be2\u5173\u8054\u5e97\u94fa\u5931\u8d25\uff01{}" + response.getDesc()));
        if (ObjectUtil.isNotNull((Object)response.getContent())) {
            return (Map)response.getContent();
        }
        throw new IllegalArgumentException("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u901a\u8fc7\u5173\u952e\u8bcd\u96c6\u5408\u67e5\u8be2\u5173\u8054\u5e97\u94fa\u5931\u8d25\uff01");
    }

    public SalesmanVO queryBrandDirector(Long brandId) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u54c1\u724c\u8d1f\u8d23\u4eba\u5165\u53c2 brandId\uff1a{}", (Object)brandId);
        }
        ApiRequest apiRequest = new ApiRequest();
        SalesmanQueryDTO dto = new SalesmanQueryDTO();
        dto.setBrandId(brandId);
        apiRequest.setJsonData((Object)dto);
        ApiResponse response = this.salesmanApi.queryBrandDirector(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u54c1\u724c\u8d1f\u8d23\u4eba\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)("\u8c03\u7528[\u57fa\u7840\u6863\u6848]\u670d\u52a1 \u67e5\u8be2\u54c1\u724c\u8d1f\u8d23\u4eba\uff01{}" + response.getDesc()));
        return (SalesmanVO)response.getContent();
    }

    public List<MdmPlatformVO> queryPlatformByIds(List<Long> platformIds) {
        log.info("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u5e73\u53f0\u6863\u6848\u4fe1\u606f");
        MdmPlatformBatchQueryDTO dto = new MdmPlatformBatchQueryDTO();
        dto.setPlatformIdList(platformIds);
        ApiResponse response = this.mdmPlatformApi.queryList(dto);
        Assert.isTrue((boolean)response.isSuccess(), (String)"\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u5e73\u53f0\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff01");
        return (List)response.getContent();
    }

    public List<Long> queryRetainBrandBySalesmanIds(List<Long> salesmanIds) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u54c1\u724c\u8d1f\u8d23\u4eba\u54c1\u724c\uff1a{}", (Object)JSON.toJSONString(salesmanIds));
        }
        ApiResponse response = this.salesmanBrandApi.queryRetainBrandBySalesmanIds(salesmanIds);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u54c1\u724c\u8d1f\u8d23\u4eba\u54c1\u724c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        log.info("\u67e5\u8be2\u54c1\u724c\u8d1f\u8d23\u4eba\u54c1\u724c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        Assert.isTrue((boolean)response.isSuccess(), (String)"\u8c03\u7528\u67e5\u8be2\u54c1\u724c\u8d1f\u8d23\u4eba\u54c1\u724c\u5931\u8d25\uff01");
        return (List)response.getContent();
    }

    public List<LogisticsCompanyPlatformVO> queryLogisticCompanyAndPlatformRel(List<Long> mdmLogisticCompanyIds) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2mdm\u7269\u6d41\u516c\u53f8\u548c\u5e73\u53f0\u76f8\u5173\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(mdmLogisticCompanyIds));
        }
        LogisticsQueryDTO logisticsQueryDTO = new LogisticsQueryDTO();
        logisticsQueryDTO.setLogisticsCompanyTypeIdList(mdmLogisticCompanyIds);
        ApiResponse response = this.logisticsCompanyApi.queryLogisticsCompanyPlatform(new ApiRequest((Object)logisticsQueryDTO));
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2mdm\u7269\u6d41\u516c\u53f8\u548c\u5e73\u53f0\u76f8\u5173\u6570\u636e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        log.info("\u67e5\u8be2mdm\u7269\u6d41\u516c\u53f8\u548c\u5e73\u53f0\u76f8\u5173\u6570\u636e\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)response));
        Assert.isTrue((boolean)response.isSuccess(), (String)"\u8c03\u7528\u67e5\u8be2mdm\u7269\u6d41\u516c\u53f8\u548c\u5e73\u53f0\u76f8\u5173\u6570\u636e\u5931\u8d25\uff01");
        return (List)response.getContent();
    }

    public Map<Long, List<LogisticsCompanyPlatformVO>> queryLogisticCompanyAndPlatformRelMap(List<Long> mdmLogisticCompanyIds) {
        if (CollUtil.isEmpty(mdmLogisticCompanyIds)) {
            return Maps.newHashMap();
        }
        List<LogisticsCompanyPlatformVO> logisticsCompanyPlatformVOS = this.queryLogisticCompanyAndPlatformRel(mdmLogisticCompanyIds);
        if (CollUtil.isEmpty(logisticsCompanyPlatformVOS)) {
            return Maps.newHashMap();
        }
        return logisticsCompanyPlatformVOS.stream().collect(Collectors.groupingBy(LogisticsCompanyPlatformVO::getLogisticsCompanyTypeId));
    }

    public String selectDictValue(String districtCountryId, String dictCode) {
        log.info("\u83b7\u53d6\u5b57\u5178\u503c\u540d\u79f0districtCountryId={}\uff0cdictCode={}", (Object)districtCountryId, (Object)dictCode);
        DictValue dictValue = this.dictRedisRepository.selectByGroupCodeValueCode(dictCode, districtCountryId);
        if (null != dictValue) {
            return dictValue.getName();
        }
        throw new IllegalArgumentException("\u83b7\u53d6\u5b57\u5178\u503c\u540d\u79f0\u5931\u8d25");
    }

    public List<DictValue> selectDictByCode(String dictCode) {
        List dictValues = this.dictRedisRepository.selectDictValueListByCode(dictCode);
        if (log.isDebugEnabled()) {
            log.debug("\u5b57\u6bb5\u7ec4\u67e5\u8be2\u51fa\u53c2:{}", (Object)(CollectionUtils.isNotEmpty((Collection)dictValues) ? JSON.toJSONString((Object)dictValues) : null));
        }
        if (CollectionUtils.isEmpty((Collection)dictValues)) {
            throw new IllegalArgumentException("\u6839\u636e\u5b57\u5178\u7ec4\u7f16\u7801\u83b7\u53d6\u5b57\u5178\u5931\u8d25");
        }
        return dictValues;
    }
}

