/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.mq.exception.SendMqException;
import com.xinqiyi.framework.mq.util.MqProducerHelper;
import com.xinqiyi.nc.api.NcMessageRecordApi;
import com.xinqiyi.nc.model.dto.MQMessageInfo;
import com.xinqiyi.nc.model.dto.MessageRecordDTO;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class NcAdapter {
    private static final Logger log = LoggerFactory.getLogger(NcAdapter.class);
    private final MqProducerHelper mqProducerHelper;
    private final NcMessageRecordApi ncMessageRecordApi;

    @Deprecated
    public String sendMqToNc(MQMessageInfo mqMessageInfo) {
        if (log.isInfoEnabled()) {
            log.info("SendNcMsg.sendMqToNc:param={}", JSONObject.toJSON((Object)mqMessageInfo));
        }
        try {
            return this.mqProducerHelper.sendMessage((JSONObject)JSONObject.toJSON((Object)mqMessageInfo), ConstantPropertiesUtil.TOPIC, ConstantPropertiesUtil.NC_MESSAGE_RECORD_TAG);
        }
        catch (SendMqException e) {
            e.printStackTrace();
            log.error("SendNcMsg.sendMqToNc: \u53d1\u9001\u6d88\u606f\u51fa\u9519:{}", (Object)ExceptionUtils.getMessage((Throwable)e));
            return null;
        }
    }

    public void sendMsgByNC(MessageRecordDTO recordDTO) {
        if (log.isDebugEnabled()) {
            log.debug("\u901a\u8fc7nc\u53d1\u9001\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)recordDTO));
        }
        if (Objects.isNull(recordDTO) || CollUtil.isEmpty((Collection)recordDTO.getMessageInfoList())) {
            return;
        }
        ApiResponse response = this.ncMessageRecordApi.sendMessage(new ApiRequest((Object)recordDTO));
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u4f9b\u8d27\u516c\u53f8\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
    }

    public NcAdapter(MqProducerHelper mqProducerHelper, NcMessageRecordApi ncMessageRecordApi) {
        this.mqProducerHelper = mqProducerHelper;
        this.ncMessageRecordApi = ncMessageRecordApi;
    }
}

