/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter.cus;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.cus.api.CusCustomerApi;
import com.xinqiyi.cus.api.CusCustomerBlacklistApi;
import com.xinqiyi.cus.api.CusCustomerInvoiceApi;
import com.xinqiyi.cus.api.CusCustomerOrderConfigApi;
import com.xinqiyi.cus.api.CusSalesmanApi;
import com.xinqiyi.cus.model.dto.customer.CusCustomerBlacklistQueryDTO;
import com.xinqiyi.cus.model.dto.customer.CustomerOrderConfigureDetailsDTO;
import com.xinqiyi.cus.model.dto.customer.CustomerQueryInfoDTO;
import com.xinqiyi.cus.model.dto.customer.CustomerSalesmanDTO;
import com.xinqiyi.cus.model.dto.customer.GetCustomerStatusDTO;
import com.xinqiyi.cus.vo.BlacklistCusToRuleVO;
import com.xinqiyi.cus.vo.CustomerInvoiceVO;
import com.xinqiyi.cus.vo.CustomerStatusVO;
import com.xinqiyi.cus.vo.CustomerVO;
import com.xinqiyi.cus.vo.customer.CusCustomerOrderConfigurationVO;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class CusAdapter {
    private static final Logger log = LoggerFactory.getLogger(CusAdapter.class);
    private final CusCustomerApi cusCustomerApi;
    private final CusSalesmanApi cusSalesmanApi;
    private final CusCustomerInvoiceApi cusCustomerInvoiceApi;
    private final CusCustomerBlacklistApi cusCustomerBlacklistApi;
    @Autowired
    private CusCustomerOrderConfigApi cusCustomerOrderConfigApi;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    private Map<Long, CustomerVO> customerVOCache = new HashMap<Long, CustomerVO>();
    private Map<Long, CustomerStatusVO> customerStatusVOCache = new HashMap<Long, CustomerStatusVO>();

    public CusAdapter(CusCustomerApi cusCustomerApi, CusSalesmanApi cusSalesmanApi, CusCustomerInvoiceApi cusCustomerInvoiceApi, CusCustomerBlacklistApi cusCustomerBlacklistApi) {
        this.cusCustomerApi = cusCustomerApi;
        this.cusSalesmanApi = cusSalesmanApi;
        this.cusCustomerInvoiceApi = cusCustomerInvoiceApi;
        this.cusCustomerBlacklistApi = cusCustomerBlacklistApi;
    }

    public ApiResponse<CustomerVO> queryCustomerInfo(Long customerId) {
        CustomerQueryInfoDTO dto = new CustomerQueryInfoDTO();
        dto.setCusCustomerId(customerId);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:{}", (Object)customerId);
        }
        ApiResponse response = this.cusCustomerApi.queryCustomerById(dto);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u51fa\u53c2,{}", (Object)JSON.toJSONString((Object)response));
        }
        return response;
    }

    public List<CustomerVO> queryCustomerByIds(List<Long> customerIdList) {
        CustomerQueryInfoDTO dto = new CustomerQueryInfoDTO();
        dto.setCusCustomerIds(customerIdList);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:{}", (Object)customerIdList.toString());
        }
        ApiResponse response = this.cusCustomerApi.queryCustomerByIds(dto);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u51fa\u53c2,{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (List)response.getContent();
    }

    public List<CustomerVO> queryCustomerByOtherCondition(CustomerQueryInfoDTO dto) {
        ApiResponse response = this.cusCustomerApi.queryCustomerByOtherCondition(dto);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u51fa\u53c2,{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (List)response.getContent();
    }

    public List<BlacklistCusToRuleVO> queryCustomerBlacklist(Long customerId, List<String> punishRules) {
        CusCustomerBlacklistQueryDTO dto = new CusCustomerBlacklistQueryDTO();
        dto.setCustomerId(customerId);
        dto.setPunishRules(punishRules);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba2\u6237\u670d\u52a1\uff0c\u67e5\u8be2\u9ed1\u540d\u5355sku customerId =[{}], punishRules=[{}] ", (Object)customerId, (Object)punishRules.toString());
        }
        ApiResponse apiResponse = this.cusCustomerBlacklistApi.queryCustomerBlacklist(dto);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u9ed1\u540d\u5355sku,{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        return (List)apiResponse.getContent();
    }

    public CustomerInvoiceVO queryCustomerInvoiceById(Long invoiceId) {
        CustomerQueryInfoDTO dto = new CustomerQueryInfoDTO();
        dto.setId(invoiceId);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba2\u6237\u670d\u52a1\uff0c\u67e5\u8be2\u5ba2\u6237\u53d1\u7968\u4fe1\u606f=[{}]", (Object)invoiceId);
        }
        ApiResponse apiResponse = this.cusCustomerInvoiceApi.queryCustomerInvoiceById(dto);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5ba2\u6237\u53d1\u7968\u4fe1\u606f,{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        return (CustomerInvoiceVO)apiResponse.getContent();
    }

    public CustomerVO queryCustomerById(Long customerId) {
        CustomerQueryInfoDTO customerQueryInfoDTO = new CustomerQueryInfoDTO();
        customerQueryInfoDTO.setCusCustomerId(customerId);
        ApiResponse response = this.cusCustomerApi.queryCustomerById(customerQueryInfoDTO);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f,{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (CustomerVO)response.getContent();
    }

    public void updateBatchBrandStatus(List<Long> idList, Integer brandStatus) {
        CustomerSalesmanDTO customerSalesmanDTO = new CustomerSalesmanDTO();
        customerSalesmanDTO.setPsBrandIdList(idList);
        customerSalesmanDTO.setPsBrandStatus(brandStatus.toString());
        ApiResponse voidApiResponse = this.cusSalesmanApi.updateSalesmanInfo(customerSalesmanDTO);
        Assert.isTrue((boolean)voidApiResponse.isSuccess(), (String)voidApiResponse.getDesc());
    }

    public CustomerStatusVO getCustomerStatus() {
        GetCustomerStatusDTO getCustomerStatusDTO = new GetCustomerStatusDTO();
        getCustomerStatusDTO.setIsQueryContract("0");
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)getCustomerStatusDTO);
        ApiResponse response = this.cusCustomerApi.getCustomerStatus(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u4fe1\u606f,{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        CustomerStatusVO customerStatusVO = (CustomerStatusVO)response.getContent();
        Assert.notNull((Object)customerStatusVO, (String)"\u67e5\u8be2\u5ba2\u6237\u72b6\u6001\u4fe1\u606f\u5931\u8d25");
        return customerStatusVO;
    }

    public CusCustomerOrderConfigurationVO selectOrderConfigurationForQuerySku(CustomerOrderConfigureDetailsDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba2\u6237\u670d\u52a1\uff0c\u67e5\u8be2\u4e0b\u5355\u914d\u7f6e\u4e2d\u4e0d\u7b26\u5408\u6761\u4ef6\u7684\u5546\u54c1\u6216\u54c1\u724c\u5165\u53c2{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)dto);
        ApiResponse response = this.cusCustomerOrderConfigApi.selectOrderConfigurationForQuerySku(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba2\u6237\u670d\u52a1\uff0c\u67e5\u8be2\u4e0b\u5355\u914d\u7f6e\u4e2d\u4e0d\u7b26\u5408\u6761\u4ef6\u7684\u5546\u54c1\u6216\u54c1\u724c\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)response));
        }
        if (response.isSuccess()) {
            return (CusCustomerOrderConfigurationVO)response.getContent();
        }
        throw new IllegalArgumentException(response.getDesc());
    }
}

