/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter.fc;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.xinqiyi.fc.api.FcArExpenseApi;
import com.xinqiyi.fc.api.FcSettlementStrategyApi;
import com.xinqiyi.fc.api.model.vo.FcSaleCompanyVO;
import com.xinqiyi.fc.api.model.vo.ar.FcArExpenseVO;
import com.xinqiyi.fc.model.dto.ar.ArExpenseQueryDTO;
import com.xinqiyi.fc.model.dto.basic.FcSaleCompanyDto;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FcArExpenseAdapter {
    private static final Logger log = LoggerFactory.getLogger(FcArExpenseAdapter.class);
    private final FcArExpenseApi arExpenseApi;
    private final FcSettlementStrategyApi fcSettlementStrategyApi;

    public List<FcArExpenseVO> selectLastBrandExpenseList(ArExpenseQueryDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2N\u6708\u91c7\u8d2d\u54c1\u724c\u8bb0\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)dto);
        ApiResponse response = this.arExpenseApi.selectLastBrandExpenseList(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2N\u6708\u91c7\u8d2d\u54c1\u724c\u8bb0\u5f55\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        if (!response.isSuccess()) {
            throw new IllegalArgumentException("\u67e5\u8be2N\u6708\u91c7\u8d2d\u54c1\u724c\u8bb0\u5f55\u5931\u8d25\uff1a" + response.getDesc());
        }
        return (List)response.getContent();
    }

    public List<FcArExpenseVO> selectSkuSalesVolumeList(ArExpenseQueryDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u67e5\u8be2\u5e97\u94fa\u91c7\u8d2d\u91cf\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)dto);
        ApiResponse response = this.arExpenseApi.selectSkuSalesVolumeList(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u67e5\u8be2\u5e97\u94fa\u91c7\u8d2d\u91cf\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        if (!response.isSuccess()) {
            throw new IllegalArgumentException("\u67e5\u8be2\u67e5\u8be2\u5e97\u94fa\u91c7\u8d2d\u91cf\u5931\u8d25\uff1a" + response.getDesc());
        }
        return (List)response.getContent();
    }

    public List<FcSaleCompanyVO> getSaleCompany(List<FcSaleCompanyDto> dtoList) {
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u9500\u552e\u516c\u53f8\u5165\u53c2:{}", (Object)JSON.toJSONString(dtoList));
        }
        ApiResponse response = this.fcSettlementStrategyApi.selectSaleList(dtoList);
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u9500\u552e\u516c\u53f8\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
        return (List)response.getContent();
    }

    public FcArExpenseAdapter(FcArExpenseApi arExpenseApi, FcSettlementStrategyApi fcSettlementStrategyApi) {
        this.arExpenseApi = arExpenseApi;
        this.fcSettlementStrategyApi = fcSettlementStrategyApi;
    }
}

