/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter.mall4j;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.extra.pinyin.PinyinUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.xinqiyi.ps.model.dto.mall4j.BrandForMallFourJDTO;
import com.xinqiyi.ps.model.dto.mall4j.CategoryForMallFourJDTO;
import com.xinqiyi.ps.model.dto.mall4j.LangMallFourJDTO;
import com.xinqiyi.ps.model.dto.mall4j.Mall4jServerResponseEntity;
import com.xinqiyi.ps.model.dto.mall4j.ProdPropValuesDTO;
import com.xinqiyi.ps.model.dto.mall4j.ProdUpdateStocksDTO;
import com.xinqiyi.ps.model.dto.mall4j.SpecMallFourJDTO;
import com.xinqiyi.ps.model.dto.mall4j.SpuForMallFourJDTO;
import com.xinqiyi.ps.model.dto.sku.SpecDTO;
import com.xinqiyi.ps.model.dto.sku.TransportQueryDTO;
import com.xinqiyi.ps.model.dto.transport.TransportDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.BrandClass;
import com.xinqiyi.ps.model.entity.Category;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.task.PsCompensateTaskBiz;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MallFourJAdapter {
    private static final Logger log = LoggerFactory.getLogger(MallFourJAdapter.class);
    private final MdmAdapter mdmAdapter;
    private final PsCompensateTaskBiz taskBiz;
    private final ScAdapter scAdapter;

    public Mall4jServerResponseEntity<Void> prodSaveToMallFourJ(List<SpuForMallFourJDTO> list) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u5546\u54c1\u5165\u53c2{}", (Object)JSON.toJSONString(list));
        }
        String url = this.getMsUrl("MALL4J_SAVE_PROD");
        try {
            String res = this.sendHttpRequest(url, JSON.toJSONString(list));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u5546\u54c1\u51fa\u53c2:{}", (Object)response);
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u5546\u54c1\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> prodUpdateToMallFourJ(List<SpuForMallFourJDTO> list) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u4fee\u6539\u5546\u57ce\u5546\u54c1\u5165\u53c2{}", (Object)JSON.toJSONString(list));
        }
        String url = this.getMsUrl("MALL4J_UPDATE_PROD");
        try {
            String res = this.sendHttpRequest(url, JSON.toJSONString(list));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u4fee\u6539\u5546\u57ce\u5546\u54c1\u51fa\u53c2:{}", (Object)response);
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u4fee\u6539\u5546\u57ce\u5546\u54c1\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> prodStocksUpdateToMallFourJ(List<ProdUpdateStocksDTO> list) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u5e93\u5b58\u548c\u9500\u552e\u4ef7\u5165\u53c2{}", (Object)JSON.toJSONString(list));
        }
        String url = this.getMsUrl("MALL4J_UPDATE_STOCKS");
        try {
            String res = this.sendHttpRequest(url, JSON.toJSONString(list));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u5e93\u5b58\u548c\u9500\u552e\u4ef7\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(1, url, JSON.toJSONString(list), "", response.getMsg(), 1);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u5e93\u5b58\u548c\u9500\u552e\u4ef7\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(1, url, JSON.toJSONString(list), "", e.getMessage(), 1);
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> psCategorySaveToMallFourJ(List<Category> categoryList) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u7c7b\u76ee\u5165\u53c2:{}", (Object)JSON.toJSONString(categoryList));
        }
        String url = this.getMsUrl("MALL4J_CATEGORY_SAVE_URL");
        ArrayList<CategoryForMallFourJDTO> categoryForMallFourJDTOList = new ArrayList<CategoryForMallFourJDTO>();
        try {
            for (Category category : categoryList) {
                List<OssUrlVO> ossUrlVOS;
                CategoryForMallFourJDTO categoryForMallFourJDTO = new CategoryForMallFourJDTO();
                categoryForMallFourJDTO.setT(System.currentTimeMillis());
                categoryForMallFourJDTO.setType(Integer.valueOf(1));
                categoryForMallFourJDTO.setPsCategoryId(category.getId());
                categoryForMallFourJDTO.setCategoryName(category.getName());
                categoryForMallFourJDTO.setStatus(Integer.valueOf(StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)category.getStatus().toString()) ? 1 : 0));
                categoryForMallFourJDTO.setSeq(category.getSort());
                categoryForMallFourJDTO.setGrade(Integer.valueOf(category.getLevel() - 1));
                if (StringUtils.isNotEmpty((CharSequence)category.getLogoUrl()) && CollUtil.isNotEmpty(ossUrlVOS = this.scAdapter.generatePreassignedUrl(CollUtil.newArrayList((Object[])new String[]{category.getLogoUrl()})))) {
                    categoryForMallFourJDTO.setPic(ossUrlVOS.get(0).getIntactUrl());
                }
                if (0L != category.getPid()) {
                    categoryForMallFourJDTO.setPsParentId(category.getPid());
                }
                ArrayList<LangMallFourJDTO> langMallFourJDTOList = new ArrayList<LangMallFourJDTO>();
                LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
                langMallFourJDTO.setCategoryId(category.getId());
                langMallFourJDTO.setLang(Integer.valueOf(0));
                langMallFourJDTO.setCategoryName(category.getName());
                langMallFourJDTO.setLangName("\u4e2d\u6587");
                langMallFourJDTOList.add(langMallFourJDTO);
                categoryForMallFourJDTO.setCategoryLangList(langMallFourJDTOList);
                categoryForMallFourJDTOList.add(categoryForMallFourJDTO);
            }
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u7c7b\u76ee\u5c01\u88c5\u6570\u636e:{}", (Object)JSON.toJSONString(categoryForMallFourJDTOList));
            }
            String res = this.sendHttpRequest(url, JSON.toJSONString(categoryForMallFourJDTOList));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u7c7b\u76ee\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(2, url, JSON.toJSONString(categoryForMallFourJDTOList), "", response.getMsg(), 1);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u7c7b\u76ee\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(2, url, JSON.toJSONString(categoryForMallFourJDTOList), "", e.getMessage(), 1);
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> psCategoryUpdateToMallFourJ(Category category) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u66f4\u65b0\u5546\u57ce\u7c7b\u76ee\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)category));
        }
        CategoryForMallFourJDTO categoryForMallFourJDTO = new CategoryForMallFourJDTO();
        String url = this.getMsUrl("MALL4J_CATEGORY_UPDATE_URL");
        try {
            List<OssUrlVO> ossUrlVOS;
            categoryForMallFourJDTO.setT(System.currentTimeMillis());
            categoryForMallFourJDTO.setPsCategoryId(category.getId());
            categoryForMallFourJDTO.setCategoryName(category.getName());
            categoryForMallFourJDTO.setStatus(Integer.valueOf(StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)category.getStatus().toString()) ? 1 : 0));
            categoryForMallFourJDTO.setSeq(category.getSort());
            if (StringUtils.isNotEmpty((CharSequence)category.getLogoUrl()) && CollUtil.isNotEmpty(ossUrlVOS = this.scAdapter.generatePreassignedUrl(CollUtil.newArrayList((Object[])new String[]{category.getLogoUrl()})))) {
                categoryForMallFourJDTO.setPic(ossUrlVOS.get(0).getIntactUrl());
            }
            ArrayList<LangMallFourJDTO> langMallFourJDTOList = new ArrayList<LangMallFourJDTO>();
            LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
            langMallFourJDTO.setCategoryId(category.getId());
            langMallFourJDTO.setLang(Integer.valueOf(0));
            langMallFourJDTO.setCategoryName(category.getName());
            langMallFourJDTO.setLangName("\u4e2d\u6587");
            langMallFourJDTOList.add(langMallFourJDTO);
            categoryForMallFourJDTO.setCategoryLangList(langMallFourJDTOList);
            if (log.isInfoEnabled()) {
                log.info("\u66f4\u65b0\u5546\u57ce\u7c7b\u76ee\u5c01\u88c5\u6570\u636e:{}", (Object)JSON.toJSONString((Object)categoryForMallFourJDTO));
            }
            String res = this.sendHttpRequest(url, JSON.toJSONString((Object)categoryForMallFourJDTO));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u66f4\u65b0\u5546\u57ce\u7c7b\u76ee\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(2, url, JSON.toJSONString((Object)categoryForMallFourJDTO), "", response.getMsg(), 1);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u66f4\u65b0\u5546\u57ce\u7c7b\u76ee\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(2, url, JSON.toJSONString((Object)categoryForMallFourJDTO), "", e.getMessage(), 1);
            return null;
        }
    }

    public void deleteCategoryToMallFourJ(Category category) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return;
        }
        CategoryForMallFourJDTO categoryForMallFourJDTO = new CategoryForMallFourJDTO();
        String url = this.getPlatUrl("MALL4J_DELETE_CATEGORY");
        categoryForMallFourJDTO.setPsCategoryId(category.getId());
        if (log.isInfoEnabled()) {
            log.info("\u5220\u9664\u5546\u57ce\u7c7b\u76ee\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)category));
        }
        try {
            String res = this.sendHttpRequest(url, JSON.toJSONString((Object)categoryForMallFourJDTO));
            if (log.isInfoEnabled()) {
                log.info("\u5220\u9664\u5546\u57ce\u7c7b\u76ee\u51fa\u53c2:{}", (Object)res);
            }
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u5220\u9664\u5546\u57ce\u7c7b\u76ee\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(2, url, JSON.toJSONString((Object)categoryForMallFourJDTO), "", response.getMsg(), 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5220\u9664\u5546\u57ce\u7c7b\u76ee\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(2, url, JSON.toJSONString((Object)categoryForMallFourJDTO), "", e.getMessage(), 1);
        }
    }

    public Mall4jServerResponseEntity<Void> brandCategoryUpdateToMallFourJ(BrandClass brandClass) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u66f4\u65b0\u5546\u57ce\u54c1\u724c\u7c7b\u76ee\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)brandClass));
        }
        String url = this.getMsUrl("MALL4J_CATEGORY_UPDATE_URL");
        CategoryForMallFourJDTO categoryForMallFourJDTO = new CategoryForMallFourJDTO();
        try {
            categoryForMallFourJDTO.setT(System.currentTimeMillis());
            categoryForMallFourJDTO.setType(Integer.valueOf(2));
            categoryForMallFourJDTO.setPsCategoryId(brandClass.getId());
            categoryForMallFourJDTO.setStatus(Integer.valueOf(StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)brandClass.getStatus().toString()) ? 1 : 0));
            ArrayList<LangMallFourJDTO> langMallFourJDTOList = new ArrayList<LangMallFourJDTO>();
            LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
            langMallFourJDTO.setCategoryId(brandClass.getId());
            langMallFourJDTO.setLang(Integer.valueOf(0));
            langMallFourJDTO.setCategoryName(brandClass.getName());
            langMallFourJDTO.setLangName("\u4e2d\u6587");
            langMallFourJDTOList.add(langMallFourJDTO);
            categoryForMallFourJDTO.setCategoryLangList(langMallFourJDTOList);
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u66f4\u65b0\u5546\u57ce\u54c1\u724c\u7c7b\u76ee\u5c01\u88c5\u6570\u636e:{}", (Object)JSON.toJSONString((Object)categoryForMallFourJDTO));
            }
            String res = this.sendHttpRequest(url, JSON.toJSONString((Object)categoryForMallFourJDTO));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u66f4\u65b0\u5546\u57ce\u54c1\u724c\u7c7b\u76ee\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(2, url, JSON.toJSONString((Object)categoryForMallFourJDTO), "", response.getMsg(), 1);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u66f4\u65b0\u5546\u57ce\u7c7b\u76ee\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(2, url, JSON.toJSONString((Object)categoryForMallFourJDTO), "", e.getMessage(), 1);
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> brandCategorySaveToMallFourJ(List<BrandClass> brandClassList) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u54c1\u724c\u7c7b\u76ee\u5165\u53c2:{}", (Object)JSON.toJSONString(brandClassList));
        }
        String url = this.getMsUrl("MALL4J_CATEGORY_SAVE_URL");
        ArrayList<CategoryForMallFourJDTO> categoryForMallFourJDTOList = new ArrayList<CategoryForMallFourJDTO>();
        try {
            String res;
            Mall4jServerResponseEntity response;
            for (BrandClass brandClass : brandClassList) {
                CategoryForMallFourJDTO categoryForMallFourJDTO = new CategoryForMallFourJDTO();
                categoryForMallFourJDTO.setT(System.currentTimeMillis());
                categoryForMallFourJDTO.setType(Integer.valueOf(2));
                categoryForMallFourJDTO.setPsCategoryId(brandClass.getId());
                categoryForMallFourJDTO.setStatus(Integer.valueOf(StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)brandClass.getStatus()) ? 1 : 0));
                categoryForMallFourJDTO.setSeq(Integer.valueOf(0));
                categoryForMallFourJDTO.setGrade(Integer.valueOf(0));
                ArrayList<LangMallFourJDTO> langMallFourJDTOList = new ArrayList<LangMallFourJDTO>();
                LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
                langMallFourJDTO.setCategoryId(brandClass.getId());
                langMallFourJDTO.setLang(Integer.valueOf(0));
                langMallFourJDTO.setCategoryName(brandClass.getName());
                langMallFourJDTO.setLangName("\u4e2d\u6587");
                langMallFourJDTOList.add(langMallFourJDTO);
                categoryForMallFourJDTO.setCategoryLangList(langMallFourJDTOList);
                categoryForMallFourJDTOList.add(categoryForMallFourJDTO);
            }
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u54c1\u724c\u7c7b\u76ee\u5c01\u88c5\u6570\u636e:{}", (Object)JSON.toJSONString(categoryForMallFourJDTOList));
            }
            if (!(response = (Mall4jServerResponseEntity)JSON.parseObject((String)(res = this.sendHttpRequest(url, JSON.toJSONString(categoryForMallFourJDTOList))), Mall4jServerResponseEntity.class)).isSuccess()) {
                this.taskBiz.saveTask(2, url, JSON.toJSONString(categoryForMallFourJDTOList), "", response.getMsg(), 1);
                return null;
            }
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u4fdd\u5b58\u54c1\u724c\u5546\u57ce\u7c7b\u76ee\u51fa\u53c2:{}", (Object)response);
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u54c1\u724c\u7c7b\u76ee\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(2, url, JSON.toJSONString(categoryForMallFourJDTOList), "", e.getMessage(), 1);
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> brandSaveToMallFourJ(List<Brand> brandList) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u4fdd\u5b58\u5546\u57ce\u54c1\u724c\u5165\u53c2:{}", (Object)JSON.toJSONString(brandList));
        }
        String url = this.getPlatUrl("MALL4J_SAVE_BRAND");
        ArrayList<BrandForMallFourJDTO> list = new ArrayList<BrandForMallFourJDTO>();
        try {
            for (Brand brand : brandList) {
                List<OssUrlVO> ossUrlVOS;
                BrandForMallFourJDTO mallFourJDTO = new BrandForMallFourJDTO();
                mallFourJDTO.setPsBrandId(brand.getId());
                mallFourJDTO.setPsBrandCode(brand.getCode());
                mallFourJDTO.setStatus(Integer.valueOf(StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)brand.getStatus().toString()) && StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)brand.getIsDelete().toString()) ? 1 : 0));
                mallFourJDTO.setFirstLetter(PinyinUtil.getFirstLetter((String)brand.getName(), (String)"").substring(0, 1).toUpperCase());
                mallFourJDTO.setPsBrandCategory(brand.getBrandClassId());
                if (StringUtils.isNotEmpty((CharSequence)brand.getLogoUrl()) && CollUtil.isNotEmpty(ossUrlVOS = this.scAdapter.generatePreassignedUrl(CollUtil.newArrayList((Object[])new String[]{brand.getLogoUrl()})))) {
                    mallFourJDTO.setImgUrl(ossUrlVOS.get(0).getIntactUrl());
                }
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                Long id = Long.valueOf(this.mdmAdapter.selectMdmSystemConfig("MALL4J_BRAND_CATEGORY_ID"));
                categoryIds.add(id);
                mallFourJDTO.setCategoryIds(categoryIds);
                ArrayList<LangMallFourJDTO> langMallFourJDTOList = new ArrayList<LangMallFourJDTO>();
                LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
                langMallFourJDTO.setBrandId(brand.getId());
                langMallFourJDTO.setLang(Integer.valueOf(0));
                langMallFourJDTO.setName(brand.getName());
                langMallFourJDTO.setLangName("\u4e2d\u6587");
                langMallFourJDTOList.add(langMallFourJDTO);
                mallFourJDTO.setBrandLangList(langMallFourJDTOList);
                list.add(mallFourJDTO);
            }
            if (log.isInfoEnabled()) {
                log.info("\u4fdd\u5b58\u5546\u57ce\u54c1\u724c\u5c01\u88c5\u6570\u636e:{}", (Object)JSON.toJSONString(list));
            }
            String res = this.sendHttpRequest(url, JSON.toJSONString(list));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u54c1\u724c\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(3, url, JSON.toJSONString(list), "", response.getMsg(), 1);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4fdd\u5b58\u5546\u57ce\u54c1\u724c\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(3, url, JSON.toJSONString(list), "", e.getMessage(), 1);
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> brandUpdateToMallFourJ(Brand brand) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u66f4\u65b0\u5546\u57ce\u54c1\u724c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)brand));
        }
        String url = this.getPlatUrl("MALL4J_UPDATE_BRAND");
        BrandForMallFourJDTO mallFourJDTO = new BrandForMallFourJDTO();
        try {
            List<OssUrlVO> ossUrlVOS;
            mallFourJDTO.setPsBrandId(brand.getId());
            mallFourJDTO.setPsBrandCode(brand.getCode());
            mallFourJDTO.setStatus(Integer.valueOf(StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)brand.getStatus().toString()) ? 1 : 0));
            mallFourJDTO.setFirstLetter(PinyinUtil.getFirstLetter((String)brand.getName(), (String)"").substring(0, 1).toUpperCase());
            mallFourJDTO.setPsBrandCategory(brand.getBrandClassId());
            if (StringUtils.isNotEmpty((CharSequence)brand.getLogoUrl()) && CollUtil.isNotEmpty(ossUrlVOS = this.scAdapter.generatePreassignedUrl(CollUtil.newArrayList((Object[])new String[]{brand.getLogoUrl()})))) {
                mallFourJDTO.setImgUrl(ossUrlVOS.get(0).getIntactUrl());
            }
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            Long id = Long.valueOf(this.mdmAdapter.selectMdmSystemConfig("MALL4J_BRAND_CATEGORY_ID"));
            categoryIds.add(id);
            mallFourJDTO.setCategoryIds(categoryIds);
            ArrayList<LangMallFourJDTO> langMallFourJDTOList = new ArrayList<LangMallFourJDTO>();
            LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
            langMallFourJDTO.setBrandId(brand.getId());
            langMallFourJDTO.setLang(Integer.valueOf(0));
            langMallFourJDTO.setName(brand.getName());
            langMallFourJDTO.setLangName("\u4e2d\u6587");
            langMallFourJDTOList.add(langMallFourJDTO);
            mallFourJDTO.setBrandLangList(langMallFourJDTOList);
            if (log.isInfoEnabled()) {
                log.info("\u4fee\u6539\u5546\u57ce\u54c1\u724c\u5c01\u88c5\u6570\u636e:{}", (Object)JSON.toJSONString((Object)mallFourJDTO));
            }
            String res = this.sendHttpRequest(url, JSON.toJSONString((Object)mallFourJDTO));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u4fee\u6539\u5546\u57ce\u54c1\u724c\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(3, url, JSON.toJSONString((Object)mallFourJDTO), "", response.getMsg(), 1);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4fee\u6539\u5546\u57ce\u54c1\u724c\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(3, url, JSON.toJSONString((Object)mallFourJDTO), "", e.getMessage(), 1);
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> saveSpecToMallFourJ(List<SpecDTO> specDTOList) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u89c4\u683c\u5165\u53c2:{}", (Object)JSON.toJSONString(specDTOList));
        }
        String url = this.getMsUrl("MALL4J_SAVE_SPEC");
        ArrayList<SpecMallFourJDTO> list = new ArrayList<SpecMallFourJDTO>();
        for (SpecDTO specDTO : specDTOList) {
            SpecMallFourJDTO specMallFourJDTO = new SpecMallFourJDTO();
            specMallFourJDTO.setT(System.currentTimeMillis());
            specMallFourJDTO.setPsPropId(specDTO.getPsSpecId());
            specMallFourJDTO.setPropName(specDTO.getPsSpecName());
            ArrayList<LangMallFourJDTO> langMallFourJDTOList = new ArrayList<LangMallFourJDTO>();
            LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
            langMallFourJDTO.setPropName(specDTO.getPsSpecName());
            langMallFourJDTO.setPropId(specDTO.getPsSpecId());
            langMallFourJDTO.setLang(Integer.valueOf(0));
            langMallFourJDTO.setLangName("\u4e2d\u6587");
            langMallFourJDTOList.add(langMallFourJDTO);
            specMallFourJDTO.setProdPropLangList(langMallFourJDTOList);
            ArrayList<ProdPropValuesDTO> prodPropValuesDTOS = new ArrayList<ProdPropValuesDTO>();
            if (CollUtil.isNotEmpty((Collection)specDTO.getSpecValueNameList())) {
                for (String name : specDTO.getSpecValueNameList()) {
                    ArrayList<LangMallFourJDTO> langMallFourJDTOS = new ArrayList<LangMallFourJDTO>();
                    ProdPropValuesDTO prodPropValuesDTO = new ProdPropValuesDTO();
                    prodPropValuesDTO.setPropId(specDTO.getPsSpecId());
                    LangMallFourJDTO lang = new LangMallFourJDTO();
                    lang.setPropValue(name);
                    lang.setLang(Integer.valueOf(0));
                    lang.setLangName("\u4e2d\u6587");
                    langMallFourJDTOS.add(lang);
                    prodPropValuesDTO.setProdPropValueLangList(langMallFourJDTOS);
                    prodPropValuesDTOS.add(prodPropValuesDTO);
                }
            }
            specMallFourJDTO.setProdPropValues(prodPropValuesDTOS);
            list.add(specMallFourJDTO);
        }
        if (log.isInfoEnabled()) {
            log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u89c4\u683c\u5c01\u88c5\u6570\u636e:{}", (Object)JSON.toJSONString(list));
        }
        try {
            String res = this.sendHttpRequest(url, JSON.toJSONString(list));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u89c4\u683c\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(4, url, JSON.toJSONString(list), "", response.getMsg(), 1);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u4fdd\u5b58\u5546\u57ce\u89c4\u683c\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(4, url, JSON.toJSONString(list), "", e.getMessage(), 1);
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> updateSpecToMallFourJ(SpecDTO specDTO) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u66f4\u65b0\u89c4\u683c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)specDTO));
        }
        String url = this.getMsUrl("MALL4J_UPDATE_SPEC");
        SpecMallFourJDTO specMallFourJDTO = new SpecMallFourJDTO();
        specMallFourJDTO.setT(System.currentTimeMillis());
        specMallFourJDTO.setPsPropId(specDTO.getPsSpecId());
        specMallFourJDTO.setPropName(specDTO.getPsSpecName());
        ArrayList<LangMallFourJDTO> langMallFourJDTOList = new ArrayList<LangMallFourJDTO>();
        LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
        langMallFourJDTO.setPropName(specDTO.getPsSpecName());
        langMallFourJDTO.setLang(Integer.valueOf(0));
        langMallFourJDTO.setLangName("\u4e2d\u6587");
        langMallFourJDTOList.add(langMallFourJDTO);
        specMallFourJDTO.setProdPropLangList(langMallFourJDTOList);
        ArrayList<ProdPropValuesDTO> prodPropValuesDTOS = new ArrayList<ProdPropValuesDTO>();
        if (CollUtil.isNotEmpty((Collection)specDTO.getSpecValueNameList())) {
            for (String name : specDTO.getSpecValueNameList()) {
                ProdPropValuesDTO prodPropValuesDTO = new ProdPropValuesDTO();
                prodPropValuesDTO.setPropId(specDTO.getPsSpecId());
                ArrayList<LangMallFourJDTO> langMallFourJDTOS = new ArrayList<LangMallFourJDTO>();
                LangMallFourJDTO lang = new LangMallFourJDTO();
                lang.setPropValue(name);
                lang.setLang(Integer.valueOf(0));
                lang.setLangName("\u4e2d\u6587");
                langMallFourJDTOS.add(lang);
                prodPropValuesDTO.setProdPropValueLangList(langMallFourJDTOS);
                prodPropValuesDTOS.add(prodPropValuesDTO);
            }
        }
        specMallFourJDTO.setProdPropValues(prodPropValuesDTOS);
        if (log.isInfoEnabled()) {
            log.info("\u66f4\u65b0\u89c4\u683c\u5c01\u88c5\u6570\u636e:{}", (Object)JSON.toJSONString((Object)specMallFourJDTO));
        }
        try {
            String res = this.sendHttpRequest(url, JSON.toJSONString((Object)specMallFourJDTO));
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u66f4\u65b0\u89c4\u683c\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(4, url, JSON.toJSONString((Object)specMallFourJDTO), "", response.getMsg(), 1);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u66f4\u65b0\u89c4\u683c\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(4, url, JSON.toJSONString((Object)specMallFourJDTO), "", e.getMessage(), 1);
            return null;
        }
    }

    public Mall4jServerResponseEntity<Void> deleteSpecToMallFourJ(Long psPropId) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info("\u5220\u9664\u5546\u57ce\u89c4\u683c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)psPropId));
        }
        String url = this.getMsUrl("MALL4J_DELETE_SPEC");
        try {
            String res = this.sendGetHttpRequest(url + psPropId);
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u5220\u9664\u5546\u57ce\u89c4\u683c\u51fa\u53c2:{}", (Object)response);
            }
            if (!response.isSuccess()) {
                this.taskBiz.saveTask(4, url + psPropId, "", "", response.getMsg(), 2);
                return null;
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5220\u9664\u5546\u57ce\u89c4\u683c\u5f02\u5e38:{}", (Object)e.getMessage());
            this.taskBiz.saveTask(4, url + psPropId, "", "", e.getMessage(), 2);
            return null;
        }
    }

    private String getMsUrl(String key) {
        return this.mdmAdapter.selectMdmSystemConfig("MALL4J_MS_IP") + this.mdmAdapter.selectMdmSystemConfig(key);
    }

    private String getPlatUrl(String key) {
        return this.mdmAdapter.selectMdmSystemConfig("MALL4J_PLATFORM_IP") + this.mdmAdapter.selectMdmSystemConfig(key);
    }

    private String getParam(Object obj) {
        Long timestamp = System.currentTimeMillis();
        TreeMap<String, Object> param = new TreeMap<String, Object>();
        param.put("timestamp", timestamp.toString());
        param.put("appSecret", ConstantPropertiesUtil.MALL_4J_APP_ID);
        param.put("data", obj);
        Digester sha256 = new Digester(DigestAlgorithm.SHA256);
        String sign = sha256.digestHex(JSON.toJSONString(param));
        param.put("sign", sign);
        param.put("appId", ConstantPropertiesUtil.MALL_4J_APP_ID);
        return JSON.toJSONString(param);
    }

    private String sendHttpRequest(String url, String param) {
        return ((HttpRequest)HttpRequest.post((String)url).header("Content-Type", "application/json")).body(param).execute().body();
    }

    private String sendGetHttpRequest(String url) {
        return HttpRequest.get((String)url).execute().body();
    }

    private String selectDefaultTransportPageResponse() {
        return "{\n  \"code\": \"00000\",\n  \"msg\": null,\n  \"data\": {\n    \"records\": [\n      {\n        \"transportId\": 1,\n        \"transName\": \"\u9ed8\u8ba4\u8fd0\u8d39\u6a21\u677f\",\n        \"createTime\": \"2024-03-29 17:58:27\",\n        \"shopId\": 1,\n        \"chargeType\": 0,\n        \"isFreeFee\": 0,\n        \"hasFreeCondition\": 0,\n        \"transfeeFrees\": null,\n        \"transfees\": null,\n        \"transportIdList\": null\n      }\n    ],\n    \"total\": 1,\n    \"size\": 10,\n    \"current\": 0,\n    \"pages\": 1\n  },\n  \"version\": \"fonyuan.mall.v20240129\",\n  \"timestamp\": null,\n  \"sign\": null,\n  \"success\": true\n}";
    }

    private Page selectDefaultTransportPage() {
        String res = this.selectDefaultTransportPageResponse();
        Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getMsg());
        return (Page)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), Page.class);
    }

    private List<TransportDTO> selectDefaultTransportList() {
        String res = this.selectDefaultTransportPageResponse();
        Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getMsg());
        Page page = (Page)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), Page.class);
        return JSON.parseArray((String)JSONObject.toJSONString((Object)page.getRecords()), TransportDTO.class);
    }

    public Page selectTransportPage(TransportQueryDTO dto) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return this.selectDefaultTransportPage();
        }
        Object url = this.getMsUrl("MALL4J_TRANSPORT_PAGE");
        try {
            url = (String)url + "?current=" + dto.getPageNum() + "&size=" + dto.getPageSize();
            if (CollUtil.isNotEmpty((Collection)dto.getTransportIdList())) {
                String transportIdList = dto.getTransportIdList().stream().map(String::valueOf).collect(Collectors.joining(","));
                url = (String)url + "&transportIdList=" + transportIdList;
            }
            if (log.isInfoEnabled()) {
                log.info("\u67e5\u8be2\u8fd0\u8d39\u6a21\u677f\u5165\u53c2:{}", url);
            }
            String res = this.sendGetHttpRequest((String)url);
            if (log.isInfoEnabled()) {
                log.info("\u67e5\u8be2\u8fd0\u8d39\u6a21\u677f\u51fa\u53c2:{}", (Object)res);
                Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
                Assert.isTrue((boolean)response.isSuccess(), (String)response.getMsg());
                return (Page)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), Page.class);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8fd0\u8d39\u6a21\u677f\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public List<TransportDTO> selectTransportList(TransportQueryDTO dto) {
        String isOpenMall4j = this.mdmAdapter.selectMdmSystemConfig("IS_OPEN_MALL4J");
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)isOpenMall4j)) {
            return this.selectDefaultTransportList();
        }
        Object url = this.getMsUrl("MALL4J_TRANSPORT_PAGE");
        try {
            url = (String)url + "?current=" + dto.getPageNum() + "&size=" + dto.getPageSize();
            if (CollUtil.isNotEmpty((Collection)dto.getTransportIdList())) {
                String transportIdList = dto.getTransportIdList().stream().map(String::valueOf).collect(Collectors.joining(","));
                url = (String)url + "&transportIdList=" + transportIdList;
            }
            String res = this.sendGetHttpRequest((String)url);
            Mall4jServerResponseEntity response = (Mall4jServerResponseEntity)JSON.parseObject((String)res, Mall4jServerResponseEntity.class);
            if (log.isInfoEnabled()) {
                log.info("\u67e5\u8be2\u8fd0\u8d39\u6a21\u677f\u51fa\u53c2:{}", (Object)response);
            }
            Assert.isTrue((boolean)response.isSuccess(), (String)response.getMsg());
            Page page = (Page)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), Page.class);
            return JSON.parseArray((String)JSONObject.toJSONString((Object)page.getRecords()), TransportDTO.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u67e5\u8be2\u8fd0\u8d39\u6a21\u677f\u5f02\u5e38:{}", (Object)e.getMessage());
            return CollUtil.newArrayList((Object[])new TransportDTO[0]);
        }
    }

    public Map<Long, TransportDTO> selectTransportMap(List<Long> transportIdList) {
        if (CollUtil.isEmpty(transportIdList)) {
            return Maps.newHashMap();
        }
        TransportQueryDTO transportQueryDTO = new TransportQueryDTO();
        transportQueryDTO.setTransportIdList(transportIdList);
        transportQueryDTO.setPageSize(999);
        List<TransportDTO> transportDTOS = this.selectTransportList(transportQueryDTO);
        if (CollUtil.isEmpty(transportDTOS)) {
            return Maps.newHashMap();
        }
        return transportDTOS.stream().collect(Collectors.toMap(TransportDTO::getTransportId, Function.identity()));
    }

    public MallFourJAdapter(MdmAdapter mdmAdapter, PsCompensateTaskBiz taskBiz, ScAdapter scAdapter) {
        this.mdmAdapter = mdmAdapter;
        this.taskBiz = taskBiz;
        this.scAdapter = scAdapter;
    }
}

