/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter.mc;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.mc.api.McBaseInfoApi;
import com.xinqiyi.mc.api.model.vo.act.McSkuVO;
import com.xinqiyi.mc.api.model.vo.act.orderGift.ReturnGiftsVO;
import com.xinqiyi.mc.model.dto.mc.FetchGiftsDTO;
import com.xinqiyi.mc.model.dto.mc.activity.CustomerAndSkuDTO;
import com.xinqiyi.mc.model.dto.mc.activity.McBaseInfoPageQueryDTO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class McAdapter {
    private static final Logger log = LoggerFactory.getLogger(McAdapter.class);
    @Autowired
    private McBaseInfoApi mcBaseInfoApi;

    public List<ReturnGiftsVO> fetchActRuleDesc(List<Long> skuIdList, Long customerId, Integer executeMcRange) {
        ArrayList fetchActRuleDescs = CollUtil.newArrayList((Object[])new FetchGiftsDTO[0]);
        for (Long skuId : skuIdList) {
            FetchGiftsDTO fetchActRuleDesc = new FetchGiftsDTO();
            fetchActRuleDesc.setPsSkuId(skuId);
            fetchActRuleDesc.setCusCustomerId(customerId);
            fetchActRuleDesc.setExecuteMcRange(executeMcRange);
            fetchActRuleDescs.add(fetchActRuleDesc);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u8425\u9500\u6d3b\u52a8\u53c2\u6570\u63cf\u8ff0,{}", (Object)JSON.toJSONString((Object)fetchActRuleDescs));
        }
        ApiResponse apiResponse = this.mcBaseInfoApi.fetchActRuleDesc((List)fetchActRuleDescs);
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)("\u67e5\u8be2\u8425\u9500\u6d3b\u52a8\u5931\u8d25" + apiResponse.getDesc()));
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u8425\u9500\u6d3b\u52a8\u63cf\u8ff0,{}", (Object)JSON.toJSONString((Object)apiResponse.toJsonObject()));
        }
        return (List)apiResponse.getContent();
    }

    public List<Long> filterSkuId(List<Long> skuIdList, Long customerId) {
        ArrayList customerAndSkuDTOS = CollUtil.newArrayList((Object[])new CustomerAndSkuDTO[0]);
        for (Long skuId : skuIdList) {
            CustomerAndSkuDTO customerAndSkuDTO = new CustomerAndSkuDTO();
            customerAndSkuDTO.setPsSkuId(skuId);
            customerAndSkuDTO.setCusCustomerId(customerId);
            customerAndSkuDTOS.add(customerAndSkuDTO);
        }
        McBaseInfoPageQueryDTO mcBaseInfoPageQueryDTO = new McBaseInfoPageQueryDTO();
        mcBaseInfoPageQueryDTO.setCustomerAndSkuDTOList((List)customerAndSkuDTOS);
        mcBaseInfoPageQueryDTO.setMcStatus((List)CollUtil.newArrayList((Object[])new Integer[]{4}));
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2sku\u6d3b\u52a8\u8fc7\u6ee4,{}", (Object)JSON.toJSONString((Object)mcBaseInfoPageQueryDTO));
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)mcBaseInfoPageQueryDTO);
        ApiResponse apiResponse = this.mcBaseInfoApi.filterSkuId(apiRequest);
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)("\u67e5\u8be2\u8425\u9500\u6d3b\u52a8\u5931\u8d25" + apiResponse.getDesc()));
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2sku\u6d3b\u52a8\u8fc7\u6ee4,{}", (Object)JSON.toJSONString((Object)apiResponse.toJsonObject()));
        }
        return (List)apiResponse.getContent();
    }

    public McSkuVO queryActivityRef(Long customerId, List<Long> checkActivitySkuIdList) {
        ArrayList customerAndSkuDTOList = CollUtil.newArrayList((Object[])new CustomerAndSkuDTO[0]);
        for (Long skuId : checkActivitySkuIdList) {
            CustomerAndSkuDTO customerAndSkuDTO = new CustomerAndSkuDTO();
            customerAndSkuDTO.setCusCustomerId(customerId);
            customerAndSkuDTO.setPsSkuId(skuId);
            customerAndSkuDTOList.add(customerAndSkuDTO);
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)customerAndSkuDTOList);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2sku\u662f\u5426\u6709\u6d3b\u52a8\u53c2\u6570,{}", (Object)JSON.toJSONString((Object)apiRequest));
        }
        ApiResponse apiResponse = this.mcBaseInfoApi.filterActivitySkuId(apiRequest);
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)("\u67e5\u8be2\u8425\u9500\u6d3b\u52a8\u5931\u8d25" + apiResponse.getDesc()));
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2sku\u662f\u5426\u6709\u6d3b\u52a8,{}", (Object)JSON.toJSONString((Object)apiResponse.toJsonObject()));
        }
        return (McSkuVO)apiResponse.getContent();
    }
}

