/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter.oa;

import com.alibaba.fastjson.JSON;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.oa.api.WorkFlowApi;
import com.xinqiyi.oa.api.model.vo.ProcessInstanceVO;
import com.xinqiyi.oa.model.dto.workflow.OaProcessDto;
import com.xinqiyi.oa.model.dto.workflow.formComponent.FormComponentParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class OaAdapter {
    private static final Logger log = LoggerFactory.getLogger(OaAdapter.class);
    @Autowired
    private WorkFlowApi workFlowApi;

    public ApiResponse terminateWorkFlow(String processInstanceId, String userJson) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528Oa\u670d\u52a1\uff0c\u7ec8\u6b62\u5ba1\u6279\u6d41\u7a0b \u6d41\u7a0bid=[{}], userJson=[{}]", (Object)processInstanceId, (Object)userJson);
        }
        ApiResponse apiResponse = this.workFlowApi.terminateWorkFlow(processInstanceId, userJson);
        if (log.isDebugEnabled()) {
            log.debug("\u7ec8\u6b62\u5ba1\u6279\u6d41\u7a0b,{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        return apiResponse;
    }

    public ProcessInstanceVO getWorkFlowDetail(String processInstanceId) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528Oa\u670d\u52a1\uff0c\u67e5\u8be2\u5de5\u4f5c\u6d41\u8be6\u60c5 \u6d41\u7a0bid=[{}]", (Object)processInstanceId);
        }
        ApiResponse apiResponse = this.workFlowApi.getWorkFlowDetail(processInstanceId);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5de5\u4f5c\u6d41\u8be6\u60c5,{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        return (ProcessInstanceVO)apiResponse.getContent();
    }

    public String createOaProcess(String formJson, String userJson, String templateType) {
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528Oa\u670d\u52a1\uff0c\u521b\u5efa\u5ba1\u6279\u6d41\u7a0b formJson=[{}], userJson=[{}], templateType=[{}]", new Object[]{formJson, userJson, templateType});
        }
        OaProcessDto oaProcessDto = new OaProcessDto();
        oaProcessDto.setFormJson(formJson);
        oaProcessDto.setUserJson(userJson);
        oaProcessDto.setTemplateType(templateType);
        ApiRequest oaProcessDtoApiRequest = new ApiRequest();
        oaProcessDtoApiRequest.setJsonData((Object)oaProcessDto);
        ApiResponse apiResponse = this.workFlowApi.createOaProcess(oaProcessDtoApiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u5ba1\u6279\u6d41\u7a0b,{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        return (String)apiResponse.getContent();
    }

    public String createOaProcessV2(String formJson, String templateType) {
        if (log.isInfoEnabled()) {
            log.info("\u8c03\u7528Oa\u670d\u52a1\uff0c\u521b\u5efa\u5ba1\u6279\u6d41\u7a0b formJson=[{}], templateType=[{}]", (Object)formJson, (Object)templateType);
        }
        FormComponentParams formComponentParams = new FormComponentParams();
        formComponentParams.setFormJson(formJson);
        formComponentParams.setTemplateCode(templateType);
        ApiRequest oaProcessDtoApiRequest = new ApiRequest();
        oaProcessDtoApiRequest.setJsonData((Object)formComponentParams);
        ApiResponse apiResponse = this.workFlowApi.createOaProcessConfig(oaProcessDtoApiRequest);
        if (log.isInfoEnabled()) {
            log.info("\u521b\u5efa\u5ba1\u6279\u6d41\u7a0b,{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        return (String)apiResponse.getContent();
    }
}

