/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter.sc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.xinqiyi.dynamicform.dao.repository.DictRedisRepository;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.dynamicform.model.dto.TableFunctionType;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.systemcenter.web.sc.api.IDictApi;
import com.xinqiyi.systemcenter.web.sc.api.IMenuApi;
import com.xinqiyi.systemcenter.web.sc.api.IRoleApi;
import com.xinqiyi.systemcenter.web.sc.api.ISensitiveColumnApi;
import com.xinqiyi.systemcenter.web.sc.api.ITaskApi;
import com.xinqiyi.systemcenter.web.sc.api.IUserApi;
import com.xinqiyi.systemcenter.web.sc.api.IUserHabitApi;
import com.xinqiyi.systemcenter.web.sc.api.OssFileApi;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.menu.BizMenuDTO;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.menu.MenuRespDTO;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.task.TaskDetailDTO;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.task.TaskSaveDto;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.user.UserVO;
import com.xinqiyi.systemcenter.web.sc.model.dto.file.OssFileDTO;
import com.xinqiyi.systemcenter.web.sc.model.dto.habit.SysTableConfigDto;
import com.xinqiyi.systemcenter.web.sc.model.dto.permission.UserFunctionPermissionDTO;
import com.xinqiyi.systemcenter.web.sc.model.dto.role.RoleDTO;
import com.xinqiyi.systemcenter.web.sc.model.dto.role.StoreRoleRelationDTO;
import com.xinqiyi.systemcenter.web.sc.model.dto.task.SyncThirdAppTaskDto;
import com.xinqiyi.systemcenter.web.sc.model.dto.task.TaskStatus;
import com.xinqiyi.systemcenter.web.sc.model.dto.user.UserStoreDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScAdapter {
    private static final Logger log = LoggerFactory.getLogger(ScAdapter.class);
    @Autowired
    private ISensitiveColumnApi iSensitiveColumnApi;
    @Autowired
    private IUserHabitApi iUserHabitApi;
    @Autowired
    private OssFileApi ossFileApi;
    @Autowired
    private IMenuApi iMenuApi;
    @Autowired
    private IRoleApi iRoleApi;
    @Autowired
    private IUserApi iUserApi;
    @Autowired
    private ITaskApi taskApi;
    @Autowired
    private IDictApi dictApi;
    @Autowired
    private DictRedisRepository dictRedisRepository;

    public List<UserFunctionPermissionDTO> checkPermission(String loginFrom) {
        ArrayList<UserFunctionPermissionDTO> userFunctionPermissionDTOList = new ArrayList<UserFunctionPermissionDTO>();
        UserFunctionPermissionDTO userFunctionPermissionDTO = new UserFunctionPermissionDTO();
        userFunctionPermissionDTO.setFunctionType(TableFunctionType.QUERY);
        userFunctionPermissionDTO.setMenuCode("WholesaleOrder");
        userFunctionPermissionDTO.setPlatform(loginFrom);
        userFunctionPermissionDTOList.add(userFunctionPermissionDTO);
        UserFunctionPermissionDTO userFunctionPermissionDTO2 = new UserFunctionPermissionDTO();
        userFunctionPermissionDTO2.setFunctionType(TableFunctionType.QUERY);
        userFunctionPermissionDTO2.setMenuCode("Order");
        userFunctionPermissionDTO2.setPlatform(loginFrom);
        userFunctionPermissionDTOList.add(userFunctionPermissionDTO2);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528sc\u670d\u52a1\uff0c\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u662f\u5426\u6709\u6279\u91c7/\u4ee3\u53d1\u7684\u6743\u9650\uff1a[{}]", userFunctionPermissionDTOList);
        }
        ApiRequest apiRequest = new ApiRequest(userFunctionPermissionDTOList);
        ApiResponse response = this.iMenuApi.checkPermission(apiRequest);
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
        return (List)response.getContent();
    }

    public ApiResponse<RoleDTO> saveStoreRoleRelation(Long storeId, Long sysRoleId) {
        if (log.isDebugEnabled()) {
            log.debug("\u4fdd\u5b58\u5e97\u94fa\u89d2\u8272\u6743\u9650\u5165\u53c2, storeId:{}, sysRoleId:{}", (Object)storeId, (Object)sysRoleId);
        }
        StoreRoleRelationDTO storeRoleRelationDTO = new StoreRoleRelationDTO();
        storeRoleRelationDTO.setStoreId(storeId);
        storeRoleRelationDTO.setSysRoleId(sysRoleId);
        ApiResponse response = this.iRoleApi.saveStoreRoleRelation(storeRoleRelationDTO);
        if (log.isDebugEnabled()) {
            log.debug("\u4fdd\u5b58\u5e97\u94fa\u89d2\u8272\u6743\u9650\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        return response;
    }

    public ApiResponse<Boolean> deleteStoreRoleRelation(Long storeId) {
        if (log.isDebugEnabled()) {
            log.debug("\u5220\u9664\u5e97\u94fa\u89d2\u8272\u6743\u9650\u5165\u53c2, storeId:{}", (Object)storeId);
        }
        StoreRoleRelationDTO storeRoleRelationDTO = new StoreRoleRelationDTO();
        storeRoleRelationDTO.setStoreId(storeId);
        ApiResponse response = this.iRoleApi.deleteStoreRoleRelation(storeRoleRelationDTO);
        if (log.isDebugEnabled()) {
            log.debug("\u5220\u9664\u5e97\u94fa\u89d2\u8272\u6743\u9650\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        return response;
    }

    public ApiResponse<Map<String, List<String>>> selectSensitiveColumnByUserId(Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u654f\u611f\u5217\u6743\u9650\u67e5\u8be2\u5165\u53c2, userId:{}", (Object)userId);
        }
        ApiResponse response = this.iSensitiveColumnApi.selectSensitiveColumnByUserId(userId);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u654f\u611f\u5217\u6743\u9650\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        return response;
    }

    public List<SysTableConfigDto> selectHabitConfig(String tableName, Long userId) {
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u5b9a\u5236\u5217\u67e5\u8be2\u5165\u53c2, userId:{}, tableName:{}", (Object)userId, (Object)tableName);
        }
        ApiResponse response = this.iUserHabitApi.selectHabitConfig(tableName, userId, null, null);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237\u5b9a\u5236\u5217\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        return (List)response.getContent();
    }

    public List<OssUrlVO> generatePreassignedUrl(List<String> urlList) {
        if (CollUtil.isEmpty(urlList)) {
            return CollUtil.newArrayList((Object[])new OssUrlVO[0]);
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData(urlList);
        ApiResponse response = this.ossFileApi.generatePreassignedUrl(apiRequest);
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
        return (List)response.getContent();
    }

    public List<OssUrlVO> generatePreassignedThumbUrl(List<String> urlList, String process) {
        if (CollUtil.isEmpty(urlList)) {
            return CollUtil.newArrayList((Object[])new OssUrlVO[0]);
        }
        OssFileDTO ossFileDTO = new OssFileDTO();
        ossFileDTO.setProcess(process);
        ossFileDTO.setOssFileList(urlList);
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)ossFileDTO);
        ApiResponse response = this.ossFileApi.generatePreassignedThumbUrl(apiRequest);
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
        return (List)response.getContent();
    }

    public List<OssUrlVO> generatePreassignedThumbUrl(List<String> imagList, Integer imageWide, Integer imageHigh) {
        if (ObjectUtil.isNull((Object)imageHigh) || ObjectUtil.isNull((Object)imageHigh)) {
            imageWide = 100;
            imageHigh = 100;
        }
        String process = "image/resize,m_pad,h_" + imageHigh + ",w_" + imageWide;
        return this.generatePreassignedThumbUrl(imagList, process);
    }

    public void createBizMenu(List<BizMenuDTO> bizMenuList) {
        log.info("\u521b\u5efa\u83dc\u5355\u5165\u53c2{}", (Object)JSON.toJSONString(bizMenuList));
        ApiResponse response = this.iMenuApi.createBizMenu(bizMenuList);
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u83dc\u5355\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
    }

    public MenuRespDTO selectBizMenu(List<BizMenuDTO> bizMenuList) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u83dc\u5355\u5165\u53c2{}", (Object)JSON.toJSONString(bizMenuList));
        }
        ApiResponse response = this.iMenuApi.selectBizMenu(bizMenuList);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u83dc\u5355\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
        return (MenuRespDTO)response.getContent();
    }

    public void bindDefaultMallUserStore(UserStoreDTO userStoreDTO) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)userStoreDTO);
        log.info("\u8bbe\u7f6e\u9ed8\u8ba4\u5e97\u94fa\u5165\u53c2{}", (Object)JSON.toJSONString((Object)apiRequest));
        ApiResponse response = this.iUserApi.bindDefaultMallUserStore(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("\u8bbe\u7f6e\u9ed8\u8ba4\u5e97\u94fa\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)response));
        }
        log.info("\u8bbe\u7f6e\u9ed8\u8ba4\u5e97\u94fa\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)response));
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
    }

    public UserVO getUserAccountInfo(Long userId) {
        log.info("\u67e5\u8be2\u7528\u6237\u8d26\u6237\u4fe1\u606f\u5165\u53c2\uff1a {}", (Object)JSON.toJSONString((Object)userId));
        ApiResponse response = this.iUserApi.selectUserById(userId);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u7528\u6237\u8d26\u6237\u4fe1\u606f\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)response));
        }
        log.info("\u67e5\u8be2\u7528\u6237\u8d26\u6237\u4fe1\u606f\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)response));
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc(), (Object[])new Object[0]);
        return (UserVO)response.getContent();
    }

    public void saveTaskDetail(TaskDetailDTO detailDTO) {
        if (log.isDebugEnabled()) {
            log.debug("\u5f02\u6b65\u4efb\u52a1\u660e\u7ec6\u4fdd\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)detailDTO));
        }
        try {
            ApiResponse response = this.taskApi.saveTaskDetail(detailDTO);
            if (log.isDebugEnabled()) {
                log.debug("\u5f02\u6b65\u4efb\u52a1\u660e\u7ec6\u4fdd\u5b58\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5f02\u6b65\u4efb\u52a1\u660e\u7ec6\u4fdd\u5b58\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void updateTask(Long taskId, Long total) {
        TaskSaveDto saveDto = new TaskSaveDto();
        saveDto.setId(taskId);
        saveDto.setTotalRowCount(total);
        saveDto.setStatus(TaskStatus.DOING.name());
        if (log.isDebugEnabled()) {
            log.debug("\u66f4\u65b0\u5f02\u6b65\u4efb\u52a1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)saveDto));
        }
        try {
            ApiResponse response = this.taskApi.updateTask(saveDto);
            if (log.isDebugEnabled()) {
                log.debug("\u66f4\u65b0\u5f02\u6b65\u4efb\u52a1\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5f02\u6b65\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<DictValue> selectDictValueList(String dictCode) {
        return this.dictRedisRepository.selectDictValueListByCode(dictCode);
    }

    public Long saveSyncThirdAppTask(SyncThirdAppTaskDto syncThirdAppTaskDto) {
        try {
            ApiResponse saveResponse = this.taskApi.saveThirdAppSyncTaskInfo(syncThirdAppTaskDto);
            if (saveResponse.isSuccess()) {
                return (Long)saveResponse.getContent();
            }
            return null;
        }
        catch (Exception ex) {
            log.error("saveSyncThirdAppTask.Exception", (Throwable)ex);
            return null;
        }
    }
}

