/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.adapter.sg;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.sg.basic.api.model.vo.SgGoodsOwnerBrandItemApi;
import com.xinqiyi.sg.basic.api.model.vo.SgGoodsOwnerBrandItemCompanyVO;
import com.xinqiyi.sg.basic.api.model.vo.SgGoodsOwnerBrandItemRespVO;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBPhyStorageVO;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageCostVo;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageQueryVo;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgStorageOutDepartmentQueryVO;
import com.xinqiyi.sg.basic.api.model.vo.storage.effective.SgBStorageEffectiveBatchVo;
import com.xinqiyi.sg.basic.model.dto.SgGoodsOwnerBrandItemQueryDTO;
import com.xinqiyi.sg.basic.model.dto.SgGoodsOwnerBrandItemReqDTO;
import com.xinqiyi.sg.basic.model.dto.report.SgBPhyOutResultDeptSumReportDto;
import com.xinqiyi.sg.basic.model.dto.report.SgBPhyOutResultDeptSumReportVo;
import com.xinqiyi.sg.basic.model.dto.report.SgBPhyStorageReportVo;
import com.xinqiyi.sg.basic.model.dto.report.SgBPhyStorageSumReportDto;
import com.xinqiyi.sg.basic.model.dto.report.SgBPhyStorageSumReportVo;
import com.xinqiyi.sg.basic.model.dto.storage.SgStorageHaveDto;
import com.xinqiyi.sg.basic.model.dto.storage.SgStorageOcQueryDto;
import com.xinqiyi.sg.basic.model.dto.storage.SgStorageOutQueryDto;
import com.xinqiyi.sg.basic.model.dto.storage.SgStorageQueryDto;
import com.xinqiyi.sg.basic.model.dto.storageeffective.SgStorageEffectiveQueryDto;
import com.xinqiyi.sg.itface.api.SgWarehouseInfoApi;
import com.xinqiyi.sg.itface.api.model.vo.SgWarehouseVo;
import com.xinqiyi.sg.itface.api.storage.SgStorageApi;
import com.xinqiyi.sg.itface.api.storage.SgStorageEffectiveApi;
import com.xinqiyi.sg.itface.api.storage.SgStorageOutQueryApi;
import com.xinqiyi.sg.itface.model.dto.SgWarehouseQueryDTO;
import com.xinqiyi.sg.itface.model.dto.storage.SgStorageCostDto;
import com.xinqiyi.sg.warehouse.api.SgOutReportApi;
import com.xinqiyi.sg.wms.api.in.SgWmsApi;
import com.xinqiyi.sg.wms.model.dto.SgErpSkuGetDto;
import com.xinqiyi.sg.wms.model.dto.SgSingleItemSynchronizeDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SgStorageQueryAdapter {
    private static final Logger log = LoggerFactory.getLogger(SgStorageQueryAdapter.class);
    private final SgStorageOutQueryApi sgStorageOutQueryApi;
    private final SgOutReportApi sgOutReportApi;
    private final SgStorageApi sgStorageApi;
    private final MdmAdapter mdmAdapter;
    private final SgWmsApi sgWmsApi;
    private final SgWarehouseInfoApi sgWarehouseInfoApi;
    private final SgGoodsOwnerBrandItemApi sgGoodsOwnerBrandItemApi;
    private final SgStorageEffectiveApi sgStorageEffectiveApi;

    public ApiResponse<List<SgStorageOutDepartmentQueryVO>> queryStorageOutByDepartment(Long mdmDeptId, List<String> skuCodeList) {
        if (log.isDebugEnabled()) {
            log.debug("\u90e8\u95e8\u51fa\u5e93\u91cf\u67e5\u8be2\u5165\u53c2, mdmDeptId:{}, skuCodeList:{}", (Object)mdmDeptId, (Object)(CollectionUtils.isEmpty(skuCodeList) ? null : JSON.toJSONString(skuCodeList)));
        }
        SgStorageOutQueryDto queryDto = new SgStorageOutQueryDto();
        queryDto.setMdmDeptId(mdmDeptId);
        queryDto.setSkuCodeList(skuCodeList);
        ApiResponse response = this.sgStorageOutQueryApi.queryStorageOutByDepartment(new ApiRequest((Object)queryDto));
        if (log.isDebugEnabled()) {
            log.debug("\u90e8\u95e8\u51fa\u5e93\u91cf\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        return response;
    }

    public ApiResponse<List<SgBPhyOutResultDeptSumReportVo>> queryBPhyOutResultDeptSumReport(Long mdmDeptId, List<String> skuCodeList) {
        if (log.isDebugEnabled()) {
            log.debug("\u90e8\u95e8\u51fa\u5e93\u91cf\u67e5\u8be2\u5165\u53c2, mdmDeptId:{}, skuCodeList:{}", (Object)mdmDeptId, (Object)(CollectionUtils.isEmpty(skuCodeList) ? null : JSON.toJSONString(skuCodeList)));
        }
        SgBPhyOutResultDeptSumReportDto queryDto = new SgBPhyOutResultDeptSumReportDto();
        queryDto.setMdmDeptId(mdmDeptId);
        queryDto.setSkuEcodeList(skuCodeList);
        ApiResponse response = this.sgOutReportApi.queryBPhyOutResultDeptSumReport(new ApiRequest((Object)queryDto));
        if (log.isDebugEnabled()) {
            log.debug("\u90e8\u95e8\u51fa\u5e93\u91cf\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        return response;
    }

    public List<SgBStorageCostVo> selectCostByWarehoseAndSku(List<String> skuCodeList) {
        if (log.isDebugEnabled()) {
            log.debug("\u6210\u672c\u4ef7\u67e5\u8be2\u5165\u53c2, skuCodeList:{}", (Object)(CollectionUtils.isEmpty(skuCodeList) ? null : JSON.toJSONString(skuCodeList)));
        }
        SystemConfigVO systemConfigVO = this.mdmAdapter.queryBySystemConfigKeyCode("STORAGE_CODE");
        SgStorageCostDto queryDto = new SgStorageCostDto();
        if (systemConfigVO != null) {
            queryDto.setWarehouseCode(systemConfigVO.getValue());
        }
        queryDto.setSkuCodes(skuCodeList);
        ApiResponse response = this.sgStorageApi.selectCostByWarehoseAndSku(queryDto);
        if (log.isDebugEnabled()) {
            log.debug("\u6210\u672c\u4ef7\u67e5\u8be2\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (List)response.getContent();
    }

    public List<SgBStorageCostVo> selectCostByWarehoseAndSkuMost(List<String> skuCodeList) {
        if (log.isDebugEnabled()) {
            log.debug("\u6210\u672c\u4ef7\u67e5\u8be2\u5165\u53c2, skuCodeList:{}", (Object)(CollectionUtils.isEmpty(skuCodeList) ? null : JSON.toJSONString(skuCodeList)));
        }
        SystemConfigVO systemConfigVO = this.mdmAdapter.queryBySystemConfigKeyCode("STORAGE_CODE");
        SgStorageCostDto queryDto = new SgStorageCostDto();
        if (systemConfigVO != null) {
            queryDto.setWarehouseCode(systemConfigVO.getValue());
        }
        queryDto.setSkuCodes(skuCodeList);
        ApiResponse response = this.sgStorageApi.selectCostByWarehoseAndSku(queryDto);
        if (log.isDebugEnabled()) {
            log.debug("\u6210\u672c\u4ef7\u67e5\u8be2\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (List)response.getContent();
    }

    public List<SgBStorageCostVo> selectCostByWarehouseCodeAndSku(String phyWarehouseCode, List<String> skuCodeList) {
        if (log.isDebugEnabled()) {
            log.debug("\u7ec4\u5408\u5546\u54c1\u6210\u672c\u4ef7\u67e5\u8be2\u5165\u53c2, skuCodeList:{}, phyWarehouseCode:{}", (Object)(CollectionUtils.isEmpty(skuCodeList) ? null : JSON.toJSONString(skuCodeList)), (Object)phyWarehouseCode);
        }
        SgStorageCostDto queryDto = new SgStorageCostDto();
        queryDto.setWarehouseCode(phyWarehouseCode);
        queryDto.setSkuCodes(skuCodeList);
        ApiResponse response = this.sgStorageApi.selectCostByWarehoseAndSku(queryDto);
        if (log.isDebugEnabled()) {
            log.debug("\u6210\u672c\u4ef7\u67e5\u8be2\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (List)response.getContent();
    }

    public Boolean haveStorage(String skuCode) {
        SgStorageHaveDto sgStorageHaveDto = new SgStorageHaveDto();
        sgStorageHaveDto.setSkuCode(skuCode);
        ApiResponse response = this.sgStorageApi.haveStorage(sgStorageHaveDto);
        if (log.isDebugEnabled()) {
            log.debug("\u662f\u5426\u6709\u5e93\u5b58\u67e5\u8be2\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (Boolean)response.getContent();
    }

    public ApiResponse<Object> singleItemSynchronize(SgSingleItemSynchronizeDto sgSingleItemSynchronizeDto) {
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)sgSingleItemSynchronizeDto));
        }
        ApiResponse apiResponse = this.sgWmsApi.singleItemSynchronize(sgSingleItemSynchronizeDto);
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u540c\u6b65\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        return apiResponse;
    }

    public ApiResponse<String> syncWmsSku(SgErpSkuGetDto dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u540c\u6b65wms\u5546\u54c1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiResponse apiResponse = this.sgWmsApi.wmsSingleItemQuery(dto);
        if (log.isDebugEnabled()) {
            log.debug("\u540c\u6b65wms\u5546\u54c1\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)("\u540c\u6b65wms\u5546\u54c1\u5931\u8d25:" + apiResponse.getDesc()));
        return apiResponse;
    }

    public ApiResponse<List<SgBPhyStorageVO>> queryPhyStorage(SgStorageQueryDto sgStorageQueryDto) {
        ApiResponse apiResponse = this.sgStorageApi.queryPhyStorage(sgStorageQueryDto);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        return apiResponse;
    }

    public ApiResponse<List<SgBStorageQueryVo>> queryStorageIncludePriceCost(SgStorageOcQueryDto sgStorageQueryDto) {
        ApiResponse apiResponse = this.sgStorageApi.queryStorageIncludePriceCost(sgStorageQueryDto);
        if (log.isDebugEnabled()) {
            log.info("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        return apiResponse;
    }

    public ApiResponse<List<SgBStorageQueryVo>> queryStorageIncludePriceCostNoPermission(SgStorageOcQueryDto sgStorageQueryDto) {
        ApiResponse apiResponse = this.sgStorageApi.queryStorageIncludePriceCostNoPermission(sgStorageQueryDto);
        if (log.isDebugEnabled()) {
            log.info("\u67e5\u8be2\u5546\u54c1\u5e93\u5b58\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)apiResponse));
        }
        return apiResponse;
    }

    public ApiResponse<List<SgBPhyStorageSumReportVo>> queryBPhyStorageSumReport(SgBPhyStorageSumReportDto dto) {
        if (log.isDebugEnabled()) {
            log.debug("sku\u5b9e\u65f6\u5e93\u5b58\u91cf\u67e5\u8be2\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)dto);
        ApiResponse response = this.sgOutReportApi.queryBPhyStorageSumReport(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("sku\u5b9e\u65f6\u5e93\u5b58\u91cf\u67e5\u8be2\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)("\u67e5\u8be2\u5e73\u5747\u51fa\u5e93\u91cf\u5931\u8d25:" + response.getDesc()));
        return response;
    }

    public List<SgBPhyStorageReportVo> queryPhyStorageByType(SgBPhyStorageSumReportDto dto) {
        if (log.isDebugEnabled()) {
            log.debug("sku\u5b9e\u65f6\u5e93\u5b58\u91cf\u67e5\u8be2\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setJsonData((Object)dto);
        ApiResponse response = this.sgOutReportApi.queryPhyStorageByType(apiRequest);
        if (log.isDebugEnabled()) {
            log.debug("sku\u5b9e\u65f6\u5e93\u5b58\u91cf\u67e5\u8be2\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)response));
        }
        if (null == response) {
            throw new IllegalArgumentException("\u67e5\u8be2\u51fa\u5e93\u91cf\u4fe1\u606f\u5931\u8d25");
        }
        if (!response.isSuccess()) {
            throw new IllegalArgumentException(response.getDesc());
        }
        return (List)response.getContent();
    }

    public List<SgBStorageQueryVo> queryStorageByRange(SgStorageOcQueryDto dto) {
        if (log.isDebugEnabled()) {
            log.debug("sku\u5b9e\u65f6\u5e93\u5b58\u91cf\u67e5\u8be2\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)dto));
        }
        ApiResponse response = this.sgStorageApi.queryStorageByRange(dto);
        if (log.isDebugEnabled()) {
            log.debug("sku\u5b9e\u65f6\u5e93\u5b58\u91cf\u67e5\u8be2\u63a5\u53e3:{}", (Object)JSON.toJSONString((Object)response));
        }
        if (null == response) {
            throw new IllegalArgumentException("\u67e5\u8be2\u51fa\u5e93\u91cf\u4fe1\u606f\u5931\u8d25");
        }
        if (!response.isSuccess()) {
            throw new IllegalArgumentException(response.getDesc());
        }
        return (List)response.getContent();
    }

    public List<SgWarehouseVo> batchQueryById(List<Long> ids) {
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53\u4ed3\u5165\u53c2:{}", ids);
        }
        SgWarehouseQueryDTO queryDTO = new SgWarehouseQueryDTO();
        queryDTO.setIds(ids);
        ApiResponse response = this.sgWarehouseInfoApi.batchQueryById(queryDTO);
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53\u4ed3\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        if (response.isSuccess()) {
            return JSON.parseArray((String)JSON.toJSONString((Object)response.getContent()), SgWarehouseVo.class);
        }
        throw new IllegalArgumentException("\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53\u4ed3\u5931\u8d25:" + response.getDesc());
    }

    @Deprecated
    public List<SgGoodsOwnerBrandItemRespVO> getSupplyCompany(List<Long> psBrandIds, Long collectingCompanyId) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u4f9b\u8d27\u516c\u53f8\u5165\u53c2:psBrandIds: {}, collectingId: {}", (Object)JSON.toJSONString(psBrandIds), (Object)collectingCompanyId);
        }
        if (CollUtil.isEmpty(psBrandIds) || ObjectUtil.isNull((Object)collectingCompanyId)) {
            return null;
        }
        SgGoodsOwnerBrandItemQueryDTO dto = new SgGoodsOwnerBrandItemQueryDTO();
        ArrayList items = new ArrayList();
        psBrandIds.forEach(psBrandId -> {
            SgGoodsOwnerBrandItemReqDTO sgGoodsOwnerBrandItemReqDTO = new SgGoodsOwnerBrandItemReqDTO();
            sgGoodsOwnerBrandItemReqDTO.setMdmCompanyId(collectingCompanyId);
            sgGoodsOwnerBrandItemReqDTO.setPsBrandId(psBrandId);
            items.add(sgGoodsOwnerBrandItemReqDTO);
        });
        dto.setReqParam(items);
        ApiResponse response = this.sgGoodsOwnerBrandItemApi.queryCompanyPsBrand(dto);
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u4f9b\u8d27\u516c\u53f8\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (List)response.getContent();
    }

    @Deprecated
    public Map<Long, SgGoodsOwnerBrandItemCompanyVO> getSupplyCompanyMap(List<Long> psBrandIds, Long collectingId) {
        List<SgGoodsOwnerBrandItemRespVO> supplyCompany = this.getSupplyCompany(psBrandIds, collectingId);
        if (CollUtil.isEmpty(supplyCompany)) {
            return Maps.newHashMap();
        }
        return supplyCompany.stream().filter(it -> Objects.nonNull(it.getCompanyVO()) && Objects.nonNull(it.getPsBrandId())).collect(Collectors.toMap(SgGoodsOwnerBrandItemRespVO::getPsBrandId, SgGoodsOwnerBrandItemRespVO::getCompanyVO));
    }

    public List<SgBStorageEffectiveBatchVo> queryStorageEffectiveBySku(SgStorageEffectiveQueryDto queryDto) {
        if (log.isDebugEnabled()) {
            log.debug("\u6279\u6b21\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        }
        ApiResponse response = this.sgStorageEffectiveApi.queryStorageEffectiveBySku(queryDto);
        if (log.isDebugEnabled()) {
            log.debug("\u6279\u6b21\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        Assert.isTrue((boolean)response.isSuccess(), (String)response.getDesc());
        return (List)response.getContent();
    }

    public SgStorageQueryAdapter(SgStorageOutQueryApi sgStorageOutQueryApi, SgOutReportApi sgOutReportApi, SgStorageApi sgStorageApi, MdmAdapter mdmAdapter, SgWmsApi sgWmsApi, SgWarehouseInfoApi sgWarehouseInfoApi, SgGoodsOwnerBrandItemApi sgGoodsOwnerBrandItemApi, SgStorageEffectiveApi sgStorageEffectiveApi) {
        this.sgStorageOutQueryApi = sgStorageOutQueryApi;
        this.sgOutReportApi = sgOutReportApi;
        this.sgStorageApi = sgStorageApi;
        this.mdmAdapter = mdmAdapter;
        this.sgWmsApi = sgWmsApi;
        this.sgWarehouseInfoApi = sgWarehouseInfoApi;
        this.sgGoodsOwnerBrandItemApi = sgGoodsOwnerBrandItemApi;
        this.sgStorageEffectiveApi = sgStorageEffectiveApi;
    }
}

