/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.cus.vo.CustomerVO;
import com.xinqiyi.fc.model.enums.FcCommonEnum;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginFrom;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.security.encrypt.config.EncryptConfig;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.AesUtil;
import com.xinqiyi.nc.model.dto.MessageInfo;
import com.xinqiyi.nc.model.dto.MessageRecordDTO;
import com.xinqiyi.ps.dao.repository.PsArrivalNotificationRecordsService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.enums.ArrivalNoticeSourceEnum;
import com.xinqiyi.ps.model.dto.enums.ArrivalNoticeStatus;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.ps.model.dto.spu.PhyStorageDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.store.PsArrivalNotificationRecordDTO;
import com.xinqiyi.ps.model.entity.PsArrivalNotificationRecord;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.service.adapter.NcAdapter;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.PhyStorageBiz;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.StringUtil;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.user.UserVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="arrivalNotificationRecordBiz")
public class ArrivalNotificationRecordBiz {
    private static final Logger log = LoggerFactory.getLogger(ArrivalNotificationRecordBiz.class);
    private final PsArrivalNotificationRecordsService arrivalNotificationRecordsService;
    private final ScAdapter scAdapter;
    private final GateWayWebAuthService gateWayWebAuthService;
    private final CusAdapter cusAdapter;
    private final EncryptConfig propertyConfig;
    private final StoreService storeService;
    private final SkuService skuService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final PhyStorageBiz phyStorageBiz;
    private final NcAdapter sendNcMsgHandler;
    private final IdSequenceGenerator idSequenceGenerator;

    public void save(PsArrivalNotificationRecordDTO arrivalNotificationRecordDTO) {
        Store store;
        if (arrivalNotificationRecordDTO.getPsStoreId() == null && (store = (Store)this.storeService.getOne((Wrapper)new QueryWrapper().lambda().eq(Store::getIsDefault, (Object)FcCommonEnum.YesOrNoStrEnum.YES.getValue()), false)) != null) {
            arrivalNotificationRecordDTO.setPsStoreId(store.getId());
        }
        Long skuId = arrivalNotificationRecordDTO.getSkuId();
        Long psStoreId = arrivalNotificationRecordDTO.getPsStoreId();
        String phone = arrivalNotificationRecordDTO.getNoticePhone();
        String source = arrivalNotificationRecordDTO.getSource();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)source), (String)"\u5546\u54c1\u6765\u6e90\u4e0d\u5f97\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)phone), (String)"\u901a\u77e5\u624b\u673a\u53f7\u4e0d\u5f97\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isValidPhoneNumber(phone), (String)"\u624b\u673a\u53f7\u683c\u5f0f\u6709\u8bef");
        Assert.notNull((Object)psStoreId, (String)"psStoreId\u4e0d\u5f97\u4e3a\u7a7a");
        Assert.notNull((Object)skuId, (String)"skuId\u4e0d\u5f97\u4e3a\u7a7a");
        Store store2 = (Store)this.storeService.getById((Serializable)psStoreId);
        Assert.notNull((Object)store2, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        Sku sku = (Sku)this.skuService.getById((Serializable)skuId);
        Assert.notNull((Object)sku, (String)"sku\u4e0d\u5b58\u5728");
        LoginUserInfo loginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Long customerId = loginUserInfo.getCustomerId();
        PsArrivalNotificationRecord recordInDb = this.getRecordInDb(arrivalNotificationRecordDTO, customerId);
        if (recordInDb == null) {
            this.buildCustomerInfo(customerId, arrivalNotificationRecordDTO);
            PsArrivalNotificationRecord notificationRecord = new PsArrivalNotificationRecord();
            BeanUtils.copyProperties((Object)arrivalNotificationRecordDTO, (Object)notificationRecord);
            notificationRecord.setOperateSource(this.getOperateSource(loginUserInfo.getLoginFrom()));
            notificationRecord.setStoreName(store2.getName());
            notificationRecord.setSkuCode(sku.getCode());
            notificationRecord.setSkuName(sku.getName());
            notificationRecord.setSpuId(sku.getPsSpuId());
            notificationRecord.setNoticeStatus(ArrivalNoticeStatus.UN_NOTICE.getCode());
            notificationRecord.setId(this.idSequenceGenerator.generateId(PsArrivalNotificationRecord.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)notificationRecord);
            this.arrivalNotificationRecordsService.save((Object)notificationRecord);
        } else if (!recordInDb.getOperateSource().equals(this.getOperateSource(loginUserInfo.getLoginFrom()))) {
            recordInDb.setOperateSource(this.getOperateSource(loginUserInfo.getLoginFrom()));
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)recordInDb);
            this.arrivalNotificationRecordsService.saveOrUpdate((Object)recordInDb);
        }
    }

    private Integer getOperateSource(LoginFrom loginFrom) {
        if (loginFrom == null) {
            return null;
        }
        switch (loginFrom) {
            case xqy_mall_pc: {
                return ArrivalNoticeSourceEnum.PC.getCode();
            }
            case xqy_mall_miniapp: {
                return ArrivalNoticeSourceEnum.WECHAT.getCode();
            }
        }
        return null;
    }

    private void buildCustomerInfo(Long customerId, PsArrivalNotificationRecordDTO arrivalNotificationRecordDTO) {
        if (customerId == null) {
            return;
        }
        ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(customerId);
        Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
        Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        CustomerVO customerVO = (CustomerVO)customerVOApiResponse.getContent();
        arrivalNotificationRecordDTO.setCusCustomerId(customerVO.getId());
        arrivalNotificationRecordDTO.setCusCustomerCode(customerVO.getCustomerCode());
        arrivalNotificationRecordDTO.setCusCustomerName(customerVO.getCustomerName());
    }

    private PsArrivalNotificationRecord getRecordInDb(PsArrivalNotificationRecordDTO dto, Long customerId) {
        if (dto.getPsStoreId() == null || dto.getSource() == null || dto.getSkuId() == null || StringUtils.isBlank((CharSequence)dto.getNoticePhone())) {
            return null;
        }
        return (PsArrivalNotificationRecord)this.arrivalNotificationRecordsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PsArrivalNotificationRecord.class).eq(PsArrivalNotificationRecord::getPsStoreId, (Object)dto.getPsStoreId())).eq(PsArrivalNotificationRecord::getSource, (Object)dto.getSource())).eq(PsArrivalNotificationRecord::getSkuId, (Object)dto.getSkuId())).eq(Objects.nonNull(customerId), PsArrivalNotificationRecord::getCusCustomerId, (Object)customerId)).eq(PsArrivalNotificationRecord::getNoticePhone, (Object)AesUtil.encryptMysql((String)dto.getNoticePhone(), (String)this.propertyConfig.getKey()))).eq(PsArrivalNotificationRecord::getNoticeStatus, (Object)ArrivalNoticeStatus.UN_NOTICE.getCode())).last("LIMIT 1"));
    }

    public void sendMsg() {
        List list = this.arrivalNotificationRecordsService.list((Wrapper)Wrappers.lambdaQuery(PsArrivalNotificationRecord.class).eq(PsArrivalNotificationRecord::getNoticeStatus, (Object)ArrivalNoticeStatus.UN_NOTICE.getCode()));
        Map<Long, List<PsArrivalNotificationRecord>> storeIdListMap = list.stream().collect(Collectors.groupingBy(PsArrivalNotificationRecord::getPsStoreId));
        if (CollUtil.isEmpty(storeIdListMap)) {
            return;
        }
        Set<Long> storeIds = storeIdListMap.keySet();
        List stores = this.storeService.listByIds(storeIds);
        for (Store store : stores) {
            List<PsArrivalNotificationRecord> psArrivalNotificationRecords = storeIdListMap.get(store.getId());
            if (CollUtil.isEmpty(psArrivalNotificationRecords)) continue;
            Map<String, List<PsArrivalNotificationRecord>> sourceListMap = psArrivalNotificationRecords.stream().collect(Collectors.groupingBy(PsArrivalNotificationRecord::getSource));
            List<PsArrivalNotificationRecord> dfArrivalNotificationRecords = sourceListMap.get(SupplyPriceTypeEnums.TWO.getCode());
            if (StringUtils.equalsIgnoreCase((CharSequence)store.getIsDfDisplayInventory(), (CharSequence)YesOrNoEnum.NO.getCode())) {
                this.sendArrivalNotifyMsg(dfArrivalNotificationRecords);
            } else {
                List<PsArrivalNotificationRecord> availableSendRecords = this.queryAvailableQty(dfArrivalNotificationRecords, store.getIssuingInventoryIds(), store.getDfAvailableRatio(), store.getDfLogicIds());
                this.sendArrivalNotifyMsg(availableSendRecords);
            }
            List<PsArrivalNotificationRecord> pcArrivalNotificationRecords = sourceListMap.get(SupplyPriceTypeEnums.ONE.getCode());
            if (StringUtils.equalsIgnoreCase((CharSequence)store.getIsDisplayInventory(), (CharSequence)YesOrNoEnum.NO.getCode())) {
                this.sendArrivalNotifyMsg(pcArrivalNotificationRecords);
            } else {
                List<PsArrivalNotificationRecord> availableSendRecords = this.queryAvailableQty(pcArrivalNotificationRecords, store.getWholesaleInventoryIds(), store.getAvailableInventoryProportion(), store.getPcLogicIds());
                this.sendArrivalNotifyMsg(availableSendRecords);
            }
            storeIdListMap.remove(store.getId());
        }
    }

    private List<PsArrivalNotificationRecord> queryAvailableQty(List<PsArrivalNotificationRecord> sendMsgBySkuArrivalList, String warehouseIdStr, BigDecimal availableRatio, String logicStr) {
        ArrayList<PsArrivalNotificationRecord> result = new ArrayList<PsArrivalNotificationRecord>();
        if (CollUtil.isEmpty(sendMsgBySkuArrivalList) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{warehouseIdStr, logicStr}) || availableRatio == null) {
            return result;
        }
        Map<Long, List<PsArrivalNotificationRecord>> skuIdListMap = sendMsgBySkuArrivalList.stream().collect(Collectors.groupingBy(PsArrivalNotificationRecord::getSkuId));
        Set<Long> psSkuIdList = skuIdListMap.keySet();
        List warehouseIds = Arrays.stream(warehouseIdStr.split(",")).map(Long::parseLong).collect(Collectors.toList());
        List logicWarehouseIds = Arrays.stream(logicStr.split(",")).map(Long::parseLong).collect(Collectors.toList());
        SpuQueryDTO spuQueryDTO = new SpuQueryDTO();
        spuQueryDTO.setSkuIdList(new ArrayList<Long>(psSkuIdList));
        spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
        spuQueryDTO.setWarehouseIds(warehouseIds);
        spuQueryDTO.setStoreIds(logicWarehouseIds);
        List<PhyStorageDTO> phyStorageDTOList = this.getAllPhyStorage(spuQueryDTO, 9999999);
        if (CollUtil.isEmpty(phyStorageDTOList)) {
            return result;
        }
        skuIdListMap.forEach((skuId, list) -> {
            BigDecimal totalQtyAvailable = phyStorageDTOList.stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)skuId)).map(PhyStorageDTO::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal qtyAvailable = totalQtyAvailable.multiply(availableRatio).divide(new BigDecimal("100"), 0, RoundingMode.DOWN);
            if (BigDecimalUtils.greaterEqual(qtyAvailable, new BigDecimal("1"))) {
                result.addAll((Collection<PsArrivalNotificationRecord>)list);
            }
        });
        return result;
    }

    public List<PhyStorageDTO> getAllPhyStorage(SpuQueryDTO spuQueryDTO, int pageSize) {
        ArrayList<PhyStorageDTO> result = new ArrayList<PhyStorageDTO>();
        spuQueryDTO.setPageSize(pageSize);
        spuQueryDTO.setPageNum(1);
        Page<PhyStorageDTO> phyStorageDTOPage = new Page<PhyStorageDTO>();
        while ((phyStorageDTOPage = this.queryPhyStoragePage(spuQueryDTO)) != null && !CollUtil.isEmpty((Collection)phyStorageDTOPage.getRecords())) {
            result.addAll(phyStorageDTOPage.getRecords());
            spuQueryDTO.setPageNum((int)phyStorageDTOPage.getCurrent() + 1);
            if ((double)spuQueryDTO.getPageNum() <= Math.ceil((double)phyStorageDTOPage.getTotal() / (double)pageSize)) continue;
        }
        return result;
    }

    private Page<PhyStorageDTO> queryPhyStoragePage(SpuQueryDTO spuQueryDTO) {
        ApiRequest request = new ApiRequest();
        request.setJsonData((Object)spuQueryDTO);
        return this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
    }

    public void sendArrivalNotifyMsg(List<PsArrivalNotificationRecord> records) {
        if (CollUtil.isEmpty(records)) {
            return;
        }
        ArrayList messageInfoList = Lists.newArrayList();
        for (PsArrivalNotificationRecord record : records) {
            this.buildMessageDTO(messageInfoList, record);
            record.setNoticeStatus(ArrivalNoticeStatus.NOTICED.getCode());
            record.setNoticeSendTime(new Date());
        }
        if (CollUtil.isNotEmpty((Collection)messageInfoList)) {
            MessageRecordDTO messageRecordDTO = new MessageRecordDTO();
            messageRecordDTO.setMessageInfoList((List)messageInfoList);
            messageRecordDTO.setMsgCode("SEND_MSG_FOR_ARRIVAL_NOTICE");
            try {
                this.sendNcMsgHandler.sendMsgByNC(messageRecordDTO);
                this.arrivalNotificationRecordsService.saveOrUpdateBatch(records);
            }
            catch (Exception e) {
                log.info("\u5230\u8d27\u901a\u77e5\u53d1\u9001\u5931\u8d25\uff0crecord:{}, e:{}", (Object)JSON.toJSONString(records), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private void buildMessageDTO(List<MessageInfo> messageInfoList, PsArrivalNotificationRecord record) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMobileList(Collections.singletonList(record.getNoticePhone()));
        messageInfo.setTitle("\u5230\u8d27\u901a\u77e5");
        HashMap stringListMap = new HashMap();
        ArrayList<String> phoneSms = new ArrayList<String>();
        phoneSms.add(record.getSkuName());
        stringListMap.put(record.getNoticePhone(), phoneSms);
        messageInfo.setContent(JSON.toJSONString(phoneSms));
        messageInfoList.add(messageInfo);
    }

    public String queryLoginUserPhone() {
        LoginUserInfo loginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        long userId = loginUserInfo.getUserId();
        PsArrivalNotificationRecord lastRecord = (PsArrivalNotificationRecord)this.arrivalNotificationRecordsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PsArrivalNotificationRecord.class).eq(BaseDo::getCreateUserId, (Object)userId)).orderByDesc(BaseDo::getId)).last("LIMIT 1"));
        if (lastRecord != null) {
            return lastRecord.getNoticePhone();
        }
        UserVO customerAccountInfo = this.scAdapter.getUserAccountInfo(userId);
        if (customerAccountInfo == null) {
            return null;
        }
        String wxPhone = customerAccountInfo.getWxPhone();
        if (StringUtils.isNotBlank((CharSequence)wxPhone)) {
            return wxPhone;
        }
        return customerAccountInfo.getPhone();
    }

    public ArrivalNotificationRecordBiz(PsArrivalNotificationRecordsService arrivalNotificationRecordsService, ScAdapter scAdapter, GateWayWebAuthService gateWayWebAuthService, CusAdapter cusAdapter, EncryptConfig propertyConfig, StoreService storeService, SkuService skuService, BaseDaoInitialService baseDaoInitialService, PhyStorageBiz phyStorageBiz, NcAdapter sendNcMsgHandler, IdSequenceGenerator idSequenceGenerator) {
        this.arrivalNotificationRecordsService = arrivalNotificationRecordsService;
        this.scAdapter = scAdapter;
        this.gateWayWebAuthService = gateWayWebAuthService;
        this.cusAdapter = cusAdapter;
        this.propertyConfig = propertyConfig;
        this.storeService = storeService;
        this.skuService = skuService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.phyStorageBiz = phyStorageBiz;
        this.sendNcMsgHandler = sendNcMsgHandler;
        this.idSequenceGenerator = idSequenceGenerator;
    }
}

