/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.xinqiyi.cus.model.dto.customer.CustomerOrderConfigureDetailsDTO;
import com.xinqiyi.dynamicform.dao.repository.DictRedisRepository;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.fc.api.model.vo.ar.FcArExpenseVO;
import com.xinqiyi.fc.model.dto.ar.ArExpenseQueryDTO;
import com.xinqiyi.fc.model.enums.FcCommonEnum;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginFrom;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.datapermission.util.DataPermissionUtil;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.model.search.CommonSearchRequest;
import com.xinqiyi.framework.mq.util.MqProducerHelper;
import com.xinqiyi.framework.sequence.DistributedSequenceGenerator;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.sequence.model.CycleType;
import com.xinqiyi.framework.sequence.model.SequenceInfo;
import com.xinqiyi.mdm.api.model.vo.platform.MdmPlatformVO;
import com.xinqiyi.mdm.api.model.vo.salesman.SalesmanVO;
import com.xinqiyi.ps.api.model.vo.BrandVO;
import com.xinqiyi.ps.api.model.vo.StoreBrandFocusVO;
import com.xinqiyi.ps.api.model.vo.StoreBrandRecommendVO;
import com.xinqiyi.ps.api.model.vo.spu.BrandSubscribeForLiteAppVO;
import com.xinqiyi.ps.api.model.vo.spu.BrandSubscribeVO;
import com.xinqiyi.ps.dao.repository.BrandChannelService;
import com.xinqiyi.ps.dao.repository.BrandClassService;
import com.xinqiyi.ps.dao.repository.BrandLabelService;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.StoreBrandFocusService;
import com.xinqiyi.ps.dao.repository.StoreBrandRecommendService;
import com.xinqiyi.ps.dao.repository.StoreBrandSortService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.brand.BrandDFDTO;
import com.xinqiyi.ps.model.dto.brand.BrandDTO;
import com.xinqiyi.ps.model.dto.brand.BrandMiniAppQueryDTO;
import com.xinqiyi.ps.model.dto.brand.BrandPageDTO;
import com.xinqiyi.ps.model.dto.brand.BrandQueryDTO;
import com.xinqiyi.ps.model.dto.brand.BrandStatusDTO;
import com.xinqiyi.ps.model.dto.enums.ChannelTypeEnum;
import com.xinqiyi.ps.model.dto.enums.IsDeleteEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.page.PageResult;
import com.xinqiyi.ps.model.dto.store.brandFocus.StoreBrandFocusQueryDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.BrandChannel;
import com.xinqiyi.ps.model.entity.BrandClass;
import com.xinqiyi.ps.model.entity.BrandLabel;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.model.entity.StoreBrandRecommend;
import com.xinqiyi.ps.model.entity.StoreBrandSort;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.fc.FcArExpenseAdapter;
import com.xinqiyi.ps.service.adapter.mall4j.MallFourJAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.SkuShelfBiz;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import com.xinqiyi.ps.service.exception.PsException;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.CamelTransformUnderlineUtils;
import com.xinqiyi.ps.service.util.ParameterColumnHandler;
import com.xinqiyi.ps.service.util.StringUtil;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import com.xinqiyi.systemcenter.web.sc.permssion.model.SelectMindDataResponse;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BrandBiz {
    private static final Logger log = LoggerFactory.getLogger(BrandBiz.class);
    private final BrandService brandService;
    private final BrandLabelService brandLabelService;
    private final BrandChannelService brandChannelService;
    private final StoreBrandFocusService storeBrandFocusService;
    private final StoreBrandRecommendService storeBrandRecommendService;
    private final StoreService storeService;
    private final DistributedSequenceGenerator distributedSequenceGenerator;
    private final IdSequenceGenerator idSequence;
    private final BaseDaoInitialService baseDaoInitialService;
    private final MdmAdapter mdmAdapter;
    private final ScAdapter scAdapter;
    private final SpuService spuService;
    private final BrandClassService brandClassService;
    private final MqProducerHelper mqProducerHelper;
    private final CusAdapter cusAdapter;
    private final GateWayWebAuthService gateWayWebAuthService;
    private final MallFourJAdapter mallFourJAdapter;
    private final FcArExpenseAdapter fcArExpenseAdapter;
    private final DictRedisRepository dictRedisRepository;
    private final UserInfoUtil userInfoUtil;
    private final SkuShelfBiz skuShelfBiz;
    private final StoreBrandSortService storeBrandSortService;
    private static final List<String> COLUMN_LIST = BrandBiz.getColumnList();

    private static List<String> getColumnList() {
        return Arrays.asList("name", "code");
    }

    public Long saveBrand(BrandDTO brandDTO) {
        this.checkBrand(brandDTO);
        Brand brand = new Brand();
        BeanUtils.copyProperties((Object)brandDTO, (Object)brand);
        brand.setStatus(Integer.valueOf(1));
        if (StringUtils.isEmpty((CharSequence)brandDTO.getCode())) {
            brand.setCode(this.getBrandCode());
        }
        brand.setId(this.idSequence.generateId(Brand.class));
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)brand);
        brand.setFirstLetter(this.processBrandFirstLetter(brand.getName()));
        brand.setCountryFirstLetter(this.processBrandFirstLetter(brand.getCountryName()));
        List<BrandLabel> brandLabels = this.generateBrandLabel(brand.getId(), brandDTO.getBrandLabelList());
        List<BrandChannel> brandChannels = this.generateBrandChannel(brand.getId(), brandDTO.getChannelIdList());
        this.brandService.saveBrand(brand, brandLabels, brandChannels);
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)brand.getIsVirtualBrand())) {
            this.mallFourJAdapter.brandSaveToMallFourJ(CollUtil.newArrayList((Object[])new Brand[]{brand}));
        }
        return brand.getId();
    }

    public void updateBrand(BrandDTO brandDTO) {
        Assert.notNull((Object)brandDTO.getId(), (String)"\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Brand serviceById = (Brand)this.brandService.getById((Serializable)brandDTO.getId());
        Assert.notNull((Object)serviceById, (String)"\u66f4\u65b0\u7684\u54c1\u724c\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        this.checkBrand(brandDTO);
        if (brandDTO.getFoundedYear() == null) {
            brandDTO.setFoundedYear("");
        }
        Brand brand = new Brand();
        BeanUtils.copyProperties((Object)brandDTO, (Object)brand);
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)brand);
        brand.setFirstLetter(this.processBrandFirstLetter(brand.getName()));
        brand.setCountryFirstLetter(this.processBrandFirstLetter(brand.getCountryName()));
        List<BrandLabel> brandLabels = this.generateBrandLabel(brand.getId(), brandDTO.getBrandLabelList());
        List<BrandChannel> brandChannels = this.generateBrandChannel(brand.getId(), brandDTO.getChannelIdList());
        this.brandService.updateBrand(brand, brandLabels, brandChannels);
        if (!StringUtils.equals((CharSequence)serviceById.getIsMoneySampleInvoice(), (CharSequence)brandDTO.getIsMoneySampleInvoice())) {
            try {
                JSONObject main = JSONObject.parseObject((String)JSONObject.toJSONString((Object)brandDTO));
                log.debug("MqProducer.SendMessage.Start: body={},topic={},tag={}", new Object[]{main, ConstantPropertiesUtil.TOPIC, ConstantPropertiesUtil.PS_BRAND_TAG});
                String msgId = this.mqProducerHelper.sendMessage(main, ConstantPropertiesUtil.TOPIC, ConstantPropertiesUtil.PS_BRAND_TAG);
                log.debug("MqProducer.SendMessage.Success: msgId ={}", (Object)msgId);
            }
            catch (Exception e) {
                log.error("MqProducer.SendMessage.fail.Error", (Throwable)e);
            }
        }
        Brand newBrand = (Brand)this.brandService.getById((Serializable)brandDTO.getId());
        if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)serviceById.getIsVirtualBrand()) || StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)newBrand.getIsVirtualBrand())) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)newBrand.getIsVirtualBrand())) {
                newBrand.setIsDelete(Integer.valueOf(1));
            }
            this.mallFourJAdapter.brandSaveToMallFourJ(CollUtil.newArrayList((Object[])new Brand[]{newBrand}));
        }
    }

    private List<BrandLabel> generateBrandLabel(Long psBrandId, List<String> labels) {
        ArrayList<BrandLabel> brandLabels = new ArrayList<BrandLabel>();
        if (CollUtil.isNotEmpty(labels)) {
            for (String label : labels) {
                BrandLabel brandLabel = new BrandLabel();
                brandLabel.setId(this.idSequence.generateId(BrandLabel.class));
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)brandLabel);
                brandLabel.setPsBrandId(psBrandId);
                brandLabel.setLabel(label);
                brandLabels.add(brandLabel);
            }
        }
        return brandLabels;
    }

    private List<BrandChannel> generateBrandChannel(Long psBrandId, List<Long> channelIds) {
        ArrayList<BrandChannel> brandChannels = new ArrayList<BrandChannel>();
        if (CollUtil.isNotEmpty(channelIds)) {
            for (Long channelId : channelIds) {
                BrandChannel brandChannel = new BrandChannel();
                brandChannel.setId(this.idSequence.generateId(BrandChannel.class));
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)brandChannel);
                brandChannel.setPsBrandId(psBrandId);
                brandChannel.setChannelId(channelId);
                brandChannels.add(brandChannel);
            }
        }
        return brandChannels;
    }

    public BrandVO queryBrandDetail(Long id, Integer imageWide, Integer imageHigh) {
        LoginUserInfo currentLoginUserInfo;
        List<Long> brandChannelIdList;
        List brandChannels;
        List brandLabels;
        Brand brand = this.brandService.queryById(id);
        BrandVO brandVO = new BrandVO();
        if (brand != null) {
            BeanUtils.copyProperties((Object)brand, (Object)brandVO);
        }
        if (ObjectUtils.isNotEmpty((Object)brandVO.getGrossProfitRate())) {
            brandVO.setGrossProfitRate(new BigDecimal(brandVO.getGrossProfitRate().toString()).setScale(2, 2));
        }
        if (ObjectUtils.isNotEmpty((Object)brandVO.getGrossProfitRateOneShipment())) {
            brandVO.setGrossProfitRateOneShipment(new BigDecimal(brandVO.getGrossProfitRateOneShipment().toString()).setScale(2, 2));
        }
        if (StringUtils.isNotBlank((CharSequence)brandVO.getLogoUrl())) {
            boolean isClientAccess = this.userInfoUtil.isClientAccess();
            List<String> imagList = Collections.singletonList(brandVO.getLogoUrl());
            List<OssUrlVO> ossUrlVOS = isClientAccess ? this.scAdapter.generatePreassignedThumbUrl(imagList, imageWide, imageHigh) : this.scAdapter.generatePreassignedUrl(imagList);
            if (CollUtil.isNotEmpty(ossUrlVOS)) {
                brandVO.setLogoUrlFull(ossUrlVOS.get(0).getIntactUrl());
            }
        }
        if (CollUtil.isNotEmpty((Collection)(brandLabels = this.brandLabelService.getByBrandId(id)))) {
            List brandLabelCodeList = brandLabels.stream().map(BrandLabel::getLabel).distinct().collect(Collectors.toList());
            List brandLabelDict = this.dictRedisRepository.selectDictValueListByCode("brand_label");
            String brandLabelCodes = String.join((CharSequence)",", brandLabelCodeList);
            brandVO.setBrandLabelList(brandLabelCodeList);
            String brandLabelNames = this.translateCodesToValues(brandLabelCodes, brandLabelDict);
            brandVO.setBrandLabelNames(brandLabelNames);
            brandVO.setBrandLabelNameList(StrUtil.split((CharSequence)brandLabelNames, (char)','));
        }
        if (CollUtil.isNotEmpty((Collection)(brandChannels = this.brandChannelService.getByBrandId(id))) && CollUtil.isNotEmpty(brandChannelIdList = brandChannels.stream().map(BrandChannel::getChannelId).distinct().collect(Collectors.toList()))) {
            brandVO.setChannelIdList(brandChannelIdList);
            List<MdmPlatformVO> mdmPlatformVOS = this.mdmAdapter.queryPlatformByIds(brandChannelIdList);
            if (CollUtil.isNotEmpty(mdmPlatformVOS)) {
                String channelNames = mdmPlatformVOS.stream().filter(a -> ObjectUtil.equals((Object)1, (Object)a.getIsSupportBrandAuth())).map(a -> a.getName() + "\u3010" + ChannelTypeEnum.getDescByCode((String)a.getChannelType()) + "\u3011").distinct().collect(Collectors.joining(","));
                brandVO.setChannelNames(channelNames);
                brandVO.setChannelNameList(StrUtil.split((CharSequence)channelNames, (char)','));
            }
        }
        if (ObjectUtil.isNotNull((Object)(currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo())) && (LoginFrom.xqy_mall_pc.equals((Object)currentLoginUserInfo.getLoginFrom()) || LoginFrom.xqy_mall_miniapp.equals((Object)currentLoginUserInfo.getLoginFrom()))) {
            JSONArray psStoreIds = currentLoginUserInfo.getInternalPurchaseCustomer().getJSONArray("storeIdList");
            Assert.notEmpty((Iterable)psStoreIds, (String)"\u8be5\u8d26\u53f7\u672a\u6388\u6743\u4efb\u4f55\u5e97\u94fa", (Object[])new Object[0]);
            Long storeId = psStoreIds.getLong(0);
            brandVO.setIsFocus(Boolean.valueOf(this.storeBrandFocusService.isFocus(Long.valueOf(currentLoginUserInfo.getUserId()), storeId, id)));
        }
        return brandVO;
    }

    private void checkBrand(BrandDTO brandDTO) {
        Brand existBrand;
        Brand brandName = this.brandService.queryBrandName(brandDTO.getName(), brandDTO.getId());
        if (brandDTO.getId() != null) {
            Brand brand = this.brandService.queryById(brandDTO.getId());
            if (brand.getStatus().equals(1)) {
                Assert.isTrue((brandName == null ? 1 : 0) != 0, (String)"\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            } else if (brand.getStatus().equals(3)) {
                Assert.isTrue((boolean)brand.getName().equals(brandDTO.getName()), (String)"\u54c1\u724c\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539", (Object[])new Object[0]);
            } else {
                Assert.isTrue((boolean)brand.getName().equals(brandDTO.getName()), (String)"\u54c1\u724c\u540d\u79f0\u4e0d\u5141\u8bb8\u4fee\u6539", (Object[])new Object[0]);
                Assert.notBlank((CharSequence)brandDTO.getLogoUrl(), (String)"\u542f\u7528\u65f6\uff0c\u54c1\u724clogo\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Assert.notBlank((CharSequence)brandDTO.getFoundedYear(), (String)"\u542f\u7528\u65f6\uff0c\u521b\u7acb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        } else {
            Assert.isTrue((brandName == null ? 1 : 0) != 0, (String)"\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
        }
        String resultCname = this.mdmAdapter.selectDistrictCountries(brandDTO.getDistrictCountryId().longValue());
        Assert.isTrue((resultCname != null ? 1 : 0) != 0, (String)"\u65e0\u6b64\u56fd\u7c4d", (Object[])new Object[0]);
        brandDTO.setCountryName(resultCname);
        if (brandDTO.getBrandClassId() != null) {
            BrandClass brandClass = this.brandClassService.getBrandClass(Long.valueOf(Long.parseLong(brandDTO.getBrandClassId().toString())));
            Assert.isTrue((brandClass != null ? 1 : 0) != 0, (String)"\u65e0\u6b64\u54c1\u724c\u5206\u7c7b", (Object[])new Object[0]);
            brandDTO.setBrandClassValue(brandClass.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)brandDTO.getCode()) && (existBrand = this.brandService.selectByCode(brandDTO.getCode())) != null && !Objects.equals(existBrand.getId(), brandDTO.getId())) {
            throw new PsException(700, "\u54c1\u724c\u7f16\u7801" + brandDTO.getCode() + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\uff01");
        }
    }

    private String getBrandCode() {
        SequenceInfo sequenceInfo = new SequenceInfo();
        sequenceInfo.setSequenceRegex("[[${#numbers.formatInteger(sn,4)}]]");
        sequenceInfo.setName("ps_brand");
        sequenceInfo.setIncrementNumber(Long.valueOf(1L));
        sequenceInfo.setMaxNo(Long.valueOf(9999L));
        sequenceInfo.setStartNumber(Long.valueOf(1L));
        sequenceInfo.setCycleType(CycleType.DEFAULT.toString());
        String seqCode = this.distributedSequenceGenerator.buildSequence(sequenceInfo, null, false);
        Brand existBrand = this.brandService.selectByCode(seqCode);
        while (existBrand != null) {
            seqCode = this.distributedSequenceGenerator.buildSequence(sequenceInfo, null, false);
            existBrand = this.brandService.selectByCode(seqCode);
        }
        return seqCode;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatusBrand(BrandStatusDTO dto) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)dto.getIds()), (String)"\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)dto.getBrandStatus(), (String)"\u54c1\u724c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List brandList = this.brandService.listByIds((Collection)dto.getIds());
        Assert.isTrue((brandList.size() == dto.getIds().size() ? 1 : 0) != 0, (String)"\u54c1\u724c\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        List brandRecommends = this.storeBrandRecommendService.getByBrandIds(dto.getIds());
        ArrayList<String> searchKeys = new ArrayList<String>();
        for (Brand brand : brandList) {
            searchKeys.add("\"brandId\":" + brand.getId());
        }
        Map<String, List<Long>> serachKeyToStoreMap = this.mdmAdapter.querySearchKeysRelatedStoreIds(searchKeys);
        LinkedList<Brand> salesmanBrandList = new LinkedList<Brand>();
        LinkedList<Long> brandIds = new LinkedList<Long>();
        for (Brand brand : brandList) {
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)brand);
            if (dto.getBrandStatus().equals(StatusEnums.STOP_USING.getCode())) {
                String storeNames;
                List stores;
                List<Long> storeIds;
                Assert.isTrue((!brand.getStatus().equals(StatusEnums.STOP_USING.getCode()) ? 1 : 0) != 0, (String)("\u8be5\u54c1\u724c" + brand.getName() + "\u5df2\u505c\u7528!"), (Object[])new Object[0]);
                List spu = this.spuService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Spu::getPsBrandId, (Object)brand.getId())).eq(Spu::getStatus, (Object)StatusEnums.ENABLED.getCode())).last("LIMIT 1"));
                Assert.isTrue((boolean)CollUtil.isEmpty((Collection)spu), (String)(brand.getName() + "\u54c1\u724c\u5df2\u5173\u8054\u5546\u54c1\uff01"), (Object[])new Object[0]);
                if (CollUtil.isNotEmpty((Collection)brandRecommends) && CollUtil.isNotEmpty(storeIds = brandRecommends.stream().filter(a -> ObjectUtil.equals((Object)a.getPsBrandId(), (Object)brand.getId())).map(StoreBrandRecommend::getPsStoreId).distinct().collect(Collectors.toList()))) {
                    stores = this.storeService.listByIds(storeIds);
                    storeNames = stores.stream().map(Store::getName).distinct().collect(Collectors.joining(","));
                    Assert.isTrue((boolean)false, (String)("\u3010" + brand.getName() + "\u3011\u54c1\u724c\u5df2\u88ab\u5e97\u94fa\u3010" + storeNames + "\u3011\u8bbe\u7f6e\u4e3a\u63a8\u8350\u54c1\u724c\uff0c\u65e0\u6cd5\u505c\u7528"), (Object[])new Object[0]);
                }
                if (CollUtil.isNotEmpty(serachKeyToStoreMap) && CollUtil.isNotEmpty(storeIds = serachKeyToStoreMap.get("\"brandId\":" + brand.getId()))) {
                    stores = this.storeService.listByIds(storeIds);
                    storeNames = stores.stream().map(Store::getName).distinct().collect(Collectors.joining(","));
                    Assert.isTrue((boolean)false, (String)("\u3010" + brand.getName() + "\u3011\u54c1\u724c\u5df2\u88ab\u5e97\u94fa\u3010" + storeNames + "\u3011\u7684\u5e97\u94fa\u88c5\u4fee\u6240\u5f15\u7528\uff0c\u65e0\u6cd5\u505c\u7528"), (Object[])new Object[0]);
                }
                brand.setStatus(StatusEnums.STOP_USING.getCode());
                brandIds.add(brand.getId());
            } else if (dto.getBrandStatus().equals(StatusEnums.ENABLED.getCode())) {
                Assert.isTrue((!brand.getStatus().equals(StatusEnums.ENABLED.getCode()) ? 1 : 0) != 0, (String)("\u8be5\u54c1\u724c" + brand.getName() + "\u5df2\u542f\u7528!"), (Object[])new Object[0]);
                Assert.notBlank((CharSequence)brand.getFoundedYear(), (String)("\u542f\u7528\u65f6\uff0c\u54c1\u724c\u3010" + brand.getName() + "\u3011\u7684\u521b\u7acb\u65f6\u95f4(\u5e74)\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                Assert.notBlank((CharSequence)brand.getLogoUrl(), (String)("\u542f\u7528\u65f6\uff0c\u54c1\u724c\u3010" + brand.getName() + "\u3011\u7684\u54c1\u724clogo\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                if (brand.getStatus().equals(StatusEnums.NOT_ENABLED.getCode())) {
                    salesmanBrandList.add(brand);
                }
                brand.setStatus(StatusEnums.ENABLED.getCode());
                brandIds.add(brand.getId());
            } else if (dto.getBrandStatus().equals(StatusEnums.NOT_ENABLED.getCode())) {
                Assert.isTrue((boolean)brand.getStatus().equals(StatusEnums.NOT_ENABLED.getCode()), (String)(brand.getName() + "\u54c1\u724c\u4e0d\u80fd\u5220\u9664!"), (Object[])new Object[0]);
                brand.setIsDelete(IsDeleteEnums.YES.getCode());
            }
            brand.setBrandClassId(brand.getBrandClassId());
            brand.setBrandClassValue(brand.getBrandClassValue());
            this.brandService.updateById((Object)brand);
            if (!StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)brand.getIsVirtualBrand())) continue;
            this.mallFourJAdapter.brandSaveToMallFourJ(CollUtil.newArrayList((Object[])new Brand[]{brand}));
        }
        if (CollectionUtil.isNotEmpty(salesmanBrandList)) {
            this.mdmAdapter.saveFullBrand(salesmanBrandList);
        }
        if (CollectionUtil.isNotEmpty(brandIds) && !dto.getBrandStatus().equals(StatusEnums.NOT_ENABLED.getCode())) {
            this.cusAdapter.updateBatchBrandStatus(brandIds, dto.getBrandStatus());
        }
    }

    public List<BrandVO> queryBrandList(BrandDTO dto) {
        List brands;
        List brandIds;
        if (Boolean.TRUE.equals(dto.getIsPermission())) {
            String notBrandId;
            LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            Map brandMap = DataPermissionUtil.getPermissionDataIdMap((Long)currentLoginUserInfo.getUserId(), (String)"ps_brand");
            String brandId = (String)brandMap.get("PERMISSION");
            if (StringUtils.isNotBlank((CharSequence)brandId)) {
                List brandIds2 = Arrays.stream(brandId.split(",")).map(Long::valueOf).collect(Collectors.toList());
                dto.setIds(brandIds2);
            }
            if (StringUtils.isNotBlank((CharSequence)(notBrandId = (String)brandMap.get("EXCLUDE_PERMISSION")))) {
                List brandIds3 = Arrays.stream(notBrandId.split(",")).map(Long::valueOf).collect(Collectors.toList());
                dto.setNotIdList(brandIds3);
            }
        }
        if (ObjectUtil.isNotNull((Object)dto.getCustomerId())) {
            ArExpenseQueryDTO arExpenseQueryDTO = new ArExpenseQueryDTO();
            arExpenseQueryDTO.setSettlementId(dto.getCustomerId());
            List<FcArExpenseVO> list = this.fcArExpenseAdapter.selectLastBrandExpenseList(arExpenseQueryDTO);
            if (CollUtil.isNotEmpty(list)) {
                brandIds = list.stream().map(FcArExpenseVO::getPsBrandId).collect(Collectors.toList());
                dto.setBrandIds(brandIds);
            } else {
                return Lists.newArrayList();
            }
        }
        if (ObjectUtil.isNotNull((Object)dto.getChannelId())) {
            List brandChannelList = this.brandChannelService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BrandChannel::getChannelId, (Object)dto.getChannelId())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
            if (CollUtil.isEmpty((Collection)brandChannelList)) {
                return CollUtil.newArrayList((Object[])new BrandVO[0]);
            }
            List brandIds4 = brandChannelList.stream().map(BrandChannel::getPsBrandId).collect(Collectors.toList());
            if (CollUtil.isNotEmpty((Collection)dto.getBrandIds())) {
                List intersection = brandIds4.stream().filter(item -> dto.getBrandIds().contains(item)).collect(Collectors.toList());
                if (CollUtil.isEmpty(intersection)) {
                    return CollUtil.newArrayList((Object[])new BrandVO[0]);
                }
                dto.setBrandIds(intersection);
            } else {
                dto.setBrandIds(brandIds4);
            }
        }
        if (CollUtil.isNotEmpty((Collection)(brands = this.brandService.queryBrandList(dto)))) {
            List<BrandVO> brandVOS = BeanConvertUtil.convertList(brands, BrandVO.class);
            brandIds = brands.stream().map(BaseDo::getId).collect(Collectors.toList());
            List brandChannels = this.brandChannelService.getByBrandIds(brandIds);
            if (CollUtil.isNotEmpty((Collection)brandChannels)) {
                List<Long> channelIds = brandChannels.stream().map(BrandChannel::getChannelId).distinct().collect(Collectors.toList());
                List<MdmPlatformVO> mdmPlatformVOS = this.mdmAdapter.queryPlatformByIds(channelIds);
                Map<Long, List<BrandChannel>> brandChannelMap = brandChannels.stream().collect(Collectors.groupingBy(BrandChannel::getPsBrandId));
                for (BrandVO brandVO : brandVOS) {
                    List channelsForBrand = (List)brandChannelMap.get(brandVO.getId());
                    if (!CollUtil.isNotEmpty((Collection)channelsForBrand)) continue;
                    List channelIdsForBrand = channelsForBrand.stream().map(BrandChannel::getChannelId).distinct().collect(Collectors.toList());
                    List channelNameList = mdmPlatformVOS.stream().filter(a -> channelIdsForBrand.contains(a.getId()) && ObjectUtil.equals((Object)1, (Object)a.getIsSupportBrandAuth())).map(MdmPlatformVO::getName).collect(Collectors.toList());
                    brandVO.setChannelNameList(channelNameList);
                }
            }
            List<String> imagList = brandVOS.stream().map(BrandVO::getLogoUrl).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedThumbUrl(imagList, dto.getImageWide(), dto.getImageHigh());
            for (BrandVO brandVO : brandVOS) {
                ossUrlVOS.stream().filter(a -> StringUtils.equals((CharSequence)a.getUrl(), (CharSequence)brandVO.getLogoUrl())).findFirst().ifPresent(a -> brandVO.setLogoUrlFull(a.getIntactUrl()));
            }
            List brandIdList = brands.stream().map(BaseDo::getId).collect(Collectors.toList());
            if (StrUtil.equals((CharSequence)FcCommonEnum.YesOrNoStrEnum.YES.getValue(), (CharSequence)dto.getIsSort()) && CollUtil.isNotEmpty(brandIdList) && ObjectUtil.isNotNull((Object)dto.getPsStoreId())) {
                List storeBrandSortList = this.storeBrandSortService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(StoreBrandSort::getPsBrandId, brandIdList)).eq(StoreBrandSort::getPsStoreId, (Object)dto.getPsStoreId()));
                for (BrandVO brandVO : brandVOS) {
                    List storeBrandSorts = storeBrandSortList.stream().filter(a -> a.getPsBrandId().equals(brandVO.getId())).collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(storeBrandSorts)) {
                        brandVO.setSortNo(((StoreBrandSort)storeBrandSorts.get(0)).getSortNo());
                        continue;
                    }
                    brandVO.setSortNo(Integer.valueOf(brandVOS.size()));
                }
                return brandVOS.stream().sorted(Comparator.comparing(BrandVO::getSortNo)).collect(Collectors.toList());
            }
            return brandVOS;
        }
        return Collections.emptyList();
    }

    public PageResult queryPage(BrandPageDTO brandPageDTO) {
        List mdmPlatformVOS;
        Page brandPage = new Page((long)brandPageDTO.getPageNum(), (long)brandPageDTO.getPageSize());
        ParameterColumnHandler.convertParameter(brandPageDTO, COLUMN_LIST, "IsUnion");
        IPage infoPage = this.brandService.queryPage(brandPage, brandPageDTO);
        List pageRecords = infoPage.getRecords();
        List<BrandVO> brandVOS = BeanConvertUtil.convertList(pageRecords, BrandVO.class);
        List brandIds = brandVOS.stream().map(BrandVO::getId).collect(Collectors.toList());
        List brandChannels = CollUtil.isNotEmpty(brandIds) ? this.brandChannelService.getByBrandIds(brandIds) : Collections.emptyList();
        List<Long> channelIds = brandChannels.stream().map(BrandChannel::getChannelId).distinct().collect(Collectors.toList());
        List<Object> list = mdmPlatformVOS = CollUtil.isNotEmpty(channelIds) ? this.mdmAdapter.queryPlatformByIds(channelIds) : Collections.emptyList();
        if (CollUtil.isNotEmpty(mdmPlatformVOS)) {
            mdmPlatformVOS = mdmPlatformVOS.stream().filter(a -> ObjectUtil.equals((Object)a.getIsSupportBrandAuth(), (Object)1)).collect(Collectors.toList());
        }
        List brandLabelDict = this.dictRedisRepository.selectDictValueListByCode("brand_label");
        for (BrandVO brandVO : brandVOS) {
            brandVO.setBrandLabelNames(this.translateCodesToValues(brandVO.getBrandLabels(), brandLabelDict));
            brandVO.setChannelNames(this.translateCodesToValues(brandVO.getChannelIds(), brandLabelDict));
            if (ObjectUtils.isNotEmpty((Object)brandVO.getGrossProfitRate())) {
                brandVO.setGrossProfitRate(new BigDecimal(brandVO.getGrossProfitRate().toString()).setScale(2, RoundingMode.CEILING));
            }
            if (ObjectUtils.isNotEmpty((Object)brandVO.getGrossProfitRateOneShipment())) {
                brandVO.setGrossProfitRateOneShipment(new BigDecimal(brandVO.getGrossProfitRateOneShipment().toString()).setScale(2, RoundingMode.CEILING));
            }
            if (!CollUtil.isNotEmpty(mdmPlatformVOS)) continue;
            List currentChannelIds = brandChannels.stream().filter(a -> ObjectUtil.equals((Object)a.getPsBrandId(), (Object)brandVO.getId())).map(BrandChannel::getChannelId).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty((Collection)brandChannels)) continue;
            String channelNames = mdmPlatformVOS.stream().filter(a -> currentChannelIds.contains(a.getId())).map(MdmPlatformVO::getName).distinct().collect(Collectors.joining(","));
            brandVO.setChannelNames(channelNames);
        }
        return new PageResult(brandPageDTO.getPageNum(), brandPageDTO.getPageSize(), brandPage.getTotal()).setData(brandVOS);
    }

    private String translateCodesToValues(String codes, List<DictValue> dict) {
        if (StringUtils.isNotBlank((CharSequence)codes)) {
            String[] labels = codes.split(",");
            ArrayList<String> labelStr = new ArrayList<String>(labels.length);
            for (String label : labels) {
                DictValue findDictValue = dict.stream().filter(a -> StringUtils.equals((CharSequence)String.valueOf(a.getValueCode()), (CharSequence)label)).findFirst().orElse(null);
                if (findDictValue == null || labelStr.contains(findDictValue.getName())) continue;
                labelStr.add(findDictValue.getName());
            }
            return String.join((CharSequence)",", labelStr);
        }
        return "";
    }

    public SelectMindDataResponse queryPage(CommonSearchRequest commonSearchRequest) {
        Page brandPage = new Page(commonSearchRequest.getPageIndex().longValue(), commonSearchRequest.getPageSize().longValue());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BaseDo::getIsDelete, (Object)0);
        BrandPageDTO brandPageDTO = new BrandPageDTO();
        List searchCondition = commonSearchRequest.getSearchCondition();
        ArrayList idList = new ArrayList();
        searchCondition.forEach(x -> {
            List searchValueList;
            String replace;
            String columnName = x.getColumnName();
            String searchValue = x.getSearchValue();
            if (StrUtil.isNotBlank((CharSequence)searchValue)) {
                searchValue = searchValue.trim();
            }
            if (columnName.contains("code")) {
                replace = StrUtil.replace((CharSequence)searchValue, (CharSequence)"\n", (CharSequence)" ");
                searchValueList = StrUtil.splitTrim((CharSequence)replace, (char)' ');
                brandPageDTO.setCodeList(searchValueList);
                lambdaQueryWrapper.and(innerWrapper -> {
                    for (String searchItem : searchValueList) {
                        ((LambdaQueryWrapper)innerWrapper.or()).like(Brand::getCode, (Object)searchItem);
                    }
                });
            }
            if (columnName.contains("value")) {
                replace = StrUtil.replace((CharSequence)searchValue, (CharSequence)"\n", (CharSequence)" ");
                searchValueList = StrUtil.splitTrim((CharSequence)replace, (char)' ');
                brandPageDTO.setNameList(searchValueList);
                lambdaQueryWrapper.and(innerWrapper -> {
                    for (String searchItem : searchValueList) {
                        ((LambdaQueryWrapper)innerWrapper.or()).like(Brand::getName, (Object)searchItem);
                    }
                });
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)columnName, (CharSequence)"id")) {
                idList.addAll(Arrays.asList(x.getSearchValue().split(",")));
            }
        });
        Object infoPage = CollUtil.isEmpty(idList) ? this.brandService.page((IPage)brandPage, (Wrapper)lambdaQueryWrapper) : this.brandService.queryPermissionPage(brandPage, brandPageDTO, idList);
        List pageRecords = infoPage.getRecords();
        ArrayList brandVOList = new ArrayList();
        pageRecords.forEach(x -> {
            BrandDFDTO brandDFDTO = new BrandDFDTO();
            brandDFDTO.setId(x.getId());
            brandDFDTO.setCode(x.getCode());
            brandDFDTO.setValue(x.getName());
            brandVOList.add((JSONObject)JSON.toJSON((Object)brandDFDTO));
        });
        SelectMindDataResponse response = new SelectMindDataResponse();
        response.setRecords(brandVOList);
        response.setPageIndex(Long.valueOf(infoPage.getCurrent()));
        response.setPageSize(Long.valueOf(infoPage.getSize()));
        response.setTotalPage(Integer.valueOf((int)infoPage.getPages()));
        response.setTotalNum(Long.valueOf(infoPage.getTotal()));
        return response;
    }

    public SelectMindDataResponse queryPageV2(CommonSearchRequest commonSearchRequest) {
        Page brandPage = new Page(commonSearchRequest.getPageIndex().longValue(), commonSearchRequest.getPageSize().longValue());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BaseDo::getIsDelete, (Object)0);
        List searchCondition = commonSearchRequest.getSearchCondition();
        HashMap map = Maps.newHashMap();
        searchCondition.forEach(x -> {
            String columnName = x.getColumnName();
            String searchValue = x.getSearchValue();
            if (StrUtil.isNotBlank((CharSequence)searchValue)) {
                searchValue = searchValue.trim();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)columnName, (CharSequence)"id")) {
                map.put("idString", searchValue);
            } else {
                map.put(CamelTransformUnderlineUtils.changeColumn(columnName), searchValue);
            }
        });
        IPage infoPage = this.brandService.queryPermissionPage(brandPage, map);
        List pageRecords = infoPage.getRecords();
        ArrayList brandVOList = new ArrayList();
        pageRecords.forEach(x -> {
            BrandDFDTO brandDFDTO = new BrandDFDTO();
            brandDFDTO.setId(x.getId());
            brandDFDTO.setCode(x.getCode());
            brandDFDTO.setValue(x.getName());
            brandVOList.add((JSONObject)JSON.toJSON((Object)brandDFDTO));
        });
        SelectMindDataResponse response = new SelectMindDataResponse();
        response.setRecords(brandVOList);
        response.setPageIndex(Long.valueOf(infoPage.getCurrent()));
        response.setPageSize(Long.valueOf(infoPage.getSize()));
        response.setTotalPage(Integer.valueOf((int)infoPage.getPages()));
        response.setTotalNum(Long.valueOf(infoPage.getTotal()));
        return response;
    }

    private List<String> getSplitTextList(String searchValue) {
        List<Object> searchList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)searchValue)) {
            return searchList;
        }
        searchList = Arrays.asList(searchValue.split(","));
        return searchList;
    }

    public List<Brand> queryBrandById(BrandDTO dto) {
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        if (currentLoginUserInfo.getLoginFrom().toString().equals(LoginFrom.xqy_mall_miniapp.toString())) {
            dto.setIsVirtualBrand("0");
        }
        return this.brandService.queryBrandById(dto);
    }

    public List<Brand> queryCategoryById() {
        return this.brandService.queryCategoryById();
    }

    public Brand selectBrandById(BrandDTO brandDTO) {
        return this.brandService.selectBrandById(brandDTO);
    }

    public BrandVO queryByCode(BrandDTO brandDTO) {
        Brand brand = this.brandService.queryByCode(brandDTO);
        BrandVO brandVO = new BrandVO();
        if (brand != null) {
            BeanUtils.copyProperties((Object)brand, (Object)brandVO);
        }
        return brandVO;
    }

    public void updateGrossProfitRateList(List<BrandStatusDTO> dto) {
        dto.forEach(brandDTO -> {
            Brand brand = (Brand)this.brandService.getById((Serializable)brandDTO.getId());
            Assert.notNull((Object)brand, (String)"\u6b64\u54c1\u724c\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
            if (StringUtils.equals((CharSequence)brandDTO.getGrossProfitRateType(), (CharSequence)"1")) {
                Assert.notNull((Object)brandDTO.getGrossProfitRate(), (String)"\u8bf7\u8f93\u5165\u54c1\u724c\u6bdb\u5229\u7387\uff08\u6279\u91c7\uff09\uff01", (Object[])new Object[0]);
            } else {
                Assert.notNull((Object)brandDTO.getGrossProfitRateOneShipment(), (String)"\u8bf7\u8f93\u5165\u54c1\u724c\u6bdb\u5229\u7387\uff08\u4e00\u4ef6\u4ee3\u53d1\uff09\uff01", (Object[])new Object[0]);
            }
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)brand);
        });
        List<Brand> brands = BeanConvertUtil.convertList(dto, Brand.class);
        for (Brand brand : brands) {
            this.brandService.updateById((Object)brand);
        }
    }

    public Brand queryByBrandName(BrandDTO dto) {
        return (Brand)this.brandService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Brand::getName, (Object)dto.getName())).eq(BaseDo::getIsDelete, (Object)0), false);
    }

    public List<Brand> queryByBrandNames(BrandDTO dto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(Brand::getName, (Collection)dto.getNames())).eq(dto.getStatus() != null, Brand::getStatus, (Object)dto.getStatus())).eq(BaseDo::getIsDelete, (Object)0);
        return this.brandService.list((Wrapper)wrapper);
    }

    public List<Brand> queryBrandForOaDropDownList() {
        return this.brandService.queryBrandForOaDropDownList();
    }

    public List<String> getFirstLetter(BrandQueryDTO dto) {
        Long userId = this.userInfoUtil.getUserId();
        Assert.notNull((Object)userId, (String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Long storeId = this.userInfoUtil.getStoreId();
        Assert.notNull((Object)storeId, (String)"\u8be5\u8d26\u53f7\u672a\u6388\u6743\u4efb\u4f55\u5e97\u94fa", (Object[])new Object[0]);
        if (ObjectUtil.equals((Object)dto.getIsFocusPage(), (Object)true)) {
            StoreBrandFocusQueryDTO queryDTO = new StoreBrandFocusQueryDTO();
            queryDTO.setUserId(userId);
            queryDTO.setStoreId(storeId);
            List storeBrandFocus = this.storeBrandFocusService.query(queryDTO);
            return storeBrandFocus.stream().map(StoreBrandFocusVO::getFirstLetter).distinct().sorted().collect(Collectors.toList());
        }
        List list = this.brandService.queryEnableDaMaoBrand(null);
        return list.stream().map(Brand::getFirstLetter).distinct().sorted().collect(Collectors.toList());
    }

    public List<BrandSubscribeVO> getCountry(BrandQueryDTO dto) {
        return new ArrayList<BrandSubscribeVO>();
    }

    public void processBrandFirstLetter() {
        List list = this.brandService.list();
        ArrayList<Brand> updateList = new ArrayList<Brand>();
        for (Brand brand : list) {
            Brand updateBrand = new Brand();
            updateBrand.setFirstLetter(this.processBrandFirstLetter(brand.getName()));
            updateBrand.setCountryFirstLetter(this.processBrandFirstLetter(brand.getCountryName()));
            updateBrand.setId(brand.getId());
            updateList.add(updateBrand);
        }
        this.brandService.updateBatchById(updateList);
    }

    private String processBrandFirstLetter(String brandName) {
        if (StringUtils.isNotBlank((CharSequence)brandName)) {
            char firstLetter = PinyinUtil.getFirstLetter((char)brandName.charAt(0));
            if (PinyinUtil.isChinese((char)firstLetter) || CharUtil.isLetter((char)firstLetter)) {
                return String.valueOf(Character.toUpperCase(firstLetter));
            }
            return "\uff03";
        }
        return "\uff03";
    }

    public BrandSubscribeForLiteAppVO selectBrandSubscribeListForLiteApp(BrandMiniAppQueryDTO dto) {
        Long userId = this.userInfoUtil.getUserId();
        Assert.notNull((Object)userId, (String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Long storeId = this.userInfoUtil.getStoreId();
        Assert.notNull((Object)storeId, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u8d26\u53f7\u767b\u5f55\u65f6\u6240\u9009\u5b9a\u7684\u5e97\u94fa", (Object[])new Object[0]);
        List<Long> shelfBrandIds = this.skuShelfBiz.selectStoreShelfBrand(storeId, null);
        List brands = CollUtil.isEmpty(shelfBrandIds) ? Collections.emptyList() : this.brandService.queryEnableDaMaoBrand(shelfBrandIds);
        StoreBrandFocusQueryDTO queryDTO = new StoreBrandFocusQueryDTO();
        queryDTO.setUserId(userId);
        queryDTO.setStoreId(storeId);
        List storeBrandFocus = this.storeBrandFocusService.query(queryDTO);
        List storeBrandRecommends = this.storeBrandRecommendService.queryForClient(userId, storeId, shelfBrandIds);
        List<String> imagList = brands.stream().map(Brand::getLogoUrl).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedThumbUrl(imagList, dto.getImageWide(), dto.getImageHigh());
        Set letters = brands.stream().map(Brand::getFirstLetter).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        BrandSubscribeForLiteAppVO brandSubscribeForLiteAppVO = new BrandSubscribeForLiteAppVO();
        brandSubscribeForLiteAppVO.setLetters(new ArrayList(letters));
        ArrayList<BrandSubscribeVO> brandSubscribeVOS = new ArrayList<BrandSubscribeVO>();
        for (Object brand : brands) {
            BrandSubscribeVO brandSubscribeVO = this.assembleBrandSubscribeVO((Brand)brand);
            ossUrlVOS.stream().filter(arg_0 -> BrandBiz.lambda$selectBrandSubscribeListForLiteApp$19((Brand)brand, arg_0)).findFirst().ifPresent(a -> brandSubscribeVO.setLogoUrlFull(a.getIntactUrl()));
            brandSubscribeVOS.add(brandSubscribeVO);
        }
        brandSubscribeForLiteAppVO.setSubscribeVOS(brandSubscribeVOS);
        ArrayList storeBrandFocusVOS = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)storeBrandFocus)) {
            for (StoreBrandFocusVO brandFocus : storeBrandFocus) {
                brandSubscribeVOS.stream().filter(a -> ObjectUtil.equals((Object)a.getBrandId(), (Object)brandFocus.getPsBrandId())).findFirst().ifPresent(storeBrandFocusVOS::add);
            }
            brandSubscribeForLiteAppVO.setFocusCount(Integer.valueOf(storeBrandFocus.size()));
        }
        brandSubscribeForLiteAppVO.setFocusVOS(storeBrandFocusVOS);
        ArrayList storeBrandRecommendVOS = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)storeBrandRecommends)) {
            for (StoreBrandRecommendVO storeBrandRecommend : storeBrandRecommends) {
                brandSubscribeVOS.stream().filter(a -> ObjectUtil.equals((Object)a.getBrandId(), (Object)storeBrandRecommend.getPsBrandId())).findFirst().ifPresent(storeBrandRecommendVOS::add);
            }
        }
        brandSubscribeForLiteAppVO.setRecommendVOS(storeBrandRecommendVOS);
        return brandSubscribeForLiteAppVO;
    }

    private BrandSubscribeVO assembleBrandSubscribeVO(Brand brand) {
        BrandSubscribeVO brandSubscribeVO = new BrandSubscribeVO();
        brandSubscribeVO.setBrandId(brand.getId());
        brandSubscribeVO.setBrandName(brand.getName());
        brandSubscribeVO.setLetters(brand.getFirstLetter());
        brandSubscribeVO.setLogoUrl(brand.getLogoUrl());
        brandSubscribeVO.setEnglishName(brand.getEnglishName());
        brandSubscribeVO.setBrandBriefIntro(brand.getBrandBriefIntro());
        brandSubscribeVO.setBrandIdea(brand.getBrandIdea());
        return brandSubscribeVO;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Page<BrandVO> queryBrandPageForPc(BrandPageDTO dto) {
        if (this.userInfoUtil.isClientAccess()) {
            dto.setIsClientAccess(Boolean.valueOf(true));
            dto.setUserId(this.userInfoUtil.getUserId());
            dto.setStoreId(this.userInfoUtil.getStoreId());
            Assert.notNull((Object)dto.getStoreId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            shelfBrandIds = this.skuShelfBiz.selectStoreShelfBrand(dto.getStoreId(), dto.getPurchaseMode());
            if (CollUtil.isEmpty(shelfBrandIds)) {
                return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
            }
            brandIs = com.google.common.collect.Lists.newArrayList();
            orderConfigureDetailsDTO = new CustomerOrderConfigureDetailsDTO();
            customerId = this.userInfoUtil.getCustomerId();
            if (null != customerId) {
                orderConfigureDetailsDTO.setCustomerId(customerId);
                try {
                    orderConfigurationVO = this.cusAdapter.selectOrderConfigurationForQuerySku(orderConfigureDetailsDTO);
                    org.springframework.util.Assert.isTrue((boolean)(null != orderConfigurationVO), (String)"\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5931\u8d25");
                    if (null != orderConfigurationVO.getIsExcludeAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsExcludeAll())) {
                        return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
                    }
                    if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointBrandIds())) {
                        v0 /* !! */  = brandIs = CollUtil.isEmpty(shelfBrandIds) != false ? orderConfigurationVO.getAppointBrandIds() : orderConfigurationVO.getAppointBrandIds().stream().filter((Predicate<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/Long;)Z)(shelfBrandIds)).collect(Collectors.toList());
                        if (CollUtil.isEmpty((Collection)brandIs)) {
                            return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
                        }
                        dto.setShelfBrandIds((List)brandIs);
                    }
                    if (!CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds())) ** GOTO lbl46
                    for (Long brandId : shelfBrandIds) {
                        id = orderConfigurationVO.getExcludeBrandIds().stream().filter((Predicate<Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$queryBrandPageForPc$23(java.lang.Long java.lang.Long ), (Ljava/lang/Long;)Z)((Long)brandId)).findAny().orElse(null);
                        if (null != id) continue;
                        brandIs.add(brandId);
                    }
                    if (CollUtil.isEmpty((Collection)brandIs)) {
                        return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
                    }
                    dto.setShelfBrandIds((List)brandIs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BrandBiz.log.error("\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5f02\u5e38{}", (Object)e.getMessage());
                    return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
                }
            }
        } else if (ObjectUtil.isNotNull((Object)dto.getStoreId())) {
            shelfBrandIds = this.skuShelfBiz.selectStoreShelfBrand(dto.getStoreId(), dto.getPurchaseMode());
            if (CollUtil.isEmpty(shelfBrandIds)) {
                return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
            }
            dto.setShelfBrandIds(shelfBrandIds);
        }
lbl46:
        // 6 sources

        brandPage = this.brandService.queryBrandPageForPc(dto);
        records = brandPage.getRecords();
        imagList = records.stream().map((Function<BrandVO, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLogoUrl(), (Lcom/xinqiyi/ps/api/model/vo/BrandVO;)Ljava/lang/String;)()).filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isNotBlank(java.lang.CharSequence ), (Ljava/lang/String;)Z)()).collect(Collectors.toList());
        ossUrlVOS = this.scAdapter.generatePreassignedThumbUrl(imagList, dto.getImageWide(), dto.getImageHigh());
        for (BrandVO brandVO : records) {
            brandClassStatus = brandVO.getBrandClassStatus();
            logoUrl = brandVO.getLogoUrl();
            if (ObjectUtil.isNotNull((Object)brandClassStatus)) {
                brandVO.setBrandClassStatusName(StatusEnums.getDescByCode((Integer)Integer.valueOf(brandClassStatus)));
            }
            if (!StringUtils.isNotBlank((CharSequence)logoUrl)) continue;
            ossUrlVOS.stream().filter((Predicate<OssUrlVO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$queryBrandPageForPc$24(com.xinqiyi.ps.api.model.vo.BrandVO com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO ), (Lcom/xinqiyi/systemcenter/web/sc/api/model/vo/file/OssUrlVO;)Z)((BrandVO)brandVO)).findFirst().ifPresent((Consumer<OssUrlVO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$queryBrandPageForPc$25(com.xinqiyi.ps.api.model.vo.BrandVO com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO ), (Lcom/xinqiyi/systemcenter/web/sc/api/model/vo/file/OssUrlVO;)V)((BrandVO)brandVO));
        }
        return brandPage;
    }

    public SalesmanVO queryBrandDirector(BrandQueryDTO jsonData) {
        Store store;
        if (jsonData.getStoreId() == null && (store = (Store)this.storeService.getOne((Wrapper)new QueryWrapper().lambda().eq(Store::getIsDefault, (Object)FcCommonEnum.YesOrNoStrEnum.YES.getValue()), false)) != null) {
            jsonData.setStoreId(store.getId());
        }
        Assert.notNull((Object)jsonData.getBrandId(), (String)"\u54c1\u724cid\u4e0d\u5f97\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)jsonData.getStoreId(), (String)"\u5e97\u94faid\u4e0d\u5f97\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)jsonData.getSourceType(), (String)"\u6765\u6e90\u7c7b\u578b\u4e0d\u5f97\u4e3a\u7a7a\uff081-\u6279\u91c7;2-\u4ee3\u53d1\uff09", (Object[])new Object[0]);
        store = (Store)this.storeService.getById((Serializable)jsonData.getStoreId());
        Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        SalesmanVO salesmanVO = null;
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        if (userInfo.getCustomerId() != null) {
            salesmanVO = this.mdmAdapter.queryBrandDirector(jsonData.getBrandId());
        }
        if (salesmanVO == null) {
            salesmanVO = new SalesmanVO();
        }
        if (StrUtil.isBlank((CharSequence)salesmanVO.getWechatQrCodeUrl())) {
            salesmanVO.setWechatQrCodeUrl(store.getBrandDirector());
        }
        if (StrUtil.isBlank((CharSequence)salesmanVO.getDingdingPhone())) {
            salesmanVO.setDingdingPhone(store.getBrandDirectorPhone());
            salesmanVO.setDingdingTominPhone(StringUtil.desensitized(store.getBrandDirectorPhone(), 2, 2, "*"));
        }
        return salesmanVO;
    }

    public BrandBiz(BrandService brandService, BrandLabelService brandLabelService, BrandChannelService brandChannelService, StoreBrandFocusService storeBrandFocusService, StoreBrandRecommendService storeBrandRecommendService, StoreService storeService, DistributedSequenceGenerator distributedSequenceGenerator, IdSequenceGenerator idSequence, BaseDaoInitialService baseDaoInitialService, MdmAdapter mdmAdapter, ScAdapter scAdapter, SpuService spuService, BrandClassService brandClassService, MqProducerHelper mqProducerHelper, CusAdapter cusAdapter, GateWayWebAuthService gateWayWebAuthService, MallFourJAdapter mallFourJAdapter, FcArExpenseAdapter fcArExpenseAdapter, DictRedisRepository dictRedisRepository, UserInfoUtil userInfoUtil, SkuShelfBiz skuShelfBiz, StoreBrandSortService storeBrandSortService) {
        this.brandService = brandService;
        this.brandLabelService = brandLabelService;
        this.brandChannelService = brandChannelService;
        this.storeBrandFocusService = storeBrandFocusService;
        this.storeBrandRecommendService = storeBrandRecommendService;
        this.storeService = storeService;
        this.distributedSequenceGenerator = distributedSequenceGenerator;
        this.idSequence = idSequence;
        this.baseDaoInitialService = baseDaoInitialService;
        this.mdmAdapter = mdmAdapter;
        this.scAdapter = scAdapter;
        this.spuService = spuService;
        this.brandClassService = brandClassService;
        this.mqProducerHelper = mqProducerHelper;
        this.cusAdapter = cusAdapter;
        this.gateWayWebAuthService = gateWayWebAuthService;
        this.mallFourJAdapter = mallFourJAdapter;
        this.fcArExpenseAdapter = fcArExpenseAdapter;
        this.dictRedisRepository = dictRedisRepository;
        this.userInfoUtil = userInfoUtil;
        this.skuShelfBiz = skuShelfBiz;
        this.storeBrandSortService = storeBrandSortService;
    }

    private static /* synthetic */ void lambda$queryBrandPageForPc$25(BrandVO brandVO, OssUrlVO a) {
        brandVO.setLogoUrlFull(a.getIntactUrl());
    }

    private static /* synthetic */ boolean lambda$queryBrandPageForPc$24(BrandVO brandVO, OssUrlVO a) {
        return StringUtils.equals((CharSequence)a.getUrl(), (CharSequence)brandVO.getLogoUrl());
    }

    private static /* synthetic */ boolean lambda$queryBrandPageForPc$23(Long brandId, Long a) {
        return a.equals(brandId);
    }

    private static /* synthetic */ boolean lambda$selectBrandSubscribeListForLiteApp$19(Brand brand, OssUrlVO a) {
        return StringUtils.equals((CharSequence)a.getUrl(), (CharSequence)brand.getLogoUrl());
    }
}

