/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.dao.repository.BrandCategoryService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.BrandCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BrandCategoryBiz {
    @Autowired
    private BrandCategoryService brandCategoryService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private SpuService spuService;

    public void saveBrandCategory(Long brandId, List<Long> categoryIds, Brand brand) {
        List brandCategorys = this.brandCategoryService.queryByBrandId(brandId);
        ArrayList categoryList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)brandCategorys)) {
            brandCategorys.forEach(brandCategory -> categoryList.add(brandCategory.getPsCategoryId()));
        }
        categoryList.removeAll(categoryIds);
        if (CollectionUtil.isNotEmpty(categoryList)) {
            categoryList.forEach(categoryId -> {
                List spuList = this.spuService.queryBySpuId(brandId, categoryId);
                Assert.isTrue((boolean)CollectionUtil.isEmpty((Collection)spuList), (String)"\u7c7b\u76ee\u5df2\u5173\u8054\u5546\u54c1\uff01", (Object[])new Object[0]);
            });
        }
        this.brandCategoryService.removeBrandCategory(brandId);
        ArrayList<BrandCategory> brandCategoryList = new ArrayList<BrandCategory>();
        for (Long categoryId2 : categoryIds) {
            BrandCategory brandCategory2 = new BrandCategory();
            brandCategory2.setId(this.idSequence.generateId(BrandCategory.class));
            brandCategory2.setPsCategoryId(categoryId2);
            brandCategory2.setPsBrandId(brandId);
            brandCategoryList.add(brandCategory2);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)brandCategory2);
        }
        this.brandCategoryService.saveBrandCategoryList(brandCategoryList, brand);
    }
}

