/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.BrandClassVO;
import com.xinqiyi.ps.dao.repository.BrandClassService;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.model.dto.brand.BrandClassDTO;
import com.xinqiyi.ps.model.dto.brand.BrandClassStatusDTO;
import com.xinqiyi.ps.model.dto.enums.IsDeleteEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.BrandClass;
import com.xinqiyi.ps.service.adapter.mall4j.MallFourJAdapter;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BrandClassBiz {
    @Autowired
    private BrandClassService brandClassService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private BrandService brandService;
    @Autowired
    private MallFourJAdapter mallFourJAdapter;

    public Long saveBrandClass(ApiRequest<BrandClassDTO> dto) {
        BrandClass brandClassName = this.brandClassService.queryBrandClass(((BrandClassDTO)dto.getJsonData()).getName(), ((BrandClassDTO)dto.getJsonData()).getId());
        Assert.isTrue((brandClassName == null ? 1 : 0) != 0, (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff01");
        BrandClass brandClass = new BrandClass();
        brandClass.setName(((BrandClassDTO)dto.getJsonData()).getName());
        if (((BrandClassDTO)dto.getJsonData()).getId() == null) {
            brandClass.setStatus(StatusEnums.NOT_ENABLED.getCode().toString());
            brandClass.setId(this.idSequence.generateId(BrandClass.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)brandClass);
            this.brandClassService.save((Object)brandClass);
        } else {
            brandClass.setId(((BrandClassDTO)dto.getJsonData()).getId());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)brandClass);
            this.brandClassService.saveBrandClassAndBrand(brandClass);
        }
        try {
            if (((BrandClassDTO)dto.getJsonData()).getId() == null) {
                this.mallFourJAdapter.brandCategorySaveToMallFourJ(CollUtil.newArrayList((Object[])new BrandClass[]{brandClass}));
            } else {
                BrandClass brandClass1 = this.brandClassService.getBrandClass(((BrandClassDTO)dto.getJsonData()).getId());
                brandClass.setStatus(brandClass1.getStatus());
                this.mallFourJAdapter.brandCategoryUpdateToMallFourJ(brandClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return brandClass.getId();
    }

    public void updateStatusBrandClass(BrandClassStatusDTO dto, String operateType) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)dto.getIds()), (String)"\u54c1\u724c\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)operateType, (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List brandClassesList = this.brandClassService.listByIds((Collection)dto.getIds());
        Assert.isTrue((brandClassesList.size() == dto.getIds().size() ? 1 : 0) != 0, (String)"\u54c1\u724c\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
        for (BrandClass brandClass : brandClassesList) {
            BrandClass getBrandClass = new BrandClass();
            getBrandClass.setId(brandClass.getId());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)getBrandClass);
            if (operateType.equals("enable")) {
                Assert.isTrue((!brandClass.getStatus().equals(StatusEnums.ENABLED.getCode().toString()) ? 1 : 0) != 0, (String)"\u54c1\u724c\u5206\u7c7b\u72b6\u6001\u4e3a\u201c\u672a\u542f\u7528/\u505c\u7528\u201d\u65f6\uff0c\u624d\u53ef\u4ee5\u542f\u7528\uff01");
                getBrandClass.setStatus(StatusEnums.ENABLED.getCode().toString());
            }
            if (operateType.equals("disable")) {
                Assert.isTrue((boolean)brandClass.getStatus().equals(StatusEnums.ENABLED.getCode().toString()), (String)"\u54c1\u724c\u5206\u7c7b\u72b6\u6001\u4e3a\u201c\u542f\u7528\u201d\u65f6\uff0c\u624d\u53ef\u4ee5\u505c\u7528\uff01");
                List brands = this.brandService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Brand::getBrandClassId, (Object)Integer.parseInt(brandClass.getId().toString()))).eq(BaseDo::getIsDelete, (Object)0)).eq(Brand::getStatus, (Object)2));
                Assert.isTrue((boolean)CollectionUtil.isEmpty((Collection)brands), (String)(brandClass.getName() + "\u5df2\u5173\u8054\u54c1\u724c\uff01"));
                getBrandClass.setStatus(StatusEnums.STOP_USING.getCode().toString());
            }
            this.brandClassService.updateById((Object)getBrandClass);
            brandClass.setStatus(getBrandClass.getStatus());
            this.mallFourJAdapter.brandCategoryUpdateToMallFourJ(brandClass);
        }
    }

    public List<BrandClassVO> queryBrandClassList(BrandClassDTO dto) {
        List brandClassList = this.brandClassService.queryBrandClassList(dto);
        return BeanConvertUtil.convertList(brandClassList, BrandClassVO.class);
    }

    public BrandClassVO queryBrandClass(Long id) {
        BrandClass brandClass = this.brandClassService.getBrandClass(id);
        BrandClassVO brandClassVO = new BrandClassVO();
        BeanUtils.copyProperties((Object)brandClass, (Object)brandClassVO);
        return brandClassVO;
    }

    public void deleteStatusBrandClass(BrandClassStatusDTO dto) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)dto.getIds()), (String)"\u54c1\u724c\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList brandClasses = new ArrayList();
        dto.getIds().forEach(id -> {
            BrandClass brandClass = this.brandClassService.getBrandClass(id);
            Assert.notNull((Object)brandClass, (String)"\u54c1\u724c\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
            Assert.isTrue((!brandClass.getStatus().equals(StatusEnums.ENABLED.getCode().toString()) ? 1 : 0) != 0, (String)"\u54c1\u724c\u5206\u7c7b\u72b6\u6001\u4e3a\u201c\u672a\u542f\u7528/\u505c\u7528\u201d\u65f6\uff0c\u624d\u53ef\u4ee5\u5220\u9664\uff01");
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)brandClass);
            brandClass.setIsDelete(IsDeleteEnums.YES.getCode());
            brandClasses.add(brandClass);
            brandClass.setStatus("1");
            this.mallFourJAdapter.brandCategoryUpdateToMallFourJ(brandClass);
        });
        this.brandClassService.updateBatchById(brandClasses);
    }
}

