/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.category.CategoryAttributeVO;
import com.xinqiyi.ps.api.model.vo.category.CategoryAttributeValueVO;
import com.xinqiyi.ps.dao.repository.impl.CategoryAttributeServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.CategoryAttributeValueServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.CategoryServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.SpuAttributeServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.SpuAttributeValueServiceImpl;
import com.xinqiyi.ps.model.dto.category.attribute.CategoryAttributeAddDTO;
import com.xinqiyi.ps.model.dto.category.attribute.CategoryAttributeQueryDTO;
import com.xinqiyi.ps.model.dto.category.attribute.CategoryAttributeStatusUpdateDTO;
import com.xinqiyi.ps.model.dto.category.attribute.CategoryAttributeUpdateDTO;
import com.xinqiyi.ps.model.dto.page.PageResult;
import com.xinqiyi.ps.model.entity.Category;
import com.xinqiyi.ps.model.entity.CategoryAttribute;
import com.xinqiyi.ps.model.entity.CategoryAttributeValue;
import com.xinqiyi.ps.model.entity.SpuAttributeValue;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CategoryAttributeBiz {
    private static final Logger log = LoggerFactory.getLogger(CategoryAttributeBiz.class);
    @Autowired
    private IdSequenceGenerator idSequenceGenerator;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private CategoryAttributeServiceImpl categoryAttributeService;
    @Autowired
    private CategoryServiceImpl categoryService;
    @Autowired
    private CategoryAttributeValueServiceImpl categoryAttributeValueService;
    @Autowired
    private SpuAttributeServiceImpl spuAttributeService;
    @Autowired
    private SpuAttributeValueServiceImpl spuAttributeValueService;

    public void saveCategoryAttribute(CategoryAttributeAddDTO dto) {
        List attributeSortList;
        List list;
        CategoryAttribute categoryAttribute = new CategoryAttribute();
        BeanUtils.copyProperties((Object)dto, (Object)categoryAttribute);
        if ((Integer.valueOf(1).equals(dto.getType()) || Integer.valueOf(4).equals(dto.getType())) && CollUtil.isEmpty((Collection)dto.getValueList())) {
            throw new IllegalArgumentException("\u8868\u5355\u6837\u5f0f\u4e3a\u4e0b\u62c9\u5355\u9009\u6216\u4e0b\u62c9\u591a\u9009\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Category category = (Category)this.categoryService.getById((Serializable)dto.getPsCategoryId());
        Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        List childCategoryList = this.categoryService.getByPid(category.getId());
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)childCategoryList), (String)"\u53ea\u80fd\u9009\u62e9\u6700\u672b\u7ea7\u7c7b\u76ee\uff01");
        CategoryAttribute categoryByName = this.categoryAttributeService.selectCategoryByName(dto.getPsCategoryId(), dto.getName());
        Assert.isTrue((null == categoryByName ? 1 : 0) != 0, (String)"\u540c\u4e00\u7c7b\u76ee\u4e0b\u7684\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        Long attributeId = this.idSequenceGenerator.generateId(CategoryAttribute.class);
        categoryAttribute.setId(attributeId);
        categoryAttribute.setStatus(Integer.valueOf(1));
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)categoryAttribute);
        List<CategoryAttributeValue> categoryAttributeValueList = this.getCategoryAttributeValueList(dto.getValueList(), attributeId);
        ArrayList<CategoryAttribute> attributeList = new ArrayList<CategoryAttribute>();
        if (ObjectUtil.isNotNull((Object)dto.getSort()) && CollUtil.isNotEmpty((Collection)(list = this.categoryAttributeService.selectCategoryAttributeBySort(dto.getSort(), null))) && CollUtil.isNotEmpty((Collection)(attributeSortList = this.categoryAttributeService.selectAllBySort(dto.getSort(), null)))) {
            CategoryAttribute categoryAttribute1;
            Integer count = dto.getSort();
            Iterator iterator = attributeSortList.iterator();
            while (iterator.hasNext() && count.equals((categoryAttribute1 = (CategoryAttribute)iterator.next()).getSort())) {
                Integer n = count;
                count = count + 1;
                categoryAttribute1.setSort(count);
                attributeList.add(categoryAttribute1);
            }
        }
        this.categoryAttributeService.saveCategoryAttribute(categoryAttribute, attributeList, categoryAttributeValueList);
    }

    public void updateCategoryAttribute(CategoryAttributeUpdateDTO dto) {
        List attributeSortList;
        List list;
        CategoryAttribute categoryAttribute = (CategoryAttribute)this.categoryAttributeService.getById((Serializable)dto.getId());
        Assert.isTrue((null != categoryAttribute ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u5c5e\u6027\u6570\u636e\u4e0d\u5b58\u5728");
        Category category = (Category)this.categoryService.getById((Serializable)dto.getPsCategoryId());
        Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        List childCategoryList = this.categoryService.getByPid(category.getId());
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)childCategoryList), (String)"\u53ea\u80fd\u9009\u62e9\u6700\u672b\u7ea7\u7c7b\u76ee\uff01");
        ArrayList<CategoryAttribute> attributeList = new ArrayList<CategoryAttribute>();
        if (ObjectUtil.isNotNull((Object)dto.getSort()) && !dto.getSort().equals(categoryAttribute.getSort()) && CollUtil.isNotEmpty((Collection)(list = this.categoryAttributeService.selectCategoryAttributeBySort(dto.getSort(), dto.getId()))) && CollUtil.isNotEmpty((Collection)(attributeSortList = this.categoryAttributeService.selectAllBySort(dto.getSort(), dto.getId())))) {
            CategoryAttribute categoryAttribute1;
            Integer count = dto.getSort();
            Iterator iterator = attributeSortList.iterator();
            while (iterator.hasNext() && count.equals((categoryAttribute1 = (CategoryAttribute)iterator.next()).getSort())) {
                Integer n = count;
                count = count + 1;
                categoryAttribute1.setSort(count);
                attributeList.add(categoryAttribute1);
            }
        }
        List<Object> categoryAttributeValueList = new ArrayList();
        if (Integer.valueOf(1).equals(categoryAttribute.getStatus())) {
            CategoryAttribute categoryByName = this.categoryAttributeService.selectCategoryByName(dto.getPsCategoryId(), dto.getName());
            if (null != categoryByName && !dto.getId().equals(categoryByName.getId())) {
                throw new IllegalArgumentException("\u540c\u4e00\u7c7b\u76ee\u4e0b\u7684\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            }
            if ((Integer.valueOf(1).equals(dto.getType()) || Integer.valueOf(4).equals(dto.getType())) && CollUtil.isEmpty((Collection)dto.getValueList())) {
                throw new IllegalArgumentException("\u8868\u5355\u6837\u5f0f\u4e3a\u4e0b\u62c9\u5355\u9009\u6216\u4e0b\u62c9\u591a\u9009\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BeanUtils.copyProperties((Object)dto, (Object)categoryAttribute);
            LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
            if (Integer.valueOf(1).equals(dto.getType()) || Integer.valueOf(4).equals(dto.getType())) {
                categoryAttribute.setNumberAccuracy(null);
                categoryAttribute.setTextLenth(null);
            } else if (Integer.valueOf(2).equals(dto.getType())) {
                categoryAttribute.setNumberAccuracy(null);
            } else if (Integer.valueOf(6).equals(dto.getType())) {
                categoryAttribute.setTextLenth(null);
            }
            categoryAttribute.setUpdateTime(new Date());
            categoryAttribute.setUpdateUserName(userInfo.getName());
            categoryAttributeValueList = this.getCategoryAttributeValueList(dto.getValueList(), dto.getId());
        } else if (Integer.valueOf(2).equals(categoryAttribute.getStatus()) || Integer.valueOf(3).equals(categoryAttribute.getStatus())) {
            if (!dto.getPsCategoryId().equals(categoryAttribute.getPsCategoryId())) {
                throw new IllegalArgumentException("\u7c7b\u76ee\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
            if (!dto.getName().equals(categoryAttribute.getName())) {
                throw new IllegalArgumentException("\u5c5e\u6027\u540d\u79f0\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
            if (!dto.getType().equals(categoryAttribute.getType())) {
                throw new IllegalArgumentException("\u8868\u5355\u6837\u5f0f\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
            if (CollUtil.isNotEmpty((Collection)dto.getValueList())) {
                List valueList = this.categoryAttributeValueService.selectCategoryAttributeValueListByAttrId(dto.getId());
                ArrayList<CategoryAttributeValue> newValueList = new ArrayList<CategoryAttributeValue>();
                for (String value : dto.getValueList()) {
                    boolean flag = true;
                    for (CategoryAttributeValue categoryAttributeValue : valueList) {
                        if (!categoryAttributeValue.getValue().equals(value)) continue;
                        categoryAttributeValueList.add(categoryAttributeValue);
                        newValueList.add(categoryAttributeValue);
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    CategoryAttributeValue categoryAttributeValue = new CategoryAttributeValue();
                    long valueId = this.idSequenceGenerator.generateId(CategoryAttributeValue.class);
                    categoryAttributeValue.setId(Long.valueOf(valueId));
                    categoryAttributeValue.setPsCategoryAttributeId(dto.getId());
                    categoryAttributeValue.setValue(value);
                    this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)categoryAttributeValue);
                    categoryAttributeValueList.add(categoryAttributeValue);
                }
                if (valueList.size() != newValueList.size()) {
                    throw new IllegalArgumentException("\u65e7\u7684\u5c5e\u6027\u503c\u4e0d\u5141\u8bb8\u4fee\u6539");
                }
                if (ObjectUtil.isNotNull((Object)dto.getTextLenth()) && !dto.getTextLenth().equals(categoryAttribute.getTextLenth())) {
                    throw new IllegalArgumentException("\u6587\u672c\u9650\u5236\u957f\u5ea6\u4e0d\u5141\u8bb8\u7f16\u8f91");
                }
                if (ObjectUtil.isNotNull((Object)dto.getNumberAccuracy()) && !dto.getNumberAccuracy().equals(categoryAttribute.getNumberAccuracy())) {
                    throw new IllegalArgumentException("\u6570\u5b57\u7cbe\u5ea6\u4e0d\u5141\u8bb8\u7f16\u8f91");
                }
                BeanUtils.copyProperties((Object)dto, (Object)categoryAttribute);
            }
        }
        this.categoryAttributeService.updateCategoryAttribute(categoryAttribute, attributeList, categoryAttributeValueList);
    }

    private List<CategoryAttributeValue> getCategoryAttributeValueList(List<String> valueList, Long attributeId) {
        ArrayList<CategoryAttributeValue> categoryAttributeValueList = new ArrayList<CategoryAttributeValue>();
        if (CollUtil.isNotEmpty(valueList)) {
            valueList.stream().forEach(value -> {
                CategoryAttributeValue categoryAttributeValue = new CategoryAttributeValue();
                long valueId = this.idSequenceGenerator.generateId(CategoryAttributeValue.class);
                categoryAttributeValue.setId(Long.valueOf(valueId));
                categoryAttributeValue.setPsCategoryAttributeId(attributeId);
                categoryAttributeValue.setValue(value);
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)categoryAttributeValue);
                categoryAttributeValueList.add(categoryAttributeValue);
            });
        }
        return categoryAttributeValueList;
    }

    public void updateCategoryAttributeStatus(CategoryAttributeStatusUpdateDTO dto) {
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        ArrayList categoryAttributeList = new ArrayList();
        dto.getIdList().forEach(id -> {
            CategoryAttribute categoryAttribute = (CategoryAttribute)this.categoryAttributeService.getById((Serializable)id);
            Assert.isTrue((null != categoryAttribute ? 1 : 0) != 0, (String)("\u7c7b\u76ee\u5c5e\u6027\u6570\u636e\u4e0d\u5b58\u5728,id\u4e3a\uff1a" + id));
            if (Integer.valueOf(3).equals(dto.getType())) {
                List list = this.spuAttributeService.selectByCategoryAttributeId(id);
                if (CollUtil.isNotEmpty((Collection)list)) {
                    throw new IllegalArgumentException("\u7c7b\u76ee\u5c5e\u6027\u5df2\u88ab\u5546\u54c1\u4f7f\u7528,\u65e0\u6cd5\u5220\u9664");
                }
                categoryAttribute.setIsDelete(Integer.valueOf(1));
                categoryAttribute.setSort(Integer.valueOf(9999));
            } else if (Integer.valueOf(1).equals(dto.getType())) {
                categoryAttribute.setStatus(Integer.valueOf(2));
            } else if (Integer.valueOf(2).equals(dto.getType())) {
                List list = this.spuAttributeService.selectByCategoryAttributeId(id);
                if (CollUtil.isNotEmpty((Collection)list)) {
                    throw new IllegalArgumentException("\u7c7b\u76ee\u5c5e\u6027\u5df2\u88ab\u5546\u54c1\u4f7f\u7528,\u65e0\u6cd5\u505c\u7528");
                }
                categoryAttribute.setStatus(Integer.valueOf(3));
            }
            categoryAttribute.setUpdateTime(new Date());
            categoryAttribute.setUpdateUserName(userInfo.getName());
            categoryAttributeList.add(categoryAttribute);
        });
        this.categoryAttributeService.updateBatchById(categoryAttributeList);
    }

    public PageResult selectCategoryAttributeList(CategoryAttributeQueryDTO dto) {
        Page page = new Page((long)dto.getPageNum(), (long)dto.getPageSize());
        IPage iPage = this.categoryAttributeService.getCategoryAttributeList(page, dto);
        List<CategoryAttributeVO> categoryAttributeList = BeanConvertUtil.convertList(iPage.getRecords(), CategoryAttributeVO.class);
        return new PageResult(dto.getPageNum(), dto.getPageSize(), page.getTotal()).setData(this.getCategoryAttributeVORes(categoryAttributeList));
    }

    public List<CategoryAttributeVO> selectAllCategoryAttributeList(CategoryAttributeQueryDTO dto) {
        if (ObjectUtil.isNotNull((Object)dto.getPsCategoryId())) {
            Category category = (Category)this.categoryService.getById((Serializable)dto.getPsCategoryId());
            Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u67e5\u8be2\u5931\u8d25");
            if (Integer.valueOf(4).equals(category.getLevel())) {
                Category categoryParent = (Category)this.categoryService.getById((Serializable)category.getPid());
                dto.setPsCategoryId(categoryParent.getId());
            }
        }
        List<CategoryAttributeVO> categoryAttributeList = BeanConvertUtil.convertList(this.categoryAttributeService.selectAllCategoryAttributeList(dto), CategoryAttributeVO.class);
        return this.getCategoryAttributeVORes(categoryAttributeList);
    }

    private List<CategoryAttributeVO> getCategoryAttributeVORes(List<CategoryAttributeVO> categoryAttributeList) {
        if (CollUtil.isNotEmpty(categoryAttributeList)) {
            List ids = categoryAttributeList.stream().map(CategoryAttributeVO::getId).collect(Collectors.toList());
            List categoryIds = categoryAttributeList.stream().map(CategoryAttributeVO::getPsCategoryId).collect(Collectors.toList());
            List categoryList = this.categoryService.queryCategoryList(categoryIds);
            List categoryAttributeValueList = this.categoryAttributeValueService.selectCategoryAttributeValueList(ids);
            categoryAttributeList.stream().forEach(categoryAttributeVO -> {
                if (CollUtil.isNotEmpty((Collection)categoryList)) {
                    categoryList.stream().forEach(category -> {
                        if (categoryAttributeVO.getPsCategoryId().equals(category.getId())) {
                            categoryAttributeVO.setCategoryName(category.getWholeName());
                        }
                    });
                }
                if (CollUtil.isNotEmpty((Collection)categoryAttributeValueList)) {
                    ArrayList categoryAttributeValueVOList = new ArrayList();
                    ArrayList valueName = new ArrayList();
                    categoryAttributeValueList.stream().forEach(value -> {
                        if (categoryAttributeVO.getId().equals(value.getPsCategoryAttributeId())) {
                            CategoryAttributeValueVO valueVO = new CategoryAttributeValueVO();
                            BeanUtils.copyProperties((Object)value, (Object)valueVO);
                            categoryAttributeValueVOList.add(valueVO);
                            valueName.add(value.getValue());
                        }
                    });
                    categoryAttributeVO.setCategoryAttributeValueVOList(categoryAttributeValueVOList);
                    categoryAttributeVO.setValueList(valueName);
                    if (CollUtil.isNotEmpty(valueName)) {
                        categoryAttributeVO.setValue(valueName.stream().collect(Collectors.joining(",")));
                    }
                }
            });
        }
        return categoryAttributeList;
    }

    public CategoryAttributeVO selectCategoryAttributeDetails(Long id) {
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)id), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        CategoryAttribute categoryAttribute = (CategoryAttribute)this.categoryAttributeService.getById((Serializable)id);
        Assert.isTrue((null != categoryAttribute ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u5c5e\u6027\u6570\u636e\u4e0d\u5b58\u5728");
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        ids.add(categoryAttribute.getId());
        categoryIds.add(categoryAttribute.getPsCategoryId());
        List categoryList = this.categoryService.queryCategoryList(categoryIds);
        List categoryAttributeValueList = this.categoryAttributeValueService.selectCategoryAttributeValueList(ids);
        CategoryAttributeVO vo = new CategoryAttributeVO();
        BeanUtils.copyProperties((Object)categoryAttribute, (Object)vo);
        List spuAttributeList = this.spuAttributeService.selectByCategoryAttributeId(vo.getId());
        if (CollUtil.isNotEmpty((Collection)spuAttributeList)) {
            vo.setIsUsed(Boolean.valueOf(true));
        } else {
            vo.setIsUsed(Boolean.valueOf(false));
        }
        if (CollUtil.isNotEmpty((Collection)categoryList)) {
            categoryList.stream().forEach(category -> {
                if (vo.getPsCategoryId().equals(category.getId())) {
                    vo.setCategoryName(category.getWholeName());
                }
            });
        }
        if (CollUtil.isNotEmpty((Collection)categoryAttributeValueList)) {
            List<CategoryAttributeValueVO> categoryAttributeValueVOList = BeanConvertUtil.convertList(categoryAttributeValueList, CategoryAttributeValueVO.class);
            if (CollUtil.isNotEmpty(categoryAttributeValueVOList)) {
                List valueIds = categoryAttributeValueVOList.stream().map(CategoryAttributeValueVO::getId).collect(Collectors.toList());
                CategoryAttributeQueryDTO queryDTO = new CategoryAttributeQueryDTO();
                queryDTO.setCategoryAttributeIds(valueIds);
                List<Long> useIds = this.verifyCategoryAttribute(queryDTO);
                if (CollUtil.isNotEmpty(useIds)) {
                    for (CategoryAttributeValueVO valueVO : categoryAttributeValueVOList) {
                        Long usedId = useIds.stream().filter(a -> a.equals(valueVO.getId())).findAny().orElse(null);
                        if (null != usedId) {
                            valueVO.setIsUsed(Boolean.valueOf(true));
                            continue;
                        }
                        valueVO.setIsUsed(Boolean.valueOf(false));
                    }
                }
            }
            vo.setCategoryAttributeValueVOList(categoryAttributeValueVOList);
            vo.setValueList(categoryAttributeValueVOList.stream().map(CategoryAttributeValueVO::getValue).collect(Collectors.toList()));
            vo.setValue(categoryAttributeValueVOList.stream().map(CategoryAttributeValueVO::getValue).collect(Collectors.joining(",")));
        }
        return vo;
    }

    public List<Long> verifyCategoryAttribute(CategoryAttributeQueryDTO dto) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)dto.getCategoryAttributeIds()), (String)"\u7c7b\u76ee\u5c5e\u6027id\u4e0d\u80fd\u4e3a\u7a7a");
        List list = this.spuAttributeValueService.selectByAttributeValueIds(dto.getCategoryAttributeIds());
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<Long> attributeIds = list.stream().map(SpuAttributeValue::getPsCategoryAttributeValueId).distinct().collect(Collectors.toList());
            return attributeIds;
        }
        return Lists.newArrayList();
    }
}

