/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.mdm.api.SystemConfigApi;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.mdm.model.dto.systemconfig.SystemConfigDTO;
import com.xinqiyi.ps.api.model.vo.BrandCategoryVO;
import com.xinqiyi.ps.api.model.vo.category.CategoryVO;
import com.xinqiyi.ps.dao.mapper.mysql.CategoryMapper;
import com.xinqiyi.ps.dao.repository.SkuShelfService;
import com.xinqiyi.ps.dao.repository.impl.BrandServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.CategoryServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.SpuServiceImpl;
import com.xinqiyi.ps.model.dto.category.CategoryAddDTO;
import com.xinqiyi.ps.model.dto.category.CategoryMoveDTO;
import com.xinqiyi.ps.model.dto.category.CategoryOprDTO;
import com.xinqiyi.ps.model.dto.category.CategoryQueryDTO;
import com.xinqiyi.ps.model.dto.category.CategoryUpdateDTO;
import com.xinqiyi.ps.model.entity.Category;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.service.adapter.mall4j.MallFourJAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CategoryBiz {
    private static final Logger log = LoggerFactory.getLogger(CategoryBiz.class);
    @Autowired
    private CategoryServiceImpl categoryService;
    @Autowired
    private SpuServiceImpl spuService;
    @Autowired
    private BrandServiceImpl brandService;
    @Autowired
    private IdSequenceGenerator idSequenceGenerator;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private MallFourJAdapter mallFourJAdapter;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private SystemConfigApi systemConfigApi;
    @Autowired
    private SkuShelfService skuShelfService;
    @Autowired
    private UserInfoUtil userInfoUtil;

    public Long saveCategory(CategoryAddDTO dto) {
        int sort;
        Long pid = ObjectUtil.isNotNull((Object)dto.getPid()) ? dto.getPid() : Long.valueOf(0L);
        Category category = this.categoryService.selectCategoryByPidAndName(pid, dto.getName(), dto.getPsStoreId());
        Assert.isTrue((null == category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        int level = 1;
        Object wholeName = "";
        if (0L != pid) {
            Category parentCategory = (Category)this.categoryService.getById((Serializable)pid);
            Assert.isTrue((null != parentCategory ? 1 : 0) != 0, (String)"\u7236\u7ea7\u7c7b\u76ee\u4e0d\u5b58\u5728");
            level = parentCategory.getLevel() + 1;
            wholeName = parentCategory.getWholeName() + "-" + dto.getName();
        } else {
            wholeName = dto.getName();
        }
        if (level <= 3) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getLogoUrl()), (String)"\u7c7b\u76ee\u4e09\u7ea7\u53ca\u4e09\u7ea7\u4e4b\u524d\uff0c\u7c7b\u76ee\u56fe\u7247\u5fc5\u586b");
        }
        int n = sort = ObjectUtil.isNotNull((Object)this.categoryService.getCategoryForMaxSort(pid)) ? this.categoryService.getCategoryForMaxSort(pid) : 1;
        if (level > 4) {
            throw new IllegalArgumentException("\u7c7b\u76ee\u7ea7\u522b\u6700\u591a\u4e3a4\u7ea7");
        }
        category = new Category();
        BeanUtils.copyProperties((Object)dto, (Object)category);
        Long id = this.idSequenceGenerator.generateId(Category.class);
        category.setId(id);
        category.setLevel(Integer.valueOf(level));
        category.setPid(pid);
        category.setStatus(Integer.valueOf(1));
        if (dto.getEnabledStatus() != null && dto.getEnabledStatus() == 2) {
            category.setStatus(Integer.valueOf(2));
        }
        category.setWholeName((String)wholeName);
        category.setSort(Integer.valueOf(sort + 1));
        category.setIsDelete(Integer.valueOf(0));
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)category);
        this.categoryService.save((Object)category);
        this.mallFourJAdapter.psCategorySaveToMallFourJ(CollUtil.newArrayList((Object[])new Category[]{category}));
        return id;
    }

    public void updateCategory(Set<Long> oldCategoryIds, Long newCategoryId, String categoryName) {
        List spuList = this.spuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Spu::getPsCategoryId, oldCategoryIds)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        if (CollUtil.isEmpty((Collection)spuList)) {
            return;
        }
        ArrayList spuArrayList = CollUtil.newArrayList((Object[])new Spu[0]);
        for (Spu spu : spuList) {
            Spu s = new Spu();
            s.setId(spu.getId());
            s.setPsCategoryId(newCategoryId);
            s.setPsCategoryName(categoryName);
            spuArrayList.add(s);
        }
        this.spuService.updateBatchById((Collection)spuArrayList);
    }

    public void updateCategory(CategoryUpdateDTO dto) {
        LoginUserInfo userInfo;
        Category category = (Category)this.categoryService.getById((Serializable)dto.getId());
        Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        if (category.getLevel() <= 3) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getLogoUrl()), (String)"\u7c7b\u76ee\u4e09\u7ea7\u53ca\u4e09\u7ea7\u4e4b\u524d\uff0c\u7c7b\u76ee\u56fe\u7247\u5fc5\u586b");
        }
        if (Integer.valueOf(1).equals(category.getStatus())) {
            Category oldCategory;
            if (StringUtils.isNotEmpty((CharSequence)dto.getName()) && null != (oldCategory = this.categoryService.selectCategoryByPidAndName(category.getPid(), dto.getName(), dto.getPsStoreId())) && !dto.getId().equals(oldCategory.getId())) {
                throw new IllegalArgumentException("\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            }
            category.setWholeName(category.getWholeName().replace(category.getName(), dto.getName()));
            category.setName(dto.getName());
            category.setLogoUrl(dto.getLogoUrl());
            if (StringUtils.isNotEmpty((CharSequence)dto.getAttribute())) {
                category.setAttribute(dto.getAttribute());
            }
        } else if (Integer.valueOf(2).equals(category.getStatus())) {
            if (StringUtils.isNotEmpty((CharSequence)dto.getAttribute())) {
                category.setAttribute(dto.getAttribute());
            }
            if (StringUtils.isNotEmpty((CharSequence)dto.getLogoUrl())) {
                category.setLogoUrl(dto.getLogoUrl());
            }
        } else if (Integer.valueOf(3).equals(category.getStatus())) {
            if (StringUtils.isNotEmpty((CharSequence)dto.getAttribute())) {
                category.setAttribute(dto.getAttribute());
            }
            if (StringUtils.isNotEmpty((CharSequence)dto.getLogoUrl())) {
                category.setLogoUrl(dto.getLogoUrl());
            }
        }
        Assert.isTrue((null != (userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        category.setUpdateTime(new Date());
        category.setUpdateUserName(userInfo.getName());
        this.categoryService.updateById((Object)category);
        this.mallFourJAdapter.psCategoryUpdateToMallFourJ(category);
    }

    public void updateCategoryStatus(CategoryOprDTO dto) {
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        Category category = (Category)this.categoryService.getById((Serializable)dto.getId());
        Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        Long psStoreId = category.getPsStoreId();
        if (Integer.valueOf(3).equals(dto.getType())) {
            Assert.isTrue((boolean)this.isNotUsed(dto.getId()), (String)"\u5f53\u524d\u7c7b\u76ee\u5df2\u5173\u8054\u5546\u54c1\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            List categoryList = this.categoryService.getByPid(dto.getId());
            Assert.isTrue((boolean)CollUtil.isEmpty((Collection)categoryList), (String)"\u53ea\u80fd\u5220\u9664\u6700\u672b\u7ea7\u7c7b\u76ee");
            List spuList = this.spuService.selectSpuByCategoryId(dto.getId());
            List brandList = this.brandService.queryBrandByCategoryId(dto.getId());
            if (CollUtil.isNotEmpty((Collection)spuList)) {
                throw new IllegalArgumentException("\u5f53\u524d\u7c7b\u76ee\u5df2\u88ab\u5546\u54c1\u4f7f\u7528,\u65e0\u6cd5\u5220\u9664");
            }
            if (CollUtil.isNotEmpty((Collection)brandList)) {
                throw new IllegalArgumentException("\u5f53\u524d\u7c7b\u76ee\u5df2\u88ab\u54c1\u724c\u4f7f\u7528,\u65e0\u6cd5\u5220\u9664");
            }
            category.setIsDelete(Integer.valueOf(1));
            category.setSort(Integer.valueOf(9999));
            category.setUpdateTime(new Date());
            category.setUpdateUserName(userInfo.getName());
            this.categoryService.updateById((Object)category);
        } else if (Integer.valueOf(1).equals(dto.getType())) {
            ArrayList<Long> childIds = new ArrayList<Long>();
            childIds.add(category.getId());
            Set<Long> categoryIdList = this.selectParentCategoryId(null, childIds, psStoreId);
            category.setStatus(Integer.valueOf(2));
            category.setUpdateTime(new Date());
            category.setUpdateUserName(userInfo.getName());
            this.categoryService.enableCategory(category, categoryIdList);
            List categoryList = this.categoryService.selectByPidEnableList(category);
            if (0L != category.getPid() && CollUtil.isEmpty((Collection)categoryList)) {
                ArrayList childrenIds = CollUtil.newArrayList((Object[])new Long[]{category.getId()});
                Set<Long> parentIds = this.selectParentCategoryId(2, childrenIds, psStoreId);
                this.updateCategory(parentIds, category.getId(), category.getName());
            }
        } else if (Integer.valueOf(2).equals(dto.getType())) {
            Assert.isTrue((boolean)this.isNotUsed(dto.getId()), (String)"\u5f53\u524d\u7c7b\u76ee\u5df2\u5173\u8054\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff01");
            ArrayList<Category> list = new ArrayList<Category>();
            List<Category> categoryList = this.getChildList(dto.getId(), list);
            categoryList.add(category);
            categoryList.stream().forEach(a -> {
                List spuList = this.spuService.selectSpuByCategoryId(a.getId());
                List brandList = this.brandService.queryBrandByCategoryId(dto.getId());
                if (CollUtil.isNotEmpty((Collection)spuList)) {
                    throw new IllegalArgumentException("\u5f53\u524d\u7c7b\u76ee\u6216\u5b50\u7ea7\u7c7b\u76ee\u5df2\u88ab\u5546\u54c1\u4f7f\u7528,\u65e0\u6cd5\u505c\u7528\uff0c\u88ab\u4f7f\u7528\u7684\u7c7b\u76ee\u4e3a\uff1a" + a.getName());
                }
                if (CollUtil.isNotEmpty((Collection)brandList)) {
                    throw new IllegalArgumentException("\u5f53\u524d\u7c7b\u76ee\u6216\u5b50\u7ea7\u7c7b\u76ee\u5df2\u88ab\u54c1\u724c\u4f7f\u7528,\u65e0\u6cd5\u505c\u7528\uff0c\u88ab\u4f7f\u7528\u7684\u7c7b\u76ee\u4e3a\uff1a" + a.getName());
                }
                a.setStatus(Integer.valueOf(3));
                a.setUpdateTime(new Date());
                a.setUpdateUserName(userInfo.getName());
            });
            this.categoryService.updateBatchById(categoryList);
        }
        if (Integer.valueOf(3).equals(dto.getType())) {
            this.mallFourJAdapter.deleteCategoryToMallFourJ(category);
        } else {
            this.mallFourJAdapter.psCategoryUpdateToMallFourJ(category);
        }
    }

    private boolean isNotUsed(Long categoryId) {
        return this.skuShelfService.selectSkuShelfByCategoryId(categoryId) <= 0L;
    }

    private List<Category> getChildList(Long id, List<Category> categoryList) {
        List list = this.categoryService.getByPid(id);
        if (CollUtil.isNotEmpty((Collection)list)) {
            categoryList.addAll(list);
            list.forEach(category -> this.getChildList(category.getId(), categoryList));
        }
        return categoryList;
    }

    public void sortCategory(List<CategoryMoveDTO> list) {
        ArrayList res = new ArrayList();
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        list.stream().forEach(categoryMoveDTO -> {
            Category category = (Category)this.categoryService.getById((Serializable)categoryMoveDTO.getId());
            Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
            category.setSort(categoryMoveDTO.getSort());
            category.setUpdateTime(new Date());
            category.setUpdateUserName(userInfo.getName());
            res.add(category);
        });
        this.categoryService.updateBatchById(res);
    }

    public List<CategoryVO> selectAllCategory(Integer level, Integer status, Long parentId, String attribute, Long psStoreId) {
        level = ObjectUtil.isNotNull((Object)level) ? level : 4;
        parentId = ObjectUtil.isNotNull((Object)parentId) ? parentId : 0L;
        List list = this.categoryService.getAllCategory(status, attribute, psStoreId);
        ArrayList<CategoryVO> result = new ArrayList<CategoryVO>();
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<CategoryVO> res = BeanConvertUtil.convertList(list, CategoryVO.class);
            Long finalParentId = parentId;
            List levelFistList = res.stream().filter(category -> finalParentId.equals(category.getPid())).sorted(Comparator.comparing(CategoryVO::getSort)).collect(Collectors.toList());
            for (CategoryVO vo : levelFistList) {
                vo.setChildren(this.getChild(res, vo, level));
                result.add(vo);
            }
        }
        return result;
    }

    public List<CategoryVO> selectAllCategoryForLiteApp(CategoryQueryDTO dto) {
        Integer level = ObjectUtil.isNotNull((Object)dto.getLevel()) ? dto.getLevel() : 3;
        Long parentId = ObjectUtil.isNotNull((Object)dto.getParentId()) ? dto.getParentId() : 0L;
        SystemConfigDTO systemConfigDTO = new SystemConfigDTO();
        systemConfigDTO.setKeyCode("CATEGORY_ATTRIBUTE");
        ApiResponse systemConfigVOApiResponse = this.systemConfigApi.queryBySystemConfigKeyCode(systemConfigDTO);
        List<Object> attributeList = Lists.newArrayList();
        if (Objects.nonNull(systemConfigVOApiResponse.getContent()) && StringUtils.isNotBlank((CharSequence)((SystemConfigVO)systemConfigVOApiResponse.getContent()).getValue())) {
            String value = ((SystemConfigVO)systemConfigVOApiResponse.getContent()).getValue();
            attributeList = Arrays.stream(value.split(",")).collect(Collectors.toList());
        } else {
            attributeList.add(String.valueOf(1));
        }
        dto.setAttributeList((List)attributeList);
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        if (userInfo.getInternalPurchaseCustomer().containsKey((Object)"storeIdList")) {
            List storeIdList = JSON.parseArray((String)String.valueOf(userInfo.getInternalPurchaseCustomer().get((Object)"storeIdList")), Long.class);
            dto.setPsStoreIdList(storeIdList);
        }
        dto.setPsStoreId(this.userInfoUtil.getStoreId());
        List list = this.categoryService.selectAllCategory(dto);
        if (CollUtil.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List<CategoryVO> res = BeanConvertUtil.convertList(list, CategoryVO.class);
        List<String> imagList = res.stream().map(CategoryVO::getLogoUrl).collect(Collectors.toList());
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(imagList);
        for (CategoryVO categoryVO : res) {
            OssUrlVO ossUrlVO = ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)categoryVO.getLogoUrl(), (CharSequence)item.getUrl())).findAny().orElse(null);
            if (ossUrlVO == null) continue;
            categoryVO.setLogoUrlFull(ossUrlVO.getIntactUrl());
        }
        List<CategoryVO> firstCategoryList = res.stream().filter(one -> one.getLevel().equals(1)).collect(Collectors.toList());
        firstCategoryList.forEach(item -> this.getChildList((CategoryVO)item, res, level));
        firstCategoryList = firstCategoryList.stream().sorted(Comparator.comparing(CategoryVO::getShopQty).reversed().thenComparing(CategoryVO::getSort)).collect(Collectors.toList());
        return firstCategoryList;
    }

    public CategoryVO getChildList(CategoryVO categoryVO, List<CategoryVO> categoryList, Integer level) {
        List categoryVOList = categoryList.stream().filter(one -> one.getPid().equals(categoryVO.getId())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(categoryVOList) && categoryVO.getLevel() != 3) {
            categoryVO.setChildren(categoryVOList);
            Integer shopQty = categoryVOList.stream().map(one -> one.getShopQty()).reduce(Integer::sum).get();
            categoryVO.setShopQty(shopQty);
            for (int i = 0; i < categoryVOList.size(); ++i) {
                CategoryVO categoryVOModel = (CategoryVO)categoryVOList.get(i);
                if (!CollectionUtil.isEmpty((Collection)categoryVOModel.getChildren()) || categoryVO.getLevel() == 3) continue;
                this.getChildList((CategoryVO)categoryVOList.get(i), categoryList, level + 1);
            }
        } else if (CollectionUtils.isEmpty(categoryVOList) && categoryVO.getLevel() != 3 && level <= 4) {
            CategoryVO vo = new CategoryVO();
            BeanUtils.copyProperties((Object)categoryVO, (Object)vo);
            ArrayList child = Lists.newArrayList();
            child.add(vo);
            categoryVO.setChildren((List)child);
            categoryVO.setShopQty(vo.getShopQty());
            this.getChildList(vo, categoryList, level + 1);
        }
        return categoryVO;
    }

    public Set<Long> selectParentCategoryId(Integer status, List<Long> childrenIds, Long psStoreId) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(childrenIds), (String)"\u5b50\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a");
        List list = this.categoryService.getAllCategory(status, "", psStoreId);
        HashSet<Long> result = new HashSet<Long>();
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<CategoryVO> res = BeanConvertUtil.convertList(list, CategoryVO.class);
            List<CategoryVO> childrenList = res.stream().filter(category -> childrenIds.contains(category.getId())).sorted(Comparator.comparing(CategoryVO::getSort)).toList();
            for (CategoryVO vo : childrenList) {
                result.add(vo.getId());
                this.getParentId(res, vo, result);
            }
        }
        return result;
    }

    public List<CategoryVO> selectParentCategoryList(Integer status, Long childrenId, Long psStoreId) {
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)childrenId), (String)"\u5b50\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a");
        List list = this.categoryService.getAllCategory(status, "", psStoreId);
        ArrayList<CategoryVO> result = new ArrayList<CategoryVO>();
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<CategoryVO> res = BeanConvertUtil.convertList(list, CategoryVO.class);
            List childrenList = res.stream().filter(category -> childrenId.equals(category.getId())).sorted(Comparator.comparing(CategoryVO::getSort)).collect(Collectors.toList());
            for (CategoryVO vo : childrenList) {
                this.getParentList(res, vo, result);
            }
        }
        return result;
    }

    private void getParentId(List<CategoryVO> list, CategoryVO categoryVO, Set<Long> result) {
        HashSet<CategoryVO> parentList = new HashSet<CategoryVO>();
        for (CategoryVO vo : list) {
            if (!vo.getId().equals(categoryVO.getPid())) continue;
            parentList.add(vo);
            result.add(vo.getId());
        }
        if (CollUtil.isNotEmpty(parentList)) {
            for (CategoryVO vo : parentList) {
                this.getParentId(list, vo, result);
            }
        }
    }

    private void getParentList(List<CategoryVO> list, CategoryVO categoryVO, List<CategoryVO> result) {
        HashSet<CategoryVO> parentList = new HashSet<CategoryVO>();
        for (CategoryVO vo : list) {
            if (!vo.getId().equals(categoryVO.getPid())) continue;
            parentList.add(vo);
            result.add(vo);
        }
        if (CollUtil.isNotEmpty(parentList)) {
            for (CategoryVO vo : parentList) {
                this.getParentList(list, vo, result);
            }
        }
    }

    public Set<Long> selectChildCategoryId(Integer status, List<Long> parentIds, Long psStoreId) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(parentIds), (String)"\u7236\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a");
        List list = this.categoryService.getAllCategory(status, "", psStoreId);
        HashSet<Long> result = new HashSet<Long>();
        result.addAll(parentIds);
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<CategoryVO> res = BeanConvertUtil.convertList(list, CategoryVO.class);
            List parentList = res.stream().filter(category -> parentIds.contains(category.getPid())).sorted(Comparator.comparing(CategoryVO::getSort)).collect(Collectors.toList());
            for (CategoryVO vo : parentList) {
                result.add(vo.getId());
                this.getChildId(res, vo, result);
            }
        }
        return result;
    }

    private void getChildId(List<CategoryVO> list, CategoryVO categoryVO, Set<Long> result) {
        HashSet<CategoryVO> childList = new HashSet<CategoryVO>();
        for (CategoryVO vo : list) {
            if (!vo.getPid().equals(categoryVO.getId())) continue;
            childList.add(vo);
            result.add(vo.getId());
        }
        if (CollUtil.isNotEmpty(childList)) {
            for (CategoryVO vo : childList) {
                this.getChildId(list, vo, result);
            }
        }
    }

    public List<CategoryVO> getChild(List<CategoryVO> list, CategoryVO categoryVO, Integer level) {
        if (categoryVO.getLevel() >= level) {
            return Collections.emptyList();
        }
        return list.stream().filter(vo -> vo.getPid().equals(categoryVO.getId())).peek(vo -> vo.setChildren(this.getChild(list, (CategoryVO)vo, level))).sorted(Comparator.comparing(CategoryVO::getSort)).collect(Collectors.toList());
    }

    public CategoryVO getCategoryDetails(Long id) {
        CategoryVO vo = new CategoryVO();
        Assert.isTrue((null != id ? 1 : 0) != 0, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Category category = (Category)this.categoryService.getById((Serializable)id);
        Assert.isTrue((null != category ? 1 : 0) != 0, (String)"\u7c7b\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        BeanUtils.copyProperties((Object)category, (Object)vo);
        return vo;
    }

    public List<BrandCategoryVO> queryCategoryNames(List<Long> categoryIds) {
        ArrayList<BrandCategoryVO> brandCategoryVOS = new ArrayList<BrandCategoryVO>();
        categoryIds.forEach(categoryId -> {
            BrandCategoryVO brandCategoryVO = new BrandCategoryVO();
            Category category = this.categoryService.queryCategory(categoryId);
            brandCategoryVO.setCategoryId(categoryId);
            brandCategoryVO.setCategoryName(category.getWholeName());
            brandCategoryVOS.add(brandCategoryVO);
        });
        return brandCategoryVOS;
    }

    public Long getPidByCategoryId(Long psCategoryId) {
        Category category = (Category)this.categoryService.getById((Serializable)psCategoryId);
        if (category == null) {
            return null;
        }
        if (category.getLevel() <= 3) {
            return psCategoryId;
        }
        List<CategoryVO> categoryVOS = this.selectParentCategoryList(null, psCategoryId, category.getPsStoreId());
        CategoryVO categoryVO = categoryVOS.stream().filter(item -> item.getLevel() == 3).findAny().orElse(null);
        if (categoryVO != null) {
            return categoryVO.getId();
        }
        return null;
    }

    public CategoryVO selectCategoryByCategoryFullName(String categoryFullName) {
        LambdaQueryWrapper categoryLambdaQueryWrapper = new LambdaQueryWrapper();
        categoryLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)categoryLambdaQueryWrapper.eq(Category::getWholeName, (Object)categoryFullName)).eq(Category::getStatus, (Object)2);
        Category category = (Category)((CategoryMapper)this.categoryService.getBaseMapper()).selectOne((Wrapper)categoryLambdaQueryWrapper);
        if (category == null) {
            return null;
        }
        CategoryVO vo = new CategoryVO();
        BeanUtils.copyProperties((Object)category, (Object)vo);
        return vo;
    }

    public CategoryVO selectCategoryByCategoryFullName(String categoryFullName, Long shopId) {
        LambdaQueryWrapper categoryLambdaQueryWrapper = new LambdaQueryWrapper();
        categoryLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)categoryLambdaQueryWrapper.eq(Category::getWholeName, (Object)categoryFullName)).eq(Category::getStatus, (Object)2)).eq(Category::getPsStoreId, (Object)shopId);
        Category category = (Category)((CategoryMapper)this.categoryService.getBaseMapper()).selectOne((Wrapper)categoryLambdaQueryWrapper);
        if (category == null) {
            return null;
        }
        CategoryVO vo = new CategoryVO();
        BeanUtils.copyProperties((Object)category, (Object)vo);
        return vo;
    }

    public CategoryVO selectCategoryByPidAndName(Long pid, String categoryName, Long shopId) {
        Category category = this.categoryService.selectCategoryByPidAndName(pid, categoryName, shopId);
        if (category == null) {
            return null;
        }
        CategoryVO vo = new CategoryVO();
        BeanUtils.copyProperties((Object)category, (Object)vo);
        return vo;
    }

    public CategoryBiz(CategoryServiceImpl categoryService, SpuServiceImpl spuService, BrandServiceImpl brandService, IdSequenceGenerator idSequenceGenerator, BaseDaoInitialService baseDaoInitialService, GateWayWebAuthService gateWayWebAuthService, MallFourJAdapter mallFourJAdapter, ScAdapter scAdapter, SystemConfigApi systemConfigApi, SkuShelfService skuShelfService, UserInfoUtil userInfoUtil) {
        this.categoryService = categoryService;
        this.spuService = spuService;
        this.brandService = brandService;
        this.idSequenceGenerator = idSequenceGenerator;
        this.baseDaoInitialService = baseDaoInitialService;
        this.gateWayWebAuthService = gateWayWebAuthService;
        this.mallFourJAdapter = mallFourJAdapter;
        this.scAdapter = scAdapter;
        this.systemConfigApi = systemConfigApi;
        this.skuShelfService = skuShelfService;
        this.userInfoUtil = userInfoUtil;
    }
}

