/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.BigDecimalUtil;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.ps.dao.repository.ComposeSkuService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.util.BeanConvertUtil;
import com.xinqiyi.ps.model.dto.ComposeSkuWeightDTO;
import com.xinqiyi.ps.model.dto.enums.AllocationRuleEnums;
import com.xinqiyi.ps.model.dto.enums.CheckStatusEnums;
import com.xinqiyi.ps.model.dto.enums.IsDeleteEnums;
import com.xinqiyi.ps.model.dto.enums.SpuClassifyEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.sku.ComposeSkuDTO;
import com.xinqiyi.ps.model.dto.sku.QueryComposeSkuDTO;
import com.xinqiyi.ps.model.dto.spu.AllocationRuleDTO;
import com.xinqiyi.ps.model.dto.spu.SpuDTO;
import com.xinqiyi.ps.model.entity.ComposeSku;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.SpuPicture;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.business.PsSceneBiz;
import com.xinqiyi.ps.service.business.SkuBarCodeBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.business.SpuPictureBiz;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ComposeSkuBiz {
    @Autowired
    private SkuService skuService;
    @Autowired
    private ComposeSkuService composeSkuService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private SpuService spuService;
    @Autowired
    private SpuPictureBiz spuPictureBiz;
    @Autowired
    private SkuBarCodeBiz skuBarCodeBiz;
    @Autowired
    private PsSceneBiz psSceneBiz;
    @Autowired
    private MdmAdapter mdmAdapter;

    public ComposeSkuWeightDTO checkSave(List<ComposeSkuDTO> composeSkuList, Integer classify, SpuDTO spuDTO) {
        if (!SpuClassifyEnums.PACK.getCode().equals(classify) && !SpuClassifyEnums.COMPOSE.getCode().equals(classify)) {
            throw new IllegalArgumentException("\u5546\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)spuDTO.getComposeSkuList()), (String)"\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)spuDTO.getAllocationRule()), (String)"\u5206\u644a\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        SystemConfigVO systemConfigVO = this.mdmAdapter.queryBySystemConfigKeyCode("COMPOSE_SKU_ALLOCATION_RULE");
        Assert.notNull((Object)systemConfigVO, (String)"\u5206\u644a\u89c4\u5219\u7cfb\u7edf\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        JSONObject jsonObject = JSON.parseObject((String)systemConfigVO.getValue());
        JSONArray jsonArray = jsonObject.getJSONArray("options");
        List allocationRuleDTOS = jsonArray.toJavaList(AllocationRuleDTO.class);
        List rule = allocationRuleDTOS.stream().filter(item -> StrUtil.equals((CharSequence)item.getValue(), (CharSequence)spuDTO.getAllocationRule())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isNotEmpty(rule), (String)"\u6b64\u5206\u644a\u89c4\u5219\u4e0d\u80fd\u4fdd\u5b58");
        if (AllocationRuleEnums.RATIO.getCode().equals(spuDTO.getAllocationRule()) || AllocationRuleEnums.THERE.getCode().equals(spuDTO.getAllocationRule())) {
            List composeSkuDTOS = composeSkuList.stream().filter(item -> item.getAllocationRatio() == null).collect(Collectors.toList());
            Assert.isTrue((boolean)CollUtil.isEmpty(composeSkuDTOS), (String)"\u5206\u644a\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal totalRatio = composeSkuList.stream().map(ComposeSkuDTO::getAllocationRatio).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (AllocationRuleEnums.RATIO.getCode().equals(spuDTO.getAllocationRule())) {
                Assert.isTrue((boolean)BigDecimalUtil.equals((BigDecimal)totalRatio, (BigDecimal)new BigDecimal("100")), (String)"\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u9700\u7b49\u4e8e100");
            } else if (AllocationRuleEnums.THERE.getCode().equals(spuDTO.getAllocationRule())) {
                Assert.isTrue((boolean)BigDecimalUtils.greaterThan(totalRatio, new BigDecimal("0")), (String)"\u91d1\u989d\u6bd4\u4f8b\u5408\u8ba1\u9700\u5927\u4e8e0");
            }
        }
        String sceneCode = SpuClassifyEnums.PACK.getCode().equals(classify) ? "009" : "010";
        List<String> typeList = this.psSceneBiz.selectByCode(sceneCode);
        BigDecimal netWeight = BigDecimal.ZERO;
        BigDecimal grossWeight = BigDecimal.ZERO;
        BigDecimal volume = BigDecimal.ZERO;
        List skuIdList = composeSkuList.stream().map(ComposeSkuDTO::getPsSkuId).collect(Collectors.toList());
        List skuList = this.skuService.listByIds(skuIdList);
        List spuIdList = skuList.stream().map(Sku::getPsSpuId).distinct().collect(Collectors.toList());
        List spuList = this.spuService.listByIds(spuIdList);
        for (ComposeSkuDTO composeSkuDTO : composeSkuList) {
            ComposeSku composeSku = new ComposeSku();
            if (composeSkuDTO.getId() != null) {
                composeSku = (ComposeSku)this.composeSkuService.getById((Serializable)composeSkuDTO.getId());
                Assert.notNull((Object)composeSku, (String)"\u5546\u54c1\u660e\u7ec6\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            Sku sku = skuList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)composeSkuDTO.getPsSkuId())).findAny().orElse(null);
            Spu spu = spuList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)sku.getPsSpuId())).findAny().orElse(null);
            if (!composeSkuDTO.getPsSkuId().equals(composeSku.getPsSkuId())) {
                Assert.isTrue((boolean)this.skuBiz.checkSkuType(typeList, sku, spu), (String)(sku.getCode() + "\u89c4\u683c\u4e0d\u7b26\u5408\u5546\u54c1\u573a\u666f\u914d\u7f6e\u7c7b\u578b"));
            }
            if (sku != null && sku.getNetWeight() != null) {
                netWeight = netWeight.add(sku.getNetWeight().multiply(new BigDecimal(composeSkuDTO.getComposeNumber())));
            }
            if (sku != null && sku.getGrossWeight() != null) {
                grossWeight = grossWeight.add(sku.getGrossWeight().multiply(new BigDecimal(composeSkuDTO.getComposeNumber())));
            }
            if (sku == null || sku.getVolume() == null) continue;
            volume = volume.add(sku.getVolume().multiply(new BigDecimal(composeSkuDTO.getComposeNumber())));
        }
        ComposeSkuWeightDTO composeSkuWeightDTO = new ComposeSkuWeightDTO();
        composeSkuWeightDTO.setGrossWeight(BigDecimalUtils.convert(grossWeight, 5));
        composeSkuWeightDTO.setNetWeight(BigDecimalUtils.convert(netWeight, 5));
        composeSkuWeightDTO.setVolume(BigDecimalUtils.convert(volume, 2));
        return composeSkuWeightDTO;
    }

    List<ComposeSku> convert(List<ComposeSkuDTO> composeSkuDTOList, Long spuId) {
        ArrayList<ComposeSku> composeSkuList = new ArrayList<ComposeSku>();
        for (ComposeSkuDTO composeSkuDTO : composeSkuDTOList) {
            ComposeSku composeSku = new ComposeSku();
            if (composeSkuDTO.getId() != null) {
                composeSku = (ComposeSku)this.composeSkuService.getById((Serializable)composeSkuDTO.getId());
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)composeSku);
                composeSku.setComposeNumber(composeSkuDTO.getComposeNumber());
                composeSku.setAllocationRatio(composeSkuDTO.getAllocationRatio());
            } else {
                BeanConvertUtil.copyProperties((Object)composeSkuDTO, (Object)composeSku);
                composeSku.setId(this.idSequence.generateId(ComposeSku.class));
                composeSku.setPsSpuId(spuId);
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)composeSku);
            }
            composeSku.setReferenceRatioRule(composeSkuDTO.getReferenceRatioRule());
            composeSkuList.add(composeSku);
        }
        return composeSkuList;
    }

    List<ComposeSku> selectBySpuId(Long spuId) {
        return this.composeSkuService.selectBySpuId(spuId);
    }

    public void deleteComposeSku(Long composeSkuId) {
        ComposeSku composeSku = (ComposeSku)this.composeSkuService.getById((Serializable)composeSkuId);
        Assert.notNull((Object)composeSku, (String)"\u5546\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)composeSku.getIsDelete().equals(IsDeleteEnums.NO.getCode()), (String)"\u5546\u54c1\u660e\u7ec6\u5df2\u5220\u9664");
        Spu spu = (Spu)this.spuService.getById((Serializable)composeSku.getPsSpuId());
        Assert.isTrue((CheckStatusEnums.NOT_CHECK.getCode().equals(spu.getCheckStatus()) || CheckStatusEnums.REJECT_ADD.getCode().equals(spu.getCheckStatus()) || CheckStatusEnums.REJECT_UPDATE.getCode().equals(spu.getCheckStatus()) || CheckStatusEnums.REJECT_ENABLED.getCode().equals(spu.getCheckStatus()) ? 1 : 0) != 0, (String)"\u6b64\u5546\u54c1\u5ba1\u6838\u72b6\u6001\u4e0d\u53ef\u5220\u9664");
        Assert.isTrue((boolean)StatusEnums.NOT_ENABLED.getCode().equals(spu.getStatus()), (String)"\u5546\u54c1\u5df2\u88ab\u542f\u7528\u8fc7,\u4e0d\u53ef\u5220\u9664");
        ComposeSku compose = new ComposeSku();
        compose.setIsDelete(IsDeleteEnums.YES.getCode());
        compose.setId(composeSku.getId());
        this.composeSkuService.updateById((Object)compose);
    }

    List<QueryComposeSkuDTO> selectComposeSku(Long spuId) {
        List<ComposeSku> composeSkuList = this.selectBySpuId(spuId);
        if (CollUtil.isEmpty(composeSkuList)) {
            return CollUtil.newArrayList((Object[])new QueryComposeSkuDTO[0]);
        }
        List composeSkuDTOList = BeanConvertUtil.convertList(composeSkuList, QueryComposeSkuDTO.class);
        List skuIdList = composeSkuDTOList.stream().map(QueryComposeSkuDTO::getPsSkuId).collect(Collectors.toList());
        List skuList = this.skuService.listByIds(skuIdList);
        List<Long> spuIdList = skuList.stream().map(Sku::getPsSpuId).distinct().collect(Collectors.toList());
        List spuList = this.spuService.listByIds(spuIdList);
        List<SpuPicture> spuPictureList = this.spuPictureBiz.getMainBySpuIds(spuIdList);
        for (QueryComposeSkuDTO composeSkuDTO : composeSkuDTOList) {
            Sku sku = skuList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)composeSkuDTO.getPsSkuId())).findAny().orElse(null);
            Spu spu = spuList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)sku.getPsSpuId())).findAny().orElse(null);
            composeSkuDTO.setBarCode(this.skuBarCodeBiz.getBarCode(sku.getId()));
            composeSkuDTO.setCounterPrice(BigDecimalUtils.convert(sku.getCounterPrice(), 2));
            composeSkuDTO.setRetailPrice(BigDecimalUtils.convert(sku.getRetailPrice(), 2));
            composeSkuDTO.setSkuName(sku.getName());
            composeSkuDTO.setSkuCode(sku.getCode());
            composeSkuDTO.setAllowBackgroundOrder(sku.getAllowBackgroundOrder());
            composeSkuDTO.setPsUnitName(spu.getPsUnitName());
            composeSkuDTO.setSpuName(spu.getName());
            composeSkuDTO.setClassify(spu.getClassify());
            composeSkuDTO.setPsBrandName(spu.getPsBrandName());
            composeSkuDTO.setPsBrandId(spu.getPsBrandId());
            composeSkuDTO.setSpuCode(spu.getCode());
            composeSkuDTO.setPsCategoryId(spu.getPsCategoryId());
            composeSkuDTO.setPsCategoryName(spu.getPsCategoryName());
            composeSkuDTO.setWmsThirdPlatformCode(sku.getWmsThirdPlatformCode());
            composeSkuDTO.setKyThirdPlatformCode(sku.getKyThirdPlatformCode());
            SpuPicture spuPicture = spuPictureList.stream().filter(item -> ObjectUtil.equal((Object)spu.getId(), (Object)item.getPsSpuId())).findAny().orElse(null);
            if (spuPicture == null) continue;
            composeSkuDTO.setSpuPicture(spuPicture.getPictureUrl());
        }
        return composeSkuDTOList;
    }
}

