/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.fc.model.enums.FcCommonEnum;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuShelfService;
import com.xinqiyi.ps.dao.repository.SkuSpecService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.enums.SkuShelfStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SkuTypeEnums;
import com.xinqiyi.ps.model.dto.enums.StoreShelfConfigEnum;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.ps.model.dto.mall4j.LangMallFourJDTO;
import com.xinqiyi.ps.model.dto.mall4j.Mall4jServerResponseEntity;
import com.xinqiyi.ps.model.dto.mall4j.SkuMallFourJDTO;
import com.xinqiyi.ps.model.dto.mall4j.SpuForMallFourJDTO;
import com.xinqiyi.ps.model.dto.sku.TransportQueryDTO;
import com.xinqiyi.ps.model.dto.spu.Mall4jDTO;
import com.xinqiyi.ps.model.dto.spu.PhyStorageDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.spu.SupplyPriceMsgDTO;
import com.xinqiyi.ps.model.dto.transport.TransportDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuShelf;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.SpuPicture;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.mall4j.MallFourJAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.CategoryBiz;
import com.xinqiyi.ps.service.business.PhyStorageBiz;
import com.xinqiyi.ps.service.business.SpuPictureBiz;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class Mall4jBiz {
    private static final Logger log = LoggerFactory.getLogger(Mall4jBiz.class);
    @Autowired
    private SkuService skuService;
    @Autowired
    private SkuSpecService skuSpecService;
    @Autowired
    private PhyStorageBiz phyStorageBiz;
    @Autowired
    private SpuPictureBiz spuPictureBiz;
    @Autowired
    private MallFourJAdapter mallFourJAdapter;
    @Autowired
    private SpuService spuService;
    @Autowired
    private MdmAdapter mdmAdapter;
    @Autowired
    private StoreService storeService;
    @Autowired
    private BrandService brandService;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private CategoryBiz categoryBiz;
    @Autowired
    private SkuShelfService skuShelfService;

    public Mall4jDTO covertProdSaveToMallFourJ(List<Long> skuIdList, List<SupplyPriceMsgDTO> dtoList, Store store, List<Brand> brandList, List<Spu> spuList, String type) {
        Mall4jDTO mall4jDTO = new Mall4jDTO();
        ArrayList skuIdArrayList = CollUtil.newArrayList((Object[])new Long[0]);
        try {
            ApiRequest request;
            List idList;
            SpuQueryDTO spuQueryDTO;
            List skuList = this.skuService.listByIds(skuIdList);
            if (CollUtil.isEmpty((Collection)skuList)) {
                return mall4jDTO;
            }
            Page<PhyStorageDTO> phyStorageDTOPage = null;
            if (YesOrNoEnum.YES.getCode().equals(store.getIsDisplayInventory()) && StrUtil.equals((CharSequence)StoreShelfConfigEnum.ONE.getCode(), (CharSequence)store.getShelfConfig())) {
                spuQueryDTO = new SpuQueryDTO();
                spuQueryDTO.setPageSize(999999);
                spuQueryDTO.setPageNum(1);
                spuQueryDTO.setSkuIdList(skuIdList);
                spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
                idList = Arrays.stream(store.getWholesaleInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
                spuQueryDTO.setWarehouseIds(idList);
                request = new ApiRequest();
                request.setJsonData((Object)spuQueryDTO);
                phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
            }
            if (YesOrNoEnum.YES.getCode().equals(store.getIsDfDisplayInventory()) && StrUtil.equals((CharSequence)StoreShelfConfigEnum.TWO.getCode(), (CharSequence)store.getShelfConfig())) {
                spuQueryDTO = new SpuQueryDTO();
                spuQueryDTO.setPageSize(999999);
                spuQueryDTO.setPageNum(1);
                spuQueryDTO.setSkuIdList(skuIdList);
                spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
                idList = Arrays.stream(store.getIssuingInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
                spuQueryDTO.setWarehouseIds(idList);
                request = new ApiRequest();
                request.setJsonData((Object)spuQueryDTO);
                phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
            }
            List<Long> spuIdList = skuList.stream().map(Sku::getPsSpuId).collect(Collectors.toList());
            List<SpuPicture> spuPictureList = this.spuPictureBiz.getBySpuIds(spuIdList);
            List<String> pictureUrlList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
            List skuPictureUrlList = skuList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getPictureUrl())).map(Sku::getPictureUrl).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(skuPictureUrlList)) {
                pictureUrlList.addAll(skuPictureUrlList);
            }
            List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(pictureUrlList);
            ArrayList saveDTOList = CollUtil.newArrayList((Object[])new SpuForMallFourJDTO[0]);
            ArrayList updateDTOList = CollUtil.newArrayList((Object[])new SpuForMallFourJDTO[0]);
            Map<Long, List<Sku>> map = skuList.stream().collect(Collectors.groupingBy(Sku::getPsSpuId));
            ArrayList spus = CollUtil.newArrayList((Object[])new Spu[0]);
            for (List<Sku> list : map.values()) {
                SpuForMallFourJDTO spuForMallFourJDTO = new SpuForMallFourJDTO();
                Spu spu = spuList.stream().filter(item -> ObjectUtil.equal((Object)((Sku)skus.get(0)).getPsSpuId(), (Object)item.getId())).findAny().orElse(null);
                Brand brand = brandList.stream().filter(item -> ObjectUtil.equal((Object)spu.getPsBrandId(), (Object)item.getId())).findAny().orElse(null);
                List spuUrlList = spuPictureList.stream().filter(item -> ObjectUtil.equal((Object)spu.getId(), (Object)item.getPsSpuId())).sorted(Comparator.comparing(SpuPicture::getIsMain).reversed()).map(SpuPicture::getPictureUrl).collect(Collectors.toList());
                String s = ossUrlVOS.stream().filter(item -> spuUrlList.contains(item.getUrl())).map(OssUrlVO::getIntactUrl).collect(Collectors.joining(","));
                spuForMallFourJDTO.setPic(s);
                Long pid = this.categoryBiz.getPidByCategoryId(spu.getPsCategoryId());
                spuForMallFourJDTO.setPsCategoryId(pid);
                if (brand.getBrandClassId() != null) {
                    spuForMallFourJDTO.setPsShopCategoryId(Long.valueOf(brand.getBrandClassId().intValue()));
                }
                spuForMallFourJDTO.setPsBrandId(brand.getId());
                spuForMallFourJDTO.setPsProdCode(spu.getCode());
                spuForMallFourJDTO.setProdName(spu.getName());
                spuForMallFourJDTO.setContent(spu.getDetails());
                LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
                langMallFourJDTO.setLang(Integer.valueOf(0));
                langMallFourJDTO.setLangName("\u4e2d\u6587");
                langMallFourJDTO.setProdName(spu.getName());
                langMallFourJDTO.setContent(spu.getDetails());
                langMallFourJDTO.setBrief(spu.getSellingPoint());
                spuForMallFourJDTO.setProdLangList((List)CollUtil.newArrayList((Object[])new LangMallFourJDTO[]{langMallFourJDTO}));
                ArrayList skuDtoList = CollUtil.newArrayList((Object[])new SkuMallFourJDTO[0]);
                for (Sku sku : list) {
                    OssUrlVO vo;
                    SkuMallFourJDTO skuMallFourJDTO = new SkuMallFourJDTO();
                    skuMallFourJDTO.setSkuId(sku.getId());
                    if (StrUtil.isNotBlank((CharSequence)sku.getPictureUrl()) && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)sku.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                        skuMallFourJDTO.setPic(vo.getIntactUrl());
                    }
                    skuMallFourJDTO.setWeight(null == sku.getGrossWeight() ? BigDecimal.valueOf(0L) : sku.getGrossWeight());
                    skuMallFourJDTO.setVolume(null == sku.getVolume() ? BigDecimal.valueOf(0L) : sku.getVolume());
                    if (phyStorageDTOPage != null) {
                        BigDecimal qtyAvailable = phyStorageDTOPage.getRecords().stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)sku.getId())).map(PhyStorageDTO::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)type)) {
                            skuMallFourJDTO.setStocks(Integer.valueOf(qtyAvailable.multiply(store.getAvailableInventoryProportion()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN).intValue()));
                        }
                        if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)type)) {
                            skuMallFourJDTO.setStocks(Integer.valueOf(qtyAvailable.multiply(store.getDfAvailableRatio()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN).intValue()));
                        }
                    } else {
                        skuMallFourJDTO.setStocks(Integer.valueOf(0));
                    }
                    SupplyPriceMsgDTO dto = dtoList.stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)sku.getId())).findAny().orElse(null);
                    if (dto != null && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)store.getShelfConfig())) {
                        skuMallFourJDTO.setPrice(dto.getPcSupplyPrice());
                    }
                    if (dto != null && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)store.getShelfConfig())) {
                        skuMallFourJDTO.setPrice(dto.getDfSupplyPrice());
                    }
                    if (skuMallFourJDTO.getPrice() == null) {
                        skuMallFourJDTO.setPrice(sku.getCounterPrice());
                    }
                    skuMallFourJDTO.setOriPrice(sku.getCounterPrice());
                    skuMallFourJDTO.setPsSkuCode(sku.getCode());
                    skuMallFourJDTO.setPartyCode(sku.getCode());
                    skuMallFourJDTO.setSkuName(sku.getName());
                    skuMallFourJDTO.setStatus(Integer.valueOf(1));
                    if (StrUtil.equals((CharSequence)"\u9ed8\u8ba4\u89c4\u683c", (CharSequence)sku.getSpecName())) {
                        skuMallFourJDTO.setProperties("\u9ed8\u8ba4\u89c4\u683c:\u9ed8\u8ba4\u89c4\u683c");
                    } else {
                        Object properties = "\u89c4\u683c:";
                        String replace = sku.getSpecValue().replace("-", "_");
                        if (!StrUtil.equals((CharSequence)SkuTypeEnums.NORMAL.getCode().toString(), (CharSequence)String.valueOf(sku.getType()))) {
                            if (replace.startsWith("TJ01")) {
                                replace = replace.replaceFirst("TJ01", "\u7279\u4ef7");
                            } else if (replace.startsWith("01")) {
                                replace = replace.replaceFirst("01", "\u7279\u4ef7");
                            } else if (replace.startsWith("TC01")) {
                                replace = replace.replaceFirst("TC01", "\u7279\u91c7");
                            } else if (replace.startsWith("03")) {
                                replace = replace.replaceFirst("03", "\u7279\u91c7");
                            } else if (replace.startsWith("TJ02")) {
                                replace = replace.replaceFirst("TJ02", "\u7279\u7279\u4ef7");
                            } else if (replace.startsWith("02")) {
                                replace = replace.replaceFirst("02", "\u7279\u7279\u4ef7");
                            } else if (replace.startsWith("04")) {
                                replace = replace.replaceFirst("04", "\u7279\u91c7\u7279\u4ef7");
                            } else if (replace.startsWith("05")) {
                                replace = replace.replaceFirst("05", "\u7279\u91c7\u7279\u7279\u4ef7");
                            }
                        }
                        properties = (String)properties + replace;
                        skuMallFourJDTO.setProperties((String)properties);
                    }
                    LangMallFourJDTO skuLang = new LangMallFourJDTO();
                    skuLang.setLang(Integer.valueOf(0));
                    skuLang.setProdName(sku.getName());
                    skuLang.setSkuName(sku.getName());
                    skuLang.setLangName("\u4e2d\u6587");
                    skuLang.setProperties(skuMallFourJDTO.getProperties());
                    skuMallFourJDTO.setSkuLangList((List)CollUtil.newArrayList((Object[])new LangMallFourJDTO[]{skuLang}));
                    skuDtoList.add(skuMallFourJDTO);
                }
                if (CollUtil.isNotEmpty((Collection)skuDtoList)) {
                    List list2 = skuDtoList.stream().sorted(Comparator.comparing(SkuMallFourJDTO::getPrice)).collect(Collectors.toList());
                    spuForMallFourJDTO.setOriPrice(((SkuMallFourJDTO)list2.get(0)).getOriPrice());
                    spuForMallFourJDTO.setPrice(((SkuMallFourJDTO)list2.get(0)).getPrice());
                }
                spuForMallFourJDTO.setSkuList((List)skuDtoList);
                if (!StrUtil.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)spu.getIsPushMallFourJ())) {
                    saveDTOList.add(spuForMallFourJDTO);
                    spu.setIsPushMallFourJ(YesOrNoEnum.YES.getCode());
                    spus.add(spu);
                    continue;
                }
                updateDTOList.add(spuForMallFourJDTO);
            }
            Mall4jServerResponseEntity<Void> voidMall4jServerResponseEntity = null;
            if (CollUtil.isNotEmpty((Collection)saveDTOList)) {
                log.info("\u5546\u54c1\u540c\u6b65\u5165\u53c2 result=[{}]", (Object)JSON.toJSONString((Object)saveDTOList));
                voidMall4jServerResponseEntity = this.mallFourJAdapter.prodSaveToMallFourJ(saveDTOList);
                log.info("\u5546\u54c1\u540c\u6b65 result=[{}]", (Object)JSON.toJSONString(voidMall4jServerResponseEntity));
                if (voidMall4jServerResponseEntity != null && voidMall4jServerResponseEntity.isSuccess()) {
                    for (SpuForMallFourJDTO spuForMallFourJDTO : saveDTOList) {
                        skuIdArrayList.addAll(spuForMallFourJDTO.getSkuList().stream().map(SkuMallFourJDTO::getSkuId).collect(Collectors.toList()));
                    }
                }
                if (voidMall4jServerResponseEntity != null && !voidMall4jServerResponseEntity.isSuccess()) {
                    mall4jDTO.setSaveMsg(voidMall4jServerResponseEntity.getMsg());
                }
            }
            if (CollUtil.isNotEmpty((Collection)updateDTOList)) {
                log.info("\u5546\u54c1\u4fee\u6539\u5165\u53c2 result=[{}]", (Object)JSON.toJSONString((Object)updateDTOList));
                Mall4jServerResponseEntity<Void> mall4jServerResponseEntity = this.mallFourJAdapter.prodUpdateToMallFourJ(updateDTOList);
                if (mall4jServerResponseEntity != null && mall4jServerResponseEntity.isSuccess()) {
                    for (SpuForMallFourJDTO spuForMallFourJDTO : updateDTOList) {
                        skuIdArrayList.addAll(spuForMallFourJDTO.getSkuList().stream().map(SkuMallFourJDTO::getSkuId).collect(Collectors.toList()));
                    }
                }
                if (mall4jServerResponseEntity != null && !mall4jServerResponseEntity.isSuccess()) {
                    mall4jDTO.setUpdateMsg(mall4jServerResponseEntity.getMsg());
                }
            }
            if (CollUtil.isNotEmpty((Collection)spus) && voidMall4jServerResponseEntity != null && voidMall4jServerResponseEntity.isSuccess()) {
                this.spuService.updateBatchById((Collection)spus);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65MallFourJ \u5546\u57ce\u4fe1\u606f\u5931\u8d25 skuId=[{}], msg=[{}]", (Object)skuIdList.toString(), (Object)e.getMessage());
        }
        mall4jDTO.setSkuId((List)skuIdArrayList);
        return mall4jDTO;
    }

    @Async(value="psAsyncSpuMall4JExecutor")
    public void covertProdUpdateToMallFourJ(List<Sku> skuList, Brand brand, Spu spu, String type) {
        try {
            ApiRequest request;
            List idList;
            SpuQueryDTO spuQueryDTO;
            SystemConfigVO mallSystemConfigVO = this.mdmAdapter.queryBySystemConfigKeyCode("PS_MALL_STORE_ID");
            if (mallSystemConfigVO == null) {
                return;
            }
            Store store = (Store)this.storeService.getById((Serializable)Long.valueOf(mallSystemConfigVO.getValue()));
            if (store == null) {
                return;
            }
            List skuIdList = skuList.stream().map(BaseDo::getId).collect(Collectors.toList());
            List skuShelfList = this.skuShelfService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SkuShelf::getPsStoreId, (Object)store.getId())).eq(SkuShelf::getShelfStatus, (Object)SkuShelfStatusEnums.ENABLED.getCode())).in(SkuShelf::getPsSkuId, skuIdList));
            skuIdList = skuShelfList.stream().map(SkuShelf::getPsSkuId).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(skuIdList)) {
                return;
            }
            skuList = this.skuService.listByIds(skuIdList);
            List dtoList = this.skuService.selectSkuSupplyPriceList(skuIdList);
            Page<PhyStorageDTO> phyStorageDTOPage = null;
            if (YesOrNoEnum.YES.getCode().equals(store.getIsDisplayInventory()) && StrUtil.equals((CharSequence)StoreShelfConfigEnum.ONE.getCode(), (CharSequence)store.getShelfConfig())) {
                spuQueryDTO = new SpuQueryDTO();
                spuQueryDTO.setPageSize(999999);
                spuQueryDTO.setPageNum(1);
                spuQueryDTO.setSkuIdList(skuIdList);
                spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
                idList = Arrays.stream(store.getWholesaleInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
                spuQueryDTO.setWarehouseIds(idList);
                request = new ApiRequest();
                request.setJsonData((Object)spuQueryDTO);
                phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
            }
            if (YesOrNoEnum.YES.getCode().equals(store.getIsDfDisplayInventory()) && StrUtil.equals((CharSequence)StoreShelfConfigEnum.TWO.getCode(), (CharSequence)store.getShelfConfig())) {
                spuQueryDTO = new SpuQueryDTO();
                spuQueryDTO.setPageSize(999999);
                spuQueryDTO.setPageNum(1);
                spuQueryDTO.setSkuIdList(skuIdList);
                spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
                idList = Arrays.stream(store.getIssuingInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
                spuQueryDTO.setWarehouseIds(idList);
                request = new ApiRequest();
                request.setJsonData((Object)spuQueryDTO);
                phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
            }
            SpuForMallFourJDTO spuForMallFourJDTO = new SpuForMallFourJDTO();
            List<SpuPicture> spuPictureList = this.spuPictureBiz.getBySpuIds(CollUtil.newArrayList((Object[])new Long[]{spu.getId()}));
            List<String> pictureUrlList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
            List skuPictureUrlList = skuList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getPictureUrl())).map(Sku::getPictureUrl).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(skuPictureUrlList)) {
                pictureUrlList.addAll(skuPictureUrlList);
            }
            List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(pictureUrlList);
            String url = ossUrlVOS.stream().filter(item -> pictureUrlList.contains(item.getUrl())).map(OssUrlVO::getIntactUrl).collect(Collectors.joining(","));
            spuForMallFourJDTO.setPic(url);
            Long pid = this.categoryBiz.getPidByCategoryId(spu.getPsCategoryId());
            spuForMallFourJDTO.setPsCategoryId(pid);
            if (brand.getBrandClassId() != null) {
                spuForMallFourJDTO.setPsShopCategoryId(Long.valueOf(brand.getBrandClassId().intValue()));
            }
            spuForMallFourJDTO.setPsBrandId(brand.getId());
            spuForMallFourJDTO.setPsProdCode(spu.getCode());
            spuForMallFourJDTO.setProdName(spu.getName());
            spuForMallFourJDTO.setContent(spu.getDetails());
            LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
            langMallFourJDTO.setLang(Integer.valueOf(0));
            langMallFourJDTO.setLangName("\u4e2d\u6587");
            langMallFourJDTO.setProdName(spu.getName());
            langMallFourJDTO.setContent(spu.getDetails());
            langMallFourJDTO.setBrief(spu.getSellingPoint());
            spuForMallFourJDTO.setProdLangList((List)CollUtil.newArrayList((Object[])new LangMallFourJDTO[]{langMallFourJDTO}));
            ArrayList skuDtoList = CollUtil.newArrayList((Object[])new SkuMallFourJDTO[0]);
            for (Sku sku : skuList) {
                OssUrlVO vo;
                SkuMallFourJDTO skuMallFourJDTO = new SkuMallFourJDTO();
                if (StrUtil.isNotBlank((CharSequence)sku.getPictureUrl()) && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)sku.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                    skuMallFourJDTO.setPic(vo.getIntactUrl());
                }
                skuMallFourJDTO.setWeight(null == sku.getGrossWeight() ? BigDecimal.valueOf(0L) : sku.getGrossWeight());
                skuMallFourJDTO.setVolume(null == sku.getVolume() ? BigDecimal.valueOf(0L) : sku.getVolume());
                if (phyStorageDTOPage != null) {
                    BigDecimal qtyAvailable = phyStorageDTOPage.getRecords().stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)sku.getId())).map(PhyStorageDTO::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)type)) {
                        skuMallFourJDTO.setStocks(Integer.valueOf(qtyAvailable.multiply(store.getAvailableInventoryProportion()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN).intValue()));
                    }
                    if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)type)) {
                        skuMallFourJDTO.setStocks(Integer.valueOf(qtyAvailable.multiply(store.getDfAvailableRatio()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN).intValue()));
                    }
                } else {
                    skuMallFourJDTO.setStocks(Integer.valueOf(0));
                }
                SupplyPriceMsgDTO dto = dtoList.stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)sku.getId())).findAny().orElse(null);
                if (dto != null && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)store.getShelfConfig())) {
                    skuMallFourJDTO.setPrice(dto.getPcSupplyPrice());
                }
                if (dto != null && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)store.getShelfConfig())) {
                    skuMallFourJDTO.setPrice(dto.getDfSupplyPrice());
                }
                if (skuMallFourJDTO.getPrice() == null) {
                    skuMallFourJDTO.setPrice(sku.getCounterPrice());
                }
                skuMallFourJDTO.setOriPrice(sku.getCounterPrice());
                skuMallFourJDTO.setPsSkuCode(sku.getCode());
                skuMallFourJDTO.setPartyCode(sku.getCode());
                skuMallFourJDTO.setSkuName(sku.getName());
                skuMallFourJDTO.setStatus(Integer.valueOf(1));
                if (StrUtil.equals((CharSequence)"\u9ed8\u8ba4\u89c4\u683c", (CharSequence)sku.getSpecName())) {
                    skuMallFourJDTO.setProperties("\u9ed8\u8ba4\u89c4\u683c:\u9ed8\u8ba4\u89c4\u683c");
                } else {
                    Object properties = "\u89c4\u683c:";
                    String replace = sku.getSpecValue().replace("-", "_");
                    if (!StrUtil.equals((CharSequence)SkuTypeEnums.NORMAL.getCode().toString(), (CharSequence)String.valueOf(sku.getType()))) {
                        if (replace.startsWith("TJ01")) {
                            replace = replace.replaceFirst("TJ01", "\u7279\u4ef7");
                        } else if (replace.startsWith("01")) {
                            replace = replace.replaceFirst("01", "\u7279\u4ef7");
                        } else if (replace.startsWith("TC01")) {
                            replace = replace.replaceFirst("TC01", "\u7279\u91c7");
                        } else if (replace.startsWith("03")) {
                            replace = replace.replaceFirst("03", "\u7279\u91c7");
                        } else if (replace.startsWith("TJ02")) {
                            replace = replace.replaceFirst("TJ02", "\u7279\u7279\u4ef7");
                        } else if (replace.startsWith("02")) {
                            replace = replace.replaceFirst("02", "\u7279\u7279\u4ef7");
                        } else if (replace.startsWith("04")) {
                            replace = replace.replaceFirst("04", "\u7279\u91c7\u7279\u4ef7");
                        } else if (replace.startsWith("05")) {
                            replace = replace.replaceFirst("05", "\u7279\u91c7\u7279\u7279\u4ef7");
                        }
                    }
                    properties = (String)properties + replace;
                    skuMallFourJDTO.setProperties((String)properties);
                }
                LangMallFourJDTO skuLang = new LangMallFourJDTO();
                skuLang.setLang(Integer.valueOf(0));
                skuLang.setProdName(sku.getName());
                skuLang.setLangName("\u4e2d\u6587");
                skuLang.setProperties(skuMallFourJDTO.getProperties());
                skuMallFourJDTO.setSkuLangList((List)CollUtil.newArrayList((Object[])new LangMallFourJDTO[]{skuLang}));
                skuDtoList.add(skuMallFourJDTO);
            }
            spuForMallFourJDTO.setSkuList((List)skuDtoList);
            ArrayList spuForMallFourJDTOS = CollUtil.newArrayList((Object[])new SpuForMallFourJDTO[]{spuForMallFourJDTO});
            log.info("\u5546\u54c1\u4fee\u6539\u5165\u53c2 result=[{}]", (Object)JSON.toJSONString((Object)spuForMallFourJDTOS));
            this.mallFourJAdapter.prodUpdateToMallFourJ(spuForMallFourJDTOS);
        }
        catch (Exception e) {
            log.error(" \u4fdd\u5b58\u5546\u54c1 \u540c\u6b65MallFourJ \u5546\u57ce\u4fe1\u606f\u5931\u8d25 spuId=[{}], msg=[{}]", (Object)spu.getId(), (Object)e.getMessage());
        }
    }

    public Mall4jServerResponseEntity<Void> covertProdUpdateToMallFourJ(List<Long> skuIdList) {
        try {
            List skuList = this.skuService.listByIds(skuIdList);
            if (CollUtil.isEmpty((Collection)skuList)) {
                return null;
            }
            List<Long> spuIdList = skuList.stream().map(Sku::getPsSpuId).distinct().collect(Collectors.toList());
            List spuList = this.spuService.listByIds(spuIdList);
            List psBrandIdList = spuList.stream().map(Spu::getPsBrandId).collect(Collectors.toList());
            List brandList = this.brandService.listByIds(psBrandIdList);
            List<SpuPicture> spuPictureList = this.spuPictureBiz.getBySpuIds(spuIdList);
            List pictureList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
            ArrayList pictureUrlList = CollUtil.newArrayList(pictureList);
            List skuPictureUrlList = skuList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getPictureUrl())).map(Sku::getPictureUrl).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(skuPictureUrlList)) {
                pictureUrlList.addAll(skuPictureUrlList);
            }
            List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(pictureUrlList);
            ArrayList updateDTOList = CollUtil.newArrayList((Object[])new SpuForMallFourJDTO[0]);
            Map<Long, List<Sku>> map = skuList.stream().collect(Collectors.groupingBy(Sku::getPsSpuId));
            for (List<Sku> skus : map.values()) {
                SpuForMallFourJDTO spuForMallFourJDTO = new SpuForMallFourJDTO();
                Spu spu = spuList.stream().filter(item -> ObjectUtil.equal((Object)((Sku)skus.get(0)).getPsSpuId(), (Object)item.getId())).findAny().orElse(null);
                if (StrUtil.equals((CharSequence)spu.getIsPushMallFourJ(), (CharSequence)FcCommonEnum.YesOrNoStrEnum.YES.getValue())) continue;
                Brand brand = brandList.stream().filter(item -> ObjectUtil.equal((Object)spu.getPsBrandId(), (Object)item.getId())).findAny().orElse(null);
                List spuUrlList = spuPictureList.stream().filter(item -> ObjectUtil.equal((Object)spu.getId(), (Object)item.getPsSpuId())).sorted(Comparator.comparing(SpuPicture::getIsMain).reversed()).map(SpuPicture::getPictureUrl).collect(Collectors.toList());
                String s = ossUrlVOS.stream().filter(item -> spuUrlList.contains(item.getUrl())).map(OssUrlVO::getIntactUrl).collect(Collectors.joining(","));
                spuForMallFourJDTO.setPic(s);
                Long pid = this.categoryBiz.getPidByCategoryId(spu.getPsCategoryId());
                spuForMallFourJDTO.setPsCategoryId(pid);
                if (brand.getBrandClassId() != null) {
                    spuForMallFourJDTO.setPsShopCategoryId(Long.valueOf(brand.getBrandClassId().intValue()));
                }
                spuForMallFourJDTO.setPsBrandId(brand.getId());
                spuForMallFourJDTO.setPsProdCode(spu.getCode());
                spuForMallFourJDTO.setProdName(spu.getName());
                if (brand.getBrandClassId() != null) {
                    spuForMallFourJDTO.setPsShopCategoryId(Long.valueOf(brand.getBrandClassId().intValue()));
                }
                spuForMallFourJDTO.setPsBrandId(brand.getId());
                spuForMallFourJDTO.setPsProdCode(spu.getCode());
                spuForMallFourJDTO.setProdName(spu.getName());
                spuForMallFourJDTO.setContent(spu.getDetails());
                LangMallFourJDTO langMallFourJDTO = new LangMallFourJDTO();
                langMallFourJDTO.setLang(Integer.valueOf(0));
                langMallFourJDTO.setLangName("\u4e2d\u6587");
                langMallFourJDTO.setProdName(spu.getName());
                langMallFourJDTO.setContent(spu.getDetails());
                langMallFourJDTO.setBrief(spu.getSellingPoint());
                spuForMallFourJDTO.setProdLangList((List)CollUtil.newArrayList((Object[])new LangMallFourJDTO[]{langMallFourJDTO}));
                ArrayList skuDtoList = CollUtil.newArrayList((Object[])new SkuMallFourJDTO[0]);
                for (Sku sku : skus) {
                    OssUrlVO vo;
                    SkuMallFourJDTO skuMallFourJDTO = new SkuMallFourJDTO();
                    skuMallFourJDTO.setWeight(null == sku.getGrossWeight() ? BigDecimal.valueOf(0L) : sku.getGrossWeight());
                    skuMallFourJDTO.setVolume(null == sku.getVolume() ? BigDecimal.valueOf(0L) : sku.getVolume());
                    skuMallFourJDTO.setOriPrice(sku.getCounterPrice());
                    skuMallFourJDTO.setPsSkuCode(sku.getCode());
                    skuMallFourJDTO.setPartyCode(sku.getCode());
                    skuMallFourJDTO.setSkuName(sku.getName());
                    skuMallFourJDTO.setStatus(Integer.valueOf(0));
                    if (StrUtil.isNotBlank((CharSequence)sku.getPictureUrl()) && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)sku.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                        skuMallFourJDTO.setPic(vo.getIntactUrl());
                    }
                    if (StrUtil.equals((CharSequence)"\u9ed8\u8ba4\u89c4\u683c", (CharSequence)sku.getSpecName())) {
                        skuMallFourJDTO.setProperties("\u9ed8\u8ba4\u89c4\u683c:\u9ed8\u8ba4\u89c4\u683c");
                    } else {
                        Object properties = "\u89c4\u683c:";
                        String replace = sku.getSpecValue().replace("-", "_");
                        if (!StrUtil.equals((CharSequence)SkuTypeEnums.NORMAL.getCode().toString(), (CharSequence)String.valueOf(sku.getType()))) {
                            if (replace.startsWith("TJ01")) {
                                replace = replace.replaceFirst("TJ01", "\u7279\u4ef7");
                            } else if (replace.startsWith("01")) {
                                replace = replace.replaceFirst("01", "\u7279\u4ef7");
                            } else if (replace.startsWith("TC01")) {
                                replace = replace.replaceFirst("TC01", "\u7279\u91c7");
                            } else if (replace.startsWith("03")) {
                                replace = replace.replaceFirst("03", "\u7279\u91c7");
                            } else if (replace.startsWith("TJ02")) {
                                replace = replace.replaceFirst("TJ02", "\u7279\u7279\u4ef7");
                            } else if (replace.startsWith("02")) {
                                replace = replace.replaceFirst("02", "\u7279\u7279\u4ef7");
                            } else if (replace.startsWith("04")) {
                                replace = replace.replaceFirst("04", "\u7279\u91c7\u7279\u4ef7");
                            } else if (replace.startsWith("05")) {
                                replace = replace.replaceFirst("05", "\u7279\u91c7\u7279\u7279\u4ef7");
                            }
                        }
                        properties = (String)properties + replace;
                        skuMallFourJDTO.setProperties((String)properties);
                    }
                    LangMallFourJDTO skuLang = new LangMallFourJDTO();
                    skuLang.setLang(Integer.valueOf(0));
                    skuLang.setLangName("\u4e2d\u6587");
                    skuLang.setProdName(sku.getName());
                    skuLang.setSkuName(sku.getName());
                    skuLang.setProperties(skuMallFourJDTO.getProperties());
                    skuMallFourJDTO.setSkuLangList((List)CollUtil.newArrayList((Object[])new LangMallFourJDTO[]{skuLang}));
                    skuDtoList.add(skuMallFourJDTO);
                }
                spuForMallFourJDTO.setSkuList((List)skuDtoList);
                updateDTOList.add(spuForMallFourJDTO);
            }
            if (CollUtil.isNotEmpty((Collection)updateDTOList)) {
                Mall4jServerResponseEntity<Void> response = this.mallFourJAdapter.prodUpdateToMallFourJ(updateDTOList);
                return response;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u66f4\u65b0MallFourJ \u5546\u57ce\u4fe1\u606f\u5931\u8d25 skuId=[{}], msg=[{}]", (Object)skuIdList.toString(), (Object)e.getMessage());
        }
        return null;
    }

    public List<TransportDTO> selectTransportList(TransportQueryDTO dto) {
        return this.mallFourJAdapter.selectTransportList(dto);
    }
}

