/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.cus.model.dto.customer.CustomerOrderConfigureDetailsDTO;
import com.xinqiyi.cus.vo.CustomerStatusVO;
import com.xinqiyi.cus.vo.CustomerVO;
import com.xinqiyi.cus.vo.customer.CusCustomerOrderConfigurationVO;
import com.xinqiyi.fc.model.enums.FcCommonEnum;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginFrom;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.util.BigDecimalUtil;
import com.xinqiyi.mc.api.model.vo.act.orderGift.ReturnGiftsVO;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.ps.api.model.vo.SkuClassificationVO;
import com.xinqiyi.ps.api.model.vo.SkuVO;
import com.xinqiyi.ps.api.model.vo.SpuSkuNumVO;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.CategoryService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuShelfService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.StoreBrandSortService;
import com.xinqiyi.ps.dao.repository.StoreCountrySortService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.enums.InventoryShowTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SkuShelfStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SkuTypeEnums;
import com.xinqiyi.ps.model.dto.enums.StoreTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.ps.model.dto.spu.CategorySubscribeDTO;
import com.xinqiyi.ps.model.dto.spu.MiniSpuQueryDTO;
import com.xinqiyi.ps.model.dto.spu.PhyStorageDTO;
import com.xinqiyi.ps.model.dto.spu.PsSkuIdSerialNoDTO;
import com.xinqiyi.ps.model.dto.spu.SkuSubscribeDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryV2DTO;
import com.xinqiyi.ps.model.dto.spu.SpuWithPriceDTO;
import com.xinqiyi.ps.model.dto.store.brandSort.StoreBrandSortDTO;
import com.xinqiyi.ps.model.dto.store.countrySort.StoreCountrySortDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.Category;
import com.xinqiyi.ps.model.entity.CustomPage;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuShelf;
import com.xinqiyi.ps.model.entity.SpuPicture;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.mc.McAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.business.PhyStorageBiz;
import com.xinqiyi.ps.service.business.PsFavoriteBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.business.SpuBiz;
import com.xinqiyi.ps.service.business.SpuPictureBiz;
import com.xinqiyi.ps.service.business.StoreBiz;
import com.xinqiyi.ps.service.business.SystemConfigBiz;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.ParameterColumnHandler;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import com.xinqiyi.sg.basic.api.model.vo.storage.effective.SgBStorageEffectiveBatchVo;
import com.xinqiyi.sg.basic.model.dto.storageeffective.SgStorageEffectiveQueryDto;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MiniAppSpuBiz {
    private static final Logger log = LoggerFactory.getLogger(MiniAppSpuBiz.class);
    public static final String SEARCH_RECORDS_REDIS_KEY = "xinqiyi:ps:liteapp:search_records:";
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private SpuBiz spuBiz;
    @Autowired
    private CusAdapter cusAdapter;
    @Autowired
    private SpuService spuService;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private SkuService skuService;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private StoreService storeService;
    @Autowired
    private PhyStorageBiz phyStorageBiz;
    @Autowired
    private McAdapter mcAdapter;
    @Autowired
    private SpuPictureBiz spuPictureBiz;
    @Autowired
    private BrandService brandService;
    @Resource
    private PsFavoriteBiz psFavoriteBiz;
    @Autowired
    private StoreCountrySortService storeCountrySortService;
    @Autowired
    private StoreBrandSortService storeBrandSortService;
    @Autowired
    private CategoryService categoryService;
    @Resource
    private MdmAdapter mdmAdapter;
    @Resource
    private SkuShelfService skuShelfService;
    @Resource
    private StoreBiz storeBiz;
    @Resource
    private SgStorageQueryAdapter sgStorageQueryAdapter;
    @Resource
    private UserInfoUtil userInfoUtil;
    @Resource
    private SystemConfigBiz configBiz;

    public SpuSkuNumVO selectSpuNum(SpuQueryV2DTO dto) {
        Store store;
        SpuQueryDTO queryDTO = new SpuQueryDTO();
        if (dto.getPsStoreId() == null && (store = (Store)this.storeService.getOne((Wrapper)new QueryWrapper().lambda().eq(Store::getIsDefault, (Object)FcCommonEnum.YesOrNoStrEnum.YES.getValue()), false)) != null) {
            dto.setPsStoreId(store.getId());
        }
        BeanUtils.copyProperties((Object)dto, (Object)queryDTO);
        if (StrUtil.isBlank((CharSequence)queryDTO.getSupplyPriceType()) && this.isNotFavPage(dto)) {
            return new SpuSkuNumVO();
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCondition())) {
            queryDTO.setQueryCondition(queryDTO.getCondition());
        }
        ParameterColumnHandler.convertParameter(queryDTO, CollUtil.newArrayList((Object[])new String[]{"condition"}), "Union");
        this.spuBiz.checkSpuParam(dto);
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        if (CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getQueryCondition()) && this.isNotFavPage(dto)) {
            this.spuBiz.saveSearchRecord(SEARCH_RECORDS_REDIS_KEY + currentLoginUserInfo.getCustomerCode(), queryDTO.getQueryCondition());
        }
        Store store2 = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        Assert.notNull((Object)store2, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        this.skuBiz.covertChildCategory(queryDTO);
        this.skuBiz.covertQueryQtyStorage(queryDTO, store2);
        queryDTO.setPsStoreType(Integer.valueOf(store2.getStoreType()));
        Long mdmDepartmentId = null;
        if (currentLoginUserInfo.getCustomerId() != null) {
            ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(currentLoginUserInfo.getCustomerId());
            Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
            Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
            mdmDepartmentId = ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId();
        }
        if (!this.isNotFavPage(dto)) {
            Long favouriteUserId = currentLoginUserInfo.getUserId();
            dto.setFavouriteUserId(favouriteUserId);
        }
        queryDTO.setPageNum(1);
        queryDTO.setPageSize(1);
        List<Long> skuIdList = this.covertSkuActivity(dto.getIsHasActivity(), queryDTO.getSkuIdList(), queryDTO.getPsStoreId(), queryDTO.getSupplyPriceType(), currentLoginUserInfo.getCustomerId());
        if (CollUtil.isNotEmpty(skuIdList)) {
            queryDTO.setSkuIdList(skuIdList);
        }
        CustomPage page = this.spuService.selectMiniAppSpuPage(dto, queryDTO, currentLoginUserInfo.getCustomerId(), mdmDepartmentId, this.userInfoUtil.isClientAccess(currentLoginUserInfo));
        SpuSkuNumVO spuSkuNumVO = new SpuSkuNumVO();
        spuSkuNumVO.setSpuNum(Long.valueOf(page.getTotal()));
        MiniSpuQueryDTO miniSpuQueryDTO = new MiniSpuQueryDTO();
        BeanUtils.copyProperties((Object)queryDTO, (Object)miniSpuQueryDTO);
        Page skuPage = this.spuService.selectMiniAppSkuPage(miniSpuQueryDTO, currentLoginUserInfo.getCustomerId(), mdmDepartmentId, this.userInfoUtil.isClientAccess(currentLoginUserInfo));
        spuSkuNumVO.setSkuNum(Long.valueOf(skuPage.getTotal()));
        return spuSkuNumVO;
    }

    private boolean isNotFavPage(SpuQueryV2DTO queryDTO) {
        return !Boolean.TRUE.equals(queryDTO.getIsFavourite());
    }

    public CustomPage<SpuWithPriceDTO> selectSpuPage(SpuQueryV2DTO dto) {
        List pictureUrlList;
        ApiRequest request;
        List idList;
        SpuQueryDTO spuQueryDTO;
        List psSkuIdList;
        Store store;
        SpuQueryDTO queryDTO = new SpuQueryDTO();
        if (dto.getPsStoreId() == null && (store = (Store)this.storeService.getOne((Wrapper)new QueryWrapper().lambda().eq(Store::getIsDefault, (Object)FcCommonEnum.YesOrNoStrEnum.YES.getValue()), false)) != null) {
            dto.setPsStoreId(store.getId());
        }
        BeanUtils.copyProperties((Object)dto, (Object)queryDTO);
        if (StrUtil.isBlank((CharSequence)queryDTO.getSupplyPriceType()) && this.isNotFavPage(dto)) {
            return new CustomPage(queryDTO.getPageNum(), queryDTO.getPageSize());
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCondition())) {
            queryDTO.setQueryCondition(queryDTO.getCondition());
        }
        ParameterColumnHandler.convertParameter(queryDTO, CollUtil.newArrayList((Object[])new String[]{"condition"}), "Union");
        this.spuBiz.checkSpuParam(dto);
        Integer shelfStatus = dto.getShelfStatus();
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        if (CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getQueryCondition()) && this.isNotFavPage(dto)) {
            this.spuBiz.saveSearchRecord(SEARCH_RECORDS_REDIS_KEY + currentLoginUserInfo.getCustomerCode(), queryDTO.getQueryCondition());
        }
        Store store2 = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        Assert.notNull((Object)store2, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        this.skuBiz.covertChildCategory(queryDTO);
        this.skuBiz.covertQueryQtyStorage(queryDTO, store2);
        queryDTO.setPsStoreType(Integer.valueOf(store2.getStoreType()));
        CustomerVO customerVO = null;
        if (!currentLoginUserInfo.getLoginFrom().equals((Object)LoginFrom.xqy_dms) && currentLoginUserInfo.getCustomerId() != null) {
            List unionList;
            List retainAllList;
            ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(currentLoginUserInfo.getCustomerId());
            Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
            Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
            customerVO = (CustomerVO)customerVOApiResponse.getContent();
            CustomerOrderConfigureDetailsDTO orderConfigureDetailsDTO = new CustomerOrderConfigureDetailsDTO();
            orderConfigureDetailsDTO.setCustomerId(customerVO.getId());
            CusCustomerOrderConfigurationVO orderConfigurationVO = this.cusAdapter.selectOrderConfigurationForQuerySku(orderConfigureDetailsDTO);
            Assert.isTrue((null != orderConfigurationVO ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5931\u8d25");
            if (null != orderConfigurationVO.getIsExcludeAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsExcludeAll())) {
                return new CustomPage();
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointBrandIds())) {
                List list = retainAllList = CollUtil.isEmpty((Collection)queryDTO.getBrandIds()) ? orderConfigurationVO.getAppointBrandIds() : orderConfigurationVO.getAppointBrandIds().stream().filter(queryDTO.getBrandIds()::contains).collect(Collectors.toList());
                if (CollUtil.isNotEmpty((Collection)retainAllList)) {
                    queryDTO.setBrandIds(retainAllList);
                } else {
                    return new CustomPage();
                }
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointSkuIds())) {
                List list = retainAllList = CollUtil.isEmpty((Collection)queryDTO.getSkuIdList()) ? orderConfigurationVO.getAppointSkuIds() : orderConfigurationVO.getAppointSkuIds().stream().filter(queryDTO.getSkuIdList()::contains).collect(Collectors.toList());
                if (CollUtil.isNotEmpty((Collection)retainAllList)) {
                    queryDTO.setSkuIdList(retainAllList);
                } else {
                    return new CustomPage();
                }
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds())) {
                unionList = CollUtil.isNotEmpty((Collection)queryDTO.getNotBrandIds()) ? Stream.concat(queryDTO.getNotBrandIds().stream(), orderConfigurationVO.getExcludeBrandIds().stream()).distinct().collect(Collectors.toList()) : orderConfigurationVO.getExcludeBrandIds();
                queryDTO.setNotBrandIds(unionList);
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeSkuIds())) {
                unionList = CollUtil.isNotEmpty((Collection)queryDTO.getBlackSkuIdList()) ? Stream.concat(queryDTO.getBlackSkuIdList().stream(), orderConfigurationVO.getExcludeSkuIds().stream()).distinct().collect(Collectors.toList()) : orderConfigurationVO.getExcludeSkuIds();
                queryDTO.setBlackSkuIdList(unionList);
            }
        }
        Long customerId = null;
        Long mdmDepartmentId = null;
        if (customerVO != null) {
            customerId = customerVO.getId();
            mdmDepartmentId = customerVO.getMdmDepartmentId();
        }
        CustomerStatusVO customerStatus = this.cusAdapter.getCustomerStatus();
        if (!this.isNotFavPage(dto)) {
            Long favouriteUserId = currentLoginUserInfo.getUserId();
            dto.setFavouriteUserId(favouriteUserId);
            String permission = this.storeBiz.getPermission(currentLoginUserInfo.getLoginFrom().toString());
            String[] permissions = permission.split(",");
            if (permissions.length > 1) {
                dto.setIsAllPermission(Boolean.valueOf(true));
            } else {
                queryDTO.setSupplyPriceType(permission);
                dto.setIsAllPermission(Boolean.valueOf(false));
            }
            if (!SkuShelfStatusEnums.STOP_USING.getCode().equals(dto.getShelfStatus())) {
                dto.setShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
                queryDTO.setShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
                dto.setFavouriteShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
            }
        }
        CustomPage page = this.spuService.selectMiniAppSpuPage(dto, queryDTO, customerId, mdmDepartmentId, this.userInfoUtil.isClientAccess(currentLoginUserInfo));
        if (!this.isNotFavPage(dto)) {
            if (!SkuShelfStatusEnums.STOP_USING.getCode().equals(shelfStatus)) {
                if (page.getTotal() >= page.getCurrent() * page.getSize()) {
                    dto.setPageNum(1);
                    dto.setPageSize(1);
                    dto.setFavouriteShelfStatus(null);
                    dto.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                    long total = page.getTotal();
                    queryDTO.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                    CustomPage invalidSpuPage = this.spuService.selectMiniAppSpuPage(dto, queryDTO, customerId, mdmDepartmentId, this.userInfoUtil.isClientAccess(currentLoginUserInfo));
                    page.setAllSpuNum(Long.valueOf(total + invalidSpuPage.getTotal()));
                    page.setInvalidSpuNum(Long.valueOf(invalidSpuPage.getTotal()));
                    page.setTotal(page.getAllSpuNum().longValue());
                } else {
                    long total = page.getTotal();
                    long size = page.getCurrent() * page.getSize() - page.getTotal();
                    dto.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                    queryDTO.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                    dto.setFavouriteShelfStatus(null);
                    dto.setPageNum(1);
                    dto.setPageSize((int)size);
                    CustomPage invalidSpuPage = this.spuService.selectMiniAppSpuPage(dto, queryDTO, customerId, mdmDepartmentId, this.userInfoUtil.isClientAccess(currentLoginUserInfo));
                    if (CollUtil.isNotEmpty((Collection)invalidSpuPage.getRecords())) {
                        List records = page.getRecords();
                        if (CollUtil.isEmpty((Collection)records)) {
                            page.setRecords(new ArrayList());
                        }
                        page.getRecords().addAll(invalidSpuPage.getRecords());
                    }
                    page.setAllSpuNum(Long.valueOf(total + invalidSpuPage.getTotal()));
                    page.setInvalidSpuNum(Long.valueOf(invalidSpuPage.getTotal()));
                    page.setTotal(page.getAllSpuNum().longValue());
                    dto.setShelfStatus(shelfStatus);
                    queryDTO.setShelfStatus(shelfStatus);
                }
            } else {
                dto.setFavouriteShelfStatus(null);
                CustomPage spuNum = this.spuService.selectMiniAppSpuNum(dto, queryDTO, customerId, mdmDepartmentId, this.userInfoUtil.isClientAccess(currentLoginUserInfo));
                page.setInvalidSpuNum(Long.valueOf(spuNum.getInvalidSpuNum() == null ? 0L : spuNum.getInvalidSpuNum()));
                page.setAllSpuNum(Long.valueOf(spuNum.getAllSpuNum() == null ? 0L : spuNum.getAllSpuNum()));
            }
        }
        if (CollUtil.isEmpty((Collection)page.getRecords())) {
            return page;
        }
        List spuRecords = page.getRecords();
        List<Long> spuIds = spuRecords.stream().map(SpuWithPriceDTO::getId).collect(Collectors.toList());
        List spuSkuList = this.skuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Sku::getPsSpuId, spuIds)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        Map<Long, List<Sku>> spuIdSkuMap = spuSkuList.stream().collect(Collectors.groupingBy(Sku::getPsSpuId));
        List skuIdList = spuSkuList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List skuShelfList = this.skuShelfService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuShelf::getPsSkuId, skuIdList)).eq(SkuShelf::getPsStoreId, (Object)dto.getPsStoreId())).eq(SkuShelf::getShelfStatus, (Object)SkuShelfStatusEnums.ENABLED.getCode()));
        Map<Long, List<SkuShelf>> skuIdShelfMap = skuShelfList.stream().collect(Collectors.groupingBy(SkuShelf::getPsSkuId));
        List skuSubscribeDTOList = this.skuService.selectSpuSubscribeList(spuIds, customerId, mdmDepartmentId, SkuShelfStatusEnums.ENABLED.getCode(), queryDTO);
        Map<Long, List<SkuSubscribeDTO>> spuSkuSubscribeMap = skuSubscribeDTOList.stream().collect(Collectors.groupingBy(SkuSubscribeDTO::getPsSpuId));
        Page<PhyStorageDTO> phyStorageDTOPage = null;
        if (YesOrNoEnum.YES.getCode().equals(store2.getIsDisplayInventory()) && SupplyPriceTypeEnums.ONE.getCode().equals(queryDTO.getSupplyPriceType()) && this.isNotFavPage(dto)) {
            psSkuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            idList = Arrays.stream(store2.getPcLogicIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setStoreIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        if (YesOrNoEnum.YES.getCode().equals(store2.getIsDfDisplayInventory()) && SupplyPriceTypeEnums.TWO.getCode().equals(queryDTO.getSupplyPriceType()) && this.isNotFavPage(dto)) {
            psSkuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            idList = Arrays.stream(store2.getDfLogicIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setStoreIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        List<Long> skuIds = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
        Integer executeMcRange = null;
        if (!StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
            executeMcRange = 1;
        }
        ArrayList<ReturnGiftsVO> returnGiftsVOS = new ArrayList();
        if (this.isNotFavPage(dto) && customerId != null) {
            returnGiftsVOS = this.mcAdapter.fetchActRuleDesc(skuIds, customerId, executeMcRange);
        }
        List<SpuPicture> spuPictureList = this.spuPictureBiz.getMainBySpuIds(spuIds);
        List<String> imagList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
        List psBrandIdList = page.getRecords().stream().map(SpuWithPriceDTO::getPsBrandId).collect(Collectors.toList());
        List brandList = this.brandService.listByIds(psBrandIdList);
        List brandLogoUrl = brandList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getLogoUrl())).map(Brand::getLogoUrl).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(brandLogoUrl)) {
            imagList.addAll(brandLogoUrl);
        }
        if (CollUtil.isNotEmpty(pictureUrlList = skuSubscribeDTOList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getPictureUrl())).map(SkuSubscribeDTO::getPictureUrl).collect(Collectors.toList()))) {
            imagList.addAll(pictureUrlList);
        }
        List<Object> ossUrlVOS = CollUtil.newArrayList((Object[])new OssUrlVO[0]);
        if (StrUtil.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)queryDTO.getIsThumbnail())) {
            String process = "image/resize,m_pad,h_" + queryDTO.getImageHigh() + ",w_" + queryDTO.getImageWide();
            ossUrlVOS = this.scAdapter.generatePreassignedThumbUrl(imagList, process);
        } else {
            ossUrlVOS = this.scAdapter.generatePreassignedUrl(imagList);
        }
        List records = page.getRecords();
        if (CollUtil.isNotEmpty((Collection)records)) {
            for (SpuWithPriceDTO record : records) {
                List<SkuSubscribeDTO> skuList;
                BigDecimal retailPrice;
                List skuSubscribes = spuSkuSubscribeMap.getOrDefault(record.getId(), new ArrayList());
                if (CollUtil.isNotEmpty((Collection)skuSubscribes)) {
                    List retailPriceList = skuSubscribes.stream().map(SkuSubscribeDTO::getRetailPrice).filter(Objects::nonNull).collect(Collectors.toList());
                    List counterPriceList = skuSubscribes.stream().map(SkuSubscribeDTO::getCounterPrice).filter(Objects::nonNull).collect(Collectors.toList());
                    retailPriceList.addAll(counterPriceList);
                    BigDecimal maxRetailPrice = retailPriceList.stream().max(Comparator.comparing(x -> x)).orElse(null);
                    BigDecimal minRetailPrice = retailPriceList.stream().min(Comparator.comparing(x -> x)).orElse(null);
                    record.setRetailPriceStr("\u00a5" + BigDecimalUtil.setFrontValueScale((BigDecimal)minRetailPrice).toString() + "~" + BigDecimalUtil.setFrontValueScale((BigDecimal)maxRetailPrice).toString());
                }
                record.setIsPc(Boolean.valueOf(false));
                record.setIsDf(Boolean.valueOf(false));
                List<Sku> skus = spuIdSkuMap.get(record.getId());
                for (Sku sku : skus) {
                    Optional<SkuShelf> dfAny;
                    Optional<SkuShelf> pcAny;
                    List<SkuShelf> skuShelves = skuIdShelfMap.get(sku.getId());
                    if (!CollUtil.isNotEmpty(skuShelves) || Boolean.TRUE.equals(dto.getIsAllPermission())) continue;
                    if (SupplyPriceTypeEnums.ONE.getCode().equals(queryDTO.getSupplyPriceType()) && (pcAny = skuShelves.stream().filter(item -> SupplyPriceTypeEnums.ONE.getCode().equals(item.getType())).findAny()).isPresent()) {
                        record.setIsPc(Boolean.valueOf(true));
                    }
                    if (!SupplyPriceTypeEnums.TWO.getCode().equals(queryDTO.getSupplyPriceType()) || !(dfAny = skuShelves.stream().filter(item -> SupplyPriceTypeEnums.TWO.getCode().equals(item.getType())).findAny()).isPresent()) continue;
                    record.setIsDf(Boolean.valueOf(true));
                }
                Brand brand = brandList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)record.getPsBrandId())).findAny().orElse(null);
                if (brand != null) {
                    OssUrlVO vo;
                    record.setPsBrandName(brand.getName());
                    record.setPsBrandLogoUrl(brand.getLogoUrl());
                    if (StrUtil.isNotBlank((CharSequence)brand.getLogoUrl()) && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)brand.getLogoUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                        record.setPsBrandLogoUrlFull(vo.getIntactUrl());
                    }
                }
                if (!this.isNotFavPage(dto)) {
                    record.setMaxPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(record.getMaxAmount())).toString());
                    if (Boolean.TRUE.equals(dto.getIsAllPermission())) {
                        if (SupplyPriceTypeEnums.ONE.getCode().equals(record.getType())) {
                            record.setIsDf(Boolean.valueOf(false));
                            record.setIsPc(Boolean.valueOf(true));
                        } else if (SupplyPriceTypeEnums.TWO.getCode().equals(record.getType())) {
                            record.setIsDf(Boolean.valueOf(true));
                            record.setIsPc(Boolean.valueOf(false));
                        }
                    }
                } else {
                    record.setMaxPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(record.getMaxPrice())).toString());
                }
                record.setMinPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(record.getMinPrice())).toString());
                SpuPicture spuPicture = spuPictureList.stream().filter(item -> item.getPsSpuId().equals(record.getId())).findAny().orElse(null);
                if (spuPicture != null) {
                    record.setMainImageUrl(spuPicture.getPictureUrl());
                    OssUrlVO vo = ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)spuPicture.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null);
                    if (vo != null) {
                        record.setMainImageUrlFull(vo.getIntactUrl());
                    }
                }
                if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store2.getIsUnauthorizedPrice()) && !StrUtil.equals((CharSequence)customerStatus.getAuthenticationStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
                    record.setMinPrice("\u8ba4\u8bc1\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                }
                if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store2.getIsSignPrice()) && !StrUtil.equals((CharSequence)customerStatus.getSignContractStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
                    record.setMinPrice("\u7b7e\u7f72\u5408\u540c\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                }
                if (!BigDecimalUtils.equal(retailPrice = (BigDecimal)(skuList = skuSubscribeDTOList.stream().filter(item -> item.getPsSpuId().equals(record.getId())).collect(Collectors.toList())).stream().map(SkuSubscribeDTO::getRetailPrice).filter(Objects::nonNull).min(Comparator.comparing(x -> x)).orElse(null), new BigDecimal("0"))) {
                    record.setRetailPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)retailPrice).toString());
                } else {
                    record.setRetailPrice(null);
                }
                if (!this.isNotFavPage(dto)) continue;
                List<SkuSubscribeDTO> skuSubscribeDTOS = this.covertSkuList(store2, skuList, currentLoginUserInfo, queryDTO.getSupplyPriceType(), phyStorageDTOPage, ossUrlVOS, spuPictureList, returnGiftsVOS, customerStatus, brandList);
                record.setSkuList(skuSubscribeDTOS);
            }
        }
        return page;
    }

    public List<CategorySubscribeDTO> selectCategoryList(SpuQueryV2DTO dto) {
        SpuQueryDTO queryDTO = new SpuQueryDTO();
        BeanUtils.copyProperties((Object)dto, (Object)queryDTO);
        if (StrUtil.isBlank((CharSequence)queryDTO.getSupplyPriceType()) && this.isNotFavPage(dto)) {
            return CollUtil.newArrayList((Object[])new CategorySubscribeDTO[0]);
        }
        this.spuBiz.checkSpuParam(dto);
        this.skuBiz.covertChildCategory(queryDTO);
        ParameterColumnHandler.convertParameter(queryDTO, CollUtil.newArrayList((Object[])new String[]{"condition"}), "Union");
        Store store = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        this.skuBiz.covertQueryQtyStorage(queryDTO, store);
        this.psFavoriteBiz.handleFavorite(dto);
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(currentLoginUserInfo.getCustomerId());
        Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
        Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        List<Object> lastCategoryList = new ArrayList();
        if (Boolean.TRUE.equals(dto.getIsFavourite())) {
            LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            String permission = this.storeBiz.getPermission(user.getLoginFrom().toString());
            String[] permissions = permission.split(",");
            if (permissions.length > 1) {
                dto.setIsAllPermission(Boolean.valueOf(true));
            } else {
                queryDTO.setSupplyPriceType(permission);
                dto.setSupplyPriceType(permission);
                dto.setIsAllPermission(Boolean.valueOf(false));
            }
            List<CategorySubscribeDTO> lastCategoryDtoList = new ArrayList();
            if (!SkuShelfStatusEnums.STOP_USING.getCode().equals(dto.getShelfStatus())) {
                dto.setShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
                queryDTO.setShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
                lastCategoryDtoList = this.spuService.selectFavCategoryMiniList(dto, queryDTO, currentLoginUserInfo.getCustomerId(), ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId());
                dto.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                queryDTO.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                lastCategoryDtoList.addAll(this.spuService.selectFavCategoryMiniList(dto, queryDTO, currentLoginUserInfo.getCustomerId(), ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId()));
                if (CollUtil.isEmpty(lastCategoryDtoList)) {
                    return lastCategoryDtoList;
                }
                Map<Long, Integer> categoryIdQtyMap = lastCategoryDtoList.stream().collect(Collectors.groupingBy(CategorySubscribeDTO::getCategoryId, Collectors.summingInt(CategorySubscribeDTO::getQty)));
                lastCategoryList = lastCategoryDtoList.stream().collect(Collectors.groupingBy(CategorySubscribeDTO::getCategoryId)).entrySet().stream().map(entry -> {
                    CategorySubscribeDTO categorySubscribeDTO = (CategorySubscribeDTO)((List)entry.getValue()).get(0);
                    categorySubscribeDTO.setQty((Integer)categoryIdQtyMap.get(entry.getKey()));
                    return categorySubscribeDTO;
                }).collect(Collectors.toList());
            } else {
                lastCategoryList = this.spuService.selectFavCategoryMiniList(dto, queryDTO, currentLoginUserInfo.getCustomerId(), ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId());
            }
        } else {
            lastCategoryList = this.spuService.selectCategoryMiniList(dto, queryDTO, currentLoginUserInfo.getCustomerId(), ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId());
        }
        return lastCategoryList;
    }

    public Page<SkuSubscribeDTO> selectSkuPage(MiniSpuQueryDTO queryDTO) {
        ApiRequest request;
        List idList;
        SpuQueryDTO spuQueryDTO;
        List<OssUrlVO> ossUrlVOS;
        List pictureUrlList;
        Page page;
        List<Long> skuIdList;
        Store store;
        log.info("\u5feb\u901f\u8fdb\u8d27\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDTO));
        if (queryDTO.getPsStoreId() == null && (store = (Store)this.storeService.getOne((Wrapper)new QueryWrapper().lambda().eq(Store::getIsDefault, (Object)FcCommonEnum.YesOrNoStrEnum.YES.getValue()), false)) != null) {
            queryDTO.setPsStoreId(store.getId());
        }
        if (StrUtil.isBlank((CharSequence)queryDTO.getSupplyPriceType())) {
            return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCondition())) {
            queryDTO.setQueryCondition(queryDTO.getCondition());
        }
        ParameterColumnHandler.convertParameter(queryDTO, CollUtil.newArrayList((Object[])new String[]{"condition", "keywords"}), "Union");
        this.spuBiz.checkSpuParam(queryDTO);
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        if (CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getQueryCondition())) {
            JSONObject internalPurchaseCustomer = currentLoginUserInfo.getInternalPurchaseCustomer();
            Object storeIdList = internalPurchaseCustomer.get((Object)"storeIdList");
            String key = SEARCH_RECORDS_REDIS_KEY + currentLoginUserInfo.getCustomerCode() + ":" + String.valueOf(storeIdList) + ":" + currentLoginUserInfo.getId();
            this.spuBiz.saveSearchRecord(key, queryDTO.getQueryCondition());
        }
        Store store2 = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        Assert.notNull((Object)store2, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        this.skuBiz.covertChildCategory(queryDTO);
        this.skuBiz.covertQueryQtyStorage(queryDTO, store2);
        queryDTO.setPsStoreType(Integer.valueOf(store2.getStoreType()));
        boolean isBatchManage = store2.getIsBatchManage() == 1;
        CustomerVO customerVO = null;
        CustomerStatusVO customerStatus = null;
        if (!currentLoginUserInfo.getLoginFrom().equals((Object)LoginFrom.xqy_dms) && currentLoginUserInfo.getCustomerId() != null) {
            customerStatus = this.cusAdapter.getCustomerStatus();
            ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(currentLoginUserInfo.getCustomerId());
            Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
            Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
            customerVO = this.cusAdapter.queryCustomerById(currentLoginUserInfo.getCustomerId());
        }
        Long customerId = null;
        Long mdmDepartmentId = null;
        List storeIdList = null;
        String deliveryExpiryDate = null;
        Integer redundantDays = null;
        if (customerVO != null) {
            customerId = customerVO.getId();
            mdmDepartmentId = customerVO.getMdmDepartmentId();
            if (customerVO.getOrderConfigurationVO() != null && "2".equals(customerVO.getOrderConfigurationVO().getSgWarehouseType()) && "1".equals(customerVO.getIsAppointDeliveryStore()) && "1".equals(customerVO.getIsAppointDeliveryExpiryDate())) {
                deliveryExpiryDate = customerVO.getDeliveryExpiryDate();
                storeIdList = customerVO.getOrderConfigurationVO().getSgStoreIds();
                if (customerVO.getCustomerExtend() != null && customerVO.getCustomerExtend().getCusCustomerExtendValue() != null) {
                    redundantDays = customerVO.getCustomerExtend().getCusCustomerExtendValue().getInteger("sap_sales_YY1_LTTS_cco");
                }
            }
        }
        if (CollUtil.isNotEmpty(skuIdList = this.covertSkuActivity(queryDTO.getIsHasActivity(), queryDTO.getSkuIdList(), queryDTO.getPsStoreId(), queryDTO.getSupplyPriceType(), customerId))) {
            queryDTO.setSkuIdList(skuIdList);
        }
        if (null != queryDTO.getIsQueryCustomerOrderConfig() && Boolean.TRUE.equals(queryDTO.getIsQueryCustomerOrderConfig())) {
            List retainAllList;
            Assert.isTrue((null != customerId ? 1 : 0) != 0, (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            CustomerOrderConfigureDetailsDTO orderConfigureDetailsDTO = new CustomerOrderConfigureDetailsDTO();
            orderConfigureDetailsDTO.setCustomerId(customerId);
            CusCustomerOrderConfigurationVO orderConfigurationVO = this.cusAdapter.selectOrderConfigurationForQuerySku(orderConfigureDetailsDTO);
            Assert.isTrue((null != orderConfigurationVO ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5931\u8d25");
            if (null != orderConfigurationVO.getIsExcludeAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsExcludeAll())) {
                return new Page();
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointBrandIds())) {
                List list = retainAllList = CollUtil.isEmpty((Collection)queryDTO.getBrandIds()) ? orderConfigurationVO.getAppointBrandIds() : orderConfigurationVO.getAppointBrandIds().stream().filter(queryDTO.getBrandIds()::contains).collect(Collectors.toList());
                if (CollUtil.isNotEmpty((Collection)retainAllList)) {
                    queryDTO.setBrandIds(retainAllList);
                } else {
                    return new Page();
                }
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointSkuIds())) {
                List list = retainAllList = CollUtil.isEmpty((Collection)queryDTO.getSkuIdList()) ? orderConfigurationVO.getAppointSkuIds() : orderConfigurationVO.getAppointSkuIds().stream().filter(queryDTO.getSkuIdList()::contains).collect(Collectors.toList());
                if (CollUtil.isNotEmpty((Collection)retainAllList)) {
                    queryDTO.setSkuIdList(retainAllList);
                } else {
                    return new Page();
                }
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds())) {
                queryDTO.setExcludeBrandIds(orderConfigurationVO.getExcludeBrandIds());
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeSkuIds())) {
                List unionList = CollUtil.isNotEmpty((Collection)queryDTO.getNotInSkuIdList()) ? Stream.concat(queryDTO.getNotInSkuIdList().stream(), orderConfigurationVO.getExcludeSkuIds().stream()).distinct().collect(Collectors.toList()) : orderConfigurationVO.getExcludeSkuIds();
                queryDTO.setNotInSkuIdList(unionList);
            }
        }
        if (CollUtil.isEmpty((Collection)(page = this.spuService.selectMiniAppSkuPage(queryDTO, customerId, mdmDepartmentId, this.userInfoUtil.isClientAccess(currentLoginUserInfo, queryDTO.getIsRenovation()))).getRecords())) {
            return new Page();
        }
        List<Long> psSkuIdList = page.getRecords().stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
        Integer executeMcRange = null;
        if (!StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
            executeMcRange = 1;
        }
        List<Object> returnGiftsVOS = CollUtil.newArrayList((Object[])new ReturnGiftsVO[0]);
        if (customerId != null) {
            returnGiftsVOS = this.mcAdapter.fetchActRuleDesc(psSkuIdList, currentLoginUserInfo.getCustomerId(), executeMcRange);
        }
        List<Long> spuIds = page.getRecords().stream().map(SkuSubscribeDTO::getPsSpuId).collect(Collectors.toList());
        List<SpuPicture> spuPictureList = this.spuPictureBiz.getMainBySpuIds(spuIds);
        List<String> imagList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
        List brandIdList = page.getRecords().stream().map(SkuSubscribeDTO::getPsBrandId).collect(Collectors.toList());
        List brandList = this.brandService.listByIds(brandIdList);
        if (CollUtil.isNotEmpty((Collection)brandList)) {
            List LogoUrlList = brandList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getLogoUrl())).map(Brand::getLogoUrl).collect(Collectors.toList());
            imagList.addAll(LogoUrlList);
        }
        if (CollUtil.isNotEmpty(pictureUrlList = page.getRecords().stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getPictureUrl())).map(SkuSubscribeDTO::getPictureUrl).collect(Collectors.toList()))) {
            imagList.addAll(pictureUrlList);
        }
        if (StrUtil.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)queryDTO.getIsThumbnail())) {
            String process = "image/resize,m_pad,h_" + queryDTO.getImageHigh() + ",w_" + queryDTO.getImageWide();
            ossUrlVOS = this.scAdapter.generatePreassignedThumbUrl(imagList, process);
        } else {
            ossUrlVOS = this.scAdapter.generatePreassignedUrl(imagList);
        }
        Page<PhyStorageDTO> phyStorageDTOPage = null;
        if (YesOrNoEnum.YES.getCode().equals(store2.getIsDisplayInventory()) && SupplyPriceTypeEnums.ONE.getCode().equals(queryDTO.getSupplyPriceType())) {
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            spuQueryDTO.setDeliveryExpiryDate(deliveryExpiryDate);
            spuQueryDTO.setRedundantDays(redundantDays);
            if (CollUtil.isNotEmpty((Collection)storeIdList)) {
                spuQueryDTO.setStoreIds(storeIdList);
            }
            idList = Arrays.stream(store2.getPcLogicIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setStoreIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        if (YesOrNoEnum.YES.getCode().equals(store2.getIsDfDisplayInventory()) && SupplyPriceTypeEnums.TWO.getCode().equals(queryDTO.getSupplyPriceType())) {
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            spuQueryDTO.setDeliveryExpiryDate(deliveryExpiryDate);
            spuQueryDTO.setRedundantDays(redundantDays);
            if (CollUtil.isNotEmpty((Collection)storeIdList)) {
                spuQueryDTO.setStoreIds(storeIdList);
            }
            idList = Arrays.stream(store2.getDfLogicIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setStoreIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        List<SkuSubscribeDTO> skuSubscribeDTOS = this.covertSkuList(store2, page.getRecords(), currentLoginUserInfo, queryDTO.getSupplyPriceType(), phyStorageDTOPage, ossUrlVOS, spuPictureList, returnGiftsVOS, customerStatus, null);
        if (isBatchManage && CollUtil.isNotEmpty(skuSubscribeDTOS)) {
            this.suppStorageEffectiveBySku(skuSubscribeDTOS);
        }
        Page voPage = new Page();
        voPage.setTotal(page.getTotal());
        voPage.setSize(page.getSize());
        voPage.setCurrent(page.getCurrent());
        voPage.setRecords(skuSubscribeDTOS);
        return voPage;
    }

    private void suppStorageEffectiveBySku(List<SkuSubscribeDTO> skuSubscribeDTOS) {
        List<String> skuCodes = skuSubscribeDTOS.stream().map(SkuSubscribeDTO::getSkuCode).toList();
        SgStorageEffectiveQueryDto queryDto = new SgStorageEffectiveQueryDto();
        queryDto.setSkuEcodes(skuCodes);
        List<SgBStorageEffectiveBatchVo> batchVoList = this.sgStorageQueryAdapter.queryStorageEffectiveBySku(queryDto);
        if (CollUtil.isNotEmpty(batchVoList)) {
            Map<String, List<SgBStorageEffectiveBatchVo>> map = batchVoList.stream().collect(Collectors.groupingBy(SgBStorageEffectiveBatchVo::getPsCSkuEcode));
            skuSubscribeDTOS.forEach(o -> {
                List effectiveBatchVos = (List)map.get(o.getSkuCode());
                if (CollUtil.isNotEmpty((Collection)effectiveBatchVos)) {
                    List<SkuSubscribeDTO.SkuBatchItem> batchItemList = effectiveBatchVos.stream().map(l -> {
                        SkuSubscribeDTO.SkuBatchItem batchItem = new SkuSubscribeDTO.SkuBatchItem();
                        batchItem.setBatchNo(l.getBatchCode());
                        batchItem.setQtyStorage(l.getQtyAvailable());
                        return batchItem;
                    }).toList();
                    o.setSkuBatchItemList(batchItemList);
                }
            });
        }
    }

    private List<Long> covertSkuActivity(String isHasActivity, List<Long> skuIdList, Long storeId, String supplyPriceType, Long customerId) {
        if (CollUtil.isNotEmpty(skuIdList) && skuIdList.contains(-1L)) {
            return skuIdList;
        }
        if (StrUtil.equals((CharSequence)FcCommonEnum.YesOrNoStrEnum.YES.getValue(), (CharSequence)isHasActivity) && customerId != null) {
            List skuShelfList = this.skuShelfService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SkuShelf::getShelfStatus, (Object)SkuShelfStatusEnums.ENABLED.getCode())).eq(SkuShelf::getPsStoreId, (Object)storeId)).eq(SkuShelf::getType, (Object)supplyPriceType));
            if (CollUtil.isEmpty((Collection)skuShelfList)) {
                return CollUtil.newArrayList((Object[])new Long[]{-1L});
            }
            List<Long> skuIdArray = skuShelfList.stream().map(SkuShelf::getPsSkuId).collect(Collectors.toList());
            List<Long> filterSkuId = this.mcAdapter.filterSkuId(skuIdArray, customerId);
            if (CollUtil.isEmpty(filterSkuId)) {
                return CollUtil.newArrayList((Object[])new Long[]{-1L});
            }
            if (CollUtil.isNotEmpty(skuIdList)) {
                List<Long> idList = skuIdList.stream().filter(filterSkuId::contains).collect(Collectors.toList());
                if (CollUtil.isEmpty(idList)) {
                    return CollUtil.newArrayList((Object[])new Long[]{-1L});
                }
                return idList;
            }
            return filterSkuId;
        }
        return null;
    }

    public SkuClassificationVO selectSkuList(MiniSpuQueryDTO queryDTO) {
        SkuClassificationVO result = new SkuClassificationVO();
        if (StrUtil.isBlank((CharSequence)queryDTO.getSupplyPriceType())) {
            return result;
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCondition())) {
            queryDTO.setQueryCondition(queryDTO.getCondition());
        }
        ParameterColumnHandler.convertParameter(queryDTO, CollUtil.newArrayList((Object[])new String[]{"condition"}), "Union");
        this.spuBiz.checkSpuParam(queryDTO);
        Store store = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        this.skuBiz.covertChildCategory(queryDTO);
        this.skuBiz.covertQueryQtyStorage(queryDTO, store);
        queryDTO.setPsStoreType(Integer.valueOf(store.getStoreType()));
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        CustomerVO customerVO = null;
        if (!currentLoginUserInfo.getLoginFrom().equals((Object)LoginFrom.xqy_dms) && currentLoginUserInfo.getCustomerId() != null) {
            ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(currentLoginUserInfo.getCustomerId());
            Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
            Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
            customerVO = (CustomerVO)customerVOApiResponse.getContent();
        }
        Long customerId = null;
        Long mdmDepartmentId = null;
        if (customerVO != null) {
            customerId = customerVO.getId();
            mdmDepartmentId = customerVO.getMdmDepartmentId();
        }
        if (null != queryDTO.getIsQueryCustomerOrderConfig() && Boolean.TRUE.equals(queryDTO.getIsQueryCustomerOrderConfig())) {
            List retainAllList;
            Assert.isTrue((null != customerId ? 1 : 0) != 0, (String)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            CustomerOrderConfigureDetailsDTO orderConfigureDetailsDTO = new CustomerOrderConfigureDetailsDTO();
            orderConfigureDetailsDTO.setCustomerId(customerId);
            CusCustomerOrderConfigurationVO orderConfigurationVO = this.cusAdapter.selectOrderConfigurationForQuerySku(orderConfigureDetailsDTO);
            Assert.isTrue((null != orderConfigurationVO ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5931\u8d25");
            if (null != orderConfigurationVO.getIsExcludeAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsExcludeAll())) {
                return result;
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointBrandIds())) {
                List list = retainAllList = CollUtil.isEmpty((Collection)queryDTO.getBrandIds()) ? orderConfigurationVO.getAppointBrandIds() : orderConfigurationVO.getAppointBrandIds().stream().filter(queryDTO.getBrandIds()::contains).collect(Collectors.toList());
                if (CollUtil.isNotEmpty((Collection)retainAllList)) {
                    queryDTO.setBrandIds(retainAllList);
                } else {
                    return result;
                }
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointSkuIds())) {
                List list = retainAllList = CollUtil.isEmpty((Collection)queryDTO.getSkuIdList()) ? orderConfigurationVO.getAppointSkuIds() : orderConfigurationVO.getAppointSkuIds().stream().filter(queryDTO.getSkuIdList()::contains).collect(Collectors.toList());
                if (CollUtil.isNotEmpty((Collection)retainAllList)) {
                    queryDTO.setSkuIdList(retainAllList);
                } else {
                    return result;
                }
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds())) {
                queryDTO.setExcludeBrandIds(orderConfigurationVO.getExcludeBrandIds());
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeSkuIds())) {
                queryDTO.setExcludeSkuIds(orderConfigurationVO.getExcludeSkuIds());
            }
        }
        List skuSubscribeDTOList = this.spuService.findMiNiAppSkuList(queryDTO, customerId, mdmDepartmentId, this.userInfoUtil.isClientAccess(currentLoginUserInfo));
        Map<Long, Integer> psCategoryIdMap = skuSubscribeDTOList.stream().collect(Collectors.toMap(SkuSubscribeDTO::getPsCategoryId, el -> 1, Integer::sum));
        Map<Long, Integer> psBrandIdMap = skuSubscribeDTOList.stream().collect(Collectors.toMap(SkuSubscribeDTO::getPsBrandId, el -> 1, Integer::sum));
        Map<Long, Integer> countryIdMap = skuSubscribeDTOList.stream().collect(Collectors.toMap(SkuSubscribeDTO::getCountryId, el -> 1, Integer::sum));
        TreeSet<SkuSubscribeDTO> brandCountrySortSet = new TreeSet<SkuSubscribeDTO>(Comparator.comparing(SkuSubscribeDTO::getCountryId));
        List notNullCountrySkuSubscribeDTOList = skuSubscribeDTOList.stream().filter(one -> Objects.nonNull(one.getCountryId())).collect(Collectors.toList());
        brandCountrySortSet.addAll(notNullCountrySkuSubscribeDTOList);
        List<SkuSubscribeDTO> brandCountrySortList = this.brandCountrySort(queryDTO.getPsStoreId(), new ArrayList<SkuSubscribeDTO>(brandCountrySortSet));
        ArrayList brandCountryList = Lists.newArrayList();
        brandCountrySortList.forEach(item -> {
            SkuVO skuVO = new SkuVO();
            skuVO.setId(item.getCountryId());
            skuVO.setName(item.getCountryName());
            skuVO.setQty((Integer)countryIdMap.get(item.getCountryId()));
            brandCountryList.add(skuVO);
        });
        TreeSet<SkuSubscribeDTO> psBrandSet = new TreeSet<SkuSubscribeDTO>(Comparator.comparing(SkuSubscribeDTO::getPsBrandId));
        List notNullBrandSkuSubscribeDTOList = skuSubscribeDTOList.stream().filter(one -> Objects.nonNull(one.getPsBrandId())).collect(Collectors.toList());
        psBrandSet.addAll(notNullBrandSkuSubscribeDTOList);
        List<SkuSubscribeDTO> brandSortList = this.brandSort(queryDTO.getPsStoreId(), new ArrayList<SkuSubscribeDTO>(psBrandSet));
        ArrayList psBrandList = Lists.newArrayList();
        brandSortList.forEach(item -> {
            SkuVO skuVO = new SkuVO();
            skuVO.setId(item.getPsBrandId());
            skuVO.setName(item.getPsBrandName());
            skuVO.setQty((Integer)psBrandIdMap.get(item.getPsBrandId()));
            psBrandList.add(skuVO);
        });
        ArrayList psCategoryList = Lists.newArrayList();
        TreeSet<SkuSubscribeDTO> psCategoryIdSet = new TreeSet<SkuSubscribeDTO>(Comparator.comparing(SkuSubscribeDTO::getPsCategoryId));
        List<SkuSubscribeDTO> notNullCategorySkuSubscribeDTOList = skuSubscribeDTOList.stream().filter(one -> Objects.nonNull(one.getPsCategoryId())).toList();
        psCategoryIdSet.addAll(notNullCategorySkuSubscribeDTOList);
        List<SkuSubscribeDTO> psCategorySortList = this.categorySort(new ArrayList<SkuSubscribeDTO>(psCategoryIdSet), psCategoryIdMap);
        psCategorySortList.forEach(item -> {
            SkuVO skuVO = new SkuVO();
            skuVO.setId(item.getPsCategoryId());
            skuVO.setName(item.getPsCategoryName());
            skuVO.setQty((Integer)psCategoryIdMap.get(item.getPsCategoryId()));
            psCategoryList.add(skuVO);
        });
        result.setPsBrandList((List)psBrandList);
        result.setCountryList((List)brandCountryList);
        result.setPsCategoryList((List)psCategoryList);
        return result;
    }

    public List<SkuSubscribeDTO> brandCountrySort(Long storeId, List<SkuSubscribeDTO> list) {
        List notRepeatList;
        ArrayList resultList = Lists.newArrayList();
        List storeCountrySortList = this.storeCountrySortService.selectSortByStoreId(storeId);
        if (CollectionUtils.isNotEmpty((Collection)storeCountrySortList)) {
            List<StoreCountrySortDTO> sortList = storeCountrySortList.stream().sorted(Comparator.comparing(StoreCountrySortDTO::getSortNo).thenComparing(StoreCountrySortDTO::getCountryFirstLetter)).collect(Collectors.toList());
            sortList.forEach(item -> {
                List tempList = list.stream().filter(one -> one.getCountryId().equals(item.getCountryId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(tempList)) {
                    resultList.addAll(tempList);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(notRepeatList = list.stream().filter(first -> storeCountrySortList.stream().noneMatch(second -> first.getCountryId().equals(second.getCountryId()))).collect(Collectors.toList()))) {
            resultList.addAll(notRepeatList.stream().sorted(Comparator.comparing(SkuSubscribeDTO::getFirstLetter)).collect(Collectors.toList()));
        }
        return resultList;
    }

    public List<SkuSubscribeDTO> brandSort(Long storeId, List<SkuSubscribeDTO> list) {
        ArrayList resultList = Lists.newArrayList();
        List storeBrandSortList = this.storeBrandSortService.selectSortByStoreId(storeId);
        if (CollectionUtils.isNotEmpty((Collection)storeBrandSortList)) {
            List<StoreBrandSortDTO> sortDTOList = storeBrandSortList.stream().sorted(Comparator.comparing(StoreBrandSortDTO::getSortNo).thenComparing(StoreBrandSortDTO::getFirstLetter)).collect(Collectors.toList());
            sortDTOList.forEach(item -> {
                List tempList = list.stream().filter(one -> one.getPsBrandId().equals(item.getPsBrandId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(tempList)) {
                    resultList.addAll(tempList);
                }
            });
        }
        List notRepeatList = list.stream().filter(first -> storeBrandSortList.stream().noneMatch(second -> first.getPsBrandId().equals(second.getPsBrandId()))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notRepeatList = notRepeatList.stream().filter(one -> Objects.nonNull(one.getFirstLetter())).collect(Collectors.toList()))) {
            resultList.addAll(notRepeatList.stream().sorted(Comparator.comparing(SkuSubscribeDTO::getFirstLetter)).collect(Collectors.toList()));
        }
        return resultList;
    }

    public List<SkuSubscribeDTO> categorySort(List<SkuSubscribeDTO> list, Map<Long, Integer> psCategoryIdMap) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<Object> categorySortList = list;
        List pidList = categorySortList.stream().filter(one -> one.getLevel().equals(4)).map(SkuSubscribeDTO::getPid).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(pidList)) {
            List categoryThreeList = this.categoryService.listByIds(pidList);
            categorySortList.forEach(item -> {
                List categoryList;
                item.setQty((Integer)psCategoryIdMap.get(item.getPsCategoryId()));
                if (CollectionUtils.isNotEmpty((Collection)categoryThreeList) && CollectionUtils.isNotEmpty(categoryList = categoryThreeList.stream().filter(one -> one.getId().equals(item.getPid())).collect(Collectors.toList()))) {
                    Category category = (Category)categoryList.get(0);
                    item.setPsCategoryName(category.getName());
                }
            });
            categorySortList = categorySortList.stream().sorted(Comparator.comparing(SkuSubscribeDTO::getQty).reversed()).collect(Collectors.toList());
        }
        return categorySortList;
    }

    private List<SkuSubscribeDTO> covertSkuList(Store store, List<SkuSubscribeDTO> skuSubscribeDTOList, LoginUserInfo currentLoginUserInfo, String supplyPriceType, Page<PhyStorageDTO> phyStorageDTOPage, List<OssUrlVO> ossUrlVOS, List<SpuPicture> spuPictureList, List<ReturnGiftsVO> returnGiftsVOS, CustomerStatusVO customerStatus, List<Brand> brandList) {
        if (CollUtil.isEmpty(skuSubscribeDTOList)) {
            return CollUtil.newArrayList((Object[])new SkuSubscribeDTO[0]);
        }
        String supplyPriceDigits = this.configBiz.getSupplyPriceDigits();
        for (SkuSubscribeDTO skuSubscribeDTO : skuSubscribeDTOList) {
            SystemConfigVO defaultMallUserId;
            ReturnGiftsVO returnGiftsVO;
            Brand brand;
            OssUrlVO vo;
            String showSkuPriceType;
            skuSubscribeDTO.setSupplyPrice(this.configBiz.getDecimalDigits(skuSubscribeDTO.getSupplyPrice(), supplyPriceDigits));
            skuSubscribeDTO.setCounterPrice(this.configBiz.getDecimalDigits(skuSubscribeDTO.getCounterPrice(), supplyPriceDigits));
            if (StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType())) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getSupplyPrice());
            }
            if (skuSubscribeDTO.getUnifySupplyPrice() == null) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getCounterPrice());
            }
            if (StringUtils.isEmpty((CharSequence)(showSkuPriceType = this.mdmAdapter.selectMdmSystemConfig("MALL_SHOW_SKU_SUPPLY_PRICE_TYPE"))) || StringUtils.equalsIgnoreCase((CharSequence)showSkuPriceType, (CharSequence)"CUSTOMER_PRICE")) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getSupplyPrice());
            }
            if (!StrUtil.equals((CharSequence)SkuTypeEnums.NORMAL.getCode().toString(), (CharSequence)skuSubscribeDTO.getSkuType())) {
                if (skuSubscribeDTO.getSpecValue().startsWith("TJ01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TJ01", "\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("01", "\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("TC01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TC01", "\u7279\u91c7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("03")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("03", "\u7279\u91c7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("TJ02")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TJ02", "\u7279\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("02")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("02", "\u7279\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("04")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("04", "\u7279\u91c7\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("05")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("05", "\u7279\u91c7\u7279\u7279\u4ef7"));
                }
            }
            if ((YesOrNoEnum.YES.getCode().equals(store.getIsDisplayInventory()) || YesOrNoEnum.YES.getCode().equals(store.getIsDfDisplayInventory())) && phyStorageDTOPage != null) {
                BigDecimal totalQtyStorage = phyStorageDTOPage.getRecords().stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)skuSubscribeDTO.getSkuId())).map(PhyStorageDTO::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)supplyPriceType)) {
                    skuSubscribeDTO.setQtyStorage(totalQtyStorage.multiply(store.getAvailableInventoryProportion()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN));
                } else if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)supplyPriceType)) {
                    skuSubscribeDTO.setQtyStorage(totalQtyStorage.multiply(store.getDfAvailableRatio()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN));
                }
            }
            if (StrUtil.equals((CharSequence)InventoryShowTypeEnum.TWO.getCode(), (CharSequence)store.getInventoryShowType()) && skuSubscribeDTO.getQtyStorage() != null) {
                if (currentLoginUserInfo.getLoginFrom().equals((Object)LoginFrom.xqy_mall_pc)) {
                    if (BigDecimalUtils.lessThan(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1"))) {
                        skuSubscribeDTO.setQtyStorageStr("<span style=\"color: rgba(0, 0, 0, 0.45)\">\u7f3a\u8d27</span>");
                    } else if (BigDecimalUtils.greaterEqual(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1")) && BigDecimalUtils.lessEqual(skuSubscribeDTO.getQtyStorage(), store.getInventoryNumber())) {
                        skuSubscribeDTO.setQtyStorageStr("<span style=\"color: #FA5555\">\u5e93\u5b58\u7d27\u5f20</span>");
                    } else if (BigDecimalUtils.greaterThan(skuSubscribeDTO.getQtyStorage(), store.getInventoryNumber())) {
                        skuSubscribeDTO.setQtyStorageStr("<span>\u6709\u8d27</span>");
                    }
                } else if (BigDecimalUtils.lessThan(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1"))) {
                    skuSubscribeDTO.setQtyStorageStr("\u7f3a\u8d27");
                } else if (BigDecimalUtils.greaterEqual(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1")) && BigDecimalUtils.lessEqual(skuSubscribeDTO.getQtyStorage(), store.getInventoryNumber())) {
                    skuSubscribeDTO.setQtyStorageStr("\u5e93\u5b58\u7d27\u5f20");
                } else if (BigDecimalUtils.greaterThan(skuSubscribeDTO.getQtyStorage(), store.getInventoryNumber())) {
                    skuSubscribeDTO.setQtyStorageStr("\u6709\u8d27");
                }
            }
            if (StrUtil.isNotBlank((CharSequence)skuSubscribeDTO.getPictureUrl())) {
                OssUrlVO vo2 = ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)skuSubscribeDTO.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null);
                if (vo2 != null) {
                    skuSubscribeDTO.setPictureUrlFull(vo2.getIntactUrl());
                }
            } else {
                SpuPicture spuPicture = spuPictureList.stream().filter(item -> ObjectUtil.equals((Object)skuSubscribeDTO.getPsSpuId(), (Object)item.getPsSpuId())).findAny().orElse(null);
                if (spuPicture != null && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)spuPicture.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                    skuSubscribeDTO.setPictureUrl(vo.getUrl());
                    skuSubscribeDTO.setPictureUrlFull(vo.getIntactUrl());
                }
            }
            if (CollUtil.isNotEmpty(brandList) && (brand = (Brand)brandList.stream().filter(item -> ObjectUtil.equal((Object)skuSubscribeDTO.getPsBrandId(), (Object)item.getId())).findAny().orElse(null)) != null && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)brand.getLogoUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                skuSubscribeDTO.setPsBrandLogoUrl(brand.getLogoUrl());
                skuSubscribeDTO.setPsBrandLogoUrlFull(vo.getIntactUrl());
            }
            if (SupplyPriceTypeEnums.ONE.getCode().equals(supplyPriceType) && (returnGiftsVO = (ReturnGiftsVO)returnGiftsVOS.stream().filter(item -> item.getPsSkuId().equals(skuSubscribeDTO.getSkuId())).findAny().orElse(null)) != null) {
                skuSubscribeDTO.setPromotionDesc(returnGiftsVO.getPromotionDesc());
                skuSubscribeDTO.setNewPromotionDesc(returnGiftsVO.getNewPromotionDesc());
            }
            skuSubscribeDTO.setRetailPrice(BigDecimalUtils.convert(skuSubscribeDTO.getRetailPrice(), 2));
            if (BigDecimalUtils.equal(skuSubscribeDTO.getRetailPrice(), new BigDecimal("0"))) {
                skuSubscribeDTO.setRetailPrice(null);
            }
            skuSubscribeDTO.setSupplyPrice(BigDecimalUtils.convert(skuSubscribeDTO.getSupplyPrice(), 4));
            skuSubscribeDTO.setCounterPrice(BigDecimalUtils.convert(skuSubscribeDTO.getCounterPrice(), 2));
            if (customerStatus != null) {
                if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store.getIsUnauthorizedPrice()) && !StrUtil.equals((CharSequence)customerStatus.getAuthenticationStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType())) {
                    skuSubscribeDTO.setSupplyPriceStr("\u8ba4\u8bc1\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                    skuSubscribeDTO.setSupplyPrice(null);
                }
                if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store.getIsSignPrice()) && !StrUtil.equals((CharSequence)customerStatus.getSignContractStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType())) {
                    skuSubscribeDTO.setSupplyPriceStr("\u7b7e\u7f72\u5408\u540c\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                    skuSubscribeDTO.setSupplyPrice(null);
                }
            } else if (!currentLoginUserInfo.getLoginFrom().equals((Object)LoginFrom.xqy_dms) && currentLoginUserInfo.getCustomerId() == null) {
                skuSubscribeDTO.setSupplyPriceStr("\u8ba4\u8bc1\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                skuSubscribeDTO.setSupplyPrice(null);
            }
            if (StrUtil.equals((CharSequence)(defaultMallUserId = this.mdmAdapter.queryBySystemConfigKeyCode("DEFAULT_MALL_USER_ID")).getValue(), (CharSequence)String.valueOf(currentLoginUserInfo.getUserId()))) {
                skuSubscribeDTO.setSupplyPriceStr("\u767b\u5f55\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                skuSubscribeDTO.setSupplyPrice(null);
            }
            if (skuSubscribeDTO.getRetailPrice() == null || BigDecimalUtils.equal(skuSubscribeDTO.getRetailPrice(), new BigDecimal("0"))) {
                skuSubscribeDTO.setRetailPrice(skuSubscribeDTO.getCounterPrice());
            }
            if (StrUtil.isBlank((CharSequence)skuSubscribeDTO.getSupplyPriceStr()) && skuSubscribeDTO.getRetailPrice() != null && skuSubscribeDTO.getUnifySupplyPrice() != null && !BigDecimalUtils.equal(skuSubscribeDTO.getRetailPrice(), new BigDecimal("0"))) {
                BigDecimal profitAmount = BigDecimalUtils.convert(skuSubscribeDTO.getRetailPrice().subtract(skuSubscribeDTO.getUnifySupplyPrice()), 2);
                skuSubscribeDTO.setProfitAmount("\u8d5a\u00a5" + BigDecimalUtils.thousandthCalculation(profitAmount));
                BigDecimal multiply = profitAmount.divide(skuSubscribeDTO.getRetailPrice(), 2, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                skuSubscribeDTO.setGrossMargin("\u6bdb\u5229\u7387" + String.valueOf(BigDecimalUtils.convert(multiply, 0)) + "%");
            }
            if (skuSubscribeDTO.getPackingQty() != null && StrUtil.isNotBlank((CharSequence)skuSubscribeDTO.getPsUnitName())) {
                skuSubscribeDTO.setPackingQtyStr(skuSubscribeDTO.getPackingQty() + skuSubscribeDTO.getPsUnitName());
            }
            if (skuSubscribeDTO.getRetailPrice() == null) {
                skuSubscribeDTO.setRetailPriceStr("\u00a5" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getCounterPrice()));
                continue;
            }
            if (BigDecimalUtils.greaterEqual(skuSubscribeDTO.getCounterPrice(), skuSubscribeDTO.getRetailPrice())) {
                skuSubscribeDTO.setRetailPriceStr("\u00a5" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getRetailPrice()) + "~" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getCounterPrice()));
                skuSubscribeDTO.setRetailPriceRise("\u00a5" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getRetailPrice()) + "\u8d77");
                continue;
            }
            skuSubscribeDTO.setRetailPriceStr("\u00a5" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getCounterPrice()) + "~" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getRetailPrice()));
            skuSubscribeDTO.setRetailPriceRise("\u00a5" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getCounterPrice()) + "\u8d77");
        }
        return skuSubscribeDTOList;
    }

    public Page<SkuSubscribeDTO> selectSkuPageOrderById(MiniSpuQueryDTO queryDTO) {
        MiniSpuQueryDTO condition = new MiniSpuQueryDTO();
        Page<SkuSubscribeDTO> skuIdsPage = new Page<SkuSubscribeDTO>();
        Page<SkuSubscribeDTO> conditionPage = new Page<SkuSubscribeDTO>();
        if (CollUtil.isNotEmpty((Collection)queryDTO.getSkuIdSerialNoDTOS())) {
            condition.setSkuIdSerialNoDTOS(queryDTO.getSkuIdSerialNoDTOS());
            condition.setSupplyPriceType(queryDTO.getSupplyPriceType());
            condition.setPsStoreId(queryDTO.getPsStoreId());
            condition.setPageNum(queryDTO.getPageNum());
            condition.setPageSize(queryDTO.getPageSize());
            condition.setPriceSort(queryDTO.getPriceSort());
            condition.setImageWide(queryDTO.getImageWide());
            condition.setImageHigh(queryDTO.getImageHigh());
            skuIdsPage = this.selectSkuPageRenovation(condition);
        }
        if (CollUtil.isNotEmpty((Collection)queryDTO.getPsCategoryIdList()) || CollUtil.isNotEmpty((Collection)queryDTO.getBrandIds()) || StringUtils.isNotEmpty((CharSequence)queryDTO.getKeywords()) || CollUtil.isNotEmpty((Collection)queryDTO.getTagIdList())) {
            queryDTO.setSkuIdList(null);
            List<Object> skuIdList = new ArrayList();
            if (CollUtil.isNotEmpty((Collection)queryDTO.getSkuIdSerialNoDTOS())) {
                skuIdList = queryDTO.getSkuIdSerialNoDTOS().stream().map(PsSkuIdSerialNoDTO::getSkuId).collect(Collectors.toList());
                queryDTO.setNotInSkuIdList(skuIdList);
            }
            conditionPage = this.selectSkuPage(queryDTO);
        }
        if (CollUtil.isEmpty((Collection)conditionPage.getRecords())) {
            return skuIdsPage;
        }
        if (CollUtil.isEmpty((Collection)skuIdsPage.getRecords())) {
            return conditionPage;
        }
        List skuIdsRecords = skuIdsPage.getRecords();
        List conditionRecords = conditionPage.getRecords();
        if (CollUtil.isNotEmpty((Collection)skuIdsRecords)) {
            for (int i = 0; i < conditionRecords.size(); ++i) {
                if (i >= skuIdsRecords.size()) continue;
                SkuSubscribeDTO skuIdDTO = (SkuSubscribeDTO)skuIdsRecords.get(i);
                conditionRecords.set(i, skuIdDTO);
            }
        }
        return conditionPage;
    }

    public Page<SkuSubscribeDTO> selectSkuPageRenovation(MiniSpuQueryDTO queryDTO) {
        List skuIdSerialNoDTOS = queryDTO.getSkuIdSerialNoDTOS();
        if (CollUtil.isEmpty((Collection)skuIdSerialNoDTOS)) {
            return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
        }
        List skuIds = skuIdSerialNoDTOS.stream().map(PsSkuIdSerialNoDTO::getSkuId).collect(Collectors.toList());
        int size = skuIds.size();
        int pageNum = queryDTO.getPageNum();
        int pageSize = queryDTO.getPageSize();
        queryDTO.setPageNum(1);
        queryDTO.setPageSize(size);
        queryDTO.setSkuIdList(skuIds);
        Page<SkuSubscribeDTO> page = this.selectSkuPage(queryDTO);
        List records = page.getRecords();
        records.sort((dto1, dto2) -> {
            PsSkuIdSerialNoDTO inputDto1 = skuIdSerialNoDTOS.stream().filter(i -> i.getSkuId().equals(dto1.getSkuId())).findFirst().orElse(null);
            PsSkuIdSerialNoDTO inputDto2 = skuIdSerialNoDTOS.stream().filter(i -> i.getSkuId().equals(dto2.getSkuId())).findFirst().orElse(null);
            if (inputDto1 == null || inputDto2 == null) {
                return 0;
            }
            if (inputDto1.getSerialNo() == null && inputDto2.getSerialNo() == null) {
                return 0;
            }
            if (inputDto1.getSerialNo() == null) {
                return 1;
            }
            if (inputDto2.getSerialNo() == null) {
                return -1;
            }
            return inputDto1.getSerialNo().compareTo(inputDto2.getSerialNo());
        });
        int fromIndex = (pageNum - 1) * pageSize;
        int toIndex = Math.min(pageNum * pageSize, records.size());
        if (fromIndex > records.size()) {
            return new Page((long)pageNum, (long)pageSize);
        }
        List skuSubscribeDTOS = records.subList(fromIndex, toIndex);
        page.setRecords(skuSubscribeDTOS);
        page.setCurrent((long)pageNum);
        page.setSize((long)pageSize);
        return page;
    }
}

