/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.util.BeanConvertUtil;
import com.xinqiyi.ps.model.dto.enums.SpuClassifyEnums;
import com.xinqiyi.ps.model.dto.sku.QueryInteriorSkuDTO;
import com.xinqiyi.ps.model.dto.spu.PhyCStorageDTO;
import com.xinqiyi.ps.model.dto.spu.PhyStorageDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.PageUtil;
import com.xinqiyi.ps.service.util.ParameterColumnHandler;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageQueryVo;
import com.xinqiyi.sg.basic.model.dto.storage.SgStorageOcQueryDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PhyStorageBiz {
    private static final Logger log = LoggerFactory.getLogger(PhyStorageBiz.class);
    @Autowired
    private SkuService skuService;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private SgStorageQueryAdapter sgStorageQueryAdapter;

    public List<Long> queryPhyStorageQty(SpuQueryDTO querySpuDTO) {
        SgStorageOcQueryDto sgStorageQueryDto = new SgStorageOcQueryDto();
        sgStorageQueryDto.setPsSkuIdList(querySpuDTO.getSkuIdList());
        sgStorageQueryDto.setWarehouseIds(querySpuDTO.getWarehouseIds());
        sgStorageQueryDto.setStoreIds(querySpuDTO.getStoreIds());
        sgStorageQueryDto.setQtyBegin(querySpuDTO.getQtyAvailableBegin());
        sgStorageQueryDto.setQtyEnd(querySpuDTO.getQtyAvailableEnd());
        sgStorageQueryDto.setQtyStorageBegin(querySpuDTO.getQtyStorageBegin());
        sgStorageQueryDto.setQtyStorageEnd(querySpuDTO.getQtyStorageBegin());
        List<SgBStorageQueryVo> sgBStorageQueryVos = this.sgStorageQueryAdapter.queryStorageByRange(sgStorageQueryDto);
        return sgBStorageQueryVos.stream().map(SgBStorageQueryVo::getPsCSkuId).distinct().collect(Collectors.toList());
    }

    public Page<PhyStorageDTO> queryPhyStorage(ApiRequest<SpuQueryDTO> apiRequest) {
        SpuQueryDTO querySpuDTO = (SpuQueryDTO)apiRequest.getJsonData();
        ParameterColumnHandler.convertParameter(querySpuDTO, CollUtil.newArrayList((Object[])new String[]{"spuName", "spuCode", "skuCode", "skuName", "wmsThirdPlatformCode", "kyThirdPlatformCode", "childSpuName", "childSpuCode", "childSkuName", "childSkuCode", "submitUser"}), "Union");
        List dtoList = this.skuService.selectSkuList(querySpuDTO);
        List composeList = this.skuService.findSkuAndCompose(querySpuDTO);
        dtoList.addAll(composeList);
        if (CollUtil.isEmpty((Collection)dtoList)) {
            return new Page();
        }
        boolean isCostPrice = true;
        if (querySpuDTO.getIsQueryStorage().booleanValue()) {
            List list;
            LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            ApiResponse<Map<String, List<String>>> mapApiResponse = this.scAdapter.selectSensitiveColumnByUserId(user.getUserId());
            Assert.isTrue((boolean)mapApiResponse.isSuccess(), (String)mapApiResponse.getDesc());
            Map hasMap = (Map)mapApiResponse.getContent();
            if (hasMap.containsKey("vr_compose_sku_store") && (list = (List)hasMap.get("vr_compose_sku_store")).contains("sg_cost_price")) {
                isCostPrice = false;
            }
        }
        List skuIdList = dtoList.stream().filter(item -> !SpuClassifyEnums.COMPOSE.getCode().equals(item.getClassify()) && item.getPSkuId() == null).map(QueryInteriorSkuDTO::getSkuId).collect(Collectors.toList());
        List storageQueryVos = CollUtil.newArrayList((Object[])new SgBStorageQueryVo[0]);
        if (CollUtil.isNotEmpty(skuIdList)) {
            SgStorageOcQueryDto sgStorageQueryDto = new SgStorageOcQueryDto();
            sgStorageQueryDto.setPsSkuIdList(skuIdList);
            sgStorageQueryDto.setWarehouseIds(querySpuDTO.getWarehouseIds());
            sgStorageQueryDto.setStoreIds(querySpuDTO.getStoreIds());
            sgStorageQueryDto.setQtyBegin(querySpuDTO.getQtyBegin());
            sgStorageQueryDto.setQtyEnd(querySpuDTO.getQtyEnd());
            sgStorageQueryDto.setIsQueryEffectiveStorage(Boolean.valueOf(StringUtils.isNotEmpty((CharSequence)querySpuDTO.getDeliveryExpiryDate())));
            sgStorageQueryDto.setRedundantDays(querySpuDTO.getRedundantDays());
            sgStorageQueryDto.setEffectiveLabel(querySpuDTO.getDeliveryExpiryDate());
            ApiResponse<List<SgBStorageQueryVo>> apiResponse = querySpuDTO.getIsQueryStorage() != false ? this.sgStorageQueryAdapter.queryStorageIncludePriceCost(sgStorageQueryDto) : this.sgStorageQueryAdapter.queryStorageIncludePriceCostNoPermission(sgStorageQueryDto);
            Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
            storageQueryVos = (List)apiResponse.getContent();
        }
        List composeSkuId = dtoList.stream().filter(item -> !SpuClassifyEnums.COMPOSE.getCode().equals(item.getClassify()) && item.getPSkuId() != null).map(QueryInteriorSkuDTO::getSkuId).collect(Collectors.toList());
        List composeQueryVos = CollUtil.newArrayList((Object[])new SgBStorageQueryVo[0]);
        if (CollUtil.isNotEmpty(composeSkuId)) {
            SgStorageOcQueryDto sgStorageQueryDto = new SgStorageOcQueryDto();
            sgStorageQueryDto.setPsSkuIdList(composeSkuId);
            sgStorageQueryDto.setWarehouseIds(querySpuDTO.getWarehouseIds());
            sgStorageQueryDto.setStoreIds(querySpuDTO.getStoreIds());
            sgStorageQueryDto.setIsQueryEffectiveStorage(Boolean.valueOf(StringUtils.isNotEmpty((CharSequence)querySpuDTO.getDeliveryExpiryDate())));
            sgStorageQueryDto.setRedundantDays(querySpuDTO.getRedundantDays());
            sgStorageQueryDto.setEffectiveLabel(querySpuDTO.getDeliveryExpiryDate());
            ApiResponse<List<SgBStorageQueryVo>> apiResponse = querySpuDTO.getIsQueryStorage() != false ? this.sgStorageQueryAdapter.queryStorageIncludePriceCost(sgStorageQueryDto) : this.sgStorageQueryAdapter.queryStorageIncludePriceCostNoPermission(sgStorageQueryDto);
            Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
            composeQueryVos = (List)apiResponse.getContent();
        }
        ArrayList phyStorageDTOS = CollUtil.newArrayList((Object[])new PhyStorageDTO[0]);
        if (CollUtil.isNotEmpty((Collection)storageQueryVos)) {
            List phyStorageDTOList = BeanConvertUtil.convertList((List)storageQueryVos, PhyStorageDTO.class);
            for (PhyStorageDTO phyStorageDTO : phyStorageDTOList) {
                BigDecimal qtyPreout;
                BigDecimal qtyPrein;
                BigDecimal qtyAvailable;
                QueryInteriorSkuDTO skuDTO = dtoList.stream().filter(item -> item.getSkuId().equals(phyStorageDTO.getPsCSkuId())).findAny().orElse(null);
                phyStorageDTO.setClassify(skuDTO.getClassify());
                phyStorageDTO.setPsSkuCode(skuDTO.getSkuCode());
                phyStorageDTO.setPsSkuName(skuDTO.getSkuName());
                phyStorageDTO.setSkuId(skuDTO.getSkuId());
                BigDecimal packingQty = BigDecimal.valueOf(1L);
                if (skuDTO.getPackingQty() != null) {
                    packingQty = BigDecimal.valueOf(skuDTO.getPackingQty().intValue());
                }
                BigDecimal qtyStorage = phyStorageDTO.getQtyStorage();
                BigDecimal afterPackageQtyStorage = phyStorageDTO.getQtyStorage();
                if (qtyStorage != null) {
                    afterPackageQtyStorage = qtyStorage.divide(packingQty, RoundingMode.DOWN).setScale(0, RoundingMode.DOWN);
                }
                BigDecimal afterPackageQtyAvailable = qtyAvailable = phyStorageDTO.getQtyAvailable();
                if (qtyAvailable != null) {
                    afterPackageQtyAvailable = qtyAvailable.divide(packingQty, RoundingMode.DOWN).setScale(0, RoundingMode.DOWN);
                }
                BigDecimal afterPackageQtyPrein = qtyPrein = phyStorageDTO.getQtyPrein();
                if (qtyPrein != null) {
                    afterPackageQtyPrein = qtyPrein.divide(packingQty, RoundingMode.DOWN).setScale(0, RoundingMode.DOWN);
                }
                BigDecimal afterPackageQtyPreout = qtyPreout = phyStorageDTO.getQtyPreout();
                if (qtyPreout != null) {
                    afterPackageQtyPreout = qtyPreout.divide(packingQty, RoundingMode.DOWN).setScale(0, RoundingMode.DOWN);
                }
                phyStorageDTO.setQtyStoragePackage(afterPackageQtyStorage);
                phyStorageDTO.setQtyAvailablePackage(afterPackageQtyAvailable);
                phyStorageDTO.setQtyPreinPackage(afterPackageQtyPrein);
                phyStorageDTO.setQtyPreoutPackage(afterPackageQtyPreout);
            }
            phyStorageDTOS.addAll(phyStorageDTOList);
        }
        List<Object> composeStorageDTOS = CollUtil.newArrayList((Object[])new PhyStorageDTO[0]);
        if (CollUtil.isNotEmpty((Collection)composeQueryVos)) {
            List composeSku = dtoList.stream().filter(item -> SpuClassifyEnums.COMPOSE.getCode().equals(item.getClassify())).collect(Collectors.toList());
            for (QueryInteriorSkuDTO skuDTO : composeSku) {
                List childSkuList = dtoList.stream().filter(item -> item.getPSkuId() != null && item.getPSkuId().equals(skuDTO.getSkuId())).collect(Collectors.toList());
                List skuId = childSkuList.stream().map(QueryInteriorSkuDTO::getSkuId).distinct().collect(Collectors.toList());
                List sgBStorageQueryVos = composeQueryVos.stream().filter(item -> skuId.contains(item.getPsCSkuId())).collect(Collectors.toList());
                Map<Long, List<SgBStorageQueryVo>> map = sgBStorageQueryVos.stream().collect(Collectors.groupingBy(SgBStorageQueryVo::getCpCPhyWarehouseId));
                for (List<SgBStorageQueryVo> storageVOS : map.values()) {
                    List psCSkuId = storageVOS.stream().map(SgBStorageQueryVo::getPsCSkuId).distinct().collect(Collectors.toList());
                    if (skuId.size() != psCSkuId.size()) continue;
                    Map<Long, List<SgBStorageQueryVo>> skuIdMap = storageVOS.stream().collect(Collectors.groupingBy(SgBStorageQueryVo::getPsCSkuId));
                    ArrayList voList = CollUtil.newArrayList((Object[])new SgBStorageQueryVo[0]);
                    for (List<SgBStorageQueryVo> vos : skuIdMap.values()) {
                        SgBStorageQueryVo sgBStorageQueryVo = new SgBStorageQueryVo();
                        SgBStorageQueryVo sgBStorageQueryVo1 = vos.get(0);
                        BeanConvertUtil.copyProperties((Object)sgBStorageQueryVo1, (Object)sgBStorageQueryVo);
                        sgBStorageQueryVo.setQtyAvailable(vos.stream().filter(s -> s.getQtyAvailable() != null).map(SgBStorageQueryVo::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add));
                        sgBStorageQueryVo.setQtyPrein(vos.stream().filter(s -> s.getQtyPrein() != null).map(SgBStorageQueryVo::getQtyPrein).reduce(BigDecimal.ZERO, BigDecimal::add));
                        sgBStorageQueryVo.setQtyPreout(vos.stream().filter(s -> s.getQtyPreout() != null).map(SgBStorageQueryVo::getQtyPreout).reduce(BigDecimal.ZERO, BigDecimal::add));
                        sgBStorageQueryVo.setQtyStorage(vos.stream().filter(s -> s.getQtyStorage() != null).map(SgBStorageQueryVo::getQtyStorage).reduce(BigDecimal.ZERO, BigDecimal::add));
                        sgBStorageQueryVo.setCpCStoreEname(vos.stream().map(SgBStorageQueryVo::getCpCStoreEname).distinct().collect(Collectors.joining(",")));
                        sgBStorageQueryVo.setCpCStoreEcode(vos.stream().map(SgBStorageQueryVo::getCpCStoreEcode).distinct().collect(Collectors.joining(",")));
                        voList.add(sgBStorageQueryVo);
                    }
                    List phyCStorageDTOS = BeanConvertUtil.convertList((List)voList, PhyCStorageDTO.class);
                    ArrayList childDtoList = CollUtil.newArrayList((Object[])new PhyCStorageDTO[0]);
                    BigDecimal totalCost = BigDecimal.ZERO;
                    ArrayList qtyStorageList = CollUtil.newArrayList((Object[])new BigDecimal[0]);
                    ArrayList qtyPreoutList = CollUtil.newArrayList((Object[])new BigDecimal[0]);
                    ArrayList qtyAvailableList = CollUtil.newArrayList((Object[])new BigDecimal[0]);
                    ArrayList qtyPreinList = CollUtil.newArrayList((Object[])new BigDecimal[0]);
                    for (PhyCStorageDTO storageVO : phyCStorageDTOS) {
                        List composeSkuList = childSkuList.stream().filter(item -> item.getSkuId().equals(storageVO.getPsCSkuId())).collect(Collectors.toList());
                        Integer totalComposeNumber = childSkuList.stream().filter(item -> item.getSkuId().equals(storageVO.getPsCSkuId())).mapToInt(QueryInteriorSkuDTO::getComposeNumber).sum();
                        BigDecimal number = new BigDecimal(totalComposeNumber);
                        for (int i = 0; i < composeSkuList.size(); ++i) {
                            QueryInteriorSkuDTO compose = (QueryInteriorSkuDTO)composeSkuList.get(i);
                            if (i >= 1) {
                                PhyCStorageDTO dto = new PhyCStorageDTO();
                                BeanConvertUtil.copyProperties((Object)storageVO, (Object)dto);
                                BigDecimal composeNumber = new BigDecimal(compose.getComposeNumber());
                                dto.setComposeNumber(compose.getComposeNumber());
                                dto.setPsSkuCode(compose.getSkuCode());
                                dto.setPsSkuName(compose.getSpuName());
                                dto.setClassify(compose.getClassify());
                                dto.setCpCStoreId(null);
                                if (dto.getPriceCost() != null) {
                                    BigDecimal multiply = storageVO.getPriceCost().multiply(composeNumber);
                                    totalCost = totalCost.add(multiply);
                                    if (isCostPrice) {
                                        dto.setTotalPriceCost(multiply);
                                    }
                                }
                                if (dto.getQtyStorage() != null) {
                                    qtyStorageList.add(dto.getQtyStorage().divide(number, 0, 1));
                                }
                                if (dto.getQtyAvailable() != null) {
                                    qtyAvailableList.add(dto.getQtyAvailable().divide(number, 0, 1));
                                }
                                if (dto.getQtyPrein() != null) {
                                    qtyPreinList.add(dto.getQtyPrein().divide(number, 0, 1));
                                }
                                if (dto.getQtyPreout() != null) {
                                    qtyPreoutList.add(dto.getQtyPreout().divide(number, 0, 1));
                                }
                                childDtoList.add(dto);
                            } else {
                                BigDecimal composeNumber = new BigDecimal(compose.getComposeNumber());
                                storageVO.setComposeNumber(compose.getComposeNumber());
                                storageVO.setPsSkuCode(compose.getSkuCode());
                                storageVO.setPsSkuName(compose.getSpuName());
                                storageVO.setClassify(compose.getClassify());
                                storageVO.setCpCStoreId(null);
                                if (storageVO.getPriceCost() != null) {
                                    BigDecimal multiply = storageVO.getPriceCost().multiply(composeNumber);
                                    totalCost = totalCost.add(multiply);
                                    if (isCostPrice) {
                                        storageVO.setTotalPriceCost(multiply);
                                    }
                                }
                                if (storageVO.getQtyStorage() != null) {
                                    qtyStorageList.add(storageVO.getQtyStorage().divide(number, 0, RoundingMode.DOWN));
                                }
                                if (storageVO.getQtyAvailable() != null) {
                                    qtyAvailableList.add(storageVO.getQtyAvailable().divide(number, 0, RoundingMode.DOWN));
                                }
                                if (storageVO.getQtyPrein() != null) {
                                    qtyPreinList.add(storageVO.getQtyPrein().divide(number, 0, RoundingMode.DOWN));
                                }
                                if (storageVO.getQtyPreout() != null) {
                                    qtyPreoutList.add(storageVO.getQtyPreout().divide(number, 0, RoundingMode.DOWN));
                                }
                            }
                            if (isCostPrice) continue;
                            storageVO.setPriceCost(null);
                            storageVO.setTotalPriceCost(null);
                        }
                    }
                    phyCStorageDTOS.addAll(childDtoList);
                    PhyStorageDTO phyStorageDTO = new PhyStorageDTO();
                    phyStorageDTO.setCpCPhyWarehouseEcode(storageVOS.get(0).getCpCPhyWarehouseEcode());
                    phyStorageDTO.setCpCPhyWarehouseEname(storageVOS.get(0).getCpCPhyWarehouseEname());
                    phyStorageDTO.setPsSkuCode(skuDTO.getSkuCode());
                    phyStorageDTO.setPsSkuName(skuDTO.getSpuName());
                    phyStorageDTO.setClassify(skuDTO.getClassify());
                    phyStorageDTO.setQtyStorage((BigDecimal)qtyStorageList.stream().sorted().collect(Collectors.toList()).get(0));
                    phyStorageDTO.setQtyAvailable((BigDecimal)qtyAvailableList.stream().sorted().collect(Collectors.toList()).get(0));
                    phyStorageDTO.setQtyPrein((BigDecimal)qtyPreinList.stream().sorted().collect(Collectors.toList()).get(0));
                    phyStorageDTO.setQtyPreout((BigDecimal)qtyPreoutList.stream().sorted().collect(Collectors.toList()).get(0));
                    phyStorageDTO.setCpCStoreId(null);
                    phyStorageDTO.setCpCStoreEname(null);
                    phyStorageDTO.setCpCStoreEcode(null);
                    phyStorageDTO.setSkuId(skuDTO.getSkuId());
                    List dtos = phyCStorageDTOS.stream().filter(item -> item.getPriceCost() != null).collect(Collectors.toList());
                    if (isCostPrice && CollUtil.isNotEmpty(dtos)) {
                        phyStorageDTO.setTotalPriceCost(totalCost);
                    }
                    if (!isCostPrice) {
                        phyStorageDTO.setPriceCost(null);
                        phyStorageDTO.setTotalPriceCost(null);
                    }
                    phyStorageDTO.setChildren(phyCStorageDTOS);
                    composeStorageDTOS.add(phyStorageDTO);
                }
            }
            if (querySpuDTO.getQtyBegin() != null && querySpuDTO.getQtyEnd() != null) {
                composeStorageDTOS = composeStorageDTOS.stream().filter(item -> BigDecimalUtils.greaterEqual(item.getQtyAvailable(), querySpuDTO.getQtyBegin()) && BigDecimalUtils.lessEqual(item.getQtyAvailable(), querySpuDTO.getQtyEnd())).collect(Collectors.toList());
            }
            if (querySpuDTO.getQtyBegin() != null && querySpuDTO.getQtyEnd() == null) {
                composeStorageDTOS = composeStorageDTOS.stream().filter(item -> BigDecimalUtils.greaterEqual(item.getQtyAvailable(), querySpuDTO.getQtyBegin())).collect(Collectors.toList());
            }
            if (querySpuDTO.getQtyBegin() == null && querySpuDTO.getQtyEnd() != null) {
                composeStorageDTOS = composeStorageDTOS.stream().filter(item -> BigDecimalUtils.lessEqual(item.getQtyAvailable(), querySpuDTO.getQtyEnd())).collect(Collectors.toList());
            }
            phyStorageDTOS.addAll(composeStorageDTOS);
        }
        return PageUtil.getPageData(phyStorageDTOS, new Page((long)querySpuDTO.getPageNum(), (long)querySpuDTO.getPageSize()));
    }
}

