/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.dynamicform.dao.repository.DictRedisRepository;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.dynamicform.model.request.QueryDynamicFormDataRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.model.search.CommonSearchRequest;
import com.xinqiyi.framework.model.search.SearchCondition;
import com.xinqiyi.framework.model.search.SearchType;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.addpurchase.PsAddPurchaseRecordReportVO;
import com.xinqiyi.ps.api.model.vo.addpurchase.PsAddPurchaseRecordVO;
import com.xinqiyi.ps.api.model.vo.addpurchase.PsAddPurchaseSystemParameterVO;
import com.xinqiyi.ps.dao.repository.PsAddPurchaseRecordService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.addpurchase.PsAddPurchaseRecordDTO;
import com.xinqiyi.ps.model.dto.addpurchase.PsAddPurchaseRecordReportDTO;
import com.xinqiyi.ps.model.dto.enums.DictEnums;
import com.xinqiyi.ps.model.dto.page.DynamicPageResult;
import com.xinqiyi.ps.model.dto.page.PageResult;
import com.xinqiyi.ps.model.entity.PsAddPurchaseRecord;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.DateUtil;
import com.xinqiyi.ps.service.util.StringUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsAddPurchaseRecordBiz {
    private static final Logger log = LoggerFactory.getLogger(PsAddPurchaseRecordBiz.class);
    @Autowired
    private PsAddPurchaseRecordService psAddPurchaseRecordService;
    @Autowired
    private IdSequenceGenerator idSequenceGenerator;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private DictRedisRepository dictRedisRepository;
    @Autowired
    private StoreService storeService;
    @Autowired
    private MdmAdapter mdmAdapter;

    public ApiResponse<Void> batchSaveOrUpdate(List<PsAddPurchaseRecordDTO> list) {
        if (log.isDebugEnabled()) {
            log.debug("\u52a0\u8d2d-\u6279\u91cf\u6dfb\u52a0/\u4fee\u6539 \u5165\u53c2:{}", (Object)JSON.toJSONString(list));
        }
        List<PsAddPurchaseRecord> psAddPurchaseRecordList = BeanConvertUtil.convertList(list, PsAddPurchaseRecord.class);
        List ocOrderSubscribeIdList = psAddPurchaseRecordList.stream().filter(one -> one.getPurchaseType().equals(2) || one.getPurchaseType().equals(3)).map(PsAddPurchaseRecord::getOcOrderSubscribeId).collect(Collectors.toList());
        Map pidMap = this.psAddPurchaseRecordService.getPidMap(ocOrderSubscribeIdList);
        psAddPurchaseRecordList.forEach(item -> {
            if (pidMap.size() > 0 && pidMap.containsKey(item.getOcOrderSubscribeId())) {
                item.setPid((Long)pidMap.get(item.getOcOrderSubscribeId()));
            }
            if (Objects.isNull(item.getId())) {
                item.setId(this.idSequenceGenerator.generateId(PsAddPurchaseRecord.class));
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)item);
            }
        });
        this.psAddPurchaseRecordService.saveOrUpdateBatch(psAddPurchaseRecordList);
        return ApiResponse.success();
    }

    public ApiResponse<List<PsAddPurchaseRecordVO>> select(PsAddPurchaseRecordDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u52a0\u8d2d-\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        }
        this.covertParams(dto);
        List psAddPurchaseRecordList = this.psAddPurchaseRecordService.select(dto);
        List<PsAddPurchaseRecordVO> resultList = BeanConvertUtil.convertList(psAddPurchaseRecordList, PsAddPurchaseRecordVO.class);
        this.commonConvert(resultList, dto);
        return ApiResponse.success(resultList);
    }

    public void commonConvert(List<PsAddPurchaseRecordVO> resultList, PsAddPurchaseRecordDTO dto) {
        if (CollectionUtils.isNotEmpty(resultList)) {
            if (Objects.nonNull(dto.getDistinct()) && dto.getDistinct().booleanValue()) {
                List pidList = resultList.stream().filter(one -> Objects.nonNull(one.getPid())).map(PsAddPurchaseRecordVO::getPid).collect(Collectors.toList());
                resultList = resultList.stream().filter(first -> pidList.stream().noneMatch(second -> Objects.equals(first.getId(), second) || Objects.equals(first.getPid(), second))).collect(Collectors.toList());
            }
            List purchaseTypeList = this.dictRedisRepository.selectDictValueListByCode(DictEnums.ADD_PURCHASE_TYPE.name());
            List sourceTypeList = this.dictRedisRepository.selectDictValueListByCode(DictEnums.ADD_PURCHASE_SOURCE_TYPE.name());
            resultList.forEach(item -> {
                if (Objects.nonNull(item.getPurchaseType())) {
                    String purchaseTypeName = purchaseTypeList.stream().filter(one -> one.getValueCode().equals(String.valueOf(item.getPurchaseType()))).map(DictValue::getName).collect(Collectors.joining(","));
                    item.setPurchaseTypeName(purchaseTypeName);
                }
                if (Objects.nonNull(item.getSourceType())) {
                    String sourceTypeName = sourceTypeList.stream().filter(one -> one.getValueCode().equals(String.valueOf(item.getSourceType()))).map(DictValue::getName).collect(Collectors.joining(","));
                    item.setSourceTypeName(sourceTypeName);
                }
            });
        }
    }

    public PageResult selectPage(PsAddPurchaseRecordDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u52a0\u8d2d-\u67e5\u8be2(\u5206\u9875)\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        }
        this.covertParams(dto);
        Page page = new Page((long)dto.getPageNum(), (long)dto.getPageSize());
        IPage iPage = this.psAddPurchaseRecordService.selectPage(page, dto);
        List<PsAddPurchaseRecordVO> resultList = BeanConvertUtil.convertList(iPage.getRecords(), PsAddPurchaseRecordVO.class);
        this.commonConvert(resultList, dto);
        return new PageResult(dto.getPageNum(), dto.getPageSize(), page.getTotal()).setData(resultList);
    }

    public void covertParams(PsAddPurchaseRecordDTO dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getCusCustomerCode()) && dto.getCusCustomerCode().contains("\n")) {
            List cusCustomerCodeList = Arrays.stream(dto.getCusCustomerCode().split("\n")).collect(Collectors.toList());
            dto.setCusCustomerCodeList(cusCustomerCodeList);
            dto.setCusCustomerCode(null);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCusCustomerName()) && dto.getCusCustomerName().contains("\n")) {
            List cusCustomerNameList = Arrays.stream(dto.getCusCustomerName().split("\n")).collect(Collectors.toList());
            dto.setCusCustomerNameList(cusCustomerNameList);
            dto.setCusCustomerName(null);
        }
    }

    public ApiResponse<Map<String, Integer>> getNumber(PsAddPurchaseRecordDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u52a0\u8d2d-\u5546\u54c1\u52a0\u8d2d\u6570\u91cf \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        }
        this.covertParams(dto);
        Map psAddPurchaseNumberMap = this.psAddPurchaseRecordService.getNumber(dto);
        return ApiResponse.success((Object)psAddPurchaseNumberMap);
    }

    public ApiResponse<List<PsAddPurchaseRecordVO>> queryNumberList(PsAddPurchaseRecordDTO dto) {
        if (log.isDebugEnabled()) {
            log.debug("\u52a0\u8d2d-\u5546\u54c1\u52a0\u8d2d\u6570\u91cf-\u5185\u90e8\u8c03\u7528 \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        }
        List psAddPurchaseNumberList = this.psAddPurchaseRecordService.queryNumberList(dto);
        List<PsAddPurchaseRecordVO> result = BeanConvertUtil.convertList(psAddPurchaseNumberList, PsAddPurchaseRecordVO.class);
        return ApiResponse.success(result);
    }

    public DynamicPageResult selectPageReport(QueryDynamicFormDataRequest queryDataRequest) {
        List searchConditionList = queryDataRequest.getJsonData().getSearchCondition();
        PsAddPurchaseRecordReportDTO dto = this.covertSearchCondition(searchConditionList);
        dto.setIsDistinct(Boolean.valueOf(false));
        Map countAddPurchaseNumberMap = this.psAddPurchaseRecordService.selectPurchaseNumber(dto);
        if (!(countAddPurchaseNumberMap.isEmpty() || dto.getCountAddPurchaseNumberMin() == null && dto.getCountAddPurchaseNumberMax() == null)) {
            List keys = countAddPurchaseNumberMap.entrySet().stream().filter(one -> dto.getCountAddPurchaseNumberMin() != null && (Integer)one.getValue() >= dto.getCountAddPurchaseNumberMin()).filter(one -> dto.getCountAddPurchaseNumberMax() != null && (Integer)one.getValue() <= dto.getCountAddPurchaseNumberMax()).map(Map.Entry::getKey).collect(Collectors.toList());
            dto.setCountAddPurchaseNumberSkuCodeList(keys);
        }
        dto.setStartTime(null);
        dto.setEndTime(null);
        dto.setIsDistinct(Boolean.valueOf(true));
        Map currentAddPurchaseNumberMap = this.psAddPurchaseRecordService.selectPurchaseNumber(dto);
        if (!(currentAddPurchaseNumberMap.isEmpty() || dto.getCurrentAddPurchaseNumberMin() == null && dto.getCurrentAddPurchaseNumberMax() == null)) {
            List keys = currentAddPurchaseNumberMap.entrySet().stream().filter(one -> dto.getCurrentAddPurchaseNumberMin() != null && (Integer)one.getValue() >= dto.getCurrentAddPurchaseNumberMin()).filter(one -> dto.getCurrentAddPurchaseNumberMax() != null && (Integer)one.getValue() <= dto.getCurrentAddPurchaseNumberMax()).map(Map.Entry::getKey).collect(Collectors.toList());
            dto.setCurrentAddPurchaseNumberSkuCodeList(keys);
        }
        if (Objects.isNull(queryDataRequest.getJsonData())) {
            queryDataRequest.setJsonData(new CommonSearchRequest());
        }
        Long pageIndex = Objects.nonNull(queryDataRequest.getJsonData().getPageIndex()) ? queryDataRequest.getJsonData().getPageIndex() : Long.valueOf(1L);
        Long pageSize = Objects.nonNull(queryDataRequest.getJsonData().getPageSize()) ? queryDataRequest.getJsonData().getPageSize() : Long.valueOf(9999L);
        Page page = new Page(pageIndex.longValue(), pageSize.longValue());
        IPage iPage = this.psAddPurchaseRecordService.selectPageReportPage(page, dto);
        List<PsAddPurchaseRecordReportVO> resultList = BeanConvertUtil.convertList(iPage.getRecords(), PsAddPurchaseRecordReportVO.class);
        if (CollectionUtil.isNotEmpty(resultList)) {
            resultList.forEach(item -> {
                if (!currentAddPurchaseNumberMap.isEmpty() && currentAddPurchaseNumberMap.containsKey(String.valueOf(item.getSkuCode()))) {
                    item.setCurrentAddPurchaseNumber((Integer)currentAddPurchaseNumberMap.get(String.valueOf(item.getSkuCode())));
                }
                if (!countAddPurchaseNumberMap.isEmpty() && countAddPurchaseNumberMap.containsKey(String.valueOf(item.getSkuCode()))) {
                    item.setCountAddPurchaseNumber((Integer)countAddPurchaseNumberMap.get(String.valueOf(item.getSkuCode())));
                }
            });
        }
        return new DynamicPageResult(pageIndex.longValue(), pageSize.longValue(), page.getTotal(), resultList);
    }

    private PsAddPurchaseRecordReportDTO covertSearchCondition(List<SearchCondition> searchConditionList) {
        SearchCondition endTimeCondition;
        SearchCondition startTimeCondition;
        SearchCondition wmsThirdPlatformCodeCondition;
        SearchCondition spuClassifyCondition;
        SearchCondition sourceTypeCondition;
        SearchCondition purchaseTypeCondition;
        SearchCondition skuNameCondition;
        SearchCondition skuCodeCondition;
        SearchCondition storeTypeCondition;
        SearchCondition storeNameCondition;
        SearchCondition storeCodeCondition;
        PsAddPurchaseRecordReportDTO dto = new PsAddPurchaseRecordReportDTO();
        SearchCondition idCondition = this.getSearchCondition(searchConditionList, "id");
        if (idCondition != null) {
            String searchValue = idCondition.getSearchValue();
            List idList = Arrays.stream(searchValue.split(",")).collect(Collectors.toList());
            dto.setIdList(idList);
        }
        if ((storeCodeCondition = this.getSearchCondition(searchConditionList, "storeCode")) != null) {
            String searchValue = storeCodeCondition.getSearchValue();
            dto.setStoreCode(searchValue);
        }
        if ((storeNameCondition = this.getSearchCondition(searchConditionList, "storeName")) != null) {
            String searchValue = storeNameCondition.getSearchValue();
            dto.setStoreName(searchValue);
        }
        if ((storeTypeCondition = this.getSearchCondition(searchConditionList, "storeType")) != null) {
            String searchValue = storeTypeCondition.getSearchValue();
            if (StringUtil.isNotBlank(searchValue) && searchValue.contains(",")) {
                dto.setStoreTypeList(Arrays.asList(searchValue.split(",")));
                dto.setStoreType(null);
            } else {
                dto.setStoreType(searchValue);
            }
        }
        if ((skuCodeCondition = this.getSearchCondition(searchConditionList, "skuCode")) != null) {
            String searchValue = skuCodeCondition.getSearchValue();
            dto.setSkuCode(searchValue);
        }
        if ((skuNameCondition = this.getSearchCondition(searchConditionList, "skuName")) != null) {
            String searchValue = skuNameCondition.getSearchValue();
            if (StringUtils.isNotBlank((CharSequence)searchValue) && searchValue.contains(",")) {
                List skuNameList = Arrays.stream(searchValue.split(",")).collect(Collectors.toList());
                dto.setSkuNameList(skuNameList);
            } else {
                dto.setSkuName(searchValue);
            }
        }
        if ((purchaseTypeCondition = this.getSearchCondition(searchConditionList, "purchaseType")) != null) {
            String searchValue = purchaseTypeCondition.getSearchValue();
            dto.setPurchaseType(Integer.valueOf(Integer.parseInt(searchValue)));
        }
        if ((sourceTypeCondition = this.getSearchCondition(searchConditionList, "sourceType")) != null) {
            String searchValue = sourceTypeCondition.getSearchValue();
            if (StringUtil.isNotBlank(searchValue) && searchValue.contains(",")) {
                List searchValueList = Arrays.asList(searchValue.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList());
                dto.setSourceTypeList(searchValueList);
                dto.setSourceType(null);
            } else {
                dto.setSourceType(Integer.valueOf(Integer.parseInt(searchValue)));
            }
        }
        List<SearchCondition> currentAddPurchaseNumberConditionList = searchConditionList.stream().filter(s -> StrUtil.equals((CharSequence)s.getColumnName(), (CharSequence)"currentAddPurchaseNumber")).collect(Collectors.toList());
        currentAddPurchaseNumberConditionList.forEach(item -> {
            String searchValue = item.getSearchValue();
            if (SearchType.GE.equals((Object)item.getSearchType())) {
                dto.setCurrentAddPurchaseNumberMin(Integer.valueOf(Integer.parseInt(searchValue)));
            }
            if (SearchType.LE.equals((Object)item.getSearchType())) {
                dto.setCurrentAddPurchaseNumberMax(Integer.valueOf(Integer.parseInt(searchValue)));
            }
        });
        List<SearchCondition> countAddPurchaseNumberConditionList = searchConditionList.stream().filter(s -> StrUtil.equals((CharSequence)s.getColumnName(), (CharSequence)"countAddPurchaseNumber")).collect(Collectors.toList());
        countAddPurchaseNumberConditionList.forEach(item -> {
            String searchValue = item.getSearchValue();
            if (SearchType.GE.equals((Object)item.getSearchType())) {
                dto.setCountAddPurchaseNumberMin(Integer.valueOf(Integer.parseInt(searchValue)));
            }
            if (SearchType.LE.equals((Object)item.getSearchType())) {
                dto.setCountAddPurchaseNumberMax(Integer.valueOf(Integer.parseInt(searchValue)));
            }
        });
        SearchCondition spuStatusCondition = this.getSearchCondition(searchConditionList, "spuStatus");
        if (spuStatusCondition != null) {
            String searchValue = spuStatusCondition.getSearchValue();
            if (StringUtils.isNotBlank((CharSequence)searchValue) && searchValue.contains(",")) {
                List searchValueList = Arrays.asList(searchValue.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList());
                dto.setSpuStatusList(searchValueList);
                dto.setSpuStatus(null);
            } else {
                dto.setSpuStatus(Integer.valueOf(Integer.parseInt(searchValue)));
            }
        }
        if ((spuClassifyCondition = this.getSearchCondition(searchConditionList, "spuClassify")) != null) {
            String searchValue = spuClassifyCondition.getSearchValue();
            if (StringUtils.isNotBlank((CharSequence)searchValue) && searchValue.contains(",")) {
                List searchValueList = Arrays.asList(searchValue.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList());
                dto.setSpuClassifyList(searchValueList);
                dto.setSpuClassify(null);
            } else {
                dto.setSpuClassify(Integer.valueOf(Integer.parseInt(searchValue)));
            }
        }
        if ((wmsThirdPlatformCodeCondition = this.getSearchCondition(searchConditionList, "wmsThirdPlatformCode")) != null) {
            String searchValue = wmsThirdPlatformCodeCondition.getSearchValue();
            dto.setWmsThirdPlatformCode(searchValue);
        }
        if ((startTimeCondition = this.getSearchCondition(searchConditionList, "startTime")) != null) {
            String searchValue = startTimeCondition.getSearchValue();
            dto.setStartTime(DateUtil.getDate(searchValue));
        }
        if ((endTimeCondition = this.getSearchCondition(searchConditionList, "endTime")) != null) {
            String searchValue = endTimeCondition.getSearchValue();
            dto.setEndTime(DateUtil.getDate(searchValue));
        }
        List<SearchCondition> addPurchaseCountTimeConditionList = searchConditionList.stream().filter(s -> StrUtil.equals((CharSequence)s.getColumnName(), (CharSequence)"addPurchaseCountTime")).collect(Collectors.toList());
        addPurchaseCountTimeConditionList.forEach(item -> {
            String searchValue = item.getSearchValue();
            if (SearchType.GE.equals((Object)item.getSearchType())) {
                dto.setStartTime(DateUtil.getDate(searchValue));
            }
            if (SearchType.LE.equals((Object)item.getSearchType())) {
                dto.setEndTime(DateUtil.getDate(searchValue));
            }
        });
        return dto;
    }

    public SearchCondition getSearchCondition(List<SearchCondition> searchConditionList, String columnName) {
        return searchConditionList.stream().filter(s -> StrUtil.equals((CharSequence)s.getColumnName(), (CharSequence)columnName)).findAny().orElse(null);
    }

    public PsAddPurchaseSystemParameterVO getSystemParameter() {
        PsAddPurchaseSystemParameterVO vo = new PsAddPurchaseSystemParameterVO();
        String value = this.mdmAdapter.selectMdmSystemConfig("ADD_PURCHASE_NUM_LAST_NDAY");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Date date = new Date();
            Date startTime = DateUtil.daysAfter(date, 0 - Integer.valueOf(value));
            vo.setStartTime(startTime);
            vo.setEndTime(date);
        }
        return vo;
    }
}

