/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.PsBasicsBatchVO;
import com.xinqiyi.ps.dao.repository.PsCauseDeptApprovalService;
import com.xinqiyi.ps.dao.repository.PsCauseDeptApprovalSkuService;
import com.xinqiyi.ps.dao.repository.PsCauseDeptSkuSupplyPriceLogService;
import com.xinqiyi.ps.dao.repository.PsCauseDeptSkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.PsCauseDeptSupplyPriceApprovalService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.model.dto.dept.DeptHistoryDTO;
import com.xinqiyi.ps.model.dto.dept.PsCauseDeptSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.dept.PsCauseDeptSkuSupplyPriceLogDTO;
import com.xinqiyi.ps.model.dto.dept.SaveCauseDeptSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.enums.CustomerSupplyPriceEnum;
import com.xinqiyi.ps.model.dto.enums.InnerLogTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.supplyprice.PostponeDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SupplyPriceApprovalCheckDTO;
import com.xinqiyi.ps.model.entity.PsCauseDeptApproval;
import com.xinqiyi.ps.model.entity.PsCauseDeptApprovalSku;
import com.xinqiyi.ps.model.entity.PsCauseDeptSkuSupplyPrice;
import com.xinqiyi.ps.model.entity.PsCauseDeptSkuSupplyPriceLog;
import com.xinqiyi.ps.model.entity.PsCauseDeptSupplyPriceApproval;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.service.adapter.org.OrgAdapter;
import com.xinqiyi.ps.service.adapter.org.OrgDepartment;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.business.PsCauseDeptSupplyPriceApprovalBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.business.SpuBiz;
import com.xinqiyi.ps.service.mq.MqCallBack;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.ParameterColumnHandler;
import com.xinqiyi.ps.service.util.PsRedisLockUtil;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageCostVo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsCauseDeptSkuSupplyPriceBiz
implements MqCallBack {
    private static final Logger log = LoggerFactory.getLogger(PsCauseDeptSkuSupplyPriceBiz.class);
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private PsCauseDeptSkuSupplyPriceService psCauseDeptSkuSupplyPriceService;
    @Autowired
    private PsCauseDeptSupplyPriceApprovalService psCauseDeptSupplyPriceApprovalService;
    @Autowired
    private PsCauseDeptApprovalService psCauseDeptApprovalService;
    @Autowired
    private PsCauseDeptApprovalSkuService psCauseDeptApprovalSkuService;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private SkuService skuService;
    @Autowired
    private SkuBarCodeService skuBarCodeService;
    @Autowired
    private SpuService spuService;
    @Autowired
    private PsCauseDeptSkuSupplyPriceLogService psCauseDeptSkuSupplyPriceLogService;
    @Autowired
    private SgStorageQueryAdapter sgStorageQueryAdapter;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private OrgAdapter orgAdapter;
    @Autowired
    private PsCauseDeptSupplyPriceApprovalBiz psCauseDeptSupplyPriceApprovalBiz;
    @Autowired
    private SpuBiz spuBiz;

    @Override
    @LogAnnotation
    public void oaCallback(String processInstanceId, String result, String status) {
        PsCauseDeptSupplyPriceApproval psCauseDeptSupplyPriceApproval = (PsCauseDeptSupplyPriceApproval)this.psCauseDeptSupplyPriceApprovalService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCauseDeptSupplyPriceApproval::getOaId, (Object)processInstanceId)).eq(PsCauseDeptSupplyPriceApproval::getStatus, (Object)CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue()));
        if (psCauseDeptSupplyPriceApproval == null) {
            return;
        }
        ArrayList<PsCauseDeptSkuSupplyPrice> psCauseDeptSkuSupplyPrices = new ArrayList<PsCauseDeptSkuSupplyPrice>();
        ArrayList<PsCauseDeptSkuSupplyPrice> removeCauseDeptSkuSupplyPrices = new ArrayList<PsCauseDeptSkuSupplyPrice>();
        ArrayList<PsCauseDeptSkuSupplyPriceLog> psCauseDeptSkuSupplyPriceLogs = new ArrayList<PsCauseDeptSkuSupplyPriceLog>();
        if (StringUtils.equalsIgnoreCase((CharSequence)"agree", (CharSequence)result)) {
            psCauseDeptSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL.getValue());
            psCauseDeptSupplyPriceApproval.setAuditTime(new Date());
            List psCauseDeptApprovalList = this.psCauseDeptApprovalService.list((Wrapper)new QueryWrapper().lambda().eq(PsCauseDeptApproval::getPsCauseDeptSupplyPriceApprovalId, (Object)psCauseDeptSupplyPriceApproval.getId()));
            List cusCauseDeptId = psCauseDeptApprovalList.stream().map(PsCauseDeptApproval::getMdmCauseDeptId).collect(Collectors.toList());
            List psCauseDeptApprovalSkuList = this.psCauseDeptApprovalSkuService.list((Wrapper)new QueryWrapper().lambda().eq(PsCauseDeptApprovalSku::getPsCauseDeptSupplyPriceApprovalId, (Object)psCauseDeptSupplyPriceApproval.getId()));
            Date date = new Date();
            for (PsCauseDeptApprovalSku psCauseDeptApprovalSku : psCauseDeptApprovalSkuList) {
                List psCauseDeptSkuSupplyPriceList = new ArrayList();
                String priceStatus = null;
                if (date.getTime() >= psCauseDeptApprovalSku.getEffectiveTime().getTime() && date.getTime() <= psCauseDeptApprovalSku.getInvalidTime().getTime()) {
                    priceStatus = CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue();
                    psCauseDeptSkuSupplyPriceList = this.psCauseDeptSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCauseDeptSkuSupplyPrice::getPsSkuId, (Object)psCauseDeptApprovalSku.getPsSkuId())).eq(PsCauseDeptSkuSupplyPrice::getType, (Object)psCauseDeptSupplyPriceApproval.getType())).in(PsCauseDeptSkuSupplyPrice::getMdmCauseDeptId, cusCauseDeptId)).le(PsCauseDeptSkuSupplyPrice::getEffectiveTime, (Object)psCauseDeptApprovalSku.getInvalidTime())).ge(PsCauseDeptSkuSupplyPrice::getInvalidTime, (Object)psCauseDeptApprovalSku.getEffectiveTime())).eq(PsCauseDeptSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue()));
                } else if (date.getTime() < psCauseDeptApprovalSku.getEffectiveTime().getTime()) {
                    priceStatus = CustomerSupplyPriceEnum.SupplyPriceStatusEnum.TO_BE_EFFECTIVE.getValue();
                } else if (date.getTime() > psCauseDeptApprovalSku.getInvalidTime().getTime()) {
                    priceStatus = CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue();
                }
                for (Long id : cusCauseDeptId) {
                    if (CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue().equals(priceStatus)) {
                        PsCauseDeptSkuSupplyPriceLog psCauseDeptSkuSupplyPriceLog = new PsCauseDeptSkuSupplyPriceLog();
                        psCauseDeptSkuSupplyPriceLog.setMdmCauseDeptId(id);
                        psCauseDeptSkuSupplyPriceLog.setPsCauseDeptSupplyPriceApprovalId(psCauseDeptSupplyPriceApproval.getId());
                        psCauseDeptSkuSupplyPriceLog.setSupplyPrice(psCauseDeptApprovalSku.getSupplyPrice());
                        psCauseDeptSkuSupplyPriceLog.setType(psCauseDeptSupplyPriceApproval.getType());
                        psCauseDeptSkuSupplyPriceLog.setEffectiveTime(psCauseDeptApprovalSku.getEffectiveTime());
                        psCauseDeptSkuSupplyPriceLog.setInvalidTime(psCauseDeptApprovalSku.getInvalidTime());
                        psCauseDeptSkuSupplyPriceLog.setPsSkuId(psCauseDeptApprovalSku.getPsSkuId());
                        psCauseDeptSkuSupplyPriceLog.setRemark(psCauseDeptApprovalSku.getRemark());
                        psCauseDeptSkuSupplyPriceLog.setStatus(priceStatus);
                        psCauseDeptSkuSupplyPriceLog.setFailureTime(new Date());
                        psCauseDeptSkuSupplyPriceLog.setFreightCost(psCauseDeptApprovalSku.getFreightCost());
                        psCauseDeptSkuSupplyPriceLog.setId(this.idSequence.generateId(PsCauseDeptSkuSupplyPriceLog.class));
                        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCauseDeptSkuSupplyPriceLog);
                        psCauseDeptSkuSupplyPriceLog.setCreateUserName(psCauseDeptApprovalSku.getCreateUserName());
                        psCauseDeptSkuSupplyPriceLogs.add(psCauseDeptSkuSupplyPriceLog);
                        continue;
                    }
                    PsCauseDeptSkuSupplyPrice psCauseDeptSkuSupplyPrice = new PsCauseDeptSkuSupplyPrice();
                    psCauseDeptSkuSupplyPrice.setId(this.idSequence.generateId(PsCauseDeptSkuSupplyPrice.class));
                    psCauseDeptSkuSupplyPrice.setMdmCauseDeptId(id);
                    psCauseDeptSkuSupplyPrice.setPsCauseDeptSupplyPriceApprovalId(psCauseDeptSupplyPriceApproval.getId());
                    psCauseDeptSkuSupplyPrice.setSupplyPrice(psCauseDeptApprovalSku.getSupplyPrice());
                    psCauseDeptSkuSupplyPrice.setEffectiveTime(psCauseDeptApprovalSku.getEffectiveTime());
                    psCauseDeptSkuSupplyPrice.setInvalidTime(psCauseDeptApprovalSku.getInvalidTime());
                    psCauseDeptSkuSupplyPrice.setPsSkuId(psCauseDeptApprovalSku.getPsSkuId());
                    psCauseDeptSkuSupplyPrice.setRemark(psCauseDeptApprovalSku.getRemark());
                    psCauseDeptSkuSupplyPrice.setStatus(priceStatus);
                    psCauseDeptSkuSupplyPrice.setType(psCauseDeptSupplyPriceApproval.getType());
                    psCauseDeptSkuSupplyPrice.setFreightCost(psCauseDeptApprovalSku.getFreightCost());
                    this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCauseDeptSkuSupplyPrice);
                    psCauseDeptSkuSupplyPrice.setCreateUserName(psCauseDeptSupplyPriceApproval.getCreateUserName());
                    psCauseDeptSkuSupplyPrices.add(psCauseDeptSkuSupplyPrice);
                    PsCauseDeptSkuSupplyPrice skuSupplyPrice = psCauseDeptSkuSupplyPriceList.stream().filter(s -> s.getMdmCauseDeptId().equals(id)).findAny().orElse(null);
                    this.getCauseDeptSupplyLogs(psCauseDeptSkuSupplyPriceLogs, removeCauseDeptSkuSupplyPrices, skuSupplyPrice);
                }
            }
            InnerLog.addLog((Long)psCauseDeptSupplyPriceApproval.getId(), (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6838\u901a\u8fc7", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(psCauseDeptSupplyPriceApproval.getType()) ? InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6838\u901a\u8fc7");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"cancel", (CharSequence)result)) {
            psCauseDeptSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.TO_SUBMIT.getValue());
            InnerLog.addLog((Long)psCauseDeptSupplyPriceApproval.getId(), (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6838\u64a4\u9500", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(psCauseDeptSupplyPriceApproval.getType()) ? InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6838\u64a4\u9500");
        } else {
            psCauseDeptSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_REJECT.getValue());
            InnerLog.addLog((Long)psCauseDeptSupplyPriceApproval.getId(), (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6838\u62d2\u7edd", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(psCauseDeptSupplyPriceApproval.getType()) ? InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6838\u62d2\u7edd");
        }
        this.psCauseDeptSupplyPriceApprovalService.updateBatch(psCauseDeptSupplyPriceApproval, psCauseDeptSkuSupplyPrices, removeCauseDeptSkuSupplyPrices, psCauseDeptSkuSupplyPriceLogs);
        List skuIdList = psCauseDeptSkuSupplyPriceLogs.stream().map(PsCauseDeptSkuSupplyPriceLog::getPsSkuId).collect(Collectors.toList());
        List skuId = psCauseDeptSkuSupplyPrices.stream().map(PsCauseDeptSkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
        ArrayList skuIdArrList = CollUtil.newArrayList((Object[])new Long[0]);
        skuIdArrList.addAll(skuIdList);
        skuIdArrList.addAll(skuId);
        if (CollUtil.isNotEmpty((Collection)skuIdArrList)) {
            List skuList = this.skuService.listByIds((Collection)skuIdArrList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    public void supplyPriceFailure() {
        Date date = new Date();
        List psCauseDeptSkuSupplyPriceList = this.psCauseDeptSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCauseDeptSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue())).le(PsCauseDeptSkuSupplyPrice::getInvalidTime, (Object)date));
        if (CollUtil.isEmpty((Collection)psCauseDeptSkuSupplyPriceList)) {
            return;
        }
        ArrayList<PsCauseDeptSkuSupplyPriceLog> psCauseDeptSkuSupplyPriceLogs = new ArrayList<PsCauseDeptSkuSupplyPriceLog>();
        for (PsCauseDeptSkuSupplyPrice skuSupplyPrice : psCauseDeptSkuSupplyPriceList) {
            skuSupplyPrice.setStatus(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue());
            PsCauseDeptSkuSupplyPriceLog psCauseDeptSkuSupplyPriceLog = new PsCauseDeptSkuSupplyPriceLog();
            BeanConvertUtil.copyProperties(skuSupplyPrice, psCauseDeptSkuSupplyPriceLog);
            psCauseDeptSkuSupplyPriceLog.setFailureTime(skuSupplyPrice.getInvalidTime());
            psCauseDeptSkuSupplyPriceLog.setId(this.idSequence.generateId(PsCauseDeptSkuSupplyPriceLog.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCauseDeptSkuSupplyPriceLog);
            psCauseDeptSkuSupplyPriceLogs.add(psCauseDeptSkuSupplyPriceLog);
        }
        this.psCauseDeptSupplyPriceApprovalService.updateBatch(null, null, psCauseDeptSkuSupplyPriceList, psCauseDeptSkuSupplyPriceLogs);
        List skuIdArrList = psCauseDeptSkuSupplyPriceLogs.stream().map(PsCauseDeptSkuSupplyPriceLog::getPsSkuId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(skuIdArrList)) {
            List skuList = this.skuService.listByIds(skuIdArrList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    public void supplyPriceEffect() {
        Date date = new Date();
        List psCauseDeptSkuSupplyPriceList = this.psCauseDeptSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCauseDeptSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.TO_BE_EFFECTIVE.getValue())).le(PsCauseDeptSkuSupplyPrice::getEffectiveTime, (Object)date)).ge(PsCauseDeptSkuSupplyPrice::getInvalidTime, (Object)date));
        if (CollUtil.isEmpty((Collection)psCauseDeptSkuSupplyPriceList)) {
            return;
        }
        ArrayList<PsCauseDeptSkuSupplyPriceLog> psCauseDeptSkuSupplyPriceLogs = new ArrayList<PsCauseDeptSkuSupplyPriceLog>();
        ArrayList<PsCauseDeptSkuSupplyPrice> removeCauseDeptSkuSupplyPrices = new ArrayList<PsCauseDeptSkuSupplyPrice>();
        for (PsCauseDeptSkuSupplyPrice skuSupplyPrice : psCauseDeptSkuSupplyPriceList) {
            PsCauseDeptSkuSupplyPrice CauseDeptSkuSupplyPrice = (PsCauseDeptSkuSupplyPrice)this.psCauseDeptSkuSupplyPriceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCauseDeptSkuSupplyPrice::getPsSkuId, (Object)skuSupplyPrice.getPsSkuId())).eq(PsCauseDeptSkuSupplyPrice::getMdmCauseDeptId, (Object)skuSupplyPrice.getMdmCauseDeptId())).eq(PsCauseDeptSkuSupplyPrice::getType, (Object)skuSupplyPrice.getType())).le(PsCauseDeptSkuSupplyPrice::getEffectiveTime, (Object)skuSupplyPrice.getInvalidTime())).ge(PsCauseDeptSkuSupplyPrice::getInvalidTime, (Object)skuSupplyPrice.getEffectiveTime())).eq(PsCauseDeptSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue()));
            skuSupplyPrice.setStatus(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue());
            this.getCauseDeptSupplyLogs(psCauseDeptSkuSupplyPriceLogs, removeCauseDeptSkuSupplyPrices, CauseDeptSkuSupplyPrice);
        }
        this.psCauseDeptSupplyPriceApprovalService.updateBatch(null, psCauseDeptSkuSupplyPriceList, removeCauseDeptSkuSupplyPrices, psCauseDeptSkuSupplyPriceLogs);
        List skuIdList = psCauseDeptSkuSupplyPriceLogs.stream().map(PsCauseDeptSkuSupplyPriceLog::getPsSkuId).collect(Collectors.toList());
        List skuId = psCauseDeptSkuSupplyPriceList.stream().map(PsCauseDeptSkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
        ArrayList skuIdArrList = CollUtil.newArrayList((Object[])new Long[0]);
        skuIdArrList.addAll(skuIdList);
        skuIdArrList.addAll(skuId);
        if (CollUtil.isNotEmpty((Collection)skuIdArrList)) {
            List skuList = this.skuService.listByIds((Collection)skuIdArrList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    private void getCauseDeptSupplyLogs(List<PsCauseDeptSkuSupplyPriceLog> psCauseDeptSkuSupplyPriceLogs, List<PsCauseDeptSkuSupplyPrice> removeCauseDeptSkuSupplyPrices, PsCauseDeptSkuSupplyPrice causeDeptSkuSupplyPrice) {
        if (causeDeptSkuSupplyPrice != null) {
            causeDeptSkuSupplyPrice.setStatus(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue());
            removeCauseDeptSkuSupplyPrices.add(causeDeptSkuSupplyPrice);
            PsCauseDeptSkuSupplyPriceLog psCauseDeptSkuSupplyPriceLog = new PsCauseDeptSkuSupplyPriceLog();
            psCauseDeptSkuSupplyPriceLog.setEffectiveTime(causeDeptSkuSupplyPrice.getEffectiveTime());
            psCauseDeptSkuSupplyPriceLog.setInvalidTime(causeDeptSkuSupplyPrice.getInvalidTime());
            psCauseDeptSkuSupplyPriceLog.setMdmCauseDeptId(causeDeptSkuSupplyPrice.getMdmCauseDeptId());
            psCauseDeptSkuSupplyPriceLog.setPsCauseDeptSupplyPriceApprovalId(causeDeptSkuSupplyPrice.getPsCauseDeptSupplyPriceApprovalId());
            psCauseDeptSkuSupplyPriceLog.setRemark(causeDeptSkuSupplyPrice.getRemark());
            psCauseDeptSkuSupplyPriceLog.setStatus(causeDeptSkuSupplyPrice.getStatus());
            psCauseDeptSkuSupplyPriceLog.setSupplyPrice(causeDeptSkuSupplyPrice.getSupplyPrice());
            psCauseDeptSkuSupplyPriceLog.setPsSkuId(causeDeptSkuSupplyPrice.getPsSkuId());
            psCauseDeptSkuSupplyPriceLog.setFailureTime(new Date());
            psCauseDeptSkuSupplyPriceLog.setFreightCost(psCauseDeptSkuSupplyPriceLog.getFreightCost());
            psCauseDeptSkuSupplyPriceLog.setType(causeDeptSkuSupplyPrice.getType());
            psCauseDeptSkuSupplyPriceLog.setId(this.idSequence.generateId(PsCauseDeptSkuSupplyPriceLog.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCauseDeptSkuSupplyPriceLog);
            psCauseDeptSkuSupplyPriceLogs.add(psCauseDeptSkuSupplyPriceLog);
        }
    }

    public void supplyPriceInvalid(ApiRequest<List<Long>> request) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)((Collection)request.getJsonData())), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7id\u4e0d\u80fd\u4e3a\u7a7a");
        List psCauseDeptSkuSupplyPriceList = this.psCauseDeptSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().ne(PsCauseDeptSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue())).in(BaseDo::getId, (Collection)request.getJsonData()));
        ArrayList<PsCauseDeptSkuSupplyPriceLog> psCauseDeptSkuSupplyPriceLogs = new ArrayList<PsCauseDeptSkuSupplyPriceLog>();
        ArrayList<PsCauseDeptSkuSupplyPrice> removeCauseDeptSkuSupplyPrices = new ArrayList<PsCauseDeptSkuSupplyPrice>();
        for (PsCauseDeptSkuSupplyPrice CauseDeptSkuSupplyPrice : psCauseDeptSkuSupplyPriceList) {
            this.getCauseDeptSupplyLogs(psCauseDeptSkuSupplyPriceLogs, removeCauseDeptSkuSupplyPrices, CauseDeptSkuSupplyPrice);
        }
        this.psCauseDeptSupplyPriceApprovalService.updateBatch(null, null, removeCauseDeptSkuSupplyPrices, psCauseDeptSkuSupplyPriceLogs);
        List skuIdList = psCauseDeptSkuSupplyPriceLogs.stream().map(PsCauseDeptSkuSupplyPriceLog::getPsSkuId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(skuIdList)) {
            List skuList = this.skuService.listByIds(skuIdList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    public Page<PsCauseDeptSkuSupplyPriceDTO> selectPage(ApiRequest<SpuQueryDTO> request) {
        List list;
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptName()) || StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptCode())) {
            List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(null, queryDTO.getCauseDeptName(), queryDTO.getCauseDeptCode());
            if (CollUtil.isEmpty(orgDepartments)) {
                return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
            }
            List causeDeptIdList = orgDepartments.stream().map(OrgDepartment::getId).collect(Collectors.toList());
            queryDTO.setCauseDeptIdList(causeDeptIdList);
        }
        Page page = null;
        page = Integer.valueOf(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue()).equals(queryDTO.getStatus()) ? this.psCauseDeptSkuSupplyPriceLogService.selectPage(queryDTO) : this.psCauseDeptSkuSupplyPriceService.selectPage(queryDTO);
        List records = page.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
        }
        boolean isCostPrice = true;
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse<Map<String, List<String>>> mapApiResponse = this.scAdapter.selectSensitiveColumnByUserId(user.getUserId());
        Assert.isTrue((boolean)mapApiResponse.isSuccess(), (String)mapApiResponse.getDesc());
        Map map = (Map)mapApiResponse.getContent();
        if (map.containsKey("ps_causeDept_sku_supply_price") && (list = (List)map.get("ps_causeDept_sku_supply_price")).contains("sg_cost_price")) {
            isCostPrice = false;
        }
        List<Long> cusCauseDeptIds = records.stream().map(PsCauseDeptSkuSupplyPriceDTO::getMdmCauseDeptId).collect(Collectors.toList());
        List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(cusCauseDeptIds, null, null);
        List skuIds = records.stream().map(PsCauseDeptSkuSupplyPriceDTO::getPsSkuId).collect(Collectors.toList());
        List skuList = this.skuService.listByIds(skuIds);
        List<String> skuCodeList = skuList.stream().map(Sku::getCode).collect(Collectors.toList());
        List spuIds = skuList.stream().map(Sku::getPsSpuId).distinct().collect(Collectors.toList());
        List spuList = this.spuService.listByIds(spuIds);
        List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(skuCodeList);
        for (PsCauseDeptSkuSupplyPriceDTO record : records) {
            Sku sku;
            OrgDepartment CauseDeptVO2;
            List skuBarCodes;
            PsCauseDeptSkuSupplyPrice CauseDeptSkuSupplyPrice;
            if (Integer.valueOf(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.TO_BE_EFFECTIVE.getValue()).equals(queryDTO.getStatus()) && (CauseDeptSkuSupplyPrice = (PsCauseDeptSkuSupplyPrice)this.psCauseDeptSkuSupplyPriceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCauseDeptSkuSupplyPrice::getMdmCauseDeptId, (Object)record.getMdmCauseDeptId())).eq(PsCauseDeptSkuSupplyPrice::getPsSkuId, (Object)record.getPsSkuId())).eq(PsCauseDeptSkuSupplyPrice::getType, (Object)record.getType())).eq(PsCauseDeptSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue()))) != null) {
                record.setCurrentSupplyPrice(CauseDeptSkuSupplyPrice.getSupplyPrice());
            }
            if (Integer.valueOf(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue()).equals(queryDTO.getStatus())) {
                record.setCurrentSupplyPrice(record.getSupplyPrice());
            }
            if (CollUtil.isNotEmpty(skuBarCodes = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(record.getPsSkuId())).collect(Collectors.toList()))) {
                record.setBarCode(skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(",")));
            }
            if ((CauseDeptVO2 = (OrgDepartment)orgDepartments.stream().filter(s -> s.getId().equals(record.getMdmCauseDeptId())).findAny().orElse(null)) != null) {
                record.setCauseDeptCode(CauseDeptVO2.getCode());
                record.setCauseDeptName(CauseDeptVO2.getName());
            }
            if ((sku = (Sku)skuList.stream().filter(s -> s.getId().equals(record.getPsSkuId())).findAny().orElse(null)) != null) {
                record.setSkuCode(sku.getCode());
                record.setSkuName(sku.getName());
                record.setKyThirdPlatformCode(sku.getKyThirdPlatformCode());
                record.setWmsThirdPlatformCode(sku.getWmsThirdPlatformCode());
                record.setCounterPrice(BigDecimalUtils.convert(sku.getCounterPrice(), 2));
                Spu spu = spuList.stream().filter(s -> s.getId().equals(sku.getPsSpuId())).findAny().orElse(null);
                if (spu != null) {
                    record.setClassify(spu.getClassify());
                    record.setBrandName(spu.getPsBrandName());
                    record.setSpuStatus(spu.getStatus());
                    record.setSpuCode(spu.getCode());
                    record.setSpuName(spu.getName());
                }
            }
            if (!isCostPrice) continue;
            sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(record.getSkuCode())).findAny().ifPresent(sgBStorageCostVo -> record.setSgCostPrice(sgBStorageCostVo.getPriceCost()));
        }
        return page;
    }

    public String selectTableCount(ApiRequest<SpuQueryDTO> request) {
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptName()) || StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptCode())) {
            List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(null, queryDTO.getCauseDeptName(), queryDTO.getCauseDeptCode());
            if (CollUtil.isEmpty(orgDepartments)) {
                return "0";
            }
            List causeDeptIdList = orgDepartments.stream().map(OrgDepartment::getId).collect(Collectors.toList());
            queryDTO.setCauseDeptIdList(causeDeptIdList);
        }
        Long count = this.psCauseDeptSkuSupplyPriceService.selectTableCount(queryDTO);
        return this.psCauseDeptSupplyPriceApprovalBiz.covertCount(count);
    }

    public long selectTableCountAndReturnNumber(ApiRequest<SpuQueryDTO> request) {
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptName()) || StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptCode())) {
            List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(null, queryDTO.getCauseDeptName(), queryDTO.getCauseDeptCode());
            if (CollUtil.isEmpty(orgDepartments)) {
                return 0L;
            }
            List causeDeptIdList = orgDepartments.stream().map(OrgDepartment::getId).collect(Collectors.toList());
            queryDTO.setCauseDeptIdList(causeDeptIdList);
        }
        return this.psCauseDeptSkuSupplyPriceService.selectTableCount(queryDTO);
    }

    public List<PsCauseDeptSkuSupplyPriceLogDTO> selectHistoryList(ApiRequest<DeptHistoryDTO> request) {
        DeptHistoryDTO dto = (DeptHistoryDTO)request.getJsonData();
        ParameterColumnHandler.convertParameter(dto, CollUtil.newArrayList((Object[])new String[]{"submitUser", "updateUserName"}), "IsUnion");
        return this.psCauseDeptSkuSupplyPriceLogService.selectHistoryList(dto);
    }

    public List<SupplyPriceApprovalCheckDTO> postpone(ApiRequest<List<PostponeDTO>> request) {
        PostponeDTO postponeDTO;
        List postponeDTOS = (List)request.getJsonData();
        List psCauseDeptSkuSupplyPriceIdList = postponeDTOS.stream().map(PostponeDTO::getId).collect(Collectors.toList());
        List psCauseDeptSkuSupplyPriceList = this.psCauseDeptSkuSupplyPriceService.list((Wrapper)new QueryWrapper().lambda().in(BaseDo::getId, psCauseDeptSkuSupplyPriceIdList));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)psCauseDeptSkuSupplyPriceList), (String)"\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        List<Long> skuIdList = psCauseDeptSkuSupplyPriceList.stream().map(PsCauseDeptSkuSupplyPrice::getPsSkuId).distinct().collect(Collectors.toList());
        List skuList = this.skuService.listByIds(skuIdList);
        List psCauseDeptSkuSupplyPrices = psCauseDeptSkuSupplyPriceList.stream().filter(item -> !item.getStatus().equals(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(psCauseDeptSkuSupplyPrices)) {
            List skuIdLongList = psCauseDeptSkuSupplyPrices.stream().map(PsCauseDeptSkuSupplyPrice::getPsSkuId).distinct().collect(Collectors.toList());
            List skuNameList = skuList.stream().filter(item -> skuIdLongList.contains(item.getId())).map(Sku::getName).collect(Collectors.toList());
            throw new IllegalArgumentException(String.valueOf(skuNameList) + "\u4f9b\u8d27\u4ef7\u4e0d\u662f\u5df2\u751f\u6548\u72b6\u6001");
        }
        List<Long> causeDeptIdList = psCauseDeptSkuSupplyPriceList.stream().map(PsCauseDeptSkuSupplyPrice::getMdmCauseDeptId).collect(Collectors.toList());
        ArrayList CauseDeptSkuSupplyPriceList = CollUtil.newArrayList((Object[])new SaveCauseDeptSkuSupplyPriceDTO[0]);
        for (Object causeDeptSkuSupplyPrice : psCauseDeptSkuSupplyPriceList) {
            SaveCauseDeptSkuSupplyPriceDTO saveCauseDeptSkuSupplyPriceDTO = new SaveCauseDeptSkuSupplyPriceDTO();
            postponeDTO = postponeDTOS.stream().filter(arg_0 -> PsCauseDeptSkuSupplyPriceBiz.lambda$postpone$9((PsCauseDeptSkuSupplyPrice)causeDeptSkuSupplyPrice, arg_0)).findAny().orElse(null);
            if (postponeDTO != null) {
                Assert.isTrue((postponeDTO.getInvalidTime().getTime() > causeDeptSkuSupplyPrice.getInvalidTime().getTime() ? 1 : 0) != 0, (String)"\u5ef6\u7eed\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4");
                saveCauseDeptSkuSupplyPriceDTO.setInvalidTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)postponeDTO.getInvalidTime(), (String)"yyyy-MM-dd 00:00:00")));
                saveCauseDeptSkuSupplyPriceDTO.setPsSkuId(causeDeptSkuSupplyPrice.getPsSkuId());
                saveCauseDeptSkuSupplyPriceDTO.setEffectiveTime((Date)DateUtil.offsetSecond((Date)causeDeptSkuSupplyPrice.getInvalidTime(), (int)1));
            }
            CauseDeptSkuSupplyPriceList.add(saveCauseDeptSkuSupplyPriceDTO);
        }
        ArrayList skuSupplyPrices = CollUtil.newArrayList((Object[])new PsCauseDeptSkuSupplyPrice[0]);
        for (PsCauseDeptSkuSupplyPrice psCauseDeptSkuSupplyPrice : psCauseDeptSkuSupplyPriceList) {
            postponeDTO = postponeDTOS.stream().filter(item -> item.getId().equals(psCauseDeptSkuSupplyPrice.getId())).findAny().orElse(null);
            if (postponeDTO == null) continue;
            PsCauseDeptSkuSupplyPrice skuSupplyPrice2 = new PsCauseDeptSkuSupplyPrice();
            skuSupplyPrice2.setId(psCauseDeptSkuSupplyPrice.getId());
            skuSupplyPrice2.setInvalidTime(psCauseDeptSkuSupplyPrice.getInvalidTime());
            skuSupplyPrices.add(skuSupplyPrice2);
            psCauseDeptSkuSupplyPrice.setInvalidTime(postponeDTO.getInvalidTime());
            psCauseDeptSkuSupplyPrice.setInvalidTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)postponeDTO.getInvalidTime(), (String)"yyyy-MM-dd 23:59:59")));
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psCauseDeptSkuSupplyPrice);
        }
        List<SupplyPriceApprovalCheckDTO> supplyPriceApprovalCheckDTOS = this.psCauseDeptSupplyPriceApprovalBiz.checkSupplyPriceValidity(causeDeptIdList, ((PsCauseDeptSkuSupplyPrice)psCauseDeptSkuSupplyPriceList.get(0)).getType(), skuIdList, skuList, CollUtil.newArrayList((Object[])new OrgDepartment[0]), null, CauseDeptSkuSupplyPriceList, psCauseDeptSkuSupplyPriceList);
        if (CollUtil.isNotEmpty(supplyPriceApprovalCheckDTOS)) {
            return supplyPriceApprovalCheckDTOS;
        }
        this.psCauseDeptSkuSupplyPriceService.updateBatchById((Collection)psCauseDeptSkuSupplyPriceList);
        for (PsCauseDeptSkuSupplyPrice CauseDeptSkuSupplyPrice : psCauseDeptSkuSupplyPriceList) {
            skuSupplyPrices.stream().filter(item -> item.getId().equals(CauseDeptSkuSupplyPrice.getId())).findAny().ifPresent(skuSupplyPrice -> InnerLog.addLog((Long)CauseDeptSkuSupplyPrice.getId(), (String)"\u5ef6\u7eed\u4f9b\u8d27\u4ef7\u65e5\u671f", (String)InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE.getCode(), null, (String)("\u539f\u5931\u6548\u65e5\u671f" + DateUtil.formatChineseDate((Date)skuSupplyPrice.getInvalidTime(), (boolean)false, (boolean)true) + "\u5ef6\u671f\u4e3a" + DateUtil.formatChineseDate((Date)CauseDeptSkuSupplyPrice.getInvalidTime(), (boolean)false, (boolean)true))));
        }
        return CollUtil.newArrayList((Object[])new SupplyPriceApprovalCheckDTO[0]);
    }

    public PsBasicsBatchVO updateSupplyPrice(ApiRequest<List<PostponeDTO>> request) {
        List dtoList = (List)request.getJsonData();
        List psCacuseSkuSupplyPriceIdList = dtoList.stream().map(PostponeDTO::getId).collect(Collectors.toList());
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            for (PostponeDTO dto : dtoList) {
                String lockKey = "ps:cause_dept_supply_price:update:" + dto.getId();
                RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u5ba2\u6237\u4f9b\u8d27\u4ef7\u7528\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock);
            }
            List psCauseDeptSkuSupplyPriceList = this.psCauseDeptSkuSupplyPriceService.list((Wrapper)new QueryWrapper().lambda().in(BaseDo::getId, psCacuseSkuSupplyPriceIdList));
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)psCauseDeptSkuSupplyPriceList), (String)"\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            List skuIdList = psCauseDeptSkuSupplyPriceList.stream().map(PsCauseDeptSkuSupplyPrice::getPsSkuId).distinct().collect(Collectors.toList());
            List skuList = this.skuService.listByIds(skuIdList);
            PsBasicsBatchVO psBasicsBatchVO = new PsBasicsBatchVO();
            ArrayList errorMessageList = CollUtil.newArrayList((Object[])new PsBasicsBatchVO.ErrorMessage[0]);
            ArrayList psCauseDeptSkuSupplyPrices = CollUtil.newArrayList((Object[])new PsCauseDeptSkuSupplyPrice[0]);
            for (PsCauseDeptSkuSupplyPrice psCauseDeptSkuSupplyPrice : psCauseDeptSkuSupplyPriceList) {
                PsBasicsBatchVO.ErrorMessage errorMessage = new PsBasicsBatchVO.ErrorMessage();
                Sku sku = skuList.stream().filter(item -> ObjectUtil.equal((Object)psCauseDeptSkuSupplyPrice.getPsSkuId(), (Object)item.getId())).findAny().orElse(null);
                if (!StrUtil.equals((CharSequence)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue(), (CharSequence)psCauseDeptSkuSupplyPrice.getStatus())) {
                    errorMessage.setId(sku.getId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u4f9b\u8d27\u4ef7\u975e\u751f\u6548\u72b6\u6001");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                PostponeDTO postponeDTO = dtoList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)psCauseDeptSkuSupplyPrice.getId())).findAny().orElse(null);
                if (postponeDTO.getInvalidTime().getTime() < psCauseDeptSkuSupplyPrice.getEffectiveTime().getTime()) {
                    errorMessage.setId(sku.getId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                if (postponeDTO.getInvalidTime().getTime() > DateUtil.offsetDay((Date)psCauseDeptSkuSupplyPrice.getInvalidTime(), (int)-1).getTime()) {
                    errorMessage.setId(sku.getId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u4f9b\u8d27\u4ef7\u5931\u6548\u65f6\u95f4\u524d\u4e00\u5929");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                PsCauseDeptSkuSupplyPrice skuSupplyPrice2 = new PsCauseDeptSkuSupplyPrice();
                skuSupplyPrice2.setId(psCauseDeptSkuSupplyPrice.getId());
                skuSupplyPrice2.setInvalidTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)postponeDTO.getInvalidTime(), (String)"yyyy-MM-dd 23:59:59")));
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)skuSupplyPrice2);
                psCauseDeptSkuSupplyPrices.add(skuSupplyPrice2);
            }
            if (CollUtil.isNotEmpty((Collection)psCauseDeptSkuSupplyPrices)) {
                this.psCauseDeptSkuSupplyPriceService.updateBatchById((Collection)psCauseDeptSkuSupplyPrices);
            }
            for (PsCauseDeptSkuSupplyPrice CauseDeptSkuSupplyPrice : psCauseDeptSkuSupplyPrices) {
                psCauseDeptSkuSupplyPriceList.stream().filter(item -> item.getId().equals(CauseDeptSkuSupplyPrice.getId())).findAny().ifPresent(skuSupplyPrice -> InnerLog.addLog((Long)CauseDeptSkuSupplyPrice.getId(), (String)"\u8c03\u6574\u4f9b\u8d27\u4ef7\u65e5\u671f", (String)InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE.getCode(), null, (String)("\u539f\u5931\u6548\u65e5\u671f" + DateUtil.formatChineseDate((Date)skuSupplyPrice.getInvalidTime(), (boolean)false, (boolean)true) + "\u8c03\u6574\u4e3a" + DateUtil.formatChineseDate((Date)CauseDeptSkuSupplyPrice.getInvalidTime(), (boolean)false, (boolean)true))));
            }
            if (CollUtil.isNotEmpty((Collection)errorMessageList)) {
                PsCauseDeptSkuSupplyPrice CauseDeptSkuSupplyPrice;
                List ids = errorMessageList.stream().map(PsBasicsBatchVO.ErrorMessage::getId).collect(Collectors.toList());
                psBasicsBatchVO.setErrorIds(ids);
                psBasicsBatchVO.setErrorTotal(Integer.valueOf(ids.size()));
                psBasicsBatchVO.setSuccessTotal(Integer.valueOf(psCauseDeptSkuSupplyPrices.size()));
                psBasicsBatchVO.setTotal(Integer.valueOf(ids.size()));
                psBasicsBatchVO.setErrorMessageList((List)errorMessageList);
                CauseDeptSkuSupplyPrice = psBasicsBatchVO;
                return CauseDeptSkuSupplyPrice;
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("Invoice.FcOutputInvoiceBiz.billingInvoice Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    private static /* synthetic */ boolean lambda$postpone$9(PsCauseDeptSkuSupplyPrice causeDeptSkuSupplyPrice, PostponeDTO item) {
        return item.getId().equals(causeDeptSkuSupplyPrice.getId());
    }
}

