/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.BigDecimalUtil;
import com.xinqiyi.mdm.api.model.vo.salesman.SalesmanVO;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.mdm.model.dto.salesman.SalesmanDTO;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.PsCauseDeptApprovalService;
import com.xinqiyi.ps.dao.repository.PsCauseDeptApprovalSkuService;
import com.xinqiyi.ps.dao.repository.PsCauseDeptSkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.PsCauseDeptSupplyPriceApprovalService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.model.dto.dept.CauseDeptApprovalDTO;
import com.xinqiyi.ps.model.dto.dept.CauseDeptDTO;
import com.xinqiyi.ps.model.dto.dept.CauseDeptSupplyPriceApprovalDTO;
import com.xinqiyi.ps.model.dto.dept.PsCauseDeptApprovalSkuDTO;
import com.xinqiyi.ps.model.dto.dept.SaveCauseDeptSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.dept.SaveCauseDeptSupplyPriceApprovalDTO;
import com.xinqiyi.ps.model.dto.enums.CustomerSupplyPriceEnum;
import com.xinqiyi.ps.model.dto.enums.InnerLogTypeEnum;
import com.xinqiyi.ps.model.dto.enums.IsDeleteEnums;
import com.xinqiyi.ps.model.dto.enums.SkuSupplyPriceStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SpuClassifyEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.sku.InteriorSkuDTO;
import com.xinqiyi.ps.model.dto.sku.QueryComposeSkuDTO;
import com.xinqiyi.ps.model.dto.sku.QueryInteriorSkuDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.supplyprice.ApprovalTableKeyDTO;
import com.xinqiyi.ps.model.dto.supplyprice.CustomerApprovalSkuDTO;
import com.xinqiyi.ps.model.dto.supplyprice.QuerySkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SaveSupplyPriceApprovalDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SupplyPriceApprovalCheckDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SupplyPriceDetailsDTO;
import com.xinqiyi.ps.model.dto.supplyprice.TableCountDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.PsCauseDeptApproval;
import com.xinqiyi.ps.model.entity.PsCauseDeptApprovalSku;
import com.xinqiyi.ps.model.entity.PsCauseDeptSkuSupplyPrice;
import com.xinqiyi.ps.model.entity.PsCauseDeptSupplyPriceApproval;
import com.xinqiyi.ps.model.entity.PsCustomerSupplyPriceApproval;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.model.entity.SkuSupplyPrice;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.oa.OaAdapter;
import com.xinqiyi.ps.service.adapter.org.OrgAdapter;
import com.xinqiyi.ps.service.adapter.org.OrgDepartment;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.business.ComposeSkuBiz;
import com.xinqiyi.ps.service.business.PsCauseDeptApprovalBiz;
import com.xinqiyi.ps.service.business.PsCauseDeptApprovalSkuBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import com.xinqiyi.ps.service.util.AcquireBillNoUtil;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.FileUploadUtil;
import com.xinqiyi.ps.service.util.PsRedisLockUtil;
import com.xinqiyi.ps.service.util.TimeSlotUtil;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageCostVo;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsCauseDeptSupplyPriceApprovalBiz {
    private static final Logger log = LoggerFactory.getLogger(PsCauseDeptSupplyPriceApprovalBiz.class);
    @Autowired
    private SkuService skuService;
    @Autowired
    private PsCauseDeptSupplyPriceApprovalService psCauseDeptSupplyPriceApprovalService;
    @Autowired
    private PsCauseDeptSkuSupplyPriceService psCauseDeptSkuSupplyPriceService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private AcquireBillNoUtil acquireBillNoUtil;
    @Autowired
    private PsCauseDeptApprovalSkuBiz psCauseDeptApprovalSkuBiz;
    @Autowired
    private PsCauseDeptApprovalSkuService causeDeptApprovalSkuService;
    @Autowired
    private SkuBarCodeService skuBarCodeService;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private FileUploadUtil fileUploadUtil;
    @Autowired
    private SgStorageQueryAdapter sgStorageQueryAdapter;
    @Autowired
    private OaAdapter oaAdapter;
    @Autowired
    private OrgAdapter orgAdapter;
    @Autowired
    private PsCauseDeptApprovalService psCauseDeptApprovalService;
    @Autowired
    private PsCauseDeptApprovalBiz psCauseDeptApprovalBiz;
    @Autowired
    private PsCauseDeptApprovalSkuService psCauseDeptApprovalSkuService;
    @Autowired
    private BrandService brandService;
    @Autowired
    private SpuService spuService;
    @Autowired
    private MdmAdapter mdmAdapter;
    @Autowired
    private ComposeSkuBiz composeSkuBiz;
    @Autowired
    private SkuSupplyPriceService skuSupplyPriceService;

    public ApiResponse<SaveSupplyPriceApprovalDTO> save(ApiRequest<SaveCauseDeptSupplyPriceApprovalDTO> request) {
        SaveCauseDeptSupplyPriceApprovalDTO deptSupplyPriceApprovalDTO = (SaveCauseDeptSupplyPriceApprovalDTO)request.getJsonData();
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            RedisReentrantLock lock;
            List skuIdList = deptSupplyPriceApprovalDTO.getCauseDeptSkuSupplyPriceList().stream().map(SaveCauseDeptSkuSupplyPriceDTO::getPsSkuId).distinct().collect(Collectors.toList());
            for (Long id : skuIdList) {
                String lockKey = "ps:dept_supply_price_approval:save:" + id;
                lock = PsRedisLockUtil.lock(lockKey, "\u5ba1\u6279\u5355\u5546\u54c1\u7528\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock);
            }
            if (deptSupplyPriceApprovalDTO.getId() != null) {
                String lockKey = "ps:dept_supply_price_approval:submit:" + deptSupplyPriceApprovalDTO.getId();
                RedisReentrantLock lock2 = PsRedisLockUtil.lock(lockKey, "\u5ba1\u6279\u5355\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock2);
            }
            List<OrgDepartment> orgDepartments = this.checkCauseDeptParam(deptSupplyPriceApprovalDTO.getMdmCauseDeptIdList());
            List<SupplyPriceApprovalCheckDTO> supplyPriceApprovalCheckDTOS = this.checkSupplyPriceParam(deptSupplyPriceApprovalDTO, orgDepartments);
            SaveSupplyPriceApprovalDTO saveSupplyPriceApprovalDTO = new SaveSupplyPriceApprovalDTO();
            saveSupplyPriceApprovalDTO.setId(deptSupplyPriceApprovalDTO.getId());
            if (CollUtil.isNotEmpty(supplyPriceApprovalCheckDTOS)) {
                saveSupplyPriceApprovalDTO.setSkuList(supplyPriceApprovalCheckDTOS);
                lock = ApiResponse.success((Object)saveSupplyPriceApprovalDTO);
                return lock;
            }
            List<Object> newMdmCauseDeptIdList = new ArrayList();
            if (deptSupplyPriceApprovalDTO.getId() == null) {
                newMdmCauseDeptIdList = deptSupplyPriceApprovalDTO.getMdmCauseDeptIdList();
            }
            List<Object> removeMdmCauseDeptIdIdList = new ArrayList();
            PsCauseDeptSupplyPriceApproval causeDeptSupplyPriceApproval = new PsCauseDeptSupplyPriceApproval();
            if (deptSupplyPriceApprovalDTO.getId() != null) {
                causeDeptSupplyPriceApproval = (PsCauseDeptSupplyPriceApproval)this.psCauseDeptSupplyPriceApprovalService.getById((Serializable)deptSupplyPriceApprovalDTO.getId());
                Assert.notNull((Object)causeDeptSupplyPriceApproval, (String)"\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)causeDeptSupplyPriceApproval);
                if (CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue().equals(causeDeptSupplyPriceApproval.getStatus()) || CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL.getValue().equals(causeDeptSupplyPriceApproval.getStatus())) {
                    this.saveApprovalRemark(causeDeptSupplyPriceApproval, deptSupplyPriceApprovalDTO);
                    saveSupplyPriceApprovalDTO.setId(causeDeptSupplyPriceApproval.getId());
                    InnerLog.addLog((Long)causeDeptSupplyPriceApproval.getId(), (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u4fdd\u5b58", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(deptSupplyPriceApprovalDTO.getType()) ? InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4fdd\u5b58");
                    ApiResponse apiResponse = ApiResponse.success((Object)saveSupplyPriceApprovalDTO);
                    return apiResponse;
                }
                List mdmCauseDeptIdList = this.psCauseDeptApprovalService.list((Wrapper)new QueryWrapper().lambda().eq(PsCauseDeptApproval::getPsCauseDeptSupplyPriceApprovalId, (Object)deptSupplyPriceApprovalDTO.getId())).stream().map(PsCauseDeptApproval::getMdmCauseDeptId).distinct().collect(Collectors.toList());
                newMdmCauseDeptIdList = deptSupplyPriceApprovalDTO.getMdmCauseDeptIdList().stream().filter(s -> !mdmCauseDeptIdList.contains(s)).collect(Collectors.toList());
                removeMdmCauseDeptIdIdList = mdmCauseDeptIdList.stream().filter(s -> !deptSupplyPriceApprovalDTO.getMdmCauseDeptIdList().contains(s)).collect(Collectors.toList());
            } else {
                causeDeptSupplyPriceApproval.setId(this.idSequence.generateId(PsCustomerSupplyPriceApproval.class));
                causeDeptSupplyPriceApproval.setCode(this.acquireBillNoUtil.getBillNo("psCauseDeptSupplyPriceApproval", "SYBGH"));
                causeDeptSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.TO_SUBMIT.getValue());
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)causeDeptSupplyPriceApproval);
            }
            causeDeptSupplyPriceApproval.setRemark(deptSupplyPriceApprovalDTO.getRemark());
            causeDeptSupplyPriceApproval.setType(deptSupplyPriceApprovalDTO.getType());
            List<PsCauseDeptApproval> psCauseDeptApprovals = this.psCauseDeptApprovalBiz.covertSave(newMdmCauseDeptIdList, causeDeptSupplyPriceApproval);
            List<PsCauseDeptApprovalSku> psCauseDeptApprovalSkuList = this.psCauseDeptApprovalSkuBiz.covertSave(causeDeptSupplyPriceApproval, deptSupplyPriceApprovalDTO);
            List updateIdList = deptSupplyPriceApprovalDTO.getCauseDeptSkuSupplyPriceList().stream().filter(item -> item.getId() != null).map(SaveCauseDeptSkuSupplyPriceDTO::getId).collect(Collectors.toList());
            this.psCauseDeptSupplyPriceApprovalService.saveApproval(causeDeptSupplyPriceApproval, psCauseDeptApprovals, psCauseDeptApprovalSkuList, removeMdmCauseDeptIdIdList, updateIdList);
            if (IsDeleteEnums.YES.getCode().equals(deptSupplyPriceApprovalDTO.getIsSubmit())) {
                List causeDeptName = orgDepartments.stream().filter(item -> StringUtils.isEmpty((CharSequence)item.getOaDingdingDeptId())).map(OrgDepartment::getName).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(causeDeptName)) {
                    ApiResponse apiResponse = ApiResponse.failed((Object)saveSupplyPriceApprovalDTO, (String)"800", (String)(causeDeptName.toString() + "\u6ca1\u6709\u914d\u7f6e\u9489\u9489Id, \u4e0d\u53ef\u63d0\u4ea4"));
                    return apiResponse;
                }
                LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
                List psCauseDeptApprovalSkuArray = this.causeDeptApprovalSkuService.list((Wrapper)new QueryWrapper().lambda().eq(PsCauseDeptApprovalSku::getPsCauseDeptSupplyPriceApprovalId, (Object)causeDeptSupplyPriceApproval.getId()));
                String oaId = null;
                try {
                    oaId = this.createOaFlow(causeDeptSupplyPriceApproval, orgDepartments, user, psCauseDeptApprovalSkuArray, deptSupplyPriceApprovalDTO.getDingDingDeptId());
                }
                catch (Exception e) {
                    ApiResponse apiResponse = ApiResponse.failed((Object)saveSupplyPriceApprovalDTO, (String)"800", (String)e.getMessage());
                    if (CollUtil.isNotEmpty(lockList)) {
                        for (int i = 0; i < lockList.size(); ++i) {
                            PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                        }
                    }
                    return apiResponse;
                }
                causeDeptSupplyPriceApproval.setSubmitUser(user.getName());
                causeDeptSupplyPriceApproval.setSubmitTime(new Date());
                causeDeptSupplyPriceApproval.setOaId(oaId);
                causeDeptSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue());
                this.psCauseDeptSupplyPriceApprovalService.saveApproval(causeDeptSupplyPriceApproval, null, psCauseDeptApprovalSkuList, removeMdmCauseDeptIdIdList, (List)CollUtil.newArrayList((Object[])new Long[0]));
                InnerLog.addLog((Long)causeDeptSupplyPriceApproval.getId(), (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u4fdd\u5b58\u63d0\u4ea4", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(deptSupplyPriceApprovalDTO.getType()) ? InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4fdd\u5b58\u63d0\u4ea4");
            } else {
                InnerLog.addLog((Long)causeDeptSupplyPriceApproval.getId(), (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u4fdd\u5b58", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(deptSupplyPriceApprovalDTO.getType()) ? InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4fdd\u5b58");
            }
            saveSupplyPriceApprovalDTO.setId(causeDeptSupplyPriceApproval.getId());
            ApiResponse apiResponse = ApiResponse.success((Object)saveSupplyPriceApprovalDTO);
            return apiResponse;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("Invoice.FcOutputInvoiceBiz.billingInvoice Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    private String createOaFlow(PsCauseDeptSupplyPriceApproval causeDeptSupplyPriceApproval, List<OrgDepartment> departments, LoginUserInfo user, List<PsCauseDeptApprovalSku> psCauseDeptApprovalSkuList, String dingDingDeptId) {
        QuerySkuSupplyPriceDTO querySkuSupplyPriceDTO = new QuerySkuSupplyPriceDTO();
        querySkuSupplyPriceDTO.setId(causeDeptSupplyPriceApproval.getId());
        List customerApprovalSkuExportDTOS = this.causeDeptApprovalSkuService.selectApprovalSkuList(querySkuSupplyPriceDTO);
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)customerApprovalSkuExportDTOS), (String)"\u4f9b\u8d27\u4ef7\u660e\u7ec6\u4e3a\u7a7a\u4e0d\u53ef\u63d0\u4ea4");
        List skuIds = customerApprovalSkuExportDTOS.stream().map(CustomerApprovalSkuDTO::getPsSkuId).collect(Collectors.toList());
        List<String> skuCodeList = customerApprovalSkuExportDTOS.stream().map(CustomerApprovalSkuDTO::getSkuCode).collect(Collectors.toList());
        List spuIds = customerApprovalSkuExportDTOS.stream().map(CustomerApprovalSkuDTO::getSpuId).distinct().collect(Collectors.toList());
        List spuList = this.spuService.listByIds(spuIds);
        List brandIds = spuList.stream().map(Spu::getPsBrandId).collect(Collectors.toList());
        List brands = this.brandService.listByIds(brandIds);
        SalesmanDTO salesmanDTO = new SalesmanDTO();
        salesmanDTO.setBrandIds((Set)CollUtil.newHashSet(brandIds));
        List<SalesmanVO> salesmanVOS = this.mdmAdapter.queryMarketingList(salesmanDTO);
        ArrayList brandName = CollUtil.newArrayList((Object[])new String[0]);
        for (Brand brand : brands) {
            List salesmanVOList = salesmanVOS.stream().filter(item -> brand.getId().equals(item.getPsBrandId())).collect(Collectors.toList());
            if (!CollUtil.isEmpty(salesmanVOList)) continue;
            brandName.add(brand.getName());
        }
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)brandName), (String)(((Object)brandName).toString() + "\u6ca1\u6709\u914d\u7f6e\u884c\u9500\u4eba\u5458,\u8bf7\u5148\u914d\u7f6e\u884c\u9500\u4eba\u5458\u540e\u63d0\u4ea4"));
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSkuMost(skuCodeList);
        List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
        Date date = new Date();
        List status = Stream.of(SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode(), SkuSupplyPriceStatusEnums.IN_FORCE.getCode()).collect(Collectors.toList());
        List skuSupplyPriceList = CollUtil.newArrayList((Object[])new SkuSupplyPrice[0]);
        if (SupplyPriceTypeEnums.TWO.getCode().equals(causeDeptSupplyPriceApproval.getType())) {
            skuSupplyPriceList = this.skuSupplyPriceService.getBySkuIds(skuIds, status, date, null);
        }
        for (CustomerApprovalSkuDTO customerApprovalSkuExportDTO : customerApprovalSkuExportDTOS) {
            SkuSupplyPrice dfSupplyPrice;
            SgBStorageCostVo sgBStorageCostVo;
            List skuBarCodes;
            customerApprovalSkuExportDTO.setCounterPrice(BigDecimalUtils.convert(customerApprovalSkuExportDTO.getCounterPrice(), 2));
            if (customerApprovalSkuExportDTO.getCustomerPrice() != null) {
                customerApprovalSkuExportDTO.setCustomerPriceOrCounterPrice(customerApprovalSkuExportDTO.getCustomerPrice());
            } else {
                customerApprovalSkuExportDTO.setCustomerPriceOrCounterPrice(customerApprovalSkuExportDTO.getCounterPrice());
            }
            customerApprovalSkuExportDTO.setSupplyPrice(BigDecimalUtils.convert(customerApprovalSkuExportDTO.getSupplyPrice(), 2));
            customerApprovalSkuExportDTO.setInDate(DateUtil.formatDateTime((Date)customerApprovalSkuExportDTO.getEffectiveTime()) + "/" + DateUtil.formatDateTime((Date)customerApprovalSkuExportDTO.getInvalidTime()));
            if (CollUtil.isNotEmpty((Collection)skuBarCodeList) && CollUtil.isNotEmpty(skuBarCodes = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(customerApprovalSkuExportDTO.getPsSkuId())).collect(Collectors.toList()))) {
                customerApprovalSkuExportDTO.setBarCode(skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(",")));
            }
            Spu spu = spuList.stream().filter(s -> s.getId().equals(customerApprovalSkuExportDTO.getSpuId())).findAny().orElse(null);
            Brand brand = brands.stream().filter(s -> s.getId().equals(spu.getPsBrandId())).findAny().orElse(null);
            PsCauseDeptApprovalSku causeDeptApprovalSku = psCauseDeptApprovalSkuList.stream().filter(s -> s.getPsSkuId().equals(customerApprovalSkuExportDTO.getPsSkuId())).findAny().orElse(null);
            if (brand != null && brand.getGrossProfitRate() != null && SupplyPriceTypeEnums.ONE.getCode().equals(causeDeptSupplyPriceApproval.getType())) {
                customerApprovalSkuExportDTO.setBrandGrossProfitRate(brand.getGrossProfitRate().toString() + "%");
                causeDeptApprovalSku.setBrandGrossProfitRate(brand.getGrossProfitRate());
            } else if (brand != null && brand.getGrossProfitRateOneShipment() != null && SupplyPriceTypeEnums.TWO.getCode().equals(causeDeptSupplyPriceApproval.getType())) {
                customerApprovalSkuExportDTO.setBrandGrossProfitRate(brand.getGrossProfitRateOneShipment().toString() + "%");
                causeDeptApprovalSku.setBrandGrossProfitRate(brand.getGrossProfitRateOneShipment());
            }
            BigDecimal price = customerApprovalSkuExportDTO.getCustomerPrice() == null ? customerApprovalSkuExportDTO.getCounterPrice() : customerApprovalSkuExportDTO.getCustomerPrice();
            customerApprovalSkuExportDTO.setCustomerGrossProfit(BigDecimalUtil.subtract((BigDecimal)price, (BigDecimal)customerApprovalSkuExportDTO.getSupplyPrice()));
            BigDecimal customerGrossProfit = BigDecimalUtil.divide((BigDecimal)customerApprovalSkuExportDTO.getCustomerGrossProfit(), (BigDecimal)price, (int)4, (RoundingMode)RoundingMode.HALF_UP);
            customerApprovalSkuExportDTO.setCustomerGrossProfitRate(String.valueOf(BigDecimalUtil.multiply((BigDecimal)customerGrossProfit, (BigDecimal[])new BigDecimal[]{new BigDecimal("100")})) + "%");
            StringBuilder composeSkuCostDesc = new StringBuilder();
            if (log.isDebugEnabled()) {
                log.debug("Spu.Code={},Spu.Classify={}", (Object)spu.getCode(), (Object)spu.getClassify());
            }
            if (SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify())) {
                if (log.isDebugEnabled()) {
                    log.debug("Start Compose Sku CostPrice Calc");
                }
                List<QueryComposeSkuDTO> composeSkuDTOList = this.composeSkuBiz.selectComposeSku(spu.getId());
                List<String> composeSkuCodeList = composeSkuDTOList.stream().map(QueryComposeSkuDTO::getSkuCode).collect(Collectors.toList());
                if (log.isDebugEnabled()) {
                    log.debug("Start Compose Sku CostPrice SKUCode={}", composeSkuCodeList);
                }
                List<SgBStorageCostVo> composeSkuCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSkuMost(composeSkuCodeList);
                BigDecimal totalCostPrice = BigDecimal.ZERO;
                for (QueryComposeSkuDTO composeSkuDTO : composeSkuDTOList) {
                    SgBStorageCostVo costVo;
                    if (!CollUtil.isNotEmpty(composeSkuCostVos) || (costVo = (SgBStorageCostVo)composeSkuCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(composeSkuDTO.getSkuCode())).findAny().orElse(null)) == null) continue;
                    BigDecimal skuPriceCost = costVo.getPriceCost();
                    skuPriceCost = BigDecimalUtil.multiply((BigDecimal)skuPriceCost, (BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(composeSkuDTO.getComposeNumber().intValue())});
                    totalCostPrice = totalCostPrice.add(skuPriceCost);
                    skuPriceCost = skuPriceCost.setScale(2, RoundingMode.HALF_UP);
                    String costPriceValue = costVo.getPriceCost().toPlainString();
                    if ("0E-8".equals(costPriceValue)) {
                        costPriceValue = "0.00000000";
                    }
                    composeSkuCostDesc.append("[" + composeSkuDTO.getSkuName() + "(" + costVo.getPsCSkuEcode() + ") \u6570\u91cf " + composeSkuDTO.getComposeNumber() + " \u5355\u4e2a\u6210\u672c " + costPriceValue + " \u603b\u6210\u672c " + String.valueOf(skuPriceCost) + "] \r\n");
                }
                String costPriceValue = totalCostPrice.toPlainString();
                if ("0E-8".equals(costPriceValue)) {
                    costPriceValue = "0.00000000";
                }
                customerApprovalSkuExportDTO.setSgCostPriceStr(costPriceValue);
                customerApprovalSkuExportDTO.setSgCostPriceDesc(composeSkuCostDesc.toString());
                if (BigDecimalUtils.lessThan(customerApprovalSkuExportDTO.getSupplyPrice(), totalCostPrice)) {
                    customerApprovalSkuExportDTO.setClue("\u672c\u6b21\u8c03\u4ef7\u4f4e\u4e8e\u6210\u672c\u4ef7");
                }
                causeDeptApprovalSku.setSgCostPrice(totalCostPrice);
                causeDeptApprovalSku.setGrossProfit(customerApprovalSkuExportDTO.getGrossProfit());
            } else if (CollUtil.isNotEmpty(sgBStorageCostVos) && (sgBStorageCostVo = (SgBStorageCostVo)sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(customerApprovalSkuExportDTO.getSkuCode())).findAny().orElse(null)) != null) {
                String s2 = sgBStorageCostVo.getPriceCost().toString();
                if ("0E-8".equals(s2)) {
                    s2 = "0.00000000";
                }
                customerApprovalSkuExportDTO.setSgCostPriceStr(s2);
                causeDeptApprovalSku.setSgCostPrice(sgBStorageCostVo.getPriceCost());
                causeDeptApprovalSku.setSgCostPrice(sgBStorageCostVo.getPriceCost());
                causeDeptApprovalSku.setGrossProfit(customerApprovalSkuExportDTO.getGrossProfit());
                if (BigDecimalUtils.lessThan(customerApprovalSkuExportDTO.getSupplyPrice(), sgBStorageCostVo.getPriceCost())) {
                    customerApprovalSkuExportDTO.setClue("\u672c\u6b21\u8c03\u4ef7\u4f4e\u4e8e\u6210\u672c\u4ef7");
                }
            }
            if (!SupplyPriceTypeEnums.TWO.getCode().equals(causeDeptSupplyPriceApproval.getType())) continue;
            SkuSupplyPrice pcSupplyPrice = skuSupplyPriceList.stream().filter(item -> item.getPsSkuId().equals(customerApprovalSkuExportDTO.getPsSkuId()) && SupplyPriceTypeEnums.ONE.getCode().equals(item.getType())).findAny().orElse(null);
            if (pcSupplyPrice != null) {
                customerApprovalSkuExportDTO.setPcSupplyPrice(pcSupplyPrice.getSupplyPrice());
            }
            if ((dfSupplyPrice = (SkuSupplyPrice)skuSupplyPriceList.stream().filter(item -> item.getPsSkuId().equals(customerApprovalSkuExportDTO.getPsSkuId()) && SupplyPriceTypeEnums.TWO.getCode().equals(item.getType())).findAny().orElse(null)) == null) continue;
            customerApprovalSkuExportDTO.setDfSupplyPrice(dfSupplyPrice.getSupplyPrice());
        }
        Object deptName = departments.stream().map(s -> "(" + s.getName() + "," + s.getCode() + ")").collect(Collectors.joining(","));
        if (((String)deptName).length() >= 950) {
            String substring = ((String)deptName).substring(0, 950);
            deptName = substring + "...\u8be6\u60c5\u8bf7\u67e5\u770bexcel";
        }
        String excelurl = "";
        String fileName = "\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355" + causeDeptSupplyPriceApproval.getId() + ".xls";
        String filePath = ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME + fileName;
        try {
            String fileUrl = ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME;
            FileUtil.mkdir((String)fileUrl);
            String templateUrl = fileUrl + "\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u6a21\u677f.xls";
            boolean exist = FileUtil.exist((String)templateUrl);
            if (!exist) {
                this.fileUploadUtil.downLoadFile(ConstantPropertiesUtil.DEPT_SUPPLY_PRICE_APPROVAL_URL, templateUrl);
            }
            TemplateExportParams params = new TemplateExportParams(templateUrl, new Integer[0]);
            HashMap map = Maps.newHashMap();
            map.put("list", customerApprovalSkuExportDTOS);
            map.put("name", String.join((CharSequence)"\n", new CharSequence[]{deptName}));
            Workbook book = ExcelExportUtil.exportExcel((TemplateExportParams)params, (Map)map);
            FileOutputStream fo = new FileOutputStream(filePath);
            book.write((OutputStream)fo);
            fo.close();
            excelurl = this.fileUploadUtil.uploadExcelFileXls("ps", filePath, PinyinUtil.getPinyin((String)user.getUserName()));
            FileUtil.del((String)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6838\u6587\u4ef6\u751f\u6210\u5931\u8d25failMsg" + e.getMessage());
        }
        SupplyPriceDetailsDTO supplyPriceDetails = new SupplyPriceDetailsDTO();
        ApprovalTableKeyDTO approvalTableKeyDTO = ApprovalTableKeyDTO.builder().barCode("\u6761\u7801").clue("\u63d0\u793a").counterPrice("\u4e13\u67dc\u4ef7").inDate("\u6709\u6548\u671f").brandName("\u5546\u54c1\u54c1\u724c").categoryName("\u5546\u54c1\u7c7b\u76ee").remark("\u5907\u6ce8").skuCode("\u89c4\u683c\u7f16\u7801").skuName("\u89c4\u683c\u540d\u79f0").supplyPrice("\u672c\u6b21\u8c03\u4ef7").unitName("\u5355\u4f4d\u540d\u79f0").sgCostPriceStr("\u6210\u672c\u4ef7").brandGrossProfitRate("\u54c1\u724c\u9884\u7b97\u6bdb\u5229\u7387").sgCostPriceDesc("\u7ec4\u5408\u5546\u54c1\u6bdb\u5229\u8bf4\u660e").customerPrice("\u5546\u54c1\u5efa\u8bae\u5ba2\u6237\u552e\u4ef7").customerGrossProfit("\u5ba2\u6237\u6bdb\u5229").customerGrossProfitRate("\u5ba2\u6237\u6bdb\u5229\u7387").freightCost("\u8fd0\u8d39\u6210\u672c").dfSupplyPrice("\u4e00\u4ef6\u4ee3\u53d1\u7edf\u4e00\u4f9b\u8d27\u4ef7").pcSupplyPrice("\u6279\u91c7\u7edf\u4e00\u4f9b\u8d27\u4ef7").customerPriceOrCounterPrice("\u5ba2\u6237\u5efa\u8bae\u4ef7\u6216\u4e13\u67dc\u4ef7").build();
        supplyPriceDetails.setSupplyPriceDetails(approvalTableKeyDTO);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("attach", excelurl);
        data.put("supplyPriceDetails", customerApprovalSkuExportDTOS);
        data.put("tableKeyJson", supplyPriceDetails);
        data.put("causeDeptName", deptName);
        data.put("remark", causeDeptSupplyPriceApproval.getRemark());
        String distinctBrandName = brands.stream().map(Brand::getName).distinct().collect(Collectors.joining());
        data.put("brandName", distinctBrandName);
        data.put("marketingPhoneList", salesmanVOS.stream().map(SalesmanVO::getPhone).collect(Collectors.joining(",")));
        data.put("oaDingdingDeptIdList", StringUtils.join((Object[])departments.stream().map(OrgDepartment::getOaDingdingDeptId).toArray(), (String)","));
        data.put("dingDingDeptId", dingDingDeptId);
        data.put("phoneNumber", user.getPhoneNumber());
        if (SupplyPriceTypeEnums.ONE.getCode().equals(causeDeptSupplyPriceApproval.getType())) {
            SystemConfigVO neiGouDeptId = this.mdmAdapter.queryBySystemConfigKeyCode("PURCHASES_DEPT_ID");
            Assert.notNull((Object)neiGouDeptId, (String)"\u5185\u8d2d\u4e8b\u4e1a\u90e8ID\u4e0d\u80fd\u4e3a\u7a7a");
            List psCauseDeptApprovals = this.psCauseDeptApprovalService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCauseDeptApproval::getMdmCauseDeptId, (Object)Long.valueOf(neiGouDeptId.getValue()))).eq(PsCauseDeptApproval::getPsCauseDeptSupplyPriceApprovalId, (Object)causeDeptSupplyPriceApproval.getId())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
            if (CollUtil.isNotEmpty((Collection)psCauseDeptApprovals)) {
                data.put("isPurchasesDept", "\u662f");
            } else {
                data.put("isPurchasesDept", "\u5426");
            }
        }
        String templateName = SupplyPriceTypeEnums.ONE.getCode().equals(causeDeptSupplyPriceApproval.getType()) ? "CAUSE_DEPT_SUPPLY_PRICE" : "CAUSE_DEPT_SUPPLY_PRICE_WHOLESALE";
        return this.oaAdapter.createOaProcessV2(JSON.toJSONString(data), templateName);
    }

    private void saveApprovalRemark(PsCauseDeptSupplyPriceApproval psCauseDeptSupplyPriceApproval, SaveCauseDeptSupplyPriceApprovalDTO saveCauseDeptSupplyPriceApprovalDTO) {
        psCauseDeptSupplyPriceApproval.setRemark(saveCauseDeptSupplyPriceApprovalDTO.getRemark());
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psCauseDeptSupplyPriceApproval);
        List<PsCauseDeptApprovalSku> psCauseDeptApprovalSkuList = this.psCauseDeptApprovalSkuBiz.saveRemark(saveCauseDeptSupplyPriceApprovalDTO);
        this.psCauseDeptSupplyPriceApprovalService.saveApprovalRemark(psCauseDeptSupplyPriceApproval, psCauseDeptApprovalSkuList);
    }

    private List<OrgDepartment> checkCauseDeptParam(List<Long> causeDeptIdList) {
        List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(causeDeptIdList, null, null);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(orgDepartments), (String)"\u90e8\u95e8\u4e0d\u5b58\u5728");
        Assert.isTrue((causeDeptIdList.size() == orgDepartments.size() ? 1 : 0) != 0, (String)"\u67e5\u65e0\u90e8\u95e8");
        return orgDepartments;
    }

    private List<SupplyPriceApprovalCheckDTO> checkSupplyPriceParam(SaveCauseDeptSupplyPriceApprovalDTO causeDeptSupplyPriceApprovalDTO, List<OrgDepartment> orgDepartments) {
        List deptSkuSupplyPriceList = causeDeptSupplyPriceApprovalDTO.getCauseDeptSkuSupplyPriceList();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)deptSkuSupplyPriceList), (String)"\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        if (causeDeptSupplyPriceApprovalDTO.getId() != null) {
            PsCauseDeptSupplyPriceApproval causeDeptSupplyPriceApproval = (PsCauseDeptSupplyPriceApproval)this.psCauseDeptSupplyPriceApprovalService.getById((Serializable)causeDeptSupplyPriceApprovalDTO.getId());
            Assert.notNull((Object)causeDeptSupplyPriceApproval, (String)"\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
            if (CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue().equals(causeDeptSupplyPriceApproval.getStatus()) || CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL.getValue().equals(causeDeptSupplyPriceApproval.getStatus())) {
                return CollUtil.newArrayList((Object[])new SupplyPriceApprovalCheckDTO[0]);
            }
        }
        List<Long> skuIdList = deptSkuSupplyPriceList.stream().map(SaveCauseDeptSkuSupplyPriceDTO::getPsSkuId).collect(Collectors.toList());
        List skuList = this.skuService.selectByStatus(skuIdList, StatusEnums.ENABLED.getCode());
        for (SaveCauseDeptSkuSupplyPriceDTO dto : deptSkuSupplyPriceList) {
            Sku sku = skuList.stream().filter(s -> dto.getPsSkuId().equals(s.getId())).findAny().orElse(null);
            Assert.notNull((Object)sku, (String)(dto.getPsSkuId() + "sku\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528"));
            Assert.isTrue((boolean)BigDecimalUtils.greaterThan(dto.getSupplyPrice(), new BigDecimal(0)), (String)(sku.getName() + " \u4f9b\u8d27\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            dto.setEffectiveTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)dto.getEffectiveTime(), (String)"yyyy-MM-dd 00:00:00")));
            dto.setInvalidTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)dto.getInvalidTime(), (String)"yyyy-MM-dd 23:59:59")));
            Assert.isTrue((dto.getEffectiveTime().getTime() >= DateUtil.beginOfDay((Date)new Date()).getTime() ? 1 : 0) != 0, (String)(sku.getName() + " \u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            Assert.isTrue((dto.getInvalidTime().getTime() > dto.getEffectiveTime().getTime() ? 1 : 0) != 0, (String)(sku.getName() + " \u4f9b\u8d27\u4ef7\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65f6\u95f4"));
        }
        return this.checkSupplyPriceValidity(causeDeptSupplyPriceApprovalDTO.getMdmCauseDeptIdList(), causeDeptSupplyPriceApprovalDTO.getType(), skuIdList, skuList, orgDepartments, causeDeptSupplyPriceApprovalDTO.getId(), deptSkuSupplyPriceList, null);
    }

    /*
     * WARNING - void declaration
     */
    public List<SupplyPriceApprovalCheckDTO> checkSupplyPriceValidity(List<Long> mdmCauseDeptIdList, String type, List<Long> skuIdList, List<Sku> skuList, List<OrgDepartment> orgDepartments, Long causeDeptSupplyPriceApprovalId, List<SaveCauseDeptSkuSupplyPriceDTO> deptSkuSupplyPriceList, List<PsCauseDeptSkuSupplyPrice> psCauseDeptSkuSupplyPriceArrayList) {
        void var12_16;
        ArrayList<SupplyPriceApprovalCheckDTO> msg = new ArrayList<SupplyPriceApprovalCheckDTO>();
        List psCauseDeptSkuSupplyPrices = this.psCauseDeptSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(PsCauseDeptSkuSupplyPrice::getMdmCauseDeptId, mdmCauseDeptIdList)).in(PsCauseDeptSkuSupplyPrice::getPsSkuId, skuIdList)).eq(PsCauseDeptSkuSupplyPrice::getType, (Object)type)).eq(PsCauseDeptSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.TO_BE_EFFECTIVE.getValue()));
        if (CollUtil.isNotEmpty(psCauseDeptSkuSupplyPriceArrayList)) {
            psCauseDeptSkuSupplyPrices.addAll(psCauseDeptSkuSupplyPriceArrayList);
        } else {
            for (Long l : mdmCauseDeptIdList) {
                for (SaveCauseDeptSkuSupplyPriceDTO deptSkuSupplyPriceDTO : deptSkuSupplyPriceList) {
                    PsCauseDeptSkuSupplyPrice psCauseDeptSkuSupplyPrice = new PsCauseDeptSkuSupplyPrice();
                    psCauseDeptSkuSupplyPrice.setMdmCauseDeptId(l);
                    BeanConvertUtil.copyProperties(deptSkuSupplyPriceDTO, psCauseDeptSkuSupplyPrice);
                    psCauseDeptSkuSupplyPrices.add(psCauseDeptSkuSupplyPrice);
                }
            }
        }
        Map<String, List<PsCauseDeptSkuSupplyPrice>> map = psCauseDeptSkuSupplyPrices.stream().collect(Collectors.groupingBy(v -> v.getMdmCauseDeptId() + "_" + v.getPsSkuId()));
        for (Map.Entry<String, List<PsCauseDeptSkuSupplyPrice>> entry : map.entrySet()) {
            List<PsCauseDeptSkuSupplyPrice> deptSkuSupplyPrices = entry.getValue();
            if (deptSkuSupplyPrices.size() <= 1) continue;
            Iterator<Map.Entry<String, List<PsCauseDeptApprovalSkuDTO>>> dateList = new ArrayList();
            for (PsCauseDeptSkuSupplyPrice saveCustomerSkuSupplyPriceDTO : deptSkuSupplyPrices) {
                dateList.add((Map.Entry<String, List<PsCauseDeptApprovalSkuDTO>>)((Object)(DateUtil.formatDateTime((Date)saveCustomerSkuSupplyPriceDTO.getEffectiveTime()) + "/" + String.valueOf(saveCustomerSkuSupplyPriceDTO.getInvalidTime()))));
            }
            String key = entry.getKey();
            Sku sku = skuList.stream().filter(s -> ((PsCauseDeptSkuSupplyPrice)deptSkuSupplyPrices.get(0)).getPsSkuId().equals(s.getId())).findAny().orElse(null);
            List<Object> idList = CollUtil.newArrayList((Object[])new Long[0]);
            if (CollUtil.isNotEmpty(psCauseDeptSkuSupplyPriceArrayList)) {
                List ids = deptSkuSupplyPrices.stream().map(BaseDo::getId).collect(Collectors.toList());
                idList = psCauseDeptSkuSupplyPriceArrayList.stream().filter(item -> ids.contains(item.getId())).map(BaseDo::getId).collect(Collectors.toList());
            }
            this.getFailMsg((List<SupplyPriceApprovalCheckDTO>)msg, key, sku, orgDepartments, (List<String>)((Object)dateList), idList);
        }
        ArrayList<PsCauseDeptApprovalSkuDTO> arrayList = new ArrayList<PsCauseDeptApprovalSkuDTO>();
        if (CollUtil.isNotEmpty(psCauseDeptSkuSupplyPriceArrayList)) {
            List<PsCauseDeptApprovalSkuDTO> list = BeanConvertUtil.convertList(psCauseDeptSkuSupplyPriceArrayList, PsCauseDeptApprovalSkuDTO.class);
        } else {
            for (Long id : mdmCauseDeptIdList) {
                for (SaveCauseDeptSkuSupplyPriceDTO deptSkuSupplyPriceDTO : deptSkuSupplyPriceList) {
                    PsCauseDeptApprovalSkuDTO psCauseDeptApprovalSkuDTO = new PsCauseDeptApprovalSkuDTO();
                    psCauseDeptApprovalSkuDTO.setMdmCauseDeptId(id);
                    BeanConvertUtil.copyProperties(deptSkuSupplyPriceDTO, psCauseDeptApprovalSkuDTO);
                    arrayList.add(psCauseDeptApprovalSkuDTO);
                }
            }
        }
        List list = this.causeDeptApprovalSkuService.selectApprovalSku(causeDeptSupplyPriceApprovalId, skuIdList, mdmCauseDeptIdList, type);
        var12_16.addAll(list);
        Map<String, List<PsCauseDeptApprovalSkuDTO>> skuMap = var12_16.stream().collect(Collectors.groupingBy(v -> v.getMdmCauseDeptId() + "_" + v.getPsSkuId()));
        for (Map.Entry<String, List<PsCauseDeptApprovalSkuDTO>> longListEntry : skuMap.entrySet()) {
            List<PsCauseDeptApprovalSkuDTO> psCustomerSkuSupplyPrices = longListEntry.getValue();
            if (psCustomerSkuSupplyPrices.size() <= 1) continue;
            ArrayList<String> dateList = new ArrayList<String>();
            for (PsCauseDeptApprovalSkuDTO saveCustomerSkuSupplyPriceDTO : psCustomerSkuSupplyPrices) {
                dateList.add(DateUtil.formatDateTime((Date)saveCustomerSkuSupplyPriceDTO.getEffectiveTime()) + "/" + DateUtil.formatDateTime((Date)saveCustomerSkuSupplyPriceDTO.getInvalidTime()));
            }
            String key = longListEntry.getKey();
            Sku sku = skuList.stream().filter(s -> ((PsCauseDeptApprovalSkuDTO)psCustomerSkuSupplyPrices.get(0)).getPsSkuId().equals(s.getId())).findAny().orElse(null);
            List<Object> idList = CollUtil.newArrayList((Object[])new Long[0]);
            if (CollUtil.isNotEmpty(psCauseDeptSkuSupplyPriceArrayList)) {
                List ids = psCustomerSkuSupplyPrices.stream().map(PsCauseDeptApprovalSkuDTO::getId).collect(Collectors.toList());
                idList = psCauseDeptSkuSupplyPriceArrayList.stream().filter(item -> ids.contains(item.getId())).map(BaseDo::getId).collect(Collectors.toList());
            }
            this.getFailMsg(msg, key, sku, orgDepartments, dateList, idList);
        }
        if (CollUtil.isNotEmpty(msg) && CollUtil.isEmpty(psCauseDeptSkuSupplyPriceArrayList)) {
            Map<Long, List<SupplyPriceApprovalCheckDTO>> msgMap = msg.stream().collect(Collectors.groupingBy(SupplyPriceApprovalCheckDTO::getSkuId));
            ArrayList dtoList = CollUtil.newArrayList((Object[])new SupplyPriceApprovalCheckDTO[0]);
            for (Map.Entry<Long, List<SupplyPriceApprovalCheckDTO>> longListEntry : msgMap.entrySet()) {
                SupplyPriceApprovalCheckDTO customerSupplyPriceApprovalCheckDTO = new SupplyPriceApprovalCheckDTO();
                customerSupplyPriceApprovalCheckDTO.setSkuId(longListEntry.getKey());
                customerSupplyPriceApprovalCheckDTO.setName(longListEntry.getValue().stream().map(SupplyPriceApprovalCheckDTO::getName).distinct().collect(Collectors.joining()));
                dtoList.add(customerSupplyPriceApprovalCheckDTO);
            }
            return dtoList;
        }
        return msg;
    }

    private void getFailMsg(List<SupplyPriceApprovalCheckDTO> msg, String key, Sku sku, List<OrgDepartment> orgDepartments, List<String> dateList, List<Long> idList) {
        if (TimeSlotUtil.overlapping(dateList)) {
            String deptId = key.substring(0, key.indexOf("_"));
            OrgDepartment orgDepartment = orgDepartments.stream().filter(s -> s.getId().equals(Long.valueOf(deptId))).findAny().orElse(null);
            if (CollUtil.isNotEmpty(idList)) {
                for (Long id : idList) {
                    SupplyPriceApprovalCheckDTO customerSupplyPriceApprovalCheckDTO = new SupplyPriceApprovalCheckDTO();
                    customerSupplyPriceApprovalCheckDTO.setId(id);
                    customerSupplyPriceApprovalCheckDTO.setSkuId(sku.getId());
                    msg.add(customerSupplyPriceApprovalCheckDTO);
                }
            } else {
                SupplyPriceApprovalCheckDTO customerSupplyPriceApprovalCheckDTO = new SupplyPriceApprovalCheckDTO();
                customerSupplyPriceApprovalCheckDTO.setSkuId(sku.getId());
                customerSupplyPriceApprovalCheckDTO.setId(Long.valueOf(deptId));
                if (orgDepartment != null) {
                    customerSupplyPriceApprovalCheckDTO.setName(orgDepartment.getName());
                }
                msg.add(customerSupplyPriceApprovalCheckDTO);
            }
        }
    }

    public void removeBatchApproval(ApiRequest<List<Long>> request) {
        List approvalIds = (List)request.getJsonData();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)approvalIds), (String)"\u5ba1\u6279\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<PsCauseDeptSupplyPriceApproval> psCauseDeptSupplyPriceApprovals = new ArrayList<PsCauseDeptSupplyPriceApproval>();
        ArrayList psCauseDeptApprovalSkuArrayList = new ArrayList();
        ArrayList psCauseDeptApprovals = new ArrayList();
        for (Long approvalId : approvalIds) {
            PsCauseDeptSupplyPriceApproval psCauseDeptSupplyPriceApproval = (PsCauseDeptSupplyPriceApproval)this.psCauseDeptSupplyPriceApprovalService.getById((Serializable)approvalId);
            Assert.notNull((Object)psCauseDeptSupplyPriceApproval, (String)(approvalId + " \u7533\u8bf7\u5355\u4e0d\u5b58\u5728"));
            Assert.isTrue((CustomerSupplyPriceEnum.ApprovalStatusEnum.TO_SUBMIT.getValue().equals(psCauseDeptSupplyPriceApproval.getStatus()) || CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_REJECT.getValue().equals(psCauseDeptSupplyPriceApproval.getStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u5355\u4e3a\u5f85\u63d0\u4ea4\u6216\u5ba1\u6279\u9a73\u56de\u624d\u53ef\u5220\u9664");
            psCauseDeptSupplyPriceApprovals.add(psCauseDeptSupplyPriceApproval);
            List psCauseDeptApprovalSkuList = this.causeDeptApprovalSkuService.list((Wrapper)new QueryWrapper().lambda().eq(PsCauseDeptApprovalSku::getPsCauseDeptSupplyPriceApprovalId, (Object)approvalId));
            psCauseDeptApprovalSkuArrayList.addAll(psCauseDeptApprovalSkuList);
            List psCustomerApprovalList = this.psCauseDeptApprovalService.list((Wrapper)new QueryWrapper().lambda().eq(PsCauseDeptApproval::getPsCauseDeptSupplyPriceApprovalId, (Object)approvalId));
            psCauseDeptApprovals.addAll(psCustomerApprovalList);
        }
        this.psCauseDeptSupplyPriceApprovalService.removeBatchApproval(psCauseDeptSupplyPriceApprovals, psCauseDeptApprovalSkuArrayList, psCauseDeptApprovals);
    }

    public CauseDeptSupplyPriceApprovalDTO selectApprovalDetails(ApiRequest<Void> request) {
        Assert.isTrue((request.getDataId() != -1L ? 1 : 0) != 0, (String)"\u5ba1\u6279\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        PsCauseDeptSupplyPriceApproval causeDeptSupplyPriceApproval = (PsCauseDeptSupplyPriceApproval)this.psCauseDeptSupplyPriceApprovalService.getById((Serializable)Long.valueOf(request.getDataId()));
        Assert.notNull((Object)causeDeptSupplyPriceApproval, (String)"\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
        CauseDeptSupplyPriceApprovalDTO causeDeptSupplyPriceApprovalDTO = new CauseDeptSupplyPriceApprovalDTO();
        BeanConvertUtil.copyProperties(causeDeptSupplyPriceApproval, causeDeptSupplyPriceApprovalDTO);
        List<Long> mdmCauseDeptIdList = this.psCauseDeptApprovalService.list((Wrapper)new QueryWrapper().lambda().eq(PsCauseDeptApproval::getPsCauseDeptSupplyPriceApprovalId, (Object)causeDeptSupplyPriceApproval.getId())).stream().map(PsCauseDeptApproval::getMdmCauseDeptId).collect(Collectors.toList());
        List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(mdmCauseDeptIdList, null, null);
        List<CauseDeptDTO> causeDeptDTOS = BeanConvertUtil.convertList(orgDepartments, CauseDeptDTO.class);
        causeDeptSupplyPriceApprovalDTO.setCauseDeptList(causeDeptDTOS);
        return causeDeptSupplyPriceApprovalDTO;
    }

    public List<CustomerApprovalSkuDTO> selectApprovalSkuList(ApiRequest<QuerySkuSupplyPriceDTO> request) {
        List customerApprovalSkuDTOS = this.psCauseDeptApprovalSkuService.selectApprovalSkuList((QuerySkuSupplyPriceDTO)request.getJsonData());
        if (CollUtil.isEmpty((Collection)customerApprovalSkuDTOS)) {
            return CollUtil.newArrayList((Object[])new CustomerApprovalSkuDTO[0]);
        }
        List skuIds = customerApprovalSkuDTOS.stream().map(CustomerApprovalSkuDTO::getPsSkuId).collect(Collectors.toList());
        List<String> skuCodeList = customerApprovalSkuDTOS.stream().map(CustomerApprovalSkuDTO::getSkuCode).collect(Collectors.toList());
        List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(skuCodeList);
        for (CustomerApprovalSkuDTO dto : customerApprovalSkuDTOS) {
            List skuBarCodes;
            dto.setCounterPrice(BigDecimalUtils.convert(dto.getCounterPrice(), 2));
            dto.setSupplyPrice(BigDecimalUtils.convert(dto.getSupplyPrice(), 2));
            if (CollUtil.isNotEmpty((Collection)skuBarCodeList) && CollUtil.isNotEmpty(skuBarCodes = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(dto.getPsSkuId())).collect(Collectors.toList()))) {
                dto.setBarCode(skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(",")));
            }
            if (!CollUtil.isNotEmpty(sgBStorageCostVos)) continue;
            sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(dto.getSkuCode())).findAny().ifPresent(sgBStorageCostVo -> dto.setSgCostPrice(sgBStorageCostVo.getPriceCost()));
        }
        return customerApprovalSkuDTOS;
    }

    public Page<CauseDeptApprovalDTO> selectApprovalPage(ApiRequest<SpuQueryDTO> request) {
        Page page;
        List records;
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptName()) || StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptCode())) {
            List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(null, queryDTO.getCauseDeptName(), queryDTO.getCauseDeptCode());
            if (CollUtil.isEmpty(orgDepartments)) {
                return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
            }
            List cusIds = orgDepartments.stream().map(OrgDepartment::getId).collect(Collectors.toList());
            List approvalIds = this.psCauseDeptApprovalService.list((Wrapper)new QueryWrapper().lambda().in(PsCauseDeptApproval::getMdmCauseDeptId, cusIds)).stream().map(PsCauseDeptApproval::getPsCauseDeptSupplyPriceApprovalId).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(approvalIds)) {
                return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
            }
            queryDTO.setPsCauseDeptApprovalIds(approvalIds);
        }
        if (CollUtil.isEmpty((Collection)(records = (page = this.psCauseDeptSupplyPriceApprovalService.selectApprovalPage(queryDTO)).getRecords()))) {
            return page;
        }
        List ids = records.stream().map(CauseDeptApprovalDTO::getId).collect(Collectors.toList());
        List psCustomerApprovals = this.psCauseDeptApprovalService.list((Wrapper)new QueryWrapper().lambda().in(PsCauseDeptApproval::getPsCauseDeptSupplyPriceApprovalId, ids));
        List<Long> mdmCauseDeptIds = psCustomerApprovals.stream().map(PsCauseDeptApproval::getMdmCauseDeptId).distinct().collect(Collectors.toList());
        List psCauseDeptApprovalSkuList = this.psCauseDeptApprovalSkuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(PsCauseDeptApprovalSku::getPsCauseDeptSupplyPriceApprovalId, ids)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        List skuIds = psCauseDeptApprovalSkuList.stream().map(PsCauseDeptApprovalSku::getPsSkuId).distinct().collect(Collectors.toList());
        InteriorSkuDTO spuQueryDTO = new InteriorSkuDTO();
        spuQueryDTO.setSkuIdList(skuIds);
        List<QueryInteriorSkuDTO> queryInteriorSkuDTOS = this.skuBiz.selectSkuList(spuQueryDTO);
        List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(mdmCauseDeptIds, null, null);
        for (CauseDeptApprovalDTO dto : page.getRecords()) {
            List<Long> cusCustomerIds = psCustomerApprovals.stream().filter(s -> s.getPsCauseDeptSupplyPriceApprovalId().equals(dto.getId())).map(PsCauseDeptApproval::getMdmCauseDeptId).toList();
            List<OrgDepartment> departments = orgDepartments.stream().filter(s -> cusCustomerIds.contains(s.getId())).toList();
            dto.setCauseDeptName(departments.stream().map(s -> s.getName() + "(" + s.getCode() + ")").collect(Collectors.joining(",")));
            List<PsCauseDeptApprovalSku> causeDeptApprovalSkuList = psCauseDeptApprovalSkuList.stream().filter(item -> item.getPsCauseDeptSupplyPriceApprovalId().equals(dto.getId())).toList();
            List<Long> skuIdList = causeDeptApprovalSkuList.stream().map(PsCauseDeptApprovalSku::getPsSkuId).distinct().toList();
            List<QueryInteriorSkuDTO> queryInteriorSkuDTOList = queryInteriorSkuDTOS.stream().filter(item -> skuIdList.contains(item.getSkuId())).toList();
            ArrayList<CallSite> brandNameList = new ArrayList<CallSite>();
            for (QueryInteriorSkuDTO queryInteriorSkuDTO : queryInteriorSkuDTOList) {
                String brandInfo = queryInteriorSkuDTO.getPsBrandName() + "(" + queryInteriorSkuDTO.getBrandCode() + ")";
                if (brandNameList.contains(brandInfo)) continue;
                brandNameList.add((CallSite)((Object)brandInfo));
            }
            dto.setPsBrandName(String.join((CharSequence)",", brandNameList));
        }
        return page;
    }

    public TableCountDTO selectTableSum(ApiRequest<SpuQueryDTO> request) {
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        TableCountDTO tableSumDTO = new TableCountDTO();
        queryDTO.setStatus(null);
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptName()) || StrUtil.isNotBlank((CharSequence)queryDTO.getCauseDeptCode())) {
            List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(null, queryDTO.getCauseDeptName(), queryDTO.getCauseDeptCode());
            if (CollUtil.isEmpty(orgDepartments)) {
                return tableSumDTO;
            }
            List cusIds = orgDepartments.stream().map(OrgDepartment::getId).collect(Collectors.toList());
            List approvalIds = this.psCauseDeptApprovalService.list((Wrapper)new QueryWrapper().lambda().in(PsCauseDeptApproval::getMdmCauseDeptId, cusIds)).stream().map(PsCauseDeptApproval::getPsCauseDeptSupplyPriceApprovalId).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(approvalIds)) {
                return tableSumDTO;
            }
            queryDTO.setPsCauseDeptApprovalIds(approvalIds);
        }
        TableCountDTO sumDTO = this.psCauseDeptSupplyPriceApprovalService.selectApprovalList(queryDTO);
        tableSumDTO.setFirstTableNum(this.covertCount(sumDTO.getFirstTableNumL()));
        tableSumDTO.setSecondTableNum(this.covertCount(sumDTO.getSecondTableNumL()));
        tableSumDTO.setThirdTableNum(this.covertCount(sumDTO.getThirdTableNumL()));
        return tableSumDTO;
    }

    public String covertCount(Long count) {
        if (count > 9999L) {
            return "9999+";
        }
        return String.valueOf(count);
    }

    public void cancelApproval(ApiRequest<Void> request) {
        long dataId = request.getDataId();
        Assert.isTrue((dataId != -1L ? 1 : 0) != 0, (String)"\u5ba1\u6279\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        PsCauseDeptSupplyPriceApproval psCauseDeptSupplyPriceApproval = (PsCauseDeptSupplyPriceApproval)this.psCauseDeptSupplyPriceApprovalService.getById((Serializable)Long.valueOf(dataId));
        Assert.notNull((Object)psCauseDeptSupplyPriceApproval, (String)"\u5ba1\u6279\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue().equals(psCauseDeptSupplyPriceApproval.getStatus()), (String)"\u5ba1\u6279\u5355\u4e0d\u662f\u5ba1\u6838\u4e2d\u72b6\u6001");
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse apiResponse = this.oaAdapter.terminateWorkFlow(psCauseDeptSupplyPriceApproval.getOaId(), JSON.toJSONString((Object)user));
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        psCauseDeptSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.TO_SUBMIT.getValue());
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psCauseDeptSupplyPriceApproval);
        this.psCauseDeptSupplyPriceApprovalService.updateById((Object)psCauseDeptSupplyPriceApproval);
        InnerLog.addLog((Long)psCauseDeptSupplyPriceApproval.getId(), (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u64a4\u9500", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(psCauseDeptSupplyPriceApproval.getType()) ? InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CAUSE_DEPT_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4e8b\u4e1a\u90e8\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u64a4\u9500");
    }
}

