/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.cus.model.dto.customer.CustomerQueryInfoDTO;
import com.xinqiyi.cus.vo.CustomerVO;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.datapermission.util.DataPermissionUtil;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.PsBasicsBatchVO;
import com.xinqiyi.ps.dao.repository.PsCauseDeptSkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.PsCustomerApprovalService;
import com.xinqiyi.ps.dao.repository.PsCustomerApprovalSkuService;
import com.xinqiyi.ps.dao.repository.PsCustomerSkuSupplyPriceLogService;
import com.xinqiyi.ps.dao.repository.PsCustomerSkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.PsCustomerSupplyPriceApprovalService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.model.dto.enums.CustomerSupplyPriceEnum;
import com.xinqiyi.ps.model.dto.enums.InnerLogTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SkuSupplyPriceStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SkuSupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.supplyprice.HistoryDTO;
import com.xinqiyi.ps.model.dto.supplyprice.PostponeDTO;
import com.xinqiyi.ps.model.dto.supplyprice.PsCustomerSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.supplyprice.PsCustomerSkuSupplyPriceLogDTO;
import com.xinqiyi.ps.model.dto.supplyprice.PsCustomerSkuSupplyPriceQueryDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SaveCustomerSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SupplyPriceApprovalCheckDTO;
import com.xinqiyi.ps.model.entity.PsCauseDeptSkuSupplyPrice;
import com.xinqiyi.ps.model.entity.PsCustomerApproval;
import com.xinqiyi.ps.model.entity.PsCustomerApprovalSku;
import com.xinqiyi.ps.model.entity.PsCustomerSkuSupplyPrice;
import com.xinqiyi.ps.model.entity.PsCustomerSkuSupplyPriceLog;
import com.xinqiyi.ps.model.entity.PsCustomerSupplyPriceApproval;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.model.entity.SkuSupplyPrice;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.business.PsCustomerSupplyPriceApprovalBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.business.SpuBiz;
import com.xinqiyi.ps.service.business.SystemConfigBiz;
import com.xinqiyi.ps.service.mq.MqCallBack;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.ParameterColumnHandler;
import com.xinqiyi.ps.service.util.PsRedisLockUtil;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageCostVo;
import jakarta.annotation.Resource;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsCustomerSkuSupplyPriceBiz
implements MqCallBack {
    private static final Logger log = LoggerFactory.getLogger(PsCustomerSkuSupplyPriceBiz.class);
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private PsCustomerSkuSupplyPriceService psCustomerSkuSupplyPriceService;
    @Autowired
    private PsCustomerSupplyPriceApprovalService psCustomerSupplyPriceApprovalService;
    @Autowired
    private PsCustomerApprovalService psCustomerApprovalService;
    @Autowired
    private PsCustomerApprovalSkuService psCustomerApprovalSkuService;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private CusAdapter cusAdapter;
    @Autowired
    private SkuService skuService;
    @Autowired
    private SkuBarCodeService skuBarCodeService;
    @Autowired
    private SpuService spuService;
    @Autowired
    private PsCustomerSkuSupplyPriceLogService psCustomerSkuSupplyPriceLogService;
    @Autowired
    private SgStorageQueryAdapter sgStorageQueryAdapter;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private PsCustomerSupplyPriceApprovalBiz psCustomerSupplyPriceApprovalBiz;
    @Autowired
    private PsCauseDeptSkuSupplyPriceService psCauseDeptSkuSupplyPriceService;
    @Autowired
    private SkuSupplyPriceService skuSupplyPriceService;
    @Autowired
    private SpuBiz spuBiz;
    @Resource
    private SystemConfigBiz configBiz;

    @Override
    @LogAnnotation
    public void oaCallback(String processInstanceId, String result, String status) {
        PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval = (PsCustomerSupplyPriceApproval)this.psCustomerSupplyPriceApprovalService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCustomerSupplyPriceApproval::getOaId, (Object)processInstanceId)).eq(PsCustomerSupplyPriceApproval::getStatus, (Object)CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue()));
        if (psCustomerSupplyPriceApproval == null) {
            return;
        }
        ArrayList<PsCustomerSkuSupplyPrice> psCustomerSkuSupplyPrices = new ArrayList<PsCustomerSkuSupplyPrice>();
        ArrayList<PsCustomerSkuSupplyPrice> removeCustomerSkuSupplyPrices = new ArrayList<PsCustomerSkuSupplyPrice>();
        ArrayList<PsCustomerSkuSupplyPriceLog> psCustomerSkuSupplyPriceLogs = new ArrayList<PsCustomerSkuSupplyPriceLog>();
        if (StringUtils.equalsIgnoreCase((CharSequence)"agree", (CharSequence)result)) {
            psCustomerSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL.getValue());
            psCustomerSupplyPriceApproval.setAuditTime(new Date());
            List psCustomerApprovalList = this.psCustomerApprovalService.list((Wrapper)new QueryWrapper().lambda().eq(PsCustomerApproval::getPsCustomerSupplyPriceApprovalId, (Object)psCustomerSupplyPriceApproval.getId()));
            List cusCustomerId = psCustomerApprovalList.stream().map(PsCustomerApproval::getCusCustomerId).collect(Collectors.toList());
            List psCustomerApprovalSkuList = this.psCustomerApprovalSkuService.list((Wrapper)new QueryWrapper().lambda().eq(PsCustomerApprovalSku::getPsCustomerSupplyPriceApprovalId, (Object)psCustomerSupplyPriceApproval.getId()));
            Date date = new Date();
            for (PsCustomerApprovalSku psCustomerApprovalSku : psCustomerApprovalSkuList) {
                List psCustomerSkuSupplyPriceList = new ArrayList();
                String priceStatus = null;
                if (date.getTime() >= psCustomerApprovalSku.getEffectiveTime().getTime() && date.getTime() <= psCustomerApprovalSku.getInvalidTime().getTime()) {
                    priceStatus = CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue();
                    psCustomerSkuSupplyPriceList = this.psCustomerSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCustomerSkuSupplyPrice::getPsSkuId, (Object)psCustomerApprovalSku.getPsSkuId())).eq(PsCustomerSkuSupplyPrice::getType, (Object)psCustomerSupplyPriceApproval.getType())).in(PsCustomerSkuSupplyPrice::getCusCustomerId, cusCustomerId)).le(PsCustomerSkuSupplyPrice::getEffectiveTime, (Object)psCustomerApprovalSku.getInvalidTime())).ge(PsCustomerSkuSupplyPrice::getInvalidTime, (Object)psCustomerApprovalSku.getEffectiveTime())).eq(PsCustomerSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue()));
                } else if (date.getTime() < psCustomerApprovalSku.getEffectiveTime().getTime()) {
                    priceStatus = CustomerSupplyPriceEnum.SupplyPriceStatusEnum.TO_BE_EFFECTIVE.getValue();
                } else if (date.getTime() > psCustomerApprovalSku.getInvalidTime().getTime()) {
                    priceStatus = CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue();
                }
                for (Long id : cusCustomerId) {
                    if (CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue().equals(priceStatus)) {
                        PsCustomerSkuSupplyPriceLog psCustomerSkuSupplyPriceLog = new PsCustomerSkuSupplyPriceLog();
                        psCustomerSkuSupplyPriceLog.setCusCustomerId(id);
                        psCustomerSkuSupplyPriceLog.setPsCustomerSupplyPriceApprovalId(psCustomerSupplyPriceApproval.getId());
                        psCustomerSkuSupplyPriceLog.setSupplyPrice(psCustomerApprovalSku.getSupplyPrice());
                        psCustomerSkuSupplyPriceLog.setEffectiveTime(psCustomerApprovalSku.getEffectiveTime());
                        psCustomerSkuSupplyPriceLog.setInvalidTime(psCustomerApprovalSku.getInvalidTime());
                        psCustomerSkuSupplyPriceLog.setPsSkuId(psCustomerApprovalSku.getPsSkuId());
                        psCustomerSkuSupplyPriceLog.setRemark(psCustomerApprovalSku.getRemark());
                        psCustomerSkuSupplyPriceLog.setStatus(priceStatus);
                        psCustomerSkuSupplyPriceLog.setFailureTime(new Date());
                        psCustomerSkuSupplyPriceLog.setFreightCost(psCustomerApprovalSku.getFreightCost());
                        psCustomerSkuSupplyPriceLog.setType(psCustomerSupplyPriceApproval.getType());
                        psCustomerSkuSupplyPriceLog.setId(this.idSequence.generateId(PsCustomerSkuSupplyPriceLog.class));
                        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCustomerSkuSupplyPriceLog);
                        psCustomerSkuSupplyPriceLog.setCreateUserName(psCustomerApprovalSku.getCreateUserName());
                        psCustomerSkuSupplyPriceLogs.add(psCustomerSkuSupplyPriceLog);
                        continue;
                    }
                    PsCustomerSkuSupplyPrice psCustomerSkuSupplyPrice = new PsCustomerSkuSupplyPrice();
                    psCustomerSkuSupplyPrice.setId(this.idSequence.generateId(PsCustomerSkuSupplyPrice.class));
                    psCustomerSkuSupplyPrice.setCusCustomerId(id);
                    psCustomerSkuSupplyPrice.setPsCustomerSupplyPriceApprovalId(psCustomerSupplyPriceApproval.getId());
                    psCustomerSkuSupplyPrice.setSupplyPrice(psCustomerApprovalSku.getSupplyPrice());
                    psCustomerSkuSupplyPrice.setEffectiveTime(psCustomerApprovalSku.getEffectiveTime());
                    psCustomerSkuSupplyPrice.setInvalidTime(psCustomerApprovalSku.getInvalidTime());
                    psCustomerSkuSupplyPrice.setPsSkuId(psCustomerApprovalSku.getPsSkuId());
                    psCustomerSkuSupplyPrice.setRemark(psCustomerApprovalSku.getRemark());
                    psCustomerSkuSupplyPrice.setStatus(priceStatus);
                    psCustomerSkuSupplyPrice.setFreightCost(psCustomerApprovalSku.getFreightCost());
                    psCustomerSkuSupplyPrice.setType(psCustomerSupplyPriceApproval.getType());
                    this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCustomerSkuSupplyPrice);
                    psCustomerSkuSupplyPrice.setCreateUserName(psCustomerSupplyPriceApproval.getCreateUserName());
                    psCustomerSkuSupplyPrices.add(psCustomerSkuSupplyPrice);
                    PsCustomerSkuSupplyPrice skuSupplyPrice = psCustomerSkuSupplyPriceList.stream().filter(s -> s.getCusCustomerId().equals(id)).findAny().orElse(null);
                    this.getCustomerSupplyLogs(psCustomerSkuSupplyPriceLogs, removeCustomerSkuSupplyPrices, skuSupplyPrice);
                }
            }
            InnerLog.addLog((Long)psCustomerSupplyPriceApproval.getId(), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6838\u901a\u8fc7", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(psCustomerSupplyPriceApproval.getType()) ? InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6838\u901a\u8fc7");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"cancel", (CharSequence)result)) {
            psCustomerSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.TO_SUBMIT.getValue());
            InnerLog.addLog((Long)psCustomerSupplyPriceApproval.getId(), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6838\u64a4\u9500", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(psCustomerSupplyPriceApproval.getType()) ? InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6838\u64a4\u9500");
        } else {
            psCustomerSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_REJECT.getValue());
            InnerLog.addLog((Long)psCustomerSupplyPriceApproval.getId(), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6838\u62d2\u7edd", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(psCustomerSupplyPriceApproval.getType()) ? InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6838\u62d2\u7edd");
        }
        this.psCustomerSupplyPriceApprovalService.updateBatch(psCustomerSupplyPriceApproval, psCustomerSkuSupplyPrices, removeCustomerSkuSupplyPrices, psCustomerSkuSupplyPriceLogs);
        List skuIdList = psCustomerSkuSupplyPriceLogs.stream().map(PsCustomerSkuSupplyPriceLog::getPsSkuId).collect(Collectors.toList());
        List skuId = psCustomerSkuSupplyPrices.stream().map(PsCustomerSkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
        ArrayList skuIdArrList = CollUtil.newArrayList((Object[])new Long[0]);
        skuIdArrList.addAll(skuIdList);
        skuIdArrList.addAll(skuId);
        if (CollUtil.isNotEmpty((Collection)skuIdArrList)) {
            List skuList = this.skuService.listByIds((Collection)skuIdArrList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    public void supplyPriceFailure() {
        Date date = new Date();
        List psCustomerSkuSupplyPriceList = this.psCustomerSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCustomerSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue())).le(PsCustomerSkuSupplyPrice::getInvalidTime, (Object)date));
        if (CollUtil.isEmpty((Collection)psCustomerSkuSupplyPriceList)) {
            return;
        }
        ArrayList<PsCustomerSkuSupplyPriceLog> psCustomerSkuSupplyPriceLogs = new ArrayList<PsCustomerSkuSupplyPriceLog>();
        for (PsCustomerSkuSupplyPrice skuSupplyPrice : psCustomerSkuSupplyPriceList) {
            skuSupplyPrice.setStatus(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue());
            PsCustomerSkuSupplyPriceLog psCustomerSkuSupplyPriceLog = new PsCustomerSkuSupplyPriceLog();
            BeanConvertUtil.copyProperties(skuSupplyPrice, psCustomerSkuSupplyPriceLog);
            psCustomerSkuSupplyPriceLog.setFailureTime(skuSupplyPrice.getInvalidTime());
            psCustomerSkuSupplyPriceLog.setId(this.idSequence.generateId(PsCustomerSkuSupplyPriceLog.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCustomerSkuSupplyPriceLog);
            psCustomerSkuSupplyPriceLogs.add(psCustomerSkuSupplyPriceLog);
        }
        this.psCustomerSupplyPriceApprovalService.updateBatch(null, null, psCustomerSkuSupplyPriceList, psCustomerSkuSupplyPriceLogs);
        List skuIdList = psCustomerSkuSupplyPriceLogs.stream().map(PsCustomerSkuSupplyPriceLog::getPsSkuId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(skuIdList)) {
            List skuList = this.skuService.listByIds(skuIdList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    public void supplyPriceEffect() {
        Date date = new Date();
        List psCustomerSkuSupplyPriceList = this.psCustomerSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCustomerSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.TO_BE_EFFECTIVE.getValue())).le(PsCustomerSkuSupplyPrice::getEffectiveTime, (Object)date)).ge(PsCustomerSkuSupplyPrice::getInvalidTime, (Object)date));
        if (CollUtil.isEmpty((Collection)psCustomerSkuSupplyPriceList)) {
            return;
        }
        ArrayList<PsCustomerSkuSupplyPriceLog> psCustomerSkuSupplyPriceLogs = new ArrayList<PsCustomerSkuSupplyPriceLog>();
        ArrayList<PsCustomerSkuSupplyPrice> removeCustomerSkuSupplyPrices = new ArrayList<PsCustomerSkuSupplyPrice>();
        for (PsCustomerSkuSupplyPrice skuSupplyPrice : psCustomerSkuSupplyPriceList) {
            PsCustomerSkuSupplyPrice customerSkuSupplyPrice = (PsCustomerSkuSupplyPrice)this.psCustomerSkuSupplyPriceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCustomerSkuSupplyPrice::getPsSkuId, (Object)skuSupplyPrice.getPsSkuId())).eq(PsCustomerSkuSupplyPrice::getCusCustomerId, (Object)skuSupplyPrice.getCusCustomerId())).eq(PsCustomerSkuSupplyPrice::getType, (Object)skuSupplyPrice.getType())).le(PsCustomerSkuSupplyPrice::getEffectiveTime, (Object)skuSupplyPrice.getInvalidTime())).ge(PsCustomerSkuSupplyPrice::getInvalidTime, (Object)skuSupplyPrice.getEffectiveTime())).eq(PsCustomerSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue()));
            skuSupplyPrice.setStatus(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue());
            this.getCustomerSupplyLogs(psCustomerSkuSupplyPriceLogs, removeCustomerSkuSupplyPrices, customerSkuSupplyPrice);
        }
        this.psCustomerSupplyPriceApprovalService.updateBatch(null, psCustomerSkuSupplyPriceList, removeCustomerSkuSupplyPrices, psCustomerSkuSupplyPriceLogs);
        List skuIdList = psCustomerSkuSupplyPriceLogs.stream().map(PsCustomerSkuSupplyPriceLog::getPsSkuId).collect(Collectors.toList());
        List skuId = psCustomerSkuSupplyPriceList.stream().map(PsCustomerSkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
        ArrayList skuIdArrList = CollUtil.newArrayList((Object[])new Long[0]);
        skuIdArrList.addAll(skuIdList);
        skuIdArrList.addAll(skuId);
        if (CollUtil.isNotEmpty((Collection)skuIdArrList)) {
            List skuList = this.skuService.listByIds((Collection)skuIdArrList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    private void getCustomerSupplyLogs(List<PsCustomerSkuSupplyPriceLog> psCustomerSkuSupplyPriceLogs, List<PsCustomerSkuSupplyPrice> removeCustomerSkuSupplyPrices, PsCustomerSkuSupplyPrice customerSkuSupplyPrice) {
        if (customerSkuSupplyPrice != null) {
            customerSkuSupplyPrice.setStatus(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue());
            removeCustomerSkuSupplyPrices.add(customerSkuSupplyPrice);
            PsCustomerSkuSupplyPriceLog psCustomerSkuSupplyPriceLog = new PsCustomerSkuSupplyPriceLog();
            psCustomerSkuSupplyPriceLog.setEffectiveTime(customerSkuSupplyPrice.getEffectiveTime());
            psCustomerSkuSupplyPriceLog.setInvalidTime(customerSkuSupplyPrice.getInvalidTime());
            psCustomerSkuSupplyPriceLog.setCusCustomerId(customerSkuSupplyPrice.getCusCustomerId());
            psCustomerSkuSupplyPriceLog.setPsCustomerSupplyPriceApprovalId(customerSkuSupplyPrice.getPsCustomerSupplyPriceApprovalId());
            psCustomerSkuSupplyPriceLog.setRemark(customerSkuSupplyPrice.getRemark());
            psCustomerSkuSupplyPriceLog.setStatus(customerSkuSupplyPrice.getStatus());
            psCustomerSkuSupplyPriceLog.setSupplyPrice(customerSkuSupplyPrice.getSupplyPrice());
            psCustomerSkuSupplyPriceLog.setPsSkuId(customerSkuSupplyPrice.getPsSkuId());
            psCustomerSkuSupplyPriceLog.setFailureTime(new Date());
            psCustomerSkuSupplyPriceLog.setFreightCost(customerSkuSupplyPrice.getFreightCost());
            psCustomerSkuSupplyPriceLog.setId(this.idSequence.generateId(PsCustomerSkuSupplyPriceLog.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCustomerSkuSupplyPriceLog);
            psCustomerSkuSupplyPriceLog.setType(customerSkuSupplyPrice.getType());
            psCustomerSkuSupplyPriceLog.setCreateUserName(customerSkuSupplyPrice.getCreateUserName());
            psCustomerSkuSupplyPriceLogs.add(psCustomerSkuSupplyPriceLog);
        }
    }

    public void supplyPriceInvalid(ApiRequest<List<Long>> request) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)((Collection)request.getJsonData())), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7id\u4e0d\u80fd\u4e3a\u7a7a");
        List psCustomerSkuSupplyPriceList = this.psCustomerSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().ne(PsCustomerSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue())).in(BaseDo::getId, (Collection)request.getJsonData()));
        ArrayList<PsCustomerSkuSupplyPriceLog> psCustomerSkuSupplyPriceLogs = new ArrayList<PsCustomerSkuSupplyPriceLog>();
        ArrayList<PsCustomerSkuSupplyPrice> removeCustomerSkuSupplyPrices = new ArrayList<PsCustomerSkuSupplyPrice>();
        for (PsCustomerSkuSupplyPrice customerSkuSupplyPrice : psCustomerSkuSupplyPriceList) {
            this.getCustomerSupplyLogs(psCustomerSkuSupplyPriceLogs, removeCustomerSkuSupplyPrices, customerSkuSupplyPrice);
        }
        this.psCustomerSupplyPriceApprovalService.updateBatch(null, null, removeCustomerSkuSupplyPrices, psCustomerSkuSupplyPriceLogs);
        List skuIdList = psCustomerSkuSupplyPriceLogs.stream().map(PsCustomerSkuSupplyPriceLog::getPsSkuId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(skuIdList)) {
            List skuList = this.skuService.listByIds(skuIdList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    private void covertDeptPermission(SpuQueryDTO queryDTO) {
        String notMdmCauseDeptChildId;
        Map mdmCauseDeptChildMap;
        String mdmCauseDeptChildId;
        String notMdmCauseDeptId;
        LoginUserInfo loginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Map mdmCauseDeptIdMap = DataPermissionUtil.getPermissionDataIdMap((Long)loginUserInfo.getUserId(), (String)"mdm_cause_dept");
        String mdmCauseDeptId = (String)mdmCauseDeptIdMap.get("PERMISSION");
        if (StrUtil.equals((CharSequence)mdmCauseDeptId, (CharSequence)"-9999") || mdmCauseDeptId == null) {
            queryDTO.setCusCustomerIds((List)CollUtil.newArrayList((Object[])new Long[]{-9999L}));
            return;
        }
        String[] mdmCauseDeptIds = mdmCauseDeptId.split(",");
        List mdmCauseDeptIdList = Arrays.stream(mdmCauseDeptIds).filter(CharSequenceUtil::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
        if (CollUtil.isNotEmpty((Collection)queryDTO.getMdmDepartmentIdList())) {
            if (CollUtil.isNotEmpty(mdmCauseDeptIdList)) {
                List ids = queryDTO.getMdmDepartmentIdList().stream().filter(mdmCauseDeptIdList::contains).collect(Collectors.toList());
                if (CollUtil.isEmpty(ids)) {
                    queryDTO.setCusCustomerIds((List)CollUtil.newArrayList((Object[])new Long[]{-9999L}));
                    return;
                }
                queryDTO.setMdmDepartmentIdList(ids);
            }
        } else {
            queryDTO.setMdmDepartmentIdList(mdmCauseDeptIdList);
        }
        if (StrUtil.isNotBlank((CharSequence)(notMdmCauseDeptId = (String)mdmCauseDeptIdMap.get("EXCLUDE_PERMISSION")))) {
            List notMdmCauseDeptIdList = Arrays.stream(notMdmCauseDeptId.split(",")).filter(CharSequenceUtil::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            queryDTO.setNotMdmDepartmentIdList(notMdmCauseDeptIdList);
        }
        if (StrUtil.equals((CharSequence)(mdmCauseDeptChildId = (String)(mdmCauseDeptChildMap = DataPermissionUtil.getPermissionDataIdMap((Long)loginUserInfo.getUserId(), (String)"mdm_cause_dept_child")).get("PERMISSION")), (CharSequence)"-9999") || mdmCauseDeptChildId == null) {
            queryDTO.setCusCustomerIds((List)CollUtil.newArrayList((Object[])new Long[]{-9999L}));
            return;
        }
        if (!StrUtil.equals((CharSequence)mdmCauseDeptChildId, (CharSequence)"-9999")) {
            String[] mdmCauseDeptChildIds = mdmCauseDeptChildId.split(",");
            List mdmCauseDeptChildIdList = Arrays.stream(mdmCauseDeptChildIds).filter(CharSequenceUtil::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            if (CollUtil.isNotEmpty((Collection)queryDTO.getMdmChildDepartmentIdList())) {
                if (CollUtil.isNotEmpty(mdmCauseDeptChildIdList)) {
                    List ids = queryDTO.getMdmChildDepartmentIdList().stream().filter(mdmCauseDeptChildIdList::contains).collect(Collectors.toList());
                    if (CollUtil.isEmpty(ids)) {
                        queryDTO.setCusCustomerIds((List)CollUtil.newArrayList((Object[])new Long[]{-9999L}));
                        return;
                    }
                    queryDTO.setMdmChildDepartmentIdList(ids);
                }
            } else {
                queryDTO.setMdmChildDepartmentIdList(mdmCauseDeptChildIdList);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)(notMdmCauseDeptChildId = (String)mdmCauseDeptChildMap.get("EXCLUDE_PERMISSION")))) {
            List notMdmCauseDeptChildIdList = Arrays.stream(notMdmCauseDeptChildId.split(",")).filter(CharSequenceUtil::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            queryDTO.setNotMdmChildDepartmentIdList(notMdmCauseDeptChildIdList);
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCustomerName()) || StrUtil.isNotBlank((CharSequence)queryDTO.getCustomerCode()) || queryDTO.getMdmDepartmentId() != null || queryDTO.getMdmChildDepartmentId() != null || CollUtil.isNotEmpty((Collection)queryDTO.getMdmDepartmentIdList()) || CollUtil.isNotEmpty((Collection)queryDTO.getMdmChildDepartmentIdList()) || CollUtil.isNotEmpty((Collection)queryDTO.getNotMdmChildDepartmentIdList()) || CollUtil.isNotEmpty((Collection)queryDTO.getNotMdmDepartmentIdList())) {
            CustomerQueryInfoDTO customerQueryInfoDTO = new CustomerQueryInfoDTO();
            customerQueryInfoDTO.setCusCustomerCode(queryDTO.getCustomerCode());
            customerQueryInfoDTO.setCusCustomerName(queryDTO.getCustomerName());
            customerQueryInfoDTO.setMdmChildDepartmentId(queryDTO.getMdmChildDepartmentId());
            customerQueryInfoDTO.setMdmDepartmentId(queryDTO.getMdmDepartmentId());
            customerQueryInfoDTO.setMdmDepartmentIdList(queryDTO.getMdmDepartmentIdList());
            customerQueryInfoDTO.setMdmChildDepartmentIdList(queryDTO.getMdmChildDepartmentIdList());
            customerQueryInfoDTO.setMdmDepartmentIdListNotIn(queryDTO.getNotMdmDepartmentIdList());
            customerQueryInfoDTO.setMdmChildDepartmentIdListNotIn(queryDTO.getNotMdmChildDepartmentIdList());
            List<CustomerVO> customerVOS = this.cusAdapter.queryCustomerByOtherCondition(customerQueryInfoDTO);
            if (CollUtil.isEmpty(customerVOS)) {
                queryDTO.setCusCustomerIds((List)CollUtil.newArrayList((Object[])new Long[]{-9999L}));
                return;
            }
            List cusIds = customerVOS.stream().map(CustomerVO::getId).collect(Collectors.toList());
            queryDTO.setCusCustomerIds(cusIds);
        }
    }

    public Page<PsCustomerSkuSupplyPriceDTO> selectPage(ApiRequest<SpuQueryDTO> request) {
        List list;
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        LoginUserInfo loginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        this.covertDeptPermission(queryDTO);
        Page page = null;
        page = Integer.valueOf(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.LOST_EFFICACY.getValue()).equals(queryDTO.getStatus()) ? this.psCustomerSkuSupplyPriceLogService.selectPage(queryDTO) : this.psCustomerSkuSupplyPriceService.selectPage(queryDTO);
        List records = page.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
        }
        boolean isCostPrice = true;
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse<Map<String, List<String>>> mapApiResponse = this.scAdapter.selectSensitiveColumnByUserId(user.getUserId());
        Assert.isTrue((boolean)mapApiResponse.isSuccess(), (String)mapApiResponse.getDesc());
        Map map = (Map)mapApiResponse.getContent();
        if (map.containsKey("ps_customer_sku_supply_price") && (list = (List)map.get("ps_customer_sku_supply_price")).contains("sg_cost_price")) {
            isCostPrice = false;
        }
        List cusCustomerIds = records.stream().map(PsCustomerSkuSupplyPriceDTO::getCusCustomerId).collect(Collectors.toList());
        CustomerQueryInfoDTO customerQueryInfoDTO = new CustomerQueryInfoDTO();
        customerQueryInfoDTO.setCusCustomerIds(cusCustomerIds);
        List<CustomerVO> customerVOS = this.cusAdapter.queryCustomerByOtherCondition(customerQueryInfoDTO);
        List skuIds = records.stream().map(PsCustomerSkuSupplyPriceDTO::getPsSkuId).collect(Collectors.toList());
        List skuList = this.skuService.listByIds(skuIds);
        List<String> skuCodeList = skuList.stream().map(Sku::getCode).collect(Collectors.toList());
        List spuIds = skuList.stream().map(Sku::getPsSpuId).distinct().collect(Collectors.toList());
        List spuList = this.spuService.listByIds(spuIds);
        List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(skuCodeList);
        String supplyPriceDigits = this.configBiz.getSupplyPriceDigits();
        for (PsCustomerSkuSupplyPriceDTO record : records) {
            Sku sku;
            CustomerVO customerVO;
            List skuBarCodes;
            PsCustomerSkuSupplyPrice customerSkuSupplyPrice;
            if (Integer.valueOf(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.TO_BE_EFFECTIVE.getValue()).equals(queryDTO.getStatus()) && (customerSkuSupplyPrice = (PsCustomerSkuSupplyPrice)this.psCustomerSkuSupplyPriceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCustomerSkuSupplyPrice::getCusCustomerId, (Object)record.getCusCustomerId())).eq(PsCustomerSkuSupplyPrice::getPsSkuId, (Object)record.getPsSkuId())).eq(PsCustomerSkuSupplyPrice::getType, (Object)record.getType())).eq(PsCustomerSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue()))) != null) {
                record.setCurrentSupplyPrice(this.configBiz.getDecimalDigits(customerSkuSupplyPrice.getSupplyPrice(), supplyPriceDigits));
            }
            if (Integer.valueOf(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue()).equals(queryDTO.getStatus())) {
                record.setCurrentSupplyPrice(this.configBiz.getDecimalDigits(record.getSupplyPrice(), supplyPriceDigits));
            }
            if (CollUtil.isNotEmpty(skuBarCodes = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(record.getPsSkuId())).collect(Collectors.toList()))) {
                record.setBarCode(skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(",")));
            }
            if ((customerVO = (CustomerVO)customerVOS.stream().filter(s -> s.getId().equals(record.getCusCustomerId())).findAny().orElse(null)) != null) {
                record.setCustomerCode(customerVO.getCustomerCode());
                record.setCustomerName(customerVO.getCustomerName());
                record.setMdmChildDepartmentName(customerVO.getMdmCauseDeptName());
                record.setMdmDepartmentName(customerVO.getMdmDepartmentName());
            }
            if ((sku = (Sku)skuList.stream().filter(s -> s.getId().equals(record.getPsSkuId())).findAny().orElse(null)) != null) {
                record.setSkuCode(sku.getCode());
                record.setSkuName(sku.getName());
                record.setKyThirdPlatformCode(sku.getKyThirdPlatformCode());
                record.setWmsThirdPlatformCode(sku.getWmsThirdPlatformCode());
                record.setCounterPrice(this.configBiz.getDecimalDigits(sku.getCostPrice(), supplyPriceDigits));
                Spu spu = spuList.stream().filter(s -> s.getId().equals(sku.getPsSpuId())).findAny().orElse(null);
                if (spu != null) {
                    record.setClassify(spu.getClassify());
                    record.setBrandName(spu.getPsBrandName());
                    record.setSpuStatus(spu.getStatus());
                    record.setSpuCode(spu.getCode());
                    record.setSpuName(spu.getName());
                }
            }
            if (!isCostPrice) continue;
            sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(record.getSkuCode())).findAny().ifPresent(sgBStorageCostVo -> record.setSgCostPrice(sgBStorageCostVo.getPriceCost()));
        }
        return page;
    }

    public String selectTableCount(ApiRequest<SpuQueryDTO> request) {
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        this.covertDeptPermission(queryDTO);
        Long count = this.psCustomerSkuSupplyPriceService.selectTableCount(queryDTO);
        return this.psCustomerSupplyPriceApprovalBiz.covertCount(count);
    }

    public long selectTableCountAndReturnNumber(ApiRequest<SpuQueryDTO> request) {
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        this.covertDeptPermission(queryDTO);
        return this.psCustomerSkuSupplyPriceService.selectTableCount(queryDTO);
    }

    public List<PsCustomerSkuSupplyPriceLogDTO> selectHistoryList(ApiRequest<HistoryDTO> request) {
        HistoryDTO dto = (HistoryDTO)request.getJsonData();
        ParameterColumnHandler.convertParameter(dto, CollUtil.newArrayList((Object[])new String[]{"submitUser", "updateUserName"}), "IsUnion");
        return this.psCustomerSkuSupplyPriceLogService.selectHistoryList(dto);
    }

    public PsBasicsBatchVO updateSupplyPrice(ApiRequest<List<PostponeDTO>> request) {
        List dtoList = (List)request.getJsonData();
        List psCustomerSkuSupplyPriceIdList = dtoList.stream().map(PostponeDTO::getId).collect(Collectors.toList());
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            for (PostponeDTO dto : dtoList) {
                String lockKey = "ps:customer_supply_price:update:" + dto.getId();
                RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u5ba2\u6237\u4f9b\u8d27\u4ef7\u7528\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock);
            }
            List psCustomerSkuSupplyPriceList = this.psCustomerSkuSupplyPriceService.list((Wrapper)new QueryWrapper().lambda().in(BaseDo::getId, psCustomerSkuSupplyPriceIdList));
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)psCustomerSkuSupplyPriceList), (String)"\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            List skuIdList = psCustomerSkuSupplyPriceList.stream().map(PsCustomerSkuSupplyPrice::getPsSkuId).distinct().collect(Collectors.toList());
            List skuList = this.skuService.listByIds(skuIdList);
            PsBasicsBatchVO psBasicsBatchVO = new PsBasicsBatchVO();
            ArrayList errorMessageList = CollUtil.newArrayList((Object[])new PsBasicsBatchVO.ErrorMessage[0]);
            ArrayList psCustomerSkuSupplyPrices = CollUtil.newArrayList((Object[])new PsCustomerSkuSupplyPrice[0]);
            for (PsCustomerSkuSupplyPrice psCustomerSkuSupplyPrice : psCustomerSkuSupplyPriceList) {
                PsBasicsBatchVO.ErrorMessage errorMessage = new PsBasicsBatchVO.ErrorMessage();
                Sku sku = skuList.stream().filter(item -> ObjectUtil.equal((Object)psCustomerSkuSupplyPrice.getPsSkuId(), (Object)item.getId())).findAny().orElse(null);
                if (!StrUtil.equals((CharSequence)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue(), (CharSequence)psCustomerSkuSupplyPrice.getStatus())) {
                    errorMessage.setId(sku.getId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u4f9b\u8d27\u4ef7\u975e\u751f\u6548\u72b6\u6001");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                PostponeDTO postponeDTO = dtoList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)psCustomerSkuSupplyPrice.getId())).findAny().orElse(null);
                if (postponeDTO.getInvalidTime().getTime() < psCustomerSkuSupplyPrice.getEffectiveTime().getTime()) {
                    errorMessage.setId(sku.getId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                if (postponeDTO.getInvalidTime().getTime() > DateUtil.offsetDay((Date)psCustomerSkuSupplyPrice.getInvalidTime(), (int)-1).getTime()) {
                    errorMessage.setId(sku.getId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u4f9b\u8d27\u4ef7\u5931\u6548\u65f6\u95f4\u524d\u4e00\u5929");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                PsCustomerSkuSupplyPrice skuSupplyPrice2 = new PsCustomerSkuSupplyPrice();
                skuSupplyPrice2.setId(psCustomerSkuSupplyPrice.getId());
                skuSupplyPrice2.setInvalidTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)postponeDTO.getInvalidTime(), (String)"yyyy-MM-dd 23:59:59")));
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)skuSupplyPrice2);
                psCustomerSkuSupplyPrices.add(skuSupplyPrice2);
            }
            if (CollUtil.isNotEmpty((Collection)psCustomerSkuSupplyPrices)) {
                this.psCustomerSkuSupplyPriceService.updateBatchById((Collection)psCustomerSkuSupplyPrices);
            }
            for (PsCustomerSkuSupplyPrice customerSkuSupplyPrice : psCustomerSkuSupplyPrices) {
                psCustomerSkuSupplyPriceList.stream().filter(item -> item.getId().equals(customerSkuSupplyPrice.getId())).findAny().ifPresent(skuSupplyPrice -> InnerLog.addLog((Long)customerSkuSupplyPrice.getId(), (String)"\u8c03\u6574\u4f9b\u8d27\u4ef7\u65e5\u671f", (String)InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE.getCode(), null, (String)("\u539f\u5931\u6548\u65e5\u671f" + DateUtil.formatChineseDate((Date)skuSupplyPrice.getInvalidTime(), (boolean)false, (boolean)true) + "\u8c03\u6574\u4e3a" + DateUtil.formatChineseDate((Date)customerSkuSupplyPrice.getInvalidTime(), (boolean)false, (boolean)true))));
            }
            if (CollUtil.isNotEmpty((Collection)errorMessageList)) {
                PsCustomerSkuSupplyPrice customerSkuSupplyPrice;
                List ids = errorMessageList.stream().map(PsBasicsBatchVO.ErrorMessage::getId).collect(Collectors.toList());
                psBasicsBatchVO.setErrorIds(ids);
                psBasicsBatchVO.setErrorTotal(Integer.valueOf(ids.size()));
                psBasicsBatchVO.setSuccessTotal(Integer.valueOf(psCustomerSkuSupplyPrices.size()));
                psBasicsBatchVO.setTotal(Integer.valueOf(ids.size()));
                psBasicsBatchVO.setErrorMessageList((List)errorMessageList);
                customerSkuSupplyPrice = psBasicsBatchVO;
                return customerSkuSupplyPrice;
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("Invoice.FcOutputInvoiceBiz.billingInvoice Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    public List<SupplyPriceApprovalCheckDTO> postpone(ApiRequest<List<PostponeDTO>> request) {
        PostponeDTO postponeDTO;
        List postponeDTOS = (List)request.getJsonData();
        List psCustomerSkuSupplyPriceIdList = postponeDTOS.stream().map(PostponeDTO::getId).collect(Collectors.toList());
        List psCustomerSkuSupplyPriceList = this.psCustomerSkuSupplyPriceService.list((Wrapper)new QueryWrapper().lambda().in(BaseDo::getId, psCustomerSkuSupplyPriceIdList));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)psCustomerSkuSupplyPriceList), (String)"\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        List<Long> skuIdList = psCustomerSkuSupplyPriceList.stream().map(PsCustomerSkuSupplyPrice::getPsSkuId).distinct().collect(Collectors.toList());
        List skuList = this.skuService.listByIds(skuIdList);
        List psCustomerSkuSupplyPrices = psCustomerSkuSupplyPriceList.stream().filter(item -> !item.getStatus().equals(CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(psCustomerSkuSupplyPrices)) {
            List skuIdLongList = psCustomerSkuSupplyPrices.stream().map(PsCustomerSkuSupplyPrice::getPsSkuId).distinct().collect(Collectors.toList());
            List skuNameList = skuList.stream().filter(item -> skuIdLongList.contains(item.getId())).map(Sku::getName).collect(Collectors.toList());
            throw new IllegalArgumentException(String.valueOf(skuNameList) + "\u4f9b\u8d27\u4ef7\u4e0d\u662f\u5df2\u751f\u6548\u72b6\u6001");
        }
        List<Long> cusCustomerIdList = psCustomerSkuSupplyPriceList.stream().map(PsCustomerSkuSupplyPrice::getCusCustomerId).collect(Collectors.toList());
        ArrayList customerSkuSupplyPriceList = CollUtil.newArrayList((Object[])new SaveCustomerSkuSupplyPriceDTO[0]);
        for (Object customerSkuSupplyPrice : psCustomerSkuSupplyPriceList) {
            SaveCustomerSkuSupplyPriceDTO saveCustomerSkuSupplyPriceDTO = new SaveCustomerSkuSupplyPriceDTO();
            postponeDTO = postponeDTOS.stream().filter(arg_0 -> PsCustomerSkuSupplyPriceBiz.lambda$postpone$13((PsCustomerSkuSupplyPrice)customerSkuSupplyPrice, arg_0)).findAny().orElse(null);
            if (postponeDTO != null) {
                Assert.isTrue((postponeDTO.getInvalidTime().getTime() > customerSkuSupplyPrice.getInvalidTime().getTime() ? 1 : 0) != 0, (String)"\u5ef6\u7eed\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4");
                saveCustomerSkuSupplyPriceDTO.setInvalidTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)postponeDTO.getInvalidTime(), (String)"yyyy-MM-dd 00:00:00")));
                saveCustomerSkuSupplyPriceDTO.setPsSkuId(customerSkuSupplyPrice.getPsSkuId());
                saveCustomerSkuSupplyPriceDTO.setEffectiveTime((Date)DateUtil.offsetSecond((Date)customerSkuSupplyPrice.getInvalidTime(), (int)1));
            }
            customerSkuSupplyPriceList.add(saveCustomerSkuSupplyPriceDTO);
        }
        ArrayList skuSupplyPrices = CollUtil.newArrayList((Object[])new PsCustomerSkuSupplyPrice[0]);
        for (PsCustomerSkuSupplyPrice customerSkuSupplyPrice : psCustomerSkuSupplyPriceList) {
            postponeDTO = postponeDTOS.stream().filter(item -> item.getId().equals(customerSkuSupplyPrice.getId())).findAny().orElse(null);
            if (postponeDTO == null) continue;
            PsCustomerSkuSupplyPrice skuSupplyPrice2 = new PsCustomerSkuSupplyPrice();
            skuSupplyPrice2.setId(customerSkuSupplyPrice.getId());
            skuSupplyPrice2.setInvalidTime(customerSkuSupplyPrice.getInvalidTime());
            skuSupplyPrices.add(skuSupplyPrice2);
            customerSkuSupplyPrice.setInvalidTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)postponeDTO.getInvalidTime(), (String)"yyyy-MM-dd 23:59:59")));
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)customerSkuSupplyPrice);
        }
        List<SupplyPriceApprovalCheckDTO> supplyPriceApprovalCheckDTOS = this.psCustomerSupplyPriceApprovalBiz.checkSupplyPriceValidity(cusCustomerIdList, ((PsCustomerSkuSupplyPrice)psCustomerSkuSupplyPriceList.get(0)).getType(), skuIdList, skuList, CollUtil.newArrayList((Object[])new CustomerVO[0]), null, customerSkuSupplyPriceList, psCustomerSkuSupplyPriceList);
        if (CollUtil.isNotEmpty(supplyPriceApprovalCheckDTOS)) {
            return supplyPriceApprovalCheckDTOS;
        }
        this.psCustomerSkuSupplyPriceService.updateBatchById((Collection)psCustomerSkuSupplyPriceList);
        for (PsCustomerSkuSupplyPrice customerSkuSupplyPrice : psCustomerSkuSupplyPriceList) {
            skuSupplyPrices.stream().filter(item -> item.getId().equals(customerSkuSupplyPrice.getId())).findAny().ifPresent(skuSupplyPrice -> InnerLog.addLog((Long)customerSkuSupplyPrice.getId(), (String)"\u5ef6\u7eed\u4f9b\u8d27\u4ef7\u65e5\u671f", (String)InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE.getCode(), null, (String)("\u539f\u5931\u6548\u65e5\u671f" + DateUtil.formatChineseDate((Date)skuSupplyPrice.getInvalidTime(), (boolean)false, (boolean)true) + "\u5ef6\u671f\u4e3a" + DateUtil.formatChineseDate((Date)customerSkuSupplyPrice.getInvalidTime(), (boolean)false, (boolean)true))));
        }
        return CollUtil.newArrayList((Object[])new SupplyPriceApprovalCheckDTO[0]);
    }

    public List<PsCustomerSkuSupplyPriceQueryDTO> selectCustomerSkuSupplyPriceList(ApiRequest<SpuQueryDTO> request) {
        SpuQueryDTO dto = (SpuQueryDTO)request.getJsonData();
        List skuList = this.skuService.listByIds((Collection)dto.getSkuIdList());
        List psCustomerSkuSupplyPriceList = this.psCustomerSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCustomerSkuSupplyPrice::getCusCustomerId, (Object)dto.getCusCustomerId())).eq(PsCustomerSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue())).eq(PsCustomerSkuSupplyPrice::getType, (Object)dto.getSupplyPriceType())).in(PsCustomerSkuSupplyPrice::getPsSkuId, (Collection)dto.getSkuIdList()));
        List psCauseDeptSkuSupplyPriceList = this.psCauseDeptSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCauseDeptSkuSupplyPrice::getMdmCauseDeptId, (Object)dto.getMdmDeptId())).eq(PsCauseDeptSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.EXECUTED.getValue())).eq(PsCauseDeptSkuSupplyPrice::getType, (Object)dto.getSupplyPriceType())).in(PsCauseDeptSkuSupplyPrice::getPsSkuId, (Collection)dto.getSkuIdList()));
        Date date = new Date();
        List skuSupplyPriceList = this.skuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().le(SkuSupplyPrice::getEffectiveTime, (Object)date)).ge(SkuSupplyPrice::getInvalidTime, (Object)date)).eq(SkuSupplyPrice::getStatus, (Object)SkuSupplyPriceStatusEnums.IN_FORCE.getCode())).eq(SkuSupplyPrice::getType, (Object)dto.getSupplyPriceType())).in(SkuSupplyPrice::getPsSkuId, (Collection)dto.getSkuIdList())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        DateTime invalidTime = DateUtil.beginOfDay((Date)DateUtil.offsetDay((Date)date, (int)(-dto.getInvalidDay().intValue())));
        List psCustomerSkuSupplyPriceLogs = this.psCustomerSkuSupplyPriceLogService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsCustomerSkuSupplyPriceLog::getType, (Object)dto.getSupplyPriceType())).eq(PsCustomerSkuSupplyPriceLog::getCusCustomerId, (Object)dto.getCusCustomerId())).gt(PsCustomerSkuSupplyPriceLog::getFailureTime, (Object)invalidTime)).lt(PsCustomerSkuSupplyPriceLog::getFailureTime, (Object)date)).in(PsCustomerSkuSupplyPriceLog::getPsSkuId, (Collection)dto.getSkuIdList()));
        ArrayList dtoList = CollUtil.newArrayList((Object[])new PsCustomerSkuSupplyPriceQueryDTO[0]);
        for (Sku sku : skuList) {
            PsCustomerSkuSupplyPriceQueryDTO psCustomerSkuSupplyPriceQueryDTO = new PsCustomerSkuSupplyPriceQueryDTO();
            psCustomerSkuSupplyPriceQueryDTO.setCounterPrice(sku.getCounterPrice());
            psCustomerSkuSupplyPriceQueryDTO.setSkuId(sku.getId());
            psCustomerSkuSupplyPriceQueryDTO.setSkuCode(sku.getCode());
            psCustomerSkuSupplyPriceQueryDTO.setSkuName(sku.getName());
            PsCustomerSkuSupplyPrice customerSkuSupplyPrice = psCustomerSkuSupplyPriceList.stream().filter(item -> sku.getId().equals(item.getPsSkuId())).findAny().orElse(null);
            if (customerSkuSupplyPrice != null) {
                psCustomerSkuSupplyPriceQueryDTO.setSupplyPrice(BigDecimalUtils.convert(customerSkuSupplyPrice.getSupplyPrice(), 2));
                psCustomerSkuSupplyPriceQueryDTO.setType(SkuSupplyPriceTypeEnums.ONE.getCode());
            } else {
                PsCauseDeptSkuSupplyPrice psCauseDeptSkuSupplyPrice = psCauseDeptSkuSupplyPriceList.stream().filter(item -> sku.getId().equals(item.getPsSkuId())).findAny().orElse(null);
                if (psCauseDeptSkuSupplyPrice != null) {
                    psCustomerSkuSupplyPriceQueryDTO.setSupplyPrice(BigDecimalUtils.convert(psCauseDeptSkuSupplyPrice.getSupplyPrice(), 2));
                    psCustomerSkuSupplyPriceQueryDTO.setType(SkuSupplyPriceTypeEnums.TWO.getCode());
                } else {
                    SkuSupplyPrice skuSupplyPrice = skuSupplyPriceList.stream().filter(item -> sku.getId().equals(item.getPsSkuId())).findAny().orElse(null);
                    if (skuSupplyPrice != null) {
                        psCustomerSkuSupplyPriceQueryDTO.setSupplyPrice(BigDecimalUtils.convert(skuSupplyPrice.getSupplyPrice(), 2));
                        psCustomerSkuSupplyPriceQueryDTO.setType(SkuSupplyPriceTypeEnums.THERE.getCode());
                    } else {
                        psCustomerSkuSupplyPriceQueryDTO.setSupplyPrice(BigDecimalUtils.convert(sku.getCounterPrice(), 2));
                        psCustomerSkuSupplyPriceQueryDTO.setType(SkuSupplyPriceTypeEnums.FOUR.getCode());
                    }
                }
            }
            List customerSkuSupplyPriceLogs = psCustomerSkuSupplyPriceLogs.stream().filter(item -> sku.getId().equals(item.getPsSkuId())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(customerSkuSupplyPriceLogs)) {
                psCustomerSkuSupplyPriceQueryDTO.setInvalidSupplyPrice(BigDecimalUtils.convert(((PsCustomerSkuSupplyPriceLog)customerSkuSupplyPriceLogs.get(customerSkuSupplyPriceLogs.size() - 1)).getSupplyPrice(), 2));
            }
            dtoList.add(psCustomerSkuSupplyPriceQueryDTO);
        }
        return dtoList;
    }

    private static /* synthetic */ boolean lambda$postpone$13(PsCustomerSkuSupplyPrice customerSkuSupplyPrice, PostponeDTO item) {
        return item.getId().equals(customerSkuSupplyPrice.getId());
    }
}

