/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.xinqiyi.cus.model.dto.customer.CustomerQueryInfoDTO;
import com.xinqiyi.cus.vo.CustomerVO;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.BigDecimalUtil;
import com.xinqiyi.mdm.api.model.vo.causedept.CauseDeptVO;
import com.xinqiyi.mdm.api.model.vo.salesman.SalesmanVO;
import com.xinqiyi.mdm.model.dto.salesman.SalesmanDTO;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.PsCustomerApprovalService;
import com.xinqiyi.ps.dao.repository.PsCustomerApprovalSkuService;
import com.xinqiyi.ps.dao.repository.PsCustomerSkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.PsCustomerSupplyPriceApprovalService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.model.dto.enums.CustomerSupplyPriceEnum;
import com.xinqiyi.ps.model.dto.enums.InnerLogTypeEnum;
import com.xinqiyi.ps.model.dto.enums.IsDeleteEnums;
import com.xinqiyi.ps.model.dto.enums.SkuSupplyPriceStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SpuClassifyEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.sku.InteriorSkuDTO;
import com.xinqiyi.ps.model.dto.sku.QueryComposeSkuDTO;
import com.xinqiyi.ps.model.dto.sku.QueryInteriorSkuDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.supplyprice.CustomerApprovalDTO;
import com.xinqiyi.ps.model.dto.supplyprice.CustomerApprovalSkuDTO;
import com.xinqiyi.ps.model.dto.supplyprice.CustomerDTO;
import com.xinqiyi.ps.model.dto.supplyprice.CustomerSupplyPriceApprovalDTO;
import com.xinqiyi.ps.model.dto.supplyprice.CustomerSupplyPriceOaFormDTO;
import com.xinqiyi.ps.model.dto.supplyprice.PsCustomerApprovalSkuDTO;
import com.xinqiyi.ps.model.dto.supplyprice.QuerySkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SaveCustomerSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SaveCustomerSupplyPriceApprovalDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SaveSupplyPriceApprovalDTO;
import com.xinqiyi.ps.model.dto.supplyprice.SupplyPriceApprovalCheckDTO;
import com.xinqiyi.ps.model.dto.supplyprice.TableCountDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.PsCustomerApproval;
import com.xinqiyi.ps.model.entity.PsCustomerApprovalSku;
import com.xinqiyi.ps.model.entity.PsCustomerSkuSupplyPrice;
import com.xinqiyi.ps.model.entity.PsCustomerSupplyPriceApproval;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.model.entity.SkuSupplyPrice;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.oa.OaAdapter;
import com.xinqiyi.ps.service.adapter.org.OrgAdapter;
import com.xinqiyi.ps.service.adapter.org.OrgDepartment;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.business.ComposeSkuBiz;
import com.xinqiyi.ps.service.business.PsCustomerApprovalBiz;
import com.xinqiyi.ps.service.business.PsCustomerApprovalSkuBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import com.xinqiyi.ps.service.util.AcquireBillNoUtil;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.FileUploadUtil;
import com.xinqiyi.ps.service.util.PsRedisLockUtil;
import com.xinqiyi.ps.service.util.TimeSlotUtil;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageCostVo;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsCustomerSupplyPriceApprovalBiz {
    private static final Logger log = LoggerFactory.getLogger(PsCustomerSupplyPriceApprovalBiz.class);
    @Autowired
    private SkuService skuService;
    @Autowired
    private PsCustomerSupplyPriceApprovalService psCustomerSupplyPriceApprovalService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private AcquireBillNoUtil acquireBillNoUtil;
    @Autowired
    private CusAdapter cusAdapter;
    @Autowired
    private PsCustomerSkuSupplyPriceService psCustomerSkuSupplyPriceService;
    @Autowired
    private PsCustomerApprovalBiz psCustomerApprovalBiz;
    @Autowired
    private PsCustomerApprovalService psCustomerApprovalService;
    @Autowired
    private PsCustomerApprovalSkuBiz psCustomerApprovalSkuBiz;
    @Autowired
    private PsCustomerApprovalSkuService psCustomerApprovalSkuService;
    @Autowired
    private SkuBarCodeService skuBarCodeService;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private FileUploadUtil fileUploadUtil;
    @Autowired
    private SgStorageQueryAdapter sgStorageQueryAdapter;
    @Autowired
    private OaAdapter oaAdapter;
    @Autowired
    private BrandService brandService;
    @Autowired
    private SpuService spuService;
    @Autowired
    private MdmAdapter mdmAdapter;
    @Autowired
    private OrgAdapter orgAdapter;
    @Autowired
    private ComposeSkuBiz composeSkuBiz;
    @Autowired
    private SkuSupplyPriceService skuSupplyPriceService;

    public ApiResponse<SaveSupplyPriceApprovalDTO> save(ApiRequest<SaveCustomerSupplyPriceApprovalDTO> request) {
        SaveCustomerSupplyPriceApprovalDTO customerSupplyPriceApprovalDTO = (SaveCustomerSupplyPriceApprovalDTO)request.getJsonData();
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            RedisReentrantLock lock;
            List skuIdList = customerSupplyPriceApprovalDTO.getCustomerSkuSupplyPriceList().stream().map(SaveCustomerSkuSupplyPriceDTO::getPsSkuId).distinct().collect(Collectors.toList());
            for (Long skuId : skuIdList) {
                String lockKey = "ps:supply_price_approval:save:" + skuId;
                lock = PsRedisLockUtil.lock(lockKey, "\u5ba1\u6279\u5355\u5546\u54c1\u7528\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock);
            }
            if (customerSupplyPriceApprovalDTO.getId() != null) {
                String lockKey = "ps:supply_price_approval:submit:" + customerSupplyPriceApprovalDTO.getId();
                RedisReentrantLock lock2 = PsRedisLockUtil.lock(lockKey, "\u5ba1\u6279\u5355\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock2);
            }
            List<CustomerVO> customerVOS = this.checkCustomerParam(customerSupplyPriceApprovalDTO.getCusCustomerIdList());
            List<SupplyPriceApprovalCheckDTO> approvalCheckDTOS = this.checkSupplyPriceParam(customerSupplyPriceApprovalDTO, customerVOS);
            SaveSupplyPriceApprovalDTO insertCustomerSupplyPriceApprovalDTO = new SaveSupplyPriceApprovalDTO();
            insertCustomerSupplyPriceApprovalDTO.setId(customerSupplyPriceApprovalDTO.getId());
            if (CollUtil.isNotEmpty(approvalCheckDTOS)) {
                insertCustomerSupplyPriceApprovalDTO.setSkuList(approvalCheckDTOS);
                lock = ApiResponse.success((Object)insertCustomerSupplyPriceApprovalDTO);
                return lock;
            }
            List<Object> newCusCustomerIdList = new ArrayList();
            if (customerSupplyPriceApprovalDTO.getId() == null) {
                newCusCustomerIdList = customerSupplyPriceApprovalDTO.getCusCustomerIdList();
            }
            List<Object> removeCusCustomerIdList = new ArrayList();
            PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval = new PsCustomerSupplyPriceApproval();
            if (customerSupplyPriceApprovalDTO.getId() != null) {
                psCustomerSupplyPriceApproval = (PsCustomerSupplyPriceApproval)this.psCustomerSupplyPriceApprovalService.getById((Serializable)customerSupplyPriceApprovalDTO.getId());
                Assert.notNull((Object)psCustomerSupplyPriceApproval, (String)"\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psCustomerSupplyPriceApproval);
                if (CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue().equals(psCustomerSupplyPriceApproval.getStatus()) || CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL.getValue().equals(psCustomerSupplyPriceApproval.getStatus())) {
                    this.saveApprovalRemark(psCustomerSupplyPriceApproval, customerSupplyPriceApprovalDTO);
                    InnerLog.addLog((Long)psCustomerSupplyPriceApproval.getId(), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u4fdd\u5b58", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(customerSupplyPriceApprovalDTO.getType()) ? InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4fdd\u5b58");
                    ApiResponse apiResponse = ApiResponse.success((Object)insertCustomerSupplyPriceApprovalDTO);
                    return apiResponse;
                }
                List customerIdList = this.psCustomerApprovalService.list((Wrapper)new QueryWrapper().lambda().eq(PsCustomerApproval::getPsCustomerSupplyPriceApprovalId, (Object)customerSupplyPriceApprovalDTO.getId())).stream().map(PsCustomerApproval::getCusCustomerId).distinct().collect(Collectors.toList());
                newCusCustomerIdList = customerSupplyPriceApprovalDTO.getCusCustomerIdList().stream().filter(s -> !customerIdList.contains(s)).collect(Collectors.toList());
                removeCusCustomerIdList = customerIdList.stream().filter(s -> !customerSupplyPriceApprovalDTO.getCusCustomerIdList().contains(s)).collect(Collectors.toList());
            } else {
                psCustomerSupplyPriceApproval.setId(this.idSequence.generateId(PsCustomerSupplyPriceApproval.class));
                psCustomerSupplyPriceApproval.setCode(this.acquireBillNoUtil.getBillNo("psCustomerSupplyPriceApproval", "KHGH"));
                psCustomerSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.TO_SUBMIT.getValue());
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psCustomerSupplyPriceApproval);
            }
            psCustomerSupplyPriceApproval.setRemark(customerSupplyPriceApprovalDTO.getRemark());
            psCustomerSupplyPriceApproval.setType(customerSupplyPriceApprovalDTO.getType());
            List<PsCustomerApproval> psCustomerApprovals = this.psCustomerApprovalBiz.covertSave(newCusCustomerIdList, psCustomerSupplyPriceApproval);
            List<PsCustomerApprovalSku> psCustomerApprovalSkuList = this.psCustomerApprovalSkuBiz.covertSave(psCustomerSupplyPriceApproval, customerSupplyPriceApprovalDTO);
            List updateIdList = customerSupplyPriceApprovalDTO.getCustomerSkuSupplyPriceList().stream().filter(item -> item.getId() != null).map(SaveCustomerSkuSupplyPriceDTO::getId).collect(Collectors.toList());
            this.psCustomerSupplyPriceApprovalService.saveApproval(psCustomerSupplyPriceApproval, psCustomerApprovals, psCustomerApprovalSkuList, removeCusCustomerIdList, updateIdList);
            if (IsDeleteEnums.YES.getCode().equals(customerSupplyPriceApprovalDTO.getIsSubmit())) {
                LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
                List psCustomerApprovalSkuArray = this.psCustomerApprovalSkuService.list((Wrapper)new QueryWrapper().lambda().eq(PsCustomerApprovalSku::getPsCustomerSupplyPriceApprovalId, (Object)psCustomerSupplyPriceApproval.getId()));
                List<Long> mdmDepartmentIdList = customerVOS.stream().map(CustomerVO::getMdmDepartmentId).distinct().collect(Collectors.toList());
                List<CauseDeptVO> causeDeptVOS = this.mdmAdapter.queryDeptAllList(mdmDepartmentIdList);
                String oaId = null;
                try {
                    oaId = this.createOaFlow(psCustomerSupplyPriceApproval, customerVOS, user, psCustomerApprovalSkuArray, causeDeptVOS, customerSupplyPriceApprovalDTO.getDingDingDeptId());
                }
                catch (Exception e) {
                    insertCustomerSupplyPriceApprovalDTO.setId(psCustomerSupplyPriceApproval.getId());
                    ApiResponse apiResponse = ApiResponse.failed((Object)insertCustomerSupplyPriceApprovalDTO, (String)"800", (String)e.getMessage());
                    if (CollUtil.isNotEmpty(lockList)) {
                        for (int i = 0; i < lockList.size(); ++i) {
                            PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                        }
                    }
                    return apiResponse;
                }
                psCustomerSupplyPriceApproval.setSubmitUser(user.getName());
                psCustomerSupplyPriceApproval.setSubmitTime(new Date());
                psCustomerSupplyPriceApproval.setOaId(oaId);
                psCustomerSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue());
                this.psCustomerSupplyPriceApprovalService.saveApproval(psCustomerSupplyPriceApproval, null, psCustomerApprovalSkuArray, removeCusCustomerIdList, (List)CollUtil.newArrayList((Object[])new Long[0]));
                InnerLog.addLog((Long)psCustomerSupplyPriceApproval.getId(), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u4fdd\u5b58\u63d0\u4ea4", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(customerSupplyPriceApprovalDTO.getType()) ? InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4fdd\u5b58\u63d0\u4ea4");
            } else {
                InnerLog.addLog((Long)psCustomerSupplyPriceApproval.getId(), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u4fdd\u5b58", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(customerSupplyPriceApprovalDTO.getType()) ? InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u4fdd\u5b58");
            }
            insertCustomerSupplyPriceApprovalDTO.setId(psCustomerSupplyPriceApproval.getId());
            ApiResponse apiResponse = ApiResponse.success((Object)insertCustomerSupplyPriceApprovalDTO);
            return apiResponse;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("Invoice.FcOutputInvoiceBiz.billingInvoice Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    private String createOaFlow(PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval, List<CustomerVO> customerVOS, LoginUserInfo user, List<PsCustomerApprovalSku> psCustomerApprovalSkuArray, List<CauseDeptVO> causeDeptVOS, Long oaDingdingDeptId) {
        QuerySkuSupplyPriceDTO querySkuSupplyPriceDTO = new QuerySkuSupplyPriceDTO();
        querySkuSupplyPriceDTO.setId(psCustomerSupplyPriceApproval.getId());
        List customerApprovalSkuExportDTOS = this.psCustomerApprovalSkuService.selectApprovalSkuList(querySkuSupplyPriceDTO);
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)customerApprovalSkuExportDTOS), (String)"\u4f9b\u8d27\u4ef7\u660e\u7ec6\u4e3a\u7a7a\u4e0d\u53ef\u63d0\u4ea4");
        List skuIds = customerApprovalSkuExportDTOS.stream().map(CustomerApprovalSkuDTO::getPsSkuId).collect(Collectors.toList());
        List<String> skuCodeList = customerApprovalSkuExportDTOS.stream().map(CustomerApprovalSkuDTO::getSkuCode).collect(Collectors.toList());
        List spuIds = customerApprovalSkuExportDTOS.stream().map(CustomerApprovalSkuDTO::getSpuId).distinct().collect(Collectors.toList());
        List spuList = this.spuService.listByIds(spuIds);
        List brandIds = spuList.stream().map(Spu::getPsBrandId).distinct().collect(Collectors.toList());
        List brands = this.brandService.listByIds(brandIds);
        SalesmanDTO salesmanDTO = new SalesmanDTO();
        salesmanDTO.setBrandIds((Set)CollUtil.newHashSet(brandIds));
        List<SalesmanVO> salesmanVOS = this.mdmAdapter.queryMarketingList(salesmanDTO);
        ArrayList brandName = CollUtil.newArrayList((Object[])new String[0]);
        for (Brand brand : brands) {
            List salesmanVOList = salesmanVOS.stream().filter(item -> brand.getId().equals(item.getPsBrandId())).collect(Collectors.toList());
            if (!CollUtil.isEmpty(salesmanVOList)) continue;
            brandName.add(brand.getName());
        }
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)brandName), (String)(((Object)brandName).toString() + "\u6ca1\u6709\u914d\u7f6e\u884c\u9500\u4eba\u5458,\u8bf7\u5148\u914d\u7f6e\u884c\u9500\u4eba\u5458\u540e\u63d0\u4ea4"));
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(skuCodeList);
        List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
        Date date = new Date();
        List status = Stream.of(SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode(), SkuSupplyPriceStatusEnums.IN_FORCE.getCode()).collect(Collectors.toList());
        List skuSupplyPriceList = CollUtil.newArrayList((Object[])new SkuSupplyPrice[0]);
        if (SupplyPriceTypeEnums.TWO.getCode().equals(psCustomerSupplyPriceApproval.getType())) {
            skuSupplyPriceList = this.skuSupplyPriceService.getBySkuIds(skuIds, status, date, null);
        }
        this.buildExcelDataAndApprovalInfo(psCustomerSupplyPriceApproval, psCustomerApprovalSkuArray, customerApprovalSkuExportDTOS, spuList, brands, sgBStorageCostVos, skuBarCodeList, skuSupplyPriceList);
        List<String> customerNameList = this.getCustomerNameList(customerVOS);
        String excelUrl = this.uploadExcelAndGetUrl(psCustomerSupplyPriceApproval, user, customerApprovalSkuExportDTOS, customerNameList);
        CustomerSupplyPriceOaFormDTO formDTO = this.getOaParam(psCustomerSupplyPriceApproval, causeDeptVOS, customerApprovalSkuExportDTOS, brands, salesmanVOS, customerNameList, excelUrl, user, oaDingdingDeptId);
        String templateName = SupplyPriceTypeEnums.ONE.getCode().equals(psCustomerSupplyPriceApproval.getType()) ? "CUSTOMER_SUPPLY_PRICE" : "CUSTOMER_SUPPLY_PRICE_WHOLESALE";
        return this.oaAdapter.createOaProcessV2(JSON.toJSONString((Object)formDTO), templateName);
    }

    private void buildExcelDataAndApprovalInfo(PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval, List<PsCustomerApprovalSku> psCustomerApprovalSkuArray, List<CustomerApprovalSkuDTO> customerApprovalSkuExportDTOS, List<Spu> spuList, List<Brand> brands, List<SgBStorageCostVo> sgBStorageCostVos, List<SkuBarCode> skuBarCodeList, List<SkuSupplyPrice> skuSupplyPriceList) {
        for (CustomerApprovalSkuDTO customerApprovalSkuExportDTO : customerApprovalSkuExportDTOS) {
            SkuSupplyPrice dfSupplyPrice;
            SgBStorageCostVo sgBStorageCostVo;
            List skuBarCodes;
            customerApprovalSkuExportDTO.setCounterPrice(BigDecimalUtils.convert(customerApprovalSkuExportDTO.getCounterPrice(), 2));
            if (customerApprovalSkuExportDTO.getCustomerPrice() != null) {
                customerApprovalSkuExportDTO.setCustomerPriceOrCounterPrice(customerApprovalSkuExportDTO.getCustomerPrice());
            } else {
                customerApprovalSkuExportDTO.setCustomerPriceOrCounterPrice(customerApprovalSkuExportDTO.getCounterPrice());
            }
            customerApprovalSkuExportDTO.setSupplyPrice(BigDecimalUtils.convert(customerApprovalSkuExportDTO.getSupplyPrice(), 2));
            customerApprovalSkuExportDTO.setInDate(DateUtil.formatDateTime((Date)customerApprovalSkuExportDTO.getEffectiveTime()) + "/" + DateUtil.formatDateTime((Date)customerApprovalSkuExportDTO.getInvalidTime()));
            if (CollUtil.isNotEmpty(skuBarCodeList) && CollUtil.isNotEmpty(skuBarCodes = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(customerApprovalSkuExportDTO.getPsSkuId())).collect(Collectors.toList()))) {
                customerApprovalSkuExportDTO.setBarCode(skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(",")));
            }
            Spu spu = spuList.stream().filter(s -> s.getId().equals(customerApprovalSkuExportDTO.getSpuId())).findAny().orElse(null);
            Brand brand = brands.stream().filter(s -> s.getId().equals(spu.getPsBrandId())).findAny().orElse(null);
            PsCustomerApprovalSku psCustomerApprovalSku = psCustomerApprovalSkuArray.stream().filter(s -> s.getPsSkuId().equals(customerApprovalSkuExportDTO.getPsSkuId())).findAny().orElse(null);
            if (brand != null && brand.getGrossProfitRate() != null && SupplyPriceTypeEnums.ONE.getCode().equals(psCustomerSupplyPriceApproval.getType())) {
                customerApprovalSkuExportDTO.setBrandGrossProfitRate(brand.getGrossProfitRate().toString() + "%");
                psCustomerApprovalSku.setBrandGrossProfitRate(brand.getGrossProfitRate());
            } else if (brand != null && brand.getGrossProfitRateOneShipment() != null && SupplyPriceTypeEnums.TWO.getCode().equals(psCustomerSupplyPriceApproval.getType())) {
                customerApprovalSkuExportDTO.setBrandGrossProfitRate(brand.getGrossProfitRateOneShipment().toString() + "%");
                psCustomerApprovalSku.setBrandGrossProfitRate(brand.getGrossProfitRateOneShipment());
            }
            BigDecimal price = customerApprovalSkuExportDTO.getCustomerPrice() == null ? customerApprovalSkuExportDTO.getCounterPrice() : customerApprovalSkuExportDTO.getCustomerPrice();
            customerApprovalSkuExportDTO.setCustomerGrossProfit(BigDecimalUtil.subtract((BigDecimal)price, (BigDecimal)customerApprovalSkuExportDTO.getSupplyPrice()));
            BigDecimal customerGrossProfit = BigDecimalUtil.divide((BigDecimal)customerApprovalSkuExportDTO.getCustomerGrossProfit(), (BigDecimal)price, (int)4, (RoundingMode)RoundingMode.HALF_UP);
            customerApprovalSkuExportDTO.setCustomerGrossProfitRate(String.valueOf(BigDecimalUtil.multiply((BigDecimal)customerGrossProfit, (BigDecimal[])new BigDecimal[]{new BigDecimal("100")})) + "%");
            StringBuilder composeSkuCostDesc = new StringBuilder();
            if (log.isDebugEnabled()) {
                log.debug("Spu.Code={},Spu.Classify={}", (Object)spu.getCode(), (Object)spu.getClassify());
            }
            if (SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify())) {
                if (log.isDebugEnabled()) {
                    log.debug("Start Compose Sku CostPrice Calc");
                }
                List<QueryComposeSkuDTO> composeSkuDTOList = this.composeSkuBiz.selectComposeSku(spu.getId());
                List<String> composeSkuCodeList = composeSkuDTOList.stream().map(QueryComposeSkuDTO::getSkuCode).collect(Collectors.toList());
                if (log.isDebugEnabled()) {
                    log.debug("Start Compose Sku CostPrice SKUCode={}", composeSkuCodeList);
                }
                List<SgBStorageCostVo> composeSkuCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(composeSkuCodeList);
                BigDecimal totalCostPrice = BigDecimal.ZERO;
                for (QueryComposeSkuDTO composeSkuDTO : composeSkuDTOList) {
                    SgBStorageCostVo costVo;
                    if (!CollUtil.isNotEmpty(composeSkuCostVos) || (costVo = (SgBStorageCostVo)composeSkuCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(composeSkuDTO.getSkuCode())).findAny().orElse(null)) == null) continue;
                    BigDecimal skuPriceCost = costVo.getPriceCost();
                    skuPriceCost = BigDecimalUtil.multiply((BigDecimal)skuPriceCost, (BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(composeSkuDTO.getComposeNumber().intValue())});
                    totalCostPrice = totalCostPrice.add(skuPriceCost);
                    skuPriceCost = skuPriceCost.setScale(2, RoundingMode.HALF_UP);
                    String costPriceValue = costVo.getPriceCost().toPlainString();
                    if ("0E-8".equals(costPriceValue)) {
                        costPriceValue = "0.00000000";
                    }
                    composeSkuCostDesc.append("[" + composeSkuDTO.getSkuName() + "(" + costVo.getPsCSkuEcode() + ") \u6570\u91cf " + composeSkuDTO.getComposeNumber() + " \u5355\u4e2a\u6210\u672c " + costPriceValue + " \u603b\u6210\u672c " + String.valueOf(skuPriceCost) + "] \r\n");
                }
                String costPriceValue = totalCostPrice.toPlainString();
                if ("0E-8".equals(costPriceValue)) {
                    costPriceValue = "0.00000000";
                }
                customerApprovalSkuExportDTO.setSgCostPriceStr(costPriceValue);
                customerApprovalSkuExportDTO.setGrossProfit(customerApprovalSkuExportDTO.getSupplyPrice().subtract(totalCostPrice));
                customerApprovalSkuExportDTO.setSgCostPriceDesc(composeSkuCostDesc.toString());
                BigDecimal grossProfit = customerApprovalSkuExportDTO.getGrossProfit().divide(customerApprovalSkuExportDTO.getSupplyPrice(), 4, 4);
                customerApprovalSkuExportDTO.setGrossProfitRate(grossProfit.multiply(new BigDecimal("100")).toPlainString() + "%");
                psCustomerApprovalSku.setSgCostPrice(totalCostPrice);
                psCustomerApprovalSku.setGrossProfit(customerApprovalSkuExportDTO.getGrossProfit());
                psCustomerApprovalSku.setGrossProfitRate(grossProfit);
                if (BigDecimalUtils.lessThan(customerApprovalSkuExportDTO.getSupplyPrice(), totalCostPrice)) {
                    customerApprovalSkuExportDTO.setClue("\u672c\u6b21\u8c03\u4ef7\u4f4e\u4e8e\u6210\u672c\u4ef7");
                }
            } else if (CollUtil.isNotEmpty(sgBStorageCostVos) && (sgBStorageCostVo = (SgBStorageCostVo)sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(customerApprovalSkuExportDTO.getSkuCode())).findAny().orElse(null)) != null) {
                String s2 = sgBStorageCostVo.getPriceCost().toPlainString();
                if ("0E-8".equals(s2)) {
                    s2 = "0.00000000";
                }
                customerApprovalSkuExportDTO.setSgCostPriceStr(s2);
                psCustomerApprovalSku.setSgCostPrice(sgBStorageCostVo.getPriceCost());
                customerApprovalSkuExportDTO.setGrossProfit(customerApprovalSkuExportDTO.getSupplyPrice().subtract(sgBStorageCostVo.getPriceCost()));
                psCustomerApprovalSku.setSgCostPrice(sgBStorageCostVo.getPriceCost());
                psCustomerApprovalSku.setGrossProfit(customerApprovalSkuExportDTO.getGrossProfit());
                BigDecimal grossProfit = customerApprovalSkuExportDTO.getGrossProfit().divide(customerApprovalSkuExportDTO.getSupplyPrice(), 4, 4);
                customerApprovalSkuExportDTO.setGrossProfitRate(grossProfit.multiply(new BigDecimal("100")).toPlainString() + "%");
                psCustomerApprovalSku.setGrossProfitRate(grossProfit);
                if (BigDecimalUtils.lessThan(customerApprovalSkuExportDTO.getSupplyPrice(), sgBStorageCostVo.getPriceCost())) {
                    customerApprovalSkuExportDTO.setClue("\u672c\u6b21\u8c03\u4ef7\u4f4e\u4e8e\u6210\u672c\u4ef7");
                }
            }
            if (!SupplyPriceTypeEnums.TWO.getCode().equals(psCustomerSupplyPriceApproval.getType())) continue;
            SkuSupplyPrice pcSupplyPrice = skuSupplyPriceList.stream().filter(item -> item.getPsSkuId().equals(customerApprovalSkuExportDTO.getPsSkuId()) && SupplyPriceTypeEnums.ONE.getCode().equals(item.getType())).findAny().orElse(null);
            if (pcSupplyPrice != null) {
                customerApprovalSkuExportDTO.setPcSupplyPrice(pcSupplyPrice.getSupplyPrice());
            }
            if ((dfSupplyPrice = (SkuSupplyPrice)skuSupplyPriceList.stream().filter(item -> item.getPsSkuId().equals(customerApprovalSkuExportDTO.getPsSkuId()) && SupplyPriceTypeEnums.TWO.getCode().equals(item.getType())).findAny().orElse(null)) != null) {
                customerApprovalSkuExportDTO.setDfSupplyPrice(dfSupplyPrice.getSupplyPrice());
                customerApprovalSkuExportDTO.setDfPrice(dfSupplyPrice.getSupplyPrice());
                continue;
            }
            customerApprovalSkuExportDTO.setDfPrice(customerApprovalSkuExportDTO.getCounterPrice());
        }
    }

    private CustomerSupplyPriceOaFormDTO getOaParam(PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval, List<CauseDeptVO> causeDeptVOS, List<CustomerApprovalSkuDTO> customerApprovalSkuExportDTOS, List<Brand> brands, List<SalesmanVO> salesmanVOS, List<String> customerNameList, String excelUrl, LoginUserInfo userInfo, Long oaDingdingDeptId) {
        CustomerSupplyPriceOaFormDTO formDTO = new CustomerSupplyPriceOaFormDTO();
        Object customerName = String.join((CharSequence)"  ", customerNameList);
        if (((String)customerName).length() >= 950) {
            String substring = ((String)customerName).substring(0, 950);
            customerName = substring + "...\u8be6\u60c5\u8bf7\u67e5\u770bexcel";
        }
        formDTO.setAttach(excelUrl);
        formDTO.setSupplyPriceDetails(customerApprovalSkuExportDTOS);
        formDTO.setCusCustomerName((String)customerName);
        formDTO.setRemark(psCustomerSupplyPriceApproval.getRemark());
        formDTO.setBrandName(brands.stream().map(Brand::getName).distinct().collect(Collectors.toList()));
        formDTO.setMarketingPhoneList(salesmanVOS.stream().map(SalesmanVO::getPhone).collect(Collectors.joining(",")));
        if (SupplyPriceTypeEnums.TWO.getCode().equals(psCustomerSupplyPriceApproval.getType())) {
            List customerApprovalSkuDTOS = customerApprovalSkuExportDTOS.stream().filter(item -> BigDecimalUtils.lessEqual(item.getSupplyPrice(), item.getDfPrice())).collect(Collectors.toList());
            if (CollUtil.isEmpty(customerApprovalSkuDTOS)) {
                formDTO.setIsSimplify("\u662f");
            } else {
                formDTO.setIsSimplify("\u5426");
            }
        }
        if (CollUtil.isNotEmpty(causeDeptVOS)) {
            formDTO.setOaDingdingDeptIdList(StringUtils.join((Object[])causeDeptVOS.stream().map(CauseDeptVO::getOaDingdingDeptId).toArray(), (String)","));
        }
        formDTO.setPhoneNumber(userInfo.getPhoneNumber());
        formDTO.setDingDingDeptId(oaDingdingDeptId);
        return formDTO;
    }

    private List<String> getCustomerNameList(List<CustomerVO> customerVOS) {
        ArrayList<String> customerNameList = new ArrayList<String>();
        Map<String, List<CustomerVO>> listMap = customerVOS.stream().collect(Collectors.groupingBy(o -> o.getMdmDepartmentId() + "_" + o.getMdmChildDepartmentId()));
        for (Map.Entry<String, List<CustomerVO>> map : listMap.entrySet()) {
            List<CustomerVO> customerVOList = map.getValue();
            CustomerVO customerVO = customerVOList.get(0);
            StringBuilder customerName = new StringBuilder(customerVO.getMdmDepartmentName() + ": [");
            String name = customerVOList.stream().map(r -> r.getCustomerCode() + "/" + r.getCustomerName()).collect(Collectors.joining(","));
            customerName.append(name).append("]   ");
            customerNameList.add(customerName.toString());
        }
        return customerNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadExcelAndGetUrl(PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval, LoginUserInfo user, List<CustomerApprovalSkuDTO> customerApprovalSkuExportDTOS, List<String> customerNameList) {
        String excelurl = "";
        String fileName = "\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355" + psCustomerSupplyPriceApproval.getId() + ".xls";
        String filePath = ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME + fileName;
        try {
            String fileUrl = ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME;
            FileUtil.mkdir((String)fileUrl);
            String templateUrl = fileUrl + "\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u6a21\u677f.xls";
            boolean exist = FileUtil.exist((String)templateUrl);
            if (!exist) {
                this.fileUploadUtil.downLoadFile(ConstantPropertiesUtil.SUPPLY_PRICE_APPROVAL_URL, templateUrl);
            }
            TemplateExportParams params = new TemplateExportParams(templateUrl, new Integer[0]);
            HashMap map = Maps.newHashMap();
            map.put("list", customerApprovalSkuExportDTOS);
            map.put("name", String.join((CharSequence)"\n", customerNameList));
            Workbook book = ExcelExportUtil.exportExcel((TemplateExportParams)params, (Map)map);
            try (FileOutputStream fo = new FileOutputStream(filePath);){
                book.write((OutputStream)fo);
            }
            excelurl = this.fileUploadUtil.uploadExcelFileXls("ps", filePath, PinyinUtil.getPinyin((String)user.getUserName()));
            FileUtil.del((String)filePath);
        }
        catch (Exception e) {
            log.error("uploadExcelAndGetUrl.Error", (Throwable)e);
            throw new IllegalArgumentException("\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6838\u6587\u4ef6\u751f\u6210\u5931\u8d25failMsg" + e.getMessage());
        }
        return excelurl;
    }

    private void saveApprovalRemark(PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval, SaveCustomerSupplyPriceApprovalDTO customerSupplyPriceApprovalDTO) {
        psCustomerSupplyPriceApproval.setRemark(customerSupplyPriceApprovalDTO.getRemark());
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psCustomerSupplyPriceApproval);
        List<PsCustomerApprovalSku> psCustomerApprovalSkuList = this.psCustomerApprovalSkuBiz.saveRemark(customerSupplyPriceApprovalDTO);
        this.psCustomerSupplyPriceApprovalService.saveApprovalRemark(psCustomerSupplyPriceApproval, psCustomerApprovalSkuList);
    }

    private List<CustomerVO> checkCustomerParam(List<Long> cusCustomerIdList) {
        List<CustomerVO> customerVOS = this.cusAdapter.queryCustomerByIds(cusCustomerIdList);
        Assert.isTrue((boolean)CollUtil.isNotEmpty(customerVOS), (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        Assert.isTrue((cusCustomerIdList.size() == customerVOS.size() ? 1 : 0) != 0, (String)"\u67e5\u65e0\u5ba2\u6237");
        return customerVOS;
    }

    private List<SupplyPriceApprovalCheckDTO> checkSupplyPriceParam(SaveCustomerSupplyPriceApprovalDTO customerSupplyPriceApprovalDTO, List<CustomerVO> customerVOS) {
        List customerSkuSupplyPriceList = customerSupplyPriceApprovalDTO.getCustomerSkuSupplyPriceList();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)customerSkuSupplyPriceList), (String)"\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        if (customerSupplyPriceApprovalDTO.getId() != null) {
            PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval = (PsCustomerSupplyPriceApproval)this.psCustomerSupplyPriceApprovalService.getById((Serializable)customerSupplyPriceApprovalDTO.getId());
            Assert.notNull((Object)psCustomerSupplyPriceApproval, (String)"\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
            if (CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue().equals(psCustomerSupplyPriceApproval.getStatus()) || CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL.getValue().equals(psCustomerSupplyPriceApproval.getStatus())) {
                return CollUtil.newArrayList((Object[])new SupplyPriceApprovalCheckDTO[0]);
            }
        }
        List<Long> skuIdList = customerSkuSupplyPriceList.stream().map(SaveCustomerSkuSupplyPriceDTO::getPsSkuId).collect(Collectors.toList());
        List skuList = this.skuService.selectByStatus(skuIdList, StatusEnums.ENABLED.getCode());
        for (SaveCustomerSkuSupplyPriceDTO dto : customerSkuSupplyPriceList) {
            Sku sku = skuList.stream().filter(s -> dto.getPsSkuId().equals(s.getId())).findAny().orElse(null);
            Assert.notNull((Object)sku, (String)(dto.getPsSkuId() + "sku\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528"));
            Assert.isTrue((boolean)BigDecimalUtils.greaterThan(dto.getSupplyPrice(), new BigDecimal(0)), (String)(sku.getName() + " \u4f9b\u8d27\u4ef7\u5fc5\u987b\u5927\u4e8e0"));
            dto.setEffectiveTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)dto.getEffectiveTime(), (String)"yyyy-MM-dd 00:00:00")));
            dto.setInvalidTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)dto.getInvalidTime(), (String)"yyyy-MM-dd 23:59:59")));
            Assert.isTrue((dto.getEffectiveTime().getTime() >= DateUtil.beginOfDay((Date)new Date()).getTime() ? 1 : 0) != 0, (String)(sku.getName() + " \u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            Assert.isTrue((dto.getInvalidTime().getTime() > dto.getEffectiveTime().getTime() ? 1 : 0) != 0, (String)(sku.getName() + " \u4f9b\u8d27\u4ef7\u5931\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65f6\u95f4"));
        }
        return this.checkSupplyPriceValidity(customerSupplyPriceApprovalDTO.getCusCustomerIdList(), customerSupplyPriceApprovalDTO.getType(), skuIdList, skuList, customerVOS, customerSupplyPriceApprovalDTO.getId(), customerSkuSupplyPriceList, null);
    }

    private void getFailMsg(List<SupplyPriceApprovalCheckDTO> msg, String key, Sku sku, List<CustomerVO> customerVOS, List<String> dateList, List<Long> idList) {
        if (TimeSlotUtil.overlapping(dateList)) {
            String cusCustomerId = key.substring(0, key.indexOf("_"));
            CustomerVO customerVO = customerVOS.stream().filter(s -> s.getId().equals(Long.valueOf(cusCustomerId))).findAny().orElse(null);
            if (CollUtil.isNotEmpty(idList)) {
                for (Long id : idList) {
                    SupplyPriceApprovalCheckDTO customerSupplyPriceApprovalCheckDTO = new SupplyPriceApprovalCheckDTO();
                    customerSupplyPriceApprovalCheckDTO.setId(id);
                    customerSupplyPriceApprovalCheckDTO.setSkuId(sku.getId());
                    msg.add(customerSupplyPriceApprovalCheckDTO);
                }
            } else {
                SupplyPriceApprovalCheckDTO customerSupplyPriceApprovalCheckDTO = new SupplyPriceApprovalCheckDTO();
                customerSupplyPriceApprovalCheckDTO.setSkuId(sku.getId());
                customerSupplyPriceApprovalCheckDTO.setId(Long.valueOf(cusCustomerId));
                if (customerVO != null) {
                    customerSupplyPriceApprovalCheckDTO.setName(customerVO.getCustomerName());
                }
                msg.add(customerSupplyPriceApprovalCheckDTO);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<SupplyPriceApprovalCheckDTO> checkSupplyPriceValidity(List<Long> cusCustomerIdList, String type, List<Long> skuIdList, List<Sku> skuList, List<CustomerVO> customerVOS, Long psCustomerApprovalId, List<SaveCustomerSkuSupplyPriceDTO> customerSkuSupplyPriceList, List<PsCustomerSkuSupplyPrice> psCustomerSkuSupplyPriceArrayList) {
        void var12_16;
        ArrayList<SupplyPriceApprovalCheckDTO> msg = new ArrayList<SupplyPriceApprovalCheckDTO>();
        List psCustomerSkuSupplyPriceList = this.psCustomerSkuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(PsCustomerSkuSupplyPrice::getCusCustomerId, cusCustomerIdList)).in(PsCustomerSkuSupplyPrice::getPsSkuId, skuIdList)).eq(PsCustomerSkuSupplyPrice::getType, (Object)type)).eq(PsCustomerSkuSupplyPrice::getStatus, (Object)CustomerSupplyPriceEnum.SupplyPriceStatusEnum.TO_BE_EFFECTIVE.getValue()));
        if (CollUtil.isNotEmpty(psCustomerSkuSupplyPriceArrayList)) {
            psCustomerSkuSupplyPriceList.addAll(psCustomerSkuSupplyPriceArrayList);
        } else {
            for (Long l : cusCustomerIdList) {
                for (SaveCustomerSkuSupplyPriceDTO saveCustomerSkuSupplyPriceDTO : customerSkuSupplyPriceList) {
                    PsCustomerSkuSupplyPrice psCustomerApprovalSkuDTO = new PsCustomerSkuSupplyPrice();
                    psCustomerApprovalSkuDTO.setCusCustomerId(l);
                    BeanConvertUtil.copyProperties(saveCustomerSkuSupplyPriceDTO, psCustomerApprovalSkuDTO);
                    psCustomerSkuSupplyPriceList.add(psCustomerApprovalSkuDTO);
                }
            }
        }
        Map<String, List<PsCustomerSkuSupplyPrice>> map = psCustomerSkuSupplyPriceList.stream().collect(Collectors.groupingBy(v -> v.getCusCustomerId() + "_" + v.getPsSkuId()));
        for (Map.Entry<String, List<PsCustomerSkuSupplyPrice>> entry : map.entrySet()) {
            List<PsCustomerSkuSupplyPrice> psCustomerSkuSupplyPrices = entry.getValue();
            if (psCustomerSkuSupplyPrices.size() <= 1) continue;
            Iterator<Map.Entry<String, List<PsCustomerApprovalSkuDTO>>> dateList = new ArrayList();
            for (PsCustomerSkuSupplyPrice saveCustomerSkuSupplyPriceDTO : psCustomerSkuSupplyPrices) {
                dateList.add((Map.Entry<String, List<PsCustomerApprovalSkuDTO>>)((Object)(DateUtil.formatDateTime((Date)saveCustomerSkuSupplyPriceDTO.getEffectiveTime()) + "/" + DateUtil.formatDateTime((Date)saveCustomerSkuSupplyPriceDTO.getInvalidTime()))));
            }
            String key = entry.getKey();
            Sku sku = skuList.stream().filter(s -> ((PsCustomerSkuSupplyPrice)psCustomerSkuSupplyPrices.get(0)).getPsSkuId().equals(s.getId())).findAny().orElse(null);
            List<Object> idList = CollUtil.newArrayList((Object[])new Long[0]);
            if (CollUtil.isNotEmpty(psCustomerSkuSupplyPriceArrayList)) {
                List ids = psCustomerSkuSupplyPrices.stream().map(BaseDo::getId).collect(Collectors.toList());
                idList = psCustomerSkuSupplyPriceArrayList.stream().filter(item -> ids.contains(item.getId())).map(BaseDo::getId).collect(Collectors.toList());
            }
            this.getFailMsg((List<SupplyPriceApprovalCheckDTO>)msg, key, sku, customerVOS, (List<String>)((Object)dateList), idList);
        }
        ArrayList<PsCustomerApprovalSkuDTO> arrayList = new ArrayList<PsCustomerApprovalSkuDTO>();
        if (CollUtil.isNotEmpty(psCustomerSkuSupplyPriceArrayList)) {
            List<PsCustomerApprovalSkuDTO> list = BeanConvertUtil.convertList(psCustomerSkuSupplyPriceArrayList, PsCustomerApprovalSkuDTO.class);
        } else {
            for (Long id : cusCustomerIdList) {
                for (SaveCustomerSkuSupplyPriceDTO saveCustomerSkuSupplyPriceDTO : customerSkuSupplyPriceList) {
                    PsCustomerApprovalSkuDTO psCustomerApprovalSkuDTO = new PsCustomerApprovalSkuDTO();
                    psCustomerApprovalSkuDTO.setCusCustomerId(id);
                    BeanConvertUtil.copyProperties(saveCustomerSkuSupplyPriceDTO, psCustomerApprovalSkuDTO);
                    arrayList.add(psCustomerApprovalSkuDTO);
                }
            }
        }
        List list = this.psCustomerApprovalSkuService.selectApprovalSku(psCustomerApprovalId, skuIdList, cusCustomerIdList, type);
        var12_16.addAll(list);
        Map<String, List<PsCustomerApprovalSkuDTO>> skuMap = var12_16.stream().collect(Collectors.groupingBy(v -> v.getCusCustomerId() + "_" + v.getPsSkuId()));
        for (Map.Entry<String, List<PsCustomerApprovalSkuDTO>> longListEntry : skuMap.entrySet()) {
            List<PsCustomerApprovalSkuDTO> psCustomerSkuSupplyPrices = longListEntry.getValue();
            if (psCustomerSkuSupplyPrices.size() <= 1) continue;
            ArrayList<String> dateList = new ArrayList<String>();
            for (PsCustomerApprovalSkuDTO saveCustomerSkuSupplyPriceDTO : psCustomerSkuSupplyPrices) {
                dateList.add(DateUtil.formatDateTime((Date)saveCustomerSkuSupplyPriceDTO.getEffectiveTime()) + "/" + DateUtil.formatDateTime((Date)saveCustomerSkuSupplyPriceDTO.getInvalidTime()));
            }
            String key = longListEntry.getKey();
            Sku sku = skuList.stream().filter(s -> ((PsCustomerApprovalSkuDTO)psCustomerSkuSupplyPrices.get(0)).getPsSkuId().equals(s.getId())).findAny().orElse(null);
            List<Object> idList = CollUtil.newArrayList((Object[])new Long[0]);
            if (CollUtil.isNotEmpty(psCustomerSkuSupplyPriceArrayList)) {
                List ids = psCustomerSkuSupplyPrices.stream().map(PsCustomerApprovalSkuDTO::getId).collect(Collectors.toList());
                idList = psCustomerSkuSupplyPriceArrayList.stream().filter(item -> ids.contains(item.getId())).map(BaseDo::getId).collect(Collectors.toList());
            }
            this.getFailMsg(msg, key, sku, customerVOS, dateList, idList);
        }
        if (CollUtil.isNotEmpty(msg) && CollUtil.isEmpty(psCustomerSkuSupplyPriceArrayList)) {
            Map<Long, List<SupplyPriceApprovalCheckDTO>> msgMap = msg.stream().collect(Collectors.groupingBy(SupplyPriceApprovalCheckDTO::getSkuId));
            ArrayList dtoList = CollUtil.newArrayList((Object[])new SupplyPriceApprovalCheckDTO[0]);
            for (Map.Entry<Long, List<SupplyPriceApprovalCheckDTO>> longListEntry : msgMap.entrySet()) {
                SupplyPriceApprovalCheckDTO customerSupplyPriceApprovalCheckDTO = new SupplyPriceApprovalCheckDTO();
                customerSupplyPriceApprovalCheckDTO.setSkuId(longListEntry.getKey());
                customerSupplyPriceApprovalCheckDTO.setName(longListEntry.getValue().stream().map(SupplyPriceApprovalCheckDTO::getName).distinct().collect(Collectors.joining()));
                dtoList.add(customerSupplyPriceApprovalCheckDTO);
            }
            return dtoList;
        }
        return msg;
    }

    public void removeBatchApproval(ApiRequest<List<Long>> request) {
        List approvalIds = (List)request.getJsonData();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)approvalIds), (String)"\u5ba1\u6279\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<PsCustomerSupplyPriceApproval> psCustomerSupplyPriceApprovals = new ArrayList<PsCustomerSupplyPriceApproval>();
        ArrayList psCustomerApprovalSkuArrayList = new ArrayList();
        ArrayList psCustomerApprovals = new ArrayList();
        for (Long approvalId : approvalIds) {
            PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval = (PsCustomerSupplyPriceApproval)this.psCustomerSupplyPriceApprovalService.getById((Serializable)approvalId);
            Assert.notNull((Object)psCustomerSupplyPriceApproval, (String)(approvalId + " \u7533\u8bf7\u5355\u4e0d\u5b58\u5728"));
            Assert.isTrue((CustomerSupplyPriceEnum.ApprovalStatusEnum.TO_SUBMIT.getValue().equals(psCustomerSupplyPriceApproval.getStatus()) || CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_REJECT.getValue().equals(psCustomerSupplyPriceApproval.getStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u5355\u4e3a\u5f85\u63d0\u4ea4\u6216\u5ba1\u6279\u9a73\u56de\u624d\u53ef\u5220\u9664");
            psCustomerSupplyPriceApprovals.add(psCustomerSupplyPriceApproval);
            List psCustomerApprovalSkuList = this.psCustomerApprovalSkuService.list((Wrapper)new QueryWrapper().lambda().eq(PsCustomerApprovalSku::getPsCustomerSupplyPriceApprovalId, (Object)approvalId));
            psCustomerApprovalSkuArrayList.addAll(psCustomerApprovalSkuList);
            List psCustomerApprovalList = this.psCustomerApprovalService.list((Wrapper)new QueryWrapper().lambda().eq(PsCustomerApproval::getPsCustomerSupplyPriceApprovalId, (Object)approvalId));
            psCustomerApprovals.addAll(psCustomerApprovalList);
        }
        this.psCustomerSupplyPriceApprovalService.removeBatchApproval(psCustomerSupplyPriceApprovals, psCustomerApprovalSkuArrayList, psCustomerApprovals);
    }

    public CustomerSupplyPriceApprovalDTO selectApprovalDetails(ApiRequest<Void> request) {
        Assert.isTrue((request.getDataId() != -1L ? 1 : 0) != 0, (String)"\u5ba1\u6279\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        PsCustomerSupplyPriceApproval customerSupplyPriceApproval = (PsCustomerSupplyPriceApproval)this.psCustomerSupplyPriceApprovalService.getById((Serializable)Long.valueOf(request.getDataId()));
        Assert.notNull((Object)customerSupplyPriceApproval, (String)"\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
        CustomerSupplyPriceApprovalDTO customerSupplyPriceApprovalDTO = new CustomerSupplyPriceApprovalDTO();
        BeanConvertUtil.copyProperties(customerSupplyPriceApproval, customerSupplyPriceApprovalDTO);
        List<Long> customerIdList = this.psCustomerApprovalService.list((Wrapper)new QueryWrapper().lambda().eq(PsCustomerApproval::getPsCustomerSupplyPriceApprovalId, (Object)customerSupplyPriceApproval.getId())).stream().map(PsCustomerApproval::getCusCustomerId).collect(Collectors.toList());
        List<CustomerVO> customerVOList = this.cusAdapter.queryCustomerByIds(customerIdList);
        List<CustomerDTO> customerDTOS = BeanConvertUtil.convertList(customerVOList, CustomerDTO.class);
        customerSupplyPriceApprovalDTO.setCustomerList(customerDTOS);
        return customerSupplyPriceApprovalDTO;
    }

    public List<CustomerApprovalSkuDTO> selectApprovalSkuList(ApiRequest<QuerySkuSupplyPriceDTO> request) {
        List customerApprovalSkuDTOS = this.psCustomerApprovalSkuService.selectApprovalSkuList((QuerySkuSupplyPriceDTO)request.getJsonData());
        if (CollUtil.isEmpty((Collection)customerApprovalSkuDTOS)) {
            return CollUtil.newArrayList((Object[])new CustomerApprovalSkuDTO[0]);
        }
        List skuIds = customerApprovalSkuDTOS.stream().map(CustomerApprovalSkuDTO::getPsSkuId).collect(Collectors.toList());
        List<String> skuCodeList = customerApprovalSkuDTOS.stream().map(CustomerApprovalSkuDTO::getSkuCode).collect(Collectors.toList());
        String priceConfigPlace = this.mdmAdapter.selectMdmSystemConfig("v_price_config_order_price_place");
        int priceConfigValue = NumberUtil.parseInt((String)priceConfigPlace, (Integer)4);
        List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(skuCodeList);
        for (CustomerApprovalSkuDTO dto : customerApprovalSkuDTOS) {
            SgBStorageCostVo sgBStorageCostVo;
            List skuBarCodes;
            dto.setCounterPrice(BigDecimalUtils.convert(dto.getCounterPrice(), priceConfigValue));
            dto.setSupplyPrice(BigDecimalUtils.convert(dto.getSupplyPrice(), priceConfigValue));
            if (CollUtil.isNotEmpty((Collection)skuBarCodeList) && CollUtil.isNotEmpty(skuBarCodes = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(dto.getPsSkuId())).collect(Collectors.toList()))) {
                dto.setBarCode(skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(",")));
            }
            if (!CollUtil.isNotEmpty(sgBStorageCostVos) || (sgBStorageCostVo = (SgBStorageCostVo)sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(dto.getSkuCode())).findAny().orElse(null)) == null) continue;
            dto.setSgCostPrice(sgBStorageCostVo.getPriceCost());
        }
        return customerApprovalSkuDTOS;
    }

    public Page<CustomerApprovalDTO> selectApprovalPage(ApiRequest<SpuQueryDTO> request) {
        Page page;
        List records;
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCustomerName()) || StrUtil.isNotBlank((CharSequence)queryDTO.getCustomerCode()) || CollUtil.isNotEmpty((Collection)queryDTO.getMdmDepartmentIdList())) {
            CustomerQueryInfoDTO customerQueryInfoDTO = new CustomerQueryInfoDTO();
            customerQueryInfoDTO.setCusCustomerCode(queryDTO.getCustomerCode());
            customerQueryInfoDTO.setCusCustomerName(queryDTO.getCustomerName());
            customerQueryInfoDTO.setMdmDepartmentIdList(queryDTO.getMdmDepartmentIdList());
            List<CustomerVO> customerVOS = this.cusAdapter.queryCustomerByOtherCondition(customerQueryInfoDTO);
            if (CollUtil.isEmpty(customerVOS)) {
                return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
            }
            List cusIds = customerVOS.stream().map(CustomerVO::getId).collect(Collectors.toList());
            List approvalIds = this.psCustomerApprovalService.list((Wrapper)new QueryWrapper().lambda().in(PsCustomerApproval::getCusCustomerId, cusIds)).stream().map(PsCustomerApproval::getPsCustomerSupplyPriceApprovalId).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(approvalIds)) {
                return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
            }
            queryDTO.setPsCustomerApprovalIds(approvalIds);
        }
        if (CollUtil.isEmpty((Collection)(records = (page = this.psCustomerSupplyPriceApprovalService.selectApprovalPage(queryDTO)).getRecords()))) {
            return page;
        }
        List ids = records.stream().map(CustomerApprovalDTO::getId).collect(Collectors.toList());
        List psCustomerApprovals = this.psCustomerApprovalService.list((Wrapper)new QueryWrapper().lambda().in(PsCustomerApproval::getPsCustomerSupplyPriceApprovalId, ids));
        List<Long> customerIds = psCustomerApprovals.stream().map(PsCustomerApproval::getCusCustomerId).distinct().collect(Collectors.toList());
        List psCustomerApprovalSkuList = this.psCustomerApprovalSkuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(PsCustomerApprovalSku::getPsCustomerSupplyPriceApprovalId, ids)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        List skuIds = psCustomerApprovalSkuList.stream().map(PsCustomerApprovalSku::getPsSkuId).distinct().collect(Collectors.toList());
        InteriorSkuDTO spuQueryDTO = new InteriorSkuDTO();
        spuQueryDTO.setSkuIdList(skuIds);
        List<QueryInteriorSkuDTO> queryInteriorSkuDTOS = this.skuBiz.selectSkuList(spuQueryDTO);
        List<CustomerVO> customerVOS = this.cusAdapter.queryCustomerByIds(customerIds);
        List<Long> mdmDepartmentIdList = customerVOS.stream().map(CustomerVO::getMdmDepartmentId).distinct().collect(Collectors.toList());
        List<OrgDepartment> orgDepartments = this.orgAdapter.selectOrgDepartments(mdmDepartmentIdList, null, null);
        for (CustomerApprovalDTO dto : page.getRecords()) {
            List<Long> cusCustomerIds = psCustomerApprovals.stream().filter(s -> s.getPsCustomerSupplyPriceApprovalId().equals(dto.getId())).map(PsCustomerApproval::getCusCustomerId).toList();
            List<CustomerVO> customerVOList = customerVOS.stream().filter(s -> cusCustomerIds.contains(s.getId())).toList();
            ArrayList<CallSite> customerNameList = new ArrayList<CallSite>();
            ArrayList<CallSite> mdmDepartmentNameList = new ArrayList<CallSite>();
            for (CustomerVO customerVO : customerVOList) {
                customerNameList.add((CallSite)((Object)(customerVO.getCustomerName() + "(" + customerVO.getCustomerCode() + ")")));
                OrgDepartment orgDepartment = orgDepartments.stream().filter(item -> item.getId().equals(customerVO.getMdmDepartmentId())).findAny().orElse(null);
                if (orgDepartment == null) continue;
                mdmDepartmentNameList.add((CallSite)((Object)(orgDepartment.getName() + "(" + orgDepartment.getCode() + ")")));
            }
            dto.setCustomerName(String.join((CharSequence)",", customerNameList));
            List departmentName = mdmDepartmentNameList.stream().distinct().collect(Collectors.toList());
            dto.setMdmDepartmentName(String.join((CharSequence)",", departmentName));
            List<PsCustomerApprovalSku> customerApprovalSkuList = psCustomerApprovalSkuList.stream().filter(item -> item.getPsCustomerSupplyPriceApprovalId().equals(dto.getId())).toList();
            List<Long> skuIdList = customerApprovalSkuList.stream().map(PsCustomerApprovalSku::getPsSkuId).distinct().toList();
            List<QueryInteriorSkuDTO> queryInteriorSkuDTOList = queryInteriorSkuDTOS.stream().filter(item -> skuIdList.contains(item.getSkuId())).toList();
            ArrayList<CallSite> brandNameList = new ArrayList<CallSite>();
            for (QueryInteriorSkuDTO queryInteriorSkuDTO : queryInteriorSkuDTOList) {
                String brandInfo = queryInteriorSkuDTO.getPsBrandName() + "(" + queryInteriorSkuDTO.getBrandCode() + ")";
                if (brandNameList.contains(brandInfo)) continue;
                brandNameList.add((CallSite)((Object)brandInfo));
            }
            dto.setPsBrandName(String.join((CharSequence)",", brandNameList));
        }
        return page;
    }

    public void cancelApproval(ApiRequest<Void> request) {
        long dataId = request.getDataId();
        Assert.isTrue((dataId != -1L ? 1 : 0) != 0, (String)"\u5ba1\u6279\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        PsCustomerSupplyPriceApproval psCustomerSupplyPriceApproval = (PsCustomerSupplyPriceApproval)this.psCustomerSupplyPriceApprovalService.getById((Serializable)Long.valueOf(dataId));
        Assert.notNull((Object)psCustomerSupplyPriceApproval, (String)"\u5ba1\u6279\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)CustomerSupplyPriceEnum.ApprovalStatusEnum.APPROVAL_ING.getValue().equals(psCustomerSupplyPriceApproval.getStatus()), (String)"\u5ba1\u6279\u5355\u4e0d\u662f\u5ba1\u6838\u4e2d\u72b6\u6001");
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse apiResponse = this.oaAdapter.terminateWorkFlow(psCustomerSupplyPriceApproval.getOaId(), JSON.toJSONString((Object)user));
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        psCustomerSupplyPriceApproval.setStatus(CustomerSupplyPriceEnum.ApprovalStatusEnum.TO_SUBMIT.getValue());
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psCustomerSupplyPriceApproval);
        this.psCustomerSupplyPriceApprovalService.updateById((Object)psCustomerSupplyPriceApproval);
        InnerLog.addLog((Long)psCustomerSupplyPriceApproval.getId(), (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u64a4\u9500", (String)(SupplyPriceTypeEnums.ONE.getCode().equals(psCustomerSupplyPriceApproval.getType()) ? InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_APPROVAL.getCode() : InnerLogTypeEnum.CUSTOMER_SUPPLY_PRICE_VIRTUAL_APPROVAL.getCode()), null, (String)"\u5ba2\u6237\u4f9b\u8d27\u4ef7\u5ba1\u6279\u5355\u64a4\u9500");
    }

    public TableCountDTO selectTableSum(ApiRequest<SpuQueryDTO> request) {
        TableCountDTO customerApprovalSumDTO = new TableCountDTO();
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getCustomerName()) || StrUtil.isNotBlank((CharSequence)queryDTO.getCustomerCode()) || CollUtil.isNotEmpty((Collection)queryDTO.getMdmDepartmentIdList())) {
            CustomerQueryInfoDTO customerQueryInfoDTO = new CustomerQueryInfoDTO();
            customerQueryInfoDTO.setCusCustomerCode(queryDTO.getCustomerCode());
            customerQueryInfoDTO.setCusCustomerName(queryDTO.getCustomerName());
            customerQueryInfoDTO.setMdmDepartmentIdList(queryDTO.getMdmDepartmentIdList());
            List<CustomerVO> customerVOS = this.cusAdapter.queryCustomerByOtherCondition(customerQueryInfoDTO);
            if (CollUtil.isEmpty(customerVOS)) {
                return customerApprovalSumDTO;
            }
            List cusIds = customerVOS.stream().map(CustomerVO::getId).collect(Collectors.toList());
            List approvalIds = this.psCustomerApprovalService.list((Wrapper)new QueryWrapper().lambda().in(PsCustomerApproval::getCusCustomerId, cusIds)).stream().map(PsCustomerApproval::getPsCustomerSupplyPriceApprovalId).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(approvalIds)) {
                return customerApprovalSumDTO;
            }
            queryDTO.setPsCustomerApprovalIds(approvalIds);
        }
        TableCountDTO tableSumDTO = this.psCustomerSupplyPriceApprovalService.selectApprovalList(queryDTO);
        customerApprovalSumDTO.setFirstTableNum(this.covertCount(tableSumDTO.getFirstTableNumL()));
        customerApprovalSumDTO.setSecondTableNum(this.covertCount(tableSumDTO.getSecondTableNumL()));
        customerApprovalSumDTO.setThirdTableNum(this.covertCount(tableSumDTO.getThirdTableNumL()));
        return customerApprovalSumDTO;
    }

    public String covertCount(Long count) {
        if (count > 9999L) {
            return "9999+";
        }
        return String.valueOf(count);
    }
}

