/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.model.search.SearchCondition;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.mdm.api.model.vo.user.UserVO;
import com.xinqiyi.ps.api.model.vo.PsFavoriteVO;
import com.xinqiyi.ps.dao.repository.PsFavoriteDetailsService;
import com.xinqiyi.ps.dao.repository.PsFavoriteService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.enums.PsFavouriteTypeEnum;
import com.xinqiyi.ps.model.dto.enums.StoreTypeEnum;
import com.xinqiyi.ps.model.dto.favourite.PsFavoriteDTO;
import com.xinqiyi.ps.model.dto.favourite.QueryFavouriteLogDetailDTO;
import com.xinqiyi.ps.model.dto.page.PageResult;
import com.xinqiyi.ps.model.dto.spu.SpuQueryV2DTO;
import com.xinqiyi.ps.model.entity.PsFavorite;
import com.xinqiyi.ps.model.entity.PsFavoriteDetails;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="psFavoriteBiz")
public class PsFavoriteBiz {
    private static final Logger log = LoggerFactory.getLogger(PsFavoriteBiz.class);
    private final PsFavoriteService favoriteService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final IdSequenceGenerator idSequence;
    private final GateWayWebAuthService gateWayWebAuthService;
    private final PsFavoriteDetailsService psFavoriteDetailsService;
    private final StoreService storeService;
    private final SpuService spuService;
    private final MdmAdapter mdmAdapter;

    public Long save(PsFavoriteDTO dto) {
        Assert.notNull((Object)dto.getStoreId(), (String)"\u5e97\u94faid\u4e0d\u5f97\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)dto.getSpuId(), (String)"spuId\u4e0d\u5f97\u4e3a\u7a7a", (Object[])new Object[0]);
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Store store = (Store)this.storeService.getById((Serializable)dto.getStoreId());
        Long customerId = null;
        String customerCode = "";
        String customerName = "";
        if (StoreTypeEnum.ONE.getCode().equals(store.getStoreType())) {
            customerId = currentLoginUserInfo.getEmployeeId();
            UserVO userVO = this.mdmAdapter.queryUserByUserId(customerId);
            if (userVO != null) {
                customerCode = userVO.getCode();
                customerName = userVO.getName();
            }
        } else {
            customerId = currentLoginUserInfo.getCustomerId();
            customerCode = currentLoginUserInfo.getCustomerCode();
            customerName = currentLoginUserInfo.getCustomerName();
        }
        PsFavorite psFavorite = (PsFavorite)this.favoriteService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PsFavorite.class).eq(PsFavorite::getStoreId, (Object)dto.getStoreId())).eq(PsFavorite::getSpuId, (Object)dto.getSpuId())).eq(PsFavorite::getCusCustomerId, (Object)customerId));
        if (psFavorite != null) {
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psFavorite);
            psFavorite.setType(dto.getType());
            this.favoriteService.saveOrUpdate((Object)psFavorite);
            PsFavoriteDetails psFavoriteDetails = new PsFavoriteDetails(psFavorite);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psFavoriteDetails);
            this.psFavoriteDetailsService.save((Object)psFavoriteDetails);
            return psFavorite.getId();
        }
        psFavorite = new PsFavorite();
        BeanConvertUtil.copyProperties(dto, psFavorite);
        psFavorite.setId(this.idSequence.generateId(Store.class));
        psFavorite.setType(PsFavouriteTypeEnum.FAVOURITE.getCode());
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psFavorite);
        psFavorite.setStoreName(store.getName());
        psFavorite.setCusCustomerCode(customerCode);
        psFavorite.setCusCustomerId(customerId);
        psFavorite.setCusCustomerName(customerName);
        Spu spu = (Spu)this.spuService.getById((Serializable)dto.getSpuId());
        psFavorite.setSpuCode(spu.getCode());
        this.favoriteService.save((Object)psFavorite);
        PsFavoriteDetails psFavoriteDetails = new PsFavoriteDetails(psFavorite);
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psFavoriteDetails);
        this.psFavoriteDetailsService.save((Object)psFavoriteDetails);
        return psFavorite.getId();
    }

    public List<PsFavoriteVO> queryFavoriteNum(PsFavoriteDTO dto) {
        return this.favoriteService.queryFavoriteNum(dto);
    }

    public PageResult queryOperateDetail(QueryFavouriteLogDetailDTO dto) {
        this.covertSearchCondition(dto);
        List favorites = this.favoriteService.queryLogDetail(dto);
        if (CollUtil.isEmpty((Collection)favorites)) {
            return new PageResult(dto.getPageNum(), dto.getPageSize(), 0L);
        }
        List<Long> favIds = favorites.stream().map(BaseDo::getId).collect(Collectors.toList());
        Map<Long, PsFavorite> favIdFavMap = favorites.stream().collect(Collectors.toMap(BaseDo::getId, it -> it));
        Page<PsFavoriteDetails> operateLogs = this.getOperateLog(favIds, dto);
        PageResult pages = new PageResult((int)operateLogs.getCurrent(), (int)operateLogs.getSize(), operateLogs.getTotal());
        ArrayList<PsFavoriteVO> resultList = new ArrayList<PsFavoriteVO>();
        for (PsFavoriteDetails favLog : operateLogs.getRecords()) {
            PsFavoriteVO psFavoriteVO = new PsFavoriteVO();
            psFavoriteVO.setId(favLog.getId());
            psFavoriteVO.setCreateTime(favLog.getCreateTime());
            PsFavorite favorite = favIdFavMap.getOrDefault(favLog.getPsFavoriteId(), new PsFavorite());
            psFavoriteVO.setCusCustomerName(favorite.getCusCustomerName());
            psFavoriteVO.setCusCustomerCode(favorite.getCusCustomerCode());
            psFavoriteVO.setType(favLog.getType());
            resultList.add(psFavoriteVO);
        }
        return pages.setData(resultList);
    }

    private Page<PsFavoriteDetails> getOperateLog(List<Long> favIds, QueryFavouriteLogDetailDTO dto) {
        Page page = new Page((long)dto.getPageNum(), (long)dto.getPageSize());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(PsFavoriteDetails.class).in(PsFavoriteDetails::getPsFavoriteId, favIds);
        if (CollUtil.isNotEmpty((Collection)dto.getTypeList())) {
            queryWrapper.in(PsFavoriteDetails::getType, (Collection)dto.getTypeList());
        }
        if (null != dto.getBeginTime()) {
            queryWrapper.ge(BaseDo::getCreateTime, (Object)dto.getBeginTime());
        }
        if (null != dto.getEndTime()) {
            queryWrapper.le(BaseDo::getCreateTime, (Object)dto.getEndTime());
        }
        queryWrapper.orderByDesc(BaseDo::getCreateTime);
        return (Page)this.psFavoriteDetailsService.page((IPage)page, (Wrapper)queryWrapper);
    }

    public void handleFavorite(SpuQueryV2DTO spuQueryDTO) {
        if (Boolean.TRUE.equals(spuQueryDTO.getIsFavourite())) {
            LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            List spuList = this.favoriteService.getSpuListByUserIdAndStoreId(Long.valueOf(currentLoginUserInfo.getUserId()), spuQueryDTO.getPsStoreId());
            spuQueryDTO.setSpuIdList(spuList);
        }
    }

    public List<PsFavoriteVO> queryStoreFavDetail(PsFavoriteDTO dto) {
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        dto.setCusCustomerId(currentLoginUserInfo.getCustomerId());
        return this.favoriteService.queryStoreFavDetail(dto);
    }

    public void batchCancel(PsFavoriteDTO jsonData) {
        List list = new ArrayList();
        if (Boolean.TRUE.equals(jsonData.getIsAllCheck())) {
            Assert.notNull((Object)jsonData.getStoreId(), (String)"\u5168\u9009\u65f6\uff0c\u5e97\u94faid\u4e0d\u5f97\u4e3a\u7a7a", (Object[])new Object[0]);
            LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            Long customerId = currentLoginUserInfo.getCustomerId();
            list = this.favoriteService.list((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(PsFavorite.class).eq(PsFavorite::getCusCustomerId, (Object)customerId)).eq(PsFavorite::getStoreId, (Object)jsonData.getStoreId())).eq(PsFavorite::getType, (Object)PsFavouriteTypeEnum.FAVOURITE.getCode()));
        } else {
            Assert.notEmpty((Iterable)jsonData.getIds(), (String)"ids\u4e0d\u5f97\u4e3a\u7a7a", (Object[])new Object[0]);
            list = this.favoriteService.list((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(PsFavorite.class).in(BaseDo::getId, (Collection)jsonData.getIds())).eq(PsFavorite::getType, (Object)PsFavouriteTypeEnum.FAVOURITE.getCode()));
        }
        ArrayList<PsFavoriteDetails> details = new ArrayList<PsFavoriteDetails>();
        for (PsFavorite favorite : list) {
            favorite.setType(PsFavouriteTypeEnum.CANCEL.getCode());
            PsFavoriteDetails psFavoriteDetails = new PsFavoriteDetails(favorite);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psFavoriteDetails);
            details.add(psFavoriteDetails);
        }
        this.favoriteService.saveOrUpdateBatch(list);
        this.psFavoriteDetailsService.saveBatch(details);
    }

    private void covertSearchCondition(QueryFavouriteLogDetailDTO dto) {
        String[] likeSpit;
        String[] split;
        String regex = "(?<!\\\\)\n";
        if (dto == null) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getCusCustomerName())) {
            split = dto.getCusCustomerName().split(regex);
            if (split.length == 1) {
                likeSpit = split[0].split(" ");
                ArrayList<String> likeCusCustomerNameList = new ArrayList<String>(Arrays.asList(likeSpit));
                dto.setLikeCusCustomerNameList(likeCusCustomerNameList);
            } else {
                dto.setCusCustomerNameList(Arrays.asList(split));
            }
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getCusCustomerCode())) {
            split = dto.getCusCustomerCode().split(regex);
            if (split.length == 1) {
                likeSpit = split[0].split(" ");
                ArrayList<String> likeCusCustomerCodeList = new ArrayList<String>(Arrays.asList(likeSpit));
                dto.setLikeCusCustomerCodeList(likeCusCustomerCodeList);
            } else {
                dto.setCusCustomerCodeList(Arrays.asList(split));
            }
        }
    }

    private String getLikeFieldName(SearchCondition item) {
        Object camelCase = item.getColumnName();
        char firstChar = Character.toUpperCase(((String)camelCase).charAt(0));
        camelCase = firstChar + ((String)camelCase).substring(1);
        return "like" + (String)camelCase + "List";
    }

    private void setValueByAttributeName(String attributeName, QueryFavouriteLogDetailDTO dto, SearchCondition item) {
        try {
            Field field = QueryFavouriteLogDetailDTO.class.getDeclaredField(attributeName);
            field.setAccessible(true);
            field.set(dto, Arrays.asList(item.getSearchValue().split(",")));
        }
        catch (Exception e) {
            log.info("[\u5546\u54c1\u6536\u85cf] \u8d4b\u503cdto\u62a5\u9519, e:{}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private void setValueByGeOrLeAttributeName(String attributeName, QueryFavouriteLogDetailDTO dto, SearchCondition item) {
        try {
            Field field = QueryFavouriteLogDetailDTO.class.getDeclaredField(attributeName);
            field.setAccessible(true);
            field.set(dto, item.getSearchValue());
        }
        catch (Exception e) {
            log.info("[\u5546\u54c1\u6536\u85cf\u67e5\u8be2] \u8d4b\u503cdto\u62a5\u9519, e:{}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    public boolean spuIsFavourited(Long psStoreId, Long userId, Long spuId) {
        PsFavorite one = (PsFavorite)this.favoriteService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PsFavorite.class).eq(PsFavorite::getStoreId, (Object)psStoreId)).eq(PsFavorite::getSpuId, (Object)spuId)).eq(BaseDo::getCreateUserId, (Object)userId)).eq(PsFavorite::getType, (Object)PsFavouriteTypeEnum.FAVOURITE.getCode())).last("LIMIT 1"));
        return one != null;
    }

    public PsFavoriteBiz(PsFavoriteService favoriteService, BaseDaoInitialService baseDaoInitialService, IdSequenceGenerator idSequence, GateWayWebAuthService gateWayWebAuthService, PsFavoriteDetailsService psFavoriteDetailsService, StoreService storeService, SpuService spuService, MdmAdapter mdmAdapter) {
        this.favoriteService = favoriteService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.idSequence = idSequence;
        this.gateWayWebAuthService = gateWayWebAuthService;
        this.psFavoriteDetailsService = psFavoriteDetailsService;
        this.storeService = storeService;
        this.spuService = spuService;
        this.mdmAdapter = mdmAdapter;
    }
}

