/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.dynamicform.dao.repository.DictRedisRepository;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.DistributedSequenceGenerator;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.sequence.model.CycleType;
import com.xinqiyi.framework.sequence.model.SequenceInfo;
import com.xinqiyi.ps.api.model.vo.PsSceneVO;
import com.xinqiyi.ps.dao.repository.PsSceneService;
import com.xinqiyi.ps.dao.repository.PsSceneTypeService;
import com.xinqiyi.ps.model.dto.enums.SkuTypeEnums;
import com.xinqiyi.ps.model.dto.enums.SpuClassifyEnums;
import com.xinqiyi.ps.model.dto.scene.PsSceneDTO;
import com.xinqiyi.ps.model.dto.scene.PsSceneQueryDTO;
import com.xinqiyi.ps.model.dto.scene.PsSceneTypeDTO;
import com.xinqiyi.ps.model.entity.scene.PsScene;
import com.xinqiyi.ps.model.entity.scene.PsSceneType;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsSceneBiz {
    @Autowired
    private PsSceneService psSceneService;
    @Autowired
    private PsSceneTypeService psSceneTypeService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private DistributedSequenceGenerator distributedSequenceGenerator;
    @Autowired
    private DictRedisRepository dictRedisRepository;

    public Page<PsSceneDTO> queryList(PsSceneQueryDTO queryDTO) {
        Page pageQuery = new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
        Page page = (Page)this.psSceneService.page((IPage)pageQuery, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getSceneName()), PsScene::getSceneName, (Object)queryDTO.getSceneName())).eq(CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getCode()), PsScene::getCode, (Object)queryDTO.getCode()));
        List records = page.getRecords();
        Page<PsSceneDTO> psSceneDTOPage = BeanConvertUtil.convertPage(page, PsSceneDTO.class);
        List sceneDTOS = psSceneDTOPage.getRecords();
        if (CollUtil.isNotEmpty((Collection)records)) {
            List ids = records.stream().map(BaseDo::getId).collect(Collectors.toList());
            List list = this.psSceneTypeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(PsSceneType::getPsSceneId, ids)).isNull(PsSceneType::getBrandClassify));
            List brandClassifyList = this.psSceneTypeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(PsSceneType::getPsSceneId, ids)).isNotNull(PsSceneType::getBrandClassify));
            if (CollUtil.isNotEmpty((Collection)list)) {
                for (PsSceneDTO sceneDTO : sceneDTOS) {
                    ArrayList typeList = Lists.newArrayList();
                    for (PsSceneType sceneType : list) {
                        if (!sceneDTO.getId().equals(sceneType.getPsSceneId())) continue;
                        PsSceneTypeDTO typeDTO = new PsSceneTypeDTO();
                        BeanConvertUtil.copyProperties(sceneType, typeDTO);
                        typeList.add(typeDTO);
                    }
                    sceneDTO.setSceneTypeList((List)typeList);
                    sceneDTO.setBrandClassifyList(brandClassifyList.stream().filter(item -> ObjectUtil.equal((Object)item.getPsSceneId(), (Object)sceneDTO.getId())).map(PsSceneType::getBrandClassify).collect(Collectors.toList()));
                }
            }
        }
        return psSceneDTOPage;
    }

    public void updateScene(PsSceneDTO sceneDTO) {
        PsScene psScene = new PsScene();
        BeanConvertUtil.copyProperties(sceneDTO, psScene);
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psScene);
        List sceneTypeVOList = sceneDTO.getSceneTypeList();
        List<PsSceneType> psSceneTypes = BeanConvertUtil.convertList(sceneTypeVOList, PsSceneType.class);
        if (CollUtil.isNotEmpty((Collection)sceneDTO.getBrandClassifyList())) {
            for (String brandClassify : sceneDTO.getBrandClassifyList()) {
                PsSceneType psSceneType2 = new PsSceneType();
                psSceneType2.setBrandClassify(brandClassify);
                psSceneTypes.add(psSceneType2);
            }
        }
        if (CollUtil.isNotEmpty(psSceneTypes)) {
            Long id = psScene.getId();
            psSceneTypes.forEach(psSceneType -> {
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psSceneType);
                psSceneType.setPsSceneId(id);
                psSceneType.setId(this.idSequence.generateId(PsSceneType.class));
            });
        }
        this.psSceneService.updateScene(psScene, psSceneTypes);
    }

    public PsScene covertSave(String sceneName) {
        PsScene psScene = new PsScene();
        Long id = this.idSequence.generateId(PsScene.class);
        psScene.setId(id);
        psScene.setCode(this.getPsSceneCode());
        psScene.setSceneName(sceneName);
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psScene);
        return psScene;
    }

    public void insertScene(PsSceneVO sceneVO) {
        PsScene psScene = new PsScene();
        BeanConvertUtil.copyProperties(sceneVO, psScene);
        Long id = this.idSequence.generateId(PsScene.class);
        psScene.setId(id);
        psScene.setCode(this.getPsSceneCode());
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psScene);
        List sceneTypeVOList = sceneVO.getSceneTypeList();
        List<PsSceneType> psSceneTypes = BeanConvertUtil.convertList(sceneTypeVOList, PsSceneType.class);
        if (CollUtil.isNotEmpty((Collection)sceneVO.getBrandClassifyList())) {
            for (String brandClassify : sceneVO.getBrandClassifyList()) {
                PsSceneType psSceneType2 = new PsSceneType();
                psSceneType2.setBrandClassify(brandClassify);
                psSceneTypes.add(psSceneType2);
            }
        }
        if (CollUtil.isNotEmpty(psSceneTypes)) {
            psSceneTypes.forEach(psSceneType -> {
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psSceneType);
                psSceneType.setPsSceneId(id);
                psSceneType.setId(this.idSequence.generateId(PsSceneType.class));
            });
        }
        this.psSceneService.insertScene(psScene, psSceneTypes);
    }

    private String getPsSceneCode() {
        SequenceInfo sequenceInfo = new SequenceInfo();
        sequenceInfo.setName("ps_scene");
        sequenceInfo.setSequenceRegex("[[${#numbers.formatInteger(sn,3)}]]");
        sequenceInfo.setIncrementNumber(Long.valueOf(1L));
        sequenceInfo.setMaxNo(Long.valueOf(999999L));
        sequenceInfo.setStartNumber(Long.valueOf(1L));
        sequenceInfo.setCycleType(CycleType.DEFAULT.toString());
        String seqCode = this.distributedSequenceGenerator.buildSequence(sequenceInfo, null, false);
        PsScene psScene = this.psSceneService.getByCode(seqCode);
        while (psScene != null) {
            seqCode = this.distributedSequenceGenerator.buildSequence(sequenceInfo, null, false);
            psScene = this.psSceneService.getByCode(seqCode);
        }
        return seqCode;
    }

    List<String> selectByCode(String sceneCode) {
        PsScene psScene = this.psSceneService.getByCode(sceneCode);
        if (psScene == null) {
            return null;
        }
        List psSceneTypes = this.psSceneTypeService.selectBySceneId(psScene.getId());
        ArrayList<String> typeList = new ArrayList<String>();
        for (PsSceneType psSceneType : psSceneTypes) {
            String classify = psSceneType.getPsSpuClassify() == null ? "" : String.valueOf(psSceneType.getPsSpuClassify());
            String skuType = psSceneType.getPsSkuType() == null ? "" : String.valueOf(psSceneType.getPsSkuType());
            String type = classify + "_" + skuType;
            typeList.add(type);
        }
        return typeList;
    }

    public List<String> selectBrandClassifyByCode(String sceneCode) {
        PsScene psScene = this.psSceneService.getByCode(sceneCode);
        if (psScene == null) {
            return null;
        }
        return this.psSceneTypeService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsSceneType::getPsSceneId, (Object)psScene.getId())).isNotNull(PsSceneType::getBrandClassify)).stream().map(PsSceneType::getBrandClassify).collect(Collectors.toList());
    }

    public PsSceneDTO getByCode(PsSceneQueryDTO queryDTO) {
        Page<PsSceneDTO> psSceneDTOPage = this.queryList(queryDTO);
        if (CollUtil.isNotEmpty((Collection)psSceneDTOPage.getRecords())) {
            PsSceneDTO psSceneDTO = (PsSceneDTO)psSceneDTOPage.getRecords().get(0);
            for (PsSceneTypeDTO psSceneTypeDTO : psSceneDTO.getSceneTypeList()) {
                if (psSceneTypeDTO.getPsSkuType() != null) {
                    psSceneTypeDTO.setName(SpuClassifyEnums.getDescByCode((Integer)psSceneTypeDTO.getPsSpuClassify()) + "-" + SkuTypeEnums.getDescByCode((Integer)psSceneTypeDTO.getPsSkuType()));
                    continue;
                }
                psSceneTypeDTO.setName(SpuClassifyEnums.getDescByCode((Integer)psSceneTypeDTO.getPsSpuClassify()));
            }
            return psSceneDTO;
        }
        return null;
    }

    public List<String> getBySpu(PsSceneQueryDTO queryDTO) {
        Page<PsSceneDTO> psSceneDTOPage = this.queryList(queryDTO);
        if (CollUtil.isNotEmpty((Collection)psSceneDTOPage.getRecords())) {
            PsSceneDTO psSceneDTO = (PsSceneDTO)psSceneDTOPage.getRecords().get(0);
            List spuClassifyList = psSceneDTO.getSceneTypeList().stream().map(item -> String.valueOf(item.getPsSpuClassify())).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(spuClassifyList)) {
                return CollUtil.newArrayList((Object[])new String[0]);
            }
            List dictValueList = this.dictRedisRepository.selectDictValueListByCode("newcCassify");
            return dictValueList.stream().filter(item -> spuClassifyList.contains(item.getValueCode().toString())).map(DictValue::getName).collect(Collectors.toList());
        }
        return CollUtil.newArrayList((Object[])new String[0]);
    }
}

