/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.xinqiyi.fc.api.model.vo.ar.FcArExpenseVO;
import com.xinqiyi.fc.model.dto.ar.ArExpenseQueryDTO;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.dao.repository.CategoryService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuShelfService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.enums.InnerLogTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SkuShelfStatusEnums;
import com.xinqiyi.ps.model.dto.enums.StoreShelfConfigEnum;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.ps.model.dto.spu.PhyStorageDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.entity.Category;
import com.xinqiyi.ps.model.entity.SkuShelf;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.service.adapter.fc.FcArExpenseAdapter;
import com.xinqiyi.ps.service.business.PhyStorageBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsSkuShelfBiz {
    private static final Logger log = LoggerFactory.getLogger(PsSkuShelfBiz.class);
    @Autowired
    private SkuShelfService skuShelfService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private StoreService storeService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private PhyStorageBiz phyStorageBiz;
    @Autowired
    private FcArExpenseAdapter fcArExpenseAdapter;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private SkuService skuService;

    @LogAnnotation
    public void autoOffShelf(String param) {
        IPage result;
        List shelfList;
        if (StrUtil.isBlank((CharSequence)param)) {
            return;
        }
        Long psStoreId = Long.valueOf(param);
        Store store = (Store)this.storeService.getById((Serializable)psStoreId);
        if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store.getIsDisplayInventory())) {
            return;
        }
        List<Long> idList = Arrays.stream(store.getWholesaleInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        int current = 1;
        Page page = new Page((long)current, 100L);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SkuShelf::getPsStoreId, (Object)psStoreId)).eq(SkuShelf::getShelfStatus, (Object)SkuShelfStatusEnums.ENABLED.getCode())).orderByAsc(BaseDo::getId);
        while (!CollUtil.isEmpty((Collection)(shelfList = (result = this.skuShelfService.getBaseMapper().selectPage((IPage)page, (Wrapper)queryWrapper)).getRecords()))) {
            this.offShelf(shelfList, idList, store.getAvailableInventoryProportion());
            if ((long)current >= result.getPages()) break;
            page.setCurrent((long)(++current));
        }
    }

    private void offShelf(List<SkuShelf> shelfList, List<Long> idList, BigDecimal availableInventoryProportion) {
        List psSkuIdList = shelfList.stream().map(SkuShelf::getPsSkuId).collect(Collectors.toList());
        SpuQueryDTO spuQueryDTO = new SpuQueryDTO();
        spuQueryDTO.setPageSize(9999999);
        spuQueryDTO.setPageNum(1);
        spuQueryDTO.setSkuIdList(psSkuIdList);
        spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
        spuQueryDTO.setWarehouseIds(idList);
        ApiRequest request = new ApiRequest();
        request.setJsonData((Object)spuQueryDTO);
        Page<PhyStorageDTO> phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        ArrayList shelfArrayList = CollUtil.newArrayList((Object[])new SkuShelf[0]);
        for (SkuShelf shelf : shelfList) {
            BigDecimal totalQtyAvailable = phyStorageDTOPage.getRecords().stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)shelf.getPsSkuId())).map(PhyStorageDTO::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal qtyAvailable = totalQtyAvailable.multiply(availableInventoryProportion).divide(new BigDecimal("100"), 0, RoundingMode.DOWN);
            if (!BigDecimalUtils.lessThan(qtyAvailable, new BigDecimal("1"))) continue;
            shelf.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
            this.skuBiz.buildOnOrOffShelfInfo(shelf, null);
            shelfArrayList.add(shelf);
        }
        if (CollUtil.isNotEmpty((Collection)shelfArrayList)) {
            this.skuShelfService.updateBatchById((Collection)shelfArrayList);
            for (SkuShelf skuShelf : shelfArrayList) {
                InnerLog.addLog((Long)skuShelf.getId(), (String)"\u81ea\u52a8\u4e0b\u67b6", (String)InnerLogTypeEnum.PS_SKU_SHELF.getCode(), null, (String)"\u81ea\u52a8\u4e0b\u67b6");
            }
        }
    }

    public void updateSalesVolume(String param) {
        int current = 1;
        Page page = new Page((long)current, 100L);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(SkuShelf::getShelfStatus, (Object)SkuShelfStatusEnums.ENABLED.getCode());
        while (true) {
            IPage result = this.skuShelfService.getBaseMapper().selectPage((IPage)page, (Wrapper)queryWrapper);
            List skuShelfList = result.getRecords();
            this.handleUpdateSalesVolume(skuShelfList);
            if ((long)current >= result.getPages()) break;
            page.setCurrent((long)(++current));
            skuShelfList.clear();
        }
    }

    private void handleUpdateSalesVolume(List<SkuShelf> skuShelfList) {
        Map<String, List<SkuShelf>> map = skuShelfList.stream().collect(Collectors.groupingBy(s -> s.getPsStoreId() + "_" + s.getType()));
        for (List<SkuShelf> skuShelfArrList : map.values()) {
            try {
                List skuIdList = skuShelfArrList.stream().map(SkuShelf::getPsSkuId).distinct().collect(Collectors.toList());
                SkuShelf shelf = skuShelfArrList.get(0);
                ArExpenseQueryDTO arExpenseQueryDTO = new ArExpenseQueryDTO();
                arExpenseQueryDTO.setType(Integer.valueOf(shelf.getType()));
                arExpenseQueryDTO.setPsSkuIdList(skuIdList);
                arExpenseQueryDTO.setPsStoreId(shelf.getPsStoreId());
                List<FcArExpenseVO> fcArExpenseVOS = this.fcArExpenseAdapter.selectSkuSalesVolumeList(arExpenseQueryDTO);
                if (CollUtil.isEmpty(fcArExpenseVOS)) continue;
                ArrayList updateList = CollUtil.newArrayList((Object[])new SkuShelf[0]);
                Date date = new Date();
                for (SkuShelf skuShelf : skuShelfArrList) {
                    FcArExpenseVO fcArExpenseVO = fcArExpenseVOS.stream().filter(item -> ObjectUtil.equal((Object)item.getPsSkuId(), (Object)skuShelf.getPsSkuId())).findAny().orElse(null);
                    if (fcArExpenseVO == null) continue;
                    SkuShelf updateShelf = new SkuShelf();
                    updateShelf.setId(skuShelf.getId());
                    updateShelf.setSalesVolume(fcArExpenseVO.getSalesVolume());
                    if (fcArExpenseVO.getSettlementPrice() != null && fcArExpenseVO.getSalesVolume() != null) {
                        BigDecimal multiply = fcArExpenseVO.getSettlementPrice().multiply(new BigDecimal(fcArExpenseVO.getSalesVolume()));
                        updateShelf.setSellingPrice(multiply);
                    }
                    updateShelf.setSalesVolumeTime(date);
                    updateList.add(updateShelf);
                }
                if (!CollUtil.isNotEmpty((Collection)updateList)) continue;
                this.skuShelfService.updateBatchById((Collection)updateList);
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u4e0a\u67b6\u5546\u54c1\u9500\u552e\u91cf\u5931\u8d25 msg=[{}], storeId=[{}]", (Object)e.getMessage(), (Object)skuShelfArrList.get(0).getPsSkuId());
                throw new IllegalArgumentException("\u66f4\u65b0\u4e0a\u67b6\u5546\u54c1\u9500\u552e\u91cf\u5931\u8d25 " + e.getMessage());
            }
        }
    }

    public ApiResponse<Void> updateStoreCategory(List<Long> skuIdList, Long categoryId, Long psStoreId) {
        List skuList;
        skuIdList = this.skuService.querySkuIdsBySpuIds(skuIdList);
        List skuShelfList = this.skuShelfService.selectBySkuIdStatus(skuIdList, null, psStoreId);
        List<Object> shelfNotExist = Lists.newArrayList((Iterable)skuIdList);
        if (CollUtil.isNotEmpty((Collection)skuShelfList)) {
            List<Long> sheftSkuIdList = skuShelfList.stream().map(SkuShelf::getPsSkuId).toList();
            shelfNotExist = shelfNotExist.stream().filter(skuId -> !sheftSkuIdList.contains(skuId)).toList();
        }
        Category category = this.categoryService.queryCategory(categoryId);
        Assert.notNull((Object)category, (String)"\u7c7b\u76ee\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        List categoryList = this.categoryService.selectByPid(category.getId());
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)categoryList), (String)"\u7c7b\u76ee\u5b58\u5728\u4e0b\u7ea7\u7c7b\u76ee");
        Store store = (Store)this.storeService.getById((Serializable)psStoreId);
        Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728\uff01");
        List<SkuShelf> insertList = null;
        if (CollUtil.isNotEmpty((Collection)shelfNotExist) && CollUtil.isNotEmpty((Collection)(skuList = this.skuService.listByIds((Collection)shelfNotExist)))) {
            insertList = skuList.stream().map(o -> {
                SkuShelf skuShelf = new SkuShelf();
                skuShelf.setPsSkuId(o.getId());
                skuShelf.setPsStoreId(psStoreId);
                skuShelf.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                skuShelf.setId(this.idSequence.generateId(SkuShelf.class));
                skuShelf.setMinOrderQty(Integer.valueOf(1));
                skuShelf.setMaxOrderQty(Integer.valueOf(0));
                if (StoreShelfConfigEnum.TWO.getCode().equals(store.getShelfConfig())) {
                    skuShelf.setType(SupplyPriceTypeEnums.TWO.getCode());
                } else {
                    skuShelf.setType(SupplyPriceTypeEnums.ONE.getCode());
                }
                if (skuShelf.getTransportId() == null) {
                    skuShelf.setTransportId(store.getPcTransportId());
                }
                skuShelf.setPsCategoryId(categoryId);
                skuShelf.setPsCategoryName(category.getName());
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)skuShelf);
                return skuShelf;
            }).toList();
        }
        ArrayList updateList = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)skuShelfList)) {
            for (SkuShelf skuShelf : skuShelfList) {
                SkuShelf update = new SkuShelf();
                update.setId(skuShelf.getId());
                update.setPsCategoryId(categoryId);
                update.setPsCategoryName(category.getName());
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)update);
                updateList.add(update);
            }
        }
        if (CollUtil.isNotEmpty(insertList)) {
            updateList.addAll(insertList);
        }
        this.skuShelfService.saveOrUpdateBatch((Collection)updateList);
        return ApiResponse.success();
    }
}

