/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.business.model.BizOperatorInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.business.service.BizOperatorService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.BigDecimalUtil;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.ps.dao.repository.PsSkuWmsService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.SyncWmsTaskService;
import com.xinqiyi.ps.model.dto.enums.WmsStatusEnum;
import com.xinqiyi.ps.model.dto.enums.WmsTypeEnum;
import com.xinqiyi.ps.model.dto.sku.SkuExportDTO;
import com.xinqiyi.ps.model.dto.skuWms.PsSKuWmsBaseDTO;
import com.xinqiyi.ps.model.dto.skuWms.PsSkuWmsDTO;
import com.xinqiyi.ps.model.dto.spu.SpuExportDTO;
import com.xinqiyi.ps.model.entity.PsSkuWms;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.task.SyncWmsTask;
import com.xinqiyi.ps.service.adapter.DfAdapter;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.business.SpuBiz;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import com.xinqiyi.ps.service.config.OmsConfig;
import com.xinqiyi.ps.service.config.PsConfig;
import com.xinqiyi.ps.service.util.FileUploadUtil;
import com.xinqiyi.sg.wms.model.dto.SgErpSkuGetDto;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.task.TaskDetailDTO;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class PsSkuWmsBiz {
    private static final Logger log = LoggerFactory.getLogger(PsSkuWmsBiz.class);
    private final PsSkuWmsService skuWmsService;
    private final DfAdapter dfAdapter;
    private final SkuService skuService;
    private final SpuService spuService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final IdSequenceGenerator idSequence;
    private final PsConfig psConfig;
    private final SgStorageQueryAdapter sgStorageQueryAdapter;
    private final ScAdapter scAdapter;
    private final MdmAdapter mdmAdapter;
    private final SyncWmsTaskService syncWmsTaskService;
    private final FileUploadUtil fileUploadUtil;
    private final BizOperatorService bizOperatorService;
    private final SpuBiz spuBiz;
    private final SkuBiz skuBiz;

    public String syncWmsSkuDetail(PsSkuWmsDTO psSkuWmsDTO, boolean needUploadExcel) {
        Object res;
        block6: {
            String[] ownerCodeList;
            SystemConfigVO systemConfig = this.mdmAdapter.queryBySystemConfigKeyCode("SYNC_WMS_SKU_OWNER_CODES");
            Assert.notNull((Object)systemConfig, (String)"\u540c\u6b65Wms\u5546\u54c1\u4fe1\u606f\u7cfb\u7edf\u53c2\u6570\u4e0d\u5f97\u4e3a\u7a7a");
            String ownerCodes = systemConfig.getValue();
            Map<String, DictValue> pushWMSWarehouseMap = this.dfAdapter.queryDictByCode("pushWMSWarehouse");
            for (String ownerCode : ownerCodeList = ownerCodes.split(",")) {
                if (pushWMSWarehouseMap.get(ownerCode) != null) continue;
                return "\u8d27\u4e3b\u7f16\u7801\u7cfb\u7edf\u53c2\u6570\u914d\u7f6e\u9519\u8bef";
            }
            List<Sku> skus = this.extractSku(psSkuWmsDTO);
            Set spuIds = skus.stream().map(Sku::getPsSpuId).collect(Collectors.toSet());
            List spus = this.spuService.listByIds(spuIds);
            Map spuMap = spus.stream().collect(Collectors.toMap(BaseDo::getId, Function.identity()));
            res = "";
            if (CollUtil.isEmpty(skus)) {
                return "\u6210\u529f\u4fee\u65390\u6761\uff0c\u5f02\u5e38\u4fe1\u606f0\u6761\uff0c\u672a\u53d1\u751f\u53d8\u53160\u6761! \u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684sku!";
            }
            Map<String, List<Sku>> wmsThirdCodeSkuListMap = skus.stream().collect(Collectors.groupingBy(Sku::getWmsThirdPlatformCode));
            if (CollUtil.isEmpty(wmsThirdCodeSkuListMap)) {
                return "\u6210\u529f\u4fee\u65390\u6761\uff0c\u5f02\u5e38\u4fe1\u606f0\u6761\uff0c\u672a\u53d1\u751f\u53d8\u53160\u6761! \u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684sku!";
            }
            int total = skus.size();
            AtomicInteger errorIds = new AtomicInteger();
            AtomicInteger successIds = new AtomicInteger();
            AtomicInteger noUpdateIds = new AtomicInteger();
            ArrayList<SyncWmsTask> syncSkuWmsResultList = new ArrayList<SyncWmsTask>();
            Long batchId = this.idSequence.generateId(SyncWmsTask.class);
            Long taskId = psSkuWmsDTO.getTaskId();
            if (taskId != null) {
                this.scAdapter.updateTask(taskId, CollUtil.isNotEmpty(skus) ? (long)skus.size() : 0L);
            }
            wmsThirdCodeSkuListMap.forEach((wmsThirdPlatformCode, skuList) -> {
                boolean isSuccess = false;
                StringJoiner errorMsg = new StringJoiner(";");
                StringJoiner ownerCodeNameStr = new StringJoiner(";");
                for (String ownerCode : ownerCodeList) {
                    String ownerCodeName = ((DictValue)pushWMSWarehouseMap.get(ownerCode)).getName();
                    ownerCodeNameStr.add(ownerCodeName);
                    SgErpSkuGetDto dto = this.getSgErpSkuGetDto(ownerCode, (String)wmsThirdPlatformCode);
                    if (dto != null) {
                        try {
                            ApiResponse<String> wmsSkuResp = this.sgStorageQueryAdapter.syncWmsSku(dto);
                            String content = (String)wmsSkuResp.getContent();
                            skuList.forEach(sku -> {
                                Spu spu = (Spu)spuMap.get(sku.getPsSpuId());
                                boolean b = this.setSkuDetail((Sku)sku, content, spu);
                                if (!b) {
                                    noUpdateIds.getAndIncrement();
                                }
                                successIds.getAndIncrement();
                            });
                            isSuccess = true;
                            break;
                        }
                        catch (Exception e) {
                            errorMsg.add("\u8d27\u4e3b\u7f16\u7801: " + ownerCode + ":" + ExceptionUtils.getMessage((Throwable)e));
                            continue;
                        }
                    }
                    errorMsg.add("\u8d27\u4e3b\u7f16\u7801: " + ownerCode + ":\u83b7\u53d6\u8d27\u4e3b\u53c2\u6570\u4e3a\u7a7a");
                }
                if (taskId != null) {
                    skuList.forEach(sku -> this.saveTaskDetail(taskId, 1, sku.getId(), sku.getCode(), "\u540c\u6b65sku\u4fe1\u606f\u6210\u529f\uff01"));
                }
                this.saveSyncDetail(ownerCodeList, errorIds, (List<SyncWmsTask>)syncSkuWmsResultList, batchId, (String)wmsThirdPlatformCode, (List<Sku>)skuList, isSuccess, errorMsg, ownerCodeNameStr);
            });
            try {
                res = total == noUpdateIds.get() ? "\u5171\u83b7\u53d6sku\u8bb0\u5f55" + total + "\u6761\uff0c\u6210\u529f\u4fee\u65390\u6761\uff0c\u5f02\u5e38\u4fe1\u606f0\u6761\uff0c\u672a\u53d1\u751f\u53d8\u5316" + String.valueOf(noUpdateIds) + "\u6761!" : this.buildResult(total, errorIds, successIds, noUpdateIds, syncSkuWmsResultList, needUploadExcel);
            }
            catch (Exception e) {
                ExceptionUtils.getStackTrace((Throwable)e);
                if (!log.isErrorEnabled()) break block6;
                log.error("[\u540c\u6b65wms\u5546\u54c1\u4fe1\u606f] \u5931\u8d25{}", (Object)ExceptionUtils.getMessage((Throwable)e));
            }
        }
        return res;
    }

    private void saveSyncDetail(String[] ownerCodeList, AtomicInteger errorIds, List<SyncWmsTask> syncSkuWmsResultList, Long batchId, String wmsThirdPlatformCode, List<Sku> skuList, boolean isSuccess, StringJoiner errorMsg, StringJoiner ownerCodeNameStr) {
        if (!isSuccess) {
            skuList.forEach(sku -> {
                errorIds.incrementAndGet();
                SyncWmsTask detail = new SyncWmsTask(batchId, sku.getId(), sku.getCode(), sku.getName(), wmsThirdPlatformCode, ownerCodeNameStr.toString(), StringUtils.join((Object[])ownerCodeList, (String)","), errorMsg.toString(), Integer.valueOf(Integer.parseInt(WmsStatusEnum.FAIL.getCode())));
                detail.setId(this.idSequence.generateId(SyncWmsTask.class));
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)detail);
                this.syncWmsTaskService.save((Object)detail);
                syncSkuWmsResultList.add(detail);
            });
        } else {
            skuList.forEach(sku -> {
                SyncWmsTask detail = new SyncWmsTask(batchId, sku.getId(), wmsThirdPlatformCode, StringUtils.join((Object[])ownerCodeList, (String)","), Integer.valueOf(Integer.parseInt(WmsStatusEnum.SUCCESS.getCode())));
                detail.setId(this.idSequence.generateId(SyncWmsTask.class));
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)detail);
                this.syncWmsTaskService.save((Object)detail);
            });
        }
    }

    private List<Sku> extractSku(PsSkuWmsDTO psSkuWmsDTO) {
        List<Object> skuIds = new ArrayList();
        List spuIds = psSkuWmsDTO.getSpuIds();
        if (CollUtil.isNotEmpty((Collection)spuIds)) {
            List list = this.skuService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(Sku.class).select(new SFunction[]{BaseDo::getId}).in(Sku::getPsSpuId, (Collection)spuIds)).eq(BaseDo::getIsDelete, (Object)false));
            skuIds = list.stream().map(BaseDo::getId).collect(Collectors.toList());
        } else {
            skuIds = psSkuWmsDTO.getSkuIds();
        }
        List<Object> skus = new ArrayList();
        skus = CollUtil.isEmpty((Collection)spuIds) && CollUtil.isEmpty(skuIds) ? (Objects.nonNull(psSkuWmsDTO.getSkuQueryCondition()) ? this.getQueryConditionSkus(psSkuWmsDTO, skus) : (Objects.nonNull(psSkuWmsDTO.getSpuQueryCondition()) ? this.getQueryConditionSpus(psSkuWmsDTO, skus) : this.skuService.selectEnableStatusSku())) : this.skuService.selectEnableStatusSku(skuIds);
        return skus;
    }

    private List<Sku> getQueryConditionSpus(PsSkuWmsDTO psSkuWmsDTO, List<Sku> skus) {
        List<SpuExportDTO> queryConditionSpus = this.spuBiz.getQueryConditionSpus(psSkuWmsDTO.getSpuQueryCondition());
        if (CollUtil.isNotEmpty(queryConditionSpus)) {
            List spuId = queryConditionSpus.stream().map(SpuExportDTO::getSpuId).collect(Collectors.toList());
            skus = this.skuService.selectBySpuIds(spuId, Boolean.valueOf(false));
        }
        return skus;
    }

    private List<Sku> getQueryConditionSkus(PsSkuWmsDTO psSkuWmsDTO, List<Sku> skus) {
        List<SkuExportDTO> queryConditionSkus = this.skuBiz.getQueryConditionSkus(psSkuWmsDTO.getSkuQueryCondition());
        if (CollUtil.isNotEmpty(queryConditionSkus)) {
            List skuIds = queryConditionSkus.stream().map(SkuExportDTO::getSkuId).collect(Collectors.toList());
            skus = this.skuService.listByIds(skuIds);
        }
        return skus;
    }

    public List<String> querySyncWmsWarehouse() {
        String[] ownerCodeList;
        ArrayList<String> result = new ArrayList<String>();
        SystemConfigVO systemConfig = this.mdmAdapter.queryBySystemConfigKeyCode("SYNC_WMS_SKU_OWNER_CODES");
        Assert.notNull((Object)systemConfig, (String)"\u540c\u6b65Wms\u5546\u54c1\u4fe1\u606f\u7cfb\u7edf\u53c2\u6570\u4e3a\u7a7a");
        String ownerCodes = systemConfig.getValue();
        Map<String, DictValue> pushWMSWarehouseMap = this.dfAdapter.queryDictByCode("pushWMSWarehouse");
        for (String ownerCode : ownerCodeList = ownerCodes.split(",")) {
            DictValue dictValue = pushWMSWarehouseMap.get(ownerCode);
            if (dictValue == null) {
                throw new IllegalArgumentException("\u8d27\u4e3b\u7f16\u7801\u7cfb\u7edf\u53c2\u6570\u914d\u7f6e\u9519\u8bef");
            }
            result.add(dictValue.getName());
        }
        return result;
    }

    private String buildResult(int total, AtomicInteger errorIds, AtomicInteger successIds, AtomicInteger noUpdateIds, List<SyncWmsTask> syncSkuWmsResultList, boolean needUploadExcel) {
        String res = "\u5171\u83b7\u53d6sku\u8bb0\u5f55: " + total + "\u6761\uff0c\u6210\u529f\u4fee\u6539: " + String.valueOf(successIds) + "\u6761\uff0c\u5f02\u5e38\u4fe1\u606f: " + String.valueOf(errorIds) + "\u6761\uff0c\u672a\u53d1\u751f\u53d8\u5316: " + String.valueOf(noUpdateIds) + "\u6761!";
        if (CollUtil.isNotEmpty(syncSkuWmsResultList) && needUploadExcel) {
            BizOperatorInfo loginUserInfo = this.bizOperatorService.selectCurrentBizOperator();
            return this.uploadFile(total, errorIds.get(), successIds.get(), noUpdateIds.get(), syncSkuWmsResultList, loginUserInfo);
        }
        return res;
    }

    public void saveTaskDetail(Long taskId, Integer taskStatus, Long orderId, String orderNo, String message) {
        TaskDetailDTO detailDTO = new TaskDetailDTO();
        detailDTO.setSysTaskId(taskId);
        detailDTO.setBillId("" + orderId);
        detailDTO.setBillNo(orderNo);
        detailDTO.setStatus(taskStatus);
        detailDTO.setMessage(message);
        this.scAdapter.saveTaskDetail(detailDTO);
    }

    private boolean setSkuDetail(Sku sku, String result, Spu spu) {
        BigDecimal newVolume;
        if (sku == null || StringUtils.isBlank((CharSequence)result)) {
            return false;
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        String item = jsonObject.getString("item");
        if (StringUtils.isBlank((CharSequence)item)) {
            return false;
        }
        JSONObject itemInfo = JSON.parseObject((String)item);
        BigDecimal length = itemInfo.getBigDecimal("length");
        BigDecimal width = itemInfo.getBigDecimal("width");
        BigDecimal height = itemInfo.getBigDecimal("height");
        BigDecimal volume = itemInfo.getBigDecimal("volume");
        BigDecimal grossWeight = itemInfo.getBigDecimal("grossWeight");
        BigDecimal netWeight = itemInfo.getBigDecimal("netWeight");
        boolean hasChanges = false;
        if (length != null && !BigDecimalUtil.equals((BigDecimal)length, (BigDecimal)sku.getLength())) {
            sku.setLength(length);
            hasChanges = true;
        }
        if (width != null && !BigDecimalUtil.equals((BigDecimal)width, (BigDecimal)sku.getWide())) {
            sku.setWide(width);
            hasChanges = true;
        }
        if (height != null && !BigDecimalUtil.equals((BigDecimal)height, (BigDecimal)sku.getHigh())) {
            sku.setHigh(height);
            hasChanges = true;
        }
        if (volume != null && !BigDecimalUtil.equals((BigDecimal)(newVolume = volume.multiply(BigDecimal.valueOf(1000L))), (BigDecimal)sku.getVolume())) {
            sku.setVolume(newVolume);
            hasChanges = true;
        }
        if (grossWeight != null && !BigDecimalUtil.equals((BigDecimal)grossWeight, (BigDecimal)sku.getGrossWeight())) {
            sku.setGrossWeight(grossWeight);
            hasChanges = true;
        }
        if (netWeight != null && !BigDecimalUtil.equals((BigDecimal)netWeight, (BigDecimal)sku.getNetWeight())) {
            sku.setNetWeight(netWeight);
            hasChanges = true;
        }
        if (hasChanges) {
            this.spuBiz.deleteRedisKeyList(Collections.singletonList(sku));
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)sku);
            if (Objects.nonNull(spu)) {
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)spu);
                spu.setUpdateTime(sku.getUpdateTime());
                this.spuService.saveOrUpdate((Object)spu);
            }
            return this.skuService.saveOrUpdate((Object)sku);
        }
        return false;
    }

    private SgErpSkuGetDto getSgErpSkuGetDto(String ownerCode, String wmsThirdPlatformCode) {
        OmsConfig config = this.psConfig.getFormMap().getOrDefault(ownerCode, null);
        if (config == null) {
            return null;
        }
        SgErpSkuGetDto dto = new SgErpSkuGetDto();
        dto.setWmsCode(config.getType());
        dto.setCustomerId(config.getCustomerId());
        dto.setUrl(config.getUrl());
        dto.setAppKey(config.getAppKey());
        dto.setAppSecret(config.getAppSecret());
        dto.setOwnerUserId(ownerCode);
        dto.setItemCode(wmsThirdPlatformCode);
        return dto;
    }

    public String uploadFile(int total, int errorIds, int successIds, int noUpdateIds, List<SyncWmsTask> resultDetailsList, BizOperatorInfo userInfo) {
        Object filePath = ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME;
        filePath = (String)filePath + "\u540c\u6b65wms\u5546\u54c1\u5931\u8d25\u539f\u56e0" + resultDetailsList.get(0).getBatchId() + "_" + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + ".xlsx";
        this.generateExcelFile(total, errorIds, successIds, noUpdateIds, resultDetailsList, (String)filePath);
        return this.fileUploadUtil.uploadExcelFileLongTeam("ps", (String)filePath, PinyinUtil.getPinyin((String)userInfo.getUserName()));
    }

    private void generateExcelFile(int total, int errorIds, int successIds, int noUpdateIds, List<SyncWmsTask> resultDetailsList, String filePath) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", String.valueOf(total));
        map.put("errorIds", String.valueOf(errorIds));
        map.put("successIds", String.valueOf(successIds));
        map.put("noUpdateIds", String.valueOf(noUpdateIds));
        ArrayList detailsListMap = new ArrayList();
        if (CollUtil.isNotEmpty(resultDetailsList)) {
            for (SyncWmsTask resultDTO : resultDetailsList) {
                HashMap<String, String> detailsMap = new HashMap<String, String>();
                detailsMap.put("skuName", resultDTO.getSkuName());
                detailsMap.put("skuCode", resultDTO.getSkuCode());
                detailsMap.put("wmsThirdPlatformCode", resultDTO.getWmsThirdPlatformCode());
                detailsMap.put("ownerName", resultDTO.getOwnerName());
                detailsMap.put("errorMsg", resultDTO.getErrorMsg());
                detailsListMap.add(detailsMap);
            }
        }
        map.put("detailsList", detailsListMap);
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u540c\u6b65wms\u5546\u54c1\u4fe1\u606f\u8fd4\u56de\u6570\u636e{}", (Object)JSON.toJSONString(map));
            }
            FileUtil.mkdir((String)ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME);
            boolean exist = FileUtil.exist((String)filePath);
            if (!exist) {
                if (log.isDebugEnabled()) {
                    log.debug("filePath{}", (Object)filePath);
                }
                this.fileUploadUtil.downLoadFile(ConstantPropertiesUtil.SYNC_WMS_SKU_URL, filePath);
            }
            TemplateExportParams params = new TemplateExportParams(filePath, new Integer[0]);
            Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
            FileOutputStream fos = new FileOutputStream(filePath);
            workbook.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u540c\u6b65wms\u5546\u54c1\u4fe1\u606fExcel\u8868\u683c\u51fa\u9519{}", (Object)e.getMessage());
            }
            throw new IllegalArgumentException("\u540c\u6b65wms\u5546\u54c1\u4fe1\u606fExcel\u8868\u683c\u51fa\u9519" + e.getMessage());
        }
    }

    public void save(PsSkuWmsDTO jsonData) {
        Map<String, DictValue> pushWMSWarehouseMap = this.dfAdapter.queryDictByCode("pushWMSWarehouse");
        List skuWmsList = jsonData.getSkuWmsList();
        Long skuId = jsonData.getSkuId();
        Assert.notNull((Object)skuId, (String)"skuId\u4e0d\u80fd\u4e3a\u7a7a");
        Sku sku = (Sku)this.skuService.getById((Serializable)skuId);
        Assert.notNull((Object)sku, (String)"sku\u4e0d\u5b58\u5728");
        List listInDb = this.skuWmsService.list((Wrapper)Wrappers.lambdaQuery(PsSkuWms.class).eq(PsSkuWms::getPsSkuId, (Object)skuId));
        ArrayList<PsSkuWms> updateList = new ArrayList<PsSkuWms>();
        for (PsSKuWmsBaseDTO dto : skuWmsList) {
            List filterList;
            String ownerCode = dto.getOwnerCode();
            String pushPlatformType = dto.getPushPlatformType();
            DictValue dictValue = pushWMSWarehouseMap.get(ownerCode);
            if (dictValue == null) {
                throw new IllegalArgumentException("\u8d27\u4e3b\u7f16\u7801\u9519\u8bef");
            }
            String thirdPlatformCode = dto.getThirdPlatformCode();
            String platformType = dictValue.getExtend2();
            if (StringUtils.equalsIgnoreCase((CharSequence)WmsTypeEnum.WANG_DIAN.getStrCode(), (CharSequence)platformType)) {
                throw new IllegalArgumentException("\u65fa\u5e97\u901a\u7b2c\u4e09\u65b9\u7f16\u7801\u4e0d\u53ef\u4fee\u6539");
            }
            if (StringUtils.isNotBlank((CharSequence)thirdPlatformCode)) {
                PsSkuWms one = (PsSkuWms)this.skuWmsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PsSkuWms.class).eq(PsSkuWms::getOwnerCode, (Object)ownerCode)).eq(PsSkuWms::getType, (Object)platformType)).eq(PsSkuWms::getThirdPlatformCode, (Object)thirdPlatformCode)).ne(PsSkuWms::getPsSkuId, (Object)skuId)).last("LIMIT 1"));
                Assert.isNull((Object)one, (String)("\u3010\u8d27\u4e3b\u4ed3\u5e93\u2014\u63a8\u9001\u5e73\u53f0\u3011\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7b2c\u4e09\u65b9\u7f16\u7801\u3010" + thirdPlatformCode + "\u3011\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u7b2c\u4e09\u65b9\u7f16\u7801"));
            }
            if (CollUtil.isEmpty(filterList = listInDb.stream().filter(it -> String.valueOf(it.getType()).equals(pushPlatformType) && it.getOwnerCode().equals(ownerCode)).collect(Collectors.toList()))) {
                PsSkuWms psSkuWms = new PsSkuWms();
                psSkuWms.setPsSkuId(skuId);
                psSkuWms.setOwnerCode(ownerCode);
                psSkuWms.setWmsStatus(WmsStatusEnum.UN_PUSH.getCode());
                psSkuWms.setType(Integer.valueOf(Integer.parseInt(pushPlatformType)));
                psSkuWms.setId(this.idSequence.generateId(PsSkuWms.class));
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psSkuWms);
                psSkuWms.setPsSpuId(sku.getPsSpuId());
                filterList.add(psSkuWms);
            }
            for (PsSkuWms psSkuWms : filterList) {
                psSkuWms.setThirdPlatformCode(thirdPlatformCode);
                updateList.add(psSkuWms);
            }
        }
        if (CollUtil.isNotEmpty(updateList)) {
            this.skuWmsService.saveOrUpdateBatch(updateList);
        }
    }

    public List<PsSKuWmsBaseDTO> selectBySkuId(PsSkuWmsDTO jsonData) {
        Long skuId = jsonData.getSkuId();
        Assert.notNull((Object)skuId, (String)"skuId\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, DictValue> pushWMSWarehouseMap = this.dfAdapter.queryDictByCode("pushWMSWarehouse");
        List listInDb = this.skuWmsService.list((Wrapper)Wrappers.lambdaQuery(PsSkuWms.class).eq(PsSkuWms::getPsSkuId, (Object)skuId));
        Sku sku = (Sku)this.skuService.getById((Serializable)skuId);
        return this.getsKuWmsBaseDTOList(pushWMSWarehouseMap, listInDb, sku.getWmsThirdPlatformCode());
    }

    public List<PsSKuWmsBaseDTO> getsKuWmsBaseDTOList(Map<String, DictValue> pushWMSWarehouseMap, List<PsSkuWms> listInDb, String wmsThirdPlatformCode) {
        ArrayList<PsSKuWmsBaseDTO> result = new ArrayList<PsSKuWmsBaseDTO>();
        Map<String, PsSkuWms> ownerCodeWmsMap = listInDb.stream().collect(Collectors.toMap(PsSkuWms::getOwnerCode, o -> o));
        long id = 1L;
        for (Map.Entry<String, DictValue> dictValueEntry : pushWMSWarehouseMap.entrySet()) {
            PsSKuWmsBaseDTO baseDTO = new PsSKuWmsBaseDTO();
            baseDTO.setId(Long.valueOf(id++));
            baseDTO.setOwnerCode(dictValueEntry.getKey());
            DictValue value = dictValueEntry.getValue();
            baseDTO.setOwnerWarehouse(value.getName());
            baseDTO.setPushPlatformName(value.getExtend1());
            baseDTO.setPushPlatformType(value.getExtend2());
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{value.getName(), value.getExtend1(), value.getExtend2()})) continue;
            if (WmsTypeEnum.WANG_DIAN.getStrCode().equals(baseDTO.getPushPlatformType())) {
                baseDTO.setThirdPlatformCode(wmsThirdPlatformCode);
            }
            baseDTO.setPushStatus(WmsStatusEnum.UN_PUSH.getCode());
            baseDTO.setSuccessful(Boolean.valueOf(false));
            PsSkuWms psSkuWms = ownerCodeWmsMap.get(dictValueEntry.getKey());
            if (psSkuWms != null) {
                baseDTO.setThirdPlatformCode(psSkuWms.getThirdPlatformCode());
                baseDTO.setPushStatus(psSkuWms.getWmsStatus());
                baseDTO.setPushFailMsg(psSkuWms.getWmsFailMsg());
                if (Objects.nonNull(psSkuWms.getWmsId())) {
                    baseDTO.setSuccessful(Boolean.valueOf(true));
                }
            }
            result.add(baseDTO);
        }
        return result;
    }

    public PsSkuWmsBiz(PsSkuWmsService skuWmsService, DfAdapter dfAdapter, SkuService skuService, SpuService spuService, BaseDaoInitialService baseDaoInitialService, IdSequenceGenerator idSequence, PsConfig psConfig, SgStorageQueryAdapter sgStorageQueryAdapter, ScAdapter scAdapter, MdmAdapter mdmAdapter, SyncWmsTaskService syncWmsTaskService, FileUploadUtil fileUploadUtil, BizOperatorService bizOperatorService, SpuBiz spuBiz, SkuBiz skuBiz) {
        this.skuWmsService = skuWmsService;
        this.dfAdapter = dfAdapter;
        this.skuService = skuService;
        this.spuService = spuService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.idSequence = idSequence;
        this.psConfig = psConfig;
        this.sgStorageQueryAdapter = sgStorageQueryAdapter;
        this.scAdapter = scAdapter;
        this.mdmAdapter = mdmAdapter;
        this.syncWmsTaskService = syncWmsTaskService;
        this.fileUploadUtil = fileUploadUtil;
        this.bizOperatorService = bizOperatorService;
        this.spuBiz = spuBiz;
        this.skuBiz = skuBiz;
    }
}

