/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.excel.AbstractExcelImportEngine;
import com.xinqiyi.framework.excel.model.ImportEntity;
import com.xinqiyi.framework.excel.model.ImportErrorMsgDto;
import com.xinqiyi.framework.excel.model.ImportTableConfig;
import com.xinqiyi.framework.file.StorageFileHelper;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.util.BeanConvertUtil;
import com.xinqiyi.ps.dao.repository.BrandCategoryService;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.CategoryService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SpecService;
import com.xinqiyi.ps.dao.repository.SpecValueService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.UnitService;
import com.xinqiyi.ps.model.dto.enums.InnerLogTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SkuSpecTypeEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.enums.WhetherEnum;
import com.xinqiyi.ps.model.dto.excel.ImportErrorMsgDTO;
import com.xinqiyi.ps.model.dto.excel.ImportSpuCommonDTO;
import com.xinqiyi.ps.model.dto.excel.ImportSpuDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.Category;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.Spec;
import com.xinqiyi.ps.model.entity.SpecValue;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.Unit;
import com.xinqiyi.ps.service.business.SpuBiz;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Service
@Configuration(value="psSpuImportBiz")
public class PsSpuImportBiz
extends AbstractExcelImportEngine {
    private static final Logger log = LoggerFactory.getLogger(PsSpuImportBiz.class);
    private static final String NOT_EXIST = "\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01";
    private static final String BRAND_CATEGORY = "\u6b64\u54c1\u724c\u4e0d\u5c5e\u4e8e\u6b64\u7c7b\u76ee\uff01";
    private static final String DEFAULT_SPEC = "\u9ed8\u8ba4\u89c4\u683c\uff01";
    private static final String PRICE_INVALID = "\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u5927\u4e8e\u4e13\u67dc\u4ef7\uff01";
    private List<String> spuNames;
    private Map<String, ImportSpuDTO> theSpuMap;
    private List<String> spuCodes;
    private List<String> skuNames;
    private List<String> skuCodes;
    private List<String> kyThirdPlatformCodes;
    private List<String> wmsThirdPlatformCodes;
    private List<Category> categories;
    private List<Brand> brands;
    private List<Unit> units;
    private List<Spec> specs;
    private List<SpecValue> specValues;
    private List<String> barCodes;
    @Resource
    private StorageFileHelper storageFileHelper;
    @Resource
    private SpuService spuService;
    @Resource
    private SkuService skuService;
    @Resource
    private CategoryService categoryService;
    @Resource
    private BrandService brandService;
    @Resource
    private UnitService unitService;
    @Resource
    private BrandCategoryService brandCategoryService;
    @Resource
    private SpecValueService specValueService;
    @Resource
    private SpecService specService;
    @Resource
    private SkuBarCodeService skuBarCodeService;
    @Resource
    private SpuBiz spuBiz;

    private void init() {
        List skuList;
        this.spuNames = Lists.newArrayList();
        this.spuCodes = Lists.newArrayList();
        this.skuNames = Lists.newArrayList();
        this.skuCodes = Lists.newArrayList();
        this.categories = Lists.newArrayList();
        this.kyThirdPlatformCodes = Lists.newArrayList();
        this.wmsThirdPlatformCodes = Lists.newArrayList();
        this.theSpuMap = Maps.newHashMap();
        List spuList = this.spuService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).select(new SFunction[]{BaseDo::getId, Spu::getCode, Spu::getName}));
        if (CollUtil.isNotEmpty((Collection)spuList)) {
            spuList.forEach(spu -> {
                this.spuNames.add(spu.getName());
                this.spuCodes.add(spu.getCode());
            });
        }
        if (CollUtil.isNotEmpty((Collection)(skuList = this.skuService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).select(new SFunction[]{BaseDo::getId, Sku::getCode, Sku::getName, Sku::getKyThirdPlatformCode, Sku::getWmsThirdPlatformCode}))))) {
            skuList.forEach(sku -> {
                this.skuNames.add(sku.getName());
                this.skuCodes.add(sku.getCode());
                this.kyThirdPlatformCodes.add(sku.getKyThirdPlatformCode());
                this.wmsThirdPlatformCodes.add(sku.getWmsThirdPlatformCode());
            });
        }
        this.categories = this.categoryService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).eq(Category::getStatus, (Object)StatusEnums.ENABLED.getCode())).select(new SFunction[]{BaseDo::getId, Category::getWholeName, Category::getName}));
        this.brands = this.brandService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).eq(Brand::getStatus, (Object)StatusEnums.ENABLED.getCode())).select(new SFunction[]{BaseDo::getId, Brand::getName, Brand::getCountryName, Brand::getCode}));
        this.units = this.unitService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).eq(Unit::getStatus, (Object)StatusEnums.ENABLED.getCode())).select(new SFunction[]{BaseDo::getId, Unit::getName}));
        this.specs = this.specService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false)).eq(Spec::getStatus, (Object)StatusEnums.ENABLED.getCode()));
        this.specValues = this.specValueService.list((Wrapper)Wrappers.lambdaQuery().eq(BaseDo::getIsDelete, (Object)false));
        this.barCodes = this.skuBarCodeService.selectListByBrand();
    }

    protected StorageFileHelper getStorageFileHelper() {
        return this.storageFileHelper;
    }

    @LogAnnotation
    protected List<ImportErrorMsgDto> saveEntity(ImportTableConfig masterTableConfig, List<ImportTableConfig> slaveTableConfig, List<ImportEntity> entityList) {
        if (log.isInfoEnabled()) {
            log.info("\u6846\u67b6\u5546\u54c1\u5bfc\u5165\u5165\u53c2:{}", (Object)JSON.toJSONString(entityList));
        }
        if (CollectionUtils.isEmpty(entityList)) {
            return Lists.newArrayList((Object[])new ImportErrorMsgDto[]{new ImportErrorMsgDto(0, Integer.valueOf(0), "\u8868\u683c\u6570\u636e\u4e3a\u7a7a\uff01")});
        }
        try {
            this.init();
            ImportSpuCommonDTO commonDTO = this.verifyParam(entityList, masterTableConfig);
            if (CollectionUtils.isNotEmpty((Collection)commonDTO.getSpuDTOList())) {
                ArrayList<Spu> spuList = new ArrayList<Spu>();
                ArrayList skuList = Lists.newArrayList();
                ArrayList skuSpecList = Lists.newArrayList();
                ArrayList skuBarCodeList = Lists.newArrayList();
                this.spuBiz.assembleSpuInfoNew(commonDTO.getSpuDTOList(), spuList, skuList, skuSpecList, skuBarCodeList);
                if (log.isDebugEnabled()) {
                    log.debug("Assemble.SkuList.Size={}", (Object)skuList.size());
                    for (Sku sku : skuList) {
                        log.debug("Save.Sku.Info=" + sku.getId() + "--" + sku.getCode());
                    }
                }
                this.spuService.insertBatchSpu(spuList, (List)skuList, (List)skuSpecList, (List)skuBarCodeList);
                for (Spu spu : spuList) {
                    InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u4fdd\u5b58", (String)InnerLogTypeEnum.SPU.getCode(), null, (String)"\u4fdd\u5b58");
                }
            }
            return BeanConvertUtil.convertList((List)commonDTO.getErrorMsgDtoList(), ImportErrorMsgDto.class);
        }
        catch (Exception e) {
            log.error("\u6846\u67b6\u5546\u54c1\u5bfc\u5165\u5f02\u5e38,", (Throwable)e);
            return Lists.newArrayList((Object[])new ImportErrorMsgDto[]{new ImportErrorMsgDto(0, Integer.valueOf(0), "\u7cfb\u7edf\u5f02\u5e38\uff01")});
        }
    }

    private ImportSpuCommonDTO verifyParam(List<ImportEntity> entityList, ImportTableConfig masterTableConfig) {
        ImportSpuCommonDTO commonDTO = new ImportSpuCommonDTO();
        ArrayList errorMsgDtoList = Lists.newArrayList();
        ArrayList spuDTOList = Lists.newArrayList();
        int rowNo = 0;
        for (ImportEntity entry : entityList) {
            ImportSpuDTO importSpuDTO = (ImportSpuDTO)JSON.parseObject((String)String.valueOf(entry.getMasterTable()), ImportSpuDTO.class);
            StringBuilder errorBuilder = new StringBuilder();
            this.verifySpuSpec(spuDTOList, importSpuDTO, errorBuilder);
            this.verifySpu(importSpuDTO, errorBuilder);
            this.verifySku(importSpuDTO, errorBuilder);
            if (StringUtils.isEmpty((CharSequence)errorBuilder.toString())) {
                spuDTOList.add(importSpuDTO);
            } else {
                ImportErrorMsgDTO errorMsgDTO = new ImportErrorMsgDTO();
                errorMsgDTO.setSheetNo(masterTableConfig.getSheetNo());
                errorMsgDTO.setRowNo(entry.getRowNo());
                errorMsgDTO.setErrorMsg(errorBuilder.toString());
                errorMsgDtoList.add(errorMsgDTO);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("ImportSpu.Info.Row=" + ++rowNo + "WMSCode=" + importSpuDTO.getWmsThirdPlatformCode());
        }
        commonDTO.setErrorMsgDtoList((List)errorMsgDtoList);
        commonDTO.setSpuDTOList((List)spuDTOList);
        return commonDTO;
    }

    private void verifySpu(ImportSpuDTO obj, StringBuilder errorBuilder) {
        if (this.theSpuMap.containsKey(obj.getName())) {
            return;
        }
        this.checkNull(obj.getName(), "\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getCategoryName(), "\u5546\u54c1\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getPsBrandName(), "\u5546\u54c1\u54c1\u724c\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getClassifyCode(), "\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getTaxCode(), "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getMoneyTypeCode(), "\u4ef7\u683c\u5e01\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getPsUnitName(), "\u57fa\u672c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getIsSpecialPriceCode(), "\u662f\u5426\u7279\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getIsSpecialProcurementCode(), "\u662f\u5426\u7279\u91c7\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getIsSpecialPricePlusCode(), "\u662f\u5426\u7279\u7279\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getIsTcTjCode(), "\u662f\u5426\u7279\u91c7\u7279\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getIsTcTtjCode(), "\u662f\u5426\u7279\u91c7\u7279\u7279\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.checkNull(obj.getIsWmsCode(), "WMS\u662f\u5426\u9ed8\u8ba4\u53d6\u89c4\u683c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        this.verifyCategory(obj, errorBuilder);
        this.verifyBrand(obj, errorBuilder);
        this.verifyUnit(obj, errorBuilder);
        String invoiceItemName = obj.getInvoiceItemName();
        if (CharSequenceUtil.isBlank((CharSequence)invoiceItemName)) {
            obj.setInvoiceItemName(obj.getName());
        }
    }

    private void verifySpuSpec(List<ImportSpuDTO> spuDTOList, ImportSpuDTO obj, StringBuilder errorBuilder) {
        List importSpuDTOList;
        if (CollUtil.isEmpty(spuDTOList)) {
            return;
        }
        List importSpuDTOS = spuDTOList.stream().filter(item -> StrUtil.equals((CharSequence)item.getName(), (CharSequence)obj.getName()) && !StrUtil.equals((CharSequence)item.getPsSpecName(), (CharSequence)obj.getPsSpecName())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(importSpuDTOS)) {
            this.appendErrorMsg(errorBuilder, "\u540c\u4e00\u5546\u54c1 \u89c4\u683c\u5fc5\u987b\u4e00\u81f4!");
        }
        if (CollUtil.isNotEmpty(importSpuDTOList = spuDTOList.stream().filter(item -> StrUtil.equals((CharSequence)item.getName(), (CharSequence)obj.getName()) && StrUtil.equals((CharSequence)item.getPsSpecValue1(), (CharSequence)obj.getPsSpecValue1()) && StrUtil.equals((CharSequence)item.getPsSpecValue2(), (CharSequence)obj.getPsSpecValue2()) && StrUtil.equals((CharSequence)item.getPsSpecValue3(), (CharSequence)obj.getPsSpecValue3())).collect(Collectors.toList()))) {
            this.appendErrorMsg(errorBuilder, "\u540c\u4e00\u5546\u54c1 \u89c4\u683c\u503c\u91cd\u590d!");
        }
    }

    private void verifySku(ImportSpuDTO obj, StringBuilder errorBuilder) {
        this.checkRepetition(this.skuNames, obj.getSkuName(), errorBuilder, "sku\u540d\u79f0\u91cd\u590d");
        this.verifyIsSpecialPrice(obj, errorBuilder);
        this.verifySpec(obj, errorBuilder);
        this.verifyBarCode(obj, errorBuilder);
        if (CharSequenceUtil.isNotBlank((CharSequence)obj.getPsSkuUnitName())) {
            this.checkExist(this.units, o -> o.getName().equals(obj.getPsSkuUnitName()), errorBuilder, "\u88c5\u7bb1\u5355\u4f4d\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01").ifPresent(o -> {
                obj.setPsSkuUnitName(o.getName());
                obj.setPsSkuUnitId(o.getId());
            });
        }
    }

    private void verifyBarCode(ImportSpuDTO obj, StringBuilder errorBuilder) {
        String[] split;
        String barCodeList = obj.getBarCode();
        String psBrandName = obj.getPsBrandName();
        if (CharSequenceUtil.isBlank((CharSequence)barCodeList)) {
            return;
        }
        for (String barCode : split = barCodeList.split("/")) {
            this.checkRepetition(this.barCodes, barCode + psBrandName, errorBuilder, "\u6761\u5f62\u7801\u91cd\u590d\uff01");
        }
    }

    private void verifySpec(ImportSpuDTO obj, StringBuilder errorBuilder) {
        HashSet set;
        String specNames = obj.getPsSpecName();
        ImportSpuDTO importSpuDTO = this.theSpuMap.get(obj.getName());
        if (importSpuDTO != null && CharSequenceUtil.isNotBlank((CharSequence)specNames) && !specNames.equalsIgnoreCase(importSpuDTO.getPsSpecName())) {
            this.appendErrorMsg(errorBuilder, "\u540c\u5546\u54c1\u4e0b\u89c4\u683c\u5fc5\u987b\u4e00\u81f4");
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)specNames) && CharSequenceUtil.isBlank((CharSequence)obj.getPsSpecValue1())) {
            obj.setPsSpecName(DEFAULT_SPEC);
            obj.setPsSpecName1(DEFAULT_SPEC);
            obj.setPsSpecValue1(DEFAULT_SPEC);
            obj.setSkuType(SkuSpecTypeEnums.DEFAULT.getCode());
            return;
        }
        if (CharSequenceUtil.isBlank((CharSequence)specNames) || CharSequenceUtil.isBlank((CharSequence)obj.getPsSpecValue1())) {
            return;
        }
        Object[] split = specNames.split("/");
        if (split.length > (set = Sets.newHashSet((Object[])split)).size()) {
            this.appendErrorMsg(errorBuilder, "\u89c4\u683c\u91cd\u590d\uff01");
            return;
        }
        if (split.length > 3) {
            this.appendErrorMsg(errorBuilder, "\u89c4\u683c\u6700\u591a3\u4e2a\uff01");
            return;
        }
        for (int i = 0; i < split.length; ++i) {
            if (i == 0 && StrUtil.isBlank((CharSequence)obj.getPsSpecValue1())) {
                this.appendErrorMsg(errorBuilder, "\u89c4\u683c\u503c1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (i == 1 && StrUtil.isBlank((CharSequence)obj.getPsSpecValue2())) {
                this.appendErrorMsg(errorBuilder, "\u89c4\u683c\u503c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (i != 2 || !StrUtil.isBlank((CharSequence)obj.getPsSpecValue3())) continue;
            this.appendErrorMsg(errorBuilder, "\u89c4\u683c\u503c3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        for (Object specName : split) {
            Optional<Spec> specOptional = this.checkExist(this.specs, arg_0 -> PsSpuImportBiz.lambda$verifySpec$6((String)specName, arg_0), errorBuilder, "\u89c4\u683c\u540d\u79f0\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01");
            int num = atomicInteger.incrementAndGet();
            specOptional.ifPresent(o -> {
                ReflectUtil.setFieldValue((Object)obj, (String)("psSpecName" + num), (Object)o.getName());
                ReflectUtil.setFieldValue((Object)obj, (String)("psSpecId" + num), (Object)o.getId());
            });
        }
        this.verifySpecValue(obj.getPsSpecValue1(), obj, errorBuilder, 1);
        obj.setSkuType(SkuSpecTypeEnums.MANY.getCode());
        if (set.size() == 2) {
            this.verifySpecValue(obj.getPsSpecValue2(), obj, errorBuilder, 2);
        }
        if (set.size() == 3) {
            this.verifySpecValue(obj.getPsSpecValue2(), obj, errorBuilder, 2);
            this.verifySpecValue(obj.getPsSpecValue3(), obj, errorBuilder, 3);
        }
    }

    private void verifySpecValue(String value, ImportSpuDTO obj, StringBuilder errorBuilder, Integer num) {
        try {
            Optional<SpecValue> specValueOptional = this.checkExist(this.specValues, o -> o.getValue().equalsIgnoreCase(value.trim()) && o.getPsSpecId().equals(ReflectUtil.getFieldValue((Object)obj, (String)("psSpecId" + num))), errorBuilder, "\u89c4\u683c\u503c" + num + "\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528\uff01");
            specValueOptional.ifPresent(o -> {
                ReflectUtil.setFieldValue((Object)obj, (String)("psSpecValue" + num), (Object)o.getValue());
                ReflectUtil.setFieldValue((Object)obj, (String)("psSpecValueId" + num), (Object)o.getId());
            });
        }
        catch (Exception e) {
            log.error("verifySpecValueError,", (Throwable)e);
        }
    }

    private void verifyIsSpecialPrice(ImportSpuDTO obj, StringBuilder errorBuilder) {
        this.checkNull(obj.getWmsThirdPlatformCode(), "\u7b2c\u4e09\u65b9\u7f16\u53f7\uff08WMS\uff09(\u5fc5\u586b)\u4e0d\u80fd\u4e3a\u7a7a", errorBuilder);
        this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode(), errorBuilder, "\u7b2c\u4e09\u65b9\u7f16\u53f7\uff08WMS\uff09\u91cd\u590d\uff01");
        Integer isSpecialPrice = obj.getIsSpecialPriceCode();
        Integer isSpecialProcurement = obj.getIsSpecialProcurementCode();
        Integer isSpecialPricePlus = obj.getIsSpecialPricePlusCode();
        Integer isTcTjCode = obj.getIsTcTjCode();
        Integer isTcTtjCode = obj.getIsTcTtjCode();
        Integer isWmsCode = obj.getIsWmsCode();
        if (isSpecialPrice == null || isSpecialProcurement == null || isSpecialPricePlus == null || isTcTjCode == null || isTcTtjCode == null) {
            return;
        }
        if (WhetherEnum.NO.getCode().equals(isWmsCode)) {
            this.checkNull(obj.getWmsThirdPlatformCode(), "\u7b2c\u4e09\u65b9\u7f16\u53f7(WMS)(\u5fc5\u586b)\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
        }
        if (WhetherEnum.YES.getCode().equals(isSpecialPrice)) {
            if (WhetherEnum.NO.getCode().equals(isWmsCode)) {
                this.checkNull(obj.getWmsThirdPlatformCode1(), "\u7279\u4ef7\u7b2c\u4e09\u65b9\u7f16\u53f7(WMS)(\u5fc5\u586b)\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
            }
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode1())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode1(), errorBuilder, "\u7279\u4ef7\u7b2c\u4e09\u65b9\u7f16\u53f7\uff08WMS\uff09\u91cd\u590d\uff01");
            }
        }
        if (WhetherEnum.YES.getCode().equals(isSpecialPricePlus)) {
            if (WhetherEnum.NO.getCode().equals(isWmsCode)) {
                this.checkNull(obj.getWmsThirdPlatformCode2(), "\u7279\u7279\u4ef7\u7b2c\u4e09\u65b9\u7f16\u53f7(WMS)(\u5fc5\u586b)\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
            }
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode2())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode2(), errorBuilder, "\u7279\u7279\u4ef7\u7b2c\u4e09\u65b9\u7f16\u53f7\uff08WMS\uff09\u91cd\u590d\uff01");
            }
        }
        if (WhetherEnum.YES.getCode().equals(isSpecialProcurement)) {
            if (WhetherEnum.NO.getCode().equals(isWmsCode)) {
                this.checkNull(obj.getWmsThirdPlatformCode3(), "\u7279\u91c7\u7b2c\u4e09\u65b9\u7f16\u53f7(WMS)(\u5fc5\u586b)\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
            }
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode3())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode3(), errorBuilder, "\u7279\u91c7\u7b2c\u4e09\u65b9\u7f16\u53f7\uff08WMS\uff09\u91cd\u590d\uff01");
            }
        }
        if ((WhetherEnum.YES.getCode().equals(isTcTjCode) || WhetherEnum.YES.getCode().equals(isTcTtjCode)) && WhetherEnum.NO.getCode().equals(isSpecialProcurement)) {
            this.appendErrorMsg(errorBuilder, "\u662f\u5426\u7279\u91c7\u5fc5\u987b\u4e3a\u662f");
        }
        if (WhetherEnum.YES.getCode().equals(isTcTjCode)) {
            if (WhetherEnum.NO.getCode().equals(isWmsCode)) {
                this.checkNull(obj.getWmsThirdPlatformCode4(), "\u7279\u91c7\u7279\u4ef7\u7b2c\u4e09\u65b9\u7f16\u53f7(WMS)(\u5fc5\u586b)\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
            }
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode4())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode4(), errorBuilder, "\u7279\u91c7\u7279\u4ef7\u7b2c\u4e09\u65b9\u7f16\u53f7\uff08WMS\uff09\u91cd\u590d\uff01");
            }
        }
        if (WhetherEnum.YES.getCode().equals(isTcTtjCode)) {
            if (WhetherEnum.NO.getCode().equals(isWmsCode)) {
                this.checkNull(obj.getWmsThirdPlatformCode5(), "\u7279\u91c7\u7279\u7279\u4ef7\u7b2c\u4e09\u65b9\u7f16\u53f7(WMS)(\u5fc5\u586b)\u4e0d\u80fd\u4e3a\u7a7a\uff01", errorBuilder);
            }
            if (StrUtil.isNotBlank((CharSequence)obj.getWmsThirdPlatformCode5())) {
                this.checkRepetition(this.wmsThirdPlatformCodes, obj.getWmsThirdPlatformCode5(), errorBuilder, "\u7279\u91c7\u7279\u7279\u4ef7\u7b2c\u4e09\u65b9\u7f16\u53f7\uff08WMS\uff09\u91cd\u590d\uff01");
            }
        }
    }

    private void verifyCategory(ImportSpuDTO obj, StringBuilder errorBuilder) {
        String categoryName = obj.getCategoryName();
        if (CharSequenceUtil.isBlank((CharSequence)categoryName)) {
            return;
        }
        Optional<Category> optional = this.checkExist(this.categories, c -> c.getWholeName().trim().equalsIgnoreCase(categoryName.trim()), errorBuilder, "\u5546\u54c1\u7c7b\u76ee\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01");
        optional.ifPresent(o -> {
            Optional<Category> any = this.categories.stream().filter(c -> o.getId().equals(c.getPid())).findFirst();
            any.ifPresent(a -> this.appendErrorMsg(errorBuilder, "\u7c7b\u76ee\u5fc5\u987b\u4e3a\u6700\u672b\u7ea7\uff01"));
            obj.setPsCategoryId(o.getId());
            obj.setPsCategoryName(o.getName());
            obj.setPsCategoryWholeName(o.getWholeName());
        });
    }

    private void verifyBrand(ImportSpuDTO obj, StringBuilder errorBuilder) {
        String psBrandName = obj.getPsBrandName();
        if (CharSequenceUtil.isBlank((CharSequence)psBrandName)) {
            return;
        }
        Optional<Brand> optional = this.checkExist(this.brands, o -> o.getName().equalsIgnoreCase(psBrandName), errorBuilder, "\u5546\u54c1\u54c1\u724c\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01");
        optional.ifPresent(o -> {
            obj.setPsBrandId(o.getId());
            obj.setPsBrandName(o.getName());
            obj.setPsBrandCode(o.getCode());
            obj.setPsBrandCountryName(o.getCountryName());
        });
    }

    private void verifyUnit(ImportSpuDTO obj, StringBuilder errorBuilder) {
        String psUnitName = obj.getPsUnitName();
        if (CharSequenceUtil.isBlank((CharSequence)psUnitName)) {
            return;
        }
        Optional<Unit> optional = this.checkExist(this.units, o -> o.getName().equalsIgnoreCase(psUnitName), errorBuilder, "\u5546\u54c1\u5355\u4f4d\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01");
        optional.ifPresent(o -> {
            obj.setPsUnitId(o.getId());
            obj.setPsUnitName(o.getName());
        });
    }

    private void verifyBrandCategory(ImportSpuDTO obj, StringBuilder errorBuilder) {
    }

    private void checkNull(Object value, String errorMsg, StringBuilder errorBuilder) {
        if (ObjectUtil.isEmpty((Object)value)) {
            this.appendErrorMsg(errorBuilder, errorMsg);
        }
    }

    private void checkNeedNull(String value, StringBuilder errorBuilder, String errorMsg) {
        if (CharSequenceUtil.isNotBlank((CharSequence)value)) {
            this.appendErrorMsg(errorBuilder, errorMsg);
        }
    }

    private void appendErrorMsg(StringBuilder errorBuilder, String errorMsg) {
        errorBuilder.append(errorMsg).append(",");
    }

    private <T> Optional<T> checkExist(List<T> list, Predicate<? super T> predicate, StringBuilder errorBuilder, String errorMsg) {
        Optional<T> optional = list.stream().filter(predicate).findFirst();
        if (!optional.isPresent()) {
            this.appendErrorMsg(errorBuilder, errorMsg);
        }
        return optional;
    }

    private <T> void checkRepetition(List<T> list, T value, StringBuilder errorBuilder, String errorMsg) {
        if (ObjectUtil.isEmpty(value)) {
            return;
        }
        if (list.contains(value)) {
            this.appendErrorMsg(errorBuilder, errorMsg);
        }
        list.add(value);
    }

    private static /* synthetic */ boolean lambda$verifySpec$6(String specName, Spec o) {
        return o.getName().equalsIgnoreCase(specName);
    }
}

