/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.xinqiyi.cus.api.CusCustomerTagApi;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.model.search.CommonSearchRequest;
import com.xinqiyi.framework.model.search.SearchCondition;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.PsBasicsBatchVO;
import com.xinqiyi.ps.dao.repository.PsSkuTagService;
import com.xinqiyi.ps.dao.repository.PsStoreSkuTagService;
import com.xinqiyi.ps.dao.repository.PsTagCategoryService;
import com.xinqiyi.ps.dao.repository.PsTagService;
import com.xinqiyi.ps.model.dto.brand.BrandDFDTO;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.sku.PsTagDTO;
import com.xinqiyi.ps.model.dto.sku.QueryTagDTO;
import com.xinqiyi.ps.model.entity.PsSkuTag;
import com.xinqiyi.ps.model.entity.PsStoreSkuTag;
import com.xinqiyi.ps.model.entity.PsTag;
import com.xinqiyi.ps.model.entity.PsTagCategory;
import com.xinqiyi.ps.service.adapter.DfAdapter;
import com.xinqiyi.ps.service.util.CamelTransformUnderlineUtils;
import com.xinqiyi.systemcenter.web.sc.permssion.model.SelectMindDataResponse;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsTagBiz {
    @Autowired
    private PsTagService psTagService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private DfAdapter dfAdapter;
    @Autowired
    private PsSkuTagService psSkuTagService;
    @Autowired
    private PsStoreSkuTagService psStoreSkuTagService;
    @Autowired
    private CusCustomerTagApi cusCustomerTagApi;
    @Autowired
    private PsTagCategoryService psTagCategoryService;

    public Long save(ApiRequest<PsTagDTO> apiRequest) {
        PsTagDTO dto = (PsTagDTO)apiRequest.getJsonData();
        PsTag psTagName = (PsTag)this.psTagService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsTag::getName, (Object)dto.getName())).ne(dto.getId() != null, BaseDo::getId, (Object)dto.getId()));
        Assert.isNull((Object)psTagName, (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        PsTag psTag = null;
        if (dto.getId() != null) {
            psTag = (PsTag)this.psTagService.getById((Serializable)dto.getId());
            Assert.notNull((Object)psTag, (String)"\u6807\u7b7e\u4e0d\u5b58\u5728");
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psTag);
        } else {
            psTag = new PsTag();
            psTag.setId(this.idSequence.generateId(PsTag.class));
            psTag.setStatus(StatusEnums.NOT_ENABLED.getCode().toString());
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psTag);
        }
        psTag.setName(dto.getName());
        psTag.setColor(dto.getColor());
        String scenario = dto.getScenarios().stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(","));
        psTag.setScenario(scenario);
        psTag.setTagCategory(dto.getTagCategory());
        psTag.setLabelType(dto.getLabelType());
        psTag.setRemark(dto.getRemark());
        this.psTagService.saveOrUpdate((Object)psTag);
        return psTag.getId();
    }

    public void enable(ApiRequest<List<Long>> apiRequest) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)((Collection)apiRequest.getJsonData())), (String)"\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        List psTags = this.psTagService.listByIds((Collection)apiRequest.getJsonData());
        List nameList = psTags.stream().filter(item -> StrUtil.equals((CharSequence)StatusEnums.ENABLED.getCode().toString(), (CharSequence)item.getStatus())).map(PsTag::getName).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(nameList), (String)(nameList.toString() + "\u6807\u7b7e\u5df2\u542f\u7528,\u4e0d\u53ef\u6267\u884c\u6b64\u64cd\u4f5c"));
        for (PsTag psTag : psTags) {
            psTag.setStatus(StatusEnums.ENABLED.getCode().toString());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psTag);
        }
        this.psTagService.saveOrUpdateBatch((Collection)psTags);
    }

    public PsBasicsBatchVO disable(ApiRequest<List<Long>> apiRequest) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)((Collection)apiRequest.getJsonData())), (String)"\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        List psTags = this.psTagService.listByIds((Collection)apiRequest.getJsonData());
        List nameList = psTags.stream().filter(item -> !StrUtil.equals((CharSequence)StatusEnums.ENABLED.getCode().toString(), (CharSequence)item.getStatus())).map(PsTag::getName).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(nameList), (String)(nameList.toString() + "\u6807\u7b7e\u4e0d\u662f\u5df2\u542f\u7528\u72b6\u6001,\u4e0d\u53ef\u6267\u884c\u6b64\u64cd\u4f5c"));
        List psStoreSkuTagList = this.psStoreSkuTagService.list((Wrapper)Wrappers.lambdaQuery(PsStoreSkuTag.class).in(PsStoreSkuTag::getPsTagId, (Collection)apiRequest.getJsonData()));
        Set tagIdStoreSkuTagSet = psStoreSkuTagList.stream().map(PsStoreSkuTag::getPsTagId).collect(Collectors.toSet());
        List psSkuTagList = this.psSkuTagService.list((Wrapper)Wrappers.lambdaQuery(PsSkuTag.class).in(PsSkuTag::getPsTagId, (Collection)apiRequest.getJsonData()));
        Set tagIdSkuTagSet = psSkuTagList.stream().map(PsSkuTag::getPsTagId).collect(Collectors.toSet());
        Set customerTagIdSet = Collections.emptySet();
        ApiResponse listApiResponse = this.cusCustomerTagApi.queryTagRelated((List)apiRequest.getJsonData());
        if (CollectionUtil.isNotEmpty((Collection)((Collection)listApiResponse.getContent()))) {
            customerTagIdSet = ((List)listApiResponse.getContent()).stream().collect(Collectors.toSet());
        }
        PsBasicsBatchVO psBasicsBatchVO = new PsBasicsBatchVO();
        ArrayList errorMessageList = CollUtil.newArrayList((Object[])new PsBasicsBatchVO.ErrorMessage[0]);
        String infoFormat = "\u3010%s\u3011\u5728\u3010%s\u3011\u88ab\u5f15\u7528\uff0c\u8bf7\u5230\u3010%s\u3011\u4e2d\u5c06\u6807\u7b7e\u79fb\u9664\u540e\uff0c\u518d\u8fdb\u884c\u505c\u7528\u64cd\u4f5c";
        Iterator iterator = psTags.iterator();
        while (iterator.hasNext()) {
            PsTag psTag = (PsTag)iterator.next();
            StringJoiner scenario = new StringJoiner(";");
            if (tagIdSkuTagSet.contains(psTag.getId())) {
                scenario.add("\u5546\u54c1\u4e2d\u5fc3");
            }
            if (tagIdStoreSkuTagSet.contains(psTag.getId())) {
                scenario.add("\u5546\u57ce\u5e73\u53f0");
            }
            if (customerTagIdSet.contains(psTag.getId())) {
                scenario.add("\u5ba2\u6237\u4e2d\u5fc3");
            }
            if (StringUtils.isNotBlank((CharSequence)scenario.toString())) {
                String info = String.format(infoFormat, psTag.getName(), scenario.toString(), scenario.toString());
                PsBasicsBatchVO.ErrorMessage errorMessage = new PsBasicsBatchVO.ErrorMessage();
                errorMessage.setId(psTag.getId().toString());
                errorMessage.setBillNo(psTag.getName());
                errorMessage.setMessage(info);
                errorMessageList.add(errorMessage);
                iterator.remove();
                continue;
            }
            psTag.setStatus(StatusEnums.STOP_USING.getCode().toString());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psTag);
        }
        this.psTagService.saveOrUpdateBatch((Collection)psTags);
        if (CollUtil.isNotEmpty((Collection)errorMessageList)) {
            List ids = errorMessageList.stream().map(PsBasicsBatchVO.ErrorMessage::getId).collect(Collectors.toList());
            psBasicsBatchVO.setErrorIds(ids);
            psBasicsBatchVO.setErrorTotal(Integer.valueOf(ids.size()));
            psBasicsBatchVO.setSuccessTotal(Integer.valueOf(psTags.size()));
            psBasicsBatchVO.setTotal(Integer.valueOf(((List)apiRequest.getJsonData()).size()));
            psBasicsBatchVO.setErrorMessageList((List)errorMessageList);
            return this.handlerResult(psBasicsBatchVO);
        }
        return null;
    }

    private PsBasicsBatchVO handlerResult(PsBasicsBatchVO psBasicsBatchVO) {
        PsBasicsBatchVO.Column column3 = new PsBasicsBatchVO.Column();
        column3.setLabel("\u6807\u7b7e\u540d\u79f0");
        column3.setProp("billNo");
        ArrayList columnList = com.google.common.collect.Lists.newArrayList();
        PsBasicsBatchVO.Column column4 = new PsBasicsBatchVO.Column();
        column4.setLabel("\u9519\u8bef\u4fe1\u606f");
        column4.setProp("message");
        columnList.add(column3);
        columnList.add(column4);
        psBasicsBatchVO.setColumnList((List)columnList);
        return psBasicsBatchVO;
    }

    public void remove(ApiRequest<List<Long>> apiRequest) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)((Collection)apiRequest.getJsonData())), (String)"\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        List psTags = this.psTagService.listByIds((Collection)apiRequest.getJsonData());
        List nameList = psTags.stream().filter(item -> !StrUtil.equals((CharSequence)StatusEnums.NOT_ENABLED.getCode().toString(), (CharSequence)item.getStatus()) || !StrUtil.equals((CharSequence)StatusEnums.STOP_USING.getCode().toString(), (CharSequence)item.getStatus())).map(PsTag::getName).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(nameList), (String)(nameList.toString() + "\u6807\u7b7e\u72b6\u6001\u4e3a \u672a\u542f\u7528\u6216\u505c\u7528 \u65f6\u624d\u53ef\u6267\u884c\u6b64\u64cd\u4f5c"));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)psTags), (String)"\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        this.psTagService.removeByIds((Collection)apiRequest.getJsonData());
    }

    public Page<PsTag> selectPage(ApiRequest<QueryTagDTO> apiRequest) {
        QueryTagDTO dto = (QueryTagDTO)apiRequest.getJsonData();
        Page page = new Page((long)dto.getPageNum(), (long)dto.getPageSize());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().like(StringUtils.isNotEmpty((CharSequence)dto.getCreateUserName()), BaseDo::getCreateUserName, (Object)dto.getCreateUserName())).like(StringUtils.isNotEmpty((CharSequence)dto.getUpdateUserName()), BaseDo::getUpdateUserName, (Object)dto.getUpdateUserName())).ge(StringUtils.isNotEmpty((CharSequence)dto.getCreateTimeStart()), BaseDo::getCreateTime, (Object)dto.getCreateTimeStart())).le(StringUtils.isNotEmpty((CharSequence)dto.getCreateTimeEnd()), BaseDo::getCreateTime, (Object)dto.getCreateTimeEnd())).ge(StringUtils.isNotEmpty((CharSequence)dto.getUpdateTimeStart()), BaseDo::getUpdateTime, (Object)dto.getUpdateTimeStart())).le(StringUtils.isNotEmpty((CharSequence)dto.getUpdateTimeEnd()), BaseDo::getUpdateTime, (Object)dto.getUpdateTimeEnd())).in(CollUtil.isNotEmpty((Collection)dto.getScenarios()), PsTag::getScenario, (Collection)dto.getScenarios())).eq(Objects.nonNull(dto.getTagCategory()), PsTag::getTagCategory, (Object)dto.getTagCategory())).in(CollectionUtil.isNotEmpty((Collection)dto.getTagCategoryList()), PsTag::getTagCategory, (Collection)dto.getTagCategoryList())).eq(Objects.nonNull(dto.getLabelType()), PsTag::getLabelType, (Object)dto.getLabelType())).in(CollectionUtil.isNotEmpty((Collection)dto.getLabelTypeList()), PsTag::getLabelType, (Collection)dto.getLabelTypeList())).in(CollectionUtil.isNotEmpty((Collection)dto.getStatusList()), PsTag::getStatus, (Collection)dto.getStatusList())).like(StringUtils.isNotBlank((CharSequence)dto.getRemark()), PsTag::getRemark, (Object)dto.getRemark())).like(StrUtil.isNotBlank((CharSequence)dto.getName()), PsTag::getName, (Object)dto.getName());
        Page pageResult = (Page)this.psTagService.page((IPage)page, (Wrapper)queryWrapper);
        List result = pageResult.getRecords();
        this.buildResult(result);
        return pageResult;
    }

    private void buildResult(List<PsTag> result) {
        Map<String, DictValue> tagScenarioMap = this.dfAdapter.queryDictByCode("tagScenario");
        Map<String, DictValue> labelTypeMap = this.dfAdapter.queryDictByCode("labelType");
        List tagCategoryIdList = result.stream().map(PsTag::getTagCategory).collect(Collectors.toList());
        List psTagCategorieList = this.psTagCategoryService.listByIdList(tagCategoryIdList);
        for (PsTag psTag : result) {
            StringBuilder scenariosNames = new StringBuilder();
            List scenarios = Arrays.stream(psTag.getScenario().split(",")).map(Integer::parseInt).collect(Collectors.toList());
            for (Integer scenarioKey : scenarios) {
                DictValue dictValue = tagScenarioMap.get(scenarioKey.toString());
                if (dictValue == null) continue;
                scenariosNames.append(dictValue.getName()).append(",");
            }
            scenariosNames.deleteCharAt(scenariosNames.length() - 1);
            psTag.setScenariosNames(scenariosNames.toString());
            psTag.setScenarios(scenarios);
            if (labelTypeMap.containsKey(psTag.getLabelType())) {
                DictValue dictValue = labelTypeMap.get(psTag.getLabelType());
                psTag.setLabelTypeName(dictValue.getName());
            }
            if (!Objects.nonNull(psTag.getTagCategory())) continue;
            String tagCategoryName = psTagCategorieList.stream().filter(one -> one.getId().equals(psTag.getTagCategory())).map(PsTagCategory::getName).collect(Collectors.joining(","));
            psTag.setTagCategoryName(tagCategoryName);
        }
    }

    private void combinedSql(QueryTagDTO dto, LambdaQueryWrapper<PsTag> queryWrapper) {
        if (CollUtil.isNotEmpty((Collection)dto.getScenarios())) {
            ArrayList<CallSite> findInSetClauses = new ArrayList<CallSite>();
            Map<String, DictValue> tagScenarioMap = this.dfAdapter.queryDictByCode("tagScenario");
            for (Integer scenario : dto.getScenarios()) {
                DictValue dictValue = tagScenarioMap.get(scenario.toString());
                if (dictValue == null) continue;
                findInSetClauses.add((CallSite)((Object)("FIND_IN_SET(" + scenario + ", scenario)")));
            }
            if (CollUtil.isNotEmpty(findInSetClauses)) {
                String combinedClause = String.join((CharSequence)" AND ", findInSetClauses);
                queryWrapper.apply(combinedClause, new Object[0]);
            }
        }
    }

    public List<PsTag> selectList(ApiRequest<QueryTagDTO> apiRequest) {
        QueryTagDTO dto = (QueryTagDTO)apiRequest.getJsonData();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(CollectionUtil.isNotEmpty((Collection)dto.getIds()), BaseDo::getId, (Collection)dto.getIds())).like(StrUtil.isNotBlank((CharSequence)dto.getName()), PsTag::getName, (Object)dto.getName())).eq(StrUtil.isNotBlank((CharSequence)dto.getStatus()), PsTag::getStatus, (Object)dto.getStatus())).in(CollUtil.isNotEmpty((Collection)dto.getScenarios()), PsTag::getScenario, (Collection)dto.getScenarios())).notIn(StrUtil.isEmpty((CharSequence)dto.getStatus()), PsTag::getStatus, Arrays.asList(StatusEnums.NOT_ENABLED.getCode(), StatusEnums.STOP_USING.getCode()));
        List result = this.psTagService.list((Wrapper)queryWrapper);
        this.buildResult(result);
        Boolean isHideTagFlag = true;
        if (Objects.nonNull(dto.getIsHideTagFlag()) && dto.getIsHideTagFlag().booleanValue()) {
            isHideTagFlag = false;
        }
        if (CollectionUtil.isNotEmpty((Collection)result) && isHideTagFlag.booleanValue()) {
            PsTag psTagModel = new PsTag();
            psTagModel.setId(Long.valueOf(0L));
            psTagModel.setName("\u65e0\u6807\u7b7e");
            result.add(0, psTagModel);
        }
        return result;
    }

    private List<String> getMutilTextList(String searchValue) {
        List<Object> searchList = com.google.common.collect.Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)searchValue)) {
            return searchList;
        }
        searchList = Arrays.asList(searchValue.split("\\s+"));
        return searchList;
    }

    public SelectMindDataResponse queryPage(CommonSearchRequest commonSearchRequest) {
        Page page = new Page(commonSearchRequest.getPageIndex().longValue(), commonSearchRequest.getPageSize().longValue());
        List searchCondition = commonSearchRequest.getSearchCondition();
        String id = null;
        CharSequence name = null;
        ArrayList nameList = com.google.common.collect.Lists.newArrayList();
        ArrayList<String> idList = new ArrayList<String>();
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(StrUtil.isNotBlank(id), BaseDo::getId, id)).like(StrUtil.isNotBlank(name), PsTag::getName, name)).ne(PsTag::getStatus, (Object)StatusEnums.NOT_ENABLED.getCode());
        for (SearchCondition condition : searchCondition) {
            String columnName = condition.getColumnName();
            String searchValue = condition.getSearchValue();
            if (columnName.contains("code")) {
                idList.addAll(this.getMutilTextList(searchValue));
                if (CollUtil.isNotEmpty(idList)) {
                    lambdaQueryWrapper.and(qw -> {
                        for (String item : idList) {
                            ((LambdaQueryWrapper)qw.or()).like(BaseDo::getId, (Object)item);
                        }
                    });
                }
            }
            if (columnName.contains("value")) {
                nameList.addAll(this.getMutilTextList(searchValue));
                if (CollUtil.isNotEmpty((Collection)nameList)) {
                    lambdaQueryWrapper.and(qw -> {
                        for (String item : nameList) {
                            ((LambdaQueryWrapper)qw.or()).like(PsTag::getName, (Object)item);
                        }
                    });
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)columnName, (CharSequence)"id")) continue;
            idList.addAll(Arrays.asList(condition.getSearchValue().split(",")));
        }
        Page iPage = null;
        iPage = CollUtil.isEmpty(idList) ? (Page)this.psTagService.page((IPage)page, (Wrapper)lambdaQueryWrapper) : this.psTagService.queryPage(page, id, (List)nameList, idList);
        List records = iPage.getRecords();
        ArrayList tagVoList = new ArrayList();
        records.forEach(x -> {
            BrandDFDTO brandDFDTO = new BrandDFDTO();
            brandDFDTO.setId(x.getId());
            brandDFDTO.setCode(x.getId().toString());
            brandDFDTO.setValue(x.getName());
            String brandStr = JSON.toJSONString((Object)brandDFDTO);
            tagVoList.add(JSON.parseObject((String)brandStr));
        });
        SelectMindDataResponse response = new SelectMindDataResponse();
        response.setRecords(tagVoList);
        response.setPageIndex(Long.valueOf(iPage.getCurrent()));
        response.setPageSize(Long.valueOf(iPage.getSize()));
        response.setTotalPage(Integer.valueOf((int)iPage.getPages()));
        response.setTotalNum(Long.valueOf(iPage.getTotal()));
        return response;
    }

    public SelectMindDataResponse queryPageV2(CommonSearchRequest commonSearchRequest) {
        Page page = new Page(commonSearchRequest.getPageIndex().longValue(), commonSearchRequest.getPageSize().longValue());
        List searchCondition = commonSearchRequest.getSearchCondition();
        HashMap map = Maps.newHashMap();
        for (SearchCondition condition : searchCondition) {
            String columnName = condition.getColumnName();
            String searchValue = condition.getSearchValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)columnName, (CharSequence)"id")) {
                map.put("idString", searchValue);
                continue;
            }
            map.put(CamelTransformUnderlineUtils.changeColumn(columnName), searchValue);
        }
        Page iPage = this.psTagService.queryPageV3(page, map);
        List records = iPage.getRecords();
        ArrayList tagVoList = new ArrayList();
        records.forEach(x -> {
            BrandDFDTO brandDFDTO = new BrandDFDTO();
            brandDFDTO.setId(x.getId());
            brandDFDTO.setCode(x.getId().toString());
            brandDFDTO.setValue(x.getName());
            String brandStr = JSON.toJSONString((Object)brandDFDTO);
            tagVoList.add(JSON.parseObject((String)brandStr));
        });
        SelectMindDataResponse response = new SelectMindDataResponse();
        response.setRecords(tagVoList);
        response.setPageIndex(Long.valueOf(iPage.getCurrent()));
        response.setPageSize(Long.valueOf(iPage.getSize()));
        response.setTotalPage(Integer.valueOf((int)iPage.getPages()));
        response.setTotalNum(Long.valueOf(iPage.getTotal()));
        return response;
    }

    private List<String> getSplitTextList(String searchValue) {
        List<Object> searchList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)searchValue)) {
            return searchList;
        }
        searchList = Arrays.asList(searchValue.split(","));
        return searchList;
    }

    public PsTag selectById(ApiRequest<QueryTagDTO> apiRequest) {
        QueryTagDTO jsonData = (QueryTagDTO)apiRequest.getJsonData();
        Long id = jsonData.getId();
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        PsTag tag = (PsTag)this.psTagService.getById((Serializable)id);
        Assert.notNull((Object)tag, (String)"\u5f53\u524d\u6807\u7b7e\u4e0d\u5b58\u5728");
        List<PsTag> psTagList = Collections.singletonList(tag);
        this.buildResult(psTagList);
        return psTagList.get(0);
    }

    public ApiResponse<Void> updateTagCategory(QueryTagDTO dto) {
        this.psTagService.updateTagCategoryByIdList(dto.getIds(), dto.getTagCategory());
        return ApiResponse.success();
    }

    public ApiResponse<Void> emptyTagCategory(QueryTagDTO dto) {
        this.psTagService.emptyTagCategory(dto);
        return ApiResponse.success();
    }

    public ApiResponse<Boolean> verificationEnabled(QueryTagDTO dto) {
        Assert.isTrue((boolean)Objects.nonNull(dto.getId()), (String)"\u53c2\u6570\u5f02\u5e38");
        PsTagCategory psTagCategoryModel = (PsTagCategory)this.psTagCategoryService.getById((Serializable)dto.getId());
        Assert.isTrue((boolean)Objects.nonNull(psTagCategoryModel), (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        List psTagList = this.psTagService.selectPsTagListByTagCategory(psTagCategoryModel.getPid());
        if (CollUtil.isNotEmpty((Collection)psTagList)) {
            return ApiResponse.success((Object)Boolean.TRUE);
        }
        return ApiResponse.success((Object)Boolean.FALSE);
    }
}

