/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.model.dto.sku.SaveSkuBarCodeDTO;
import com.xinqiyi.ps.model.dto.sku.SkuDTO;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkuBarCodeBiz {
    @Autowired
    private SkuBarCodeService skuBarCodeService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;

    List<SaveSkuBarCodeDTO> saveConvert(SkuDTO skuDTO, Long skuId) {
        String[] barCodeList = skuDTO.getBarCodeList().split(",");
        ArrayList<SkuBarCode> skuBarCodeList = new ArrayList<SkuBarCode>();
        for (String barCode : barCodeList) {
            SkuBarCode skuBarCode = new SkuBarCode();
            skuBarCode.setId(this.idSequence.generateId(SkuBarCode.class));
            skuBarCode.setPsSkuId(skuId);
            skuBarCode.setSkuType(skuDTO.getType());
            skuBarCode.setBarCode(barCode);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)skuBarCode);
            skuBarCodeList.add(skuBarCode);
        }
        return BeanConvertUtil.convertList(skuBarCodeList, SaveSkuBarCodeDTO.class);
    }

    String getBarCode(Long psSkuId) {
        List skuBarCodeList = this.skuBarCodeService.selectBySkuId(psSkuId);
        return skuBarCodeList.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(","));
    }

    void checkSave(SkuDTO skuDTO, List<Long> removeSkuIds, Long psBrandId) {
    }
}

