/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.cus.vo.CustomerVO;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.excel.model.ExcelHeadData;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.dao.repository.PsStoreSkuTagService;
import com.xinqiyi.ps.dao.repository.PsTagService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuShelfService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.dao.util.BeanConvertUtil;
import com.xinqiyi.ps.model.dto.addpurchase.PsAddPurchaseRecordDTO;
import com.xinqiyi.ps.model.dto.enums.MoneyTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SkuShelfStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SpuClassifyEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.enums.StoreShelfConfigEnum;
import com.xinqiyi.ps.model.dto.enums.StoreTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.WhetherEnum;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.ps.model.dto.shelf.DfShelDTO;
import com.xinqiyi.ps.model.dto.shelf.PcDfShelDTO;
import com.xinqiyi.ps.model.dto.shelf.PcShelDTO;
import com.xinqiyi.ps.model.dto.sku.QueryInteriorSkuDTO;
import com.xinqiyi.ps.model.dto.sku.SearchTagDTO;
import com.xinqiyi.ps.model.dto.sku.SkuTagDTO;
import com.xinqiyi.ps.model.dto.sku.TransportQueryDTO;
import com.xinqiyi.ps.model.dto.sku.UpdateTagDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryV2DTO;
import com.xinqiyi.ps.model.dto.transport.TransportDTO;
import com.xinqiyi.ps.model.entity.PsStoreSkuTag;
import com.xinqiyi.ps.model.entity.PsTag;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.model.entity.SkuShelf;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.business.Mall4jBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.util.CamelTransformUnderlineUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SkuShelfBiz {
    private static final Logger log = LoggerFactory.getLogger(SkuShelfBiz.class);
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private StoreService storeService;
    @Autowired
    private CusAdapter cusAdapter;
    @Autowired
    private SkuService skuService;
    @Autowired
    private SkuShelfService skuShelfService;
    @Autowired
    private SkuBarCodeService skuBarCodeService;
    @Autowired
    private Mall4jBiz mall4jBiz;
    @Autowired
    private PsStoreSkuTagService storeSkuTagService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private PsTagService psTagService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;

    public int selectShelfSkuCount(SpuQueryDTO queryDTO) {
        Integer count;
        this.skuBiz.covertSpuName(queryDTO);
        if (StrUtil.isNotEmpty((CharSequence)queryDTO.getSceneCode()) && SkuShelfStatusEnums.STOP_USING.getCode().equals(queryDTO.getShelfStatus())) {
            this.skuBiz.covertScene(queryDTO);
        }
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        this.skuBiz.covertQueryChildSku(queryDTO);
        this.skuBiz.covertQueryTag(queryDTO);
        this.skuBiz.covertCategory(queryDTO);
        Store store = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        this.skuBiz.covertQtyStorage(queryDTO, store);
        if (StoreTypeEnum.ONE.getCode().equals(store.getStoreType())) {
            Assert.notNull((Object)store.getCusCustomerId(), (String)(store.getName() + "\u5e97\u94fa\u8ba2\u5355\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a"));
            ApiResponse<CustomerVO> apiResponse = this.cusAdapter.queryCustomerInfo(store.getCusCustomerId());
            Assert.isTrue((boolean)apiResponse.isSuccess(), (String)("\u67e5\u8be2\u5ba2\u6237\u670d\u52a1\u5931\u8d25\uff1a" + apiResponse.getDesc()));
            queryDTO.setCusCustomerId(store.getCusCustomerId());
            queryDTO.setMdmDepartmentId(((CustomerVO)apiResponse.getContent()).getMdmDepartmentId());
            count = this.skuShelfService.selectShelfSkuCount(queryDTO);
        } else {
            count = this.skuShelfService.selectUnPurchaseShelfSkuCount(queryDTO);
        }
        return count;
    }

    public List<Map<String, Object>> shelfSkuExport(SpuQueryV2DTO dto) {
        Page page;
        SpuQueryDTO queryDTO = new SpuQueryDTO();
        BeanUtils.copyProperties((Object)dto, (Object)queryDTO);
        this.skuBiz.covertSpuName(queryDTO);
        if (StrUtil.isNotEmpty((CharSequence)queryDTO.getSceneCode()) && SkuShelfStatusEnums.STOP_USING.getCode().equals(queryDTO.getShelfStatus())) {
            this.skuBiz.covertScene(queryDTO);
        }
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        this.skuBiz.covertQueryChildSku(queryDTO);
        this.skuBiz.covertQueryTag(queryDTO);
        this.skuBiz.covertCategory(queryDTO);
        Store store = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        this.skuBiz.covertQtyStorage(queryDTO, store);
        PsAddPurchaseRecordDTO addPurchaseRecordDTO = this.skuBiz.getPsAddPurchaseRecordDTO(queryDTO, dto.getPsStoreId());
        if (StoreTypeEnum.ONE.getCode().equals(store.getStoreType())) {
            Assert.notNull((Object)store.getCusCustomerId(), (String)(store.getName() + "\u5e97\u94fa\u8ba2\u5355\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a"));
            ApiResponse<CustomerVO> apiResponse = this.cusAdapter.queryCustomerInfo(store.getCusCustomerId());
            Assert.isTrue((boolean)apiResponse.isSuccess(), (String)("\u67e5\u8be2\u5ba2\u6237\u670d\u52a1\u5931\u8d25\uff1a" + apiResponse.getDesc()));
            queryDTO.setCusCustomerId(store.getCusCustomerId());
            queryDTO.setMdmDepartmentId(((CustomerVO)apiResponse.getContent()).getMdmDepartmentId());
            page = this.skuService.selectPurchaseShelfSkuPage(dto, queryDTO, addPurchaseRecordDTO);
        } else {
            page = this.skuService.selectShelfSkuPage(dto, queryDTO, addPurchaseRecordDTO);
        }
        if (CollUtil.isEmpty((Collection)page.getRecords())) {
            return CollUtil.newArrayList((Object[])new Map[0]);
        }
        List skuIds = page.getRecords().stream().map(QueryInteriorSkuDTO::getSkuId).distinct().collect(Collectors.toList());
        List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
        List skuShelfList = this.skuShelfService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuShelf::getPsSkuId, skuIds)).eq(SkuShelf::getPsStoreId, (Object)queryDTO.getPsStoreId()));
        List<Object> transportDTOList = CollUtil.newArrayList((Object[])new TransportDTO[0]);
        List transportIdList = skuShelfList.stream().filter(item -> ObjectUtil.isNotNull((Object)item.getTransportId())).map(SkuShelf::getTransportId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(transportIdList)) {
            TransportQueryDTO transportQueryDTO = new TransportQueryDTO();
            transportQueryDTO.setTransportIdList(transportIdList);
            transportQueryDTO.setPageSize(999);
            transportDTOList = this.mall4jBiz.selectTransportList(transportQueryDTO);
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.skuBiz.covertQtyStorageSku(page.getRecords(), store);
        for (QueryInteriorSkuDTO queryInteriorSkuDTO : page.getRecords()) {
            List skuBarCodes;
            SkuShelf dfSkuShelf;
            if (queryInteriorSkuDTO.getPsStoreId() == null) {
                queryInteriorSkuDTO.setPsStoreId(queryDTO.getPsStoreId());
            }
            queryInteriorSkuDTO.setPsStoreName(store.getName());
            SkuShelf pcSkuShelf = skuShelfList.stream().filter(item -> ObjectUtil.equal((Object)item.getPsSkuId(), (Object)queryInteriorSkuDTO.getSkuId()) && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)item.getType())).findAny().orElse(null);
            if (pcSkuShelf != null) {
                queryInteriorSkuDTO.setMaxPcOrderQty(pcSkuShelf.getMaxOrderQty());
                queryInteriorSkuDTO.setMinPcOrderQty(pcSkuShelf.getMinOrderQty());
                TransportDTO transportDTO = transportDTOList.stream().filter(item -> ObjectUtil.equal((Object)pcSkuShelf.getTransportId(), (Object)item.getTransportId())).findAny().orElse(null);
                if (transportDTO != null) {
                    queryInteriorSkuDTO.setPcTransportName(transportDTO.getTransName());
                }
            }
            if ((dfSkuShelf = (SkuShelf)skuShelfList.stream().filter(item -> ObjectUtil.equal((Object)item.getPsSkuId(), (Object)queryInteriorSkuDTO.getSkuId()) && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)item.getType())).findAny().orElse(null)) != null) {
                queryInteriorSkuDTO.setMaxDfOrderQty(dfSkuShelf.getMaxOrderQty());
                queryInteriorSkuDTO.setMinDfOrderQty(dfSkuShelf.getMinOrderQty());
                TransportDTO transportDTO = transportDTOList.stream().filter(item -> ObjectUtil.equal((Object)dfSkuShelf.getTransportId(), (Object)item.getTransportId())).findAny().orElse(null);
                if (transportDTO != null) {
                    queryInteriorSkuDTO.setDfTransportName(transportDTO.getTransName());
                }
            }
            if (CollUtil.isNotEmpty((Collection)skuBarCodeList) && CollUtil.isNotEmpty(skuBarCodes = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(queryInteriorSkuDTO.getSkuId())).collect(Collectors.toList()))) {
                queryInteriorSkuDTO.setBarCode(skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(",")));
            }
            if (StoreTypeEnum.ONE.getCode().equals(store.getStoreType())) {
                if (queryInteriorSkuDTO.getSupplyPrice() != null) {
                    queryInteriorSkuDTO.setIsSupplyPrice(YesOrNoEnum.YES.getDesc());
                } else {
                    queryInteriorSkuDTO.setIsSupplyPrice(YesOrNoEnum.NO.getDesc());
                }
            } else {
                if (queryInteriorSkuDTO.getPcSupplyPrice() != null) {
                    queryInteriorSkuDTO.setIsPcSupplyPrice(YesOrNoEnum.YES.getDesc());
                } else {
                    queryInteriorSkuDTO.setIsPcSupplyPrice(YesOrNoEnum.NO.getDesc());
                }
                if (queryInteriorSkuDTO.getDfSupplyPrice() != null) {
                    queryInteriorSkuDTO.setIsDfSupplyPrice(YesOrNoEnum.YES.getDesc());
                } else {
                    queryInteriorSkuDTO.setIsDfSupplyPrice(YesOrNoEnum.NO.getDesc());
                }
            }
            queryInteriorSkuDTO.setClassifyStr(SpuClassifyEnums.getDescByCode((Integer)queryInteriorSkuDTO.getClassify()));
            queryInteriorSkuDTO.setMoneyTypeStr(MoneyTypeEnum.getDescByCode((Integer)queryInteriorSkuDTO.getMoneyType()));
            queryInteriorSkuDTO.setIsAviationBanStr(WhetherEnum.getDescByCode((Integer)queryInteriorSkuDTO.getIsAviationBan()));
            Map<String, Object> map = CamelTransformUnderlineUtils.beanToMap(queryInteriorSkuDTO);
            list.add(map);
        }
        return list;
    }

    public List<ExcelHeadData> getExcelHeadData(SpuQueryDTO queryDTO) {
        Store store = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.ONE.getCode(), (CharSequence)store.getShelfConfig()) || StrUtil.equals((CharSequence)StoreShelfConfigEnum.THERE.getCode(), (CharSequence)store.getShelfConfig()) && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)queryDTO.getPsSkuSupplyPriceType())) {
            return CamelTransformUnderlineUtils.getDTOColumns(PcShelDTO.class);
        }
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.TWO.getCode(), (CharSequence)store.getShelfConfig()) || StrUtil.equals((CharSequence)StoreShelfConfigEnum.THERE.getCode(), (CharSequence)store.getShelfConfig()) && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)queryDTO.getPsSkuSupplyPriceType())) {
            return CamelTransformUnderlineUtils.getDTOColumns(DfShelDTO.class);
        }
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.FORE.getCode(), (CharSequence)store.getShelfConfig())) {
            return CamelTransformUnderlineUtils.getDTOColumns(PcDfShelDTO.class);
        }
        return CollUtil.newArrayList((Object[])new ExcelHeadData[0]);
    }

    public void addSkuTag(ApiRequest<UpdateTagDTO> apiRequest) {
        UpdateTagDTO dto = (UpdateTagDTO)apiRequest.getJsonData();
        Assert.notNull((Object)dto.getPsStoreId(), (String)"\u5e97\u94faid\u4e0d\u5f97\u4e3a\u7a7a");
        String purchaseMode = dto.getPurchaseMode();
        List<String> purchaseModeList = this.getPurchaseModeList(purchaseMode);
        List psTags = this.psTagService.listByIds((Collection)dto.getPsTagIdList());
        List nameList = psTags.stream().filter(item -> !StatusEnums.ENABLED.getCode().toString().equals(item.getStatus())).map(PsTag::getName).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(nameList), (String)(nameList.toString() + "\u672a\u542f\u7528, \u4e0d\u53ef\u6267\u884c\u6b64\u64cd\u4f5c"));
        List skuList = this.skuService.listByIds((Collection)dto.getPsSkuIdList());
        List storeSkuTags = this.storeSkuTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsStoreSkuTag::getPsStoreId, (Object)dto.getPsStoreId())).in(PsStoreSkuTag::getPsSkuId, (Collection)dto.getPsSkuIdList())).in(PsStoreSkuTag::getPsTagId, (Collection)dto.getPsTagIdList())).in(PsStoreSkuTag::getPurchaseMode, purchaseModeList));
        ArrayList psStoreSkuTags = CollUtil.newArrayList((Object[])new PsStoreSkuTag[0]);
        for (Sku sku : skuList) {
            this.addStoreSkuTag(dto, purchaseModeList, psTags, storeSkuTags, psStoreSkuTags, sku);
        }
        this.storeSkuTagService.saveBatch((Collection)psStoreSkuTags);
    }

    private void addStoreSkuTag(UpdateTagDTO dto, List<String> purchaseModeList, List<PsTag> psTags, List<PsStoreSkuTag> storeSkuTags, List<PsStoreSkuTag> psStoreSkuTags, Sku sku) {
        for (String purchaseMode : purchaseModeList) {
            for (PsTag psTag : psTags) {
                PsStoreSkuTag skuTag = storeSkuTags.stream().filter(item -> item.getPsSkuId().equals(sku.getId()) && item.getPsTagId().equals(psTag.getId())).findAny().orElse(null);
                if (skuTag != null) continue;
                PsStoreSkuTag psStoreSkuTag = new PsStoreSkuTag();
                psStoreSkuTag.setId(this.idSequence.generateId(PsStoreSkuTag.class));
                psStoreSkuTag.setPsStoreId(dto.getPsStoreId());
                psStoreSkuTag.setPsSkuId(sku.getId());
                psStoreSkuTag.setPsSpuId(sku.getPsSpuId());
                psStoreSkuTag.setPsTagId(psTag.getId());
                psStoreSkuTag.setPurchaseMode(purchaseMode);
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psStoreSkuTag);
                psStoreSkuTags.add(psStoreSkuTag);
            }
        }
    }

    private List<String> getPurchaseModeList(String purchaseMode) {
        ArrayList<String> purchaseModeList = new ArrayList<String>();
        if (StrUtil.isNotEmpty((CharSequence)purchaseMode)) {
            purchaseModeList.add(purchaseMode);
        } else {
            purchaseModeList.addAll(Arrays.asList(SupplyPriceTypeEnums.ONE.getCode(), SupplyPriceTypeEnums.TWO.getCode()));
        }
        return purchaseModeList;
    }

    public void removeSkuTag(ApiRequest<UpdateTagDTO> apiRequest) {
        UpdateTagDTO dto = (UpdateTagDTO)apiRequest.getJsonData();
        Assert.notNull((Object)dto.getPsStoreId(), (String)"\u5e97\u94faid\u4e0d\u5f97\u4e3a\u7a7a");
        String purchaseMode = dto.getPurchaseMode();
        List<String> purchaseModeList = this.getPurchaseModeList(purchaseMode);
        this.storeSkuTagService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsStoreSkuTag::getPsStoreId, (Object)dto.getPsStoreId())).in(PsStoreSkuTag::getPsSkuId, (Collection)dto.getPsSkuIdList())).in(PsStoreSkuTag::getPsTagId, (Collection)dto.getPsTagIdList())).in(PsStoreSkuTag::getPurchaseMode, purchaseModeList));
    }

    public List<SkuTagDTO> selectSkuTag(ApiRequest<SearchTagDTO> apiRequest) {
        List psStoreSkuTags;
        Set tagIdList;
        SearchTagDTO jsonData = (SearchTagDTO)apiRequest.getJsonData();
        Assert.notNull((Object)jsonData.getPsStoreId(), (String)"\u5e97\u94faid\u4e0d\u5f97\u4e3a\u7a7a");
        String purchaseMode = jsonData.getPurchaseMode();
        if (StrUtil.isEmpty((CharSequence)purchaseMode)) {
            purchaseMode = SupplyPriceTypeEnums.ONE.getCode();
        }
        if (CollUtil.isEmpty(tagIdList = (psStoreSkuTags = this.storeSkuTagService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{PsStoreSkuTag::getPsTagId}).eq(PsStoreSkuTag::getPsStoreId, (Object)jsonData.getPsStoreId())).in(PsStoreSkuTag::getPsSkuId, (Collection)jsonData.getPsSkuIdList())).eq(StrUtil.isNotEmpty((CharSequence)purchaseMode), PsStoreSkuTag::getPurchaseMode, (Object)purchaseMode))).stream().map(PsStoreSkuTag::getPsTagId).collect(Collectors.toSet()))) {
            return null;
        }
        List psTags = this.psTagService.listByIds(tagIdList);
        return BeanConvertUtil.convertList((List)psTags, SkuTagDTO.class);
    }

    public List<Long> selectStoreShelfBrand(Long storeId, String purchaseMode) {
        return this.skuShelfService.selectStoreShelfBrand(storeId, purchaseMode);
    }
}

