/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.BigDecimalUtil;
import com.xinqiyi.mdm.api.model.vo.salesman.SalesmanVO;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.mdm.model.dto.salesman.SalesmanDTO;
import com.xinqiyi.oa.api.WorkFlowApi;
import com.xinqiyi.oa.api.model.vo.OperationRecord;
import com.xinqiyi.oa.api.model.vo.ProcessInstanceVO;
import com.xinqiyi.oa.model.dto.enums.OaResultEnum;
import com.xinqiyi.ps.api.model.vo.PsBasicsBatchVO;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.enums.IsDeleteEnums;
import com.xinqiyi.ps.model.dto.enums.SkuSupplyPriceStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SpuClassifyEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.ps.model.dto.mall4j.ProdUpdateStocksDTO;
import com.xinqiyi.ps.model.dto.mall4j.SkuParamDTO;
import com.xinqiyi.ps.model.dto.sku.ExcelSkuDTO;
import com.xinqiyi.ps.model.dto.sku.ExcelSkuListDTO;
import com.xinqiyi.ps.model.dto.sku.IdListDTO;
import com.xinqiyi.ps.model.dto.sku.PsSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.sku.QueryComposeSkuDTO;
import com.xinqiyi.ps.model.dto.sku.SaveSkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.sku.SkuIdDTO;
import com.xinqiyi.ps.model.dto.sku.SkuSupplyDTO;
import com.xinqiyi.ps.model.dto.sku.SkuSupplyPriceDTO;
import com.xinqiyi.ps.model.dto.spu.SkuCodeDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.supplyprice.HistoryDTO;
import com.xinqiyi.ps.model.dto.supplyprice.TableCountDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.model.entity.SkuSupplyPrice;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.SpuPicture;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.mall4j.MallFourJAdapter;
import com.xinqiyi.ps.service.adapter.oa.OaAdapter;
import com.xinqiyi.ps.service.adapter.org.OrgAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.business.ComposeSkuBiz;
import com.xinqiyi.ps.service.business.SkuBarCodeBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.business.SpuBiz;
import com.xinqiyi.ps.service.business.SpuPictureBiz;
import com.xinqiyi.ps.service.business.SystemConfigBiz;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import com.xinqiyi.ps.service.mq.MqCallBack;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.FileUploadUtil;
import com.xinqiyi.ps.service.util.ParameterColumnHandler;
import com.xinqiyi.ps.service.util.PsRedisLockUtil;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageCostVo;
import jakarta.annotation.Resource;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SkuSupplyPriceBiz
implements MqCallBack {
    private static final Logger log = LoggerFactory.getLogger(SkuSupplyPriceBiz.class);
    @Autowired
    private SkuService skuService;
    @Autowired
    private SkuSupplyPriceService skuSupplyPriceService;
    @Autowired
    private SpuBiz spuBiz;
    @Autowired
    private SpuService spuService;
    @Autowired
    private WorkFlowApi workFlowApi;
    @Autowired
    private FileUploadUtil fileUploadUtil;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private SpuPictureBiz spuPictureBiz;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private OrgAdapter orgAdapter;
    @Autowired
    private SkuBarCodeBiz skuBarCodeBiz;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private SkuBarCodeService skuBarCodeService;
    @Autowired
    private SgStorageQueryAdapter sgStorageQueryAdapter;
    @Autowired
    private OaAdapter oaAdapter;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private BrandService brandService;
    @Autowired
    private ComposeSkuBiz composeSkuBiz;
    @Autowired
    private MallFourJAdapter mallFourJAdapter;
    @Autowired
    private MdmAdapter mdmAdapter;
    @Autowired
    private StoreService storeService;
    @Resource
    private SystemConfigBiz configBiz;

    public PsBasicsBatchVO saveSkuSupplyPrice(SaveSkuSupplyPriceDTO dto) {
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            for (SkuSupplyDTO supplyDTO : dto.getSkuSupplyList()) {
                String lockKey = "ps:sku_supply_price:save:" + supplyDTO.getPsSkuId();
                RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u4f9b\u8d27\u4ef7\u5546\u54c1\u7528\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock);
            }
            List skuIdList = dto.getSkuSupplyList().stream().map(SkuSupplyDTO::getPsSkuId).collect(Collectors.toList());
            List skuList = this.skuService.listByIds(skuIdList);
            List spuIdList = skuList.stream().map(Sku::getPsSpuId).distinct().collect(Collectors.toList());
            List spuList = this.spuService.listByIds(spuIdList);
            List skuSupplyPriceList = this.skuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuSupplyPrice::getPsSkuId, skuIdList)).eq(BaseDo::getIsDelete, (Object)IsDeleteEnums.NO.getCode()));
            List invalidSupplyPriceList = this.skuSupplyPriceService.selectByStatus(skuIdList, (List)CollUtil.newArrayList((Object[])new Integer[]{SkuSupplyPriceStatusEnums.IN_FORCE.getCode(), SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode()}), null);
            PsBasicsBatchVO psBasicsBatchVO = new PsBasicsBatchVO();
            ArrayList errorMessageList = CollUtil.newArrayList((Object[])new PsBasicsBatchVO.ErrorMessage[0]);
            ArrayList updateIdList = CollUtil.newArrayList((Object[])new Long[0]);
            ArrayList psSkuSupplyPrices = CollUtil.newArrayList((Object[])new SkuSupplyPrice[0]);
            block7: for (SkuSupplyDTO supplyDTO : dto.getSkuSupplyList()) {
                Spu spu;
                List supplyPriceList = skuSupplyPriceList.stream().filter(item -> CollUtil.newArrayList((Object[])new Integer[]{SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode(), SkuSupplyPriceStatusEnums.IN_REVIEW.getCode()}).contains(item.getStatus()) && ObjectUtil.equal((Object)item.getPsSkuId(), (Object)supplyDTO.getPsSkuId())).collect(Collectors.toList());
                Sku sku = skuList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)supplyDTO.getPsSkuId())).findAny().orElse(null);
                if (sku == null || (spu = (Spu)spuList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)sku.getPsSpuId())).findAny().orElse(null)) == null) continue;
                PsBasicsBatchVO.ErrorMessage errorMessage = new PsBasicsBatchVO.ErrorMessage();
                if (CollUtil.isNotEmpty(supplyPriceList)) {
                    errorMessage.setId(supplyDTO.getPsSkuId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u5df2\u5b58\u5728\u5f85\u751f\u6548\u6216\u5ba1\u6838\u4e2d\u6216\u5ba1\u6838\u9a73\u56de \u4e0d\u80fd\u65b0\u589e\u8c03\u4ef7");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                if (StrUtil.equals((CharSequence)SpuClassifyEnums.COMPOSE.getCode().toString(), (CharSequence)spu.getClassify().toString()) && supplyDTO.getPcSupplyPrice() == null) {
                    errorMessage.setId(supplyDTO.getPsSkuId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u6279\u91c7\u4f9b\u8d27\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                if (supplyDTO.getEffectiveTime().getTime() < DateUtil.beginOfDay((Date)new Date()).getTime()) {
                    errorMessage.setId(supplyDTO.getPsSkuId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage("\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
                    errorMessageList.add(errorMessage);
                    continue;
                }
                List supplyPrices = invalidSupplyPriceList.stream().filter(item -> ObjectUtil.equal((Object)item.getPsSkuId(), (Object)supplyDTO.getPsSkuId())).collect(Collectors.toList());
                for (SkuSupplyPrice supplyPrice : supplyPrices) {
                    if (supplyDTO.getEffectiveTime().getTime() > supplyPrice.getEffectiveTime().getTime()) continue;
                    errorMessage.setId(supplyDTO.getPsSkuId().toString());
                    errorMessage.setBillNo(sku.getName());
                    errorMessage.setMessage(SupplyPriceTypeEnums.getDescByCode((String)supplyPrice.getType()) + "\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5df2\u751f\u6548\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4");
                    errorMessageList.add(errorMessage);
                    continue block7;
                }
            }
            if (CollUtil.isNotEmpty((Collection)errorMessageList)) {
                SkuSupplyDTO supplyDTO;
                List ids = errorMessageList.stream().map(PsBasicsBatchVO.ErrorMessage::getId).collect(Collectors.toList());
                psBasicsBatchVO.setErrorIds(ids);
                psBasicsBatchVO.setErrorTotal(Integer.valueOf(ids.size()));
                psBasicsBatchVO.setSuccessTotal(Integer.valueOf(0));
                psBasicsBatchVO.setTotal(Integer.valueOf(ids.size()));
                psBasicsBatchVO.setErrorMessageList((List)errorMessageList);
                supplyDTO = psBasicsBatchVO;
                return supplyDTO;
            }
            for (SkuSupplyDTO supplyDTO : dto.getSkuSupplyList()) {
                SkuSupplyPrice pcSkuSupplyPrice = skuSupplyPriceList.stream().filter(item -> (ObjectUtil.equal((Object)SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode(), (Object)item.getStatus()) || ObjectUtil.equal((Object)SkuSupplyPriceStatusEnums.AUDIT_REJECTION.getCode(), (Object)item.getStatus())) && ObjectUtil.equal((Object)SupplyPriceTypeEnums.ONE.getCode(), (Object)item.getType()) && ObjectUtil.equal((Object)supplyDTO.getPsSkuId(), (Object)item.getPsSkuId())).findAny().orElse(null);
                SkuSupplyPrice dfSkuSupplyPrice = skuSupplyPriceList.stream().filter(item -> (ObjectUtil.equal((Object)SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode(), (Object)item.getStatus()) || ObjectUtil.equal((Object)SkuSupplyPriceStatusEnums.AUDIT_REJECTION.getCode(), (Object)item.getStatus())) && ObjectUtil.equal((Object)SupplyPriceTypeEnums.TWO.getCode(), (Object)item.getType()) && ObjectUtil.equal((Object)supplyDTO.getPsSkuId(), (Object)item.getPsSkuId())).findAny().orElse(null);
                pcSkuSupplyPrice = this.getSkuSupplyPrice(updateIdList, supplyDTO, pcSkuSupplyPrice);
                pcSkuSupplyPrice.setEffectiveTime(supplyDTO.getEffectiveTime());
                DateTime maxDateTime = DateUtil.parse((CharSequence)"2099-01-01 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
                pcSkuSupplyPrice.setInvalidTime((Date)maxDateTime);
                pcSkuSupplyPrice.setSupplyPrice(supplyDTO.getPcSupplyPrice());
                pcSkuSupplyPrice.setFreightCost(supplyDTO.getPcFreightCost());
                pcSkuSupplyPrice.setRemark(supplyDTO.getRemark());
                pcSkuSupplyPrice.setType(SupplyPriceTypeEnums.ONE.getCode());
                pcSkuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode());
                psSkuSupplyPrices.add(pcSkuSupplyPrice);
                dfSkuSupplyPrice = this.getSkuSupplyPrice(updateIdList, supplyDTO, dfSkuSupplyPrice);
                dfSkuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode());
                dfSkuSupplyPrice.setEffectiveTime(supplyDTO.getEffectiveTime());
                dfSkuSupplyPrice.setInvalidTime((Date)maxDateTime);
                dfSkuSupplyPrice.setSupplyPrice(supplyDTO.getDfSupplyPrice());
                dfSkuSupplyPrice.setFreightCost(supplyDTO.getDfFreightCost());
                dfSkuSupplyPrice.setRemark(supplyDTO.getRemark());
                dfSkuSupplyPrice.setType(SupplyPriceTypeEnums.TWO.getCode());
                psSkuSupplyPrices.add(dfSkuSupplyPrice);
            }
            this.skuSupplyPriceService.insert((List)psSkuSupplyPrices, (List)updateIdList);
            if (IsDeleteEnums.YES.getCode().equals(dto.getIsSubmit())) {
                LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
                Assert.notNull((Object)user, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                this.createOaFlow(psSkuSupplyPrices, user, dto.getDingDingDeptId());
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("Invoice.SkuSupplyPriceBiz.saveSkuSupplyPrice Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    private SkuSupplyPrice getSkuSupplyPrice(List<Long> updateIdList, SkuSupplyDTO supplyDTO, SkuSupplyPrice skuSupplyPrice) {
        if (skuSupplyPrice != null) {
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)skuSupplyPrice);
            updateIdList.add(skuSupplyPrice.getId());
        } else {
            skuSupplyPrice = new SkuSupplyPrice();
            skuSupplyPrice.setPsSkuId(supplyDTO.getPsSkuId());
            skuSupplyPrice.setId(this.idSequence.generateId(SkuSupplyPrice.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)skuSupplyPrice);
        }
        return skuSupplyPrice;
    }

    private void checkSkuSupply(SkuSupplyDTO supplyDTO, List<SkuSupplyPrice> skuSupplyPriceArray, String type) {
        Assert.isTrue((supplyDTO.getEffectiveTime().getTime() >= DateUtil.beginOfDay((Date)new Date()).getTime() ? 1 : 0) != 0, (String)"\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        Sku sku = this.skuService.getByStatus(supplyDTO.getPsSkuId(), StatusEnums.ENABLED.getCode());
        Assert.notNull((Object)sku, (String)"\u89c4\u683c\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        List statusList = Stream.of(SkuSupplyPriceStatusEnums.IN_FORCE.getCode(), SkuSupplyPriceStatusEnums.INVALID.getCode()).collect(Collectors.toList());
        List skuSupplyPriceList = this.skuSupplyPriceService.selectByStatus((List)CollUtil.newArrayList((Object[])new Long[]{sku.getId()}), statusList, type);
        if (CollUtil.isNotEmpty((Collection)skuSupplyPriceList)) {
            Assert.isTrue((supplyDTO.getEffectiveTime().getTime() > ((SkuSupplyPrice)skuSupplyPriceList.get(0)).getEffectiveTime().getTime() ? 1 : 0) != 0, (String)"\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5df2\u751f\u6548\u4f9b\u8d27\u4ef7\u751f\u6548\u65f6\u95f4");
        }
        if (CollUtil.isNotEmpty(skuSupplyPriceArray)) {
            List skuSupplyPrices = skuSupplyPriceArray.stream().filter(s -> s.getPsSkuId().equals(supplyDTO.getPsSkuId())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollUtil.isEmpty(skuSupplyPrices), (String)(sku.getName() + "\u5df2\u5b58\u5728\u5f85\u751f\u6548\u6216\u5ba1\u6838\u4e2d\u6216\u5ba1\u6838\u9a73\u56de \u4e0d\u80fd\u65b0\u589e\u8c03\u4ef7"));
        }
    }

    private void createOaFlow(List<SkuSupplyPrice> psSkuSupplyPrices, LoginUserInfo user, String dingDingDeptId) {
        List<ExcelSkuDTO> excelSkuDTOS = this.covertExcelSku(psSkuSupplyPrices);
        List<ExcelSkuDTO> yesDtoList = excelSkuDTOS.stream().filter(item -> item.getPcModifyPrice() != null && item.getDfModifyPrice() != null).collect(Collectors.toList());
        List<ExcelSkuDTO> notDtoList = excelSkuDTOS.stream().filter(item -> item.getPcModifyPrice() == null || item.getDfModifyPrice() == null).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(yesDtoList)) {
            this.submitOaFlow(yesDtoList, true, user, dingDingDeptId);
        }
        if (CollUtil.isNotEmpty(notDtoList)) {
            this.submitOaFlow(notDtoList, false, user, dingDingDeptId);
        }
    }

    private void submitOaFlow(List<ExcelSkuDTO> excelSkuDTOS, Boolean isHavePrice, LoginUserInfo user, String dingDingDeptId) {
        List<ExcelSkuListDTO> excelSkuDTOList;
        ArrayList skuSupplyPriceIdList = CollUtil.newArrayList((Object[])new Long[0]);
        for (ExcelSkuDTO excelSkuDTO : excelSkuDTOS) {
            skuSupplyPriceIdList.addAll(excelSkuDTO.getSkuSupplyPriceIdList());
        }
        String fileName = "skuSupplyPrice.xls";
        FileUtil.mkdir((String)ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME);
        String filePath = ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME + fileName;
        String excelurl = "";
        try {
            excelSkuDTOList = BeanConvertUtil.convertList(excelSkuDTOS, ExcelSkuListDTO.class);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u4f9b\u8d27\u4ef7\u5217\u8868", "\u4f9b\u8d27\u4ef7\u5217\u8868"), ExcelSkuDTO.class, excelSkuDTOS);
            FileOutputStream fos = new FileOutputStream(filePath);
            workbook.write((OutputStream)fos);
            fos.close();
            excelurl = this.fileUploadUtil.uploadExcelFile("ps", filePath, PinyinUtil.getPinyin((String)user.getUserName()));
            FileUtil.del((String)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u4f9b\u8d27\u4ef7\u5ba1\u6838\u6587\u4ef6\u751f\u6210\u5931\u8d25");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("excelPath", excelurl);
        data.put("isHavePrice", isHavePrice != false ? "\u5426" : "\u662f");
        HashMap<String, String> tableKey = new HashMap<String, String>();
        tableKey.put("brandName", "\u5546\u54c1\u54c1\u724c");
        tableKey.put("categoryName", "\u5546\u54c1\u7c7b\u76ee");
        tableKey.put("salesmanName", "\u884c\u9500\u8d1f\u8d23\u4eba");
        tableKey.put("skuName", "\u89c4\u683c\u540d\u79f0");
        tableKey.put("skuCode", "\u89c4\u683c\u7f16\u7801");
        tableKey.put("barCode", "\u6761\u7801");
        tableKey.put("counterPrice", "\u4e13\u67dc\u4ef7");
        tableKey.put("unitName", "\u5355\u4f4d\u540d\u79f0");
        tableKey.put("pcModifyPrice", "\u539f\u4f9b\u8d27\u4ef7\uff08\u6279\u91c7\uff09");
        tableKey.put("dfModifyPrice", "\u539f\u4f9b\u8d27\u4ef7\uff08\u4ee3\u53d1\uff09");
        tableKey.put("pcSupplyPrice", "\u4f9b\u8d27\u4ef7\uff08\u6279\u91c7\uff09");
        tableKey.put("dfSupplyPrice", "\u4f9b\u8d27\u4ef7\uff08\u4ee3\u53d1\uff09");
        tableKey.put("effectiveTime", "\u751f\u6548\u65f6\u95f4");
        tableKey.put("remark", "\u8c03\u4ef7\u8bf4\u660e");
        tableKey.put("costPriceStr", "\u6210\u672c\u4ef7");
        tableKey.put("pcBrandGrossProfitRate", "\u54c1\u724c\u9884\u7b97\u6bdb\u5229\u7387\uff08\u6279\u91c7\uff09");
        tableKey.put("dfBrandGrossProfitRate", "\u54c1\u724c\u9884\u7b97\u6bdb\u5229\u7387\uff08\u4ee3\u53d1\uff09");
        tableKey.put("customerPriceOrCounterPrice", "\u5ba2\u6237\u5efa\u8bae\u4ef7\u6216\u4e13\u67dc\u4ef7");
        tableKey.put("sgCostPriceDesc", "\u7ec4\u5408\u5546\u54c1\u6bdb\u5229\u8bf4\u660e");
        tableKey.put("pcFreightCost", "\u8fd0\u8d39\u6210\u672c\uff08\u6279\u91c7\uff09");
        tableKey.put("dfFreightCost", "\u8fd0\u8d39\u6210\u672c\uff08\u4ee3\u53d1\uff09");
        HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
        map.put("supplyPriceDetails", tableKey);
        data.put("tableKeyJson", map);
        data.put("supplyPriceDetails", excelSkuDTOList);
        ArrayList salesmanPhoneList = CollUtil.newArrayList((Object[])new String[0]);
        for (ExcelSkuListDTO excelSkuListDTO : excelSkuDTOList) {
            if (!StrUtil.isNotBlank((CharSequence)excelSkuListDTO.getSalesmanPhone())) continue;
            List<String> phoneList = Arrays.asList(excelSkuListDTO.getSalesmanPhone().split(","));
            salesmanPhoneList.addAll(phoneList);
        }
        data.put("marketingPhoneList", salesmanPhoneList.stream().distinct().collect(Collectors.joining(",")));
        data.put("dingDingDeptId", dingDingDeptId);
        data.put("phoneNumber", user.getPhoneNumber());
        String oaId = this.oaAdapter.createOaProcessV2(JSON.toJSONString(data), "PDSPY_PRICE");
        ProcessInstanceVO workFlowDetail = null;
        try {
            workFlowDetail = this.oaAdapter.getWorkFlowDetail(oaId);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6OA\u8be6\u60c5\u5931\u8d25  oaId=[{}], msg=[{}]", (Object)oaId, (Object)e.getMessage());
        }
        Date date = new Date();
        ArrayList skuSupplyPriceList = CollUtil.newArrayList((Object[])new SkuSupplyPrice[0]);
        for (Long id : skuSupplyPriceIdList) {
            SkuSupplyPrice skuSupplyPrice = new SkuSupplyPrice();
            skuSupplyPrice.setId(id);
            skuSupplyPrice.setOaId(oaId);
            if (workFlowDetail != null) {
                skuSupplyPrice.setOaCode(workFlowDetail.getBusinessId());
            }
            skuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.IN_REVIEW.getCode());
            skuSupplyPrice.setSubmitUser(user.getName());
            skuSupplyPrice.setSubmitTime(date);
            skuSupplyPriceList.add(skuSupplyPrice);
        }
        if (CollUtil.isNotEmpty((Collection)skuSupplyPriceList)) {
            this.skuSupplyPriceService.updateBatchById((Collection)skuSupplyPriceList);
        }
    }

    private List<ExcelSkuDTO> covertExcelSku(List<SkuSupplyPrice> psSkuSupplyPrices) {
        ArrayList<ExcelSkuDTO> excelSkuDTOS = new ArrayList<ExcelSkuDTO>();
        List skuIds = psSkuSupplyPrices.stream().map(SkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
        List skuList = this.skuService.listByIds(skuIds);
        List spuIds = skuList.stream().map(Sku::getPsSpuId).collect(Collectors.toList());
        List spuList = this.spuService.listByIds(spuIds);
        List brandIds = spuList.stream().map(Spu::getPsBrandId).collect(Collectors.toList());
        List brands = this.brandService.listByIds(brandIds);
        List<String> skuCodes = skuList.stream().map(Sku::getCode).collect(Collectors.toList());
        SalesmanDTO salesmanDTO = new SalesmanDTO();
        salesmanDTO.setBrandIds((Set)CollUtil.newHashSet(brandIds));
        List<SalesmanVO> salesmanVOS = this.mdmAdapter.queryMarketingList(salesmanDTO);
        List skuBarCodeList = this.skuBarCodeService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuBarCode::getPsSkuId, skuIds)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(skuCodes);
        List skuSupplyPriceList = this.skuSupplyPriceService.getBySkuIdList(skuIds, (List)CollUtil.newArrayList((Object[])new Integer[]{SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode(), SkuSupplyPriceStatusEnums.IN_FORCE.getCode()}));
        Map<Long, List<SkuSupplyPrice>> map = psSkuSupplyPrices.stream().collect(Collectors.groupingBy(SkuSupplyPrice::getPsSkuId));
        for (List<SkuSupplyPrice> psSkuSupplyPriceList : map.values()) {
            SgBStorageCostVo sgBStorageCostVo;
            BigDecimal customerGrossProfit;
            BigDecimal price;
            List salesmanList;
            SkuSupplyPrice pcSkuSupplyPrice = psSkuSupplyPriceList.stream().filter(item -> ObjectUtil.equal((Object)SupplyPriceTypeEnums.ONE.getCode(), (Object)item.getType())).findAny().orElse(null);
            SkuSupplyPrice dfSkuSupplyPrice = psSkuSupplyPriceList.stream().filter(item -> ObjectUtil.equal((Object)SupplyPriceTypeEnums.TWO.getCode(), (Object)item.getType())).findAny().orElse(null);
            SkuSupplyPrice skuSupplyPrice = psSkuSupplyPriceList.get(0);
            ExcelSkuDTO dto = new ExcelSkuDTO();
            List skuSupplyPriceIdList = psSkuSupplyPriceList.stream().map(BaseDo::getId).collect(Collectors.toList());
            dto.setSkuSupplyPriceIdList(skuSupplyPriceIdList);
            Sku sku = skuList.stream().filter(s -> s.getId().equals(skuSupplyPrice.getPsSkuId())).findFirst().orElse(null);
            Spu spu = spuList.stream().filter(s -> s.getId().equals(sku.getPsSpuId())).findFirst().orElse(null);
            String skuBarCode = skuBarCodeList.stream().filter(item -> ObjectUtil.equal((Object)item.getPsSkuId(), (Object)skuSupplyPrice.getPsSkuId())).map(SkuBarCode::getBarCode).collect(Collectors.joining(","));
            dto.setBarCode(skuBarCode);
            dto.setBrandName(spu.getPsBrandName());
            dto.setCategoryName(spu.getPsCategoryName());
            dto.setEffectiveTime(DateUtil.format((Date)skuSupplyPrice.getEffectiveTime(), (String)"yyyy-MM-dd"));
            dto.setCounterPrice(BigDecimalUtils.convert(sku.getCounterPrice(), 2));
            if (sku.getCustomerPrice() == null) {
                dto.setCustomerPriceOrCounterPrice(BigDecimalUtils.convert(sku.getCounterPrice(), 2));
            } else {
                dto.setCustomerPriceOrCounterPrice(BigDecimalUtils.convert(sku.getCustomerPrice(), 2));
            }
            dto.setCustomerPrice(sku.getCustomerPrice());
            dto.setUnitName(spu.getPsUnitName());
            if (pcSkuSupplyPrice != null) {
                dto.setPcSupplyPrice(BigDecimalUtils.convert(pcSkuSupplyPrice.getSupplyPrice(), 2));
                dto.setPcFreightCost(pcSkuSupplyPrice.getFreightCost());
            }
            if (dfSkuSupplyPrice != null) {
                dto.setDfSupplyPrice(BigDecimalUtils.convert(dfSkuSupplyPrice.getSupplyPrice(), 2));
                dto.setDfFreightCost(dfSkuSupplyPrice.getFreightCost());
            }
            dto.setSkuName(sku.getName());
            dto.setSkuCode(sku.getCode());
            dto.setSpuName(spu.getName());
            dto.setSpuCode(spu.getCode());
            dto.setRemark(skuSupplyPrice.getRemark());
            Brand brand = brands.stream().filter(s -> s.getId().equals(spu.getPsBrandId())).findAny().orElse(null);
            if (brand != null && brand.getGrossProfitRate() != null && pcSkuSupplyPrice != null) {
                dto.setPcBrandGrossProfitRate(String.valueOf(brand.getGrossProfitRate()) + "%");
                pcSkuSupplyPrice.setBrandGrossProfitRate(brand.getGrossProfitRate());
            }
            if (brand != null && brand.getGrossProfitRateOneShipment() != null && dfSkuSupplyPrice != null) {
                dto.setDfBrandGrossProfitRate(String.valueOf(brand.getGrossProfitRateOneShipment()) + "%");
                dfSkuSupplyPrice.setBrandGrossProfitRate(brand.getGrossProfitRateOneShipment());
            }
            if (CollUtil.isNotEmpty(salesmanList = salesmanVOS.stream().filter(item -> ObjectUtil.equal((Object)item.getPsBrandId(), (Object)spu.getPsBrandId())).collect(Collectors.toList()))) {
                dto.setSalesmanName(salesmanList.stream().map(SalesmanVO::getName).collect(Collectors.joining(",")));
                dto.setSalesmanPhone(salesmanList.stream().map(SalesmanVO::getPhone).collect(Collectors.joining(",")));
            }
            skuSupplyPriceList.stream().filter(item -> ObjectUtil.equal((Object)SupplyPriceTypeEnums.ONE.getCode(), (Object)item.getType()) && ObjectUtil.equal((Object)skuSupplyPrice.getPsSkuId(), (Object)item.getPsSkuId())).findAny().ifPresent(pc -> dto.setPcModifyPrice(BigDecimalUtils.convert(pc.getSupplyPrice(), 2)));
            skuSupplyPriceList.stream().filter(item -> ObjectUtil.equal((Object)SupplyPriceTypeEnums.TWO.getCode(), (Object)item.getType()) && ObjectUtil.equal((Object)skuSupplyPrice.getPsSkuId(), (Object)item.getPsSkuId())).findAny().ifPresent(df -> dto.setDfModifyPrice(BigDecimalUtils.convert(df.getSupplyPrice(), 2)));
            BigDecimal bigDecimal = price = sku.getCustomerPrice() == null ? sku.getCounterPrice() : sku.getCustomerPrice();
            if (pcSkuSupplyPrice != null) {
                dto.setPcCustomerGrossProfit(BigDecimalUtil.subtract((BigDecimal)price, (BigDecimal)pcSkuSupplyPrice.getSupplyPrice()));
                customerGrossProfit = BigDecimalUtil.divide((BigDecimal)dto.getCustomerGrossProfit(), (BigDecimal)price, (int)4, (RoundingMode)RoundingMode.HALF_UP);
                if (BigDecimalUtils.equal(new BigDecimal("0"), customerGrossProfit)) {
                    dto.setPcCustomerGrossProfitRate("0");
                } else {
                    dto.setPcCustomerGrossProfitRate(String.valueOf(BigDecimalUtil.multiply((BigDecimal)customerGrossProfit, (BigDecimal[])new BigDecimal[]{new BigDecimal("100")})) + "%");
                }
            }
            if (dfSkuSupplyPrice != null) {
                dto.setDfCustomerGrossProfit(BigDecimalUtil.subtract((BigDecimal)price, (BigDecimal)dfSkuSupplyPrice.getSupplyPrice()));
                customerGrossProfit = BigDecimalUtil.divide((BigDecimal)dto.getCustomerGrossProfit(), (BigDecimal)price, (int)4, (RoundingMode)RoundingMode.HALF_UP);
                if (BigDecimalUtils.equal(new BigDecimal("0"), customerGrossProfit)) {
                    dto.setPcCustomerGrossProfitRate("0");
                } else {
                    dto.setPcCustomerGrossProfitRate(String.valueOf(BigDecimalUtil.multiply((BigDecimal)customerGrossProfit, (BigDecimal[])new BigDecimal[]{new BigDecimal("100")})) + "%");
                }
            }
            StringBuilder composeSkuCostDesc = new StringBuilder();
            if (SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify())) {
                BigDecimal grossProfit;
                if (log.isDebugEnabled()) {
                    log.debug("Start Compose Sku CostPrice Calc");
                }
                List<QueryComposeSkuDTO> composeSkuDTOList = this.composeSkuBiz.selectComposeSku(spu.getId());
                List<String> composeSkuCodeList = composeSkuDTOList.stream().map(QueryComposeSkuDTO::getSkuCode).collect(Collectors.toList());
                if (log.isDebugEnabled()) {
                    log.debug("Start Compose Sku CostPrice SKUCode={}", composeSkuCodeList);
                }
                List<SgBStorageCostVo> composeSkuCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(composeSkuCodeList);
                BigDecimal totalCostPrice = BigDecimal.ZERO;
                for (QueryComposeSkuDTO composeSkuDTO : composeSkuDTOList) {
                    SgBStorageCostVo costVo;
                    if (!CollUtil.isNotEmpty(composeSkuCostVos) || (costVo = (SgBStorageCostVo)composeSkuCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(composeSkuDTO.getSkuCode())).findAny().orElse(null)) == null) continue;
                    BigDecimal skuPriceCost = costVo.getPriceCost();
                    skuPriceCost = BigDecimalUtil.multiply((BigDecimal)skuPriceCost, (BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(composeSkuDTO.getComposeNumber().intValue())});
                    totalCostPrice = totalCostPrice.add(skuPriceCost);
                    skuPriceCost = skuPriceCost.setScale(2, RoundingMode.HALF_UP);
                    String priceCost = costVo.getPriceCost().toPlainString();
                    if ("0E-8".equals(priceCost)) {
                        priceCost = "0.00000000";
                    }
                    composeSkuCostDesc.append("[").append(composeSkuDTO.getSkuName()).append("(").append(costVo.getPsCSkuEcode()).append(")").append(" \u6570\u91cf ").append(composeSkuDTO.getComposeNumber()).append(" \u5355\u4e2a\u6210\u672c ").append(priceCost).append(" \u603b\u6210\u672c ").append(skuPriceCost).append("] \r\n");
                }
                dto.setCostPriceStr(totalCostPrice.toPlainString());
                dto.setSgCostPriceDesc(composeSkuCostDesc.toString());
                if (pcSkuSupplyPrice != null) {
                    dto.setPcGrossProfit(pcSkuSupplyPrice.getSupplyPrice().subtract(totalCostPrice));
                    grossProfit = BigDecimal.ZERO;
                    if (!BigDecimalUtils.equal(pcSkuSupplyPrice.getSupplyPrice(), new BigDecimal(0))) {
                        grossProfit = dto.getPcGrossProfit().divide(pcSkuSupplyPrice.getSupplyPrice(), 4, RoundingMode.HALF_UP);
                    }
                    dto.setPcGrossProfitRate(String.valueOf(grossProfit.multiply(new BigDecimal("100"))) + "%");
                    pcSkuSupplyPrice.setSgCostPrice(totalCostPrice);
                    pcSkuSupplyPrice.setGrossProfit(dto.getGrossProfit());
                    pcSkuSupplyPrice.setGrossProfitRate(grossProfit);
                }
                if (dfSkuSupplyPrice != null) {
                    dto.setDfGrossProfit(dfSkuSupplyPrice.getSupplyPrice().subtract(totalCostPrice));
                    grossProfit = BigDecimal.ZERO;
                    if (!BigDecimalUtils.equal(dfSkuSupplyPrice.getSupplyPrice(), new BigDecimal(0))) {
                        grossProfit = dto.getPcGrossProfit().divide(dfSkuSupplyPrice.getSupplyPrice(), 4, RoundingMode.HALF_UP);
                    }
                    dto.setDfGrossProfitRate(String.valueOf(grossProfit.multiply(new BigDecimal("100"))) + "%");
                    dfSkuSupplyPrice.setSgCostPrice(totalCostPrice);
                    dfSkuSupplyPrice.setGrossProfit(dto.getGrossProfit());
                    dfSkuSupplyPrice.setGrossProfitRate(grossProfit);
                }
            } else if (CollUtil.isNotEmpty(sgBStorageCostVos) && (sgBStorageCostVo = (SgBStorageCostVo)sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(dto.getSkuCode())).findAny().orElse(null)) != null) {
                BigDecimal grossProfit;
                String s2 = sgBStorageCostVo.getPriceCost().toPlainString();
                if ("0E-8".equals(s2)) {
                    s2 = "0.00000000";
                }
                dto.setCostPriceStr(s2);
                if (pcSkuSupplyPrice != null) {
                    dto.setPcGrossProfit(pcSkuSupplyPrice.getSupplyPrice().subtract(sgBStorageCostVo.getPriceCost()));
                    grossProfit = BigDecimal.ZERO;
                    if (!BigDecimalUtils.equal(pcSkuSupplyPrice.getSupplyPrice(), new BigDecimal(0))) {
                        grossProfit = dto.getPcGrossProfit().divide(pcSkuSupplyPrice.getSupplyPrice(), 4, RoundingMode.HALF_UP);
                    }
                    dto.setPcGrossProfitRate(grossProfit.multiply(new BigDecimal("100")).toPlainString() + "%");
                    pcSkuSupplyPrice.setSgCostPrice(sgBStorageCostVo.getPriceCost());
                    pcSkuSupplyPrice.setGrossProfit(dto.getGrossProfit());
                    pcSkuSupplyPrice.setGrossProfitRate(grossProfit);
                }
                if (dfSkuSupplyPrice != null) {
                    dto.setDfGrossProfit(dfSkuSupplyPrice.getSupplyPrice().subtract(sgBStorageCostVo.getPriceCost()));
                    grossProfit = BigDecimal.ZERO;
                    if (!BigDecimalUtils.equal(dfSkuSupplyPrice.getSupplyPrice(), new BigDecimal(0))) {
                        grossProfit = dto.getPcGrossProfit().divide(dfSkuSupplyPrice.getSupplyPrice(), 4, RoundingMode.HALF_UP);
                    }
                    dto.setDfGrossProfitRate(grossProfit.multiply(new BigDecimal("100")).toPlainString() + "%");
                    dfSkuSupplyPrice.setSgCostPrice(sgBStorageCostVo.getPriceCost());
                    dfSkuSupplyPrice.setGrossProfit(dto.getGrossProfit());
                    dfSkuSupplyPrice.setGrossProfitRate(grossProfit);
                }
            }
            excelSkuDTOS.add(dto);
        }
        return excelSkuDTOS;
    }

    public void cancelSkuSupplyPrice(SkuIdDTO dto) {
        ArrayList<SkuSupplyPrice> psSkuSupplyPrices = new ArrayList<SkuSupplyPrice>();
        List status = Stream.of(SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode(), SkuSupplyPriceStatusEnums.AUDIT_REJECTION.getCode()).collect(Collectors.toList());
        List skuSupplyPrices = this.skuSupplyPriceService.selectByStatus(dto.getPsSkuIds(), status, null);
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)skuSupplyPrices), (String)"\u65e0\u4f9b\u8d27\u4ef7\u53ef\u53d6\u6d88, \u8bf7\u7a0d\u540e\u518d\u8bd5");
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            for (Long id : dto.getPsSkuIds()) {
                String lockKey = "ps:sku_supply_price:save:" + id;
                RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u4f9b\u8d27\u4ef7\u5546\u54c1\u7528\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock);
            }
            for (SkuSupplyPrice skuSupplyPrice : skuSupplyPrices) {
                SkuSupplyPrice supplyPrice = new SkuSupplyPrice();
                supplyPrice.setIsDelete(IsDeleteEnums.YES.getCode());
                supplyPrice.setStatus(SkuSupplyPriceStatusEnums.CANCELLED.getCode());
                supplyPrice.setId(skuSupplyPrice.getId());
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)supplyPrice);
                psSkuSupplyPrices.add(supplyPrice);
            }
            this.skuSupplyPriceService.updateByIds(psSkuSupplyPrices);
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("Invoice.SkuSupplyPriceBiz.insertSkuSupplyPrice Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    public List<PsSkuSupplyPriceDTO> selectLogList(ApiRequest<HistoryDTO> apiRequest) {
        HistoryDTO dto = (HistoryDTO)apiRequest.getJsonData();
        ParameterColumnHandler.convertParameter(dto, CollUtil.newArrayList((Object[])new String[]{"submitUser"}), "IsUnion");
        List skuSupplyPriceList = this.skuSupplyPriceService.selectLogList(dto);
        List<PsSkuSupplyPriceDTO> psSkuSupplyPriceDTOS = BeanConvertUtil.convertList(skuSupplyPriceList, PsSkuSupplyPriceDTO.class);
        for (PsSkuSupplyPriceDTO psSkuSupplyPriceDTO : psSkuSupplyPriceDTOS) {
            psSkuSupplyPriceDTO.setSupplyPrice(BigDecimalUtils.convert(psSkuSupplyPriceDTO.getSupplyPrice(), 2));
        }
        return psSkuSupplyPriceDTOS;
    }

    @Override
    public void oaCallback(String processInstanceId, String result, String status) {
        if (log.isDebugEnabled()) {
            log.debug("SkuSupplyPriceBiz.OaCalLBack.ProcessInstanceId={};Result={};Status={}", new Object[]{processInstanceId, result, status});
        }
        ApiResponse instanceVOApiResponse = null;
        try {
            instanceVOApiResponse = this.workFlowApi.getWorkFlowDetail(processInstanceId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("OA\u83b7\u53d6\u8be6\u60c5:" + e.getMessage());
        }
        Assert.isTrue((instanceVOApiResponse != null ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5ba1\u6279\u8be6\u60c5\u5931\u8d25");
        if (!instanceVOApiResponse.isSuccess()) {
            throw new IllegalArgumentException("OA\u83b7\u53d6\u8be6\u60c5:" + instanceVOApiResponse.getDesc());
        }
        String userId = null;
        Date auditTime = null;
        String remark = null;
        for (OperationRecord operationRecord : ((ProcessInstanceVO)instanceVOApiResponse.getContent()).getOperationRecords()) {
            if (!result.equals(operationRecord.getOperationResult().toLowerCase())) continue;
            userId = operationRecord.getUserid();
            auditTime = Date.from(operationRecord.getDate().atZone(ZoneId.systemDefault()).toInstant());
            remark = operationRecord.getRemark();
        }
        List psSkuSupplyPriceList = this.skuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SkuSupplyPrice::getOaId, (Object)processInstanceId)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE)).eq(SkuSupplyPrice::getStatus, (Object)SkuSupplyPriceStatusEnums.IN_REVIEW.getCode()));
        if (CollectionUtils.isEmpty((Collection)psSkuSupplyPriceList)) {
            throw new IllegalArgumentException("Select.Supply.Price.List.Empty.ProcessInstanceId=" + processInstanceId);
        }
        Date date = new Date();
        ArrayList<SkuSupplyPrice> skuSupplyPriceList = new ArrayList<SkuSupplyPrice>();
        for (SkuSupplyPrice psSkuSupplyPrice : psSkuSupplyPriceList) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"agree", (CharSequence)result)) {
                Integer priceStatus = null;
                if (date.getTime() >= psSkuSupplyPrice.getEffectiveTime().getTime() && date.getTime() <= psSkuSupplyPrice.getInvalidTime().getTime()) {
                    priceStatus = SkuSupplyPriceStatusEnums.IN_FORCE.getCode();
                } else if (date.getTime() < psSkuSupplyPrice.getEffectiveTime().getTime()) {
                    priceStatus = SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode();
                } else if (date.getTime() > psSkuSupplyPrice.getInvalidTime().getTime()) {
                    priceStatus = SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode();
                }
                psSkuSupplyPrice.setStatus(priceStatus);
                List statusList = Stream.of(SkuSupplyPriceStatusEnums.IN_FORCE.getCode(), SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode()).collect(Collectors.toList());
                SkuSupplyPrice skuSupplyPrice = this.skuSupplyPriceService.getBySkuId(psSkuSupplyPrice.getPsSkuId(), statusList, new Date(), psSkuSupplyPrice.getType());
                if (skuSupplyPrice != null) {
                    skuSupplyPrice.setInvalidTime((Date)DateUtil.offsetSecond((Date)DateUtil.beginOfDay((Date)psSkuSupplyPrice.getEffectiveTime()), (int)-1));
                    if (date.getTime() > skuSupplyPrice.getEffectiveTime().getTime()) {
                        skuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.INVALID.getCode());
                    }
                    this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)skuSupplyPrice);
                    skuSupplyPriceList.add(skuSupplyPrice);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)OaResultEnum.FLOW_RESULT_CANCEL.getCode(), (CharSequence)result)) {
                psSkuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode());
            } else {
                psSkuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.AUDIT_REJECTION.getCode());
                psSkuSupplyPrice.setReasonsReject(remark);
            }
            psSkuSupplyPrice.setAuditTime(auditTime);
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psSkuSupplyPrice);
            skuSupplyPriceList.add(psSkuSupplyPrice);
        }
        if (CollUtil.isNotEmpty(skuSupplyPriceList)) {
            this.skuSupplyPriceService.updateBatchById(skuSupplyPriceList);
            this.covertProdUpdateToMallFourJ(skuSupplyPriceList);
            List skuIdList = skuSupplyPriceList.stream().map(SkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
            List skuList = this.skuService.listByIds(skuIdList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    public Page<SkuSupplyPriceDTO> selectPageSkuSupplyPrice(SpuQueryDTO queryDTO) {
        List list;
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        this.skuBiz.covertCategory(queryDTO);
        if (StrUtil.isNotEmpty((CharSequence)queryDTO.getSceneCode())) {
            this.skuBiz.covertScene(queryDTO);
        }
        if (queryDTO.getStatus() == null) {
            queryDTO.setStatus(StatusEnums.ENABLED.getCode());
        }
        boolean isCostPrice = true;
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse<Map<String, List<String>>> mapApiResponse = this.scAdapter.selectSensitiveColumnByUserId(user.getUserId());
        Assert.isTrue((boolean)mapApiResponse.isSuccess(), (String)mapApiResponse.getDesc());
        Map map = (Map)mapApiResponse.getContent();
        if (map.containsKey("ps_sku_supply_price") && (list = (List)map.get("ps_sku_supply_price")).contains("sg_cost_price")) {
            isCostPrice = false;
        }
        this.skuBiz.convertBrandPermission(queryDTO);
        Page page = ObjectUtil.equal((Object)SkuSupplyPriceStatusEnums.IN_FORCE.getCode(), (Object)queryDTO.getSkuSupplyPriceStatus()) ? this.skuSupplyPriceService.selectPageSkuSupplyPrice(queryDTO) : this.skuSupplyPriceService.selectPageSkuSupplyPriceByStatus(queryDTO);
        if (CollUtil.isEmpty((Collection)page.getRecords())) {
            return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
        }
        List<String> skuCodeList = page.getRecords().stream().map(SkuSupplyPriceDTO::getSkuCode).collect(Collectors.toList());
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(skuCodeList);
        ArrayList status = CollUtil.newArrayList((Object[])new Integer[]{SkuSupplyPriceStatusEnums.IN_REVIEW.getCode(), SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode(), SkuSupplyPriceStatusEnums.AUDIT_REJECTION.getCode(), SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode()});
        List skuIdList = page.getRecords().stream().map(SkuSupplyPriceDTO::getSkuId).collect(Collectors.toList());
        Date date = new Date();
        List skuSupplyPriceArrayListList = CollUtil.newArrayList((Object[])new SkuSupplyPrice[0]);
        if (!ObjectUtil.equal((Object)SkuSupplyPriceStatusEnums.IN_FORCE.getCode(), (Object)queryDTO.getSkuSupplyPriceStatus())) {
            skuSupplyPriceArrayListList = this.skuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuSupplyPrice::getPsSkuId, skuIdList)).in(SkuSupplyPrice::getStatus, (Collection)CollUtil.newArrayList((Object[])new Integer[]{SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode(), SkuSupplyPriceStatusEnums.IN_FORCE.getCode()}))).le(SkuSupplyPrice::getEffectiveTime, (Object)date)).ge(SkuSupplyPrice::getInvalidTime, (Object)date));
        }
        List skuSupplyPriceList = this.skuSupplyPriceService.selectByStatus(skuIdList, (List)status, queryDTO.getType());
        List<Long> spuIds = page.getRecords().stream().map(SkuSupplyPriceDTO::getSpuId).collect(Collectors.toList());
        List<SpuPicture> spuPictureList = this.spuPictureBiz.getMainBySpuIds(spuIds);
        List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIdList);
        String supplyPriceDigits = this.configBiz.getSupplyPriceDigits();
        for (SkuSupplyPriceDTO skuSupplyPriceDTO : page.getRecords()) {
            SkuCodeDTO codeDTO;
            SgBStorageCostVo sgBStorageCostVo;
            List skuBarCodes;
            List skuSupplyPrices;
            List spuPictures;
            if (!ObjectUtil.equal((Object)SkuSupplyPriceStatusEnums.IN_FORCE.getCode(), (Object)queryDTO.getSkuSupplyPriceStatus())) {
                SkuSupplyPrice dfSkuSupplyPrice;
                SkuSupplyPrice pcSkuSupplyPrice = skuSupplyPriceArrayListList.stream().filter(item -> ObjectUtil.equal((Object)SupplyPriceTypeEnums.ONE.getCode(), (Object)item.getType()) && ObjectUtil.equal((Object)skuSupplyPriceDTO.getSkuId(), (Object)item.getPsSkuId()) && ObjectUtil.equal((Object)SupplyPriceTypeEnums.ONE.getCode(), (Object)item.getType())).findAny().orElse(null);
                if (pcSkuSupplyPrice != null) {
                    skuSupplyPriceDTO.setPcSupplyPrice(this.configBiz.getDecimalDigits(pcSkuSupplyPrice.getSupplyPrice(), supplyPriceDigits));
                }
                if ((dfSkuSupplyPrice = (SkuSupplyPrice)skuSupplyPriceArrayListList.stream().filter(item -> ObjectUtil.equal((Object)SupplyPriceTypeEnums.TWO.getCode(), (Object)item.getType()) && ObjectUtil.equal((Object)skuSupplyPriceDTO.getSkuId(), (Object)item.getPsSkuId()) && ObjectUtil.equal((Object)SupplyPriceTypeEnums.TWO.getCode(), (Object)item.getType())).findAny().orElse(null)) != null) {
                    skuSupplyPriceDTO.setDfSupplyPrice(this.configBiz.getDecimalDigits(dfSkuSupplyPrice.getSupplyPrice(), supplyPriceDigits));
                }
            }
            skuSupplyPriceDTO.setCounterPrice(this.configBiz.getDecimalDigits(skuSupplyPriceDTO.getCounterPrice(), supplyPriceDigits));
            skuSupplyPriceDTO.setDfModifyPrice(this.configBiz.getDecimalDigits(skuSupplyPriceDTO.getDfModifyPrice(), supplyPriceDigits));
            skuSupplyPriceDTO.setPcModifyPrice(this.configBiz.getDecimalDigits(skuSupplyPriceDTO.getPcModifyPrice(), supplyPriceDigits));
            if (CollUtil.isNotEmpty(spuPictureList) && CollUtil.isNotEmpty(spuPictures = spuPictureList.stream().filter(s -> s.getPsSpuId().equals(skuSupplyPriceDTO.getSpuId())).collect(Collectors.toList()))) {
                skuSupplyPriceDTO.setSpuPictureUrl(((SpuPicture)spuPictures.get(0)).getPictureUrl());
            }
            if (SkuSupplyPriceStatusEnums.IN_FORCE.getCode().equals(queryDTO.getSkuSupplyPriceStatus())) {
                skuSupplyPriceDTO.setSkuSupplyPriceStatus(SkuSupplyPriceStatusEnums.IN_FORCE.getCode());
            }
            if (CollUtil.isNotEmpty(skuSupplyPrices = skuSupplyPriceList.stream().filter(item -> item.getPsSkuId().equals(skuSupplyPriceDTO.getSkuId())).collect(Collectors.toList()))) {
                skuSupplyPriceDTO.setLastSupplyPriceStatus(((SkuSupplyPrice)skuSupplyPrices.get(0)).getStatus());
            }
            if (CollUtil.isNotEmpty((Collection)skuBarCodeList) && CollUtil.isNotEmpty(skuBarCodes = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(skuSupplyPriceDTO.getSkuId())).collect(Collectors.toList()))) {
                skuSupplyPriceDTO.setBarCode(skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(",")));
            }
            if (isCostPrice && (sgBStorageCostVo = (SgBStorageCostVo)sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(skuSupplyPriceDTO.getSkuCode())).findAny().orElse(null)) != null) {
                if ("0E-8".equals(sgBStorageCostVo.getPriceCost().toString())) {
                    skuSupplyPriceDTO.setSgCostPrice("0.00000000");
                } else {
                    skuSupplyPriceDTO.setSgCostPrice(sgBStorageCostVo.getPriceCost().toString());
                }
            }
            if (!CollUtil.isNotEmpty((Collection)queryDTO.getSkuCodeDTOS()) || (codeDTO = (SkuCodeDTO)queryDTO.getSkuCodeDTOS().stream().filter(s -> s.getCode().equals(skuSupplyPriceDTO.getSkuCode()) || s.getCode().equals(skuSupplyPriceDTO.getWmsThirdPlatformCode())).findAny().orElse(null)) == null) continue;
            skuSupplyPriceDTO.setQty(codeDTO.getQty());
            skuSupplyPriceDTO.setUnitPrice(BigDecimalUtils.convert(codeDTO.getUnitPrice(), 2));
            skuSupplyPriceDTO.setSecondPrice(BigDecimalUtils.convert(codeDTO.getSecondPrice(), 2));
        }
        return page;
    }

    private void covertSupplyPriceQuery(SpuQueryDTO queryDTO) {
        if (queryDTO.getMinPcSupplyPrice() != null || queryDTO.getMaxPcSupplyPrice() != null || queryDTO.getMinDfSupplyPrice() != null || queryDTO.getMaxDfSupplyPrice() != null) {
            List skuSupplyPriceList = this.skuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseDo::getIsDelete, (Object)Boolean.FALSE)).eq(queryDTO.getMinPcSupplyPrice() != null || queryDTO.getMaxPcSupplyPrice() != null, SkuSupplyPrice::getType, (Object)SupplyPriceTypeEnums.ONE.getCode())).ge(queryDTO.getMinPcSupplyPrice() != null, SkuSupplyPrice::getSupplyPrice, (Object)queryDTO.getMinPcSupplyPrice())).le(queryDTO.getMaxPcSupplyPrice() != null, SkuSupplyPrice::getSupplyPrice, (Object)queryDTO.getMaxPcSupplyPrice())).eq(queryDTO.getMinDfSupplyPrice() != null || queryDTO.getMaxDfSupplyPrice() != null, SkuSupplyPrice::getType, (Object)SupplyPriceTypeEnums.TWO.getCode())).ge(queryDTO.getMinDfSupplyPrice() != null, SkuSupplyPrice::getSupplyPrice, (Object)queryDTO.getMinDfSupplyPrice())).le(queryDTO.getMaxDfSupplyPrice() != null, SkuSupplyPrice::getSupplyPrice, (Object)queryDTO.getMaxDfSupplyPrice()));
            if (CollUtil.isEmpty((Collection)skuSupplyPriceList)) {
                queryDTO.setSkuIdList((List)CollUtil.newArrayList((Object[])new Long[]{-1L}));
            } else {
                List skuIds = skuSupplyPriceList.stream().map(SkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
                if (CollUtil.isNotEmpty((Collection)queryDTO.getSkuIdList())) {
                    if (((Long)queryDTO.getSkuIdList().get(0)).equals(-1L)) {
                        return;
                    }
                    List idList = queryDTO.getSkuIdList().stream().filter(skuIds::contains).collect(Collectors.toList());
                    if (CollUtil.isEmpty(idList)) {
                        queryDTO.setSkuIdList((List)CollUtil.newArrayList((Object[])new Long[]{-1L}));
                    } else {
                        queryDTO.setSkuIdList(idList);
                    }
                }
                queryDTO.setSkuIdList(skuIds);
            }
        }
    }

    public List<String> selectSkuSupplyPriceTableCount(ApiRequest<SpuQueryDTO> request) {
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        this.skuBiz.covertCategory(queryDTO);
        if (StrUtil.isNotEmpty((CharSequence)queryDTO.getSceneCode())) {
            this.skuBiz.covertScene(queryDTO);
        }
        if (queryDTO.getStatus() == null) {
            queryDTO.setStatus(StatusEnums.ENABLED.getCode());
        }
        this.skuBiz.convertBrandPermission(queryDTO);
        queryDTO.setSkuSupplyPriceStatus(null);
        TableCountDTO tableCount = this.skuSupplyPriceService.selectSkuSupplyPriceTableCount(queryDTO);
        ArrayList countList = CollUtil.newArrayList((Object[])new String[0]);
        countList.add(this.covertCount(tableCount.getFirstTableNumL()));
        countList.add(this.covertCount(tableCount.getSecondTableNumL()));
        countList.add(this.covertCount(tableCount.getThirdTableNumL()));
        countList.add(this.covertCount(tableCount.getFourthTableNumL()));
        return countList;
    }

    public long selectCurrentSkuSupplyPriceTableCount(ApiRequest<SpuQueryDTO> request) {
        SpuQueryDTO queryDTO = (SpuQueryDTO)request.getJsonData();
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQuery(queryDTO);
        if (StrUtil.isNotEmpty((CharSequence)queryDTO.getSceneCode())) {
            this.skuBiz.covertScene(queryDTO);
        }
        if (queryDTO.getStatus() == null) {
            queryDTO.setStatus(StatusEnums.ENABLED.getCode());
        }
        this.skuBiz.convertBrandPermission(queryDTO);
        queryDTO.setSkuSupplyPriceStatus(null);
        TableCountDTO tableCount = this.skuSupplyPriceService.selectSkuSupplyPriceTableCount(queryDTO);
        return tableCount.getFifthTableNumL();
    }

    private String covertCount(Long count) {
        if (count > 9999L) {
            return "9999+";
        }
        return String.valueOf(count);
    }

    public void skuSupplyPriceRefreshStatus() {
        Date date = new Date();
        ArrayList<SkuSupplyPrice> skuSupplyPriceList = new ArrayList<SkuSupplyPrice>();
        List skuSupplyPrices = this.skuSupplyPriceService.selectByDate(SkuSupplyPriceStatusEnums.TO_BE_EFFECTIVE.getCode(), date);
        for (Object skuSupplyPrice : skuSupplyPrices) {
            skuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.IN_FORCE.getCode());
            skuSupplyPriceList.add((SkuSupplyPrice)skuSupplyPrice);
        }
        List supplyInForcePrices = this.skuSupplyPriceService.selectByInForce(SkuSupplyPriceStatusEnums.IN_FORCE.getCode(), date);
        for (SkuSupplyPrice skuSupplyPrice : supplyInForcePrices) {
            skuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.INVALID.getCode());
            skuSupplyPriceList.add(skuSupplyPrice);
        }
        this.skuSupplyPriceService.updateBatchById(skuSupplyPriceList);
        if (CollUtil.isNotEmpty(skuSupplyPriceList)) {
            this.covertProdUpdateToMallFourJ(skuSupplyPriceList);
            List skuIdList = skuSupplyPriceList.stream().map(SkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
            List skuList = this.skuService.listByIds(skuIdList);
            this.spuBiz.deleteRedisKeyList(skuList);
        }
    }

    public void revocation(ApiRequest<List<String>> request) {
        List oaIdList = (List)request.getJsonData();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)oaIdList), (String)"\u5ba1\u6279\u6d41id\u4e0d\u80fd\u4e3a\u7a7a");
        List oaIds = oaIdList.stream().distinct().collect(Collectors.toList());
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        String userJson = JSON.toJSONString((Object)user);
        ArrayList<CallSite> failMsg = new ArrayList<CallSite>();
        for (String oaId : oaIds) {
            List skuSupplyPriceList = this.skuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SkuSupplyPrice::getOaId, (Object)oaId)).eq(SkuSupplyPrice::getStatus, (Object)SkuSupplyPriceStatusEnums.IN_REVIEW.getCode()));
            ApiResponse apiResponse = this.oaAdapter.terminateWorkFlow(oaId, userJson);
            if (!apiResponse.isSuccess()) {
                failMsg.add((CallSite)((Object)("\u5ba1\u6279\u53f7:" + ((SkuSupplyPrice)skuSupplyPriceList.get(0)).getOaCode() + "\u64a4\u9500\u5931\u8d25;" + apiResponse.getDesc() + "</br>")));
                continue;
            }
            for (SkuSupplyPrice skuSupplyPrice : skuSupplyPriceList) {
                skuSupplyPrice.setStatus(SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode());
            }
            this.skuSupplyPriceService.updateBatchById((Collection)skuSupplyPriceList);
        }
        Assert.isTrue((boolean)CollUtil.isEmpty(failMsg), (String)((Object)failMsg).toString());
    }

    public void submit(ApiRequest<IdListDTO> request) {
        IdListDTO listDTO = (IdListDTO)request.getJsonData();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)listDTO.getIdList()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            for (Long id : listDTO.getIdList()) {
                String lockKey = "ps:sku_supply_price:save:" + id;
                RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u4f9b\u8d27\u4ef7\u5546\u54c1\u7528\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock);
            }
            List skuSupplyPriceList = this.skuSupplyPriceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuSupplyPrice::getPsSkuId, (Collection)listDTO.getIdList())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE)).eq(SkuSupplyPrice::getStatus, (Object)SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode()));
            if (CollUtil.isEmpty((Collection)skuSupplyPriceList)) {
                return;
            }
            LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            this.createOaFlow(skuSupplyPriceList, user, listDTO.getDingDingDeptId());
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("skuSupplyPriceBiz.submit Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    public void cancelApproval(ApiRequest<String> request) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)((CharSequence)request.getJsonData())), (String)"oaId\u4e0d\u80fd\u4e3a\u7a7a");
        List skuSupplyPriceList = this.skuSupplyPriceService.list((Wrapper)new QueryWrapper().lambda().eq(SkuSupplyPrice::getOaId, request.getJsonData()));
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)skuSupplyPriceList), (String)"");
        List skuSupplyPrices = skuSupplyPriceList.stream().filter(item -> !SkuSupplyPriceStatusEnums.IN_REVIEW.getCode().equals(item.getStatus())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(skuSupplyPrices), (String)"\u4f9b\u8d27\u4ef7\u4e0d\u662f\u5ba1\u6838\u4e2d\u72b6\u6001");
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse apiResponse = this.oaAdapter.terminateWorkFlow((String)request.getJsonData(), JSON.toJSONString((Object)user));
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        ArrayList prices = CollUtil.newArrayList((Object[])new SkuSupplyPrice[0]);
        for (SkuSupplyPrice skuSupplyPrice : skuSupplyPriceList) {
            SkuSupplyPrice price = new SkuSupplyPrice();
            price.setId(skuSupplyPrice.getId());
            price.setStatus(SkuSupplyPriceStatusEnums.TO_SUBMIT.getCode());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)price);
            prices.add(price);
        }
        this.skuSupplyPriceService.updateBatchById((Collection)prices);
    }

    public void covertProdUpdateToMallFourJ(List<SkuSupplyPrice> skuSupplyPriceList) {
        try {
            if (CollUtil.isEmpty(skuSupplyPriceList)) {
                return;
            }
            SystemConfigVO mallSystemConfigVO = this.mdmAdapter.queryBySystemConfigKeyCode("PS_MALL_STORE_ID");
            if (mallSystemConfigVO == null) {
                return;
            }
            Store store = (Store)this.storeService.getById((Serializable)Long.valueOf(mallSystemConfigVO.getValue()));
            if (store == null) {
                return;
            }
            List supplyPrices = skuSupplyPriceList.stream().filter(item -> SkuSupplyPriceStatusEnums.IN_FORCE.getCode().equals(item.getStatus())).collect(Collectors.toList());
            List skuIdList = supplyPrices.stream().filter(item -> ObjectUtil.equal((Object)store.getShelfConfig(), (Object)item.getType())).map(SkuSupplyPrice::getPsSkuId).collect(Collectors.toList());
            if (CollUtil.isEmpty(skuIdList)) {
                return;
            }
            List skuList = this.skuService.listByIds(skuIdList);
            List spuIdList = skuList.stream().map(Sku::getPsSpuId).collect(Collectors.toList());
            List spuList = this.spuService.listByIds(spuIdList);
            ArrayList updateDTOList = CollUtil.newArrayList((Object[])new ProdUpdateStocksDTO[0]);
            Map<Long, List<Sku>> map = skuList.stream().collect(Collectors.groupingBy(Sku::getPsSpuId));
            for (List<Sku> skus : map.values()) {
                Spu spu = spuList.stream().filter(item -> ObjectUtil.equal((Object)((Sku)skus.get(0)).getPsSpuId(), (Object)item.getId())).findAny().orElse(null);
                if (!StrUtil.equals((CharSequence)spu.getIsPushMallFourJ(), (CharSequence)YesOrNoEnum.YES.getCode())) continue;
                ProdUpdateStocksDTO spuForMallFourJDTO = new ProdUpdateStocksDTO();
                spuForMallFourJDTO.setPsProdCode(spu.getCode());
                ArrayList skuDtoList = CollUtil.newArrayList((Object[])new SkuParamDTO[0]);
                for (Sku sku : skus) {
                    SkuSupplyPrice skuSupplyPrice = supplyPrices.stream().filter(item -> ObjectUtil.equal((Object)store.getShelfConfig(), (Object)item.getType()) && ObjectUtil.equal((Object)sku.getId(), (Object)item.getPsSkuId())).findAny().orElse(null);
                    SkuParamDTO skuMallFourJDTO = new SkuParamDTO();
                    skuMallFourJDTO.setPsSkuCode(sku.getCode());
                    skuMallFourJDTO.setPrice(skuSupplyPrice.getSupplyPrice());
                    skuDtoList.add(skuMallFourJDTO);
                }
                spuForMallFourJDTO.setSkuParamList((List)skuDtoList);
                updateDTOList.add(spuForMallFourJDTO);
            }
            if (CollUtil.isNotEmpty((Collection)updateDTOList)) {
                this.mallFourJAdapter.prodStocksUpdateToMallFourJ(updateDTOList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u4ef7\u683c \u5546\u57ce\u4fe1\u606f\u5931\u8d25  msg=[{}]", (Object)e.getMessage());
        }
    }
}

