/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.spec.SpecVO;
import com.xinqiyi.ps.api.model.vo.spec.SpecValueVO;
import com.xinqiyi.ps.dao.mapper.mysql.SpecMapper;
import com.xinqiyi.ps.dao.repository.impl.SkuSpecServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.SpecServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.SpecValueServiceImpl;
import com.xinqiyi.ps.model.dto.page.PageResult;
import com.xinqiyi.ps.model.dto.sku.SpecDTO;
import com.xinqiyi.ps.model.dto.spec.SpecAddDTO;
import com.xinqiyi.ps.model.dto.spec.SpecOprDTO;
import com.xinqiyi.ps.model.dto.spec.SpecQueryDTO;
import com.xinqiyi.ps.model.dto.spec.SpecUpdateDTO;
import com.xinqiyi.ps.model.entity.Spec;
import com.xinqiyi.ps.model.entity.SpecValue;
import com.xinqiyi.ps.service.adapter.mall4j.MallFourJAdapter;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SpecBiz {
    private static final Logger log = LoggerFactory.getLogger(SpecBiz.class);
    @Autowired
    private SpecServiceImpl specService;
    @Autowired
    private IdSequenceGenerator idSequenceGenerator;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private SpecValueServiceImpl specValueService;
    @Autowired
    private SkuSpecServiceImpl skuSpecService;
    @Autowired
    private MallFourJAdapter mallFourJAdapter;

    public Long saveSpec(SpecAddDTO dto) {
        Spec spec = this.specService.selectSpecByName(dto.getName());
        Assert.isTrue((null == spec ? 1 : 0) != 0, (String)"\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        spec = new Spec();
        Long specId = this.idSequenceGenerator.generateId(Spec.class);
        spec.setId(specId);
        spec.setName(dto.getName());
        spec.setStatus(Integer.valueOf(1));
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)spec);
        List<SpecValue> specValueList = this.getSpecValueList(dto.getValueList(), specId);
        this.specService.saveSpec(spec, specValueList);
        try {
            SpecDTO specDTO = new SpecDTO();
            specDTO.setPsSpecId(spec.getId());
            specDTO.setPsSpecName(spec.getName());
            List valusList = specValueList.stream().map(SpecValue::getValue).collect(Collectors.toList());
            specDTO.setSpecValueNameList(valusList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return specId;
    }

    public void updateSpec(SpecUpdateDTO dto) {
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        this.updateSpec(dto, userInfo);
    }

    public void updateSpec(SpecUpdateDTO dto, LoginUserInfo userInfo) {
        Spec spec = this.specService.selectSpecByName(dto.getName());
        if (null != spec && !dto.getId().equals(spec.getId())) {
            throw new IllegalArgumentException("\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        spec = (Spec)this.specService.getById((Serializable)dto.getId());
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)spec), (String)"\u89c4\u683c\u6570\u636e\u4e0d\u5b58\u5728");
        ArrayList<SpecValue> valueList = new ArrayList<SpecValue>();
        if (Integer.valueOf(2).equals(spec.getStatus()) || Integer.valueOf(3).equals(spec.getStatus())) {
            if (ObjectUtil.isNotNull((Object)dto.getName()) && !dto.getName().equals(spec.getName())) {
                throw new IllegalArgumentException("\u542f\u7528\u72b6\u6001\u4e0b\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4fee\u6539");
            }
            if (CollUtil.isNotEmpty((Collection)dto.getValueList())) {
                List specValueList = this.specValueService.getSpecValueListBySpecId(dto.getId());
                ArrayList newSpecValueList = new ArrayList();
                dto.getValueList().stream().forEach(d -> {
                    boolean flag = true;
                    for (SpecValue specValue : specValueList) {
                        if (!specValue.getValue().equals(d)) continue;
                        valueList.add(specValue);
                        newSpecValueList.add(specValue);
                        flag = false;
                        break;
                    }
                    if (flag) {
                        SpecValue specValue = new SpecValue();
                        Long specValueId = this.idSequenceGenerator.generateId(SpecValue.class);
                        specValue.setId(specValueId);
                        specValue.setPsSpecId(dto.getId());
                        specValue.setValue(d);
                        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)specValue);
                        valueList.add(specValue);
                    }
                });
                if (specValueList.size() != newSpecValueList.size()) {
                    throw new IllegalArgumentException("\u65e7\u7684\u89c4\u683c\u503c\u4e0d\u5141\u8bb8\u4fee\u6539");
                }
            }
        } else {
            valueList.addAll(this.getSpecValueList(dto.getValueList(), dto.getId()));
        }
        spec.setName(dto.getName());
        spec.setUpdateTime(new Date());
        spec.setUpdateUserName(userInfo.getName());
        this.specService.updateSpec(spec, valueList);
        if (spec.getStatus() == 2) {
            try {
                ArrayList<SpecDTO> specDTOList = new ArrayList<SpecDTO>();
                SpecDTO specDTO = new SpecDTO();
                specDTO.setPsSpecId(spec.getId());
                specDTO.setPsSpecName(spec.getName());
                List valusList = valueList.stream().map(SpecValue::getValue).collect(Collectors.toList());
                specDTO.setSpecValueNameList(valusList);
                specDTOList.add(specDTO);
                this.mallFourJAdapter.saveSpecToMallFourJ(specDTOList);
            }
            catch (Exception e) {
                log.error("updateSpec.saveSpecToMallFourJ.Exception", (Throwable)e);
            }
        }
    }

    public Long createSpecValue(Long specId, String spuSpecValue) {
        SpecValue specValueInfo = new SpecValue();
        Long specValueId = this.idSequenceGenerator.generateId(SpecValue.class);
        specValueInfo.setId(specValueId);
        specValueInfo.setPsSpecId(specId);
        specValueInfo.setValue(spuSpecValue);
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)specValueInfo);
        this.specValueService.save((Object)specValueInfo);
        return specValueId;
    }

    private List<SpecValue> getSpecValueList(List<String> valueList, Long specId) {
        ArrayList<SpecValue> specValueList = new ArrayList<SpecValue>();
        if (CollUtil.isNotEmpty(valueList)) {
            valueList.stream().forEach(value -> {
                SpecValue specValue = new SpecValue();
                Long specValueId = this.idSequenceGenerator.generateId(SpecValue.class);
                specValue.setId(specValueId);
                specValue.setPsSpecId(specId);
                specValue.setValue(value);
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)specValue);
                specValueList.add(specValue);
            });
        }
        return specValueList;
    }

    public PageResult selectSpecList(SpecQueryDTO dto) {
        Page page = new Page((long)dto.getPageNum(), (long)dto.getPageSize());
        IPage iPage = this.specService.selectSpecList(page, dto);
        List<SpecVO> list = this.getSpecVOList(iPage.getRecords());
        return new PageResult(dto.getPageNum(), dto.getPageSize(), page.getTotal()).setData(list);
    }

    public List<SpecVO> selectAllSpecList(SpecQueryDTO dto) {
        List specList = this.specService.selectAllSpecList(dto);
        return this.getSpecVOList(specList);
    }

    private List<SpecVO> getSpecVOList(List<Spec> list) {
        List<SpecVO> specVOList = new ArrayList<SpecVO>();
        if (CollUtil.isNotEmpty(list)) {
            specVOList = BeanConvertUtil.convertList(list, SpecVO.class);
            List specIdList = specVOList.stream().map(SpecVO::getId).collect(Collectors.toList());
            List specValueList = this.specValueService.getSpecValueBySpecId(specIdList);
            specVOList.stream().forEach(specVO -> {
                ArrayList valueVOList = new ArrayList();
                specValueList.stream().forEach(specValue -> {
                    if (specVO.getId().equals(specValue.getPsSpecId())) {
                        SpecValueVO valueVO = new SpecValueVO();
                        BeanUtils.copyProperties((Object)specValue, (Object)valueVO);
                        valueVOList.add(valueVO);
                    }
                });
                specVO.setSpecValueVOList(valueVOList);
                specVO.setValues(valueVOList.stream().map(SpecValueVO::getValue).collect(Collectors.joining(",")));
            });
        }
        return specVOList;
    }

    public SpecVO selectSpecDetails(Long id) {
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)id), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Spec spec = (Spec)this.specService.getById((Serializable)id);
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)spec), (String)"\u89c4\u683c\u6570\u636e\u4e0d\u5b58\u5728");
        SpecVO vo = new SpecVO();
        BeanUtils.copyProperties((Object)spec, (Object)vo);
        ArrayList<Long> specIdList = new ArrayList<Long>();
        specIdList.add(vo.getId());
        List list = this.specValueService.getSpecValueBySpecId(specIdList);
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<SpecValueVO> specValueVOList = BeanConvertUtil.convertList(list, SpecValueVO.class);
            vo.setSpecValueVOList(specValueVOList);
            vo.setValues(specValueVOList.stream().map(SpecValueVO::getValue).collect(Collectors.joining(",")));
        }
        return vo;
    }

    public SpecVO selectSpecByName(String name) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Spec::getName, (Object)name);
        Spec spec = (Spec)((SpecMapper)this.specService.getBaseMapper()).selectOne((Wrapper)queryWrapper);
        if (spec == null) {
            return null;
        }
        SpecVO vo = new SpecVO();
        BeanUtils.copyProperties((Object)spec, (Object)vo);
        ArrayList<Long> specIdList = new ArrayList<Long>();
        specIdList.add(vo.getId());
        List list = this.specValueService.getSpecValueBySpecId(specIdList);
        if (CollUtil.isNotEmpty((Collection)list)) {
            List<SpecValueVO> specValueVOList = BeanConvertUtil.convertList(list, SpecValueVO.class);
            vo.setSpecValueVOList(specValueVOList);
            vo.setValues(specValueVOList.stream().map(SpecValueVO::getValue).collect(Collectors.joining(",")));
        }
        return vo;
    }

    public void updateBatchSpecStatus(SpecOprDTO dto) {
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        ArrayList specList = new ArrayList();
        dto.getIdList().forEach(id -> {
            Spec spec = (Spec)this.specService.getById((Serializable)id);
            Assert.isTrue((null != spec ? 1 : 0) != 0, (String)("\u89c4\u683c\u6570\u636e\u4e0d\u5b58\u5728,id\u4e3a\uff1a" + id));
            if (3 == dto.getType()) {
                List skuSpecList = this.skuSpecService.selectBySpecId(id);
                if (CollUtil.isNotEmpty((Collection)skuSpecList)) {
                    throw new IllegalArgumentException("\u89c4\u683c\u5df2\u88ab\u5546\u54c1\u4f7f\u7528,\u65e0\u6cd5\u5220\u9664,\u89c4\u683c\u4e3a\uff1a" + spec.getName());
                }
                spec.setIsDelete(Integer.valueOf(1));
            } else if (1 == dto.getType()) {
                spec.setStatus(Integer.valueOf(2));
            } else if (2 == dto.getType()) {
                List skuSpecList = this.skuSpecService.selectBySpecId(id);
                if (CollUtil.isNotEmpty((Collection)skuSpecList)) {
                    throw new IllegalArgumentException("\u89c4\u683c\u5df2\u88ab\u5546\u54c1\u4f7f\u7528,\u65e0\u6cd5\u505c\u7528,\u89c4\u683c\u4e3a\uff1a" + spec.getName());
                }
                spec.setStatus(Integer.valueOf(3));
            } else {
                throw new IllegalArgumentException("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
            }
            spec.setUpdateTime(new Date());
            spec.setUpdateUserName(userInfo.getName());
            specList.add(spec);
        });
        this.specService.updateBatchById(specList);
        if (1 == dto.getType()) {
            ArrayList<SpecDTO> specDTOList = new ArrayList<SpecDTO>();
            for (Spec spec : specList) {
                SpecDTO specDTO = new SpecDTO();
                BeanUtils.copyProperties((Object)spec, (Object)specDTO);
                specDTO.setPsSpecId(spec.getId());
                specDTO.setPsSpecName(spec.getName());
                List valueList = this.specValueService.getSpecValueListBySpecId(spec.getId());
                if (CollUtil.isNotEmpty((Collection)valueList)) {
                    specDTO.setSpecValueNameList(valueList.stream().map(SpecValue::getValue).collect(Collectors.toList()));
                }
                specDTOList.add(specDTO);
            }
            this.mallFourJAdapter.saveSpecToMallFourJ(specDTOList);
        } else if (3 == dto.getType() || 2 == dto.getType()) {
            for (Spec spec : specList) {
                this.mallFourJAdapter.deleteSpecToMallFourJ(spec.getId());
            }
        }
    }

    public Long saveAndStartSpec(SpecAddDTO dto) {
        Long id = this.saveSpec(dto);
        Spec spec = (Spec)this.specService.getById((Serializable)id);
        spec.setStatus(Integer.valueOf(2));
        this.specService.updateById((Object)spec);
        return id;
    }
}

