/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.dao.repository.CategoryAttributeService;
import com.xinqiyi.ps.dao.repository.CategoryAttributeValueService;
import com.xinqiyi.ps.dao.repository.SpuAttributeService;
import com.xinqiyi.ps.dao.repository.SpuAttributeValueService;
import com.xinqiyi.ps.dao.util.BeanConvertUtil;
import com.xinqiyi.ps.model.dto.enums.AttributeTypeStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SpuShelflifeUnitEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.spu.QuerySpuAttributeDTO;
import com.xinqiyi.ps.model.dto.spu.QuerySpuAttributeValueDTO;
import com.xinqiyi.ps.model.dto.spu.SkuSubscribeDTO;
import com.xinqiyi.ps.model.dto.spu.SpuAttributeDTO;
import com.xinqiyi.ps.model.dto.spu.SpuAttributeMiniDTO;
import com.xinqiyi.ps.model.entity.CategoryAttribute;
import com.xinqiyi.ps.model.entity.CategoryAttributeValue;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.SpuAttribute;
import com.xinqiyi.ps.model.entity.SpuAttributeValue;
import com.xinqiyi.ps.model.entity.dto.SaveSpuAttributeDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SpuAttributeBiz {
    @Autowired
    private CategoryAttributeService categoryAttributeService;
    @Autowired
    private CategoryAttributeValueService categoryAttributeValueService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private SpuAttributeService spuAttributeService;
    @Autowired
    private SpuAttributeValueService spuAttributeValueService;

    public void checkSave(List<SpuAttributeDTO> spuAttributeList) {
        for (SpuAttributeDTO attributeDTO : spuAttributeList) {
            CategoryAttribute categoryAttribute = this.categoryAttributeService.getByStatus(attributeDTO.getPsCategoryAttributeId(), Boolean.FALSE, StatusEnums.ENABLED.getCode());
            Assert.notNull((Object)categoryAttribute, (String)"\u7c7b\u76ee\u5c5e\u6027\u4e0d\u5b58\u5728");
            if (this.checkAttributeValue(attributeDTO, categoryAttribute)) continue;
            if (AttributeTypeStatusEnums.TEXT.getCode().equals(categoryAttribute.getType())) {
                Assert.isTrue((categoryAttribute.getTextLenth() >= attributeDTO.getCategoryAttributeValue().length() ? 1 : 0) != 0, (String)"\u6587\u672c\u957f\u5ea6\u8d85\u51fa\u8303\u56f4");
            } else if (AttributeTypeStatusEnums.NUMBER.getCode().equals(categoryAttribute.getType())) {
                Assert.isTrue((NumberUtil.isInteger((String)attributeDTO.getCategoryAttributeValue()) || NumberUtil.isDouble((String)attributeDTO.getCategoryAttributeValue()) ? 1 : 0) != 0, (String)(categoryAttribute.getName() + "\u8bf7\u8f93\u5165\u6570\u503c\u7c7b\u578b"));
                Assert.isTrue((boolean)categoryAttribute.getNumberAccuracy().equals(StringUtils.substringAfter((String)attributeDTO.getCategoryAttributeValue(), (String)".").length()), (String)(categoryAttribute.getName() + " \u6570\u503c\u7cbe\u5ea6\u4e0d\u6b63\u786e"));
            }
            if (!CollUtil.isNotEmpty((Collection)attributeDTO.getPsCategoryAttributeValueIdList())) continue;
            for (Long attributeValueId : attributeDTO.getPsCategoryAttributeValueIdList()) {
                if (attributeValueId == null) continue;
                CategoryAttributeValue attributeValue = (CategoryAttributeValue)this.categoryAttributeValueService.getById((Serializable)attributeValueId);
                Assert.notNull((Object)attributeValue, (String)"\u7c7b\u76ee\u5c5e\u6027\u503c\u4e0d\u5b58\u5728");
            }
        }
    }

    private boolean checkAttributeValue(SpuAttributeDTO attributeDTO, CategoryAttribute categoryAttribute) {
        if ((AttributeTypeStatusEnums.TEXT.getCode().equals(categoryAttribute.getType()) || AttributeTypeStatusEnums.TIME.getCode().equals(categoryAttribute.getType()) || AttributeTypeStatusEnums.DATE.getCode().equals(categoryAttribute.getType()) || AttributeTypeStatusEnums.NUMBER.getCode().equals(categoryAttribute.getType())) && StrUtil.isEmpty((CharSequence)attributeDTO.getCategoryAttributeValue())) {
            return true;
        }
        return (AttributeTypeStatusEnums.RADIO.getCode().equals(categoryAttribute.getType()) || AttributeTypeStatusEnums.MULTI_SELECT.getCode().equals(categoryAttribute.getType())) && CollUtil.isEmpty((Collection)attributeDTO.getPsCategoryAttributeValueIdList());
    }

    SaveSpuAttributeDTO convert(List<SpuAttributeDTO> spuAttributeDTOs, Long spuId) {
        ArrayList<SpuAttribute> spuAttributeList = new ArrayList<SpuAttribute>();
        ArrayList<SpuAttributeValue> spuAttributeValueList = new ArrayList<SpuAttributeValue>();
        for (SpuAttributeDTO attributeDTO : spuAttributeDTOs) {
            Object date;
            SpuAttribute spuAttribute = new SpuAttribute();
            BeanConvertUtil.copyProperties((Object)attributeDTO, (Object)spuAttribute);
            spuAttribute.setId(this.idSequence.generateId(SpuAttribute.class));
            spuAttribute.setPsSpuId(spuId);
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)spuAttribute);
            CategoryAttribute categoryAttribute = this.categoryAttributeService.getByStatus(attributeDTO.getPsCategoryAttributeId(), Boolean.valueOf(attributeDTO.getPsCategoryAttributeId().equals(spuAttribute.getPsCategoryAttributeId())), StatusEnums.ENABLED.getCode());
            if (this.checkAttributeValue(attributeDTO, categoryAttribute)) continue;
            if (AttributeTypeStatusEnums.DATE.getCode().equals(categoryAttribute.getType())) {
                date = DateUtil.format((Date)DateUtil.parse((CharSequence)attributeDTO.getCategoryAttributeValue(), (String)DatePattern.NORM_DATE_FORMAT.getPattern()), (String)DatePattern.NORM_DATE_FORMAT.getPattern());
                attributeDTO.setCategoryAttributeValue((String)date);
            }
            if (AttributeTypeStatusEnums.TIME.getCode().equals(categoryAttribute.getType())) {
                date = DateUtil.format((Date)DateUtil.parse((CharSequence)attributeDTO.getCategoryAttributeValue(), (String)DatePattern.NORM_DATETIME_FORMAT.getPattern()), (String)DatePattern.NORM_DATETIME_FORMAT.getPattern());
                attributeDTO.setCategoryAttributeValue((String)date);
            }
            spuAttribute.setAttributeName(categoryAttribute.getName());
            spuAttributeList.add(spuAttribute);
            if (CollUtil.isNotEmpty((Collection)attributeDTO.getPsCategoryAttributeValueIdList())) {
                for (Long attributeValueId : attributeDTO.getPsCategoryAttributeValueIdList()) {
                    CategoryAttributeValue attributeValue = (CategoryAttributeValue)this.categoryAttributeValueService.getById((Serializable)attributeValueId);
                    SpuAttributeValue spuAttributeValue = new SpuAttributeValue();
                    if (attributeValue != null) {
                        spuAttributeValue.setPsSpuAttributeId(attributeValue.getId());
                        spuAttributeValue.setAttributeValue(attributeValue.getValue());
                    }
                    spuAttributeValue.setId(this.idSequence.generateId(SpuAttributeValue.class));
                    spuAttributeValue.setPsSpuAttributeId(spuAttribute.getId());
                    spuAttributeValue.setPsCategoryAttributeValueId(attributeValueId);
                    this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)spuAttributeValue);
                    spuAttributeValueList.add(spuAttributeValue);
                }
                continue;
            }
            SpuAttributeValue spuAttributeValue = new SpuAttributeValue();
            spuAttributeValue.setAttributeValue(attributeDTO.getCategoryAttributeValue());
            spuAttributeValue.setId(this.idSequence.generateId(SpuAttributeValue.class));
            spuAttributeValue.setPsSpuAttributeId(spuAttribute.getId());
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)spuAttributeValue);
            spuAttributeValueList.add(spuAttributeValue);
        }
        SaveSpuAttributeDTO saveSpuAttributeDTO = new SaveSpuAttributeDTO();
        saveSpuAttributeDTO.setSpuAttributeList(spuAttributeList);
        saveSpuAttributeDTO.setSpuAttributeValueList(spuAttributeValueList);
        return saveSpuAttributeDTO;
    }

    List<SpuAttribute> selectBySpuId(Long psSpuId) {
        return this.spuAttributeService.selectBySpuId(psSpuId);
    }

    List<QuerySpuAttributeDTO> selectAttribute(Long spuId, Long categoryId) {
        List spuAttributeList = this.spuAttributeService.selectSortBySpuId(spuId, categoryId);
        List spuAttributeDTOList = BeanConvertUtil.convertList((List)spuAttributeList, QuerySpuAttributeDTO.class);
        for (QuerySpuAttributeDTO querySpuAttributeDTO : spuAttributeDTOList) {
            CategoryAttribute categoryAttribute = (CategoryAttribute)this.categoryAttributeService.getById((Serializable)querySpuAttributeDTO.getPsCategoryAttributeId());
            querySpuAttributeDTO.setAttributeType(categoryAttribute.getType());
            List spuAttributeValues = this.spuAttributeValueService.selectByAttributeId(querySpuAttributeDTO.getId());
            List attributeValueDTOS = BeanConvertUtil.convertList((List)spuAttributeValues, QuerySpuAttributeValueDTO.class);
            querySpuAttributeDTO.setSpuAttributeValueList(attributeValueDTOS);
        }
        return spuAttributeDTOList;
    }

    public List<SpuAttributeMiniDTO> selectAttributeList(Spu spu, List<SkuSubscribeDTO> skuSubscribeDTOList) {
        List spuAttributeList = this.spuAttributeService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SpuAttribute::getPsSpuId, (Object)spu.getId())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        ArrayList dtoList = CollUtil.newArrayList((Object[])new SpuAttributeMiniDTO[0]);
        SpuAttributeMiniDTO brandDTO = new SpuAttributeMiniDTO();
        brandDTO.setAttributeName("\u54c1\u724c");
        brandDTO.setAttributeValue(spu.getPsBrandName());
        dtoList.add(brandDTO);
        SpuAttributeMiniDTO shelfLifeDTO = new SpuAttributeMiniDTO();
        shelfLifeDTO.setAttributeName("\u4fdd\u8d28\u671f");
        if (spu.getShelfLife() != null && spu.getShelfLifeUnit() != null) {
            shelfLifeDTO.setAttributeValue(spu.getShelfLife() + SpuShelflifeUnitEnums.getDescByCode((Integer)spu.getShelfLifeUnit()));
        } else {
            shelfLifeDTO.setAttributeValue("--");
        }
        dtoList.add(shelfLifeDTO);
        SpuAttributeMiniDTO productionPlaceDTO = new SpuAttributeMiniDTO();
        productionPlaceDTO.setAttributeName("\u4ea7\u5730");
        if (StrUtil.isNotBlank((CharSequence)spu.getProductionPlace())) {
            productionPlaceDTO.setAttributeValue(spu.getProductionPlace());
        } else {
            productionPlaceDTO.setAttributeValue("--");
        }
        dtoList.add(productionPlaceDTO);
        SpuAttributeMiniDTO specValueDTO = new SpuAttributeMiniDTO();
        specValueDTO.setAttributeName("\u89c4\u683c");
        specValueDTO.setAttributeValue(skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSpecValue).collect(Collectors.joining("/")));
        dtoList.add(specValueDTO);
        if (CollUtil.isEmpty((Collection)spuAttributeList)) {
            return dtoList;
        }
        List spuAttributeIdList = spuAttributeList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List spuAttributeValues = this.spuAttributeValueService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SpuAttributeValue::getPsSpuAttributeId, spuAttributeIdList)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        for (SpuAttribute spuAttribute : spuAttributeList) {
            SpuAttributeMiniDTO spuAttributeMiniDTO = new SpuAttributeMiniDTO();
            spuAttributeMiniDTO.setAttributeName(spuAttribute.getAttributeName());
            String spuAttributeValueList = spuAttributeValues.stream().filter(item -> ObjectUtil.equal((Object)item.getPsSpuAttributeId(), (Object)spuAttribute.getId()) && StrUtil.isNotBlank((CharSequence)item.getAttributeValue())).map(SpuAttributeValue::getAttributeValue).collect(Collectors.joining("\u3001"));
            spuAttributeMiniDTO.setAttributeValue(spuAttributeValueList);
            if (StrUtil.isBlank((CharSequence)spuAttributeMiniDTO.getAttributeValue())) {
                productionPlaceDTO.setAttributeValue("--");
            }
            dtoList.add(spuAttributeMiniDTO);
        }
        return dtoList;
    }
}

