/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.handler.inter.IExcelVerifyHandler;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.xinqiyi.cus.model.dto.customer.CustomerOrderConfigureDetailsDTO;
import com.xinqiyi.cus.vo.CustomerStatusVO;
import com.xinqiyi.cus.vo.CustomerVO;
import com.xinqiyi.cus.vo.customer.CusCustomerOrderConfigurationVO;
import com.xinqiyi.dynamicform.dao.repository.DictRedisRepository;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.dynamicform.model.request.QueryDynamicFormDataRequest;
import com.xinqiyi.dynamicform.service.DynamicTableOperator;
import com.xinqiyi.fc.api.model.vo.FcSaleCompanyVO;
import com.xinqiyi.fc.model.dto.basic.FcSaleCompanyDto;
import com.xinqiyi.fc.model.enums.FcCommonEnum;
import com.xinqiyi.framework.api.model.ApiRequest;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginFrom;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.data.dao.repository.DataRedisRepository;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.model.PageResponse;
import com.xinqiyi.framework.model.search.CommonSearchRequest;
import com.xinqiyi.framework.model.search.ConditionRelation;
import com.xinqiyi.framework.model.search.SearchCondition;
import com.xinqiyi.framework.model.search.SearchType;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.DistributedSequenceGenerator;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.sequence.model.SequenceInfo;
import com.xinqiyi.framework.util.BigDecimalUtil;
import com.xinqiyi.mc.api.model.vo.act.McSkuVO;
import com.xinqiyi.mc.api.model.vo.act.orderGift.ReturnGiftsVO;
import com.xinqiyi.mdm.api.model.vo.salesman.SalesmanVO;
import com.xinqiyi.mdm.api.model.vo.systemconfig.SystemConfigVO;
import com.xinqiyi.mdm.common.PsRedisKeyConstants;
import com.xinqiyi.oa.api.WorkFlowApi;
import com.xinqiyi.oa.model.dto.enums.OaResultEnum;
import com.xinqiyi.ps.api.model.vo.PsBasicsBatchVO;
import com.xinqiyi.ps.api.model.vo.spu.BrandSubscribeForLiteAppVO;
import com.xinqiyi.ps.api.model.vo.spu.BrandSubscribeVO;
import com.xinqiyi.ps.dao.repository.BrandService;
import com.xinqiyi.ps.dao.repository.CategoryService;
import com.xinqiyi.ps.dao.repository.ComposeSkuService;
import com.xinqiyi.ps.dao.repository.PsSkuTagService;
import com.xinqiyi.ps.dao.repository.PsSkuWmsService;
import com.xinqiyi.ps.dao.repository.PsStoreSpuAliasService;
import com.xinqiyi.ps.dao.repository.PsTagService;
import com.xinqiyi.ps.dao.repository.SkuBarCodeService;
import com.xinqiyi.ps.dao.repository.SkuService;
import com.xinqiyi.ps.dao.repository.SkuShelfService;
import com.xinqiyi.ps.dao.repository.SkuSupplyPriceService;
import com.xinqiyi.ps.dao.repository.SpuAttributeValueService;
import com.xinqiyi.ps.dao.repository.SpuService;
import com.xinqiyi.ps.dao.repository.StoreBrandSortService;
import com.xinqiyi.ps.dao.repository.StoreCountrySortService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.dao.repository.UnitService;
import com.xinqiyi.ps.model.dto.ComposeSkuWeightDTO;
import com.xinqiyi.ps.model.dto.enums.AllocationRuleEnums;
import com.xinqiyi.ps.model.dto.enums.CheckStatusEnums;
import com.xinqiyi.ps.model.dto.enums.CopyInsertEnum;
import com.xinqiyi.ps.model.dto.enums.InnerLogTypeEnum;
import com.xinqiyi.ps.model.dto.enums.InventoryShowTypeEnum;
import com.xinqiyi.ps.model.dto.enums.IsDeleteEnums;
import com.xinqiyi.ps.model.dto.enums.MoneyTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SkuShelfStatusEnums;
import com.xinqiyi.ps.model.dto.enums.SkuSpecTypeEnums;
import com.xinqiyi.ps.model.dto.enums.SkuTypeEnums;
import com.xinqiyi.ps.model.dto.enums.SpuClassifyEnums;
import com.xinqiyi.ps.model.dto.enums.SpuShelflifeUnitEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.enums.StoreTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.WhetherEnum;
import com.xinqiyi.ps.model.dto.enums.WmsStatusEnum;
import com.xinqiyi.ps.model.dto.enums.WmsTypeEnum;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.ps.model.dto.excel.ImportSpuDTO;
import com.xinqiyi.ps.model.dto.excel.ImportSpuExcelDTO;
import com.xinqiyi.ps.model.dto.excel.ImportSpuExcelOfModeDTO;
import com.xinqiyi.ps.model.dto.sku.ComposeSkuOaExportDTO;
import com.xinqiyi.ps.model.dto.sku.InteriorSkuDTO;
import com.xinqiyi.ps.model.dto.sku.QueryComposeSkuDTO;
import com.xinqiyi.ps.model.dto.sku.QueryInteriorSkuDTO;
import com.xinqiyi.ps.model.dto.sku.QuerySkuDTO;
import com.xinqiyi.ps.model.dto.sku.QuerySkuSpecDTO;
import com.xinqiyi.ps.model.dto.sku.SaveSkuDTO;
import com.xinqiyi.ps.model.dto.sku.SkuDTO;
import com.xinqiyi.ps.model.dto.sku.SkuOaExportDTO;
import com.xinqiyi.ps.model.dto.sku.SkuTagDTO;
import com.xinqiyi.ps.model.dto.sku.SpecDTO;
import com.xinqiyi.ps.model.dto.spu.BrandSubscribeDTO;
import com.xinqiyi.ps.model.dto.spu.CategorySubscribeDTO;
import com.xinqiyi.ps.model.dto.spu.ComposeExportDTO;
import com.xinqiyi.ps.model.dto.spu.ComposeSpuDTO;
import com.xinqiyi.ps.model.dto.spu.DisableHintDTO;
import com.xinqiyi.ps.model.dto.spu.MiniSpuQueryDTO;
import com.xinqiyi.ps.model.dto.spu.PhyStorageDTO;
import com.xinqiyi.ps.model.dto.spu.PsBrandIdSerialNoDTO;
import com.xinqiyi.ps.model.dto.spu.QuerySpuAttributeDTO;
import com.xinqiyi.ps.model.dto.spu.QuerySpuDTO;
import com.xinqiyi.ps.model.dto.spu.QuerySpuPictureDTO;
import com.xinqiyi.ps.model.dto.spu.ShelfSpuDTO;
import com.xinqiyi.ps.model.dto.spu.SkuLogoDTO;
import com.xinqiyi.ps.model.dto.spu.SkuQtyDTO;
import com.xinqiyi.ps.model.dto.spu.SkuSubscribeDTO;
import com.xinqiyi.ps.model.dto.spu.SkuWithClientDTO;
import com.xinqiyi.ps.model.dto.spu.SpuAttributeMiniDTO;
import com.xinqiyi.ps.model.dto.spu.SpuComposeExportDTO;
import com.xinqiyi.ps.model.dto.spu.SpuComposeOaExportDTO;
import com.xinqiyi.ps.model.dto.spu.SpuComposeOaListDTO;
import com.xinqiyi.ps.model.dto.spu.SpuComposeSkuExportDTO;
import com.xinqiyi.ps.model.dto.spu.SpuComposeTableKeyDTO;
import com.xinqiyi.ps.model.dto.spu.SpuDTO;
import com.xinqiyi.ps.model.dto.spu.SpuDetailWithClientDTO;
import com.xinqiyi.ps.model.dto.spu.SpuDetailsDTO;
import com.xinqiyi.ps.model.dto.spu.SpuDetailsQueryDTO;
import com.xinqiyi.ps.model.dto.spu.SpuExportDTO;
import com.xinqiyi.ps.model.dto.spu.SpuIdsDTO;
import com.xinqiyi.ps.model.dto.spu.SpuOaExportDTO;
import com.xinqiyi.ps.model.dto.spu.SpuOaHeaderDTO;
import com.xinqiyi.ps.model.dto.spu.SpuOaListDTO;
import com.xinqiyi.ps.model.dto.spu.SpuPictureDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryDTO;
import com.xinqiyi.ps.model.dto.spu.SpuQueryV2DTO;
import com.xinqiyi.ps.model.dto.spu.SpuSubscribeDTO;
import com.xinqiyi.ps.model.dto.spu.SpuTableKeyDTO;
import com.xinqiyi.ps.model.dto.spu.SpuWithPriceDTO;
import com.xinqiyi.ps.model.dto.spu.UpdateDetailsDTO;
import com.xinqiyi.ps.model.dto.spu.WmsDTO;
import com.xinqiyi.ps.model.dto.store.brandSort.StoreBrandSortDTO;
import com.xinqiyi.ps.model.dto.store.countrySort.StoreCountrySortDTO;
import com.xinqiyi.ps.model.entity.Brand;
import com.xinqiyi.ps.model.entity.Category;
import com.xinqiyi.ps.model.entity.ComposeSku;
import com.xinqiyi.ps.model.entity.PsSkuTag;
import com.xinqiyi.ps.model.entity.PsSkuWms;
import com.xinqiyi.ps.model.entity.PsStoreSpuAlias;
import com.xinqiyi.ps.model.entity.PsTag;
import com.xinqiyi.ps.model.entity.Sku;
import com.xinqiyi.ps.model.entity.SkuBarCode;
import com.xinqiyi.ps.model.entity.SkuShelf;
import com.xinqiyi.ps.model.entity.SkuSpec;
import com.xinqiyi.ps.model.entity.SkuSupplyPrice;
import com.xinqiyi.ps.model.entity.Spu;
import com.xinqiyi.ps.model.entity.SpuAttribute;
import com.xinqiyi.ps.model.entity.SpuAttributeValue;
import com.xinqiyi.ps.model.entity.SpuPicture;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.model.entity.Unit;
import com.xinqiyi.ps.model.entity.dto.SaveSpuAttributeDTO;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.fc.FcArExpenseAdapter;
import com.xinqiyi.ps.service.adapter.mc.McAdapter;
import com.xinqiyi.ps.service.adapter.oa.OaAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.adapter.sg.SgStorageQueryAdapter;
import com.xinqiyi.ps.service.business.CategoryBiz;
import com.xinqiyi.ps.service.business.ComposeSkuBiz;
import com.xinqiyi.ps.service.business.LogBiz;
import com.xinqiyi.ps.service.business.Mall4jBiz;
import com.xinqiyi.ps.service.business.PhyStorageBiz;
import com.xinqiyi.ps.service.business.PsFavoriteBiz;
import com.xinqiyi.ps.service.business.SkuBarCodeBiz;
import com.xinqiyi.ps.service.business.SkuBiz;
import com.xinqiyi.ps.service.business.SkuSpecBiz;
import com.xinqiyi.ps.service.business.SpuAttributeBiz;
import com.xinqiyi.ps.service.business.SpuPictureBiz;
import com.xinqiyi.ps.service.business.StoreBiz;
import com.xinqiyi.ps.service.business.SystemConfigBiz;
import com.xinqiyi.ps.service.config.ConstantPropertiesUtil;
import com.xinqiyi.ps.service.exception.PsException;
import com.xinqiyi.ps.service.hanlder.ExcelVerifyHandlerImpl;
import com.xinqiyi.ps.service.helper.ImportHelper;
import com.xinqiyi.ps.service.mq.MqCallBack;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.BeanUtil;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.ExcelUtil;
import com.xinqiyi.ps.service.util.FileUploadUtil;
import com.xinqiyi.ps.service.util.FileZipUtil;
import com.xinqiyi.ps.service.util.OwnerCodeUtil;
import com.xinqiyi.ps.service.util.PsRedisLockUtil;
import com.xinqiyi.ps.service.util.StringUtil;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import com.xinqiyi.sg.basic.api.model.vo.SgGoodsOwnerBrandItemCompanyVO;
import com.xinqiyi.sg.basic.api.model.vo.storage.SgBStorageCostVo;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import com.xinqiyi.systemcenter.web.sc.model.dto.habit.SysTableConfigDto;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SpuBiz
implements MqCallBack {
    private static final Logger log = LoggerFactory.getLogger(SpuBiz.class);
    public static final String SEARRCH_RECORDS_REDIS_KEY = "xinqiyi:ps:liteapp:search_records:";
    @Autowired
    private SpuService spuService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private BrandService brandService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private ComposeSkuBiz composeSkuBiz;
    @Autowired
    private SpuAttributeBiz spuAttributeBiz;
    @Autowired
    private DistributedSequenceGenerator distributedSequenceGenerator;
    @Autowired
    private SkuBiz skuBiz;
    @Autowired
    private UnitService unitService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private SpuPictureBiz spuPictureBiz;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private FileUploadUtil fileUploadUtil;
    @Autowired
    private WorkFlowApi workFlowApi;
    @Autowired
    private SkuSpecBiz skuSpecBiz;
    @Autowired
    private SkuShelfService skuShelfService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private SpuAttributeValueService spuAttributeValueService;
    @Autowired
    private SkuBarCodeBiz skuBarCodeBiz;
    @Autowired
    private SkuService skuService;
    @Autowired
    private ComposeSkuService composeSkuService;
    @Autowired
    private DataRedisRepository dataRedisRepository;
    @Autowired
    private SkuBarCodeService skuBarCodeService;
    @Autowired
    private OaAdapter oaAdapter;
    @Autowired
    private CusAdapter cusAdapter;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private PsSkuTagService psSkuTagService;
    @Autowired
    private PsTagService psTagService;
    @Autowired
    private MdmAdapter mdmAdapter;
    @Autowired
    private SgStorageQueryAdapter sgStorageQueryAdapter;
    @Autowired
    private StoreService storeService;
    @Autowired
    private DynamicTableOperator dynamicTableOperator;
    @Autowired
    private McAdapter mcAdapter;
    @Autowired
    private PhyStorageBiz phyStorageBiz;
    @Autowired
    private Mall4jBiz mall4jBiz;
    @Autowired
    private CategoryBiz categoryBiz;
    @Autowired
    private FcArExpenseAdapter fcArAdapter;
    @Autowired
    private PsFavoriteBiz psFavoriteBiz;
    @Autowired
    private StoreCountrySortService storeCountrySortService;
    @Autowired
    private StoreBrandSortService storeBrandSortService;
    @Autowired
    private DictRedisRepository dictRedisRepository;
    @Autowired
    private PsSkuWmsService psSkuWmsService;
    @Autowired
    private SkuSupplyPriceService skuSupplyPriceService;
    @Resource
    private StoreBiz storeBiz;
    @Resource
    private LogBiz logBiz;
    @Resource
    private PsStoreSpuAliasService storeSpuAliasService;
    @Resource
    private UserInfoUtil userInfoUtil;
    @Resource
    private SystemConfigBiz configBiz;

    public Long saveSpu(SpuDTO spuDTO) {
        String lockKey = null;
        RedisReentrantLock lock = null;
        try {
            if (spuDTO.getId() != null) {
                lockKey = "ps:spu:save:" + spuDTO.getId();
                lock = PsRedisLockUtil.lock(lockKey, "\u5546\u54c1\u6b63\u5728\u88ab\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            Spu spu = new Spu();
            if (spuDTO.getId() != null) {
                spu = (Spu)this.spuService.getById((Serializable)spuDTO.getId());
                Assert.notNull((Object)spu, (String)"\u67e5\u65e0\u6b64\u5546\u54c1");
                Assert.isTrue((spu.getCheckStatus().equals(CheckStatusEnums.NOT_CHECK.getCode()) || spu.getCheckStatus().equals(CheckStatusEnums.REJECT_ADD.getCode()) || spu.getCheckStatus().equals(CheckStatusEnums.REJECT_UPDATE.getCode()) || spu.getCheckStatus().equals(CheckStatusEnums.REJECT_ENABLED.getCode()) || spu.getCheckStatus().equals(CheckStatusEnums.SUCCESS.getCode()) ? 1 : 0) != 0, (String)"\u6b64\u5546\u54c1\u5ba1\u6838\u72b6\u6001\u4e0d\u53ef\u7f16\u8f91");
                if (StatusEnums.ENABLED.getCode().equals(spu.getStatus()) || StatusEnums.STOP_USING.getCode().equals(spu.getStatus())) {
                    Assert.isTrue((boolean)spuDTO.getClassify().equals(spu.getClassify()), (String)"\u5546\u54c1\u7c7b\u578b\u4e0d\u53ef\u7f16\u8f91");
                }
                if (!spuDTO.getSkuType().equals(spu.getSkuType())) {
                    List skuList = this.skuService.selectBySpuId(spu.getId(), null, Boolean.FALSE);
                    Assert.isTrue((boolean)CollUtil.isEmpty((Collection)skuList), (String)"\u5b58\u5728sku\u89c4\u683c,\u4e0d\u53ef\u5207\u6362\u89c4\u683c\u7c7b\u578b");
                }
            }
            List spuName = this.spuService.selectName((List)CollUtil.newArrayList((Object[])new String[]{spuDTO.getName()}), spuDTO.getId() != null ? CollUtil.newArrayList((Object[])new Long[]{spuDTO.getId()}) : null);
            Assert.isTrue((boolean)CollUtil.isEmpty((Collection)spuName), (String)"\u5546\u54c1\u540d\u79f0\u91cd\u590d");
            Unit unit = this.unitService.getByStatus(spuDTO.getPsUnitId(), spuDTO.getPsUnitId().equals(spu.getPsUnitId()), StatusEnums.ENABLED.getCode());
            Assert.notNull((Object)unit, (String)"\u5355\u4f4d\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
            Category category = this.categoryService.getByStatus(spuDTO.getPsCategoryId(), spuDTO.getPsCategoryId().equals(spu.getPsCategoryId()), StatusEnums.ENABLED.getCode());
            Assert.notNull((Object)category, (String)"\u7c7b\u76ee\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
            List categoryList = this.categoryService.selectByPid(category.getId());
            Assert.isTrue((boolean)CollUtil.isEmpty((Collection)categoryList), (String)"\u7c7b\u76ee\u5b58\u5728\u4e0b\u7ea7\u7c7b\u76ee");
            Brand brand = this.brandService.getByStatus(spuDTO.getPsBrandId(), spuDTO.getPsBrandId().equals(spu.getPsBrandId()), StatusEnums.ENABLED.getCode());
            Assert.notNull((Object)brand, (String)"\u54c1\u724c\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
            ComposeSkuWeightDTO composeSkuWeightDTO = null;
            if (CollUtil.isNotEmpty((Collection)spuDTO.getComposeSkuList())) {
                composeSkuWeightDTO = this.composeSkuBiz.checkSave(spuDTO.getComposeSkuList(), spuDTO.getClassify(), spuDTO);
            }
            if (CollUtil.isNotEmpty((Collection)spuDTO.getSpuAttributeList())) {
                this.spuAttributeBiz.checkSave(spuDTO.getSpuAttributeList());
            }
            this.spuPictureBiz.checkSave(spuDTO.getSpuPictureList());
            this.skuBiz.checkSave(spuDTO);
            Long spuId = spu.getId() == null ? this.idSequence.generateId(Spu.class) : spu.getId();
            SaveSpuAttributeDTO saveSpuAttributeDTO = new SaveSpuAttributeDTO();
            if (CollUtil.isNotEmpty((Collection)spuDTO.getSpuAttributeList())) {
                saveSpuAttributeDTO = this.spuAttributeBiz.convert(spuDTO.getSpuAttributeList(), spuId);
            }
            List<Object> spuPictureList = new ArrayList();
            if (CollUtil.isNotEmpty((Collection)spuDTO.getSpuPictureList())) {
                spuPictureList = this.spuPictureBiz.convert(spuDTO.getSpuPictureList(), spuId);
            }
            String spuCode = "";
            spuCode = spuDTO.getId() != null ? (StrUtil.isNotEmpty((CharSequence)spu.getCode()) ? spuDTO.getCode() : this.getSpuCode(brand.getCode(), spuDTO.getClassify())) : (StrUtil.isNotEmpty((CharSequence)spuDTO.getCode()) ? spuDTO.getCode() : this.getSpuCode(brand.getCode(), spuDTO.getClassify()));
            boolean isCompose = SpuClassifyEnums.COMPOSE.getCode().equals(spuDTO.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spuDTO.getClassify());
            SaveSkuDTO saveSkuDTO = this.skuBiz.convert(spuDTO.getSkuList(), spuCode, spuId, spuDTO.getSkuType(), spu.getStatus(), spuDTO.getClassify(), composeSkuWeightDTO);
            ArrayList<ComposeSku> composeSkuList = new ArrayList();
            if (isCompose) {
                Assert.notNull((Object)spuDTO.getComSpuNameControl(), (String)"\u7ec4\u5408\u5546\u54c1\u540d\u79f0\u63a7\u5236\u4e0d\u53ef\u4e3a\u7a7a");
                composeSkuList = this.composeSkuBiz.convert(spuDTO.getComposeSkuList(), spuId);
                spu.setComSpuNameControl(spuDTO.getComSpuNameControl());
            }
            List<Sku> skuList = BeanConvertUtil.convertList(saveSkuDTO.getInsertSkuDTOS(), Sku.class);
            List<SkuSpec> skuSpecList = BeanConvertUtil.convertList(saveSkuDTO.getInsertSkuSpecDTOS(), SkuSpec.class);
            List<SkuBarCode> skuBarCodeList = BeanConvertUtil.convertList(saveSkuDTO.getSaveSkuBarCodeDTOS(), SkuBarCode.class);
            if (StatusEnums.ENABLED.getCode().equals(spu.getStatus())) {
                spu.setPsCategoryId(spuDTO.getPsCategoryId());
                spu.setTaxCode(spuDTO.getTaxCode());
                spu.setMoneyType(spuDTO.getMoneyType());
                spu.setProductionPlace(spuDTO.getProductionPlace());
                spu.setIsAviationBan(spuDTO.getIsAviationBan());
                spu.setInvoiceItemName(spuDTO.getInvoiceItemName());
                spu.setShelfLife(spuDTO.getShelfLife());
                spu.setShelfLifeUnit(spuDTO.getShelfLifeUnit());
                spu.setSellingPoint(spuDTO.getSellingPoint());
                spu.setName(spuDTO.getName());
                spu.setDetails(spuDTO.getDetails());
            } else {
                BeanConvertUtil.copyProperties(spuDTO, spu);
                spu.setPsBrandName(brand.getName());
                spu.setPsBrandId(brand.getId());
                spu.setOrgSalesmanId(spuDTO.getOrgSalesmanId());
                spu.setOrgSalesmanCode(spuDTO.getOrgSalesmanCode());
                spu.setOrgSalesmanName(spuDTO.getOrgSalesmanName());
                spu.setPsBrandCountryName(brand.getCountryName());
            }
            spu.setPsCategoryName(category.getName());
            spu.setPsCategoryWholeName(category.getWholeName());
            spu.setPsUnitId(spuDTO.getPsUnitId());
            spu.setPsUnitName(unit.getName());
            if (WhetherEnum.NO.getCode().equals(spu.getWholesale()) && !SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) && spuDTO.getIsSubmitOa().booleanValue()) {
                if (StrUtil.isNotBlank((CharSequence)spu.getOwnerCode())) {
                    List<String> ownerCodeList = Arrays.asList(spu.getOwnerCode().split(","));
                    spuDTO.getOwnerCodeList().addAll(ownerCodeList);
                    spu.setOwnerCode(spuDTO.getOwnerCodeList().stream().distinct().collect(Collectors.joining(",")));
                } else if (CollUtil.isNotEmpty((Collection)spuDTO.getOwnerCodeList())) {
                    spu.setOwnerCode(String.join((CharSequence)",", spuDTO.getOwnerCodeList()));
                }
            }
            if (spuDTO.getId() == null) {
                spu.setId(spuId);
                spu.setCode(spuCode);
                existSpu = this.spuService.selectSpuByCode(spuCode);
                Assert.isTrue((existSpu == null ? 1 : 0) != 0, (String)("\u5546\u54c1\u7f16\u7801" + spuCode + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01"));
                spu.setCheckStatus(CheckStatusEnums.NOT_CHECK.getCode());
                spu.setStatus(StatusEnums.NOT_ENABLED.getCode());
                if (isCompose) {
                    this.logBiz.copyInsert(CopyInsertEnum.COMPOSE_SPU.getTableName(), spuId, spuDTO.getIsCopy());
                }
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)spu);
            } else {
                existSpu = this.spuService.selectSpuByCode(spuCode);
                if (existSpu != null && !Objects.equals(existSpu.getId(), spuDTO.getId())) {
                    Assert.isTrue((existSpu == null ? 1 : 0) != 0, (String)("\u5546\u54c1\u7f16\u7801" + spuCode + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01"));
                }
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)spu);
            }
            LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            this.spuService.insertOrUpdate(spu, composeSkuList, saveSpuAttributeDTO.getSpuAttributeList(), saveSpuAttributeDTO.getSpuAttributeValueList(), spuPictureList, skuList, skuSpecList, skuBarCodeList);
            if (spuDTO.getIsSubmitOa().booleanValue() && !StatusEnums.ENABLED.getCode().equals(spu.getStatus())) {
                ArrayList<SpuOaExportDTO> spuOaExportList = new ArrayList<SpuOaExportDTO>();
                ArrayList<SpuComposeOaExportDTO> spuOaComposeExportList = new ArrayList<SpuComposeOaExportDTO>();
                this.getOaDTO(spuOaExportList, spuOaComposeExportList, skuList, spu, composeSkuList, skuBarCodeList);
                ArrayList orgSalesmanIdList = spu.getOrgSalesmanId() == null ? CollUtil.newArrayList((Object[])new Long[0]) : CollUtil.newArrayList((Object[])new Long[]{spu.getOrgSalesmanId()});
                String oaId = this.createSpuOaFlow(spuOaExportList, spuOaComposeExportList, user, orgSalesmanIdList, spuDTO.getDingDingDeptId());
                spu.setOaId(oaId);
                spu.setCheckStatus(this.getCheckStatus(spu.getCheckStatus()));
                this.spuService.saveOrUpdate((Object)spu);
                InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u4fdd\u5b58\u63d0\u4ea4", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u4fdd\u5b58\u63d0\u4ea4");
            } else {
                InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u4fdd\u5b58", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u4fdd\u5b58");
            }
            List skuDtoList = spuDTO.getSkuList();
            List skuIdList = skuDtoList.stream().filter(s -> s.getId() != null).map(SkuDTO::getId).collect(Collectors.toList());
            List<Sku> skuRedisList = skuList.stream().filter(item -> skuIdList.contains(item.getId())).collect(Collectors.toList());
            this.deleteRedisKeyList(skuRedisList);
            this.deleteTransportRedisKeyList(skuRedisList);
            if (StatusEnums.ENABLED.getCode().equals(spu.getStatus()) && !SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) && WhetherEnum.NO.getCode().equals(spu.getWholesale()) && StrUtil.isNotBlank((CharSequence)spu.getOwnerCode())) {
                List<String> ownerCodeList = Arrays.asList(spu.getOwnerCode().split(","));
                this.skuBiz.singleItemSynchronize(CollUtil.newArrayList((Object[])new Spu[]{spu}), skuList, skuBarCodeList, ownerCodeList);
            }
            if (StrUtil.equals((CharSequence)YesOrNoEnum.YES.getCode(), (CharSequence)spu.getIsPushMallFourJ())) {
                this.mall4jBiz.covertProdUpdateToMallFourJ(skuList, brand, spu, SupplyPriceTypeEnums.TWO.getCode());
            }
            Long l = spuId;
            return l;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("spu.SpuBiz.save Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (null != lock) {
                PsRedisLockUtil.unlock(lock, lockKey, log, this.getClass().getName());
            }
        }
    }

    private void deleteTransportRedisKeyList(List<Sku> skuList) {
        if (CollUtil.isEmpty(skuList)) {
            return;
        }
        List storeIdList = this.storeService.list((Wrapper)new QueryWrapper().lambda().eq(Store::getStatus, (Object)StatusEnums.ENABLED.getCode())).stream().map(BaseDo::getId).collect(Collectors.toList());
        if (CollUtil.isEmpty(storeIdList)) {
            return;
        }
        for (Long storeId : storeIdList) {
            for (Sku sku : skuList) {
                this.dataRedisRepository.deleteBaseData("ps:sku:id:transport:1-" + storeId + "-" + sku.getId());
                this.dataRedisRepository.deleteBaseData("ps:sku:id:transport:2-" + storeId + "-" + sku.getId());
            }
        }
        List skuIdList = skuList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List skuIdArray = this.composeSkuService.selectComposeSku(skuIdList);
        if (CollUtil.isNotEmpty((Collection)skuIdArray)) {
            for (Long storeId : storeIdList) {
                for (Long id : skuIdArray) {
                    this.dataRedisRepository.deleteBaseData("ps:sku:id:transport:1-" + storeId + "-" + id);
                    this.dataRedisRepository.deleteBaseData("ps:sku:id:transport:2-" + storeId + "-" + id);
                }
            }
        }
    }

    private void removeThirdPlatformCodeRedisKey(Sku sku) {
        if (sku == null) {
            return;
        }
        this.dataRedisRepository.deleteBaseData("ps:sku:wmsThirdPlatformCode:" + sku.getWmsThirdPlatformCode());
        this.dataRedisRepository.deleteBaseData("ps:sku:kyThirdPlatformCode:" + sku.getKyThirdPlatformCode());
        this.dataRedisRepository.deleteBaseData("ps:sku:contrast:wmsThirdCode:" + sku.getWmsThirdPlatformCode());
        List skuWmsList = this.psSkuWmsService.list((Wrapper)Wrappers.lambdaQuery(PsSkuWms.class).eq(PsSkuWms::getPsSkuId, (Object)sku.getId()));
        for (PsSkuWms psSkuWms : skuWmsList) {
            if (!WmsTypeEnum.CAI_NIAO.getCode().equals(psSkuWms.getType())) continue;
            this.dataRedisRepository.deleteBaseData(PsRedisKeyConstants.getPsSkuCnThirdPlatformCode((String)psSkuWms.getOwnerCode(), (String)psSkuWms.getThirdPlatformCode()));
            this.dataRedisRepository.deleteBaseData(PsRedisKeyConstants.getPsSkuContrastCnWmsThirdCode((String)psSkuWms.getOwnerCode(), (String)psSkuWms.getThirdPlatformCode()));
        }
    }

    private void deleteRedisKey(Sku sku) {
        this.removeThirdPlatformCodeRedisKey(sku);
        this.dataRedisRepository.deleteBaseData("ps:sku:id:" + sku.getId());
        this.dataRedisRepository.deleteBaseData("ps:sku:code:" + sku.getCode());
        this.dataRedisRepository.deleteBaseData("ps:sku:contrast:skuCode:" + sku.getCode());
    }

    public void deleteRedisKeyList(List<Sku> skuList) {
        if (CollUtil.isEmpty(skuList)) {
            return;
        }
        for (Sku sku : skuList) {
            this.removeThirdPlatformCodeRedisKey(sku);
            this.dataRedisRepository.deleteBaseData("ps:sku:id:" + sku.getId());
            this.dataRedisRepository.deleteBaseData("ps:sku:code:" + sku.getCode());
            this.dataRedisRepository.deleteBaseData("ps:sku:contrast:skuCode:" + sku.getCode());
            this.dataRedisRepository.deleteBaseData("ps:sku:status2:code:" + sku.getCode());
            this.dataRedisRepository.deleteBaseData("ps:sku:compose:code:" + sku.getCode());
            this.dataRedisRepository.deleteBaseData("ps:sku:parent:code:" + sku.getCode());
            this.dataRedisRepository.deleteBaseData("ps:sku:cuscustomer:supplyprice2:code:" + sku.getCode());
            this.dataRedisRepository.deleteBaseData("ps:sku:cuscustomer:supplyprice2:code:" + sku.getCode() + ":2");
        }
        List<String> skuCodeList = skuList.stream().map(Sku::getCode).distinct().collect(Collectors.toList());
        List<String> spuCodeList = this.querySkuContrastInfo(skuCodeList);
        for (String code : spuCodeList) {
            this.dataRedisRepository.deleteBaseData("ps:sku:contrast:type0:" + code);
            this.dataRedisRepository.deleteBaseData("ps:sku:contrast:type20:" + code);
        }
    }

    public List<String> querySkuContrastInfo(List<String> skuCodeList) {
        try {
            QueryDynamicFormDataRequest request = new QueryDynamicFormDataRequest();
            ArrayList<SearchCondition> searchConditionList = new ArrayList<SearchCondition>(2);
            SearchCondition searchCondition = new SearchCondition();
            searchCondition.setColumnName("sku_code");
            searchCondition.setSearchValue(String.join((CharSequence)",", skuCodeList));
            searchCondition.setPreConditionRelation(ConditionRelation.AND);
            searchCondition.setSearchType(SearchType.IN);
            searchConditionList.add(searchCondition);
            CommonSearchRequest jsonData = new CommonSearchRequest();
            jsonData.setPageIndex(Long.valueOf(1L));
            jsonData.setPageSize(Long.valueOf(100L));
            jsonData.setSearchCondition(searchConditionList);
            request.setJsonData(jsonData);
            request.setTableName("v_ps_sku_contrast_orenasu_view");
            PageResponse queryFormDataResponse = this.dynamicTableOperator.selectGridDynamicTableData(request);
            return queryFormDataResponse.getRecords().stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getString("contrast_spu_code"))).map(item -> item.getString("contrast_spu_code")).collect(Collectors.toList());
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u5546\u54c1SKU\u5bf9\u7167\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    private SpuOaExportDTO covertSpuOaExport(Spu spu, List<Sku> skuList, List<SkuBarCode> skuBarCodeList) {
        SpuOaExportDTO spuOaExportDTO = new SpuOaExportDTO();
        BeanConvertUtil.copyProperties(spu, spuOaExportDTO);
        if (spu.getShelfLife() != null && spu.getShelfLifeUnit() != null) {
            spuOaExportDTO.setShelfLifeName(spu.getShelfLife() + SpuShelflifeUnitEnums.getDescByCode((Integer)spu.getShelfLifeUnit()));
        }
        List<SkuOaExportDTO> skuOaExportList = BeanConvertUtil.convertList(skuList, SkuOaExportDTO.class);
        for (SkuOaExportDTO skuOaExportDTO : skuOaExportList) {
            String barCode = skuBarCodeList.stream().filter(s -> s.getPsSkuId().equals(skuOaExportDTO.getId())).map(SkuBarCode::getBarCode).collect(Collectors.joining(","));
            skuOaExportDTO.setCounterPrice(BigDecimalUtils.convert(skuOaExportDTO.getCounterPrice(), 2));
            skuOaExportDTO.setRetailPrice(BigDecimalUtils.convert(skuOaExportDTO.getRetailPrice(), 2));
            skuOaExportDTO.setCustomerPrice(BigDecimalUtils.convert(skuOaExportDTO.getCustomerPrice(), 2));
            skuOaExportDTO.setBarCode(barCode);
        }
        spuOaExportDTO.setSkuOaExportList(skuOaExportList);
        return spuOaExportDTO;
    }

    private SpuComposeOaExportDTO covertComposeSpuOaExport(Spu spu, List<ComposeSku> composeSkuList, Sku sku, List<SkuBarCode> skuBarCodeList) {
        SpuComposeOaExportDTO spuOaExportDTO = new SpuComposeOaExportDTO();
        BeanConvertUtil.copyProperties(spu, spuOaExportDTO);
        BeanUtils.copyProperties((Object)sku, (Object)spuOaExportDTO, (String[])new String[]{"code", "name", "psUnitName"});
        spuOaExportDTO.setCounterPrice(BigDecimalUtils.convert(sku.getCounterPrice(), 2));
        spuOaExportDTO.setRetailPrice(BigDecimalUtils.convert(sku.getRetailPrice(), 2));
        spuOaExportDTO.setCustomerPrice(BigDecimalUtils.convert(sku.getCustomerPrice(), 2));
        spuOaExportDTO.setSkuPsUnitName(sku.getPsUnitName());
        String barCode = skuBarCodeList.stream().map(SkuBarCode::getBarCode).collect(Collectors.joining(","));
        spuOaExportDTO.setBarCode(barCode);
        spuOaExportDTO.setSkuName(sku.getName());
        spuOaExportDTO.setSkuCode(sku.getCode());
        List<ComposeSkuOaExportDTO> composeSkuOaExportDTOS = this.convertComposeSku(composeSkuList, spu);
        spuOaExportDTO.setComposeSkuOaExportList(composeSkuOaExportDTOS);
        BigDecimal total = composeSkuOaExportDTOS.stream().filter(item -> item.getSgCostPriceNum() != null).map(ComposeSkuOaExportDTO::getSgCostPriceNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!BigDecimalUtils.equal(total, new BigDecimal("0"))) {
            spuOaExportDTO.setTotalSgCostPrice(total);
        }
        return spuOaExportDTO;
    }

    private List<ComposeSkuOaExportDTO> convertComposeSku(List<ComposeSku> composeSkuList, Spu spu) {
        List<ComposeSkuOaExportDTO> composeSkuOaExportDTOList = BeanConvertUtil.convertList(composeSkuList, ComposeSkuOaExportDTO.class);
        List skuIdList = composeSkuList.stream().map(ComposeSku::getPsSkuId).distinct().collect(Collectors.toList());
        List skuList = this.skuService.listByIds(skuIdList);
        List<String> skuCodeList = skuList.stream().map(Sku::getCode).collect(Collectors.toList());
        List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehoseAndSku(skuCodeList);
        if (CollUtil.isNotEmpty(composeSkuOaExportDTOList)) {
            for (ComposeSkuOaExportDTO composeSkuOaExportDTO : composeSkuOaExportDTOList) {
                SgBStorageCostVo sgBStorageCostVo;
                Sku sku = skuList.stream().filter(item -> item.getId().equals(composeSkuOaExportDTO.getPsSkuId())).findAny().orElse(null);
                Spu oldSpu = (Spu)this.spuService.getById((Serializable)sku.getPsSpuId());
                composeSkuOaExportDTO.setBarCode(this.skuBarCodeBiz.getBarCode(composeSkuOaExportDTO.getPsSkuId()));
                composeSkuOaExportDTO.setCounterPrice(BigDecimalUtils.convert(sku.getCounterPrice(), 2));
                composeSkuOaExportDTO.setRetailPrice(BigDecimalUtils.convert(sku.getRetailPrice(), 2));
                composeSkuOaExportDTO.setCustomerPrice(BigDecimalUtils.convert(sku.getCustomerPrice(), 2));
                composeSkuOaExportDTO.setSpuNameCode(oldSpu.getName() + "/" + oldSpu.getCode());
                composeSkuOaExportDTO.setPsUnitName(oldSpu.getPsUnitName());
                composeSkuOaExportDTO.setSkuNameCode(sku.getName() + "/" + sku.getCode());
                if (composeSkuOaExportDTO.getAllocationRatio() != null && AllocationRuleEnums.RATIO.getCode().equals(spu.getAllocationRule())) {
                    composeSkuOaExportDTO.setAllocationRatioStr(String.valueOf(composeSkuOaExportDTO.getAllocationRatio()) + "%");
                }
                if (composeSkuOaExportDTO.getAllocationRatio() != null && AllocationRuleEnums.THERE.getCode().equals(spu.getAllocationRule())) {
                    composeSkuOaExportDTO.setAllocationRatioStr(composeSkuOaExportDTO.getAllocationRatio().toString());
                }
                if (!CollUtil.isNotEmpty(sgBStorageCostVos) || (sgBStorageCostVo = (SgBStorageCostVo)sgBStorageCostVos.stream().filter(s -> s.getPsCSkuEcode().equals(sku.getCode())).findAny().orElse(null)) == null) continue;
                composeSkuOaExportDTO.setSgCostPrice(sgBStorageCostVo.getPriceCost());
                composeSkuOaExportDTO.setSgCostPriceNum(sgBStorageCostVo.getPriceCost().multiply(new BigDecimal(composeSkuOaExportDTO.getComposeNumber())));
            }
        }
        return composeSkuOaExportDTOList;
    }

    private String getSpuCode(String brandCode, Integer classify) {
        SequenceInfo sequenceInfo = new SequenceInfo();
        sequenceInfo.setName("ps_spu_code_" + brandCode + "_0" + classify);
        sequenceInfo.setSequenceRegex(brandCode + "0" + classify + "[[${#numbers.formatInteger(sn,4)}]]");
        sequenceInfo.setIncrementNumber(Long.valueOf(1L));
        sequenceInfo.setMaxNo(Long.valueOf(999999L));
        sequenceInfo.setStartNumber(Long.valueOf(1L));
        String seqNo = this.distributedSequenceGenerator.buildSequence(sequenceInfo, null, false);
        Spu existSpu = this.spuService.selectSpuByCode(seqNo);
        while (existSpu != null) {
            seqNo = this.distributedSequenceGenerator.buildSequence(sequenceInfo, null, false);
            existSpu = this.spuService.selectSpuByCode(seqNo);
        }
        return seqNo;
    }

    public Spu getById(Long spuId) {
        return (Spu)this.spuService.getById((Serializable)spuId);
    }

    public Page<SpuWithPriceDTO> getSpuListWithPrice(SpuQueryDTO queryDTO) {
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        if (CharSequenceUtil.isNotBlank((CharSequence)queryDTO.getName())) {
            this.saveSearchRecord(SEARRCH_RECORDS_REDIS_KEY + currentLoginUserInfo.getCustomerCode(), queryDTO.getName());
        }
        if ("1".equals(currentLoginUserInfo.getType().toString())) {
            JSONObject internalPurchaseCustomer = currentLoginUserInfo.getInternalPurchaseCustomer();
            JSONArray storeIdList = internalPurchaseCustomer.getJSONArray("storeIdList");
            if (storeIdList == null) {
                return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
            }
            List psStoreIdList = storeIdList.toJavaList(Long.class);
            queryDTO.setPsStoreIdList(psStoreIdList);
        } else {
            queryDTO.setPsStoreIdList((List)CollUtil.newArrayList((Object[])new Long[]{1L}));
        }
        ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(currentLoginUserInfo.getCustomerId());
        Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
        Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        Page spuListWithPrice = this.spuService.getSpuListWithPrice(queryDTO, currentLoginUserInfo.getCustomerId().longValue(), ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId().longValue());
        List records = spuListWithPrice.getRecords();
        if (CollUtil.isNotEmpty((Collection)records)) {
            for (SpuWithPriceDTO record : records) {
                record.setMaxPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(record.getMaxPrice())).toString());
                record.setMinPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(record.getMinPrice())).toString());
            }
        }
        return spuListWithPrice;
    }

    public SpuDetailWithClientDTO getSpuDetailWithClient(Long spuId, Long psStoreId) {
        LoginUserInfo loginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.notNull((Object)loginUserInfo, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\uff01");
        long userId = loginUserInfo.getCustomerId();
        if ("1".equals(loginUserInfo.getType().toString())) {
            JSONObject internalPurchaseCustomer = loginUserInfo.getInternalPurchaseCustomer();
            JSONArray storeIdList = internalPurchaseCustomer.getJSONArray("storeIdList");
            if (storeIdList == null) {
                return new SpuDetailWithClientDTO();
            }
            List psStoreIdList = storeIdList.toJavaList(Long.class);
            psStoreId = (Long)psStoreIdList.get(0);
        } else {
            psStoreId = 1L;
        }
        ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(userId);
        Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
        Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        SpuDetailWithClientDTO dto = this.spuService.getSpuDetailWithClient(spuId, psStoreId, userId, ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId());
        Assert.notNull((Object)dto, (String)"\u5546\u54c1\u4e0d\u5b58\u5728!");
        dto.setMaxPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(dto.getMaxPrice())).toString());
        dto.setMinPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(dto.getMinPrice())).toString());
        List<SpuPicture> spuPictureList = this.spuPictureBiz.selectBySpuId(spuId);
        List<QuerySpuPictureDTO> spuPictureDTOList = BeanConvertUtil.convertList(spuPictureList, QuerySpuPictureDTO.class);
        dto.setSpuPictureList(spuPictureDTOList);
        List<QuerySpuAttributeDTO> spuAttributeDTOList = this.spuAttributeBiz.selectAttribute(spuId, dto.getPsCategoryId());
        dto.setSpuAttributeList(spuAttributeDTOList);
        List<SkuWithClientDTO> skuDTOList = this.skuBiz.getSkuBySpuIdWithClient(spuId, psStoreId, userId, ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId());
        if (CollUtil.isNotEmpty(skuDTOList)) {
            for (SkuWithClientDTO sku : skuDTOList) {
                sku.setPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(sku.getPrice())).toString());
                sku.setCounterPrice(BigDecimalUtil.setFrontValueScale((BigDecimal)new BigDecimal(sku.getCounterPrice())).toString());
                if (sku.getSpecValue().startsWith("TJ01")) {
                    sku.setSpecValue(sku.getSpecValue().replaceFirst("TJ01", "\u7279\u4ef7"));
                    continue;
                }
                if (sku.getSpecValue().startsWith("01")) {
                    sku.setSpecValue(sku.getSpecValue().replaceFirst("01", "\u7279\u4ef7"));
                    continue;
                }
                if (sku.getSpecValue().startsWith("TC01")) {
                    sku.setSpecValue(sku.getSpecValue().replaceFirst("TC01", "\u7279\u91c7"));
                    continue;
                }
                if (sku.getSpecValue().startsWith("03")) {
                    sku.setSpecValue(sku.getSpecValue().replaceFirst("03", "\u7279\u91c7"));
                    continue;
                }
                if (sku.getSpecValue().startsWith("TJ02")) {
                    sku.setSpecValue(sku.getSpecValue().replaceFirst("TJ02", "\u7279\u7279\u4ef7"));
                    continue;
                }
                if (sku.getSpecValue().startsWith("02")) {
                    sku.setSpecValue(sku.getSpecValue().replaceFirst("02", "\u7279\u7279\u4ef7"));
                    continue;
                }
                if (sku.getSpecValue().startsWith("04")) {
                    sku.setSpecValue(sku.getSpecValue().replaceFirst("04", "\u7279\u91c7\u7279\u4ef7"));
                    continue;
                }
                if (!sku.getSpecValue().startsWith("05")) continue;
                sku.setSpecValue(sku.getSpecValue().replaceFirst("05", "\u7279\u91c7\u7279\u7279\u4ef7"));
            }
        }
        dto.setSkuList(skuDTOList);
        return dto;
    }

    public PsBasicsBatchVO submitOa(SpuIdsDTO dto) {
        List spuList = this.spuService.listByIds((Collection)dto.getPsSpuIds());
        ArrayList<SpuOaExportDTO> spuOaExportList = new ArrayList<SpuOaExportDTO>();
        ArrayList<SpuComposeOaExportDTO> spuOaComposeExportList = new ArrayList<SpuComposeOaExportDTO>();
        ArrayList<Long> orgSalesmanIdList = new ArrayList<Long>();
        PsBasicsBatchVO psBasicsBatchVO = this.checkSpu(spuList);
        if (CollUtil.isNotEmpty((Collection)psBasicsBatchVO.getErrorMessageList())) {
            return psBasicsBatchVO;
        }
        for (Spu spu : spuList) {
            Assert.isTrue((!spu.getStatus().equals(StatusEnums.ENABLED.getCode()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u5df2\u542f\u7528\u4e0d\u53ef\u63d0\u4ea4Oa");
            Assert.isTrue((spu.getCheckStatus().equals(CheckStatusEnums.NOT_CHECK.getCode()) || spu.getCheckStatus().equals(CheckStatusEnums.REJECT_ADD.getCode()) || spu.getCheckStatus().equals(CheckStatusEnums.REJECT_UPDATE.getCode()) || spu.getCheckStatus().equals(CheckStatusEnums.REJECT_ENABLED.getCode()) ? 1 : 0) != 0, (String)"\u6b64\u5546\u54c1\u5ba1\u6838\u72b6\u6001\u4e0d\u53ef\u63d0\u4ea4\u5ba1\u6838");
            if ((SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify())) && spu.getOrgSalesmanId() != null) {
                orgSalesmanIdList.add(spu.getOrgSalesmanId());
            }
            List<Sku> skuList = this.skuBiz.selectBySpuId(spu.getId());
            List skuIds = skuList.stream().map(BaseDo::getId).collect(Collectors.toList());
            List<ComposeSku> composeSkuList = this.composeSkuBiz.selectBySpuId(spu.getId());
            List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
            this.getOaDTO(spuOaExportList, spuOaComposeExportList, skuList, spu, composeSkuList, skuBarCodeList);
        }
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        List<Long> orgSalesmanIds = orgSalesmanIdList.stream().distinct().collect(Collectors.toList());
        String oaId = this.createSpuOaFlow(spuOaExportList, spuOaComposeExportList, user, orgSalesmanIds, dto.getDingDingDeptId());
        String ownerCodeList = "";
        if (CollUtil.isNotEmpty((Collection)dto.getOwnerCodeList())) {
            ownerCodeList = String.join((CharSequence)",", dto.getOwnerCodeList());
        }
        for (Spu spu : spuList) {
            spu.setOaId(oaId);
            if (WhetherEnum.NO.getCode().equals(spu.getWholesale()) && !SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) && CollUtil.isNotEmpty((Collection)dto.getOwnerCodeList())) {
                if (StrUtil.isNotBlank((CharSequence)spu.getOwnerCode())) {
                    List<String> ownerCodes = Arrays.asList(spu.getOwnerCode().split(","));
                    ArrayList ownerCode = CollUtil.newArrayList((Collection)dto.getOwnerCodeList());
                    ownerCode.addAll(ownerCodes);
                    spu.setOwnerCode(ownerCode.stream().distinct().collect(Collectors.joining(",")));
                } else {
                    spu.setOwnerCode(ownerCodeList);
                }
            }
            spu.setCheckStatus(this.getCheckStatus(spu.getCheckStatus()));
            InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u63d0\u4ea4", (String)InnerLogTypeEnum.SPU.getCode(), null, (String)"\u63d0\u4ea4");
        }
        this.spuService.updateBatchById((Collection)spuList);
        return psBasicsBatchVO;
    }

    private PsBasicsBatchVO checkSpu(List<Spu> spuList) {
        PsBasicsBatchVO psBasicsBatchVO = new PsBasicsBatchVO();
        ArrayList errorMessageList = CollUtil.newArrayList((Object[])new PsBasicsBatchVO.ErrorMessage[0]);
        if (CollUtil.isEmpty(spuList)) {
            return psBasicsBatchVO;
        }
        List spuIdList = spuList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List psBrandIdList = spuList.stream().map(Spu::getPsBrandId).collect(Collectors.toList());
        List brandList = this.brandService.listByIds(psBrandIdList);
        List skuList = this.skuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Sku::getPsSpuId, spuIdList)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        if (CollUtil.isEmpty((Collection)skuList)) {
            return psBasicsBatchVO;
        }
        List skuIdList = skuList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List skuNameList = skuList.stream().map(Sku::getName).collect(Collectors.toList());
        List wmsThirdPlatformCodeList = skuList.stream().map(Sku::getWmsThirdPlatformCode).collect(Collectors.toList());
        List kyThirdPlatformCodeList = skuList.stream().map(Sku::getKyThirdPlatformCode).collect(Collectors.toList());
        List skuNames = this.skuService.findByThirdPlatformCode(skuIdList, null, null, null, skuNameList);
        List wmsThirdPlatformCodes = this.skuService.findByThirdPlatformCode(skuIdList, null, wmsThirdPlatformCodeList, null, null);
        List kyThirdPlatformCodes = this.skuService.findByThirdPlatformCode(skuIdList, kyThirdPlatformCodeList, null, null, null);
        skuNames.addAll(skuList);
        wmsThirdPlatformCodes.addAll(skuList);
        kyThirdPlatformCodes.addAll(skuList);
        List normalSkuList = skuList.stream().filter(item -> SkuTypeEnums.NORMAL.getCode().equals(item.getType())).collect(Collectors.toList());
        List normalSkuIdList = normalSkuList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List skuBarCodes = this.skuBarCodeService.selectBySkuIds(normalSkuIdList);
        List barCodeList = CollUtil.newArrayList((Object[])new SkuBarCode[0]);
        if (CollUtil.isNotEmpty((Collection)skuBarCodes)) {
            List stringList = skuBarCodes.stream().map(SkuBarCode::getBarCode).collect(Collectors.toList());
            barCodeList = this.skuBarCodeService.findByBarCode(stringList, skuIdList, null, psBrandIdList);
        }
        barCodeList.addAll(skuBarCodes);
        List spuNameList = spuList.stream().map(Spu::getName).collect(Collectors.toList());
        List spuName = this.spuService.selectName(spuNameList, spuIdList);
        spuName.addAll(spuList);
        ArrayList successIdList = CollUtil.newArrayList((Object[])new Long[0]);
        for (Spu spu : spuList) {
            List skuArrAys = skuList.stream().filter(item -> ObjectUtil.equal((Object)spu.getId(), (Object)item.getPsSpuId())).collect(Collectors.toList());
            if (CollUtil.isEmpty(skuArrAys)) continue;
            List skuIdArray = skuArrAys.stream().map(BaseDo::getId).collect(Collectors.toList());
            List skuNameArray = skuArrAys.stream().map(Sku::getName).collect(Collectors.toList());
            List wmsThirdPlatformCodeArray = skuArrAys.stream().map(Sku::getWmsThirdPlatformCode).collect(Collectors.toList());
            List kyThirdPlatformCodeArray = skuArrAys.stream().map(Sku::getKyThirdPlatformCode).collect(Collectors.toList());
            List bras = barCodeList.stream().filter(item -> skuIdArray.contains(item.getPsSkuId())).map(SkuBarCode::getBarCode).collect(Collectors.toList());
            PsBasicsBatchVO.ErrorMessage errorMessage = new PsBasicsBatchVO.ErrorMessage();
            List spus = spuName.stream().filter(item -> StrUtil.equals((CharSequence)item.getName(), (CharSequence)spu.getName()) && !ObjectUtil.equal((Object)item.getId(), (Object)spu.getId())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(spus)) {
                errorMessage.setId(spu.getId().toString());
                errorMessage.setBillNo(spu.getName());
                errorMessage.setMessage("\u5546\u54c1\u540d\u79f0\u91cd\u590d");
                errorMessageList.add(errorMessage);
                continue;
            }
            Brand brand = brandList.stream().filter(item -> ObjectUtil.equal((Object)spu.getPsBrandId(), (Object)item.getId())).findAny().orElse(null);
            if (brand != null && !StatusEnums.ENABLED.getCode().equals(brand.getStatus())) {
                errorMessage.setId(spu.getId().toString());
                errorMessage.setBillNo(spu.getName());
                errorMessage.setMessage(brand.getName() + "\u54c1\u724c\u672a\u542f\u7528");
                errorMessageList.add(errorMessage);
                continue;
            }
            List skuOneList = skuNames.stream().filter(item -> skuNameArray.contains(item.getName()) && !skuIdArray.contains(item.getId())).map(Sku::getName).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(skuOneList)) {
                errorMessage.setId(spu.getId().toString());
                errorMessage.setBillNo(spu.getName());
                errorMessage.setMessage(String.valueOf(skuOneList) + "\u89c4\u683c\u540d\u79f0\u91cd\u590d");
                errorMessageList.add(errorMessage);
                continue;
            }
            List skuTwoList = wmsThirdPlatformCodes.stream().filter(item -> wmsThirdPlatformCodeArray.contains(item.getWmsThirdPlatformCode()) && !skuIdArray.contains(item.getId())).map(Sku::getWmsThirdPlatformCode).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(skuTwoList)) {
                errorMessage.setId(spu.getId().toString());
                errorMessage.setBillNo(spu.getName());
                errorMessage.setMessage(String.valueOf(skuTwoList) + "wms\u7f16\u7801\u91cd\u590d");
                errorMessageList.add(errorMessage);
                continue;
            }
            List skuThreeList = kyThirdPlatformCodes.stream().filter(item -> kyThirdPlatformCodeArray.contains(item.getKyThirdPlatformCode()) && !skuIdArray.contains(item.getId())).map(Sku::getWmsThirdPlatformCode).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(skuThreeList)) {
                errorMessage.setId(spu.getId().toString());
                errorMessage.setBillNo(spu.getName());
                errorMessage.setMessage(String.valueOf(skuThreeList) + "\u5ba2\u60a6\u7f16\u7801\u91cd\u590d");
                errorMessageList.add(errorMessage);
                continue;
            }
            List skuFourList = barCodeList.stream().filter(item -> bras.contains(item.getBarCode()) && !skuIdArray.contains(item.getPsSkuId())).map(SkuBarCode::getBarCode).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(skuFourList)) {
                errorMessage.setId(spu.getId().toString());
                errorMessage.setBillNo(spu.getName());
                errorMessage.setMessage(String.valueOf(skuFourList) + "\u6761\u5f62\u7801\u91cd\u590d");
                errorMessageList.add(errorMessage);
                continue;
            }
            successIdList.add(spu.getId());
        }
        List ids = errorMessageList.stream().map(PsBasicsBatchVO.ErrorMessage::getId).collect(Collectors.toList());
        psBasicsBatchVO.setErrorIds(ids);
        psBasicsBatchVO.setErrorTotal(Integer.valueOf(ids.size()));
        psBasicsBatchVO.setSuccessTotal(Integer.valueOf(successIdList.size()));
        psBasicsBatchVO.setTotal(Integer.valueOf(spuList.size()));
        psBasicsBatchVO.setErrorMessageList((List)errorMessageList);
        return psBasicsBatchVO;
    }

    private Integer getCheckStatus(Integer status) {
        if (CheckStatusEnums.NOT_CHECK.getCode().equals(status) || CheckStatusEnums.REJECT_ADD.getCode().equals(status)) {
            return CheckStatusEnums.CHECK_ADD.getCode();
        }
        if (CheckStatusEnums.REJECT_UPDATE.getCode().equals(status) || CheckStatusEnums.REJECT_ENABLED.getCode().equals(status)) {
            return CheckStatusEnums.CHECK_UPDATE.getCode();
        }
        if (CheckStatusEnums.SUCCESS.getCode().equals(status)) {
            return CheckStatusEnums.CHECK_UPDATE.getCode();
        }
        return status;
    }

    private String createSpuOaFlow(List<SpuOaExportDTO> spuOaExportList, List<SpuComposeOaExportDTO> spuComposeOaExportList, LoginUserInfo user, List<Long> orgSalesmanIdList, Long dingDingDeptId) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        SpuOaHeaderDTO spuOaHeaderDTO = new SpuOaHeaderDTO();
        if (CollUtil.isNotEmpty(spuComposeOaExportList)) {
            SpuComposeTableKeyDTO spuComposeTableKeyDTO = SpuComposeTableKeyDTO.builder().barCode("\u6761\u5f62\u7801").checkStatus("\u5546\u54c1\u5ba1\u6838\u72b6\u6001").classify("\u5546\u54c1\u7c7b\u578b").code("\u5546\u54c1\u7f16\u7801").composeNumber("\u660e\u7ec6\u7ec4\u5408\u6570\u91cf").counterPrice("\u4e13\u67dc\u4ef7").customerPrice("\u5efa\u8bae\u5ba2\u6237\u552e\u4ef7").detailCounterPrice("\u660e\u7ec6\u4e13\u67dc\u4ef7").detailPsUnitName("\u660e\u7ec6\u5355\u4f4d").detailRetailPrice("\u660e\u7ec6\u5efa\u8bae\u96f6\u552e\u4ef7").grossWeight("\u5546\u54c1\u6bdb\u91cd(kg)").high("\u5546\u54c1\u9ad8(cm)").invoiceItemName("\u53d1\u7968\u9879\u76ee\u540d\u79f0").isAviationBan("\u822a\u7a7a\u7981\u7528").kyThirdPlatformCode("\u7b2c\u4e09\u65b9\u7f16\u7801").length("\u5546\u54c1\u957f\u91cd(cm)").moneyTypeName("\u4ef7\u683c\u5e01\u522b").name("\u5546\u54c1\u540d\u79f0").netWeight("\u5546\u54c1\u51c0\u91cd(kg)").packingQty("\u88c5\u7bb1\u6570\u91cf").psBrandName("\u54c1\u724c").psCategoryName("\u5546\u54c1\u7c7b\u76ee").psUnitName("\u5546\u54c1\u57fa\u672c\u5355\u4f4d").retailPrice("\u5efa\u8bae\u96f6\u552e\u4ef7").skuBarCode("\u660e\u7ec6\u6761\u5f62\u7801").skuCode("\u89c4\u683c\u7f16\u7801").skuName("\u89c4\u683c\u540d\u79f0").skuNameCode("\u660e\u7ec6\u89c4\u683c\u540d\u79f0\u7f16\u7801").skuPsUnitName("\u88c5\u7bb1\u5355\u4f4d").specName("\u89c4\u683c\u5c5e\u6027\u540d\u79f0").specValue("\u89c4\u683c\u5c5e\u6027\u503c").spuNameCode("\u660e\u7ec6\u5546\u54c1\u540d\u79f0/\u7f16\u7801").status("\u5546\u54c1\u72b6\u6001").type("\u89c4\u683c\u7c7b\u578b").volume("\u4f53\u79ef(cm3)").wide("\u5546\u54c1\u5bbd(cm)").wmsThirdPlatformCode("wms\u7b2c\u4e09\u65b9\u7f16\u7801").detailCustomerPrice("\u660e\u7ec6\u5efa\u8bae\u5ba2\u6237\u552e\u4ef7").allocationRule("\u5206\u644a\u89c4\u5219").sgCostPrice("\u6210\u672c\u4ef7").sgCostPriceNum("\u6210\u672c\u91d1\u989d").totalSgCostPrice("\u7ec4\u5408\u5546\u54c1\u6210\u672c").allocationRatio("\u5206\u644a\u6bd4\u4f8b").wholesale("\u662f\u5426\u4e00\u4ef6\u4ee3\u53d1").build();
            spuOaHeaderDTO.setComposeSpuDetails(spuComposeTableKeyDTO);
            if (CollUtil.isNotEmpty(orgSalesmanIdList)) {
                List<SalesmanVO> salesmanVOList = this.mdmAdapter.querySalesmanBatch(orgSalesmanIdList);
                Assert.isTrue((orgSalesmanIdList.size() == salesmanVOList.size() ? 1 : 0) != 0, (String)"\u8d1f\u8d23\u4e1a\u52a1\u5458\u4e0d\u5b58\u5728");
                List nameList = salesmanVOList.stream().filter(item -> !"2".equals(item.getStatus())).map(SalesmanVO::getName).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(nameList)) {
                    throw new IllegalArgumentException(nameList.toString() + "\u8d1f\u8d23\u4e1a\u52a1\u5458\u4e0d\u662f\u542f\u7528\u72b6\u6001");
                }
                data.put("salesMan", "[" + StringUtils.join((Object[])salesmanVOList.stream().map(SalesmanVO::getPhone).toArray(), (String)",") + "]");
            }
            List<SpuComposeOaListDTO> composeOaListDTOS = this.covertTableSpuCompose(spuComposeOaExportList);
            data.put("composeSpuDetails", composeOaListDTOS);
        } else {
            SpuTableKeyDTO spuTableKeyDTO = SpuTableKeyDTO.builder().barCode("\u6761\u5f62\u7801").checkStatus("\u5546\u54c1\u5ba1\u6838\u72b6\u6001").classify("\u5546\u54c1\u7c7b\u578b").code("\u5546\u54c1\u7f16\u7801").counterPrice("\u4e13\u67dc\u4ef7").grossWeight("\u5546\u54c1\u6bdb\u91cd(kg)").high("\u5546\u54c1\u9ad8(cm)").invoiceItemName("\u53d1\u7968\u9879\u76ee\u540d\u79f0").isAviationBan("\u822a\u7a7a\u7981\u7528").kyThirdPlatformCode("\u7b2c\u4e09\u65b9\u7f16\u7801").length("\u5546\u54c1\u957f\u91cd(cm)").moneyTypeName("\u4ef7\u683c\u5e01\u522b").name("\u5546\u54c1\u540d\u79f0").netWeight("\u5546\u54c1\u51c0\u91cd(kg)").packingQty("\u88c5\u7bb1\u6570\u91cf").productionPlace("\u4ea7\u5730").psBrandCountryName("\u54c1\u724c\u6240\u5c5e\u56fd").psBrandName("\u54c1\u724c").psCategoryName("\u5546\u54c1\u7c7b\u76ee").psUnitName("\u5546\u54c1\u57fa\u672c\u5355\u4f4d").retailPrice("\u5efa\u8bae\u96f6\u552e\u4ef7").shelfLifeName("\u4fdd\u8d28\u671f").skuCode("\u89c4\u683c\u7f16\u7801").skuName("\u89c4\u683c\u540d\u79f0").skuPsUnitName("\u88c5\u7bb1\u5355\u4f4d").specName("\u89c4\u683c\u5c5e\u6027\u540d\u79f0").specValue("\u89c4\u683c\u5c5e\u6027\u503c").status("\u5546\u54c1\u72b6\u6001").type("\u89c4\u683c\u7c7b\u578b").volume("\u4f53\u79ef(cm3)").wide("\u5546\u54c1\u5bbd(cm)").wmsThirdPlatformCode("wms\u7b2c\u4e09\u65b9\u7f16\u7801").customerPrice("\u5efa\u8bae\u5ba2\u6237\u552e\u4ef7").wholesale("\u662f\u5426\u4e00\u4ef6\u4ee3\u53d1").build();
            spuOaHeaderDTO.setSpuDetails(spuTableKeyDTO);
            List<SpuOaListDTO> spuOaListDTOS = this.covertSpuCompose(spuOaExportList);
            data.put("spuDetails", spuOaListDTOS);
        }
        String fileName = "sku.xlsx";
        FileUtil.mkdir((String)ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME);
        String filePath = ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME + fileName;
        String fileUrl = "";
        boolean notEmpty = CollUtil.isNotEmpty(spuOaExportList);
        List currencyTypeList = this.dictRedisRepository.selectDictValueListByCode("currencyType");
        Map<Object, String> currencyTypeMap = currencyTypeList.stream().collect(Collectors.toMap(DictValue::getValueCode, DictValue::getName));
        spuOaExportList.forEach(item -> item.setMoneyTypeName((String)currencyTypeMap.get(String.valueOf(item.getMoneyType()))));
        try {
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u5546\u54c1\u5217\u8868", "\u5546\u54c1\u5217\u8868"), notEmpty ? SpuOaExportDTO.class : SpuComposeOaExportDTO.class, notEmpty ? spuOaExportList : spuComposeOaExportList);
            FileOutputStream fos = new FileOutputStream(filePath);
            workbook.write((OutputStream)fos);
            fos.close();
            fileUrl = this.fileUploadUtil.uploadExcelFile("product/", filePath, PinyinUtil.getPinyin((String)user.getUserName()));
            FileUtil.del((String)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("\u5546\u54c1\u5ba1\u6838\u6587\u4ef6\u751f\u6210\u5931\u8d25");
        }
        data.put("excelPath", fileUrl);
        data.put("tableKeyJson", spuOaHeaderDTO);
        data.put("phoneNumber", user.getPhoneNumber());
        data.put("dingDingDeptId", dingDingDeptId);
        return this.oaAdapter.createOaProcessV2(JSON.toJSONString(data), "PRODUCT_AUDIT");
    }

    private List<SpuOaListDTO> covertSpuCompose(List<SpuOaExportDTO> spuOaExportList) {
        ArrayList spuOaListDTOS = CollUtil.newArrayList((Object[])new SpuOaListDTO[0]);
        List currencyTypeList = this.dictRedisRepository.selectDictValueListByCode("currencyType");
        Map<Object, String> currencyTypeMap = currencyTypeList.stream().collect(Collectors.toMap(DictValue::getValueCode, DictValue::getName));
        for (SpuOaExportDTO spuOaExportDTO : spuOaExportList) {
            for (int i = 0; i < spuOaExportDTO.getSkuOaExportList().size(); ++i) {
                SpuOaListDTO spuOaListDTO = new SpuOaListDTO();
                SkuOaExportDTO skuOaExportDTO = (SkuOaExportDTO)spuOaExportDTO.getSkuOaExportList().get(i);
                if (i == 0) {
                    BeanConvertUtil.copyProperties(spuOaExportDTO, spuOaListDTO);
                    spuOaListDTO.setClassify(SpuClassifyEnums.getDescByCode((Integer)spuOaExportDTO.getClassify()));
                    spuOaListDTO.setStatus(StatusEnums.getDescByCode((Integer)spuOaExportDTO.getStatus()));
                    spuOaListDTO.setCheckStatus(CheckStatusEnums.getDescByCode((Integer)spuOaExportDTO.getCheckStatus()));
                    spuOaListDTO.setIsAviationBan(WhetherEnum.getDescByCode((Integer)spuOaExportDTO.getIsAviationBan()));
                    spuOaListDTO.setMoneyType(currencyTypeMap.get(String.valueOf(spuOaExportDTO.getMoneyType())));
                    spuOaListDTO.setWholesale(WhetherEnum.getDescByCode((Integer)spuOaExportDTO.getWholesale()));
                }
                BeanUtils.copyProperties((Object)skuOaExportDTO, (Object)spuOaListDTO, (String[])new String[]{"psUnitName", "name", "code", "wholesale"});
                spuOaListDTO.setType(SkuTypeEnums.getDescByCode((Integer)skuOaExportDTO.getType()));
                spuOaListDTO.setSkuCode(skuOaExportDTO.getCode());
                spuOaListDTO.setSkuName(skuOaExportDTO.getName());
                spuOaListDTOS.add(spuOaListDTO);
            }
        }
        return spuOaListDTOS;
    }

    private List<SpuComposeOaListDTO> covertTableSpuCompose(List<SpuComposeOaExportDTO> spuComposeOaExportList) {
        ArrayList composeOaListDTOS = CollUtil.newArrayList((Object[])new SpuComposeOaListDTO[0]);
        List currencyTypeList = this.dictRedisRepository.selectDictValueListByCode("currencyType");
        Map<Object, String> currencyTypeMap = currencyTypeList.stream().collect(Collectors.toMap(DictValue::getValueCode, DictValue::getName));
        for (SpuComposeOaExportDTO spuComposeOaExportDTO : spuComposeOaExportList) {
            for (int i = 0; i < spuComposeOaExportDTO.getComposeSkuOaExportList().size(); ++i) {
                SpuComposeOaListDTO spuComposeOaListDTO = new SpuComposeOaListDTO();
                ComposeSkuOaExportDTO composeSkuOaExportDTO = (ComposeSkuOaExportDTO)spuComposeOaExportDTO.getComposeSkuOaExportList().get(i);
                if (i == 0) {
                    BeanUtils.copyProperties((Object)spuComposeOaExportDTO, (Object)spuComposeOaListDTO, (String[])new String[]{"psUnitName", "barCode", "counterPrice", "retailPrice", "customerPrice", "sgCostPrice", "allocationRatio", "sgCostPriceNum"});
                    spuComposeOaListDTO.setClassify(SpuClassifyEnums.getDescByCode((Integer)spuComposeOaExportDTO.getClassify()));
                    spuComposeOaListDTO.setStatus(StatusEnums.getDescByCode((Integer)spuComposeOaExportDTO.getStatus()));
                    spuComposeOaListDTO.setCheckStatus(CheckStatusEnums.getDescByCode((Integer)spuComposeOaExportDTO.getCheckStatus()));
                    spuComposeOaListDTO.setIsAviationBan(WhetherEnum.getDescByCode((Integer)spuComposeOaExportDTO.getIsAviationBan()));
                    spuComposeOaListDTO.setMoneyType(currencyTypeMap.get(String.valueOf(spuComposeOaExportDTO.getMoneyType())));
                    spuComposeOaListDTO.setType(SkuTypeEnums.getDescByCode((Integer)spuComposeOaExportDTO.getType()));
                    spuComposeOaListDTO.setAllocationRule(AllocationRuleEnums.getDescByCode((String)spuComposeOaExportDTO.getAllocationRule()));
                    spuComposeOaListDTO.setWholesale(WhetherEnum.getDescByCode((Integer)spuComposeOaExportDTO.getWholesale()));
                    spuComposeOaListDTO.setTotalSgCostPrice(spuComposeOaExportDTO.getTotalSgCostPrice());
                }
                BeanUtils.copyProperties((Object)composeSkuOaExportDTO, (Object)spuComposeOaListDTO, (String[])new String[]{"psUnitName", "barCode", "counterPrice", "retailPrice", "customerPrice", "wholesale"});
                spuComposeOaListDTO.setDetailCounterPrice(composeSkuOaExportDTO.getCounterPrice());
                spuComposeOaListDTO.setDetailPsUnitName(composeSkuOaExportDTO.getPsUnitName());
                spuComposeOaListDTO.setDetailRetailPrice(composeSkuOaExportDTO.getRetailPrice());
                spuComposeOaListDTO.setDetailCustomerPrice(composeSkuOaExportDTO.getCustomerPrice());
                spuComposeOaListDTO.setSkuBarCode(composeSkuOaExportDTO.getBarCode());
                spuComposeOaListDTO.setSgCostPriceNum(composeSkuOaExportDTO.getSgCostPriceNum());
                spuComposeOaListDTO.setSgCostPrice(composeSkuOaExportDTO.getSgCostPrice());
                spuComposeOaListDTO.setAllocationRatio(composeSkuOaExportDTO.getAllocationRatioStr());
                composeOaListDTOS.add(spuComposeOaListDTO);
            }
        }
        return composeOaListDTOS;
    }

    String createNewFlow(String fromJson, String userJson, String templateType) {
        ApiResponse apiResponse = this.workFlowApi.createNewWorkFlow(fromJson, userJson, templateType);
        Assert.isTrue((apiResponse != null ? 1 : 0) != 0, (String)"\u63d0\u4ea4\u9489\u9489\u5ba1\u6838\u5931\u8d25");
        if (!apiResponse.isSuccess()) {
            throw new IllegalArgumentException(apiResponse.getDesc());
        }
        return (String)apiResponse.getContent();
    }

    @Override
    @LogAnnotation
    public void oaCallback(String oaId, String result, String status) {
        List checkStatus = Stream.of(CheckStatusEnums.CHECK_ADD.getCode(), CheckStatusEnums.CHECK_UPDATE.getCode(), CheckStatusEnums.CHECK_ENABLED.getCode()).collect(Collectors.toList());
        List spuList = this.spuService.selectByOa(oaId, checkStatus);
        if (CollUtil.isEmpty((Collection)spuList) && OaResultEnum.FLOW_RESULT_REFUSE.getCode().equals(result)) {
            return;
        }
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)spuList), (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        for (Spu spu : spuList) {
            boolean isCompose;
            boolean bl = isCompose = SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify());
            if (OaResultEnum.FLOW_RESULT_AGREE.getCode().equals(result)) {
                spu.setCheckStatus(CheckStatusEnums.SUCCESS.getCode());
                spu.setStatus(StatusEnums.ENABLED.getCode());
                InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u5ba1\u6838\u901a\u8fc7", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u5546\u54c1\u5ba1\u6838\u901a\u8fc7");
                continue;
            }
            if (CheckStatusEnums.CHECK_ADD.getCode().equals(spu.getCheckStatus())) {
                spu.setCheckStatus(CheckStatusEnums.REJECT_ADD.getCode());
            } else if (CheckStatusEnums.CHECK_UPDATE.getCode().equals(spu.getCheckStatus())) {
                spu.setCheckStatus(CheckStatusEnums.REJECT_UPDATE.getCode());
            } else if (CheckStatusEnums.CHECK_ENABLED.getCode().equals(spu.getCheckStatus())) {
                spu.setCheckStatus(CheckStatusEnums.REJECT_ENABLED.getCode());
            }
            InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u5ba1\u6838\u62d2\u7edd", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u5546\u54c1\u5ba1\u6838\u62d2\u7edd");
        }
        this.spuService.updateBatchById((Collection)spuList);
        if (OaResultEnum.FLOW_RESULT_AGREE.getCode().equals(result)) {
            List<Spu> spuArrList = spuList.stream().filter(item -> WhetherEnum.NO.getCode().equals(item.getWholesale()) && !SpuClassifyEnums.COMPOSE.getCode().equals(item.getClassify())).collect(Collectors.toList());
            List spuIdList = spuArrList.stream().map(BaseDo::getId).collect(Collectors.toList());
            List<Sku> skuList = CollUtil.newArrayList((Object[])new Sku[0]);
            List skuBarCodeList = CollUtil.newArrayList((Object[])new SkuBarCode[0]);
            if (CollUtil.isNotEmpty(spuIdList) && CollUtil.isNotEmpty((Collection)(skuList = this.skuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Sku::getPsSpuId, spuIdList)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE))))) {
                List skuIds = skuList.stream().map(BaseDo::getId).collect(Collectors.toList());
                skuBarCodeList = this.skuBarCodeService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuBarCode::getPsSkuId, skuIds)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
            }
            ArrayList ownerCodeList = CollUtil.newArrayList((Object[])new String[0]);
            for (Spu spu : spuArrList) {
                if (!StrUtil.isNotBlank((CharSequence)spu.getOwnerCode())) continue;
                ownerCodeList.addAll(Arrays.asList(StringUtils.split((String)spu.getOwnerCode(), (String)",")));
            }
            List<String> ownerCodes = ownerCodeList.stream().distinct().collect(Collectors.toList());
            this.skuBiz.singleItemSynchronize(spuArrList, skuList, skuBarCodeList, ownerCodes);
        }
        List spuId = spuList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List skuArrayList = this.skuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Sku::getPsSpuId, spuId)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        this.deleteRedisKeyList(skuArrayList);
    }

    public QuerySpuDTO queryDetails(Long spuId) {
        List querySkuDTOS;
        Spu spu = (Spu)this.spuService.getById((Serializable)spuId);
        Assert.notNull((Object)spu, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)spu.getIsDelete().equals(IsDeleteEnums.NO.getCode()), (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        QuerySpuDTO spuDTO = new QuerySpuDTO();
        BeanConvertUtil.copyProperties(spu, spuDTO);
        if (StrUtil.isNotBlank((CharSequence)spu.getOwnerCode())) {
            spuDTO.setOwnerCodeList(Arrays.asList(spu.getOwnerCode().split(",")));
        }
        List<SpuPicture> spuPictureList = this.spuPictureBiz.selectBySpuId(spu.getId());
        List<QuerySpuPictureDTO> spuPictureDTOList = BeanConvertUtil.convertList(spuPictureList, QuerySpuPictureDTO.class);
        spuDTO.setSpuPictureList(spuPictureDTOList);
        List<QuerySpuAttributeDTO> spuAttributeDTOList = this.spuAttributeBiz.selectAttribute(spu.getId(), null);
        spuDTO.setSpuAttributeList(spuAttributeDTOList);
        List<QueryComposeSkuDTO> composeSkuDTOList = this.composeSkuBiz.selectComposeSku(spu.getId());
        spuDTO.setComposeSkuList(composeSkuDTOList);
        List<QuerySkuDTO> skuDTOList = this.skuBiz.selectSku(spu.getId());
        spuDTO.setSkuList(skuDTOList);
        if ((SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify())) && CollectionUtils.isNotEmpty(composeSkuDTOList)) {
            SystemConfigVO systemConfig = this.mdmAdapter.queryBySystemConfigKeyCode("COMPOSE_SPU_WAREHOUSE_CODE");
            Assert.notNull((Object)systemConfig, (String)"\u7ec4\u5408\u5546\u54c1\u67e5\u8be2\u6210\u672c\u4ef7\u914d\u7f6e\u7684\u5b9e\u4f53\u4ed3\u7f16\u7801\u7cfb\u7edf\u53c2\u6570\u4e0d\u5b58\u5728");
            ArrayList skuCodeList = Lists.newArrayList();
            ArrayList skuIdList = Lists.newArrayList();
            for (QueryComposeSkuDTO composeSkuDTO : composeSkuDTOList) {
                skuCodeList.add(composeSkuDTO.getSkuCode());
                skuIdList.add(composeSkuDTO.getPsSkuId());
            }
            List<SgBStorageCostVo> sgBStorageCostVos = this.sgStorageQueryAdapter.selectCostByWarehouseCodeAndSku(systemConfig.getValue(), skuCodeList);
            Map<String, SgBStorageCostVo> skuCodeSgCostMap = sgBStorageCostVos.stream().collect(Collectors.toMap(SgBStorageCostVo::getPsCSkuEcode, item -> item, (o, v) -> o));
            List skuSupplyPriceList = this.skuSupplyPriceService.getBySkuIds((List)skuIdList, (List)CollUtil.newArrayList((Object[])new Integer[]{StatusEnums.ENABLED.getCode()}), null, SupplyPriceTypeEnums.ONE.getCode());
            Map<Long, BigDecimal> skuSupplyPriceMap = skuSupplyPriceList.stream().collect(Collectors.toMap(SkuSupplyPrice::getPsSkuId, SkuSupplyPrice::getSupplyPrice, (o, v) -> o));
            for (QueryComposeSkuDTO composeSkuDTO : composeSkuDTOList) {
                BigDecimal supplyPrice;
                SgBStorageCostVo sgBStorageCostVo = skuCodeSgCostMap.get(composeSkuDTO.getSkuCode());
                if (Objects.nonNull(sgBStorageCostVo)) {
                    composeSkuDTO.setCostPrice(BigDecimalUtils.convert(sgBStorageCostVo.getPriceCost(), 2));
                }
                if (!Objects.nonNull(supplyPrice = skuSupplyPriceMap.get(composeSkuDTO.getId()))) continue;
                composeSkuDTO.setPsSupplyPrice(BigDecimalUtils.convert(supplyPrice, 2));
            }
        }
        if (CollUtil.isNotEmpty(querySkuDTOS = skuDTOList.stream().filter(item -> WmsStatusEnum.FAIL.getCode().equals(item.getWmsStatus())).collect(Collectors.toList()))) {
            spuDTO.setIsFailWmsSku(Boolean.TRUE);
        } else {
            spuDTO.setIsFailWmsSku(Boolean.FALSE);
        }
        ArrayList skuSpecList = new ArrayList();
        for (QuerySkuDTO querySkuDTO : skuDTOList) {
            skuSpecList.addAll(querySkuDTO.getSkuSpecList());
        }
        Map<Long, List<QuerySkuSpecDTO>> spec = skuSpecList.stream().collect(Collectors.groupingBy(QuerySkuSpecDTO::getPsSpecId));
        ArrayList<SpecDTO> specDTOS = new ArrayList<SpecDTO>();
        for (Long key : spec.keySet()) {
            SpecDTO specDTO = new SpecDTO();
            List<QuerySkuSpecDTO> skuSpecDTOList = spec.get(key);
            specDTO.setPsSpecId(skuSpecDTOList.get(0).getPsSpecId());
            specDTO.setPsSpecName(skuSpecDTOList.get(0).getPsSpecName());
            List specValueIdList = skuSpecDTOList.stream().map(QuerySkuSpecDTO::getPsSpecValueId).distinct().collect(Collectors.toList());
            specDTO.setSpecValueIdList(specValueIdList);
            specDTOS.add(specDTO);
        }
        spuDTO.setSpecList(specDTOS);
        return spuDTO;
    }

    public void downloadZip(SpuDetailsDTO jsonData, HttpServletResponse response) {
        Long spuId = jsonData.getId();
        Assert.notNull((Object)spuId, (String)"spuId\u4e0d\u80fd\u4e3a\u7a7a");
        Spu spu = (Spu)this.spuService.getById((Serializable)spuId);
        Assert.notNull((Object)spu, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        String details = spu.getDetails();
        List<String> pictureArticleUrlList = StringUtil.extractImageUrls(details);
        List<String> spuPictureUrlList = this.getSpuPictureUrl(spuId);
        LoginUserInfo loginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        String showcaseDiagramFileName = this.getShowcaseDiagramFileName(loginUserInfo.getUserId(), spuId);
        for (int i = 0; i < spuPictureUrlList.size(); ++i) {
            this.fileUploadUtil.downLoadPictureFileByWholeUrl(showcaseDiagramFileName, spuPictureUrlList.get(i), "/picture" + i);
        }
        String detailDiagramFileName = this.getDetailDiagramFileName(loginUserInfo.getUserId(), spuId);
        for (int i = 0; i < pictureArticleUrlList.size(); ++i) {
            this.fileUploadUtil.downLoadPictureFileByWholeUrl(detailDiagramFileName, pictureArticleUrlList.get(i), "/picture" + i);
        }
        FileZipUtil.FolderInfo subFolder1 = new FileZipUtil.FolderInfo("\u6a71\u7a97\u56fe", ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME + showcaseDiagramFileName);
        FileZipUtil.FolderInfo subFolder2 = new FileZipUtil.FolderInfo("\u8be6\u60c5\u56fe", ConstantPropertiesUtil.DEFAULT_FILE_OPERATE_NAME + detailDiagramFileName);
        try {
            FileZipUtil.zipAndDownload(response, jsonData.getZipFileName(), subFolder1, subFolder2);
        }
        catch (IOException e) {
            log.error("business.com.xinqiyi.ps.service.SpuBiz.downloadZip \u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25\uff1a{}", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private String getShowcaseDiagramFileName(long userId, Long spuId) {
        return "ShowcaseDiagram_user_" + userId + "_spuId_" + spuId;
    }

    private String getDetailDiagramFileName(long userId, Long spuId) {
        return "DetailDiagram_user_" + userId + "_spuId_" + spuId;
    }

    private List<String> getSpuPictureUrl(Long spuId) {
        List<SpuPicture> spuPictureList = this.spuPictureBiz.selectBySpuId(spuId);
        spuPictureList.sort((o1, o2) -> o1.getIsMain() != false ? -1 : (o2.getIsMain() != false ? 1 : 0));
        List<String> spuPictureRelvativeUrlList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
        ArrayList<String> spuPictureUrlList = new ArrayList<String>();
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(spuPictureRelvativeUrlList);
        for (String relativeUrl : spuPictureRelvativeUrlList) {
            ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)relativeUrl, (CharSequence)item.getUrl())).findAny().ifPresent(ossUrlVO -> spuPictureUrlList.add(ossUrlVO.getIntactUrl()));
        }
        return spuPictureUrlList;
    }

    public void deleteSpu(List<Long> spuIdList) {
        List spuCollection = this.spuService.listByIds(spuIdList);
        ArrayList<Sku> skuList = new ArrayList<Sku>();
        ArrayList<SkuSpec> skuSpecList = new ArrayList<SkuSpec>();
        ArrayList<ComposeSku> composeSkuList = new ArrayList<ComposeSku>();
        ArrayList<SpuAttribute> spuAttributeList = new ArrayList<SpuAttribute>();
        ArrayList spuAttributeValueList = new ArrayList();
        ArrayList<SpuPicture> spuPictureList = new ArrayList<SpuPicture>();
        ArrayList<SkuBarCode> skuBarCodeList = new ArrayList<SkuBarCode>();
        ArrayList<Spu> spuList = new ArrayList<Spu>();
        for (Spu spu : spuCollection) {
            Assert.isTrue((boolean)spu.getIsDelete().equals(IsDeleteEnums.NO.getCode()), (String)(spu.getName() + " \u5546\u54c1\u5df2\u5220\u9664"));
            this.checkDeleteStatus(spu);
            List<Sku> skuCollection = this.skuBiz.selectBySpuId(spu.getId());
            List<SkuSpec> skuSpecs = this.getSkuSpecList(skuCollection);
            List<ComposeSku> composeSkuCollection = this.composeSkuBiz.selectBySpuId(spu.getId());
            for (ComposeSku composeSku : composeSkuCollection) {
                composeSku.setIsDelete(IsDeleteEnums.YES.getCode());
            }
            List<SpuAttribute> spuAttributes = this.spuAttributeBiz.selectBySpuId(spu.getId());
            ArrayList<SpuAttributeValue> spuAttributeValues = new ArrayList<SpuAttributeValue>();
            for (SpuAttribute spuAttribute : spuAttributes) {
                spuAttribute.setIsDelete(IsDeleteEnums.YES.getCode());
                List spuAttributeValueCollection = this.spuAttributeValueService.selectByAttributeId(spuAttribute.getId());
                for (SpuAttributeValue spuAttributeValue : spuAttributeValueCollection) {
                    spuAttributeValue.setIsDelete(IsDeleteEnums.YES.getCode());
                    spuAttributeValues.add(spuAttributeValue);
                }
            }
            List<SpuPicture> spuPictures = this.spuPictureBiz.selectBySpuId(spu.getId());
            for (SpuPicture spuPicture : spuPictures) {
                spuPicture.setIsDelete(IsDeleteEnums.YES.getCode());
            }
            Spu spu2 = new Spu();
            spu2.setId(spu.getId());
            spu2.setIsDelete(IsDeleteEnums.YES.getCode());
            List skuIdList = skuCollection.stream().map(BaseDo::getId).collect(Collectors.toList());
            List skuBarCodes = this.skuBarCodeService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuBarCode::getPsSkuId, skuIdList)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
            for (SkuBarCode skuBarCode : skuBarCodes) {
                skuBarCode.setIsDelete(IsDeleteEnums.YES.getCode());
                skuBarCodeList.add(skuBarCode);
            }
            spuList.add(spu2);
            skuList.addAll(skuCollection);
            skuSpecList.addAll(skuSpecs);
            composeSkuList.addAll(composeSkuCollection);
            spuAttributeList.addAll(spuAttributes);
            spuAttributeValueList.addAll(spuAttributeValues);
            spuPictureList.addAll(spuPictures);
        }
        this.spuService.updateSpu(spuList, skuList, skuSpecList, composeSkuList, spuAttributeList, spuAttributeValueList, spuPictureList, skuBarCodeList);
        for (Sku sku : skuList) {
            this.deleteRedisKey(sku);
        }
    }

    void checkDeleteStatus(Spu spu) {
        Assert.isTrue((CheckStatusEnums.NOT_CHECK.getCode().equals(spu.getCheckStatus()) || CheckStatusEnums.REJECT_ADD.getCode().equals(spu.getCheckStatus()) || CheckStatusEnums.REJECT_UPDATE.getCode().equals(spu.getCheckStatus()) || CheckStatusEnums.REJECT_ENABLED.getCode().equals(spu.getCheckStatus()) ? 1 : 0) != 0, (String)"\u6b64\u5546\u54c1\u5ba1\u6838\u72b6\u6001\u4e0d\u53ef\u5220\u9664");
        Assert.isTrue((boolean)StatusEnums.NOT_ENABLED.getCode().equals(spu.getStatus()), (String)"\u5546\u54c1\u5df2\u88ab\u542f\u7528\u8fc7,\u4e0d\u53ef\u5220\u9664");
    }

    List<SkuSpec> getSkuSpecList(List<Sku> skuList) {
        ArrayList<SkuSpec> skuSpecList = new ArrayList<SkuSpec>();
        for (Sku sku : skuList) {
            sku.setIsDelete(IsDeleteEnums.YES.getCode());
            List<SkuSpec> skuSpecs = this.skuSpecBiz.selectBySkuId(sku.getId());
            for (SkuSpec skuSpec : skuSpecs) {
                skuSpec.setIsDelete(IsDeleteEnums.YES.getCode());
                skuSpecList.add(skuSpec);
            }
        }
        return skuSpecList;
    }

    public List<QueryInteriorSkuDTO> selectSpuList(SpuQueryV2DTO dto) {
        SpuQueryDTO queryDTO = new SpuQueryDTO();
        BeanUtils.copyProperties((Object)dto, (Object)queryDTO);
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQueryTag(queryDTO);
        this.skuBiz.covertCategory(queryDTO);
        List queryInteriorSkuDTOS = this.spuService.selectSpuList(dto, queryDTO);
        this.skuBiz.covertInteriorSkuList(queryInteriorSkuDTOS, null, null, queryDTO.getSupplyPriceType(), queryDTO.getPsStoreId());
        return queryInteriorSkuDTOS;
    }

    public Spu selectSpuByCode(String code) {
        return this.spuService.selectSpuByCode(code);
    }

    public Page<QueryInteriorSkuDTO> selectSpuPage(SpuQueryV2DTO dto) {
        SpuQueryDTO queryDTO = new SpuQueryDTO();
        BeanUtils.copyProperties((Object)dto, (Object)queryDTO);
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQueryTag(queryDTO);
        this.skuBiz.covertCategory(queryDTO);
        this.skuBiz.convertBrandPermission(queryDTO);
        Page page = this.spuService.selectSpuPage(dto, queryDTO);
        this.skuBiz.covertInteriorSkuList(page.getRecords(), null, null, queryDTO.getSupplyPriceType(), queryDTO.getPsStoreId());
        if (CollUtil.isNotEmpty((Collection)page.getRecords())) {
            List spuIdList = page.getRecords().stream().map(QueryInteriorSkuDTO::getSpuId).collect(Collectors.toList());
            List skuList = this.skuService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Sku::getPsSpuId, spuIdList)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE)).eq(Sku::getWmsStatus, (Object)WmsStatusEnum.FAIL.getCode()));
            List psSkuTags = this.psSkuTagService.list((Wrapper)new QueryWrapper().lambda().in(PsSkuTag::getPsSpuId, spuIdList));
            List psTags = CollUtil.newArrayList((Object[])new PsTag[0]);
            if (CollUtil.isNotEmpty((Collection)psSkuTags)) {
                List tagIdList = psSkuTags.stream().map(PsSkuTag::getPsTagId).collect(Collectors.toList());
                psTags = this.psTagService.listByIds(tagIdList);
            }
            for (QueryInteriorSkuDTO record : page.getRecords()) {
                List skuArrayList = skuList.stream().filter(item -> item.getPsSpuId().equals(record.getSpuId())).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(skuArrayList)) {
                    record.setIsFailWmsSku(Boolean.TRUE);
                } else {
                    record.setIsFailWmsSku(Boolean.FALSE);
                }
                List tagList = psSkuTags.stream().filter(item -> item.getPsSpuId().equals(record.getSpuId())).map(PsSkuTag::getPsTagId).distinct().collect(Collectors.toList());
                ArrayList skuTagDTOS = CollUtil.newArrayList((Object[])new SkuTagDTO[0]);
                for (Long id : tagList) {
                    SkuTagDTO skuTagDTO = new SkuTagDTO();
                    PsTag psTag = psTags.stream().filter(item -> item.getId().equals(id)).findAny().orElse(null);
                    if (psTag != null) {
                        BeanConvertUtil.copyProperties(psTag, skuTagDTO);
                    }
                    skuTagDTOS.add(skuTagDTO);
                }
                record.setPsTagList((List)skuTagDTOS);
            }
        }
        return page;
    }

    public void importSpuExcel(MultipartFile file, HttpServletResponse response) {
        List<ImportSpuExcelOfModeDTO> list = ImportHelper.importExcelToBeanExport(file, ImportSpuExcelOfModeDTO.class, 0, (IExcelVerifyHandler)SpringUtil.getBean(ExcelVerifyHandlerImpl.class), response);
        this.saveImportSpuInfo(list);
    }

    public void saveImportSpuInfo(List<ImportSpuExcelOfModeDTO> list) {
        ArrayList spuList = Lists.newArrayList();
        ArrayList skuList = Lists.newArrayList();
        ArrayList skuSpecList = Lists.newArrayList();
        ArrayList skuBarCodeList = Lists.newArrayList();
        this.assembleSpuInfo(list, spuList, skuList, skuSpecList, skuBarCodeList);
        this.spuService.insertBatchSpu((List)spuList, (List)skuList, (List)skuSpecList, (List)skuBarCodeList);
    }

    public void assembleSpuInfo(List<? extends ImportSpuExcelDTO> dtoList, List<Spu> spuList, List<Sku> skuList, List<SkuSpec> skuSpecList, List<SkuBarCode> skuBarCodeList) {
        if (CollUtil.isNotEmpty(dtoList)) {
            HashMap spuMap = Maps.newHashMap();
            HashMap skuCodeMap = Maps.newHashMap();
            for (ImportSpuExcelDTO importSpuExcelDTO : dtoList) {
                this.assembleSpuInfoCommon(importSpuExcelDTO, spuList, skuList, skuSpecList, skuBarCodeList, spuMap, skuCodeMap);
            }
        }
    }

    public void assembleSpuInfoNew(List<ImportSpuDTO> spuDTOList, List<Spu> spuList, List<Sku> skuList, List<SkuSpec> skuSpecList, List<SkuBarCode> skuBarCodeList) {
        if (CollUtil.isNotEmpty(spuDTOList)) {
            HashMap spuMap = Maps.newHashMap();
            HashMap skuCodeMap = Maps.newHashMap();
            List<ImportSpuExcelDTO> dtoList = BeanConvertUtil.convertList(spuDTOList, ImportSpuExcelDTO.class);
            for (ImportSpuExcelDTO dto : dtoList) {
                if (log.isDebugEnabled()) {
                    log.debug("AssembleSpuInfo.Dto.List.Size={},SpuSize={}, SkuSize={}", new Object[]{dtoList.size(), spuList.size(), skuList.size()});
                }
                this.assembleSpuInfoCommon(dto, spuList, skuList, skuSpecList, skuBarCodeList, spuMap, skuCodeMap);
            }
        }
    }

    private void assembleSpuInfoCommon(ImportSpuExcelDTO dto, List<Spu> spuList, List<Sku> skuList, List<SkuSpec> skuSpecList, List<SkuBarCode> skuBarCodeList, HashMap<String, Spu> spuMap, HashMap<String, AtomicInteger> skuCodeMap) {
        Spu spu;
        if (!spuMap.containsKey(dto.getName())) {
            spu = new Spu();
            BeanConvertUtil.copyProperties(dto, spu);
            spu.setId(this.idSequence.generateId(Spu.class));
            spu.setClassify(dto.getClassifyCode());
            spu.setWholesale(dto.getIsWholesaleCode());
            spu.setIsAviationBan(WhetherEnum.NO.getCode());
            spu.setStatus(StatusEnums.NOT_ENABLED.getCode());
            spu.setCheckStatus(CheckStatusEnums.NOT_CHECK.getCode());
            spu.setMoneyType(dto.getMoneyTypeCode());
            spu.setSkuType(dto.getSkuType());
            if (StringUtils.isEmpty((CharSequence)dto.getSpuCode())) {
                spu.setCode(this.getSpuCode(dto.getPsBrandCode(), spu.getClassify()));
            } else {
                spu.setCode(dto.getSpuCode());
            }
            spu.setPsUnitId(dto.getPsUnitId());
            spu.setPsUnitName(dto.getPsUnitName());
            spu.setShelfLifeUnit(SpuShelflifeUnitEnums.DAY.getCode());
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)spu);
            spuList.add(spu);
            spuMap.put(spu.getName(), spu);
            skuCodeMap.put(spu.getCode(), new AtomicInteger(0));
        }
        spu = spuMap.get(dto.getName());
        ArrayList skus = Lists.newArrayList();
        Integer isSpecialPrice = dto.getIsSpecialPriceCode();
        Integer isSpecialProcurement = dto.getIsSpecialProcurementCode();
        Integer isSpecialPriceCodePlus = dto.getIsSpecialPricePlusCode();
        Integer isTcTj = dto.getIsTcTjCode();
        Integer isTcTtj = dto.getIsTcTtjCode();
        Sku sku = new Sku();
        BeanConvertUtil.copyProperties(dto, sku);
        sku.setId(this.idSequence.generateId(Sku.class));
        sku.setType(SkuTypeEnums.NORMAL.getCode());
        if (StringUtils.isEmpty((CharSequence)dto.getSkuCode())) {
            sku.setCode(spu.getCode() + String.format("%02d", skuCodeMap.get(spu.getCode()).incrementAndGet()));
        } else {
            sku.setCode(dto.getSkuCode());
        }
        sku.setPsSpuId(spu.getId());
        sku.setVolume(dto.getLength().multiply(dto.getHigh()).multiply(dto.getWide()).setScale(4, 4));
        sku.setName(dto.getSkuName());
        sku.setPsUnitId(dto.getPsSkuUnitId());
        sku.setPsUnitName(dto.getPsSkuUnitName());
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sku);
        skus.add(sku);
        if (WhetherEnum.YES.getCode().equals(isSpecialPrice)) {
            Sku sku1 = new Sku();
            BeanConvertUtil.copyProperties(sku, sku1);
            sku1.setType(SkuTypeEnums.SPECIAL_OFFER.getCode());
            sku1.setCode(this.getSkuCodeByType(sku1, "01"));
            sku1.setPCode(sku.getCode());
            sku1.setId(this.idSequence.generateId(Sku.class));
            sku1.setName(this.getSkuNameByType(sku.getName(), 1));
            sku1.setKyThirdPlatformCode(dto.getKyThirdPlatformCode1());
            sku1.setWmsThirdPlatformCode(StrUtil.isNotBlank((CharSequence)dto.getWmsThirdPlatformCode1()) ? dto.getWmsThirdPlatformCode1() : sku1.getCode());
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sku1);
            skus.add(sku1);
        }
        if (WhetherEnum.YES.getCode().equals(isSpecialPriceCodePlus)) {
            Sku sku2 = new Sku();
            BeanConvertUtil.copyProperties(sku, sku2);
            sku2.setType(SkuTypeEnums.SPECIAL_TWO_OFFER.getCode());
            sku2.setCode(this.getSkuCodeByType(sku2, "02"));
            sku2.setPCode(sku.getCode());
            sku2.setId(this.idSequence.generateId(Sku.class));
            sku2.setName(this.getSkuNameByType(sku.getName(), 2));
            sku2.setKyThirdPlatformCode(dto.getKyThirdPlatformCode2());
            sku2.setWmsThirdPlatformCode(StrUtil.isNotBlank((CharSequence)dto.getWmsThirdPlatformCode2()) ? dto.getWmsThirdPlatformCode2() : sku2.getCode());
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)sku2);
            skus.add(sku2);
        }
        Sku sku3 = null;
        if (WhetherEnum.YES.getCode().equals(isSpecialProcurement)) {
            sku3 = new Sku();
            BeanConvertUtil.copyProperties(sku, sku3);
            sku3.setType(SkuTypeEnums.SPECIAL_MINING.getCode());
            sku3.setCode(this.getSkuCodeByType(sku3, "03"));
            sku3.setPCode(sku.getCode());
            sku3.setName(this.getSkuNameByType(sku.getName(), 3));
            sku3.setId(this.idSequence.generateId(Sku.class));
            sku3.setKyThirdPlatformCode(dto.getKyThirdPlatformCode3());
            sku3.setWmsThirdPlatformCode(StrUtil.isNotBlank((CharSequence)dto.getWmsThirdPlatformCode3()) ? dto.getWmsThirdPlatformCode3() : sku3.getCode());
            skus.add(sku3);
        }
        if (WhetherEnum.YES.getCode().equals(isTcTj)) {
            Sku sku4 = new Sku();
            BeanConvertUtil.copyProperties(sku, sku4);
            sku4.setType(SkuTypeEnums.SPECIAL_MINING_SPECIAL_OFFER.getCode());
            sku4.setCode(this.getSkuCodeByType(sku4, "04"));
            sku4.setPCode(sku3.getCode());
            sku4.setName(this.getSkuNameByType(sku.getName(), 4));
            sku4.setId(this.idSequence.generateId(Sku.class));
            sku4.setKyThirdPlatformCode(dto.getKyThirdPlatformCode4());
            sku4.setWmsThirdPlatformCode(StrUtil.isNotBlank((CharSequence)dto.getWmsThirdPlatformCode4()) ? dto.getWmsThirdPlatformCode4() : sku4.getCode());
            skus.add(sku4);
        }
        if (WhetherEnum.YES.getCode().equals(isTcTtj)) {
            Sku sku5 = new Sku();
            BeanConvertUtil.copyProperties(sku, sku5);
            sku5.setType(SkuTypeEnums.SPECIAL_MINING_SPECIAL_TWO_OFFER.getCode());
            sku5.setCode(this.getSkuCodeByType(sku5, "05"));
            sku5.setPCode(sku3.getCode());
            sku5.setName(this.getSkuNameByType(sku.getName(), 5));
            sku5.setId(this.idSequence.generateId(Sku.class));
            sku5.setKyThirdPlatformCode(dto.getKyThirdPlatformCode5());
            sku5.setWmsThirdPlatformCode(StrUtil.isNotBlank((CharSequence)dto.getWmsThirdPlatformCode5()) ? dto.getWmsThirdPlatformCode5() : sku5.getCode());
            skus.add(sku5);
        }
        String[] split = dto.getPsSpecName().split("/");
        for (Sku s : skus) {
            String[] split1;
            String barCodes;
            if (SkuSpecTypeEnums.DEFAULT.getCode().equals(spu.getSkuType())) {
                s.setSpecName(dto.getPsSpecName1());
                s.setSpecValue(dto.getPsSpecValue1());
                continue;
            }
            ArrayList specNames = Lists.newArrayList();
            ArrayList specValues = Lists.newArrayList();
            AtomicInteger atomicInteger = new AtomicInteger(0);
            for (int i = 0; i < split.length; ++i) {
                int num = atomicInteger.incrementAndGet();
                SkuSpec skuSpec = new SkuSpec();
                BeanConvertUtil.copyProperties(dto, skuSpec);
                skuSpec.setId(this.idSequence.generateId(SkuSpec.class));
                skuSpec.setPsSkuId(s.getId());
                skuSpec.setPsSpecValue((String)ReflectUtil.getFieldValue((Object)dto, (String)("psSpecValue" + num)));
                skuSpec.setPsSpecName((String)ReflectUtil.getFieldValue((Object)dto, (String)("psSpecName" + num)));
                skuSpec.setPsSpecId((Long)ReflectUtil.getFieldValue((Object)dto, (String)("psSpecId" + num)));
                skuSpec.setPsSpecValueId((Long)ReflectUtil.getFieldValue((Object)dto, (String)("psSpecValueId" + num)));
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)skuSpec);
                skuSpecList.add(skuSpec);
                specNames.add(skuSpec.getPsSpecName());
                specValues.add(skuSpec.getPsSpecValue());
            }
            s.setSpecName(CollUtil.join((Iterable)specNames, (CharSequence)"+"));
            s.setSpecValue(CollUtil.join((Iterable)specValues, (CharSequence)"-"));
            if (SkuTypeEnums.SPECIAL_OFFER.getCode().equals(s.getType())) {
                s.setSpecValue("01-" + s.getSpecValue());
            } else if (SkuTypeEnums.SPECIAL_TWO_OFFER.getCode().equals(s.getType())) {
                s.setSpecValue("02-" + s.getSpecValue());
            } else if (SkuTypeEnums.SPECIAL_MINING.getCode().equals(s.getType())) {
                s.setSpecValue("03-" + s.getSpecValue());
            } else if (SkuTypeEnums.SPECIAL_MINING_SPECIAL_OFFER.getCode().equals(s.getType())) {
                s.setSpecValue("04-" + s.getSpecValue());
            } else if (SkuTypeEnums.SPECIAL_MINING_SPECIAL_TWO_OFFER.getCode().equals(s.getType())) {
                s.setSpecValue("05-" + s.getSpecValue());
            }
            if (CharSequenceUtil.isBlank((CharSequence)dto.getSkuName())) {
                s.setName(spu.getName() + s.getSpecName());
            }
            if (!CharSequenceUtil.isNotBlank((CharSequence)(barCodes = dto.getBarCode()))) continue;
            for (String barCode : split1 = barCodes.split("/")) {
                SkuBarCode skuBarCode = new SkuBarCode();
                skuBarCode.setId(this.idSequence.generateId(SkuBarCode.class));
                skuBarCode.setPsSkuId(s.getId());
                skuBarCode.setBarCode(barCode);
                skuBarCode.setSkuType(s.getType());
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)skuBarCode);
                skuBarCodeList.add(skuBarCode);
            }
        }
        skuList.addAll(skus);
    }

    private String getSkuNameByType(String name, Integer type) {
        if (type.equals(1)) {
            name = "\u3010\u7279\u4ef7\u3011" + (String)name;
        }
        if (type.equals(2)) {
            name = "\u3010\u7279\u7279\u4ef7\u3011" + (String)name;
        }
        if (type.equals(3)) {
            name = "\u3010\u7279\u91c7\u3011" + (String)name;
        }
        if (type.equals(4)) {
            name = "\u3010\u7279\u91c7\u7279\u4ef7\u3011" + (String)name;
        }
        if (type.equals(5)) {
            name = "\u3010\u7279\u91c7\u7279\u7279\u4ef7\u3011" + (String)name;
        }
        return name;
    }

    private String getSkuCodeByType(Sku sku, String num) {
        return sku.getCode() + num;
    }

    public PsBasicsBatchVO enableSpu(SpuIdsDTO dto) {
        PsBasicsBatchVO psBasicsBatchVO;
        List spuIdList = dto.getPsSpuIds();
        List spuList = this.spuService.selectById(spuIdList);
        if (CollUtil.isEmpty((Collection)spuList)) {
            return null;
        }
        List spuArrayList = spuList.stream().filter(item -> !SpuClassifyEnums.COMPOSE.getCode().equals(item.getClassify()) && WhetherEnum.NO.getCode().equals(item.getWholesale())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(spuArrayList)) {
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)dto.getOwnerCodeList()), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isNotEmpty((Collection)(psBasicsBatchVO = this.checkSpu(spuList)).getErrorMessageList())) {
            return psBasicsBatchVO;
        }
        ArrayList<SpuOaExportDTO> spuOaExportList = new ArrayList<SpuOaExportDTO>();
        ArrayList<SpuComposeOaExportDTO> spuOaComposeExportList = new ArrayList<SpuComposeOaExportDTO>();
        ArrayList skuArrayList = CollUtil.newArrayList((Object[])new Sku[0]);
        ArrayList orgSalesmanIdList = CollUtil.newArrayList((Object[])new Long[0]);
        for (Spu spu : spuList) {
            Assert.isTrue((boolean)StatusEnums.STOP_USING.getCode().equals(spu.getStatus()), (String)(spu.getName() + "\u5546\u54c1\u975e\u5df2\u505c\u7528\u72b6\u6001"));
            Assert.isTrue((boolean)IsDeleteEnums.NO.getCode().equals(spu.getIsDelete()), (String)(spu.getName() + "\u5546\u54c1\u5df2\u5220\u9664"));
            Assert.isTrue((!CheckStatusEnums.CHECK_ADD.getCode().equals(spu.getCheckStatus()) && !CheckStatusEnums.CHECK_UPDATE.getCode().equals(spu.getCheckStatus()) && !CheckStatusEnums.CHECK_ENABLED.getCode().equals(spu.getCheckStatus()) ? 1 : 0) != 0, (String)(spu.getName() + "\u5ba1\u6838\u4e2d\u4e0d\u80fd\u542f\u7528"));
            List<ComposeSku> composeSkus = new ArrayList();
            if (SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify())) {
                composeSkus = this.composeSkuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ComposeSku::getPsSpuId, (Object)spu.getId())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
                List skuIds = composeSkus.stream().map(ComposeSku::getPsSkuId).collect(Collectors.toList());
                List skuList = this.skuService.listByIds(skuIds);
                List spuIds = skuList.stream().map(Sku::getPsSpuId).distinct().collect(Collectors.toList());
                List spus = this.spuService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(BaseDo::getId, spuIds)).eq(Spu::getStatus, (Object)StatusEnums.STOP_USING.getCode())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
                List spuNames = spus.stream().map(Spu::getName).collect(Collectors.toList());
                Assert.isTrue((boolean)CollUtil.isEmpty((Collection)spus), (String)(" \u5546\u54c1\u660e\u7ec6\u4e2d\u7684\u5546\u54c1" + spuNames.toString() + "\u5df2\u88ab\u505c\u7528,\u8bf7\u5148\u542f\u7528"));
            }
            if ((SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify())) && spu.getOrgSalesmanId() != null) {
                orgSalesmanIdList.add(spu.getOrgSalesmanId());
            }
            List<Sku> skuList = this.skuBiz.selectBySpuId(spu.getId());
            List skuIds = skuList.stream().map(BaseDo::getId).collect(Collectors.toList());
            skuArrayList.addAll(skuList);
            List skuBarCodeList = this.skuBarCodeService.selectBySkuIds(skuIds);
            this.getOaDTO(spuOaExportList, spuOaComposeExportList, skuList, spu, composeSkus, skuBarCodeList);
        }
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        List<Long> orgSalesmanIds = orgSalesmanIdList.stream().distinct().collect(Collectors.toList());
        String oaId = this.createSpuOaFlow(spuOaExportList, spuOaComposeExportList, user, orgSalesmanIds, dto.getDingDingDeptId());
        String ownerCodeList = null;
        if (CollUtil.isNotEmpty((Collection)dto.getOwnerCodeList())) {
            ownerCodeList = String.join((CharSequence)",", dto.getOwnerCodeList());
        }
        for (Spu spu : spuList) {
            spu.setOaId(oaId);
            if (WhetherEnum.NO.getCode().equals(spu.getWholesale()) && !SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) && CollUtil.isNotEmpty((Collection)dto.getOwnerCodeList())) {
                if (StrUtil.isNotBlank((CharSequence)spu.getOwnerCode()) && CollUtil.isNotEmpty((Collection)dto.getOwnerCodeList())) {
                    ArrayList<String> ownerCodes = new ArrayList<String>(Arrays.asList(spu.getOwnerCode().split(",")));
                    ownerCodes.addAll(dto.getOwnerCodeList());
                    spu.setOwnerCode(ownerCodes.stream().distinct().collect(Collectors.joining(",")));
                } else if (StrUtil.isBlank((CharSequence)spu.getOwnerCode()) && CollUtil.isNotEmpty((Collection)dto.getOwnerCodeList())) {
                    spu.setOwnerCode(ownerCodeList);
                }
            }
            spu.setCheckStatus(CheckStatusEnums.CHECK_ENABLED.getCode());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)spu);
            boolean isCompose = SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify());
            InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u542f\u7528", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u542f\u7528");
        }
        this.spuService.saveOrUpdateList(spuList);
        this.deleteRedisKeyList(skuArrayList);
        return psBasicsBatchVO;
    }

    private void getOaDTO(List<SpuOaExportDTO> spuOaExportList, List<SpuComposeOaExportDTO> spuOaComposeExportList, List<Sku> skuList, Spu spu, List<ComposeSku> composeSkuList, List<SkuBarCode> skuBarCodeList) {
        if (SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify())) {
            SpuComposeOaExportDTO spuOaExportDTO = this.covertComposeSpuOaExport(spu, composeSkuList, skuList.get(0), skuBarCodeList);
            spuOaComposeExportList.add(spuOaExportDTO);
        } else {
            SpuOaExportDTO spuOaExportDTO = this.covertSpuOaExport(spu, skuList, skuBarCodeList);
            spuOaExportList.add(spuOaExportDTO);
        }
    }

    public void disableSpu(List<Long> spuIdList) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(spuIdList), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        List spuList = this.spuService.selectById(spuIdList);
        List spuNameList = spuList.stream().filter(item -> !StatusEnums.ENABLED.getCode().equals(item.getStatus())).map(Spu::getName).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(spuNameList), (String)(String.valueOf(spuNameList) + "\u5546\u54c1\u975e\u5df2\u542f\u7528\u72b6\u6001"));
        SystemConfigVO mallSystemConfigVO = this.mdmAdapter.queryBySystemConfigKeyCode("PS_MALL_STORE_ID");
        Assert.notNull((Object)mallSystemConfigVO, (String)"\u67e5\u8be2mallFourJ\u5546\u57ce\u5e97\u94fa\u5931\u8d25");
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        List composeSpuList = this.spuService.selectComposeSpuBySpuIdList(spuIdList, null, Integer.valueOf(1));
        List enabledComposeSpuList = composeSpuList.stream().filter(item -> StatusEnums.ENABLED.getCode().equals(item.getStatus())).collect(Collectors.toList());
        spuList.addAll(enabledComposeSpuList);
        List composeIds = composeSpuList.stream().map(BaseDo::getId).collect(Collectors.toList());
        composeIds.addAll(spuIdList);
        List skuIdList = this.skuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Sku::getPsSpuId, composeIds)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE)).stream().map(BaseDo::getId).collect(Collectors.toList());
        List skuShelfList = CollUtil.newArrayList((Object[])new SkuShelf[0]);
        if (CollUtil.isNotEmpty(skuIdList)) {
            skuShelfList = this.skuShelfService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuShelf::getPsSkuId, skuIdList)).eq(SkuShelf::getShelfStatus, (Object)SkuShelfStatusEnums.ENABLED.getCode()));
        }
        ArrayList spuArrayList = CollUtil.newArrayList((Object[])new Spu[0]);
        for (Object spu : spuList) {
            Spu updateSpu = new Spu();
            updateSpu.setId(spu.getId());
            updateSpu.setStatus(StatusEnums.STOP_USING.getCode());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateSpu);
            spuArrayList.add(updateSpu);
        }
        ArrayList skuShelfArrayList = CollUtil.newArrayList((Object[])new SkuShelf[0]);
        for (SkuShelf skuShelf : skuShelfList) {
            SkuShelf updateShelf = new SkuShelf();
            updateShelf.setId(skuShelf.getId());
            updateShelf.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
            this.skuBiz.buildOnOrOffShelfInfo(skuShelf, userInfo);
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)updateShelf);
            skuShelfArrayList.add(updateShelf);
        }
        this.spuService.disableSpu((List)spuArrayList, (List)skuShelfArrayList);
        for (Spu spu : spuArrayList) {
            boolean isCompose = SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify());
            InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u505c\u7528", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u505c\u7528");
        }
        List spuIds = spuArrayList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List skuArrayList = this.skuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Sku::getPsSpuId, spuIds)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        this.deleteRedisKeyList(skuArrayList);
        List<Long> skuIdLongList = skuShelfArrayList.stream().filter(item -> ObjectUtil.equal((Object)Long.valueOf(mallSystemConfigVO.getValue()), (Object)item.getPsStoreId())).map(SkuShelf::getPsSkuId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(skuIdLongList)) {
            this.mall4jBiz.covertProdUpdateToMallFourJ(skuIdLongList);
        }
    }

    public void exportSpu(SpuQueryDTO queryDTO, HttpServletResponse response) {
        List<SpuExportDTO> spuExportDTOList = this.getQueryConditionSpus(queryDTO);
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        if (CollUtil.isEmpty(spuExportDTOList)) {
            throw new PsException(800, "\u6570\u636e\u4e3a\u7a7a,\u65e0\u9700\u5bfc\u51fa");
        }
        spuExportDTOList.forEach(item -> {
            item.setClassifyName(SpuClassifyEnums.getDescByCode((Integer)item.getClassify()));
            item.setStatusName(StatusEnums.getDescByCode((Integer)item.getStatus()));
            item.setCheckStatusName(CheckStatusEnums.getDescByCode((Integer)item.getCheckStatus()));
            item.setIsAviationBanName(WhetherEnum.getDescByCode((Integer)item.getIsAviationBan()));
            item.setMoneyTypeName(MoneyTypeEnum.getDescByCode((Integer)item.getMoneyType()));
            item.setCreateTimeStr(DateUtil.format((Date)item.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            item.setCheckTimeStr(DateUtil.format((Date)item.getCheckTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            item.setIsWholesale(WhetherEnum.getDescByCode((Integer)item.getWholesale()));
            if (StrUtil.isNotBlank((CharSequence)item.getOwnerCode())) {
                List<String> ownerCodeList = Arrays.asList(item.getOwnerCode().split(","));
                ArrayList codes = CollUtil.newArrayList((Object[])new String[0]);
                for (String s : ownerCodeList) {
                    codes.add(OwnerCodeUtil.getOwnerCodeDesc(s));
                }
                item.setOwnerCodeListName(String.join((CharSequence)",", codes));
            }
        });
        ArrayList<Map<String, Object>> map = new ArrayList();
        try {
            map = BeanUtil.objectList2ListMap(spuExportDTOList);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u8f6c\u6362spu\u5bfc\u51fa\u6570\u636e\u5931\u8d25");
        }
        List<SysTableConfigDto> sysTableConfigList = this.scAdapter.selectHabitConfig("ps_spu", user.getUserId());
        String columnTitleList = sysTableConfigList.stream().filter(item -> item.getIsDisable() == false).map(SysTableConfigDto::getColumnTitle).collect(Collectors.joining(","));
        String columnNameList = sysTableConfigList.stream().filter(item -> item.getIsDisable() == false).map(SysTableConfigDto::getColumnName).collect(Collectors.joining(","));
        String columnName = columnNameList.replaceAll("classify", "classifyName").replaceAll("status", "statusName").replaceAll("wholesale", "isWholesale").replace("checkTime", "checkTimeStr").replaceAll("wholesale", "isWholesale").replaceAll("checkStatus", "checkStatusName").replaceAll("isAviationBan", "isAviationBanName").replaceAll("moneyType", "moneyTypeName").replaceAll("createTime", "createTimeStr");
        List<ExcelExportEntity> entity = BeanUtil.setExcelExportEntity(columnTitleList.split(","), columnName.split(","));
        ExcelUtil.exportFile(response, entity, map, "\u5546\u54c1\u5217\u8868.xlsx");
    }

    public List<SpuExportDTO> getQueryConditionSpus(SpuQueryDTO queryDTO) {
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.covertQueryTag(queryDTO);
        this.skuBiz.convertBrandPermission(queryDTO);
        return this.spuService.selectExportSpu(queryDTO);
    }

    public void exportComposeSpu(SpuQueryDTO queryDTO, HttpServletResponse response) {
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        List spuExportDTOList = this.spuService.selectExportComposeSpu(queryDTO);
        if (CollUtil.isNotEmpty((Collection)spuExportDTOList)) {
            List spuIdList = spuExportDTOList.stream().map(SpuComposeExportDTO::getSpuId).collect(Collectors.toList());
            List composeSkus = this.composeSkuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(ComposeSku::getPsSpuId, spuIdList)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
            List skuIdList = composeSkus.stream().map(ComposeSku::getPsSkuId).distinct().collect(Collectors.toList());
            InteriorSkuDTO interiorSkuDTO = new InteriorSkuDTO();
            interiorSkuDTO.setSkuIdList(skuIdList);
            List<QueryInteriorSkuDTO> queryInteriorSkuDTOS = this.skuBiz.selectSkuList(interiorSkuDTO);
            for (SpuComposeExportDTO spuComposeExportDTO : spuExportDTOList) {
                List skuIds = composeSkus.stream().filter(item -> item.getPsSpuId().equals(spuComposeExportDTO.getSpuId())).map(ComposeSku::getPsSkuId).collect(Collectors.toList());
                List queryInteriorSkuDTO = queryInteriorSkuDTOS.stream().filter(item -> skuIds.contains(item.getSkuId())).collect(Collectors.toList());
                List<SpuComposeSkuExportDTO> spuComposeSkuExportDTOS = BeanConvertUtil.convertList(queryInteriorSkuDTO, SpuComposeSkuExportDTO.class);
                for (SpuComposeSkuExportDTO spuComposeSkuExportDTO : spuComposeSkuExportDTOS) {
                    composeSkus.stream().filter(item -> item.getPsSkuId().equals(spuComposeSkuExportDTO.getSkuId()) && item.getPsSpuId().equals(spuComposeExportDTO.getSpuId())).findAny().ifPresent(composeSku -> spuComposeSkuExportDTO.setComposeNumber(composeSku.getComposeNumber()));
                }
                spuComposeExportDTO.setSpuComposeSkuExportDTOS(spuComposeSkuExportDTOS);
            }
        }
        ExcelUtil.exportExcels(spuExportDTOList, "\u5546\u54c1\u4e2d\u5fc3", "\u7ec4\u5408\u5546\u54c1\u5217\u8868", SpuComposeExportDTO.class, "\u7ec4\u5408\u5546\u54c1\u5217\u8868.xlsx", response);
    }

    public void exportComposeSpuList(SpuQueryDTO queryDTO, HttpServletResponse response) {
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertQueryBarCode(queryDTO);
        this.skuBiz.convertBrandPermission(queryDTO);
        List spuExportDTOList = this.spuService.selectExportComposeSpuList(queryDTO);
        if (CollUtil.isEmpty((Collection)spuExportDTOList)) {
            throw new PsException(800, "\u6570\u636e\u4e3a\u7a7a,\u65e0\u9700\u5bfc\u51fa");
        }
        ExcelUtil.exportExcels(spuExportDTOList, "\u5546\u54c1\u4e2d\u5fc3", "\u7ec4\u5408\u5546\u54c1\u5217\u8868", ComposeExportDTO.class, "\u7ec4\u5408\u5546\u54c1\u5217\u8868.xlsx", response);
    }

    public List<String> getRecentSearchList() {
        ArrayList<String> list = new ArrayList<String>();
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        JSONObject internalPurchaseCustomer = currentLoginUserInfo.getInternalPurchaseCustomer();
        Object storeIdList = internalPurchaseCustomer.get((Object)"storeIdList");
        String key = SEARRCH_RECORDS_REDIS_KEY + currentLoginUserInfo.getCustomerCode() + ":" + String.valueOf(storeIdList) + ":" + currentLoginUserInfo.getId();
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        Set range = zSetOperations.reverseRangeWithScores((Object)key, 0L, 19L);
        if (CollUtil.isNotEmpty((Collection)range)) {
            for (ZSetOperations.TypedTuple tuple : range) {
                list.add((String)tuple.getValue());
            }
        }
        return list;
    }

    public void saveSearchRecord(String customerCode, String value) {
        String redisKey = customerCode;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.add((Object)redisKey, (Object)value, (double)System.currentTimeMillis());
        Long size = zSetOperations.size((Object)redisKey);
        if (size > 20L) {
            zSetOperations.removeRange((Object)redisKey, 0L, size - 20L - 1L);
        }
    }

    public void deleteSearchRecords(SpuDTO dto) {
        LoginUserInfo currentLoginUserInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        JSONObject internalPurchaseCustomer = currentLoginUserInfo.getInternalPurchaseCustomer();
        Object storeIdList = internalPurchaseCustomer.get((Object)"storeIdList");
        String key = SEARRCH_RECORDS_REDIS_KEY + currentLoginUserInfo.getCustomerCode() + ":" + String.valueOf(storeIdList) + ":" + currentLoginUserInfo.getId();
        if (StringUtils.isNotBlank((CharSequence)dto.getName())) {
            this.redisTemplate.opsForZSet().remove((Object)key, new Object[]{dto.getName()});
        } else {
            this.redisTemplate.delete((Object)key);
        }
    }

    public List<ShelfSpuDTO> selectShelfSpu(List<Long> spuIdList) {
        List skuList = this.skuService.selectSkuByShelf(spuIdList, null, null, SkuShelfStatusEnums.ENABLED.getCode(), null, null);
        List uniqueSku = skuList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Sku>(Comparator.comparing(Sku::getPsSpuId))), ArrayList::new));
        ArrayList<ShelfSpuDTO> shelfSpuDTOList = new ArrayList<ShelfSpuDTO>();
        for (Sku sku : uniqueSku) {
            ShelfSpuDTO shelfSpuDTO = new ShelfSpuDTO();
            Spu spu = (Spu)this.spuService.getById((Serializable)sku.getPsSpuId());
            shelfSpuDTO.setSpuCode(spu.getCode());
            shelfSpuDTO.setSpuName(spu.getName());
            shelfSpuDTOList.add(shelfSpuDTO);
        }
        return shelfSpuDTOList;
    }

    public void updateSpuCategory(List<Long> spuIdList, Long categoryId) {
        List spuList = this.spuService.selectById(spuIdList);
        Category category = this.categoryService.getByStatus(categoryId, false, StatusEnums.ENABLED.getCode());
        Assert.notNull((Object)category, (String)"\u7c7b\u76ee\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528");
        List categoryList = this.categoryService.selectByPid(category.getId());
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)categoryList), (String)"\u7c7b\u76ee\u5b58\u5728\u4e0b\u7ea7\u7c7b\u76ee");
        for (Spu spu : spuList) {
            Assert.isTrue((!CheckStatusEnums.CHECK_ADD.getCode().equals(spu.getCheckStatus()) && !CheckStatusEnums.CHECK_UPDATE.getCode().equals(spu.getCheckStatus()) && !CheckStatusEnums.CHECK_ENABLED.getCode().equals(spu.getCheckStatus()) ? 1 : 0) != 0, (String)(spu.getName() + "\u5ba1\u6838\u4e2d\u4e0d\u80fd\u4fee\u6539\u7c7b\u76ee"));
            spu.setPsCategoryId(categoryId);
            spu.setPsCategoryName(category.getName());
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)spu);
            InnerLog.addLog((Long)spu.getId(), (String)"\u66f4\u65b0\u5546\u54c1\u7c7b\u76ee", (String)InnerLogTypeEnum.SPU.getCode(), null, (String)"\u66f4\u65b0");
        }
        this.spuService.saveOrUpdateList(spuList);
    }

    public List<String> checkComposeSpu(ApiRequest<List<ComposeSpuDTO>> apiRequest) {
        List composeSpuList = (List)apiRequest.getJsonData();
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)composeSpuList), (String)"\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        List dtoList = this.spuService.selectComposeSpu(composeSpuList, Integer.valueOf(composeSpuList.size()), Long.valueOf(apiRequest.getDataId()));
        ArrayList<String> spuList = new ArrayList<String>();
        for (QueryInteriorSkuDTO skuDTO : dtoList) {
            spuList.add("\u5546\u54c1\u540d\u79f0:\u3010" + skuDTO.getSpuName() + "\u3011 \u5546\u54c1\u7f16\u7801:\u3010" + skuDTO.getSpuCode() + "\u3011<br>");
        }
        return spuList;
    }

    public void cancelSpu(ApiRequest<Void> request) {
        Assert.isTrue((request.getDataId() >= 1L ? 1 : 0) != 0, (String)"spuId\u4e0d\u80fd\u4e3a\u7a7a");
        Spu spu = (Spu)this.spuService.getById((Serializable)Long.valueOf(request.getDataId()));
        Assert.notNull((Object)spu, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)IsDeleteEnums.NO.getCode().equals(spu.getIsDelete()), (String)(spu.getName() + "\u5546\u54c1\u5df2\u5220\u9664"));
        Assert.isTrue((CheckStatusEnums.CHECK_ADD.getCode().equals(spu.getCheckStatus()) || CheckStatusEnums.CHECK_UPDATE.getCode().equals(spu.getCheckStatus()) || CheckStatusEnums.CHECK_ENABLED.getCode().equals(spu.getCheckStatus()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse apiResponse = this.oaAdapter.terminateWorkFlow(spu.getOaId(), JSON.toJSONString((Object)user));
        Assert.isTrue((boolean)apiResponse.isSuccess(), (String)apiResponse.getDesc());
        if (CheckStatusEnums.CHECK_ADD.getCode().equals(spu.getCheckStatus())) {
            spu.setCheckStatus(CheckStatusEnums.NOT_CHECK.getCode());
        } else {
            spu.setCheckStatus(CheckStatusEnums.SUCCESS.getCode());
            spu.setStatus(StatusEnums.STOP_USING.getCode());
        }
        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)spu);
        this.spuService.updateById((Object)spu);
        boolean isCompose = SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify());
        InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u64a4\u9500\u5ba1\u6279", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u5546\u54c1\u64a4\u9500\u5ba1\u6279");
    }

    public List<WmsDTO> pushWms(ApiRequest<SpuIdsDTO> apiRequest) {
        SpuIdsDTO dto = (SpuIdsDTO)apiRequest.getJsonData();
        List spuList = this.spuService.listByIds((Collection)dto.getPsSpuIds());
        List spuCodeList = spuList.stream().filter(item -> !WhetherEnum.NO.getCode().equals(item.getWholesale()) && SpuClassifyEnums.COMPOSE.getCode().equals(item.getClassify())).map(Spu::getCode).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(spuCodeList), (String)(String.valueOf(spuCodeList) + "\u4e00\u4ef6\u4ee3\u53d1\u5546\u54c1\u6216\u7ec4\u5408\u5546\u54c1\u4e0d\u53ef\u63a8\u9001wms"));
        List codeList = spuList.stream().filter(item -> StatusEnums.NOT_ENABLED.getCode().equals(item.getStatus())).map(Spu::getCode).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(codeList), (String)(String.valueOf(codeList) + "\u672a\u542f\u7528\u4e0d\u53ef\u63a8\u9001wms"));
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            for (Spu spu : spuList) {
                String lockKey = "ps:sku:push_wms:" + spu.getId();
                RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u5546\u54c1\u6b63\u5728\u88ab\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                lockKeyList.add((CallSite)((Object)lockKey));
                lockList.add(lock);
            }
            List skuList = this.skuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Sku::getPsSpuId, (Collection)dto.getPsSpuIds())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
            List skuIdList = skuList.stream().map(BaseDo::getId).collect(Collectors.toList());
            List skuBarCodeList = this.skuBarCodeService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuBarCode::getPsSkuId, skuIdList)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
            List ownerCodeList = dto.getOwnerCodeList();
            String ownerCodeArray = String.join((CharSequence)",", dto.getOwnerCodeList());
            for (Spu spu : spuList) {
                if (StrUtil.isNotBlank((CharSequence)spu.getOwnerCode())) {
                    ownerCodeList.addAll(Arrays.asList(StringUtils.split((String)spu.getOwnerCode(), (String)",")));
                    List<String> ownerCodes = Arrays.asList(spu.getOwnerCode().split(","));
                    ArrayList ownerCode = CollUtil.newArrayList((Collection)dto.getOwnerCodeList());
                    ownerCode.addAll(ownerCodes);
                    spu.setOwnerCode(ownerCode.stream().distinct().collect(Collectors.joining(",")));
                    continue;
                }
                spu.setOwnerCode(ownerCodeArray);
            }
            List<String> ownerCodes = ownerCodeList.stream().distinct().collect(Collectors.toList());
            for (Spu spu : spuList) {
                boolean isCompose = SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify());
                InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u63a8\u9001wms", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u5546\u54c1\u63a8\u9001wms");
            }
            List<WmsDTO> list = this.skuBiz.singleItemSynchronize(spuList, skuList, skuBarCodeList, ownerCodes);
            return list;
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                log.error("spu.pushWms Error:", (Throwable)e);
            }
            throw e;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    public void batchReCheck(ApiRequest<List<Long>> apiRequest) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)((Collection)apiRequest.getJsonData())), (String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        List spuList = this.spuService.listByIds((Collection)apiRequest.getJsonData());
        List codeList = spuList.stream().filter(item -> !StatusEnums.ENABLED.getCode().equals(item.getStatus())).map(Spu::getCode).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(codeList), (String)(codeList.toString() + "\u5546\u54c1\u975e\u542f\u7528\u72b6\u6001"));
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Date date = new Date();
        for (Spu spu : spuList) {
            spu.setCheckUserId(Long.valueOf(user.getUserId()));
            spu.setCheckUserName(user.getName());
            spu.setCheckTime(date);
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)spu);
        }
        this.spuService.saveOrUpdateList(spuList);
        for (Spu spu : spuList) {
            boolean isCompose = SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify());
            InnerLog.addLog((Long)spu.getId(), (String)"\u5546\u54c1\u590d\u6838", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u590d\u6838");
        }
    }

    public List<DisableHintDTO> selectDisableSpu(ApiRequest<List<Long>> apiRequest) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)((Collection)apiRequest.getJsonData())), (String)"spuId\u4e0d\u80fd\u4e3a\u7a7a");
        List spuList = this.spuService.selectComposeSpuBySpuIdList((List)apiRequest.getJsonData(), StatusEnums.ENABLED.getCode(), Integer.valueOf(0));
        ArrayList dtos = CollUtil.newArrayList((Object[])new DisableHintDTO[0]);
        for (Spu spu : spuList) {
            DisableHintDTO disableHintDTO = new DisableHintDTO();
            disableHintDTO.setSpuName(spu.getName());
            disableHintDTO.setSpuCode(spu.getCode());
            disableHintDTO.setMsg("\u5b58\u5728\u5173\u8054\u7684\u7ec4\u5408\u5546\u54c1;");
            dtos.add(disableHintDTO);
        }
        List spus = this.spuService.selectComposeShelfSpuIdList((List)apiRequest.getJsonData());
        ArrayList dtoList = CollUtil.newArrayList((Object[])new DisableHintDTO[0]);
        for (Spu spu : spus) {
            DisableHintDTO disableHintDTO = dtos.stream().filter(item -> item.getSpuCode().equals(spu.getCode())).findAny().orElse(null);
            if (disableHintDTO != null) {
                disableHintDTO.setMsg(disableHintDTO.getMsg() + "\u5b58\u5728\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u53ca\u7ec4\u5408\u5546\u54c1;");
                continue;
            }
            DisableHintDTO dto = new DisableHintDTO();
            dto.setSpuName(spu.getName());
            dto.setSpuCode(spu.getCode());
            dto.setMsg("\u5b58\u5728\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u53ca\u7ec4\u5408\u5546\u54c1;");
            dtoList.add(dto);
        }
        dtos.addAll(dtoList);
        List spuArrayList = this.spuService.selectShelfSpuIdList((List)apiRequest.getJsonData());
        ArrayList dtoArrayList = CollUtil.newArrayList((Object[])new DisableHintDTO[0]);
        for (Spu spu : spuArrayList) {
            DisableHintDTO disableHintDTO = dtos.stream().filter(item -> item.getSpuCode().equals(spu.getCode())).findAny().orElse(null);
            if (disableHintDTO != null && !disableHintDTO.getMsg().contains("\u5b58\u5728\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u53ca\u7ec4\u5408\u5546\u54c1")) {
                disableHintDTO.setMsg(disableHintDTO.getMsg() + "\u5b58\u5728\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u53ca\u7ec4\u5408\u5546\u54c1;");
                continue;
            }
            DisableHintDTO dto = new DisableHintDTO();
            dto.setSpuName(spu.getName());
            dto.setSpuCode(spu.getCode());
            dto.setMsg("\u5b58\u5728\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u53ca\u7ec4\u5408\u5546\u54c1;");
            dtoArrayList.add(dto);
        }
        dtos.addAll(dtoArrayList);
        return dtos;
    }

    public SpuDetailsDTO selectSkuListById(SpuQueryDTO queryDTO) {
        ApiRequest request;
        List idList;
        SpuQueryDTO spuQueryDTO;
        List psSkuIdList;
        List brandIdList;
        List brandList;
        SpuDetailsDTO spuDetailsDTO = new SpuDetailsDTO();
        if (StrUtil.isBlank((CharSequence)queryDTO.getSupplyPriceType())) {
            return spuDetailsDTO;
        }
        this.checkSpuParam(queryDTO);
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(user.getCustomerId());
        Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
        Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6, \u8bf7\u7a0d\u540e\u518d\u8bd5");
        List skuQtyList = queryDTO.getSkuQtyList();
        if (CollUtil.isEmpty((Collection)skuQtyList)) {
            return spuDetailsDTO;
        }
        List skuIdList = queryDTO.getSkuQtyList().stream().map(SkuQtyDTO::getSkuId).collect(Collectors.toList());
        if (CollUtil.isEmpty(skuIdList)) {
            return spuDetailsDTO;
        }
        queryDTO.setSkuIdList(skuIdList);
        List skuSubscribeDTOList = this.skuService.selectSpuSubscribeList(null, user.getCustomerId(), ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId(), null, queryDTO);
        if (CollUtil.isEmpty((Collection)skuSubscribeDTOList)) {
            return spuDetailsDTO;
        }
        Store store = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        List<Long> spuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getPsSpuId).distinct().collect(Collectors.toList());
        List<SpuPicture> spuPictureList = this.spuPictureBiz.getMainBySpuIds(spuIdList);
        List<String> imagList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
        List pictureUrlList = skuSubscribeDTOList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getPictureUrl())).map(SkuSubscribeDTO::getPictureUrl).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(pictureUrlList)) {
            imagList.addAll(pictureUrlList);
        }
        if (CollUtil.isNotEmpty((Collection)(brandList = this.brandService.listByIds(brandIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getPsBrandId).collect(Collectors.toList()))))) {
            List LogoUrlList = brandList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getLogoUrl())).map(Brand::getLogoUrl).collect(Collectors.toList());
            imagList.addAll(LogoUrlList);
        }
        String process = "image/resize,m_pad,h_" + queryDTO.getImageHigh() + ",w_" + queryDTO.getImageWide();
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedThumbUrl(imagList, process);
        Page<PhyStorageDTO> phyStorageDTOPage = null;
        if (YesOrNoEnum.YES.getCode().equals(store.getIsDisplayInventory()) && SupplyPriceTypeEnums.ONE.getCode().equals(queryDTO.getSupplyPriceType())) {
            psSkuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            idList = Arrays.stream(store.getWholesaleInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setWarehouseIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        if (YesOrNoEnum.YES.getCode().equals(store.getIsDfDisplayInventory()) && SupplyPriceTypeEnums.TWO.getCode().equals(queryDTO.getSupplyPriceType())) {
            psSkuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            idList = Arrays.stream(store.getIssuingInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setWarehouseIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        List<Long> skuIds = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
        List<ReturnGiftsVO> returnGiftsVOS = this.mcAdapter.fetchActRuleDesc(skuIds, user.getCustomerId(), null);
        List spuList = this.spuService.listByIds(spuIdList);
        BigDecimal totoUnifySupplyPrice = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        String showSkuPriceType = this.mdmAdapter.selectMdmSystemConfig("MALL_SHOW_SKU_SUPPLY_PRICE_TYPE");
        Map spuAliasMap = this.storeSpuAliasService.getAliasBySpuIds(store.getId(), spuIdList);
        String supplyPriceDigits = this.configBiz.getSupplyPriceDigits();
        for (SkuSubscribeDTO skuSubscribeDTO : skuSubscribeDTOList) {
            SkuQtyDTO qtyDTO;
            ReturnGiftsVO returnGiftsVO;
            OssUrlVO vo;
            skuSubscribeDTO.setSupplyPrice(this.configBiz.getDecimalDigits(skuSubscribeDTO.getSupplyPrice(), supplyPriceDigits));
            skuSubscribeDTO.setCounterPrice(this.configBiz.getDecimalDigits(skuSubscribeDTO.getCounterPrice(), supplyPriceDigits));
            Spu spu = spuList.stream().filter(item -> ObjectUtil.equal((Object)item.getId(), (Object)skuSubscribeDTO.getPsSpuId())).findAny().orElse(null);
            if (spu != null) {
                skuSubscribeDTO.setSpuCode(spu.getCode());
                skuSubscribeDTO.setSpuName(this.userInfoUtil.isClientAccess(user) ? spuAliasMap.getOrDefault(spu.getId(), spu.getName()) : spu.getName());
            }
            if (StrUtil.isNotBlank((CharSequence)skuSubscribeDTO.getPictureUrl())) {
                OssUrlVO vo2 = ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)skuSubscribeDTO.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null);
                if (vo2 != null) {
                    skuSubscribeDTO.setPictureUrlFull(vo2.getIntactUrl());
                }
            } else {
                SpuPicture spuPicture = spuPictureList.stream().filter(item -> ObjectUtil.equal((Object)item.getPsSpuId(), (Object)spu.getId())).findAny().orElse(null);
                if (spuPicture != null && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)spuPicture.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                    skuSubscribeDTO.setPictureUrl(vo.getIntactUrl());
                    skuSubscribeDTO.setPictureUrlFull(vo.getIntactUrl());
                }
            }
            Brand brand = brandList.stream().filter(item -> ObjectUtil.equal((Object)skuSubscribeDTO.getPsBrandId(), (Object)item.getId())).findAny().orElse(null);
            if (brand != null && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)brand.getLogoUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                skuSubscribeDTO.setPsBrandLogoUrl(brand.getLogoUrl());
                skuSubscribeDTO.setPsBrandLogoUrlFull(vo.getIntactUrl());
            }
            if (StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType())) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getSupplyPrice());
            }
            if (skuSubscribeDTO.getUnifySupplyPrice() == null) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getCounterPrice());
            }
            if (StringUtils.isEmpty((CharSequence)showSkuPriceType) || StringUtils.equalsIgnoreCase((CharSequence)showSkuPriceType, (CharSequence)"CUSTOMER_PRICE")) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getSupplyPrice());
            }
            skuSubscribeDTO.setRetailPrice(BigDecimalUtils.convert(skuSubscribeDTO.getRetailPrice(), 2));
            skuSubscribeDTO.setSupplyPrice(this.configBiz.getDecimalDigits(skuSubscribeDTO.getSupplyPrice(), supplyPriceDigits));
            skuSubscribeDTO.setCounterPrice(BigDecimalUtils.convert(skuSubscribeDTO.getCounterPrice(), 2));
            if ((YesOrNoEnum.YES.getCode().equals(store.getIsDisplayInventory()) || YesOrNoEnum.YES.getCode().equals(store.getIsDfDisplayInventory())) && phyStorageDTOPage != null) {
                BigDecimal totalQtyStorage = phyStorageDTOPage.getRecords().stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)skuSubscribeDTO.getSkuId())).map(PhyStorageDTO::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)queryDTO.getSupplyPriceType())) {
                    skuSubscribeDTO.setQtyStorage(totalQtyStorage.multiply(store.getAvailableInventoryProportion()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN));
                } else if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)queryDTO.getSupplyPriceType())) {
                    skuSubscribeDTO.setQtyStorage(totalQtyStorage.multiply(store.getDfAvailableRatio()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN));
                }
            }
            if (SupplyPriceTypeEnums.ONE.getCode().equals(queryDTO.getSupplyPriceType()) && (returnGiftsVO = (ReturnGiftsVO)returnGiftsVOS.stream().filter(item -> item.getPsSkuId().equals(skuSubscribeDTO.getSkuId())).findAny().orElse(null)) != null) {
                skuSubscribeDTO.setPromotionDesc(returnGiftsVO.getPromotionDesc());
                skuSubscribeDTO.setGroupGoodsMark(returnGiftsVO.getGroupGoodsMark());
                skuSubscribeDTO.setNewPromotionDesc(returnGiftsVO.getNewPromotionDesc());
            }
            if ((qtyDTO = (SkuQtyDTO)skuQtyList.stream().filter(item -> ObjectUtil.equal((Object)skuSubscribeDTO.getSkuId(), (Object)item.getSkuId())).findAny().orElse(null)) != null) {
                skuSubscribeDTO.setQty(qtyDTO.getQty());
                totoUnifySupplyPrice = totoUnifySupplyPrice.add(skuSubscribeDTO.getUnifySupplyPrice().multiply(new BigDecimal(qtyDTO.getQty())));
                price = price.add(skuSubscribeDTO.getSupplyPrice().multiply(new BigDecimal(qtyDTO.getQty())));
            }
            if (skuSubscribeDTO.getPackingQty() == null || !StrUtil.isNotBlank((CharSequence)skuSubscribeDTO.getPsUnitName())) continue;
            skuSubscribeDTO.setPackingQtyStr(skuSubscribeDTO.getPackingQty() + skuSubscribeDTO.getPsUnitName());
        }
        BigDecimal subtract = BigDecimalUtils.convert(totoUnifySupplyPrice, 2).subtract(BigDecimalUtils.convert(price, 2));
        spuDetailsDTO.setDiscountAmount(subtract);
        spuDetailsDTO.setSkuList(skuSubscribeDTOList);
        return spuDetailsDTO;
    }

    public void setSupplyAndSaleCompanyDetail(Store store, Map<String, FcSaleCompanyVO> saleAndSetSupplyCompany, SkuSubscribeDTO skuSubscribeDTO) {
        FcSaleCompanyVO saleCompany = saleAndSetSupplyCompany.get(skuSubscribeDTO.getSkuCode());
        if (Objects.nonNull(saleCompany)) {
            skuSubscribeDTO.setSupplyCompanyId(saleCompany.getSupplyCompanyId());
            skuSubscribeDTO.setSupplyCompanyName(saleCompany.getSupplyCompanyName());
            skuSubscribeDTO.setSaleCompanyId(saleCompany.getSaleCompanyId());
            skuSubscribeDTO.setSaleCompanyName(saleCompany.getSaleCompanyName());
        }
    }

    @Deprecated
    public Map<String, FcSaleCompanyVO> getSaleAndSetSupplyCompany(List<SkuSubscribeDTO> skuSubscribeDTOList, Long collectingCompanyId) {
        if (CollUtil.isEmpty(skuSubscribeDTOList) || Objects.isNull(collectingCompanyId)) {
            return new HashMap<String, FcSaleCompanyVO>();
        }
        Map<Long, List<SkuSubscribeDTO>> brandIdSkuMap = skuSubscribeDTOList.stream().collect(Collectors.groupingBy(SkuSubscribeDTO::getPsBrandId));
        if (CollUtil.isEmpty(brandIdSkuMap.keySet())) {
            return new HashMap<String, FcSaleCompanyVO>();
        }
        Map<Long, SgGoodsOwnerBrandItemCompanyVO> supplyCompanyMap = this.sgStorageQueryAdapter.getSupplyCompanyMap(new ArrayList<Long>(brandIdSkuMap.keySet()), collectingCompanyId);
        ArrayList<FcSaleCompanyDto> dtoList = new ArrayList<FcSaleCompanyDto>();
        for (SkuSubscribeDTO item : skuSubscribeDTOList) {
            SgGoodsOwnerBrandItemCompanyVO companyVO;
            if (item.getPsBrandId() == null || (companyVO = supplyCompanyMap.get(item.getPsBrandId())) == null) continue;
            item.setSupplyCompanyId(companyVO.getId());
            item.setSupplyCompanyName(companyVO.getCompanyName());
            this.buildQuerySaleCompanyParam(dtoList, item, companyVO);
        }
        if (CollUtil.isEmpty(dtoList)) {
            return new HashMap<String, FcSaleCompanyVO>();
        }
        List<FcSaleCompanyVO> saleCompanyList = this.fcArAdapter.getSaleCompany(dtoList);
        if (CollUtil.isEmpty(saleCompanyList)) {
            return new HashMap<String, FcSaleCompanyVO>();
        }
        return saleCompanyList.stream().filter(Objects::nonNull).collect(Collectors.toMap(FcSaleCompanyVO::getSkuCode, Function.identity(), (existing, replacement) -> existing));
    }

    private void buildQuerySaleCompanyParam(List<FcSaleCompanyDto> dtoList, SkuSubscribeDTO item, SgGoodsOwnerBrandItemCompanyVO companyVO) {
        FcSaleCompanyDto dto = new FcSaleCompanyDto();
        dto.setSkuCode(item.getSkuCode());
        dto.setSpuCode(item.getSpuCode());
        dto.setSaleAmount(item.getSupplyPrice());
        dto.setSupplyCompanyId(companyVO.getId());
        dto.setSupplyCompanyName(companyVO.getCompanyName());
        dtoList.add(dto);
    }

    public void checkSpuParam(SpuQueryDTO queryDTO) {
        Assert.notNull((Object)queryDTO.getPsStoreId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)queryDTO.getSupplyPriceType()), (String)"\u91c7\u8d2d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void checkSpuParam(MiniSpuQueryDTO queryDTO) {
        Assert.notNull((Object)queryDTO.getPsStoreId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)queryDTO.getSupplyPriceType()), (String)"\u91c7\u8d2d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void checkSpuParam(SpuQueryV2DTO queryDTO) {
        Assert.notNull((Object)queryDTO.getPsStoreId(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        if (Boolean.TRUE.equals(queryDTO.getIsFavourite())) {
            return;
        }
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)queryDTO.getSupplyPriceType()), (String)"\u91c7\u8d2d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Page<SpuSubscribeDTO> selectSpuSubscribePage(ApiRequest<SpuQueryDTO> apiRequest) {
        ApiRequest request;
        List idList;
        SpuQueryDTO spuQueryDTO;
        List psSkuIdList;
        SpuQueryDTO queryDTO = (SpuQueryDTO)apiRequest.getJsonData();
        if (StrUtil.isBlank((CharSequence)queryDTO.getSupplyPriceType())) {
            return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
        }
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        CustomerStatusVO customerStatus = this.cusAdapter.getCustomerStatus();
        Store store = (Store)this.storeService.getById((Serializable)queryDTO.getPsStoreId());
        Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        this.checkSpuParam(queryDTO);
        this.skuBiz.covertSpuName(queryDTO);
        this.skuBiz.covertChildCategory(queryDTO);
        this.skuBiz.covertQueryQtyStorage(queryDTO, store);
        Page dotPage = this.spuService.selectSpuSubscribePage(queryDTO);
        if (CollUtil.isEmpty((Collection)dotPage.getRecords())) {
            return new Page();
        }
        List<Long> spuIds = dotPage.getRecords().stream().map(SpuSubscribeDTO::getSpuId).collect(Collectors.toList());
        ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(user.getCustomerId());
        Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
        Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6, \u8bf7\u7a0d\u540e\u518d\u8bd5");
        List skuSubscribeDTOList = this.skuService.selectSpuSubscribeList(spuIds, user.getCustomerId(), ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId(), SkuShelfStatusEnums.ENABLED.getCode(), queryDTO);
        Page<PhyStorageDTO> phyStorageDTOPage = null;
        if (YesOrNoEnum.YES.getCode().equals(store.getIsDisplayInventory()) && SupplyPriceTypeEnums.ONE.getCode().equals(queryDTO.getSupplyPriceType())) {
            psSkuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            idList = Arrays.stream(store.getWholesaleInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setWarehouseIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        if (YesOrNoEnum.YES.getCode().equals(store.getIsDfDisplayInventory()) && SupplyPriceTypeEnums.TWO.getCode().equals(queryDTO.getSupplyPriceType())) {
            psSkuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            idList = Arrays.stream(store.getIssuingInventoryIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setWarehouseIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        List<Long> skuIds = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
        Integer executeMcRange = null;
        if (!StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType())) {
            executeMcRange = 1;
        }
        List<ReturnGiftsVO> returnGiftsVOS = this.mcAdapter.fetchActRuleDesc(skuIds, user.getCustomerId(), executeMcRange);
        List<SpuPicture> spuPictureList = this.spuPictureBiz.getMainBySpuIds(spuIds);
        List<String> imagList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
        List pictureUrlList = skuSubscribeDTOList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getPictureUrl())).map(SkuSubscribeDTO::getPictureUrl).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(pictureUrlList)) {
            imagList.addAll(pictureUrlList);
        }
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(imagList);
        for (SpuSubscribeDTO record : dotPage.getRecords()) {
            List skuList = skuSubscribeDTOList.stream().filter(item -> item.getPsSpuId().equals(record.getSpuId())).collect(Collectors.toList());
            SpuPicture spuPicture = spuPictureList.stream().filter(item -> item.getPsSpuId().equals(record.getSpuId())).findAny().orElse(null);
            if (spuPicture != null) {
                record.setSpuPictureUrl(spuPicture.getPictureUrl());
                OssUrlVO vo = ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)spuPicture.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null);
                if (vo != null) {
                    record.setSpuPictureUrlFull(vo.getIntactUrl());
                }
            }
            for (SkuSubscribeDTO skuSubscribeDTO : skuList) {
                ReturnGiftsVO returnGiftsVO;
                OssUrlVO vo;
                if (StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType())) {
                    skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getSupplyPrice());
                }
                if (skuSubscribeDTO.getUnifySupplyPrice() == null) {
                    skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getCounterPrice());
                }
                if (skuSubscribeDTO.getSpecValue().startsWith("TJ01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TJ01", "\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("01", "\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("TC01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TC01", "\u7279\u91c7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("03")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("03", "\u7279\u91c7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("TJ02")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TJ02", "\u7279\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("02")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("02", "\u7279\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("04")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("04", "\u7279\u91c7\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("05")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("05", "\u7279\u91c7\u7279\u7279\u4ef7"));
                }
                if ((YesOrNoEnum.YES.getCode().equals(store.getIsDisplayInventory()) || YesOrNoEnum.YES.getCode().equals(store.getIsDfDisplayInventory())) && phyStorageDTOPage != null) {
                    BigDecimal totalQtyStorage = phyStorageDTOPage.getRecords().stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)skuSubscribeDTO.getSkuId())).map(PhyStorageDTO::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)queryDTO.getSupplyPriceType())) {
                        skuSubscribeDTO.setQtyStorage(totalQtyStorage.multiply(store.getAvailableInventoryProportion()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN));
                    } else if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)queryDTO.getSupplyPriceType())) {
                        skuSubscribeDTO.setQtyStorage(totalQtyStorage.multiply(store.getDfAvailableRatio()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN));
                    }
                }
                if (StrUtil.equals((CharSequence)InventoryShowTypeEnum.TWO.getCode(), (CharSequence)store.getInventoryShowType()) && skuSubscribeDTO.getQtyStorage() != null) {
                    if (BigDecimalUtils.lessThan(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1"))) {
                        skuSubscribeDTO.setQtyStorageStr("<span style=\"color: rgba(0, 0, 0, 0.45)\">\u7f3a\u8d27</span>");
                    } else if (BigDecimalUtils.greaterEqual(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1")) && BigDecimalUtils.lessEqual(skuSubscribeDTO.getQtyStorage(), store.getInventoryNumber())) {
                        skuSubscribeDTO.setQtyStorageStr("<span style=\"color: #FA5555\">\u5e93\u5b58\u7d27\u5f20</span>");
                    } else if (BigDecimalUtils.greaterThan(skuSubscribeDTO.getQtyStorage(), store.getInventoryNumber())) {
                        skuSubscribeDTO.setQtyStorageStr("<span>\u6709\u8d27</span>");
                    }
                }
                if (StrUtil.isNotBlank((CharSequence)skuSubscribeDTO.getPictureUrl()) && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)skuSubscribeDTO.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
                    skuSubscribeDTO.setPictureUrlFull(vo.getIntactUrl());
                }
                if (SupplyPriceTypeEnums.ONE.getCode().equals(queryDTO.getSupplyPriceType()) && (returnGiftsVO = (ReturnGiftsVO)returnGiftsVOS.stream().filter(item -> item.getPsSkuId().equals(skuSubscribeDTO.getSkuId())).findAny().orElse(null)) != null) {
                    skuSubscribeDTO.setPromotionDesc(returnGiftsVO.getPromotionDesc());
                }
                skuSubscribeDTO.setRetailPrice(BigDecimalUtils.convert(skuSubscribeDTO.getRetailPrice(), 2));
                skuSubscribeDTO.setSupplyPrice(BigDecimalUtils.convert(skuSubscribeDTO.getSupplyPrice(), 2));
                skuSubscribeDTO.setCounterPrice(BigDecimalUtils.convert(skuSubscribeDTO.getCounterPrice(), 2));
                if (StrUtil.isBlank((CharSequence)skuSubscribeDTO.getPictureUrl()) && spuPicture != null) {
                    skuSubscribeDTO.setPictureUrl(spuPicture.getPictureUrl());
                    skuSubscribeDTO.setPictureUrlFull(record.getSpuPictureUrlFull());
                }
                if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store.getIsUnauthorizedPrice()) && !StrUtil.equals((CharSequence)customerStatus.getAuthenticationStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType())) {
                    skuSubscribeDTO.setSupplyPriceStr("\u8ba4\u8bc1\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                    skuSubscribeDTO.setSupplyPrice(null);
                }
                if (!StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store.getIsSignPrice()) || StrUtil.equals((CharSequence)customerStatus.getSignContractStatus(), (CharSequence)"2") || StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType())) continue;
                skuSubscribeDTO.setSupplyPriceStr("\u7b7e\u7f72\u5408\u540c\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                skuSubscribeDTO.setSupplyPrice(null);
            }
            record.setSkuList(skuList);
        }
        return dotPage;
    }

    public String getSpuAlias(Long storeId, Long spuId) {
        return this.storeSpuAliasService.getAliasBySpuId(storeId, spuId);
    }

    public SpuDetailsDTO spuDetails(ApiRequest<SpuDetailsQueryDTO> apiRequest) {
        OssUrlVO vo;
        long count;
        ApiRequest request;
        List idList;
        SpuQueryDTO spuQueryDTO;
        List psSkuIdList;
        List pictureUrlList;
        Store store;
        SpuDetailsQueryDTO dto = (SpuDetailsQueryDTO)apiRequest.getJsonData();
        if (dto.getPsStoreId() == null && (store = (Store)this.storeService.getOne((Wrapper)new QueryWrapper().lambda().eq(Store::getIsDefault, (Object)FcCommonEnum.YesOrNoStrEnum.YES.getValue()), false)) != null) {
            dto.setPsStoreId(store.getId());
        }
        SpuDetailsDTO spuDetailsDTO = new SpuDetailsDTO();
        Spu spu = (Spu)this.spuService.getById((Serializable)dto.getSpuId());
        if (spu == null) {
            spuDetailsDTO.setStatus("3");
            return spuDetailsDTO;
        }
        if (ObjectUtil.equal((Object)YesOrNoEnum.YES.getCode(), (Object)spu.getIsDelete())) {
            spuDetailsDTO.setStatus("3");
            return spuDetailsDTO;
        }
        CustomerStatusVO customerStatus = this.cusAdapter.getCustomerStatus();
        Store store2 = (Store)this.storeService.getById((Serializable)dto.getPsStoreId());
        Assert.notNull((Object)store2, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Long mdmDepartmentId = null;
        if (user.getCustomerId() != null) {
            Long brandId;
            ApiResponse<CustomerVO> customerVOApiResponse = this.cusAdapter.queryCustomerInfo(user.getCustomerId());
            Assert.isTrue((boolean)customerVOApiResponse.isSuccess(), (String)customerVOApiResponse.getDesc());
            Assert.notNull((Object)customerVOApiResponse.getContent(), (String)"\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6, \u8bf7\u7a0d\u540e\u518d\u8bd5");
            mdmDepartmentId = ((CustomerVO)customerVOApiResponse.getContent()).getMdmDepartmentId();
            CustomerOrderConfigureDetailsDTO orderConfigureDetailsDTO = new CustomerOrderConfigureDetailsDTO();
            orderConfigureDetailsDTO.setCustomerId(user.getCustomerId());
            CusCustomerOrderConfigurationVO orderConfigurationVO = this.cusAdapter.selectOrderConfigurationForQuerySku(orderConfigureDetailsDTO);
            Assert.isTrue((null != orderConfigurationVO ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5931\u8d25");
            if (null != orderConfigurationVO.getIsExcludeAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsExcludeAll())) {
                return null;
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointBrandIds()) && null == (brandId = (Long)orderConfigurationVO.getAppointBrandIds().stream().filter(a -> a.equals(spu.getPsBrandId())).findAny().orElse(null))) {
                return null;
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointSkuIds())) {
                dto.setAppointSkuIds(orderConfigurationVO.getAppointSkuIds());
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds()) && null != (brandId = (Long)orderConfigurationVO.getExcludeBrandIds().stream().filter(a -> a.equals(spu.getPsBrandId())).findAny().orElse(null))) {
                return null;
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeSkuIds())) {
                dto.setExcludeSkuIds(orderConfigurationVO.getExcludeSkuIds());
            }
        }
        SpuQueryDTO queryDTO = new SpuQueryDTO();
        queryDTO.setSupplyPriceType(dto.getSupplyPriceType());
        queryDTO.setPsStoreId(dto.getPsStoreId());
        queryDTO.setPsStoreType(Integer.valueOf(store2.getStoreType()));
        queryDTO.setSkuIdList(dto.getAppointSkuIds());
        queryDTO.setExcludeSkuIds(dto.getExcludeSkuIds());
        List skuSubscribeDTOList = this.skuService.selectSpuSubscribeList((List)CollUtil.newArrayList((Object[])new Long[]{dto.getSpuId()}), user.getCustomerId(), mdmDepartmentId, SkuShelfStatusEnums.ENABLED.getCode(), queryDTO);
        if (CollUtil.isEmpty((Collection)skuSubscribeDTOList)) {
            spuDetailsDTO.setStatus("2");
        } else {
            spuDetailsDTO.setStatus("1");
        }
        List skuIdList = this.skuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Sku::getPsSpuId, (Object)spu.getId())).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE)).stream().map(BaseDo::getId).collect(Collectors.toList());
        List skuShelfList = this.skuShelfService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SkuShelf::getPsSkuId, skuIdList)).eq(SkuShelf::getPsStoreId, (Object)dto.getPsStoreId())).eq(SkuShelf::getShelfStatus, (Object)SkuShelfStatusEnums.ENABLED.getCode()));
        List<SkuShelf> pcList = skuShelfList.stream().filter(item -> StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)item.getType())).collect(Collectors.toList());
        List<SkuShelf> dfList = skuShelfList.stream().filter(item -> StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)item.getType())).collect(Collectors.toList());
        if (CollUtil.isEmpty(pcList)) {
            spuDetailsDTO.setIsPc(Boolean.FALSE);
        }
        if (CollUtil.isEmpty(dfList)) {
            spuDetailsDTO.setIsDf(Boolean.FALSE);
        }
        if (CollUtil.isEmpty(pcList) && CollUtil.isEmpty(dfList)) {
            return spuDetailsDTO;
        }
        if (CollUtil.isEmpty(pcList) && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)dto.getSupplyPriceType())) {
            return spuDetailsDTO;
        }
        if (CollUtil.isEmpty(dfList) && StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)dto.getSupplyPriceType())) {
            return spuDetailsDTO;
        }
        List<SpuPicture> spuPictureList = this.spuPictureBiz.selectBySpuId(dto.getSpuId());
        List<SpuPictureDTO> spuPictureArrayList = BeanConvertUtil.convertList(spuPictureList, SpuPictureDTO.class);
        List<String> imagList = spuPictureList.stream().map(SpuPicture::getPictureUrl).collect(Collectors.toList());
        Brand brand = (Brand)this.brandService.getById((Serializable)spu.getPsBrandId());
        if (StrUtil.isNotBlank((CharSequence)brand.getLogoUrl())) {
            imagList.add(brand.getLogoUrl());
        }
        if (CollUtil.isNotEmpty(pictureUrlList = skuSubscribeDTOList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getPictureUrl())).map(SkuSubscribeDTO::getPictureUrl).collect(Collectors.toList()))) {
            imagList.addAll(pictureUrlList);
        }
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(imagList);
        for (SpuPictureDTO spuPictureDTO : spuPictureArrayList) {
            OssUrlVO vo2 = ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)spuPictureDTO.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null);
            if (vo2 == null) continue;
            spuPictureDTO.setPictureUrlFull(vo2.getIntactUrl());
        }
        List<Long> skuIds = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
        Integer executeMcRange = null;
        if (!StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
            executeMcRange = 1;
        }
        List<Object> returnGiftsVOS = CollUtil.newArrayList((Object[])new ReturnGiftsVO[0]);
        if (user.getCustomerId() != null) {
            returnGiftsVOS = this.mcAdapter.fetchActRuleDesc(skuIds, user.getCustomerId(), executeMcRange);
            this.checkActivityRef(dto, spuDetailsDTO, user.getCustomerId(), pcList, dfList);
        }
        Page<PhyStorageDTO> phyStorageDTOPage = null;
        if (YesOrNoEnum.YES.getCode().equals(store2.getIsDisplayInventory()) && SupplyPriceTypeEnums.ONE.getCode().equals(dto.getSupplyPriceType())) {
            psSkuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            idList = Arrays.stream(store2.getPcLogicIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setStoreIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        if (YesOrNoEnum.YES.getCode().equals(store2.getIsDfDisplayInventory()) && SupplyPriceTypeEnums.TWO.getCode().equals(dto.getSupplyPriceType())) {
            psSkuIdList = skuSubscribeDTOList.stream().map(SkuSubscribeDTO::getSkuId).collect(Collectors.toList());
            spuQueryDTO = new SpuQueryDTO();
            spuQueryDTO.setPageSize(999999);
            spuQueryDTO.setPageNum(1);
            spuQueryDTO.setSkuIdList(psSkuIdList);
            spuQueryDTO.setIsQueryStorage(Boolean.FALSE);
            idList = Arrays.stream(store2.getDfLogicIds().split(",")).map(Long::valueOf).collect(Collectors.toList());
            spuQueryDTO.setStoreIds(idList);
            request = new ApiRequest();
            request.setJsonData((Object)spuQueryDTO);
            phyStorageDTOPage = this.phyStorageBiz.queryPhyStorage((ApiRequest<SpuQueryDTO>)request);
        }
        int hotCommodityCount = 0;
        SystemConfigVO defaultMallUserId = this.mdmAdapter.queryBySystemConfigKeyCode("DEFAULT_MALL_USER_ID");
        String showSkuPriceType = this.mdmAdapter.selectMdmSystemConfig("MALL_SHOW_SKU_SUPPLY_PRICE_TYPE");
        String supplyPriceDigits = this.configBiz.getSupplyPriceDigits();
        for (SkuSubscribeDTO skuSubscribeDTO : skuSubscribeDTOList) {
            ReturnGiftsVO returnGiftsVO;
            skuSubscribeDTO.setSupplyPrice(this.configBiz.getDecimalDigits(skuSubscribeDTO.getSupplyPrice(), supplyPriceDigits));
            skuSubscribeDTO.setCounterPrice(this.configBiz.getDecimalDigits(skuSubscribeDTO.getCounterPrice(), supplyPriceDigits));
            if (YesOrNoEnum.YES.getCode().equals(skuSubscribeDTO.getHotCommodityFlag())) {
                ++hotCommodityCount;
            }
            if (StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getSupplyPrice());
            }
            if (skuSubscribeDTO.getUnifySupplyPrice() == null) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getCounterPrice());
            }
            if (StringUtils.isEmpty((CharSequence)showSkuPriceType) || StringUtils.equalsIgnoreCase((CharSequence)showSkuPriceType, (CharSequence)"CUSTOMER_PRICE")) {
                skuSubscribeDTO.setUnifySupplyPrice(skuSubscribeDTO.getSupplyPrice());
            }
            if (!StrUtil.equals((CharSequence)SkuTypeEnums.NORMAL.getCode().toString(), (CharSequence)skuSubscribeDTO.getSkuType())) {
                if (skuSubscribeDTO.getSpecValue().startsWith("TJ01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TJ01", "\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("01", "\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("TC01")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TC01", "\u7279\u91c7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("03")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("03", "\u7279\u91c7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("TJ02")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("TJ02", "\u7279\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("02")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("02", "\u7279\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("04")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("04", "\u7279\u91c7\u7279\u4ef7"));
                } else if (skuSubscribeDTO.getSpecValue().startsWith("05")) {
                    skuSubscribeDTO.setSpecValue(skuSubscribeDTO.getSpecValue().replaceFirst("05", "\u7279\u91c7\u7279\u7279\u4ef7"));
                }
            }
            skuSubscribeDTO.setRetailPrice(BigDecimalUtils.convert(skuSubscribeDTO.getRetailPrice(), 2));
            if (BigDecimalUtils.equal(skuSubscribeDTO.getRetailPrice(), new BigDecimal("0"))) {
                skuSubscribeDTO.setRetailPrice(null);
            }
            skuSubscribeDTO.setSupplyPrice(BigDecimalUtils.convert(skuSubscribeDTO.getSupplyPrice(), 2));
            skuSubscribeDTO.setCounterPrice(BigDecimalUtils.convert(skuSubscribeDTO.getCounterPrice(), 2));
            if ((YesOrNoEnum.YES.getCode().equals(store2.getIsDisplayInventory()) || YesOrNoEnum.YES.getCode().equals(store2.getIsDfDisplayInventory())) && phyStorageDTOPage != null) {
                BigDecimal totalQtyStorage = phyStorageDTOPage.getRecords().stream().filter(item -> ObjectUtil.equal((Object)item.getSkuId(), (Object)skuSubscribeDTO.getSkuId())).map(PhyStorageDTO::getQtyAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)dto.getSupplyPriceType())) {
                    skuSubscribeDTO.setQtyStorage(totalQtyStorage.multiply(store2.getAvailableInventoryProportion()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN));
                } else if (StrUtil.equals((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)dto.getSupplyPriceType())) {
                    skuSubscribeDTO.setQtyStorage(totalQtyStorage.multiply(store2.getDfAvailableRatio()).divide(new BigDecimal("100"), 0, RoundingMode.DOWN));
                }
            }
            if (StrUtil.equals((CharSequence)InventoryShowTypeEnum.TWO.getCode(), (CharSequence)store2.getInventoryShowType()) && skuSubscribeDTO.getQtyStorage() != null) {
                if (user.getLoginFrom().equals((Object)LoginFrom.xqy_mall_pc)) {
                    if (BigDecimalUtils.lessThan(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1"))) {
                        skuSubscribeDTO.setQtyStorageStr("<span style=\"color: rgba(0, 0, 0, 0.45)\">\u7f3a\u8d27</span>");
                        skuSubscribeDTO.setSkuOutOfStock(Boolean.TRUE);
                    } else if (BigDecimalUtils.greaterEqual(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1")) && BigDecimalUtils.lessEqual(skuSubscribeDTO.getQtyStorage(), store2.getInventoryNumber())) {
                        skuSubscribeDTO.setQtyStorageStr("<span style=\"color: #FA5555\">\u5e93\u5b58\u7d27\u5f20</span>");
                    } else if (BigDecimalUtils.greaterThan(skuSubscribeDTO.getQtyStorage(), store2.getInventoryNumber())) {
                        skuSubscribeDTO.setQtyStorageStr("<span>\u6709\u8d27</span>");
                    }
                } else if (BigDecimalUtils.lessThan(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1"))) {
                    skuSubscribeDTO.setQtyStorageStr("\u7f3a\u8d27");
                    skuSubscribeDTO.setSkuOutOfStock(Boolean.TRUE);
                } else if (BigDecimalUtils.greaterEqual(skuSubscribeDTO.getQtyStorage(), new BigDecimal("1")) && BigDecimalUtils.lessEqual(skuSubscribeDTO.getQtyStorage(), store2.getInventoryNumber())) {
                    skuSubscribeDTO.setQtyStorageStr("\u5e93\u5b58\u7d27\u5f20");
                } else if (BigDecimalUtils.greaterThan(skuSubscribeDTO.getQtyStorage(), store2.getInventoryNumber())) {
                    skuSubscribeDTO.setQtyStorageStr("\u6709\u8d27");
                }
            }
            if (SupplyPriceTypeEnums.ONE.getCode().equals(dto.getSupplyPriceType()) && (returnGiftsVO = (ReturnGiftsVO)returnGiftsVOS.stream().filter(item -> item.getPsSkuId().equals(skuSubscribeDTO.getSkuId())).findAny().orElse(null)) != null) {
                skuSubscribeDTO.setPromotionDesc(returnGiftsVO.getPromotionDesc());
                skuSubscribeDTO.setNewPromotionDesc(returnGiftsVO.getNewPromotionDesc());
            }
            if (StrUtil.isNotBlank((CharSequence)skuSubscribeDTO.getPictureUrl())) {
                OssUrlVO vo3 = ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)skuSubscribeDTO.getPictureUrl(), (CharSequence)item.getUrl())).findAny().orElse(null);
                if (vo3 != null) {
                    skuSubscribeDTO.setPictureUrlFull(vo3.getIntactUrl());
                }
            } else if (CollUtil.isNotEmpty(spuPictureArrayList)) {
                SpuPictureDTO spuPictureDTO = spuPictureArrayList.get(0);
                skuSubscribeDTO.setPictureUrl(spuPictureDTO.getPictureUrl());
                skuSubscribeDTO.setPictureUrlFull(spuPictureDTO.getPictureUrlFull());
            }
            if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store2.getIsUnauthorizedPrice()) && !StrUtil.equals((CharSequence)customerStatus.getAuthenticationStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
                skuSubscribeDTO.setSupplyPriceStr("\u8ba4\u8bc1\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                skuSubscribeDTO.setSupplyPrice(null);
            }
            if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store2.getIsSignPrice()) && !StrUtil.equals((CharSequence)customerStatus.getSignContractStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
                skuSubscribeDTO.setSupplyPriceStr("\u7b7e\u7f72\u5408\u540c\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                skuSubscribeDTO.setSupplyPrice(null);
            }
            if (user.getCustomerId() == null) {
                skuSubscribeDTO.setSupplyPriceStr("\u8ba4\u8bc1\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                skuSubscribeDTO.setSupplyPrice(null);
            }
            if (StrUtil.equals((CharSequence)defaultMallUserId.getValue(), (CharSequence)String.valueOf(user.getUserId()))) {
                skuSubscribeDTO.setSupplyPriceStr("\u767b\u5f55\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
                skuSubscribeDTO.setSupplyPrice(null);
            }
            if (skuSubscribeDTO.getRetailPrice() == null || BigDecimalUtils.equal(skuSubscribeDTO.getRetailPrice(), new BigDecimal("0"))) {
                skuSubscribeDTO.setRetailPrice(skuSubscribeDTO.getCounterPrice());
            }
            if (StrUtil.isBlank((CharSequence)skuSubscribeDTO.getSupplyPriceStr()) && skuSubscribeDTO.getRetailPrice() != null && skuSubscribeDTO.getUnifySupplyPrice() != null && !BigDecimalUtils.equal(skuSubscribeDTO.getRetailPrice(), new BigDecimal("0"))) {
                BigDecimal profitAmount = BigDecimalUtils.convert(skuSubscribeDTO.getRetailPrice().subtract(skuSubscribeDTO.getUnifySupplyPrice()), 2);
                skuSubscribeDTO.setProfitAmountNumber(profitAmount);
                skuSubscribeDTO.setProfitAmount("\u8d5a\u00a5" + BigDecimalUtils.thousandthCalculation(profitAmount));
                BigDecimal multiply = profitAmount.divide(skuSubscribeDTO.getRetailPrice(), 2, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                BigDecimal grossMargin = BigDecimalUtils.convert(multiply, 0);
                skuSubscribeDTO.setGrossMargin("\u6bdb\u5229\u7387" + String.valueOf(grossMargin) + "%");
                skuSubscribeDTO.setGrossMarginNumber(grossMargin);
            }
            if (skuSubscribeDTO.getPackingQty() != null && StrUtil.isNotBlank((CharSequence)skuSubscribeDTO.getPsUnitName())) {
                skuSubscribeDTO.setPackingQtyStr(skuSubscribeDTO.getPackingQty() + skuSubscribeDTO.getPsUnitName());
            }
            if (skuSubscribeDTO.getRetailPrice() == null) {
                skuSubscribeDTO.setRetailPriceStr("\u00a5" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getCounterPrice()));
                continue;
            }
            if (BigDecimalUtils.greaterThan(skuSubscribeDTO.getCounterPrice(), skuSubscribeDTO.getRetailPrice())) {
                skuSubscribeDTO.setRetailPriceStr("\u00a5" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getRetailPrice()) + "~" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getCounterPrice()));
                continue;
            }
            skuSubscribeDTO.setRetailPriceStr("\u00a5" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getCounterPrice()) + "~" + BigDecimalUtils.thousandthCalculation(skuSubscribeDTO.getRetailPrice()));
        }
        if ((StringUtils.isEmpty((CharSequence)showSkuPriceType) || StringUtils.equalsIgnoreCase((CharSequence)showSkuPriceType, (CharSequence)"CUSTOMER_PRICE")) && CollUtil.isNotEmpty((Collection)skuSubscribeDTOList)) {
            skuSubscribeDTOList.forEach(skuInfo -> skuInfo.setUnifySupplyPrice(skuInfo.getSupplyPrice()));
        }
        if (hotCommodityCount == skuSubscribeDTOList.size()) {
            spuDetailsDTO.setIsAllHotCommodityFlag(Boolean.valueOf(true));
        }
        if (ObjectUtil.equal((Object)new Long(count = skuSubscribeDTOList.stream().filter(item -> item.getSkuOutOfStock() != null && item.getSkuOutOfStock() != false).count()).intValue(), (Object)skuSubscribeDTOList.size())) {
            spuDetailsDTO.setSpuOutOfStock(Boolean.TRUE);
        }
        PsStoreSpuAlias spuAlias = this.storeSpuAliasService.getBySpuId(store2.getId(), spu.getId());
        String spuName = this.userInfoUtil.isClientAccess(user) ? (Objects.nonNull(spuAlias) ? spuAlias.getSpuAlias() : spu.getName()) : spu.getName();
        spuDetailsDTO.setId(spu.getId());
        spuDetailsDTO.setSpuName(spuName);
        spuDetailsDTO.setSpuCode(spu.getCode());
        spuDetailsDTO.setDetails(spu.getDetails());
        spuDetailsDTO.setPictureUrlList(spuPictureArrayList);
        spuDetailsDTO.setSkuList(skuSubscribeDTOList);
        spuDetailsDTO.setIsDisplayInventory(store2.getIsDisplayInventory());
        spuDetailsDTO.setIsDfDisplayInventory(store2.getIsDfDisplayInventory());
        spuDetailsDTO.setPsBrandId(brand.getId());
        spuDetailsDTO.setPsBrandName(brand.getName());
        spuDetailsDTO.setPsBrandLogoUrl(brand.getLogoUrl());
        if (StrUtil.isNotBlank((CharSequence)brand.getLogoUrl()) && (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)brand.getLogoUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) != null) {
            spuDetailsDTO.setPsBrandLogoUrlFull(vo.getIntactUrl());
        }
        spuDetailsDTO.setCountryName(brand.getCountryName());
        BigDecimal maxSupplyPrice = skuSubscribeDTOList.stream().filter(item -> item.getSupplyPrice() != null).map(SkuSubscribeDTO::getSupplyPrice).max(Comparator.comparing(x -> x)).orElse(null);
        BigDecimal minSupplyPrice = skuSubscribeDTOList.stream().filter(item -> item.getSupplyPrice() != null).map(SkuSubscribeDTO::getSupplyPrice).min(Comparator.comparing(x -> x)).orElse(null);
        spuDetailsDTO.setMaxSupplyPrice(BigDecimalUtils.convert(maxSupplyPrice, 2));
        spuDetailsDTO.setMinSupplyPrice(BigDecimalUtils.convert(minSupplyPrice, 2));
        BigDecimal maxUnifySupplyPrice = skuSubscribeDTOList.stream().filter(item -> item.getUnifySupplyPrice() != null).map(SkuSubscribeDTO::getUnifySupplyPrice).max(Comparator.comparing(x -> x)).orElse(null);
        BigDecimal minUnifySupplyPrice = skuSubscribeDTOList.stream().filter(item -> item.getUnifySupplyPrice() != null).map(SkuSubscribeDTO::getUnifySupplyPrice).min(Comparator.comparing(x -> x)).orElse(null);
        spuDetailsDTO.setMaxUnifySupplyPrice(BigDecimalUtils.convert(maxUnifySupplyPrice, 2));
        spuDetailsDTO.setMinUnifySupplyPrice(BigDecimalUtils.convert(minUnifySupplyPrice, 2));
        List retailPriceList = skuSubscribeDTOList.stream().filter(item -> item.getRetailPrice() != null).map(SkuSubscribeDTO::getRetailPrice).collect(Collectors.toList());
        List counterPriceList = skuSubscribeDTOList.stream().filter(item -> item.getCounterPrice() != null).map(SkuSubscribeDTO::getCounterPrice).collect(Collectors.toList());
        retailPriceList.addAll(counterPriceList);
        BigDecimal maxRetailPrice = retailPriceList.stream().max(Comparator.comparing(x -> x)).orElse(null);
        BigDecimal minRetailPrice = retailPriceList.stream().min(Comparator.comparing(x -> x)).orElse(null);
        spuDetailsDTO.setRetailPriceStr("\u00a5" + BigDecimalUtils.thousandthCalculation(minRetailPrice) + "~" + BigDecimalUtils.thousandthCalculation(maxRetailPrice));
        BigDecimal maxProfitAmountNumber = skuSubscribeDTOList.stream().filter(item -> item.getProfitAmountNumber() != null).map(SkuSubscribeDTO::getProfitAmountNumber).max(Comparator.comparing(x -> x)).orElse(null);
        BigDecimal minProfitAmountNumber = skuSubscribeDTOList.stream().filter(item -> item.getProfitAmountNumber() != null).map(SkuSubscribeDTO::getProfitAmountNumber).min(Comparator.comparing(x -> x)).orElse(null);
        if (maxProfitAmountNumber != null && minProfitAmountNumber != null) {
            if (BigDecimalUtils.equal(maxProfitAmountNumber, minProfitAmountNumber)) {
                spuDetailsDTO.setProfitAmount("\u8d5a\u00a5" + BigDecimalUtils.thousandthCalculation(minProfitAmountNumber));
            } else {
                spuDetailsDTO.setProfitAmount("\u8d5a\u00a5" + BigDecimalUtils.thousandthCalculation(minProfitAmountNumber) + "~" + BigDecimalUtils.thousandthCalculation(maxProfitAmountNumber));
            }
        }
        BigDecimal maxGrossMarginNumber = skuSubscribeDTOList.stream().filter(item -> item.getGrossMarginNumber() != null).map(SkuSubscribeDTO::getGrossMarginNumber).max(Comparator.comparing(x -> x)).orElse(null);
        BigDecimal minGrossMarginNumber = skuSubscribeDTOList.stream().filter(item -> item.getGrossMarginNumber() != null).map(SkuSubscribeDTO::getGrossMarginNumber).min(Comparator.comparing(x -> x)).orElse(null);
        if (maxGrossMarginNumber != null && minGrossMarginNumber != null) {
            if (BigDecimalUtils.equal(maxGrossMarginNumber, minGrossMarginNumber)) {
                spuDetailsDTO.setGrossMargin("\u6bdb\u5229\u7387" + String.valueOf(minGrossMarginNumber) + "%");
            } else {
                spuDetailsDTO.setGrossMargin("\u6bdb\u5229\u7387" + String.valueOf(minGrossMarginNumber) + "%~" + String.valueOf(maxGrossMarginNumber) + "%");
            }
        }
        if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store2.getIsUnauthorizedPrice()) && !StrUtil.equals((CharSequence)customerStatus.getAuthenticationStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
            spuDetailsDTO.setSupplyPriceStr("\u8ba4\u8bc1\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
            spuDetailsDTO.setMaxSupplyPrice(null);
            spuDetailsDTO.setMinSupplyPrice(null);
        }
        if (user.getCustomerId() == null) {
            spuDetailsDTO.setSupplyPriceStr("\u8ba4\u8bc1\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
            spuDetailsDTO.setMaxSupplyPrice(null);
            spuDetailsDTO.setMinSupplyPrice(null);
        }
        if (StrUtil.equals((CharSequence)YesOrNoEnum.NO.getCode(), (CharSequence)store2.getIsSignPrice()) && !StrUtil.equals((CharSequence)customerStatus.getSignContractStatus(), (CharSequence)"2") && !StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store2.getStoreType())) {
            spuDetailsDTO.setSupplyPriceStr("\u7b7e\u7f72\u5408\u540c\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
            spuDetailsDTO.setMaxSupplyPrice(null);
            spuDetailsDTO.setMinSupplyPrice(null);
        }
        if (StrUtil.equals((CharSequence)defaultMallUserId.getValue(), (CharSequence)String.valueOf(user.getUserId()))) {
            spuDetailsDTO.setSupplyPriceStr("\u767b\u5f55\u540e\u53ef\u67e5\u770b\u4ef7\u683c");
            spuDetailsDTO.setMaxSupplyPrice(null);
            spuDetailsDTO.setMinSupplyPrice(null);
        }
        BigDecimal totalQtyStorage = skuSubscribeDTOList.stream().filter(s -> s.getQtyStorage() != null).map(SkuSubscribeDTO::getQtyStorage).reduce(BigDecimal.ZERO, BigDecimal::add);
        spuDetailsDTO.setTotalQtyStorage(totalQtyStorage);
        List<SpuAttributeMiniDTO> spuAttributeDTOList = this.spuAttributeBiz.selectAttributeList(spu, skuSubscribeDTOList);
        spuDetailsDTO.setSpuAttributeList(spuAttributeDTOList);
        if (StrUtil.equals((CharSequence)InventoryShowTypeEnum.TWO.getCode(), (CharSequence)store2.getInventoryShowType())) {
            if (user.getLoginFrom().equals((Object)LoginFrom.xqy_mall_pc)) {
                if (BigDecimalUtils.lessThan(totalQtyStorage, new BigDecimal("1"))) {
                    spuDetailsDTO.setTotalQtyStorageStr("<span style=\"color: rgba(0, 0, 0, 0.45)\">\u7f3a\u8d27</span>");
                } else if (BigDecimalUtils.greaterEqual(totalQtyStorage, new BigDecimal("1")) && BigDecimalUtils.lessEqual(totalQtyStorage, store2.getInventoryNumber())) {
                    spuDetailsDTO.setTotalQtyStorageStr("<span style=\"color: #FA5555\">\u5e93\u5b58\u7d27\u5f20</span>");
                } else if (BigDecimalUtils.greaterThan(totalQtyStorage, store2.getInventoryNumber())) {
                    spuDetailsDTO.setTotalQtyStorageStr("<span>\u6709\u8d27</span>");
                }
            } else if (BigDecimalUtils.lessThan(totalQtyStorage, new BigDecimal("1"))) {
                spuDetailsDTO.setTotalQtyStorageStr("\u7f3a\u8d27");
            } else if (BigDecimalUtils.greaterEqual(totalQtyStorage, new BigDecimal("1")) && BigDecimalUtils.lessEqual(totalQtyStorage, store2.getInventoryNumber())) {
                spuDetailsDTO.setTotalQtyStorageStr("\u5e93\u5b58\u7d27\u5f20");
            } else if (BigDecimalUtils.greaterThan(totalQtyStorage, store2.getInventoryNumber())) {
                spuDetailsDTO.setTotalQtyStorageStr("\u6709\u8d27");
            }
        }
        spuDetailsDTO.setIsFavourite(Boolean.valueOf(this.psFavoriteBiz.spuIsFavourited(dto.getPsStoreId(), user.getUserId(), spu.getId())));
        return spuDetailsDTO;
    }

    private void checkActivityRef(SpuDetailsQueryDTO dto, SpuDetailsDTO spuDetailsDTO, Long customerId, List<SkuShelf> pcList, List<SkuShelf> dfList) {
        McSkuVO mcSkuVO;
        ArrayList<Long> checkActivitySkuIdList = new ArrayList<Long>();
        if (StringUtils.equalsIgnoreCase((CharSequence)SupplyPriceTypeEnums.ONE.getCode(), (CharSequence)dto.getSupplyPriceType())) {
            checkActivitySkuIdList.addAll(pcList.stream().map(SkuShelf::getPsSkuId).collect(Collectors.toList()));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SupplyPriceTypeEnums.TWO.getCode(), (CharSequence)dto.getSupplyPriceType())) {
            checkActivitySkuIdList.addAll(dfList.stream().map(SkuShelf::getPsSkuId).collect(Collectors.toList()));
        }
        if (CollUtil.isNotEmpty(checkActivitySkuIdList) && Objects.nonNull(mcSkuVO = this.mcAdapter.queryActivityRef(customerId, checkActivitySkuIdList))) {
            List activitySkuIdList = mcSkuVO.getActivitySkuIdList();
            List groupActivitySkuIdList = mcSkuVO.getGroupActivitySkuIdList();
            if (CollUtil.isNotEmpty((Collection)activitySkuIdList)) {
                spuDetailsDTO.setIsHaveActivity(Boolean.valueOf(true));
            }
            if (CollUtil.isNotEmpty((Collection)groupActivitySkuIdList)) {
                spuDetailsDTO.setIsHaveGroupActivity(Boolean.valueOf(true));
            }
        }
    }

    public List<BrandSubscribeDTO> selectBrandSubscribeList(ApiRequest<SpuQueryV2DTO> apiRequest) {
        List list;
        SpuQueryV2DTO dto = (SpuQueryV2DTO)apiRequest.getJsonData();
        SpuQueryDTO spuQueryDTO = new SpuQueryDTO();
        BeanUtils.copyProperties((Object)dto, (Object)spuQueryDTO);
        this.skuBiz.covertSpuName(spuQueryDTO);
        if (StrUtil.isBlank((CharSequence)spuQueryDTO.getSupplyPriceType()) && !Boolean.TRUE.equals(dto.getIsFavourite())) {
            return CollUtil.newArrayList((Object[])new BrandSubscribeDTO[0]);
        }
        Store store = (Store)this.storeService.getById((Serializable)spuQueryDTO.getPsStoreId());
        this.skuBiz.covertQueryQtyStorage(spuQueryDTO, store);
        this.skuBiz.covertChildCategory(spuQueryDTO);
        this.psFavoriteBiz.handleFavorite(dto);
        if (Boolean.TRUE.equals(dto.getIsFavourite())) {
            LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            String permission = this.storeBiz.getPermission(user.getLoginFrom().toString());
            String[] permissions = permission.split(",");
            if (permissions.length > 1) {
                dto.setIsAllPermission(Boolean.valueOf(true));
            } else {
                spuQueryDTO.setSupplyPriceType(permission);
                dto.setSupplyPriceType(permission);
                dto.setIsAllPermission(Boolean.valueOf(false));
            }
            List brandSubscribeDTOS = new ArrayList();
            if (!SkuShelfStatusEnums.STOP_USING.getCode().equals(dto.getShelfStatus()) && !SkuShelfStatusEnums.ENABLED.getCode().equals(dto.getShelfStatus())) {
                dto.setShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
                spuQueryDTO.setShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
                brandSubscribeDTOS = this.spuService.selectFavBrandSubscribeList(dto, spuQueryDTO, Integer.valueOf(1), this.userInfoUtil.isClientAccess(user));
                dto.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                spuQueryDTO.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                brandSubscribeDTOS.addAll(this.spuService.selectFavBrandSubscribeList(dto, spuQueryDTO, Integer.valueOf(1), this.userInfoUtil.isClientAccess(user)));
                if (CollUtil.isEmpty(brandSubscribeDTOS)) {
                    List list2 = brandSubscribeDTOS;
                }
                Map<Long, Long> brandIdQtyMap = brandSubscribeDTOS.stream().collect(Collectors.groupingBy(BrandSubscribeDTO::getBrandId, Collectors.summingLong(BrandSubscribeDTO::getQty)));
                list = brandSubscribeDTOS.stream().collect(Collectors.groupingBy(BrandSubscribeDTO::getBrandId)).entrySet().stream().map(entry -> {
                    BrandSubscribeDTO brandSubscribeDTO = (BrandSubscribeDTO)((List)entry.getValue()).get(0);
                    brandSubscribeDTO.setQty((Long)brandIdQtyMap.get(entry.getKey()));
                    return brandSubscribeDTO;
                }).collect(Collectors.toList());
            } else {
                list = this.spuService.selectFavBrandSubscribeList(dto, spuQueryDTO, Integer.valueOf(1), this.userInfoUtil.isClientAccess(user));
            }
        } else {
            list = this.spuService.selectBrandSubscribeList(dto, spuQueryDTO, Integer.valueOf(1));
        }
        return this.brandSort(spuQueryDTO.getPsStoreId(), list);
    }

    private void covertUrl(List<BrandSubscribeDTO> list) {
        List<String> imagList = list.stream().map(BrandSubscribeDTO::getLogoUrl).collect(Collectors.toList());
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(imagList);
        if (CollUtil.isEmpty(ossUrlVOS)) {
            return;
        }
        for (BrandSubscribeDTO record : list) {
            OssUrlVO vo;
            if (!StrUtil.isNotBlank((CharSequence)record.getLogoUrl()) || (vo = (OssUrlVO)ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)record.getLogoUrl(), (CharSequence)item.getUrl())).findAny().orElse(null)) == null) continue;
            record.setLogoUrlFull(vo.getIntactUrl());
        }
    }

    public List<BrandSubscribeDTO> brandSort(Long storeId, List<BrandSubscribeDTO> list) {
        List notRepeatList;
        ArrayList resultList = Lists.newArrayList();
        List storeBrandSortList = this.storeBrandSortService.selectSortByStoreId(storeId);
        if (CollectionUtils.isNotEmpty((Collection)storeBrandSortList)) {
            List<StoreBrandSortDTO> sortDTOList = storeBrandSortList.stream().sorted(Comparator.comparing(StoreBrandSortDTO::getSortNo).thenComparing(StoreBrandSortDTO::getFirstLetter)).collect(Collectors.toList());
            sortDTOList.forEach(item -> {
                List tempList = list.stream().filter(one -> one.getBrandId().equals(item.getPsBrandId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(tempList)) {
                    resultList.addAll(tempList);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(notRepeatList = list.stream().filter(first -> storeBrandSortList.stream().noneMatch(second -> first.getBrandId().equals(second.getPsBrandId()))).collect(Collectors.toList()))) {
            resultList.addAll(notRepeatList.stream().sorted(Comparator.comparing(BrandSubscribeDTO::getFirstLetter)).collect(Collectors.toList()));
        }
        return resultList;
    }

    public BrandSubscribeForLiteAppVO selectBrandSubscribeListForLiteApp(ApiRequest<SpuQueryDTO> apiRequest) {
        BrandSubscribeForLiteAppVO vo = new BrandSubscribeForLiteAppVO();
        SpuQueryDTO spuQueryDTO = (SpuQueryDTO)apiRequest.getJsonData();
        this.skuBiz.covertSpuName(spuQueryDTO);
        Store store = (Store)this.storeService.getById((Serializable)spuQueryDTO.getPsStoreId());
        this.skuBiz.covertQueryQtyStorage(spuQueryDTO, store);
        this.skuBiz.covertChildCategory(spuQueryDTO);
        List dto = this.spuService.selectBrandSubscribeList(new SpuQueryV2DTO(), spuQueryDTO, Integer.valueOf(1));
        if (CollUtil.isNotEmpty((Collection)dto)) {
            ArrayList<BrandSubscribeVO> brandSubscribeVOS = new ArrayList<BrandSubscribeVO>();
            List brandIds = dto.stream().map(BrandSubscribeDTO::getBrandId).collect(Collectors.toList());
            List brandList = this.brandService.listByIds(brandIds);
            for (Brand brand : brandList) {
                BrandSubscribeVO subscribeVO = new BrandSubscribeVO();
                subscribeVO.setBrandId(brand.getId());
                subscribeVO.setBrandName(brand.getName());
                subscribeVO.setEnglishName(brand.getEnglishName());
                subscribeVO.setLogoUrl(brand.getLogoUrl());
                brandSubscribeVOS.add(subscribeVO);
            }
            List<String> imagList = brandSubscribeVOS.stream().map(BrandSubscribeVO::getLogoUrl).collect(Collectors.toList());
            List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedUrl(imagList);
            for (BrandSubscribeVO subscribeVO : brandSubscribeVOS) {
                OssUrlVO ossUrlVO = ossUrlVOS.stream().filter(item -> StrUtil.equals((CharSequence)subscribeVO.getLogoUrl(), (CharSequence)item.getUrl())).findAny().orElse(null);
                if (ossUrlVO == null) continue;
                subscribeVO.setLogoUrlFull(ossUrlVO.getIntactUrl());
            }
            this.getBrandStartingLetter(brandSubscribeVOS);
            brandSubscribeVOS.sort(Comparator.comparing(BrandSubscribeVO::getLetters));
            Set existingFirstLetters = brandSubscribeVOS.stream().map(BrandSubscribeVO::getLetters).collect(Collectors.toSet());
            List<String> allLetters = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
            List sortedExistingFirstLetters = allLetters.stream().filter(existingFirstLetters::contains).collect(Collectors.toList());
            vo.setLetters(sortedExistingFirstLetters);
            vo.setSubscribeVOS(brandSubscribeVOS);
        }
        return vo;
    }

    private void getBrandStartingLetter(List<BrandSubscribeVO> brands) {
        for (BrandSubscribeVO vo : brands) {
            vo.setLetters(PinyinUtil.getFirstLetter((String)vo.getBrandName(), (String)"").substring(0, 1).toUpperCase());
        }
    }

    public List<BrandSubscribeDTO> selectCountrySubscribeList(ApiRequest<SpuQueryDTO> apiRequest) {
        SpuQueryDTO spuQueryDTO = (SpuQueryDTO)apiRequest.getJsonData();
        this.skuBiz.covertSpuName(spuQueryDTO);
        if (StrUtil.isBlank((CharSequence)spuQueryDTO.getSupplyPriceType())) {
            return CollUtil.newArrayList((Object[])new BrandSubscribeDTO[0]);
        }
        this.skuBiz.covertChildCategory(spuQueryDTO);
        Store store = (Store)this.storeService.getById((Serializable)spuQueryDTO.getPsStoreId());
        this.skuBiz.covertQueryQtyStorage(spuQueryDTO, store);
        List<BrandSubscribeDTO> dtoList = this.spuService.selectBrandSubscribeList(new SpuQueryV2DTO(), spuQueryDTO, Integer.valueOf(2));
        if (CollUtil.isEmpty((Collection)dtoList)) {
            return dtoList;
        }
        List brandIdList = dtoList.stream().map(BrandSubscribeDTO::getBrandId).distinct().collect(Collectors.toList());
        List brandList = this.brandService.listByIds(brandIdList);
        for (BrandSubscribeDTO brandSubscribeDTO : dtoList) {
            brandList.stream().filter(item -> ObjectUtil.equal((Object)brandSubscribeDTO.getBrandId(), (Object)item.getId())).findAny().ifPresent(brand -> brandSubscribeDTO.setCountryName(brand.getCountryName()));
        }
        dtoList = this.brandCountrySort(spuQueryDTO.getPsStoreId(), dtoList);
        return dtoList;
    }

    public List<BrandSubscribeDTO> brandCountrySort(Long storeId, List<BrandSubscribeDTO> list) {
        List notRepeatList;
        ArrayList resultList = Lists.newArrayList();
        List storeCountrySortList = this.storeCountrySortService.selectSortByStoreId(storeId);
        if (CollectionUtils.isNotEmpty((Collection)storeCountrySortList)) {
            List<StoreCountrySortDTO> sortList = storeCountrySortList.stream().sorted(Comparator.comparing(StoreCountrySortDTO::getSortNo).thenComparing(StoreCountrySortDTO::getCountryFirstLetter)).collect(Collectors.toList());
            sortList.forEach(item -> {
                List tempList = list.stream().filter(one -> one.getCountryId().equals(item.getCountryId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(tempList)) {
                    resultList.addAll(tempList);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(notRepeatList = list.stream().filter(first -> storeCountrySortList.stream().noneMatch(second -> first.getCountryId().equals(second.getCountryId()))).collect(Collectors.toList()))) {
            resultList.addAll(notRepeatList.stream().sorted(Comparator.comparing(BrandSubscribeDTO::getFirstLetter)).collect(Collectors.toList()));
        }
        return resultList;
    }

    public List<CategorySubscribeDTO> selectCategoryList(ApiRequest<SpuQueryV2DTO> apiRequest) {
        SpuQueryV2DTO v2DTO = (SpuQueryV2DTO)apiRequest.getJsonData();
        SpuQueryDTO spuQueryDTO = new SpuQueryDTO();
        BeanUtils.copyProperties((Object)v2DTO, (Object)spuQueryDTO);
        this.skuBiz.covertSpuName(spuQueryDTO);
        if (StrUtil.isBlank((CharSequence)spuQueryDTO.getSupplyPriceType()) && !Boolean.TRUE.equals(v2DTO.getIsFavourite())) {
            return CollUtil.newArrayList((Object[])new CategorySubscribeDTO[0]);
        }
        this.skuBiz.covertChildCategory(spuQueryDTO);
        Store store = (Store)this.storeService.getById((Serializable)spuQueryDTO.getPsStoreId());
        this.skuBiz.covertQueryQtyStorage(spuQueryDTO, store);
        this.psFavoriteBiz.handleFavorite(v2DTO);
        List<Object> lastCategoryList = new ArrayList();
        if (Boolean.TRUE.equals(v2DTO.getIsFavourite())) {
            LoginUserInfo user = this.gateWayWebAuthService.getCurrentLoginUserInfo();
            String permission = this.storeBiz.getPermission(user.getLoginFrom().toString());
            String[] permissions = permission.split(",");
            if (permissions.length > 1) {
                v2DTO.setIsAllPermission(Boolean.valueOf(true));
            } else {
                spuQueryDTO.setSupplyPriceType(permission);
                v2DTO.setSupplyPriceType(permission);
                v2DTO.setIsAllPermission(Boolean.valueOf(false));
            }
            List<CategorySubscribeDTO> lastCategoryDtoList = new ArrayList();
            if (!SkuShelfStatusEnums.STOP_USING.getCode().equals(v2DTO.getShelfStatus()) && !SkuShelfStatusEnums.ENABLED.getCode().equals(v2DTO.getShelfStatus())) {
                v2DTO.setShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
                spuQueryDTO.setShelfStatus(SkuShelfStatusEnums.ENABLED.getCode());
                lastCategoryDtoList = this.spuService.selectFavCategorySubscribeList(v2DTO, spuQueryDTO);
                v2DTO.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                spuQueryDTO.setShelfStatus(SkuShelfStatusEnums.STOP_USING.getCode());
                lastCategoryDtoList.addAll(this.spuService.selectFavCategorySubscribeList(v2DTO, spuQueryDTO));
                if (CollUtil.isEmpty(lastCategoryDtoList)) {
                    return lastCategoryDtoList;
                }
                Map<Long, Integer> categoryIdQtyMap = lastCategoryDtoList.stream().collect(Collectors.groupingBy(CategorySubscribeDTO::getCategoryId, Collectors.summingInt(CategorySubscribeDTO::getQty)));
                lastCategoryList = lastCategoryDtoList.stream().collect(Collectors.groupingBy(CategorySubscribeDTO::getCategoryId)).entrySet().stream().map(entry -> {
                    CategorySubscribeDTO categorySubscribeDTO = (CategorySubscribeDTO)((List)entry.getValue()).get(0);
                    categorySubscribeDTO.setQty((Integer)categoryIdQtyMap.get(entry.getKey()));
                    return categorySubscribeDTO;
                }).collect(Collectors.toList());
            } else {
                lastCategoryList = this.spuService.selectFavCategorySubscribeList(v2DTO, spuQueryDTO);
            }
        } else {
            lastCategoryList = this.spuService.selectCategorySubscribeList(v2DTO, spuQueryDTO);
        }
        Map<Long, Integer> threeCategoryQtyMap = lastCategoryList.stream().filter(one -> one.getLevel().equals(4)).collect(Collectors.toMap(CategorySubscribeDTO::getPid, el -> 1, Integer::sum));
        List threeCategoryIdList = lastCategoryList.stream().filter(one -> one.getLevel().equals(4)).map(CategorySubscribeDTO::getPid).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(threeCategoryIdList)) {
            List threeCategoryList = this.categoryService.listByIds(threeCategoryIdList);
            for (int i = 0; i < threeCategoryList.size(); ++i) {
                Category category = (Category)threeCategoryList.get(i);
                CategorySubscribeDTO dto = new CategorySubscribeDTO();
                dto.setCategoryId(category.getId());
                dto.setCategoryName(category.getName());
                if (threeCategoryQtyMap.containsKey(category.getId())) {
                    dto.setQty(threeCategoryQtyMap.get(category.getId()));
                }
                dto.setLevel(category.getLevel());
                lastCategoryList.add(dto);
            }
        }
        lastCategoryList = lastCategoryList.stream().filter(one -> !one.getLevel().equals(4)).sorted(Comparator.comparing(CategorySubscribeDTO::getQty).reversed()).collect(Collectors.toList());
        return lastCategoryList;
    }

    public Boolean selectCategoryExists(long dataId, SpuQueryDTO queryDTO) {
        Long psStoreId = queryDTO != null && queryDTO.getPsStoreId() != null ? queryDTO.getPsStoreId() : 0L;
        Set<Long> longs = this.categoryBiz.selectParentCategoryId(null, CollUtil.newArrayList((Object[])new Long[]{dataId}), psStoreId);
        ArrayList categoryList = CollUtil.newArrayList(longs);
        List spuList = this.spuService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(Spu::getPsCategoryId, (Collection)categoryList)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
        if (CollUtil.isNotEmpty((Collection)spuList)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void updateSpuDetails(ApiRequest<UpdateDetailsDTO> apiRequest) {
        UpdateDetailsDTO dto = (UpdateDetailsDTO)apiRequest.getJsonData();
        Spu spu = (Spu)this.spuService.getById((Serializable)dto.getSpuId());
        Assert.notNull((Object)spu, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        spu.setDetails(dto.getDetails());
        List<SpuPicture> spuPictureList = this.spuPictureBiz.convert(dto.getSpuPictureList(), dto.getSpuId());
        ArrayList skuLists = CollUtil.newArrayList((Object[])new Sku[0]);
        if (CollUtil.isNotEmpty((Collection)dto.getSkuList())) {
            List skuIdList = dto.getSkuList().stream().map(SkuLogoDTO::getSkuId).collect(Collectors.toList());
            List skuList = this.skuService.listByIds(skuIdList);
            for (SkuLogoDTO skuLogoDTO : dto.getSkuList()) {
                Sku sku = skuList.stream().filter(item -> ObjectUtil.equal((Object)skuLogoDTO.getSkuId(), (Object)item.getId())).findAny().orElse(null);
                if (sku == null) continue;
                sku.setPictureUrl(skuLogoDTO.getPictureUrl());
                sku.setRetailPrice(skuLogoDTO.getRetailPrice());
                sku.setCostPrice(skuLogoDTO.getCostPrice());
                sku.setCustomerPrice(skuLogoDTO.getCustomerPrice());
                skuLists.add(sku);
            }
        }
        this.spuService.updateSpuDetails(spu, spuPictureList, (List)skuLists);
        boolean isCompose = SpuClassifyEnums.COMPOSE.getCode().equals(spu.getClassify()) || SpuClassifyEnums.PACK.getCode().equals(spu.getClassify());
        InnerLog.addLog((Long)spu.getId(), (String)"\u7f16\u8f91\u56fe\u6587\u8be6\u60c5", (String)(isCompose ? InnerLogTypeEnum.COMPOSE_SPU.getCode() : InnerLogTypeEnum.SPU.getCode()), null, (String)"\u7f16\u8f91\u56fe\u6587\u8be6\u60c5");
    }

    public Page<BrandSubscribeDTO> selectBrandSubscribePage(ApiRequest<SpuQueryV2DTO> apiRequest) {
        SpuQueryV2DTO dto = (SpuQueryV2DTO)apiRequest.getJsonData();
        SpuQueryDTO spuQueryDTO = new SpuQueryDTO();
        BeanUtils.copyProperties((Object)dto, (Object)spuQueryDTO);
        this.skuBiz.covertSpuName(spuQueryDTO);
        if (StrUtil.isBlank((CharSequence)spuQueryDTO.getSupplyPriceType()) && !Boolean.TRUE.equals(dto.getIsFavourite())) {
            return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
        }
        Store store = (Store)this.storeService.getById((Serializable)spuQueryDTO.getPsStoreId());
        this.skuBiz.covertQueryQtyStorage(spuQueryDTO, store);
        this.skuBiz.covertChildCategory(spuQueryDTO);
        Page page = this.spuService.selectBrandSubscribePage(dto, spuQueryDTO);
        List records = page.getRecords();
        this.covertUrl(records);
        this.brandSort(spuQueryDTO.getPsStoreId(), records);
        return page;
    }

    public Page<BrandSubscribeDTO> selectBrandSubscribePageOrderById(ApiRequest<SpuQueryV2DTO> apiRequest) {
        SpuQueryV2DTO queryDTO = (SpuQueryV2DTO)apiRequest.getJsonData();
        SpuQueryV2DTO condition = new SpuQueryV2DTO();
        List skuIdList = queryDTO.getSkuIdList();
        Page<BrandSubscribeDTO> brandIdPage = new Page<BrandSubscribeDTO>();
        Page<BrandSubscribeDTO> conditionPage = new Page<BrandSubscribeDTO>();
        if (CollUtil.isNotEmpty((Collection)skuIdList)) {
            condition.setSkuIdList(skuIdList);
            condition.setSupplyPriceType(queryDTO.getSupplyPriceType());
            condition.setPsStoreId(queryDTO.getPsStoreId());
            condition.setPageNum(queryDTO.getPageNum());
            condition.setPageSize(queryDTO.getPageSize());
            ApiRequest conditionApiDto = new ApiRequest();
            conditionApiDto.setJsonData((Object)condition);
            brandIdPage = this.selectBrandSubscribePage((ApiRequest<SpuQueryV2DTO>)conditionApiDto);
        }
        if (CollUtil.isNotEmpty((Collection)queryDTO.getPsCategoryIdList()) || CollUtil.isNotEmpty((Collection)queryDTO.getBrandIds()) || StringUtils.isNotEmpty((CharSequence)queryDTO.getCondition())) {
            queryDTO.setSkuIdList(null);
            conditionPage = this.selectBrandSubscribePage(apiRequest);
        }
        if (CollUtil.isEmpty((Collection)conditionPage.getRecords())) {
            return brandIdPage;
        }
        if (CollUtil.isEmpty((Collection)brandIdPage.getRecords())) {
            return conditionPage;
        }
        List brandRecords = brandIdPage.getRecords();
        List conditionRecords = conditionPage.getRecords();
        if (CollUtil.isNotEmpty((Collection)brandRecords)) {
            for (int i = 0; i < conditionRecords.size(); ++i) {
                if (i >= brandRecords.size()) continue;
                BrandSubscribeDTO skuIdDTO = (BrandSubscribeDTO)brandRecords.get(i);
                conditionRecords.set(i, skuIdDTO);
            }
        }
        return conditionPage;
    }

    public Page<BrandSubscribeDTO> selectBrandSubscribePageRenovation(ApiRequest<SpuQueryV2DTO> apiRequest) {
        SpuQueryV2DTO queryDTO = (SpuQueryV2DTO)apiRequest.getJsonData();
        List skuIdSerialNoDTOS = queryDTO.getBrandIdSerialNoDTOS();
        if (CollUtil.isEmpty((Collection)skuIdSerialNoDTOS)) {
            return new Page((long)queryDTO.getPageNum(), (long)queryDTO.getPageSize());
        }
        List brandIds = skuIdSerialNoDTOS.stream().map(PsBrandIdSerialNoDTO::getBrandId).collect(Collectors.toList());
        int size = brandIds.size();
        int pageNum = queryDTO.getPageNum();
        int pageSize = queryDTO.getPageSize();
        queryDTO.setPageNum(1);
        queryDTO.setPageSize(size);
        queryDTO.setBrandIds(brandIds);
        Page<BrandSubscribeDTO> page = this.selectBrandSubscribePage(apiRequest);
        List records = page.getRecords();
        records.sort((dto1, dto2) -> {
            PsBrandIdSerialNoDTO inputDto1 = skuIdSerialNoDTOS.stream().filter(i -> i.getBrandId().equals(dto1.getBrandId())).findFirst().orElse(null);
            PsBrandIdSerialNoDTO inputDto2 = skuIdSerialNoDTOS.stream().filter(i -> i.getBrandId().equals(dto2.getBrandId())).findFirst().orElse(null);
            if (inputDto1 == null || inputDto2 == null) {
                return 0;
            }
            if (inputDto1.getSerialNo() == null && inputDto2.getSerialNo() == null) {
                return 0;
            }
            if (inputDto1.getSerialNo() == null) {
                return 1;
            }
            if (inputDto2.getSerialNo() == null) {
                return -1;
            }
            return inputDto1.getSerialNo().compareTo(inputDto2.getSerialNo());
        });
        int fromIndex = (pageNum - 1) * pageSize;
        int toIndex = Math.min(pageNum * pageSize, records.size());
        if (fromIndex > records.size()) {
            return new Page((long)pageNum, (long)pageSize);
        }
        List brandSubscribeDTOS = records.subList(fromIndex, toIndex);
        page.setRecords(brandSubscribeDTOS);
        page.setCurrent((long)pageNum);
        page.setSize((long)pageSize);
        return page;
    }
}

