/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.dao.repository.SpuPictureService;
import com.xinqiyi.ps.dao.util.BeanConvertUtil;
import com.xinqiyi.ps.model.dto.spu.SpuPictureDTO;
import com.xinqiyi.ps.model.entity.SpuPicture;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SpuPictureBiz {
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private SpuPictureService spuPictureService;

    void checkSave(List<SpuPictureDTO> spuPictureList) {
        List spuPictureDTOS = spuPictureList.stream().filter(SpuPictureDTO::getIsMain).collect(Collectors.toList());
        Assert.isTrue((spuPictureDTOS.size() == 1 ? 1 : 0) != 0, (String)"\u5546\u54c1\u4e3b\u56fe\u53ea\u80fd\u6709\u4e00\u5f20");
    }

    List<SpuPicture> convert(List<SpuPictureDTO> spuPictureDTOList, Long spuId) {
        ArrayList<SpuPicture> spuPictureList = new ArrayList<SpuPicture>();
        for (SpuPictureDTO spuPictureDTO : spuPictureDTOList) {
            SpuPicture spuPicture = new SpuPicture();
            BeanConvertUtil.copyProperties((Object)spuPictureDTO, (Object)spuPicture);
            spuPicture.setPsSpuId(spuId);
            spuPicture.setId(this.idSequence.generateId(SpuPicture.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)spuPicture);
            spuPictureList.add(spuPicture);
        }
        return spuPictureList;
    }

    List<SpuPicture> selectBySpuId(Long psSpuId) {
        return this.spuPictureService.selectBySpuId(psSpuId);
    }

    SpuPicture getMainBySpuId(Long psSpuId) {
        return this.spuPictureService.getMainBySpuId(psSpuId);
    }

    public List<SpuPicture> getMainBySpuIds(List<Long> spuIds) {
        return this.spuPictureService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SpuPicture::getPsSpuId, spuIds)).eq(SpuPicture::getIsMain, (Object)Boolean.TRUE)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE));
    }

    public List<SpuPicture> getBySpuIds(List<Long> spuIds) {
        return this.spuPictureService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SpuPicture::getPsSpuId, spuIds)).eq(BaseDo::getIsDelete, (Object)Boolean.FALSE)).orderByDesc(SpuPicture::getIsMain));
    }
}

