/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Maps;
import com.xinqiyi.cus.model.dto.enums.CustomerPurchaseModeEnum;
import com.xinqiyi.cus.vo.CustomerVO;
import com.xinqiyi.dynamicform.dao.repository.DictRedisRepository;
import com.xinqiyi.dynamicform.model.dto.DictGroup;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.dynamicform.model.enums.OperateType;
import com.xinqiyi.fc.model.enums.FcCommonEnum;
import com.xinqiyi.framework.api.model.ApiResponse;
import com.xinqiyi.framework.bizlog.annotation.LogAnnotation;
import com.xinqiyi.framework.bizlog.entity.BizLogInfo;
import com.xinqiyi.framework.bizlog.entity.InnerLog;
import com.xinqiyi.framework.bizlog.service.BizLogWrapperService;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.model.search.CommonSearchRequest;
import com.xinqiyi.framework.security.encrypt.config.EncryptConfig;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.AesUtil;
import com.xinqiyi.mdm.api.model.vo.logisticscompany.LogisticsCompanyPlatformVO;
import com.xinqiyi.mdm.api.model.vo.renovation.ShopRenovationVO;
import com.xinqiyi.mdm.model.dto.renovation.QueryShopRenovationDTO;
import com.xinqiyi.ps.api.model.vo.PsStorePlatformAccountVO;
import com.xinqiyi.ps.api.model.vo.PsStoreVO;
import com.xinqiyi.ps.api.model.vo.QueryStoreLogisticsCompanyDTO;
import com.xinqiyi.ps.api.model.vo.StoreLogisticCompanyVO;
import com.xinqiyi.ps.api.model.vo.StoreLogisticsCompanyPlatformVO;
import com.xinqiyi.ps.api.model.vo.StorePayTypeSwitchVO;
import com.xinqiyi.ps.api.model.vo.StorePointManagementConfigVO;
import com.xinqiyi.ps.api.model.vo.StoreSalesmanInfoVO;
import com.xinqiyi.ps.api.model.vo.StoreVO;
import com.xinqiyi.ps.dao.repository.PsSceneService;
import com.xinqiyi.ps.dao.repository.PsStoreLogisticsCompanyPlatformService;
import com.xinqiyi.ps.dao.repository.PsStoreLogisticsCompanyService;
import com.xinqiyi.ps.dao.repository.PsStorePlatformAccountService;
import com.xinqiyi.ps.dao.repository.PsStorePlatformService;
import com.xinqiyi.ps.dao.repository.PsStoreSpuAliasService;
import com.xinqiyi.ps.dao.repository.SkuShelfService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.enums.DisplayInventoryEnum;
import com.xinqiyi.ps.model.dto.enums.IsDeleteEnums;
import com.xinqiyi.ps.model.dto.enums.StatusEnums;
import com.xinqiyi.ps.model.dto.enums.StorePlatformTypeEnum;
import com.xinqiyi.ps.model.dto.enums.StoreShelfConfigEnum;
import com.xinqiyi.ps.model.dto.enums.StoreTypeEnum;
import com.xinqiyi.ps.model.dto.enums.SupplyPriceTypeEnums;
import com.xinqiyi.ps.model.dto.enums.YesOrNoEnum;
import com.xinqiyi.ps.model.dto.spu.SpuAliasBaseDTO;
import com.xinqiyi.ps.model.dto.spu.SpuAliasDTO;
import com.xinqiyi.ps.model.dto.store.MenuDTO;
import com.xinqiyi.ps.model.dto.store.PsStorePlatformAccountDTO;
import com.xinqiyi.ps.model.dto.store.QueryStorePermissionDTO;
import com.xinqiyi.ps.model.dto.store.QueryStoreRenovationDTO;
import com.xinqiyi.ps.model.dto.store.StoreDTO;
import com.xinqiyi.ps.model.dto.store.StoreLogisticCompanyDTO;
import com.xinqiyi.ps.model.dto.store.StoreLogisticsCompanyPlatformDTO;
import com.xinqiyi.ps.model.dto.store.StorePayTypeSwitchDTO;
import com.xinqiyi.ps.model.dto.transport.TransportDTO;
import com.xinqiyi.ps.model.entity.PsStoreLogisticsCompany;
import com.xinqiyi.ps.model.entity.PsStoreLogisticsCompanyPlatform;
import com.xinqiyi.ps.model.entity.PsStorePlatform;
import com.xinqiyi.ps.model.entity.PsStorePlatformAccount;
import com.xinqiyi.ps.model.entity.PsStoreSpuAlias;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.model.entity.StorePayTypeSwitch;
import com.xinqiyi.ps.model.entity.scene.PsScene;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.mall4j.MallFourJAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.PsSceneBiz;
import com.xinqiyi.ps.service.business.StorePayTypeSwitchBiz;
import com.xinqiyi.ps.service.business.StorePlatformAccountBiz;
import com.xinqiyi.ps.service.business.StorePlatformBiz;
import com.xinqiyi.ps.service.business.StorePointManagementBiz;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import com.xinqiyi.ps.service.util.BigDecimalUtils;
import com.xinqiyi.ps.service.util.CamelTransformUnderlineUtils;
import com.xinqiyi.ps.service.util.DateUtil;
import com.xinqiyi.ps.service.util.RedisUtils;
import com.xinqiyi.ps.service.util.StringUtil;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.menu.BizMenuDTO;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.menu.MenuRespDTO;
import com.xinqiyi.systemcenter.web.sc.model.dto.permission.UserFunctionPermissionDTO;
import com.xinqiyi.systemcenter.web.sc.model.dto.role.RoleDTO;
import com.xinqiyi.systemcenter.web.sc.model.dto.user.UserStoreDTO;
import com.xinqiyi.systemcenter.web.sc.permssion.model.SelectMindDataResponse;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class StoreBiz {
    private static final Logger log = LoggerFactory.getLogger(StoreBiz.class);
    @Autowired
    private StoreService storeService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private CusAdapter cusAdapter;
    @Autowired
    private IdSequenceGenerator idSequence;
    @Autowired
    private ScAdapter scAdapter;
    @Autowired
    private PsSceneBiz psSceneBiz;
    @Autowired
    private PsSceneService psSceneService;
    @Autowired
    private EncryptConfig encryptConfig;
    @Autowired
    private StorePlatformBiz storePlatformBiz;
    @Autowired
    private StorePlatformAccountBiz storePlatformAccountBiz;
    @Autowired
    private PsStorePlatformService psStorePlatformService;
    @Autowired
    private PsStorePlatformAccountService psStorePlatformAccountService;
    @Autowired
    private DictRedisRepository dictRedisRepository;
    @Autowired
    private UserInfoUtil userInfoUtil;
    @Autowired
    private IdSequenceGenerator idSequenceGenerator;
    @Autowired
    private BizLogWrapperService bizLogWrapperService;
    @Resource
    private MdmAdapter mdmAdapter;
    @Resource
    private PsStoreLogisticsCompanyService psStoreLogisticsCompanyService;
    @Resource
    private MallFourJAdapter mallFourJAdapter;
    @Resource
    private PsStoreLogisticsCompanyPlatformService psStoreLogisticsCompanyPlatformService;
    @Resource
    private PsStoreSpuAliasService storeSpuAliasService;
    @Resource
    private SkuShelfService skuShelfService;
    @Resource
    private StorePointManagementBiz storePointManagementBiz;
    @Resource
    private StorePayTypeSwitchBiz payTypeSwitchBiz;

    public ApiResponse<List<StoreVO>> queryStoreList(StoreDTO dto) {
        List storeList = this.storeService.queryStoreList(dto);
        List<StoreVO> storeVOS = BeanConvertUtil.convertList(storeList, StoreVO.class);
        if (CollUtil.isNotEmpty(storeVOS)) {
            List<Long> storeIdList = storeVOS.stream().map(StoreVO::getId).toList();
            List<StorePayTypeSwitchVO> switchVOS = this.payTypeSwitchBiz.getStorePayTypeSwitchVOList(storeIdList);
            boolean anyMatch = switchVOS.stream().anyMatch(o -> o.getPsStoreId() == null);
            if (anyMatch) {
                storeVOS.forEach(o -> o.setPayTypeSwitchVOList(switchVOS));
            } else {
                Map<Long, List<StorePayTypeSwitchVO>> switchVOMap = switchVOS.stream().collect(Collectors.groupingBy(StorePayTypeSwitchVO::getPsStoreId));
                storeVOS.forEach(o -> o.setPayTypeSwitchVOList((List)switchVOMap.get(o.getId())));
            }
        }
        return ApiResponse.success(storeVOS);
    }

    @LogAnnotation
    public void updateStoreStatusBatch(StoreDTO dto, String operateType) {
        Assert.notEmpty((Collection)dto.getIds(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)operateType, (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        List stores = this.storeService.listByIds((Collection)dto.getIds());
        Assert.isTrue((stores.size() == dto.getIds().size() ? 1 : 0) != 0, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        if (operateType.equals("enable")) {
            List storeList = stores.stream().filter(a -> StringUtils.equals((CharSequence)a.getStoreType(), (CharSequence)StoreTypeEnum.ONE.getCode())).collect(Collectors.toList());
            Assert.isTrue((storeList.size() <= 1 ? 1 : 0) != 0, (String)"\u201c\u5185\u8d2d\u5e97\u94fa\u201d\u7c7b\u578b\u7684\u5e97\u94fa\u53ea\u80fd\u6709\u4e00\u6761\u542f\u7528\u7684\u8bb0\u5f55");
        }
        for (Store store : stores) {
            if (operateType.equals("enable")) {
                if (StringUtils.equals((CharSequence)store.getStoreType(), (CharSequence)StoreTypeEnum.ONE.getCode())) {
                    Store serviceOne = (Store)this.storeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Store::getStatus, (Object)StatusEnums.ENABLED.getCode().toString())).eq(Store::getStoreType, (Object)StoreTypeEnum.ONE.getCode())).ne(BaseDo::getId, (Object)store.getId()), false);
                    Assert.isNull((Object)serviceOne, (String)"\u5df2\u5b58\u5728\u201c\u542f\u7528\u201d\u72b6\u6001\u7684\u201c\u5e97\u94fa\u7c7b\u578b=\u5185\u8d2d\u5e97\u94fa\u201d\u7684\u5e97\u94fa");
                }
                Assert.isTrue((!store.getStatus().equals(StatusEnums.ENABLED.getCode().toString()) ? 1 : 0) != 0, (String)"\u505c\u7528/\u672a\u542f\u7528\u201d\u72b6\u6001\u624d\u53ef\u4ee5\u542f\u7528\uff01");
                store.setStatus(StatusEnums.ENABLED.getCode().toString());
                InnerLog.addLog((Long)store.getId(), (String)"\u6240\u5c5e\u5e97\u94fa\u542f\u7528", (String)"ps_store", (String)"", (String)"\u542f\u7528");
            }
            if (operateType.equals("disable")) {
                Assert.isTrue((boolean)store.getStatus().equals(StatusEnums.ENABLED.getCode().toString()), (String)"\u542f\u7528\u201d\u72b6\u6001\u624d\u53ef\u4ee5\u505c\u7528\uff01");
                store.setStatus(StatusEnums.STOP_USING.getCode().toString());
                InnerLog.addLog((Long)store.getId(), (String)"\u6240\u5c5e\u5e97\u94fa\u505c\u7528", (String)"ps_store", (String)"", (String)"\u505c\u7528");
            }
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)store);
        }
        this.storeService.updateBatchById((Collection)stores);
    }

    public String getPermission(String loginFrom) {
        List<UserFunctionPermissionDTO> userFunctionPermissionDTOS = this.scAdapter.checkPermission(loginFrom);
        List menuCodeList = userFunctionPermissionDTOS.stream().filter(userFunctionPermissionDTO -> ObjectUtil.isNotNull((Object)userFunctionPermissionDTO.getHasPermission()) && userFunctionPermissionDTO.getHasPermission() != false).collect(Collectors.toList()).stream().map(UserFunctionPermissionDTO::getMenuCode).collect(Collectors.toList());
        Assert.notEmpty(menuCodeList, (String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6682\u65f6\u6ca1\u6709\u76f8\u5173\u7684\u64cd\u4f5c\u6743\u9650\uff01\u5982\u987b\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u4e1a\u52a1\u5458\uff01");
        Object permissionCode = "";
        if (menuCodeList.size() > 1) {
            permissionCode = CustomerPurchaseModeEnum.BATCH_PURCHASE.getCode() + "," + CustomerPurchaseModeEnum.DROP_SHIPPING.getCode();
        } else {
            for (String code : menuCodeList) {
                if (com.baomidou.mybatisplus.core.toolkit.StringUtils.equals((CharSequence)"Order", (CharSequence)code)) {
                    permissionCode = CustomerPurchaseModeEnum.DROP_SHIPPING.getCode();
                }
                if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.equals((CharSequence)"WholesaleOrder", (CharSequence)code)) continue;
                permissionCode = CustomerPurchaseModeEnum.BATCH_PURCHASE.getCode();
            }
        }
        return permissionCode;
    }

    public void deleteStoreBatch(StoreDTO dto) {
        Assert.notEmpty((Collection)dto.getIds(), (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        List stores = this.storeService.listByIds((Collection)dto.getIds());
        Assert.isTrue((stores.size() == dto.getIds().size() ? 1 : 0) != 0, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        for (Store store : stores) {
            Assert.isTrue((boolean)store.getStatus().equals(StatusEnums.NOT_ENABLED.getCode().toString()), (String)"\u672a\u542f\u7528\u201d\u72b6\u6001\u624d\u5141\u8bb8\u5220\u9664\uff01");
            store.setStatus(StatusEnums.ENABLED.getCode().toString());
        }
        this.storeService.removeByIds((Collection)dto.getIds());
    }

    public StoreVO queryStoreDetail(Long dataId) {
        StorePointManagementConfigVO storePointManagementConfig;
        PsStoreLogisticsCompany logisticsCompany;
        Assert.notNull((Object)dataId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Store store = (Store)this.storeService.getById((Serializable)dataId);
        StoreVO storeVO = new StoreVO();
        if (ObjectUtils.isNotEmpty((Object)store)) {
            BeanUtils.copyProperties((Object)store, (Object)storeVO);
            if (ObjectUtils.isNotEmpty((Object)store.getCusCustomerId())) {
                CustomerVO customerVO = this.cusAdapter.queryCustomerById(store.getCusCustomerId());
                storeVO.setCusCustomerName(customerVO.getCustomerName());
            }
            storeVO.setAvailableInventoryProportion(BigDecimalUtils.getValue(storeVO.getAvailableInventoryProportion()));
            storeVO.setWholesaleInventoryList(this.getList(store.getWholesaleInventoryIds(), store.getWholesaleInventoryNames()));
            storeVO.setIssuingInventoryList(this.getList(store.getIssuingInventoryIds(), store.getIssuingInventoryNames()));
            storeVO.setPcLogicList(this.getList(store.getPcLogicIds(), store.getPcLogicNames()));
            storeVO.setDfLogicList(this.getList(store.getDfLogicIds(), store.getDfLogicNames()));
        }
        if ((logisticsCompany = (PsStoreLogisticsCompany)this.psStoreLogisticsCompanyService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PsStoreLogisticsCompany.class).eq(PsStoreLogisticsCompany::getPsStoreId, (Object)dataId)).eq(PsStoreLogisticsCompany::getIsDefault, (Object)FcCommonEnum.YesOrNoEnum.YES.getValue())).eq(PsStoreLogisticsCompany::getPurchaseMode, (Object)Integer.valueOf(SupplyPriceTypeEnums.ONE.getCode()))).last("limit 1"))) != null) {
            storeVO.setPcFreeShippingAmount(logisticsCompany.getFreeShippingAmount());
        }
        if (Objects.nonNull(storePointManagementConfig = this.storePointManagementBiz.getByStoreId(store.getId())) && FcCommonEnum.YesOrNoEnum.NO.getValue().equals(storePointManagementConfig.getEnablePointsSystem())) {
            storeVO.setStorePointManagementConfig(null);
        } else {
            this.buildStorePointManagementPointsExpiryDate(storePointManagementConfig);
            storeVO.setStorePointManagementConfig(storePointManagementConfig);
        }
        storeVO.setPayTypeSwitchVOList(this.payTypeSwitchBiz.getStorePayTypeSwitchVOList(store.getId(), false));
        return storeVO;
    }

    private void buildStorePointManagementPointsExpiryDate(StorePointManagementConfigVO storePointManagementConfig) {
        if (Objects.nonNull(storePointManagementConfig) && storePointManagementConfig.getPointsExpiryMonthNextYear() > 0) {
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            int lastDay = DateUtil.findLastDay(year, storePointManagementConfig.getPointsExpiryMonthNextYear());
            storePointManagementConfig.setPointsExpiryDateStr(storePointManagementConfig.getPointsExpiryMonthNextYear() + "." + lastDay);
        }
    }

    @LogAnnotation
    @Transactional(rollbackFor={Exception.class})
    public Long saveStore(StoreDTO dto) {
        List<PsStoreLogisticsCompany> logisticCompanyList;
        this.verifySaveStoreParam(dto);
        Store store = new Store();
        BeanUtils.copyProperties((Object)dto, (Object)store);
        if (StringUtils.equals((CharSequence)DisplayInventoryEnum.YES.getCode(), (CharSequence)dto.getIsDisplayInventory())) {
            Assert.notNull((Object)dto.getAvailableInventoryProportion(), (String)"\u53ef\u7528\u5e93\u5b58\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            List wholesaleInventorIds = dto.getWholesaleInventoryList().stream().map(wholesaleInventor -> wholesaleInventor.get("id")).distinct().collect(Collectors.toList());
            List wholesaleInventorNames = dto.getWholesaleInventoryList().stream().map(wholesaleInventor -> wholesaleInventor.get("name")).distinct().collect(Collectors.toList());
            store.setWholesaleInventoryIds(StringUtils.join(wholesaleInventorIds, (String)","));
            store.setWholesaleInventoryNames(StringUtils.join(wholesaleInventorNames, (String)","));
            List pcIds = dto.getPcLogicList().stream().map(wholesaleInventor -> wholesaleInventor.get("id")).distinct().collect(Collectors.toList());
            List pcNameList = dto.getPcLogicList().stream().map(wholesaleInventor -> wholesaleInventor.get("name")).distinct().collect(Collectors.toList());
            store.setPcLogicIds(StringUtils.join(pcIds, (String)","));
            store.setPcLogicNames(StringUtils.join(pcNameList, (String)","));
        }
        if (StringUtils.equals((CharSequence)DisplayInventoryEnum.YES.getCode(), (CharSequence)dto.getIsDfDisplayInventory())) {
            Assert.notNull((Object)dto.getIsDfDisplayInventory(), (String)"\u53ef\u7528\u5e93\u5b58\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            List issuingInventoryIds = dto.getIssuingInventoryList().stream().map(issuingInventory -> issuingInventory.get("id")).distinct().collect(Collectors.toList());
            List issuingInventoryNames = dto.getIssuingInventoryList().stream().map(issuingInventory -> issuingInventory.get("name")).distinct().collect(Collectors.toList());
            store.setIssuingInventoryIds(StringUtils.join(issuingInventoryIds, (String)","));
            store.setIssuingInventoryNames(StringUtils.join(issuingInventoryNames, (String)","));
            List dfIds = dto.getDfLogicList().stream().map(wholesaleInventor -> wholesaleInventor.get("id")).distinct().collect(Collectors.toList());
            List dfNameList = dto.getDfLogicList().stream().map(wholesaleInventor -> wholesaleInventor.get("name")).distinct().collect(Collectors.toList());
            store.setDfLogicIds(StringUtils.join(dfIds, (String)","));
            store.setDfLogicNames(StringUtils.join(dfNameList, (String)","));
        }
        if (ObjectUtils.isNotEmpty((Object)store.getCusCustomerId())) {
            CustomerVO customerVO = this.cusAdapter.queryCustomerById(store.getCusCustomerId());
            store.setCusCustomerName(customerVO.getCustomerName());
        }
        if (ObjectUtils.isEmpty((Object)dto.getId())) {
            store.setId(this.idSequence.generateId(Store.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)store);
            store.setStatus(StatusEnums.NOT_ENABLED.getCode().toString());
            InnerLog.addLog((Long)store.getId(), (String)"\u6240\u5c5e\u5e97\u94fa\u65b0\u589e", (String)"ps_store", (String)"", (String)"\u65b0\u589e");
        } else {
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)store);
            InnerLog.addLog((Long)store.getId(), (String)"\u6240\u5c5e\u5e97\u94fa\u7f16\u8f91", (String)"ps_store", (String)"", (String)"\u7f16\u8f91");
        }
        Long sysRoleId = null;
        if (dto.getId() != null) {
            Store s = (Store)this.storeService.getById((Serializable)dto.getId());
            Assert.notNull((Object)s, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
            if (!Objects.equals(s.getCollectingCompanyId(), dto.getCollectingCompanyId())) {
                // empty if block
            }
            sysRoleId = s.getSysRoleId();
        }
        if (dto.getSysRoleId() != null && !ObjectUtil.equal((Object)dto.getSysRoleId(), sysRoleId)) {
            ApiResponse<RoleDTO> roleDTOApiResponse = this.scAdapter.saveStoreRoleRelation(store.getId(), dto.getSysRoleId());
            Assert.isTrue((boolean)roleDTOApiResponse.isSuccess(), (String)("\u4fdd\u5b58\u5e97\u94fa\u89d2\u8272\u5931\u8d25 \u5931\u8d25\u539f\u56e0:" + roleDTOApiResponse.getDesc()));
        }
        if (dto.getSysRoleId() == null && sysRoleId != null) {
            ApiResponse<Boolean> booleanApiResponse = this.scAdapter.deleteStoreRoleRelation(store.getId());
            Assert.isTrue((booleanApiResponse.isSuccess() && (Boolean)booleanApiResponse.getContent() != false ? 1 : 0) != 0, (String)("\u5220\u9664\u5e97\u94fa\u89d2\u8272\u5931\u8d25 \u5931\u8d25\u539f\u56e0:" + booleanApiResponse.getDesc()));
        }
        PsStorePlatform psStorePlatform = null;
        List<Object> psStorePlatformAccountList = CollUtil.newArrayList((Object[])new PsStorePlatformAccount[0]);
        if (StrUtil.equals((CharSequence)StorePlatformTypeEnum.TWO.getCode(), (CharSequence)dto.getPlatformType())) {
            psStorePlatform = this.storePlatformBiz.covert(dto, store.getId());
            psStorePlatformAccountList = this.storePlatformAccountBiz.covert(dto, psStorePlatform, store.getId());
        }
        if (CollUtil.isNotEmpty(logisticCompanyList = this.buildLogisticCompanySaveEntity(dto, store.getId()))) {
            Map<Long, PsStoreLogisticsCompany> preLogisticsCompanyMap = logisticCompanyList.stream().collect(Collectors.toMap(BaseDo::getId, Function.identity()));
            Long storeId = store.getId();
            Map<Long, PsStoreLogisticsCompany> logisticsCompanyIdMap = this.psStoreLogisticsCompanyService.list((Wrapper)Wrappers.lambdaQuery(PsStoreLogisticsCompany.class).eq(PsStoreLogisticsCompany::getPsStoreId, (Object)storeId)).stream().collect(Collectors.toMap(BaseDo::getId, Function.identity()));
            ArrayList logisticsCompanyRemoveIdList = Lists.newArrayList();
            List<Long> insertIds = preLogisticsCompanyMap.keySet().stream().filter(id -> !logisticsCompanyIdMap.containsKey(id)).collect(Collectors.toList());
            ArrayList insertLogList = Lists.newArrayList();
            this.getLogisticCompanyInsertLog(store, preLogisticsCompanyMap, insertIds, insertLogList);
            logisticsCompanyIdMap.forEach((id, logisticsCompany) -> {
                if (!preLogisticsCompanyMap.containsKey(id)) {
                    logisticsCompanyRemoveIdList.add(id);
                } else {
                    this.getLogisticCompanyUpdateLog(store, (PsStoreLogisticsCompany)logisticsCompany, (Long)id, preLogisticsCompanyMap, insertLogList);
                }
            });
            if (CollUtil.isNotEmpty((Collection)logisticsCompanyRemoveIdList)) {
                List<BizLogInfo> deleteLogList = this.getLogisticCompanyDeleteLog(store, logisticsCompanyIdMap, logisticsCompanyRemoveIdList);
                this.bizLogWrapperService.manualSaveOperateLog("ps_log", deleteLogList);
                this.psStoreLogisticsCompanyService.removeByIdList((List)logisticsCompanyRemoveIdList);
            }
            this.psStoreLogisticsCompanyService.saveOrUpdateBatch(logisticCompanyList);
            if (CollUtil.isNotEmpty((Collection)insertLogList)) {
                this.bizLogWrapperService.manualSaveOperateLog("ps_log", (List)insertLogList);
            }
            for (PsStoreLogisticsCompany logisticsCompany2 : logisticCompanyList) {
                Long logisticsCompanyId = logisticsCompany2.getId();
                List platformList = logisticsCompany2.getPlatformList();
                Map<Long, PsStoreLogisticsCompanyPlatform> prePlatformMap = platformList.stream().collect(Collectors.toMap(BaseDo::getId, Function.identity()));
                Map<Long, PsStoreLogisticsCompanyPlatform> platformIdMap = this.psStoreLogisticsCompanyPlatformService.list((Wrapper)Wrappers.lambdaQuery(PsStoreLogisticsCompanyPlatform.class).eq(PsStoreLogisticsCompanyPlatform::getPsStoreLogisticCompanyId, (Object)logisticsCompanyId)).stream().collect(Collectors.toMap(BaseDo::getId, Function.identity()));
                ArrayList platformRemoveIdList = Lists.newArrayList();
                List<Long> platformInsertIds = prePlatformMap.keySet().stream().filter(id -> !platformIdMap.containsKey(id)).collect(Collectors.toList());
                ArrayList platformInsertLogList = Lists.newArrayList();
                this.getLogisticCompanyPlatformInsertLog(store, prePlatformMap, platformInsertIds, platformInsertLogList);
                platformIdMap.forEach((id, platform) -> {
                    if (!prePlatformMap.containsKey(id)) {
                        platformRemoveIdList.add(id);
                    } else {
                        this.getPlatformUpdateLog(store, prePlatformMap, (Long)id, (PsStoreLogisticsCompanyPlatform)platform, platformInsertLogList);
                    }
                });
                if (CollUtil.isNotEmpty((Collection)platformInsertLogList)) {
                    this.bizLogWrapperService.manualSaveOperateLog("ps_log", (List)platformInsertLogList);
                }
                if (CollUtil.isNotEmpty((Collection)platformRemoveIdList)) {
                    List<BizLogInfo> deleteLogList = this.getPlatformDeleteLog(store, logisticsCompanyRemoveIdList, platformIdMap);
                    this.bizLogWrapperService.manualSaveOperateLog("ps_log", deleteLogList);
                    this.psStoreLogisticsCompanyPlatformService.removeByIdList((List)platformRemoveIdList);
                }
                this.psStoreLogisticsCompanyPlatformService.saveOrUpdateBatch((Collection)platformList);
            }
        }
        List<StorePayTypeSwitch> storePayTypeSwitchList = this.payTypeSwitchBiz.getStorePayTypeSwitchList(dto, store);
        return this.storeService.saveOrUpdate(store, dto.getIsDisplayInventory(), dto.getIsDfDisplayInventory(), psStorePlatform, (List)psStorePlatformAccountList, storePayTypeSwitchList);
    }

    private void verifySaveStoreParam(StoreDTO dto) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)dto.getShelfConfig()), (String)"\u4e0a\u67b6\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getRetailPriceFlag(), (String)"\u5efa\u8bae\u96f6\u552e\u4ef7\u4e3a\u7a7a\u5141\u8bb8\u4e0a\u67b6\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getOaOrderFailureTime(), (String)"\u8ba2\u5355\u5931\u6548\u65f6\u95f4\uff08OA\u5ba1\u6279\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getOaOrderFailureTimeUnit(), (String)"\u8ba2\u5355\u5931\u6548\u65f6\u95f4\u5355\u4f4d\uff08OA\u5ba1\u6279\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getIndividualOrderFailureTime(), (String)"\u8ba2\u5355\u5931\u6548\u65f6\u95f4\uff08\u4e2a\u4eba\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getIndividualOrderFailureTimeUnit(), (String)"\u8ba2\u5355\u5931\u6548\u65f6\u95f4\u5355\u4f4d\uff08\u4e2a\u4eba\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getEnterprisingOrderFailureTime(), (String)"\u8ba2\u5355\u5931\u6548\u65f6\u95f4\uff08\u4f01\u4e1a\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getEnterprisingOrderFailureTimeUnit(), (String)"\u8ba2\u5355\u5931\u6548\u65f6\u95f4\u5355\u4f4d\uff08\u4f01\u4e1a\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getFinancialReviewRejOrderFailureTime(), (String)"\u8ba2\u5355\u5931\u6548\u65f6\u95f4\uff08\u8d22\u5ba1\u9a73\u56de\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getFinancialReviewRejOrderFailureTimeUnit(), (String)"\u8ba2\u5355\u5931\u6548\u65f6\u95f4\u5355\u4f4d\uff08\u8d22\u5ba1\u9a73\u56de\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)Objects.nonNull(dto.getCollectingCompanyId()), (String)"\u6536\u6b3e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)dto.getCollectingCompanyName()), (String)"\u6536\u6b3e\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Store storeCode = this.storeService.checkStore(dto.getId(), dto.getCode(), "");
        Assert.isTrue((boolean)ObjectUtils.isEmpty((Object)storeCode), (String)"\u5e97\u94fa\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        Store storeName = this.storeService.checkStore(dto.getId(), "", dto.getName());
        Assert.isTrue((boolean)ObjectUtils.isEmpty((Object)storeName), (String)"\u5e97\u94fa\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        if (CollUtil.isNotEmpty((Collection)dto.getPayTypeSwitchDTOList())) {
            StorePayTypeSwitchDTO sapPay = dto.getPayTypeSwitchDTOList().stream().filter(o -> Objects.equals(1, o.getIsOpen()) && Objects.equals(o.getPayType(), 99)).findAny().orElse(null);
            StorePayTypeSwitchDTO balancePay = dto.getPayTypeSwitchDTOList().stream().filter(o -> Objects.equals(1, o.getIsOpen()) && Objects.equals(o.getPayType(), 5)).findAny().orElse(null);
            if (null != sapPay && null != balancePay) {
                throw new IllegalArgumentException("SAP\u652f\u4ed8\u4e0e\u4f59\u989d\u652f\u4ed8\u4e0d\u80fd\u540c\u65f6\u5f00\u542f");
            }
        }
    }

    private List<BizLogInfo> getPlatformDeleteLog(Store store, List<Long> logisticsCompanyRemoveIdList, Map<Long, PsStoreLogisticsCompanyPlatform> platformIdMap) {
        ArrayList deleteLogList = Lists.newArrayList();
        for (Long removeId : logisticsCompanyRemoveIdList) {
            PsStoreLogisticsCompanyPlatform platform = platformIdMap.get(removeId);
            if (null == platform) continue;
            BizLogInfo bizLogInfo = new BizLogInfo();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
            bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
            bizLogInfo.setOperateDataId(store.getId());
            bizLogInfo.setOperateTypeCode("ITEM_DELETE");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u5220\u9664");
            bizLogInfo.setOperateTableDesc("ITEM_UPDATE");
            bizLogInfo.setBeforeUpdateValue("");
            bizLogInfo.setBeforeUpdateValueDesc("");
            bizLogInfo.setAfterUpdateValue("1");
            bizLogInfo.setAfterUpdateValueDesc("\u5220\u9664\u3010" + platform.getMdmPlatformName() + "\u3011");
            bizLogInfo.setOperateTableName("ps_store");
            bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8-\u5e73\u53f0id:" + platform.getId());
            bizLogInfo.setOperateColumnName("is_delete");
            bizLogInfo.setOperateColumnDesc("\u660e\u7ec6\u5220\u9664");
            deleteLogList.add(bizLogInfo);
        }
        return deleteLogList;
    }

    private List<BizLogInfo> getLogisticCompanyDeleteLog(Store store, Map<Long, PsStoreLogisticsCompany> logisticsCompanyIdMap, List<Long> logisticsCompanyRemoveIdList) {
        ArrayList deleteLogList = Lists.newArrayList();
        for (Long removeId : logisticsCompanyRemoveIdList) {
            PsStoreLogisticsCompany logisticsCompany = logisticsCompanyIdMap.get(removeId);
            BizLogInfo bizLogInfo = new BizLogInfo();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
            bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
            bizLogInfo.setOperateDataId(store.getId());
            bizLogInfo.setOperateTypeCode("ITEM_DELETE");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u5220\u9664");
            bizLogInfo.setOperateTableDesc("ITEM_UPDATE");
            bizLogInfo.setBeforeUpdateValue("");
            bizLogInfo.setBeforeUpdateValueDesc("");
            bizLogInfo.setAfterUpdateValue("1");
            bizLogInfo.setAfterUpdateValueDesc("\u5220\u9664\u3010" + logisticsCompany.getMdmLogisticsCompanyTypeName() + "\u3011");
            bizLogInfo.setOperateTableName("ps_store");
            bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + logisticsCompany.getId());
            bizLogInfo.setOperateColumnName("is_delete");
            bizLogInfo.setOperateColumnDesc("\u660e\u7ec6\u5220\u9664");
            deleteLogList.add(bizLogInfo);
        }
        return deleteLogList;
    }

    private void getPlatformUpdateLog(Store store, Map<Long, PsStoreLogisticsCompanyPlatform> prePlatformMap, Long id, PsStoreLogisticsCompanyPlatform platform, List<BizLogInfo> platformInsertLogList) {
        PsStoreLogisticsCompanyPlatform prePlatform = prePlatformMap.get(id);
        if (prePlatform == null) {
            return;
        }
        if (!prePlatform.getIsMallDisplay().equals(platform.getIsMallDisplay())) {
            BizLogInfo bizLogInfo = new BizLogInfo();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
            bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
            bizLogInfo.setOperateDataId(store.getId());
            bizLogInfo.setOperateTypeCode("UPDATE");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u66f4\u6539");
            bizLogInfo.setOperateTableDesc("ITEM_UPDATE");
            bizLogInfo.setBeforeUpdateValue(platform.getIsMallDisplay().toString());
            bizLogInfo.setBeforeUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)platform.getIsMallDisplay()));
            bizLogInfo.setAfterUpdateValue(prePlatform.getIsMallDisplay().toString());
            bizLogInfo.setAfterUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)prePlatform.getIsMallDisplay()));
            bizLogInfo.setOperateTableName("ps_store");
            bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8-\u5e73\u53f0id:" + platform.getId());
            bizLogInfo.setOperateColumnName("is_mall_display");
            bizLogInfo.setOperateColumnDesc(prePlatform.getMdmPlatformName() + "\u662f\u5426\u5728\u5546\u57ce\u663e\u793a");
            platformInsertLogList.add(bizLogInfo);
        }
    }

    private void getLogisticCompanyPlatformInsertLog(Store store, Map<Long, PsStoreLogisticsCompanyPlatform> prePlatformMap, List<Long> platformInsertIds, List<BizLogInfo> platformInsertLogList) {
        if (CollUtil.isNotEmpty(platformInsertIds)) {
            for (Long insertId : platformInsertIds) {
                PsStoreLogisticsCompanyPlatform prePlatform = prePlatformMap.get(insertId);
                BizLogInfo bizLogInfo = new BizLogInfo();
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
                bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
                bizLogInfo.setOperateDataId(store.getId());
                bizLogInfo.setOperateTypeCode("ITEM_INSERT");
                bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u65b0\u589e");
                bizLogInfo.setBeforeUpdateValue("");
                bizLogInfo.setBeforeUpdateValueDesc("");
                bizLogInfo.setAfterUpdateValue(prePlatform.getIsMallDisplay().toString());
                bizLogInfo.setAfterUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)prePlatform.getIsMallDisplay()));
                bizLogInfo.setOperateTableName("ps_store");
                bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8-\u5e73\u53f0id:" + prePlatform.getId());
                bizLogInfo.setOperateColumnName("is_mall_display");
                bizLogInfo.setOperateColumnDesc(prePlatform.getMdmPlatformName() + "\u662f\u5426\u5728\u5546\u57ce\u663e\u793a");
                platformInsertLogList.add(bizLogInfo);
            }
        }
    }

    private void getLogisticCompanyUpdateLog(Store store, PsStoreLogisticsCompany logisticsCompany, Long id, Map<Long, PsStoreLogisticsCompany> preLogisticsCompanyMap, List<BizLogInfo> insertLogList) {
        BizLogInfo bizLogInfo;
        PsStoreLogisticsCompany preLogisticsCompany = preLogisticsCompanyMap.get(id);
        if (preLogisticsCompany == null) {
            return;
        }
        if (!preLogisticsCompany.getIsMallDisplay().equals(logisticsCompany.getIsMallDisplay())) {
            bizLogInfo = new BizLogInfo();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
            bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
            bizLogInfo.setOperateDataId(store.getId());
            bizLogInfo.setOperateTypeCode("UPDATE");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u66f4\u6539");
            bizLogInfo.setOperateTableDesc("ITEM_UPDATE");
            bizLogInfo.setBeforeUpdateValue(logisticsCompany.getIsMallDisplay().toString());
            bizLogInfo.setBeforeUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)logisticsCompany.getIsMallDisplay()));
            bizLogInfo.setAfterUpdateValue(preLogisticsCompany.getIsMallDisplay().toString());
            bizLogInfo.setAfterUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)preLogisticsCompany.getIsMallDisplay()));
            bizLogInfo.setOperateTableName("ps_store");
            bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + logisticsCompany.getId());
            bizLogInfo.setOperateColumnName("is_mall_display");
            bizLogInfo.setOperateColumnDesc(logisticsCompany.getMdmLogisticsCompanyTypeName() + "\u662f\u5426\u5728\u5546\u57ce\u663e\u793a");
            insertLogList.add(bizLogInfo);
        }
        if (!preLogisticsCompany.getIsDefault().equals(logisticsCompany.getIsDefault())) {
            bizLogInfo = new BizLogInfo();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
            bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
            bizLogInfo.setOperateDataId(store.getId());
            bizLogInfo.setOperateTypeCode("UPDATE");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u66f4\u6539");
            bizLogInfo.setOperateTableDesc("ITEM_UPDATE");
            bizLogInfo.setBeforeUpdateValue(logisticsCompany.getIsDefault().toString());
            bizLogInfo.setBeforeUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)logisticsCompany.getIsDefault()));
            bizLogInfo.setAfterUpdateValue(preLogisticsCompany.getIsDefault().toString());
            bizLogInfo.setAfterUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)preLogisticsCompany.getIsDefault()));
            bizLogInfo.setOperateTableName("ps_store");
            bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + logisticsCompany.getId());
            bizLogInfo.setOperateColumnName("is_default");
            bizLogInfo.setOperateColumnDesc(logisticsCompany.getMdmLogisticsCompanyTypeName() + "\u662f\u5426\u9ed8\u8ba4");
            insertLogList.add(bizLogInfo);
        }
        if (!Objects.equals(logisticsCompany.getFreeShippingAmount(), preLogisticsCompany.getFreeShippingAmount())) {
            bizLogInfo = new BizLogInfo();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
            bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
            bizLogInfo.setOperateDataId(store.getId());
            bizLogInfo.setOperateTypeCode("UPDATE");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u66f4\u6539");
            bizLogInfo.setOperateTableDesc("ITEM_UPDATE");
            String freeShippingAmount = Objects.nonNull(logisticsCompany.getFreeShippingAmount()) ? logisticsCompany.getFreeShippingAmount().toString() : "";
            bizLogInfo.setBeforeUpdateValue(freeShippingAmount);
            bizLogInfo.setBeforeUpdateValueDesc(freeShippingAmount);
            String preFreeShippingAmount = Objects.nonNull(preLogisticsCompany.getFreeShippingAmount()) ? preLogisticsCompany.getFreeShippingAmount().toString() : "";
            bizLogInfo.setAfterUpdateValue(preFreeShippingAmount);
            bizLogInfo.setAfterUpdateValueDesc(preFreeShippingAmount);
            bizLogInfo.setOperateTableName("ps_store");
            bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + logisticsCompany.getId());
            bizLogInfo.setOperateColumnName("free_shipping_amount");
            bizLogInfo.setOperateColumnDesc(logisticsCompany.getMdmLogisticsCompanyTypeName() + "\u5305\u90ae\u91d1\u989d");
            insertLogList.add(bizLogInfo);
        }
        if (!Objects.equals(logisticsCompany.getLogisticsCompanyAlias(), preLogisticsCompany.getLogisticsCompanyAlias())) {
            bizLogInfo = new BizLogInfo();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
            bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
            bizLogInfo.setOperateDataId(store.getId());
            bizLogInfo.setOperateTypeCode("UPDATE");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u66f4\u6539");
            bizLogInfo.setOperateTableDesc("ITEM_UPDATE");
            bizLogInfo.setBeforeUpdateValue(logisticsCompany.getLogisticsCompanyAlias());
            bizLogInfo.setBeforeUpdateValueDesc(logisticsCompany.getLogisticsCompanyAlias());
            bizLogInfo.setAfterUpdateValue(preLogisticsCompany.getLogisticsCompanyAlias());
            bizLogInfo.setAfterUpdateValueDesc(preLogisticsCompany.getLogisticsCompanyAlias());
            bizLogInfo.setOperateTableName("ps_store");
            bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + logisticsCompany.getId());
            bizLogInfo.setOperateColumnName("logistics_company_alias");
            bizLogInfo.setOperateColumnDesc(preLogisticsCompany.getMdmLogisticsCompanyTypeName() + "\u522b\u540d");
            insertLogList.add(bizLogInfo);
        }
    }

    private void getLogisticCompanyInsertLog(Store store, Map<Long, PsStoreLogisticsCompany> preLogisticsCompanyMap, List<Long> insertIds, List<BizLogInfo> insertLogList) {
        if (CollUtil.isNotEmpty(insertIds)) {
            for (Long insertId : insertIds) {
                PsStoreLogisticsCompany preLogisticsCompany = preLogisticsCompanyMap.get(insertId);
                BizLogInfo bizLogInfo = new BizLogInfo();
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
                bizLogInfo.setId(this.idSequenceGenerator.generateId("ps_log"));
                bizLogInfo.setOperateDataId(store.getId());
                bizLogInfo.setOperateTypeCode("ITEM_INSERT");
                bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u65b0\u589e");
                bizLogInfo.setBeforeUpdateValue("");
                bizLogInfo.setBeforeUpdateValueDesc("");
                bizLogInfo.setAfterUpdateValue(preLogisticsCompany.getIsMallDisplay().toString());
                bizLogInfo.setAfterUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)preLogisticsCompany.getIsMallDisplay()));
                bizLogInfo.setOperateTableName("ps_store");
                bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + preLogisticsCompany.getId());
                bizLogInfo.setOperateColumnName("is_mall_display");
                bizLogInfo.setOperateColumnDesc(preLogisticsCompany.getMdmLogisticsCompanyTypeName() + "\u662f\u5426\u5728\u5546\u57ce\u663e\u793a");
                insertLogList.add(bizLogInfo);
                BizLogInfo bizLogInfoDefault = new BizLogInfo();
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfoDefault);
                bizLogInfoDefault.setId(this.idSequenceGenerator.generateId("ps_log"));
                bizLogInfoDefault.setOperateDataId(store.getId());
                bizLogInfoDefault.setOperateTypeCode("ITEM_INSERT");
                bizLogInfoDefault.setOperateTypeDesc("\u660e\u7ec6\u65b0\u589e");
                bizLogInfoDefault.setBeforeUpdateValue("");
                bizLogInfoDefault.setBeforeUpdateValueDesc("");
                bizLogInfoDefault.setAfterUpdateValue(preLogisticsCompany.getIsDefault().toString());
                bizLogInfoDefault.setAfterUpdateValueDesc(YesOrNoEnum.getDescByCode((Integer)preLogisticsCompany.getIsDefault()));
                bizLogInfoDefault.setOperateTableName("ps_store");
                bizLogInfoDefault.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + preLogisticsCompany.getId());
                bizLogInfoDefault.setOperateColumnName("is_default");
                bizLogInfoDefault.setOperateColumnDesc(preLogisticsCompany.getMdmLogisticsCompanyTypeName() + "\u662f\u5426\u9ed8\u8ba4");
                insertLogList.add(bizLogInfoDefault);
                BizLogInfo bizLogInfoFreeShippingAmount = new BizLogInfo();
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfoFreeShippingAmount);
                bizLogInfoFreeShippingAmount.setId(this.idSequenceGenerator.generateId("ps_log"));
                bizLogInfoFreeShippingAmount.setOperateDataId(store.getId());
                bizLogInfoFreeShippingAmount.setOperateTypeCode("ITEM_INSERT");
                bizLogInfoFreeShippingAmount.setOperateTypeDesc("\u660e\u7ec6\u65b0\u589e");
                bizLogInfoFreeShippingAmount.setBeforeUpdateValue("");
                bizLogInfoFreeShippingAmount.setBeforeUpdateValueDesc("");
                String freeShippingAmount = Objects.nonNull(preLogisticsCompany.getFreeShippingAmount()) ? preLogisticsCompany.getFreeShippingAmount().toString() : "";
                bizLogInfoFreeShippingAmount.setAfterUpdateValue(freeShippingAmount);
                bizLogInfoFreeShippingAmount.setAfterUpdateValueDesc(freeShippingAmount);
                bizLogInfoFreeShippingAmount.setOperateTableName("ps_store");
                bizLogInfoFreeShippingAmount.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + preLogisticsCompany.getId());
                bizLogInfoFreeShippingAmount.setOperateColumnName("free_shipping_amount");
                bizLogInfoFreeShippingAmount.setOperateColumnDesc(preLogisticsCompany.getMdmLogisticsCompanyTypeName() + "\u5305\u90ae\u91d1\u989d");
                insertLogList.add(bizLogInfoFreeShippingAmount);
                if (!StringUtils.isNotBlank((CharSequence)preLogisticsCompany.getLogisticsCompanyAlias())) continue;
                BizLogInfo bizLogALias = new BizLogInfo();
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogALias);
                bizLogALias.setId(this.idSequenceGenerator.generateId("ps_log"));
                bizLogALias.setOperateDataId(store.getId());
                bizLogALias.setOperateTypeCode("ITEM_INSERT");
                bizLogALias.setOperateTypeDesc("\u660e\u7ec6\u65b0\u589e");
                bizLogALias.setBeforeUpdateValue("");
                bizLogALias.setBeforeUpdateValueDesc("");
                bizLogALias.setAfterUpdateValue(preLogisticsCompany.getLogisticsCompanyAlias());
                bizLogALias.setAfterUpdateValueDesc(preLogisticsCompany.getLogisticsCompanyAlias());
                bizLogALias.setOperateTableName("ps_store");
                bizLogALias.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u7269\u6d41\u516c\u53f8id:" + preLogisticsCompany.getId());
                bizLogALias.setOperateColumnName("logistics_company_alias");
                bizLogALias.setOperateColumnDesc(preLogisticsCompany.getMdmLogisticsCompanyTypeName() + "\u522b\u540d");
                insertLogList.add(bizLogALias);
            }
        }
    }

    private List<PsStoreLogisticsCompany> buildLogisticCompanySaveEntity(StoreDTO dto, Long storeId) {
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.FORE.getCode(), (CharSequence)dto.getShelfConfig()) || StrUtil.equals((CharSequence)StoreShelfConfigEnum.THERE.getCode(), (CharSequence)dto.getShelfConfig())) {
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)dto.getPcLogisticCompanyList()), (String)"\u672a\u8bbe\u7f6e\u6279\u91c7\u8fd0\u8d39\u914d\u7f6e");
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)dto.getDfLogisticCompanyList()), (String)"\u672a\u8bbe\u7f6e\u4ee3\u53d1\u8fd0\u8d39\u914d\u7f6e");
        } else if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.ONE.getCode(), (CharSequence)dto.getShelfConfig())) {
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)dto.getPcLogisticCompanyList()), (String)"\u672a\u8bbe\u7f6e\u6279\u91c7\u8fd0\u8d39\u914d\u7f6e");
        } else if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.TWO.getCode(), (CharSequence)dto.getShelfConfig())) {
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)dto.getDfLogisticCompanyList()), (String)"\u672a\u8bbe\u7f6e\u4ee3\u53d1\u8fd0\u8d39\u914d\u7f6e");
        }
        List<PsStoreLogisticsCompany> logisticCompanyList = this.getPsStoreLogisticsCompaniesSaveDto(storeId, dto.getPcLogisticCompanyList(), SupplyPriceTypeEnums.ONE.getCode());
        logisticCompanyList.addAll(this.getPsStoreLogisticsCompaniesSaveDto(storeId, dto.getDfLogisticCompanyList(), SupplyPriceTypeEnums.TWO.getCode()));
        return logisticCompanyList;
    }

    public String getPurchaseModePrefix(String purchaseMode) {
        return "\u7269\u6d41\u516c\u53f8-" + SupplyPriceTypeEnums.getDescByCode((String)purchaseMode) + "-";
    }

    private List<PsStoreLogisticsCompany> getPsStoreLogisticsCompaniesSaveDto(Long storeId, List<StoreLogisticCompanyDTO> pcLogisticCompanyDtoList, String purchaseMode) {
        ArrayList logisticCompanyList = CollUtil.newArrayList((Object[])new PsStoreLogisticsCompany[0]);
        if (CollUtil.isEmpty(pcLogisticCompanyDtoList)) {
            return logisticCompanyList;
        }
        this.checkLogisticCompany(pcLogisticCompanyDtoList);
        if (CollUtil.isNotEmpty(pcLogisticCompanyDtoList)) {
            for (StoreLogisticCompanyDTO logisticsCompanyDto : pcLogisticCompanyDtoList) {
                List platformDtoList = logisticsCompanyDto.getPlatformList();
                this.checkLogisticCompanyPlatform(logisticsCompanyDto, platformDtoList);
                PsStoreLogisticsCompany logisticsCompany = new PsStoreLogisticsCompany();
                BeanUtils.copyProperties((Object)logisticsCompanyDto, (Object)logisticsCompany);
                if (ObjectUtils.isEmpty((Object)logisticsCompanyDto.getId())) {
                    logisticsCompany.setId(this.idSequence.generateId(PsStoreLogisticsCompany.class));
                    logisticsCompany.setPsStoreId(storeId);
                    logisticsCompany.setPurchaseMode(Integer.valueOf(purchaseMode));
                    this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)logisticsCompany);
                } else {
                    this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)logisticsCompany);
                }
                String mdmLogisticsCompanyName = this.getPurchaseModePrefix(purchaseMode) + logisticsCompanyDto.getMdmLogisticsCompanyTypeName();
                logisticCompanyList.add(logisticsCompany);
                ArrayList platformList = CollUtil.newArrayList((Object[])new PsStoreLogisticsCompanyPlatform[0]);
                platformDtoList.removeIf(it -> Objects.isNull(it.getMdmPlatformId()) || Long.valueOf(-1L).equals(it.getMdmPlatformId()));
                for (StoreLogisticsCompanyPlatformDTO storeLogisticsCompanyPlatformDTO : platformDtoList) {
                    PsStoreLogisticsCompanyPlatform platform = new PsStoreLogisticsCompanyPlatform();
                    BeanUtils.copyProperties((Object)storeLogisticsCompanyPlatformDTO, (Object)platform);
                    if (ObjectUtils.isEmpty((Object)storeLogisticsCompanyPlatformDTO.getId())) {
                        platform.setId(this.idSequence.generateId(PsStoreLogisticsCompanyPlatform.class));
                        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)platform);
                    } else {
                        this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)platform);
                    }
                    platform.setPsStoreId(storeId);
                    platform.setPsStoreLogisticCompanyId(logisticsCompany.getId());
                    platform.setMdmLogisticsCompanyId(storeLogisticsCompanyPlatformDTO.getLogisticsCompanyId());
                    platform.setMdmPlatformName(mdmLogisticsCompanyName + "_" + platform.getMdmPlatformName());
                    platformList.add(platform);
                }
                String platformRel = platformDtoList.stream().map(StoreLogisticsCompanyPlatformDTO::getMdmPlatformName).collect(Collectors.joining("\u3001"));
                logisticsCompany.setMdmLogisticsCompanyTypeName(mdmLogisticsCompanyName);
                logisticsCompany.setTransportName(mdmLogisticsCompanyName + "_" + logisticsCompanyDto.getTransportName());
                logisticsCompany.setPlatformInfoRel(mdmLogisticsCompanyName + "_" + platformRel);
                logisticsCompany.setPlatformList((List)platformList);
            }
        }
        return logisticCompanyList;
    }

    private void checkLogisticCompany(List<StoreLogisticCompanyDTO> pcLogisticCompanyDtoList) {
        long logisticsCompanyCount = pcLogisticCompanyDtoList.stream().map(StoreLogisticCompanyDTO::getMdmLogisticsCompanyTypeId).distinct().count();
        Assert.isTrue((logisticsCompanyCount == (long)pcLogisticCompanyDtoList.size() ? 1 : 0) != 0, (String)"\u540c\u4e00\u6240\u5c5e\u5e97\u94fa\u3001\u540c\u4e00\u7269\u6d41\u516c\u53f8\uff08\u6279\u91c7/\u4ee3\u53d1\uff09\u4e0b\uff0c\u7269\u6d41\u516c\u53f8\u552f\u4e00");
        pcLogisticCompanyDtoList.stream().collect(Collectors.groupingBy(StoreLogisticCompanyDTO::getTransportId)).forEach((k, v) -> {
            long defaultCount = v.stream().filter(o -> FcCommonEnum.YesOrNoEnum.YES.getValue().equals(o.getIsDefault())).count();
            Assert.isTrue((defaultCount <= 1L ? 1 : 0) != 0, (String)"\u540c\u4e00\u6240\u5c5e\u5e97\u94fa\u3001\u540c\u4e00\u8fd0\u8d39\u6a21\u677f\u4e0b\uff0c\u53ea\u80fd\u6709\u4e00\u6761\u9ed8\u8ba4\u7684\u7269\u6d41\u516c\u53f8\u8bb0\u5f55");
        });
        long showCount = pcLogisticCompanyDtoList.stream().filter(o -> FcCommonEnum.YesOrNoEnum.YES.getValue().equals(o.getIsMallDisplay()) && FcCommonEnum.YesOrNoEnum.YES.getValue().equals(o.getIsDefault())).count();
        Assert.isTrue((showCount > 0L ? 1 : 0) != 0, (String)"\u6700\u5c11\u8981\u6709\u4e00\u6761\u3010\u662f\u5426\u5728\u5546\u57ce\u663e\u793a = \u662f\u3011\u7684\u9ed8\u8ba4\u7269\u6d41\u516c\u53f8\u8bb0\u5f55");
        ArrayList aliasList = Lists.newArrayList();
        aliasList.addAll(pcLogisticCompanyDtoList.stream().map(StoreLogisticCompanyDTO::getLogisticsCompanyAlias).filter(one -> StringUtil.isNotBlank(one)).collect(Collectors.toList()));
        Map<String, Long> frequencyMap = aliasList.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting()));
        List duplicates = frequencyMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        Assert.isTrue((boolean)CollUtil.isEmpty(duplicates), (String)("\u3010" + String.join((CharSequence)"\u3001", duplicates) + "\u3011 \u540c\u4e00\u7269\u6d41\u516c\u53f8\u4e0b\uff0c\u7269\u6d41\u516c\u53f8\u522b\u540d\u552f\u4e00"));
    }

    private void checkLogisticCompanyPlatform(StoreLogisticCompanyDTO logisticsCompanyDto, List<StoreLogisticsCompanyPlatformDTO> platformDtoList) {
        long platformCount = platformDtoList.stream().map(StoreLogisticsCompanyPlatformDTO::getMdmPlatformId).distinct().count();
        Assert.isTrue((platformCount == (long)platformDtoList.size() ? 1 : 0) != 0, (String)"\u540c\u4e00\u7269\u6d41\u516c\u53f8\u4e0b\uff0c\u5bf9\u5e94\u5e73\u53f0\u552f\u4e00");
        if (FcCommonEnum.YesOrNoEnum.YES.getValue().equals(logisticsCompanyDto.getIsMallDisplay())) {
            long showPlatformCount = platformDtoList.stream().filter(o -> FcCommonEnum.YesOrNoEnum.YES.getValue().equals(o.getIsMallDisplay())).count();
            PsStoreLogisticsCompany psStoreLogisticsCompany = new PsStoreLogisticsCompany();
        }
    }

    private List<Map<String, Object>> getList(String ids, String names) {
        if (StringUtils.isEmpty((CharSequence)ids) && StringUtils.isEmpty((CharSequence)names)) {
            return new LinkedList<Map<String, Object>>();
        }
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        List<String> idList = Arrays.asList(ids.split(","));
        List<String> nameList = Arrays.asList(names.split(","));
        if (ObjectUtils.isNotEmpty((Object)names)) {
            for (int i = 0; i < idList.size(); ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (StringUtils.isNotBlank((CharSequence)ids)) {
                    map.put("id", Integer.parseInt(idList.get(i)));
                }
                map.put("name", nameList.get(i));
                list.add(map);
            }
        }
        return list;
    }

    @LogAnnotation
    public void generateMenu(StoreDTO dto) {
        Long storeId = this.saveStore(dto);
        Store store = (Store)this.storeService.getById((Serializable)storeId);
        ArrayList psSceneList = CollUtil.newArrayList((Object[])new PsScene[0]);
        ArrayList sceneCodeList = CollUtil.newArrayList((Object[])new String[0]);
        PsScene pcScene = new PsScene();
        PsScene dfScene = new PsScene();
        PsScene psScene = new PsScene();
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.ONE.getCode(), (CharSequence)dto.getShelfConfig())) {
            pcScene = this.psSceneBiz.covertSave(store.getName() + "-\u6279\u91c7\u573a\u666f");
            psSceneList.add(pcScene);
            sceneCodeList.add(pcScene.getCode());
        }
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.TWO.getCode(), (CharSequence)dto.getShelfConfig())) {
            dfScene = this.psSceneBiz.covertSave(store.getName() + "-\u4e00\u4ef6\u4ee3\u53d1\u573a\u666f");
            psSceneList.add(dfScene);
            sceneCodeList.add(dfScene.getCode());
        }
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.THERE.getCode(), (CharSequence)dto.getShelfConfig())) {
            pcScene = this.psSceneBiz.covertSave(store.getName() + "-\u6279\u91c7\u573a\u666f");
            psSceneList.add(pcScene);
            sceneCodeList.add(pcScene.getCode());
            dfScene = this.psSceneBiz.covertSave(store.getName() + "-\u4e00\u4ef6\u4ee3\u53d1\u573a\u666f");
            psSceneList.add(dfScene);
            sceneCodeList.add(dfScene.getCode());
        }
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.FORE.getCode(), (CharSequence)dto.getShelfConfig())) {
            psScene = this.psSceneBiz.covertSave(store.getName() + "-\u6279\u91c7&\u4ee3\u53d1\u573a\u666f");
            psSceneList.add(psScene);
            sceneCodeList.add(psScene.getCode());
        }
        List<Object> removeSceneCode = CollUtil.newArrayList((Object[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)store.getPsSceneCode())) {
            removeSceneCode = Arrays.asList(store.getPsSceneCode().split(","));
        }
        store.setPsSceneCode(String.join((CharSequence)",", sceneCodeList));
        this.storeService.updateScene(store, (List)psSceneList, (List)removeSceneCode);
        String name = store.getName();
        if (StrUtil.isNotBlank((CharSequence)store.getMenuName())) {
            name = store.getMenuName();
        }
        BizMenuDTO pcBizMenuDTO = new BizMenuDTO();
        pcBizMenuDTO.setMenuName(name + "-\u6279\u91c7\u5546\u54c1");
        BizMenuDTO dfBizMenuDTO = new BizMenuDTO();
        dfBizMenuDTO.setMenuName(name + "-\u4ee3\u53d1\u5546\u54c1");
        BizMenuDTO pdBizMenuDTO = new BizMenuDTO();
        pdBizMenuDTO.setMenuName(name + "\u5546\u54c1(\u6279\u91c7&\u4ee3\u53d1)");
        String pcName = store.getName() + "-\u6279\u91c7\u5546\u54c1";
        String dfName = store.getName() + "-\u4ee3\u53d1\u5546\u54c1";
        String pdName = store.getName() + "\u5546\u54c1(\u6279\u91c7&\u4ee3\u53d1)";
        ArrayList bizMenuDTOS = CollUtil.newArrayList((Object[])new BizMenuDTO[]{pcBizMenuDTO, dfBizMenuDTO, pdBizMenuDTO});
        MenuRespDTO menuRespDTO = this.scAdapter.selectBizMenu(bizMenuDTOS);
        Map menuMap = menuRespDTO.getMenuMap();
        ArrayList bizMenuList = CollUtil.newArrayList((Object[])new BizMenuDTO[0]);
        this.getMenu(store, pcScene.getCode(), pcBizMenuDTO, menuMap, bizMenuList, SupplyPriceTypeEnums.ONE.getCode());
        this.getMenu(store, dfScene.getCode(), dfBizMenuDTO, menuMap, bizMenuList, SupplyPriceTypeEnums.TWO.getCode());
        this.getMenu(store, psScene.getCode(), pdBizMenuDTO, menuMap, bizMenuList, null);
        if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.ONE.getCode(), (CharSequence)dto.getShelfConfig())) {
            this.getCovertSaveMenu(store, pcScene.getCode(), pcName, menuMap, bizMenuList, SupplyPriceTypeEnums.ONE.getCode());
        } else if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.TWO.getCode(), (CharSequence)dto.getShelfConfig())) {
            this.getCovertSaveMenu(store, dfScene.getCode(), dfName, menuMap, bizMenuList, SupplyPriceTypeEnums.TWO.getCode());
        } else if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.THERE.getCode(), (CharSequence)dto.getShelfConfig())) {
            this.getCovertSaveMenu(store, pcScene.getCode(), pcName, menuMap, bizMenuList, SupplyPriceTypeEnums.ONE.getCode());
            this.getCovertSaveMenu(store, dfScene.getCode(), dfName, menuMap, bizMenuList, SupplyPriceTypeEnums.TWO.getCode());
        } else if (StrUtil.equals((CharSequence)StoreShelfConfigEnum.FORE.getCode(), (CharSequence)dto.getShelfConfig())) {
            this.getCovertSaveMenu(store, psScene.getCode(), pdName, menuMap, bizMenuList, null);
        }
        this.scAdapter.createBizMenu(bizMenuList);
        store.setMenuName(store.getName());
        store.setIsInitializingGoods(YesOrNoEnum.YES.getCode());
        this.storeService.updateById((Object)store);
        InnerLog.addLog((Long)store.getId(), (String)"\u521d\u59cb\u5316\u5e97\u94fa", (String)"ps_store", (String)"", (String)"\u521d\u59cb\u5316\u5e97\u94fa");
    }

    private void getCovertSaveMenu(Store store, String sceneCode, String menuName, Map<String, List<MenuRespDTO.Menu>> menuMap, List<BizMenuDTO> bizMenuList, String supplyPriceType) {
        BizMenuDTO bizMenuDTO = new BizMenuDTO();
        bizMenuDTO.setMenuName(menuName);
        bizMenuDTO.setMenuType("shelve");
        bizMenuDTO.setOperateType(OperateType.INSERT);
        MenuDTO menuDTO = this.covert(store.getId(), store.getStoreType(), supplyPriceType, sceneCode);
        bizMenuDTO.setMenuConfig(JSON.toJSONString((Object)menuDTO));
        bizMenuList.add(bizMenuDTO);
    }

    private void getMenu(Store store, String sceneCode, BizMenuDTO menuName, Map<String, List<MenuRespDTO.Menu>> menuMap, List<BizMenuDTO> bizMenuList, String supplyPriceType) {
        List<MenuRespDTO.Menu> menus = menuMap.get(menuName.getMenuName());
        if (CollUtil.isNotEmpty(menus)) {
            MenuRespDTO.Menu menu = menus.get(0);
            BizMenuDTO bizMenuDTO = new BizMenuDTO();
            bizMenuDTO.setId(menu.getId());
            bizMenuDTO.setMenuName(menuName.getMenuName());
            bizMenuDTO.setOperateType(OperateType.UPDATE);
            bizMenuDTO.setIsDelete(IsDeleteEnums.YES.getCode());
            bizMenuDTO.setMenuType("shelve");
            MenuDTO dto = this.covert(store.getId(), store.getStoreType(), supplyPriceType, sceneCode);
            bizMenuDTO.setMenuConfig(JSON.toJSONString((Object)dto));
            bizMenuList.add(bizMenuDTO);
        }
    }

    private MenuDTO covert(Long storeId, String psStoreType, String psSkuSupplyPriceType, String sceneCode) {
        MenuDTO menuDTO = new MenuDTO();
        MenuDTO.Props props = new MenuDTO.Props();
        props.setPsStoreId(storeId);
        props.setPsSkuSupplyPriceType(psSkuSupplyPriceType);
        props.setSceneCode(sceneCode);
        if (StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)psStoreType)) {
            props.setPsStoreType("inside");
        }
        if (StrUtil.equals((CharSequence)StoreTypeEnum.TWO.getCode(), (CharSequence)psStoreType)) {
            props.setPsStoreType("self");
        }
        if (StrUtil.equals((CharSequence)StoreTypeEnum.THERE.getCode(), (CharSequence)psStoreType)) {
            props.setPsStoreType("unSelf");
        }
        menuDTO.setProps(props);
        return menuDTO;
    }

    public PsStoreVO getById(StoreDTO dto) {
        Store store = (Store)this.storeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(dto.getId() != null, BaseDo::getId, (Object)dto.getId())).eq(StringUtils.isNotBlank((CharSequence)dto.getWxAppId()), Store::getWxAppId, (Object)AesUtil.encryptMysql((String)dto.getWxAppId(), (String)this.encryptConfig.getKey()))).eq(StringUtils.isNotBlank((CharSequence)dto.getAliAppId()), Store::getAliAppId, (Object)AesUtil.encryptMysql((String)dto.getAliAppId(), (String)this.encryptConfig.getKey())), false);
        PsStoreVO storeVO = new PsStoreVO();
        if (ObjectUtils.isNotEmpty((Object)store)) {
            BeanUtils.copyProperties((Object)store, (Object)storeVO);
            if (ObjectUtils.isNotEmpty((Object)store.getCusCustomerId())) {
                CustomerVO customerVO = this.cusAdapter.queryCustomerById(store.getCusCustomerId());
                storeVO.setCusCustomerName(customerVO.getCustomerName());
            }
            storeVO.setAvailableInventoryProportion(BigDecimalUtils.getValue(storeVO.getAvailableInventoryProportion()));
            storeVO.setWholesaleInventoryList(this.getList(store.getWholesaleInventoryIds(), store.getWholesaleInventoryNames()));
            storeVO.setIssuingInventoryList(this.getList(store.getIssuingInventoryIds(), store.getIssuingInventoryNames()));
            storeVO.setPcLogicList(this.getList(store.getPcLogicIds(), store.getPcLogicNames()));
            storeVO.setDfLogicList(this.getList(store.getDfLogicIds(), store.getDfLogicNames()));
            storeVO.setPayTypeSwitchVOList(this.payTypeSwitchBiz.getStorePayTypeSwitchVOList(store.getId(), dto.getIsPc()));
        }
        return this.getStorePlatFrom(store, storeVO);
    }

    public List<PsStoreLogisticsCompany> getLogisticsCompanyList(List<Long> storeIds, Integer purchaseMode, Integer isMallDisplay, Integer isDefault, Integer noPlatform, Long mdmLogisticsCompanyTypeId) {
        if (CollUtil.isEmpty(storeIds)) {
            return Lists.newArrayList();
        }
        List logisticCompanyList = this.psStoreLogisticsCompanyService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(PsStoreLogisticsCompany::getPsStoreId, storeIds)).eq(Objects.nonNull(purchaseMode), PsStoreLogisticsCompany::getPurchaseMode, (Object)purchaseMode)).eq(Objects.nonNull(isMallDisplay), PsStoreLogisticsCompany::getIsMallDisplay, (Object)isMallDisplay)).eq(Objects.nonNull(isDefault), PsStoreLogisticsCompany::getIsDefault, (Object)isDefault)).eq(Objects.nonNull(mdmLogisticsCompanyTypeId), PsStoreLogisticsCompany::getMdmLogisticsCompanyTypeId, (Object)mdmLogisticsCompanyTypeId));
        if (CollUtil.isEmpty((Collection)logisticCompanyList)) {
            return logisticCompanyList;
        }
        List companyIds = logisticCompanyList.stream().map(BaseDo::getId).collect(Collectors.toList());
        List platformList = FcCommonEnum.YesOrNoEnum.YES.getValue().equals(noPlatform) ? Lists.newArrayList() : this.psStoreLogisticsCompanyPlatformService.getPlatformListByCompanyIds(companyIds, isMallDisplay);
        Map<Long, List<PsStoreLogisticsCompanyPlatform>> companyIdPlatformListMap = platformList.stream().collect(Collectors.groupingBy(PsStoreLogisticsCompanyPlatform::getPsStoreLogisticCompanyId));
        logisticCompanyList.forEach(psStoreLogisticsCompany -> {
            if (!FcCommonEnum.YesOrNoEnum.YES.getValue().equals(isMallDisplay)) {
                psStoreLogisticsCompany.setPlatformList((List)CollUtil.newArrayList((Object[])new PsStoreLogisticsCompanyPlatform[]{PsStoreLogisticsCompanyPlatform.noChoosePlatform()}));
            }
            if (CollUtil.isEmpty((Collection)psStoreLogisticsCompany.getPlatformList())) {
                psStoreLogisticsCompany.setPlatformList((List)Lists.newArrayList());
            }
            psStoreLogisticsCompany.getPlatformList().addAll(companyIdPlatformListMap.getOrDefault(psStoreLogisticsCompany.getId(), Lists.newArrayList()));
        });
        return logisticCompanyList;
    }

    private PsStoreVO getStorePlatFrom(Store store, PsStoreVO storeVO) {
        PsStorePlatform storePlatform = (PsStorePlatform)this.psStorePlatformService.getOne((Wrapper)new QueryWrapper().lambda().eq(PsStorePlatform::getPsStoreId, (Object)store.getId()));
        if (storePlatform != null) {
            storeVO.setCusId(storePlatform.getCusId());
            storeVO.setCusIdStr(StringUtil.desensitized(storePlatform.getCusId(), 2, 2, "*"));
            storeVO.setAppId(storePlatform.getAppId());
            storeVO.setAppIdStr(StringUtil.desensitized(storePlatform.getAppId(), 2, 2, "*"));
            storeVO.setPrivateKey(storePlatform.getPrivateKey());
            storeVO.setPrivateKeyStr("******");
            storeVO.setPublicKey(storePlatform.getPublicKey());
            storeVO.setPublicKeyStr("******");
            storeVO.setPlatformApiUrl(storePlatform.getPlatformApiUrl());
            storeVO.setNotifyUrl(storePlatform.getNotifyUrl());
            storeVO.setReturnUrl(storePlatform.getReturnUrl());
            storeVO.setPlatformWxAppId(storePlatform.getPlatformWxAppId());
            storeVO.setPlatformWxAppIdStr(StringUtil.desensitized(storePlatform.getPlatformWxAppId(), 2, 2, "*"));
        }
        List psStorePlatformAccounts = this.psStorePlatformAccountService.list((Wrapper)new QueryWrapper().lambda().eq(PsStorePlatformAccount::getPsStoreId, (Object)store.getId()));
        List<Object> psStorePlatformAccountVOS = CollUtil.newArrayList((Object[])new PsStorePlatformAccountVO[0]);
        if (CollUtil.isNotEmpty((Collection)psStorePlatformAccounts)) {
            psStorePlatformAccountVOS = BeanConvertUtil.convertList(psStorePlatformAccounts, PsStorePlatformAccountVO.class);
            for (PsStorePlatformAccountVO psStorePlatformAccountVO : psStorePlatformAccountVOS) {
                psStorePlatformAccountVO.setAccountStr(StringUtil.desensitized(psStorePlatformAccountVO.getAccount(), 2, 2, "*"));
            }
        }
        storeVO.setStorePlatformAccountList((List)psStorePlatformAccountVOS);
        return storeVO;
    }

    public PsStoreVO getStoreById(StoreDTO dto) {
        Store store = (Store)this.storeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(dto.getId() != null, BaseDo::getId, (Object)dto.getId())).eq(StringUtils.isNotBlank((CharSequence)dto.getWxAppId()), Store::getWxAppId, (Object)AesUtil.encryptMysql((String)dto.getWxAppId(), (String)this.encryptConfig.getKey()))).eq(StringUtils.isNotBlank((CharSequence)dto.getAliAppId()), Store::getAliAppId, (Object)AesUtil.encryptMysql((String)dto.getAliAppId(), (String)this.encryptConfig.getKey())), false);
        PsStoreVO storeVO = new PsStoreVO();
        if (ObjectUtils.isNotEmpty((Object)store)) {
            BeanUtils.copyProperties((Object)store, (Object)storeVO);
            if (ObjectUtils.isNotEmpty((Object)store.getCusCustomerId())) {
                CustomerVO customerVO = this.cusAdapter.queryCustomerById(store.getCusCustomerId());
                storeVO.setCusCustomerName(customerVO.getCustomerName());
            }
            storeVO.setAvailableInventoryProportion(BigDecimalUtils.getValue(storeVO.getAvailableInventoryProportion()));
            storeVO.setWholesaleInventoryList(this.getList(store.getWholesaleInventoryIds(), store.getWholesaleInventoryNames()));
            storeVO.setIssuingInventoryList(this.getList(store.getIssuingInventoryIds(), store.getIssuingInventoryNames()));
            storeVO.setPcLogicList(this.getList(store.getPcLogicIds(), store.getPcLogicNames()));
            storeVO.setDfLogicList(this.getList(store.getDfLogicIds(), store.getDfLogicNames()));
        }
        storeVO.setWxAppIdStr(StringUtil.desensitized(storeVO.getWxAppId(), 2, 2, "*"));
        storeVO.setWxAppSecretStr(StringUtil.desensitized(storeVO.getWxAppSecret(), 2, 2, "*"));
        storeVO.setWxMchIdStr(StringUtil.desensitized(storeVO.getWxMchId(), 2, 2, "*"));
        storeVO.setWxCertUrlStr(StringUtil.desensitized(storeVO.getWxCertUrlStr(), 2, 2, "*"));
        storeVO.setWxMerchantSerialNumberStr(StringUtil.desensitized(storeVO.getWxMerchantSerialNumber(), 2, 2, "*"));
        storeVO.setWxApiV3KeyStr(StringUtil.desensitized(storeVO.getWxApiV3Key(), 2, 2, "*"));
        storeVO.setAliAppIdStr(StringUtil.desensitized(storeVO.getAliAppId(), 2, 2, "*"));
        storeVO.setAliPrivateKeyStr("******");
        storeVO.setAliPublicKeyStr("******");
        storeVO.setWxAccountStr(StringUtil.desensitized(storeVO.getWxAccount(), 2, 2, "*"));
        storeVO.setAliAccountStr(StringUtil.desensitized(storeVO.getAliAccount(), 2, 2, "*"));
        storeVO.setBrandDirectorPhoneStr(StringUtil.desensitized(storeVO.getBrandDirectorPhone(), 2, 2, "*"));
        List<StoreLogisticCompanyVO> storeLogisticCompanyVOS = this.getStoreLogisticCompanyVOS(store.getId());
        Map<Integer, List<StoreLogisticCompanyVO>> purchaseLogisticCompanyListMap = storeLogisticCompanyVOS.stream().collect(Collectors.groupingBy(StoreLogisticCompanyVO::getPurchaseMode));
        List<StoreLogisticCompanyVO> pcStoreLogisticsCompanies = purchaseLogisticCompanyListMap.getOrDefault(Integer.valueOf(SupplyPriceTypeEnums.ONE.getCode()), Lists.newArrayList());
        List<StoreLogisticCompanyVO> dfStoreLogisticsCompanies = purchaseLogisticCompanyListMap.getOrDefault(Integer.valueOf(SupplyPriceTypeEnums.TWO.getCode()), Lists.newArrayList());
        storeVO.setPcLogisticCompanyList(pcStoreLogisticsCompanies);
        storeVO.setDfLogisticCompanyList(dfStoreLogisticsCompanies);
        storeVO.setPayTypeSwitchVOList(this.payTypeSwitchBiz.getStorePayTypeSwitchVOList(store.getId(), dto.getIsPc()));
        storeVO.setDefaultCurrency("CNY");
        return this.getStorePlatFrom(store, storeVO);
    }

    public Boolean isHaveShopRenovation(QueryStoreRenovationDTO dto) {
        if (dto.getId() == null) {
            return false;
        }
        Store store = (Store)this.storeService.getById((Serializable)dto.getId());
        QueryShopRenovationDTO queryShopRenovationDTO = new QueryShopRenovationDTO();
        queryShopRenovationDTO.setShopId(dto.getId());
        List<ShopRenovationVO> shopRenovations = this.mdmAdapter.queryRenovationByShopId(queryShopRenovationDTO);
        if (CollUtil.isNotEmpty(shopRenovations)) {
            return true;
        }
        return false;
    }

    private List<String> getMutilTextList(String searchValue) {
        List<Object> searchList = com.google.common.collect.Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)searchValue)) {
            return searchList;
        }
        searchList = Arrays.asList(searchValue.split("\\s+"));
        return searchList;
    }

    private List<String> getSplitTextList(String searchValue) {
        List<Object> searchList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)searchValue)) {
            return searchList;
        }
        searchList = Arrays.asList(searchValue.split(","));
        return searchList;
    }

    public SelectMindDataResponse queryDataPermissionPage(CommonSearchRequest commonSearchRequest) {
        Page page = new Page(commonSearchRequest.getPageIndex().longValue(), commonSearchRequest.getPageSize().longValue());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BaseDo::getIsDelete, (Object)0);
        List searchCondition = commonSearchRequest.getSearchCondition();
        ArrayList idList = new ArrayList();
        QueryStorePermissionDTO queryStorePermissionDTO = new QueryStorePermissionDTO();
        searchCondition.forEach(x -> {
            String columnName = x.getColumnName();
            String searchValue = x.getSearchValue();
            if (columnName.contains("code")) {
                queryStorePermissionDTO.setCodeList(this.getMutilTextList(searchValue));
                if (CollUtil.isNotEmpty((Collection)queryStorePermissionDTO.getCodeList())) {
                    lambdaQueryWrapper.and(qw -> {
                        for (String code : queryStorePermissionDTO.getCodeList()) {
                            ((LambdaQueryWrapper)qw.or()).like(Store::getCode, (Object)code);
                        }
                    });
                }
            }
            if (columnName.contains("value")) {
                queryStorePermissionDTO.setNameList(this.getMutilTextList(searchValue));
                if (CollUtil.isNotEmpty((Collection)queryStorePermissionDTO.getNameList())) {
                    lambdaQueryWrapper.and(qw -> {
                        for (String name : queryStorePermissionDTO.getNameList()) {
                            ((LambdaQueryWrapper)qw.or()).like(Store::getName, (Object)name);
                        }
                    });
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)columnName, (CharSequence)"id")) {
                idList.addAll(Arrays.asList(x.getSearchValue().split(",")));
            }
        });
        IPage infoPage = null;
        infoPage = CollUtil.isEmpty(idList) ? this.storeService.page((IPage)page, (Wrapper)lambdaQueryWrapper) : this.storeService.queryPermissionPage(page, queryStorePermissionDTO, idList);
        List resultJsonObjList = infoPage.getRecords().stream().map(x -> {
            JSONObject resultObj = new JSONObject();
            resultObj.put("id", (Object)x.getId());
            resultObj.put("code", (Object)x.getCode());
            resultObj.put("value", (Object)x.getName());
            return resultObj;
        }).collect(Collectors.toList());
        SelectMindDataResponse response = new SelectMindDataResponse();
        response.setRecords(resultJsonObjList);
        response.setPageIndex(Long.valueOf(infoPage.getCurrent()));
        response.setPageSize(Long.valueOf(infoPage.getSize()));
        response.setTotalPage(Integer.valueOf((int)infoPage.getPages()));
        response.setTotalNum(Long.valueOf(infoPage.getTotal()));
        return response;
    }

    public SelectMindDataResponse queryDataPermissionPageV2(CommonSearchRequest commonSearchRequest) {
        Page page = new Page(commonSearchRequest.getPageIndex().longValue(), commonSearchRequest.getPageSize().longValue());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BaseDo::getIsDelete, (Object)0);
        List searchCondition = commonSearchRequest.getSearchCondition();
        HashMap map = Maps.newHashMap();
        searchCondition.forEach(x -> {
            String columnName = x.getColumnName();
            String searchValue = x.getSearchValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)columnName, (CharSequence)"id")) {
                map.put("idString", searchValue);
            } else {
                map.put(CamelTransformUnderlineUtils.changeColumn(columnName), searchValue);
            }
        });
        IPage infoPage = this.storeService.queryPermissionPageV3(page, map);
        List resultJsonObjList = infoPage.getRecords().stream().map(x -> {
            JSONObject resultObj = new JSONObject();
            resultObj.put("id", (Object)x.getId());
            resultObj.put("code", (Object)x.getCode());
            resultObj.put("value", (Object)x.getName());
            return resultObj;
        }).collect(Collectors.toList());
        SelectMindDataResponse response = new SelectMindDataResponse();
        response.setRecords(resultJsonObjList);
        response.setPageIndex(Long.valueOf(infoPage.getCurrent()));
        response.setPageSize(Long.valueOf(infoPage.getSize()));
        response.setTotalPage(Integer.valueOf((int)infoPage.getPages()));
        response.setTotalNum(Long.valueOf(infoPage.getTotal()));
        return response;
    }

    public List<PsStorePlatformAccountDTO> selectStorePayType(StoreDTO dto) {
        Assert.isTrue((dto.getId() != null ? 1 : 0) != 0, (String)"\u5e97\u94faid");
        Store store = (Store)this.storeService.getById((Serializable)dto.getId());
        DictGroup dictGroup = this.dictRedisRepository.selectDictGroup("platform_gether_pay_terms");
        List dictValueList = dictGroup.getDictValueList();
        ArrayList psStorePlatformAccountVOS = CollUtil.newArrayList((Object[])new PsStorePlatformAccountDTO[0]);
        List<StorePayTypeSwitchVO> storePayTypeSwitchList = this.payTypeSwitchBiz.getStorePayTypeSwitchVOList(dto.getId(), true);
        if (CollUtil.isEmpty(storePayTypeSwitchList)) {
            return psStorePlatformAccountVOS;
        }
        if (StrUtil.equals((CharSequence)store.getPlatformType(), (CharSequence)StorePlatformTypeEnum.ONE.getCode())) {
            StorePayTypeSwitchVO zfbPayTypeSwitchVO;
            StorePayTypeSwitchVO storePayTypeSwitchVO = storePayTypeSwitchList.stream().filter(a -> a.getPayType().equals(1)).findAny().orElse(null);
            if (null != storePayTypeSwitchVO) {
                PsStorePlatformAccountDTO psStorePlatformAccountDTO = new PsStorePlatformAccountDTO();
                psStorePlatformAccountDTO.setType("1");
                DictValue dictValue = dictValueList.stream().filter(item -> StrUtil.equals((CharSequence)"1", (CharSequence)String.valueOf(item.getValueCode()))).findAny().orElse(null);
                if (dictValue != null) {
                    psStorePlatformAccountDTO.setName(dictValue.getName());
                }
                psStorePlatformAccountVOS.add(psStorePlatformAccountDTO);
            }
            if (null != (zfbPayTypeSwitchVO = (StorePayTypeSwitchVO)storePayTypeSwitchList.stream().filter(a -> a.getPayType().equals(2)).findAny().orElse(null))) {
                PsStorePlatformAccountDTO zfb = new PsStorePlatformAccountDTO();
                zfb.setType("2");
                DictValue zfbdictValue = dictValueList.stream().filter(item -> StrUtil.equals((CharSequence)"2", (CharSequence)String.valueOf(item.getValueCode()))).findAny().orElse(null);
                if (zfbdictValue != null) {
                    zfb.setName(zfbdictValue.getName());
                }
                psStorePlatformAccountVOS.add(zfb);
            }
        } else {
            List psStorePlatformAccounts = this.psStorePlatformAccountService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PsStorePlatformAccount::getPsStoreId, (Object)store.getId())).eq(PsStorePlatformAccount::getIsEnable, (Object)FcCommonEnum.YesOrNoStrEnum.YES.getValue()));
            if (CollUtil.isNotEmpty((Collection)psStorePlatformAccounts)) {
                for (PsStorePlatformAccount psStorePlatformAccount : psStorePlatformAccounts) {
                    if (StrUtil.equals((CharSequence)"3", (CharSequence)psStorePlatformAccount.getType())) {
                        StorePayTypeSwitchVO qyPayTypeSwitchVO;
                        StorePayTypeSwitchVO storePayTypeSwitchVO = storePayTypeSwitchList.stream().filter(a -> a.getPayType().equals(3)).findAny().orElse(null);
                        if (null != storePayTypeSwitchVO) {
                            PsStorePlatformAccountDTO accountDTO = new PsStorePlatformAccountDTO();
                            accountDTO.setType("3");
                            accountDTO.setName("\u4e2a\u4eba\u7f51\u94f6");
                            accountDTO.setBankType("1");
                            psStorePlatformAccountVOS.add(accountDTO);
                        }
                        if (null == (qyPayTypeSwitchVO = (StorePayTypeSwitchVO)storePayTypeSwitchList.stream().filter(a -> a.getPayType().equals(4)).findAny().orElse(null))) continue;
                        PsStorePlatformAccountDTO psStorePlatformAccountDTO = new PsStorePlatformAccountDTO();
                        psStorePlatformAccountDTO.setType("3");
                        psStorePlatformAccountDTO.setName("\u4f01\u4e1a\u7f51\u94f6");
                        psStorePlatformAccountDTO.setBankType("2");
                        psStorePlatformAccountVOS.add(psStorePlatformAccountDTO);
                        continue;
                    }
                    DictValue dictValue = dictValueList.stream().filter(item -> StrUtil.equals((CharSequence)psStorePlatformAccount.getType(), (CharSequence)String.valueOf(item.getValueCode()))).findAny().orElse(null);
                    PsStorePlatformAccountDTO psStorePlatformAccountDTO = new PsStorePlatformAccountDTO();
                    psStorePlatformAccountDTO.setType(psStorePlatformAccount.getType());
                    if (dictValue != null) {
                        psStorePlatformAccountDTO.setName(dictValue.getName());
                    }
                    psStorePlatformAccountVOS.add(psStorePlatformAccountDTO);
                }
            }
        }
        storePayTypeSwitchList.stream().forEach(a -> {
            if (Integer.valueOf(5).equals(a.getPayType()) || Integer.valueOf(6).equals(a.getPayType()) || Integer.valueOf(99).equals(a.getPayType())) {
                PsStorePlatformAccountDTO psStorePlatformAccountDTO = new PsStorePlatformAccountDTO();
                psStorePlatformAccountDTO.setType(a.getPayType().toString());
                psStorePlatformAccountDTO.setName(a.getShowName());
                psStorePlatformAccountVOS.add(psStorePlatformAccountDTO);
            }
        });
        return psStorePlatformAccountVOS;
    }

    public void bindDefaultStore(Long dataId) {
        Assert.notNull((Object)dataId, (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList storeList = CollUtil.newArrayList((Object[])new Store[0]);
        Store store = (Store)this.storeService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(Store::getIsDefault, (Object)FcCommonEnum.YesOrNoStrEnum.YES.getValue())).ne(BaseDo::getId, (Object)dataId), Boolean.FALSE.booleanValue());
        if (store != null) {
            store.setIsDefault(FcCommonEnum.YesOrNoStrEnum.NO.getValue());
            storeList.add(store);
        }
        Store psStore = (Store)this.storeService.getById((Serializable)dataId);
        Assert.notNull((Object)psStore, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)StrUtil.equals((CharSequence)StoreTypeEnum.TWO.getCode(), (CharSequence)psStore.getStoreType()), (String)"\u81ea\u8425\u5e97\u94fa\u624d\u53ef\u6444\u8005\u9ed8\u8ba4\u5e97\u94fa");
        if (StrUtil.equals((CharSequence)psStore.getIsDefault(), (CharSequence)FcCommonEnum.YesOrNoStrEnum.YES.getValue())) {
            throw new IllegalArgumentException("\u5e97\u94fa\u5df2\u662f\u9ed8\u8ba4\u5e97\u94fa");
        }
        psStore.setIsDefault(FcCommonEnum.YesOrNoStrEnum.YES.getValue());
        storeList.add(psStore);
        UserStoreDTO userStoreDTO = new UserStoreDTO();
        userStoreDTO.setCusStoreId(dataId);
        this.scAdapter.bindDefaultMallUserStore(userStoreDTO);
        this.storeService.updateBatchById((Collection)storeList);
    }

    public List<StoreSalesmanInfoVO> queryStoreSalesmanList(StoreDTO dto) {
        List storeList = this.storeService.queryStoreList(dto);
        return BeanUtil.copyToList((Collection)storeList, StoreSalesmanInfoVO.class);
    }

    public List<StoreLogisticCompanyVO> logisticCompanyWithNameRel(QueryStoreLogisticsCompanyDTO jsonData) {
        Long id = jsonData.getStoreId();
        Integer purchaseMode = jsonData.getPurchaseMode();
        Assert.notNull((Object)id, (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        Integer isMallDisplay = this.userInfoUtil.isClientAccess() ? Integer.valueOf(1) : null;
        List<StoreLogisticCompanyVO> storeLogisticCompanyVOS = this.getStoreLogisticCompanyVOS(id, purchaseMode, isMallDisplay, jsonData.getIsDefault(), jsonData.getNoPlatform(), jsonData.getMdmLogisticsCompanyTypeId());
        if (Integer.valueOf(1).equals(isMallDisplay)) {
            for (StoreLogisticCompanyVO storeLogisticCompanyVO : storeLogisticCompanyVOS) {
                if (!StringUtils.isNotBlank((CharSequence)storeLogisticCompanyVO.getLogisticsCompanyAlias())) continue;
                storeLogisticCompanyVO.setMdmLogisticsCompanyTypeName(storeLogisticCompanyVO.getLogisticsCompanyAlias());
            }
        }
        return storeLogisticCompanyVOS;
    }

    private List<StoreLogisticCompanyVO> getStoreLogisticCompanyVOS(Long id) {
        return this.getStoreLogisticCompanyVOS(id, null, null, null, null, null);
    }

    private List<StoreLogisticCompanyVO> getStoreLogisticCompanyVOS(Long id, Integer purchaseMode, Integer isMallDisplay, Integer isDefault, Integer noPlatform, Long mdmLogisticsCompanyTypeId) {
        ArrayList psStoreLogisticCompanyList = Lists.newArrayList();
        List<PsStoreLogisticsCompany> logisticsCompanyList = this.getLogisticsCompanyList(Collections.singletonList(id), purchaseMode, isMallDisplay, isDefault, noPlatform, mdmLogisticsCompanyTypeId);
        if (CollUtil.isEmpty(logisticsCompanyList)) {
            return psStoreLogisticCompanyList;
        }
        Set transportIdList = logisticsCompanyList.stream().map(PsStoreLogisticsCompany::getTransportId).filter(ObjectUtil::isNotNull).collect(Collectors.toSet());
        Map<Long, TransportDTO> transportDTOMap = this.mallFourJAdapter.selectTransportMap(new ArrayList<Long>(transportIdList));
        Set mdmLogisticsCompanyTypeIds = logisticsCompanyList.stream().map(PsStoreLogisticsCompany::getMdmLogisticsCompanyTypeId).collect(Collectors.toSet());
        Map<Long, List<LogisticsCompanyPlatformVO>> mdmLogisticCompanyAndPlatformRelMap = this.mdmAdapter.queryLogisticCompanyAndPlatformRelMap(new ArrayList<Long>(mdmLogisticsCompanyTypeIds));
        for (PsStoreLogisticsCompany psStoreLogisticsCompany : logisticsCompanyList) {
            StoreLogisticCompanyVO storeLogisticCompanyVO = new StoreLogisticCompanyVO();
            BeanConvertUtil.copyProperties(psStoreLogisticsCompany, storeLogisticCompanyVO);
            ArrayList<StoreLogisticsCompanyPlatformVO> storeLogisticsCompanyPlatformVOList = new ArrayList<StoreLogisticsCompanyPlatformVO>();
            for (PsStoreLogisticsCompanyPlatform psStoreLogisticsCompanyPlatform : psStoreLogisticsCompany.getPlatformList()) {
                StoreLogisticsCompanyPlatformVO storeLogisticsCompanyPlatformVO = new StoreLogisticsCompanyPlatformVO();
                BeanUtils.copyProperties((Object)psStoreLogisticsCompanyPlatform, (Object)storeLogisticsCompanyPlatformVO);
                storeLogisticsCompanyPlatformVOList.add(storeLogisticsCompanyPlatformVO);
            }
            storeLogisticCompanyVO.setPlatformList(storeLogisticsCompanyPlatformVOList);
            this.buildLogisticsCompanyAndPlatformName(mdmLogisticCompanyAndPlatformRelMap, psStoreLogisticsCompany, storeLogisticCompanyVO);
            TransportDTO transportInfo = transportDTOMap.getOrDefault(storeLogisticCompanyVO.getTransportId(), new TransportDTO());
            if (StringUtils.isNotBlank((CharSequence)transportInfo.getTransName())) {
                storeLogisticCompanyVO.setTransportName(transportInfo.getTransName());
            } else {
                storeLogisticCompanyVO.setTransportName("");
                storeLogisticCompanyVO.setTransportId(null);
            }
            psStoreLogisticCompanyList.add(storeLogisticCompanyVO);
        }
        return psStoreLogisticCompanyList;
    }

    private void buildLogisticsCompanyAndPlatformName(Map<Long, List<LogisticsCompanyPlatformVO>> mdmLogisticCompanyAndPlatformRelMap, PsStoreLogisticsCompany psStoreLogisticsCompany, StoreLogisticCompanyVO storeLogisticCompanyVO) {
        List<LogisticsCompanyPlatformVO> logisticsCompanyPlatformVOS = mdmLogisticCompanyAndPlatformRelMap.get(psStoreLogisticsCompany.getMdmLogisticsCompanyTypeId());
        if (CollUtil.isNotEmpty(logisticsCompanyPlatformVOS)) {
            String logisticsCompanyTypeName = logisticsCompanyPlatformVOS.get(0).getLogisticsCompanyTypeName();
            storeLogisticCompanyVO.setMdmLogisticsCompanyTypeName(logisticsCompanyTypeName);
            List platformList = storeLogisticCompanyVO.getPlatformList();
            Map mdmPlatformIdPlatformMap = logisticsCompanyPlatformVOS.stream().collect(Collectors.toMap(LogisticsCompanyPlatformVO::getMdmPlatformId, Function.identity(), (o, n) -> o));
            StringJoiner platformInfoRel = new StringJoiner("\u3001");
            for (StoreLogisticsCompanyPlatformVO platform : platformList) {
                if (Long.valueOf(-1L).equals(platform.getMdmPlatformId())) {
                    Optional<LogisticsCompanyPlatformVO> noMdmPlatform = logisticsCompanyPlatformVOS.stream().filter(it -> StringUtils.equalsIgnoreCase((CharSequence)"OTHER", (CharSequence)it.getMdmPlatformCode())).findFirst();
                    noMdmPlatform.ifPresent(o -> {
                        this.convertPlatformData((LogisticsCompanyPlatformVO)o, platform);
                        platform.setMdmLogisticsCompanyId(o.getLogisticsCompanyId());
                    });
                    continue;
                }
                LogisticsCompanyPlatformVO mdmPlatform = mdmPlatformIdPlatformMap.getOrDefault(platform.getMdmPlatformId(), new LogisticsCompanyPlatformVO());
                if (platform.getMdmLogisticsCompanyId() == null) {
                    platform.setMdmLogisticsCompanyId(mdmPlatform.getLogisticsCompanyId());
                }
                this.convertPlatformData(mdmPlatform, platform);
                if (!StringUtils.isNotBlank((CharSequence)mdmPlatform.getMdmPlatformName())) continue;
                platform.setMdmPlatformName(mdmPlatform.getMdmPlatformName());
                String mdmPlatformNameRelTail = Integer.valueOf(1).equals(platform.getIsMallDisplay()) ? "\uff08\u5546\u57ce\u7aef\u663e\u793a\uff09" : "";
                platformInfoRel.add(mdmPlatform.getMdmPlatformName() + mdmPlatformNameRelTail);
            }
            storeLogisticCompanyVO.setPlatformInfoRel(platformInfoRel.toString());
        }
    }

    public void convertPlatformData(LogisticsCompanyPlatformVO source, StoreLogisticsCompanyPlatformVO target) {
        if (Objects.nonNull(source) && Objects.nonNull(target)) {
            target.setLogisticsCompanyId(source.getLogisticsCompanyId());
            target.setLogisticsCompanyName(source.getLogisticsCompanyName());
            target.setLogisticsCompanyCode(source.getLogisticsCompanyCode());
            target.setLogisticsCompanyTypeId(source.getLogisticsCompanyTypeId());
            target.setLogisticsCompanyTypeName(source.getLogisticsCompanyTypeName());
            target.setLogisticsCompanyTypeCode(source.getLogisticsCompanyTypeCode());
            target.setThirdCode(source.getThirdCode());
            target.setMdmPlatformCode(source.getMdmPlatformCode());
            target.setMdmLogisticsCompanyStatus(source.getMdmLogisticsCompanyStatus());
            target.setMdmLogisticsCompanyTypeStatus(source.getMdmLogisticsCompanyTypeStatus());
        }
    }

    public Long queryTransportId(QueryStoreLogisticsCompanyDTO jsonData) {
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5e97\u94fa\u7269\u6d41\u516c\u53f8\u8fd0\u8d39\u6a21\u677fid\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)jsonData));
        }
        Long storeId = jsonData.getStoreId();
        Assert.notNull((Object)storeId, (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        Integer purchaseMode = jsonData.getPurchaseMode();
        Assert.notNull((Object)purchaseMode, (String)"\u91c7\u8d2d\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Long mdmLogisticsCompanyId = jsonData.getMdmLogisticsCompanyId();
        Long mdmLogisticsCompanyTypeId = jsonData.getMdmLogisticsCompanyTypeId();
        mdmLogisticsCompanyTypeId = Objects.isNull(mdmLogisticsCompanyTypeId) ? mdmLogisticsCompanyId : mdmLogisticsCompanyTypeId;
        Assert.notNull((Object)mdmLogisticsCompanyTypeId, (String)"\u7269\u6d41\u516c\u53f8id\u4e0d\u5f97\u4e3a\u7a7a");
        PsStoreLogisticsCompany logisticsCompany = (PsStoreLogisticsCompany)this.psStoreLogisticsCompanyService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PsStoreLogisticsCompany.class).eq(PsStoreLogisticsCompany::getPsStoreId, (Object)storeId)).eq(PsStoreLogisticsCompany::getMdmLogisticsCompanyTypeId, (Object)mdmLogisticsCompanyTypeId)).eq(PsStoreLogisticsCompany::getPurchaseMode, (Object)purchaseMode)).last("LIMIT 1"));
        Assert.notNull((Object)logisticsCompany, (String)"\u7269\u6d41\u516c\u53f8\u4e0d\u5b58\u5728");
        if (log.isDebugEnabled()) {
            log.debug("\u67e5\u8be2\u5e97\u94fa\u7269\u6d41\u516c\u53f8\u8fd0\u8d39\u6a21\u677fid\u51fa\u9910:{}", (Object)JSON.toJSONString((Object)jsonData));
        }
        return logisticsCompany.getTransportId();
    }

    public List<StoreLogisticsCompanyPlatformVO> logisticCompanyBA(QueryStoreLogisticsCompanyDTO jsonData) {
        List<StoreLogisticCompanyVO> storeLogisticCompanyVOS = this.logisticCompanyWithNameRel(jsonData);
        ArrayList allPlatformaList = Lists.newArrayList();
        for (StoreLogisticCompanyVO storeLogisticCompanyVO : storeLogisticCompanyVOS) {
            List platformList = storeLogisticCompanyVO.getPlatformList();
            for (StoreLogisticsCompanyPlatformVO platformVO : platformList) {
                platformVO.setPsStoreId(storeLogisticCompanyVO.getPsStoreId());
                platformVO.setPurchaseMode(storeLogisticCompanyVO.getPurchaseMode());
                platformVO.setIsDefault(storeLogisticCompanyVO.getIsDefault());
                platformVO.setMdmLogisticsCompanyTypeId(storeLogisticCompanyVO.getMdmLogisticsCompanyTypeId());
                platformVO.setTransportId(storeLogisticCompanyVO.getTransportId());
                platformVO.setIsMallDisplay(storeLogisticCompanyVO.getIsMallDisplay());
                platformVO.setFreeShippingAmount(storeLogisticCompanyVO.getFreeShippingAmount());
                platformVO.setPlatformInfoRel(storeLogisticCompanyVO.getPlatformInfoRel());
                platformVO.setMdmLogisticsCompanyTypeName(storeLogisticCompanyVO.getMdmLogisticsCompanyTypeName());
                allPlatformaList.add(platformVO);
            }
        }
        return allPlatformaList;
    }

    public StoreLogisticCompanyVO queryLogisticCompanyByMdmId(QueryStoreLogisticsCompanyDTO jsonData) {
        if (Objects.isNull(jsonData.getMdmLogisticsCompanyTypeId()) || Objects.isNull(jsonData.getPurchaseMode()) || Objects.isNull(jsonData.getStoreId())) {
            throw new IllegalArgumentException("mdmLogisticsCompanyTypeId\u3001purchaseMode\u3001storeId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<StoreLogisticCompanyVO> storeLogisticCompanyVOS = this.logisticCompanyWithNameRel(jsonData);
        if (CollUtil.isNotEmpty(storeLogisticCompanyVOS)) {
            return storeLogisticCompanyVOS.get(0);
        }
        return null;
    }

    public PsStoreVO queryStoreAndLogisticsCompanyRelInternal(QueryStoreLogisticsCompanyDTO jsonData) {
        Store store;
        String storeName = jsonData.getStoreName();
        Long storeId = jsonData.getStoreId();
        if (StringUtils.isBlank((CharSequence)storeName) && Objects.isNull(storeId)) {
            throw new IllegalArgumentException("storeName and storeId can not be null at the same time");
        }
        if (StringUtils.isNotBlank((CharSequence)storeName)) {
            store = (Store)this.storeService.getOne((Wrapper)Wrappers.lambdaQuery(Store.class).eq(Store::getName, (Object)storeName));
            Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
            jsonData.setStoreId(store.getId());
        } else {
            store = (Store)this.storeService.getById((Serializable)storeId);
            Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        }
        PsStoreVO psStoreVO = new PsStoreVO();
        BeanUtils.copyProperties((Object)store, (Object)psStoreVO);
        psStoreVO.setStoreLogisticsCompanyPlatformList(this.logisticCompanyBA(jsonData));
        return psStoreVO;
    }

    public void saveAlias(List<SpuAliasDTO> jsonData) {
        for (SpuAliasDTO spuAliasDTO : jsonData) {
        }
        PsStoreSpuAlias psStoreSpuAlias = new PsStoreSpuAlias();
        BeanUtils.copyProperties(jsonData, (Object)psStoreSpuAlias);
        String spuAlias = this.storeSpuAliasService.getAliasBySpuId(psStoreSpuAlias.getPsStoreId(), psStoreSpuAlias.getPsSpuId());
    }

    public void saveAlias(Long psStoreId, List<SpuAliasBaseDTO> spuAliasList) {
        Set aliasIsNullSpuIdSet = spuAliasList.stream().filter(it -> StringUtils.isBlank((CharSequence)it.getSpuAlias())).map(SpuAliasBaseDTO::getPsSpuId).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(aliasIsNullSpuIdSet)) {
            this.storeSpuAliasService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PsStoreSpuAlias.class).eq(PsStoreSpuAlias::getPsStoreId, (Object)psStoreId)).in(PsStoreSpuAlias::getPsSpuId, aliasIsNullSpuIdSet));
            spuAliasList.removeIf(it -> aliasIsNullSpuIdSet.contains(it.getPsSpuId()));
            List<String> deleteSpuIds = aliasIsNullSpuIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            RedisUtils.deleteSpuAliasCache(deleteSpuIds, psStoreId);
        }
        if (CollUtil.isEmpty(spuAliasList)) {
            return;
        }
        this.checkAliasUnique(psStoreId, spuAliasList);
        Map<Long, String> spuIdAliasMap = spuAliasList.stream().collect(Collectors.toMap(SpuAliasBaseDTO::getPsSpuId, SpuAliasBaseDTO::getSpuAlias));
        List listInDb = this.storeSpuAliasService.getBySpuIds(psStoreId, (List)CollUtil.newArrayList(spuIdAliasMap.keySet()));
        ArrayList list = CollUtil.newArrayList((Object[])new PsStoreSpuAlias[0]);
        for (PsStoreSpuAlias psStoreSpuAlias : listInDb) {
            psStoreSpuAlias.setSpuAlias(spuIdAliasMap.get(psStoreSpuAlias.getPsSpuId()));
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psStoreSpuAlias);
            list.add(psStoreSpuAlias);
            spuIdAliasMap.remove(psStoreSpuAlias.getPsSpuId());
        }
        for (Map.Entry entry : spuIdAliasMap.entrySet()) {
            PsStoreSpuAlias psStoreSpuAlias = new PsStoreSpuAlias();
            psStoreSpuAlias.setPsStoreId(psStoreId);
            psStoreSpuAlias.setPsSpuId((Long)entry.getKey());
            psStoreSpuAlias.setSpuAlias((String)entry.getValue());
            psStoreSpuAlias.setId(this.idSequenceGenerator.generateId(PsStoreSpuAlias.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psStoreSpuAlias);
            list.add(psStoreSpuAlias);
        }
        if (CollUtil.isNotEmpty((Collection)list)) {
            this.storeSpuAliasService.saveOrUpdateBatch((Collection)list);
        }
        Map<String, String> spuAliasCacheMap = list.stream().collect(Collectors.toMap(it -> String.valueOf(it.getPsSpuId()), PsStoreSpuAlias::getSpuAlias));
        RedisUtils.spuAliasCache(spuAliasCacheMap, psStoreId);
    }

    private void checkAliasUnique(Long psStoreId, List<SpuAliasBaseDTO> spuAliasList) {
        ArrayList idList = Lists.newArrayList();
        ArrayList aliasList = Lists.newArrayList();
        for (SpuAliasBaseDTO spuAliasBaseDTO : spuAliasList) {
            if (Objects.nonNull(spuAliasBaseDTO.getPsSpuId())) {
                idList.add(spuAliasBaseDTO.getId());
            }
            aliasList.add(spuAliasBaseDTO.getSpuAlias());
        }
        List repeatAliasList = this.storeSpuAliasService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().select(new SFunction[]{PsStoreSpuAlias::getSpuAlias}).eq(PsStoreSpuAlias::getPsStoreId, (Object)psStoreId)).in(PsStoreSpuAlias::getSpuAlias, (Collection)aliasList)).notIn(BaseDo::getId, (Collection)idList));
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)repeatAliasList), (String)("\u5b58\u5728\u91cd\u590d\u522b\u540d\u3010" + repeatAliasList.stream().map(PsStoreSpuAlias::getSpuAlias).collect(Collectors.joining("\u3001")) + "\u3011"));
    }
}

