/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.xinqiyi.cus.model.dto.customer.CustomerOrderConfigureDetailsDTO;
import com.xinqiyi.cus.vo.customer.CusCustomerOrderConfigurationVO;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.redis.lock.RedisReentrantLock;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.StoreBrandFocusVO;
import com.xinqiyi.ps.dao.repository.StoreBrandFocusService;
import com.xinqiyi.ps.model.dto.enums.StoreBrandFocusOperateTypeEnum;
import com.xinqiyi.ps.model.dto.store.brandFocus.StoreBrandFocusPageQueryDTO;
import com.xinqiyi.ps.model.dto.store.brandFocus.StoreBrandFocusQueryDTO;
import com.xinqiyi.ps.model.entity.PsStoreBrandFocusHistory;
import com.xinqiyi.ps.model.entity.StoreBrandFocus;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.SkuShelfBiz;
import com.xinqiyi.ps.service.util.PsRedisLockUtil;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StoreBrandFocusBiz {
    private static final Logger log = LoggerFactory.getLogger(StoreBrandFocusBiz.class);
    private final StoreBrandFocusService psStoreBrandFocusService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final IdSequenceGenerator idSequence;
    private final UserInfoUtil userInfoUtil;
    private final ScAdapter scAdapter;
    private final SkuShelfBiz skuShelfBiz;
    private final CusAdapter cusAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String focus(Long brandId) {
        Assert.notNull((Object)brandId, (String)"\u8bf7\u9009\u5b9a\u8981\u5173\u6ce8\u7684\u54c1\u724c", (Object[])new Object[0]);
        Long userId = this.userInfoUtil.getUserId();
        Assert.notNull((Object)userId, (String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Long storeId = this.userInfoUtil.getStoreId();
        Assert.notNull((Object)storeId, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u8d26\u53f7\u767b\u5f55\u65f6\u6240\u9009\u5b9a\u7684\u5e97\u94fa", (Object[])new Object[0]);
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            String key = String.join((CharSequence)",", String.valueOf(brandId), String.valueOf(userId), String.valueOf(storeId));
            String lockKey = "ps:store_brand:focus:" + key;
            RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u5173\u6ce8\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...");
            lockKeyList.add((CallSite)((Object)lockKey));
            lockList.add(lock);
            boolean isFocus = this.psStoreBrandFocusService.isFocus(userId, storeId, brandId);
            if (isFocus) {
                String string = "\u60a8\u5df2\u5173\u6ce8";
                return string;
            }
            StoreBrandFocus psStoreBrandFocus = new StoreBrandFocus();
            psStoreBrandFocus.setUserId(userId);
            psStoreBrandFocus.setPsBrandId(brandId);
            psStoreBrandFocus.setPsStoreId(storeId);
            psStoreBrandFocus.setId(this.idSequence.generateId(StoreBrandFocus.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psStoreBrandFocus);
            PsStoreBrandFocusHistory psStoreBrandFocusHistory = new PsStoreBrandFocusHistory();
            psStoreBrandFocusHistory.setType(StoreBrandFocusOperateTypeEnum.FOCUS.getCode());
            psStoreBrandFocusHistory.setUserId(userId);
            psStoreBrandFocusHistory.setPsBrandId(brandId);
            psStoreBrandFocusHistory.setPsStoreId(storeId);
            psStoreBrandFocusHistory.setId(this.idSequence.generateId(PsStoreBrandFocusHistory.class));
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psStoreBrandFocusHistory);
            this.psStoreBrandFocusService.focus(psStoreBrandFocus, psStoreBrandFocusHistory);
            String string = "\u5173\u6ce8\u6210\u529f!";
            return string;
        }
        catch (Exception e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    public String cancelFocus(Long brandId) {
        return this.cancelFocus(Collections.singletonList(brandId), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cancelFocus(List<Long> brandIds, Boolean isAllCheck) {
        if (ObjectUtil.notEqual((Object)isAllCheck, (Object)Boolean.TRUE) && CollUtil.isEmpty(brandIds)) {
            throw new IllegalArgumentException("\u8bf7\u9009\u5b9a\u8981\u53d6\u6d88\u5173\u6ce8\u7684\u54c1\u724c");
        }
        Long userId = this.userInfoUtil.getUserId();
        Assert.notNull((Object)userId, (String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Long storeId = this.userInfoUtil.getStoreId();
        Assert.notNull((Object)userId, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u8d26\u53f7\u767b\u5f55\u65f6\u6240\u9009\u5b9a\u7684\u5e97\u94fa", (Object[])new Object[0]);
        ArrayList<CallSite> lockKeyList = new ArrayList<CallSite>();
        ArrayList<RedisReentrantLock> lockList = new ArrayList<RedisReentrantLock>();
        try {
            if (ObjectUtil.equals((Object)isAllCheck, (Object)Boolean.TRUE)) {
                List brandFocusList = this.psStoreBrandFocusService.queryByUserAndStore(userId, storeId);
                Assert.notEmpty((Iterable)brandFocusList, (String)"\u6ca1\u6709\u5173\u6ce8\u4e2d\u7684\u54c1\u724c", (Object[])new Object[0]);
                for (Object brandFocus : brandFocusList) {
                    String key = String.join((CharSequence)",", String.valueOf(brandFocus.getPsBrandId()), String.valueOf(userId), String.valueOf(storeId));
                    String lockKey = "ps:store_brand:focus:" + key;
                    RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u53d6\u6d88\u5173\u6ce8\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...");
                    lockKeyList.add((CallSite)((Object)lockKey));
                    lockList.add(lock);
                }
                storeBrandFocusHistories = new ArrayList<PsStoreBrandFocusHistory>();
                for (StoreBrandFocus brandFocus : brandFocusList) {
                    psStoreBrandFocusHistory = new PsStoreBrandFocusHistory();
                    psStoreBrandFocusHistory.setType(StoreBrandFocusOperateTypeEnum.CANCEL_FOCUS.getCode());
                    psStoreBrandFocusHistory.setUserId(userId);
                    psStoreBrandFocusHistory.setPsBrandId(brandFocus.getPsBrandId());
                    psStoreBrandFocusHistory.setPsStoreId(storeId);
                    psStoreBrandFocusHistory.setId(this.idSequence.generateId(PsStoreBrandFocusHistory.class));
                    this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psStoreBrandFocusHistory);
                    storeBrandFocusHistories.add(psStoreBrandFocusHistory);
                }
                this.psStoreBrandFocusService.cancelAllFocus(userId, storeId, storeBrandFocusHistories);
            } else {
                for (Long brandId : brandIds) {
                    String key = String.join((CharSequence)",", String.valueOf(brandId), String.valueOf(userId), String.valueOf(storeId));
                    String lockKey = "ps:store_brand:focus:" + (String)key;
                    RedisReentrantLock lock = PsRedisLockUtil.lock(lockKey, "\u53d6\u6d88\u5173\u6ce8\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5...");
                    lockKeyList.add((CallSite)((Object)lockKey));
                    lockList.add(lock);
                }
                boolean isFocus = this.psStoreBrandFocusService.isFocus(userId, storeId, brandIds);
                Assert.isTrue((boolean)isFocus, (String)"\u60a8\u5df2\u53d6\u6d88\u5173\u6ce8", (Object[])new Object[0]);
                storeBrandFocusHistories = new ArrayList();
                for (Long brandId : brandIds) {
                    psStoreBrandFocusHistory = new PsStoreBrandFocusHistory();
                    psStoreBrandFocusHistory.setType(StoreBrandFocusOperateTypeEnum.CANCEL_FOCUS.getCode());
                    psStoreBrandFocusHistory.setUserId(userId);
                    psStoreBrandFocusHistory.setPsBrandId(brandId);
                    psStoreBrandFocusHistory.setPsStoreId(storeId);
                    psStoreBrandFocusHistory.setId(this.idSequence.generateId(PsStoreBrandFocusHistory.class));
                    this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)psStoreBrandFocusHistory);
                    storeBrandFocusHistories.add(psStoreBrandFocusHistory);
                }
                this.psStoreBrandFocusService.batchCancelFocus(userId, storeId, brandIds, storeBrandFocusHistories);
            }
            String isFocus = "\u53d6\u6d88\u5173\u6ce8\u6210\u529f!";
            return isFocus;
        }
        catch (Exception e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (CollUtil.isNotEmpty(lockList)) {
                for (int i = 0; i < lockList.size(); ++i) {
                    PsRedisLockUtil.unlock((RedisReentrantLock)lockList.get(i), (String)lockKeyList.get(i), log, this.getClass().getName());
                }
            }
        }
    }

    public List<StoreBrandFocusVO> query(StoreBrandFocusQueryDTO dto) {
        List storeBrandFocus;
        Long userId = this.userInfoUtil.getUserId();
        Assert.notNull((Object)userId, (String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Long storeId = this.userInfoUtil.getStoreId();
        Assert.notNull((Object)storeId, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u8d26\u53f7\u767b\u5f55\u65f6\u6240\u9009\u5b9a\u7684\u5e97\u94fa", (Object[])new Object[0]);
        dto.setUserId(userId);
        dto.setStoreId(storeId);
        Long customerId = this.userInfoUtil.getCustomerId();
        if (null != customerId) {
            try {
                CustomerOrderConfigureDetailsDTO orderConfigureDetailsDTO = new CustomerOrderConfigureDetailsDTO();
                orderConfigureDetailsDTO.setCustomerId(customerId);
                CusCustomerOrderConfigurationVO orderConfigurationVO = this.cusAdapter.selectOrderConfigurationForQuerySku(orderConfigureDetailsDTO);
                org.springframework.util.Assert.isTrue((null != orderConfigurationVO ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5931\u8d25");
                if (null != orderConfigurationVO.getIsExcludeAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsExcludeAll())) {
                    return Lists.newArrayList();
                }
                if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointBrandIds())) {
                    dto.setBrandIds(orderConfigurationVO.getAppointBrandIds());
                }
                if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds())) {
                    dto.setExcludeBrandIds(orderConfigurationVO.getExcludeBrandIds());
                }
                if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds())) {
                    dto.setExcludeBrandIds(orderConfigurationVO.getExcludeBrandIds());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5f02\u5e38{}", (Object)e.getMessage());
                return Collections.emptyList();
            }
        }
        if (CollUtil.isNotEmpty((Collection)(storeBrandFocus = this.psStoreBrandFocusService.query(dto)))) {
            this.afterQueryCommonProcess(storeBrandFocus, dto.getImageWide(), dto.getImageHigh(), storeId);
            return storeBrandFocus;
        }
        return Collections.emptyList();
    }

    public Page<StoreBrandFocusVO> query(StoreBrandFocusPageQueryDTO dto) {
        Page result;
        List storeBrandFocus;
        Long userId = this.userInfoUtil.getUserId();
        Assert.notNull((Object)userId, (String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Long storeId = this.userInfoUtil.getStoreId();
        Assert.notNull((Object)storeId, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u8d26\u53f7\u767b\u5f55\u65f6\u6240\u9009\u5b9a\u7684\u5e97\u94fa", (Object[])new Object[0]);
        dto.setUserId(userId);
        dto.setStoreId(storeId);
        Long customerId = this.userInfoUtil.getCustomerId();
        if (null != customerId) {
            CustomerOrderConfigureDetailsDTO orderConfigureDetailsDTO = new CustomerOrderConfigureDetailsDTO();
            orderConfigureDetailsDTO.setCustomerId(customerId);
            CusCustomerOrderConfigurationVO orderConfigurationVO = this.cusAdapter.selectOrderConfigurationForQuerySku(orderConfigureDetailsDTO);
            org.springframework.util.Assert.isTrue((null != orderConfigurationVO ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5931\u8d25");
            if (null != orderConfigurationVO.getIsExcludeAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsExcludeAll())) {
                return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointBrandIds())) {
                dto.setBrandIds(orderConfigurationVO.getAppointBrandIds());
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds())) {
                dto.setExcludeBrandIds(orderConfigurationVO.getExcludeBrandIds());
            }
        }
        if (CollUtil.isNotEmpty((Collection)(storeBrandFocus = (result = this.psStoreBrandFocusService.queryPage(dto)).getRecords()))) {
            this.afterQueryCommonProcess(storeBrandFocus, dto.getImageWide(), dto.getImageHigh(), storeId);
            return result;
        }
        return new Page((long)dto.getPageNum(), (long)dto.getPageSize());
    }

    private void afterQueryCommonProcess(List<StoreBrandFocusVO> storeBrandFocus, Integer imageWide, Integer imageHigh, Long storeId) {
        List<Long> shelfBrandIds = this.skuShelfBiz.selectStoreShelfBrand(storeId, null);
        List<String> imagList = storeBrandFocus.stream().map(StoreBrandFocusVO::getLogoUrl).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedThumbUrl(imagList, imageWide, imageHigh);
        for (StoreBrandFocusVO brandFocus : storeBrandFocus) {
            ossUrlVOS.stream().filter(a -> StringUtils.equals((CharSequence)a.getUrl(), (CharSequence)brandFocus.getLogoUrl())).findFirst().ifPresent(a -> brandFocus.setLogoUrlFull(a.getIntactUrl()));
            if (!CollUtil.isNotEmpty(shelfBrandIds)) continue;
            brandFocus.setIsOnShelf(Boolean.valueOf(shelfBrandIds.stream().anyMatch(a -> ObjectUtil.equals((Object)brandFocus.getPsBrandId(), (Object)a))));
        }
    }

    public StoreBrandFocusBiz(StoreBrandFocusService psStoreBrandFocusService, BaseDaoInitialService baseDaoInitialService, IdSequenceGenerator idSequence, UserInfoUtil userInfoUtil, ScAdapter scAdapter, SkuShelfBiz skuShelfBiz, CusAdapter cusAdapter) {
        this.psStoreBrandFocusService = psStoreBrandFocusService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.idSequence = idSequence;
        this.userInfoUtil = userInfoUtil;
        this.scAdapter = scAdapter;
        this.skuShelfBiz = skuShelfBiz;
        this.cusAdapter = cusAdapter;
    }
}

