/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.google.common.collect.Lists;
import com.xinqiyi.cus.model.dto.customer.CustomerOrderConfigureDetailsDTO;
import com.xinqiyi.cus.vo.customer.CusCustomerOrderConfigurationVO;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.StoreBrandRecommendVO;
import com.xinqiyi.ps.dao.repository.StoreBrandRecommendService;
import com.xinqiyi.ps.model.dto.store.brandRecommend.StoreBrandRecommendDTO;
import com.xinqiyi.ps.model.dto.store.brandRecommend.StoreBrandRecommendQueryDTO;
import com.xinqiyi.ps.model.dto.store.brandRecommend.StoreBrandRecommendSaveDTO;
import com.xinqiyi.ps.model.entity.StoreBrandRecommend;
import com.xinqiyi.ps.service.adapter.cus.CusAdapter;
import com.xinqiyi.ps.service.adapter.sc.ScAdapter;
import com.xinqiyi.ps.service.business.SkuShelfBiz;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import com.xinqiyi.systemcenter.web.sc.api.model.vo.file.OssUrlVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StoreBrandRecommendBiz {
    private static final Logger log = LoggerFactory.getLogger(StoreBrandRecommendBiz.class);
    private final StoreBrandRecommendService storeBrandRecommendService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final IdSequenceGenerator idSequence;
    private final UserInfoUtil userInfoUtil;
    private final ScAdapter scAdapter;
    private final SkuShelfBiz skuShelfBiz;
    private final CusAdapter cusAdapter;

    public void save(StoreBrandRecommendSaveDTO dto) {
        Long storeId = dto.getPsStoreId();
        Assert.notNull((Object)storeId, (String)"\u7f3a\u5c11storeId", (Object[])new Object[0]);
        List storeBrandRecommendDTOS = dto.getStoreBrandRecommendDTOS();
        Assert.isTrue((storeBrandRecommendDTOS.size() <= 50 ? 1 : 0) != 0, (String)"\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e50\u4e2a\u63a8\u8350\u54c1\u724c", (Object[])new Object[0]);
        ArrayList<StoreBrandRecommend> storeBrandRecommends = new ArrayList<StoreBrandRecommend>(storeBrandRecommendDTOS.size());
        if (CollUtil.isNotEmpty((Collection)storeBrandRecommendDTOS)) {
            for (StoreBrandRecommendDTO storeBrandRecommendDTO : storeBrandRecommendDTOS) {
                StoreBrandRecommend storeBrandRecommend = new StoreBrandRecommend();
                this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)storeBrandRecommend);
                storeBrandRecommend.setPsStoreId(storeId);
                storeBrandRecommend.setPsBrandId(storeBrandRecommendDTO.getPsBrandId());
                storeBrandRecommend.setSortNo(storeBrandRecommendDTO.getSortNo());
                storeBrandRecommend.setId(this.idSequence.generateId(StoreBrandRecommend.class));
                storeBrandRecommends.add(storeBrandRecommend);
            }
        }
        this.storeBrandRecommendService.removeOldAndSaveNewSort(storeId, storeBrandRecommends);
    }

    public List<StoreBrandRecommendVO> getByStoreId(Long storeId) {
        Assert.notNull((Object)storeId, (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.storeBrandRecommendService.getByStoreId(storeId);
    }

    public List<StoreBrandRecommendVO> queryForClient(StoreBrandRecommendQueryDTO dto) {
        Long userId = this.userInfoUtil.getUserId();
        Assert.notNull((Object)userId, (String)"\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Long storeId = this.userInfoUtil.getStoreId();
        Assert.notNull((Object)storeId, (String)"\u8be5\u8d26\u53f7\u672a\u6388\u6743\u4efb\u4f55\u5e97\u94fa", (Object[])new Object[0]);
        List<Long> shelfBrandIds = this.skuShelfBiz.selectStoreShelfBrand(storeId, null);
        if (CollUtil.isEmpty(shelfBrandIds)) {
            return Lists.newArrayList();
        }
        List<Object> brandIs = Lists.newArrayList();
        Long customerId = this.userInfoUtil.getCustomerId();
        if (null != customerId) {
            CustomerOrderConfigureDetailsDTO orderConfigureDetailsDTO = new CustomerOrderConfigureDetailsDTO();
            orderConfigureDetailsDTO.setCustomerId(customerId);
            CusCustomerOrderConfigurationVO orderConfigurationVO = this.cusAdapter.selectOrderConfigurationForQuerySku(orderConfigureDetailsDTO);
            org.springframework.util.Assert.isTrue((null != orderConfigurationVO ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5ba2\u6237\u4e0b\u5355\u914d\u7f6e\u5931\u8d25");
            if (null != orderConfigurationVO.getIsQueryAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsQueryAll())) {
                brandIs.addAll(shelfBrandIds);
            }
            if (null != orderConfigurationVO.getIsExcludeAll() && Boolean.TRUE.equals(orderConfigurationVO.getIsExcludeAll())) {
                return Lists.newArrayList();
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getAppointBrandIds())) {
                List<Object> list = brandIs = CollUtil.isEmpty(shelfBrandIds) ? orderConfigurationVO.getAppointBrandIds() : orderConfigurationVO.getAppointBrandIds().stream().filter(shelfBrandIds::contains).collect(Collectors.toList());
            }
            if (CollUtil.isNotEmpty((Collection)orderConfigurationVO.getExcludeBrandIds())) {
                for (Long brandId : shelfBrandIds) {
                    Long id = orderConfigurationVO.getExcludeBrandIds().stream().filter(a -> a.equals(brandId)).findAny().orElse(null);
                    if (null != id) continue;
                    brandIs.add(brandId);
                }
            }
        }
        List storeBrandRecommends = this.storeBrandRecommendService.queryForClient(userId, storeId, (List)brandIs);
        List<String> imagList = storeBrandRecommends.stream().map(StoreBrandRecommendVO::getLogoUrl).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<OssUrlVO> ossUrlVOS = this.scAdapter.generatePreassignedThumbUrl(imagList, dto.getImageWide(), dto.getImageHigh());
        for (StoreBrandRecommendVO storeBrandRecommend : storeBrandRecommends) {
            ossUrlVOS.stream().filter(a -> StringUtils.equals((CharSequence)a.getUrl(), (CharSequence)storeBrandRecommend.getLogoUrl())).findFirst().ifPresent(a -> storeBrandRecommend.setLogoUrlFull(a.getIntactUrl()));
        }
        return storeBrandRecommends;
    }

    public StoreBrandRecommendBiz(StoreBrandRecommendService storeBrandRecommendService, BaseDaoInitialService baseDaoInitialService, IdSequenceGenerator idSequence, UserInfoUtil userInfoUtil, ScAdapter scAdapter, SkuShelfBiz skuShelfBiz, CusAdapter cusAdapter) {
        this.storeBrandRecommendService = storeBrandRecommendService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.idSequence = idSequence;
        this.userInfoUtil = userInfoUtil;
        this.scAdapter = scAdapter;
        this.skuShelfBiz = skuShelfBiz;
        this.cusAdapter = cusAdapter;
    }
}

