/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.StoreBrandSortVO;
import com.xinqiyi.ps.dao.repository.StoreBrandSortService;
import com.xinqiyi.ps.model.dto.store.brandSort.StoreBrandSortDTO;
import com.xinqiyi.ps.model.dto.store.brandSort.StoreBrandSortSaveDTO;
import com.xinqiyi.ps.model.entity.StoreBrandSort;
import com.xinqiyi.ps.service.business.SkuShelfBiz;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StoreBrandSortBiz {
    private static final Logger log = LoggerFactory.getLogger(StoreBrandSortBiz.class);
    private final StoreBrandSortService storeBrandSortService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final IdSequenceGenerator idSequence;
    private final UserInfoUtil userInfoUtil;
    private final SkuShelfBiz skuShelfBiz;

    public void save(StoreBrandSortSaveDTO dto) {
        Long storeId = dto.getPsStoreId();
        List storeBrandSortDTOS = dto.getStoreBrandSortDTOS();
        Assert.notNull((Object)storeId, (String)"\u7f3a\u5c11storeId", (Object[])new Object[0]);
        ArrayList<StoreBrandSort> storeBrandSorts = new ArrayList<StoreBrandSort>(storeBrandSortDTOS.size());
        for (StoreBrandSortDTO storeBrandSortDTO : storeBrandSortDTOS) {
            if (!ObjectUtil.isNotNull((Object)storeBrandSortDTO.getSortNo())) continue;
            StoreBrandSort storeBrandSort = new StoreBrandSort();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)storeBrandSort);
            storeBrandSort.setPsStoreId(storeId);
            storeBrandSort.setPsBrandId(storeBrandSortDTO.getPsBrandId());
            storeBrandSort.setSortNo(storeBrandSortDTO.getSortNo());
            storeBrandSort.setId(this.idSequence.generateId(StoreBrandSort.class));
            storeBrandSorts.add(storeBrandSort);
        }
        this.storeBrandSortService.removeOldAndSaveNewSort(storeId, storeBrandSorts);
    }

    public List<StoreBrandSortVO> getByStoreId(Long storeId) {
        Long loginStoreId = this.userInfoUtil.getStoreId();
        if (ObjectUtil.isNotNull((Object)loginStoreId)) {
            storeId = loginStoreId;
        }
        Assert.notNull((Object)storeId, (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.storeBrandSortService.getByStoreId(storeId);
    }

    public StoreBrandSortBiz(StoreBrandSortService storeBrandSortService, BaseDaoInitialService baseDaoInitialService, IdSequenceGenerator idSequence, UserInfoUtil userInfoUtil, SkuShelfBiz skuShelfBiz) {
        this.storeBrandSortService = storeBrandSortService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.idSequence = idSequence;
        this.userInfoUtil = userInfoUtil;
        this.skuShelfBiz = skuShelfBiz;
    }
}

