/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.StoreCountrySortVO;
import com.xinqiyi.ps.dao.repository.StoreCountrySortService;
import com.xinqiyi.ps.model.dto.store.countrySort.StoreCountrySortDTO;
import com.xinqiyi.ps.model.dto.store.countrySort.StoreCountrySortSaveDTO;
import com.xinqiyi.ps.model.entity.StoreCountrySort;
import com.xinqiyi.ps.service.business.SkuShelfBiz;
import com.xinqiyi.ps.service.util.UserInfoUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StoreCountrySortBiz {
    private static final Logger log = LoggerFactory.getLogger(StoreCountrySortBiz.class);
    private final StoreCountrySortService storeCountrySortService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final IdSequenceGenerator idSequence;
    private final UserInfoUtil userInfoUtil;
    private final SkuShelfBiz skuShelfBiz;

    public void save(StoreCountrySortSaveDTO dto) {
        Long storeId = dto.getPsStoreId();
        List storeCountrySortDTOS = dto.getStoreCountrySortDTOList();
        Assert.notNull((Object)storeId, (String)"\u7f3a\u5c11storeId", (Object[])new Object[0]);
        ArrayList<StoreCountrySort> storeCountrySorts = new ArrayList<StoreCountrySort>(storeCountrySortDTOS.size());
        for (StoreCountrySortDTO storeCountrySortDTO : storeCountrySortDTOS) {
            if (!ObjectUtil.isNotNull((Object)storeCountrySortDTO.getSortNo())) continue;
            StoreCountrySort storeCountrySort = new StoreCountrySort();
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)storeCountrySort);
            storeCountrySort.setPsStoreId(storeId);
            storeCountrySort.setCountryId(storeCountrySortDTO.getCountryId());
            storeCountrySort.setSortNo(storeCountrySortDTO.getSortNo());
            storeCountrySort.setId(this.idSequence.generateId(StoreCountrySort.class));
            storeCountrySorts.add(storeCountrySort);
        }
        this.storeCountrySortService.removeOldAndSaveNewSort(storeId, storeCountrySorts);
    }

    public List<StoreCountrySortVO> getByStoreId(Long storeId) {
        Long loginStoreId = this.userInfoUtil.getStoreId();
        if (ObjectUtil.isNotNull((Object)loginStoreId)) {
            storeId = loginStoreId;
        }
        Assert.notNull((Object)storeId, (String)"\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.storeCountrySortService.getByStoreId(storeId);
    }

    public StoreCountrySortBiz(StoreCountrySortService storeCountrySortService, BaseDaoInitialService baseDaoInitialService, IdSequenceGenerator idSequence, UserInfoUtil userInfoUtil, SkuShelfBiz skuShelfBiz) {
        this.storeCountrySortService = storeCountrySortService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.idSequence = idSequence;
        this.userInfoUtil = userInfoUtil;
        this.skuShelfBiz = skuShelfBiz;
    }
}

