/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.google.common.collect.Lists;
import com.xinqiyi.dynamicform.model.dto.DictValue;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.StorePayTypeSwitchVO;
import com.xinqiyi.ps.dao.repository.StorePayTypeSwitchService;
import com.xinqiyi.ps.model.dto.store.StoreDTO;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.model.entity.StorePayTypeSwitch;
import com.xinqiyi.ps.service.adapter.MdmAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class StorePayTypeSwitchBiz {
    private static final Logger log = LoggerFactory.getLogger(StorePayTypeSwitchBiz.class);
    private final StorePayTypeSwitchService payTypeSwitchService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final IdSequenceGenerator idSequence;
    private final MdmAdapter mdmAdapter;

    public List<StorePayTypeSwitch> getStorePayTypeSwitchList(StoreDTO storeDTO, Store store) {
        ArrayList storePayTypeSwitchList = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)storeDTO.getPayTypeSwitchDTOList())) {
            storeDTO.getPayTypeSwitchDTOList().stream().forEach(a -> {
                StorePayTypeSwitch storePayTypeSwitch = new StorePayTypeSwitch();
                BeanUtils.copyProperties((Object)a, (Object)storePayTypeSwitch);
                storePayTypeSwitch.setPsStoreId(store.getId());
                if (null == a.getId()) {
                    storePayTypeSwitch.setId(this.idSequence.generateId(StorePayTypeSwitch.class));
                    this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)storePayTypeSwitch);
                } else {
                    this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)storePayTypeSwitch);
                }
                storePayTypeSwitchList.add(storePayTypeSwitch);
            });
        }
        return storePayTypeSwitchList;
    }

    public List<StorePayTypeSwitchVO> getStorePayTypeSwitchVOList(List<Long> storeIdList) {
        ArrayList storePayTypeSwitchVOList = Lists.newArrayList();
        List storePayTypeSwitchAllList = this.payTypeSwitchService.selectStorePayTypeSwitchByStoreIdList(storeIdList);
        List<DictValue> dictValueList = this.mdmAdapter.selectDictByCode("STORE_PAY_TYPE_SWITCH");
        Assert.isTrue((boolean)CollUtil.isNotEmpty(dictValueList), (String)"\u8bf7\u68c0\u67e5\u5e97\u94fa\u652f\u4ed8\u7c7b\u578b\u662f\u5426\u914d\u7f6e", (Object[])new Object[0]);
        if (CollUtil.isEmpty((Collection)storePayTypeSwitchAllList)) {
            this.getDefaultSwitchVOList(null, dictValueList, storePayTypeSwitchVOList);
            return storePayTypeSwitchVOList;
        }
        Map<Long, List<StorePayTypeSwitch>> listMap = storePayTypeSwitchAllList.stream().collect(Collectors.groupingBy(StorePayTypeSwitch::getPsStoreId));
        for (Long storeId : storeIdList) {
            List<StorePayTypeSwitch> storePayTypeSwitchList = listMap.get(storeId);
            if (CollUtil.isEmpty(storePayTypeSwitchList)) {
                this.getDefaultSwitchVOList(storeId, dictValueList, storePayTypeSwitchVOList);
                continue;
            }
            for (DictValue dictValue : dictValueList) {
                Integer code = Integer.parseInt(String.valueOf(dictValue.getValueCode()));
                StorePayTypeSwitchVO storePayTypeSwitchVO = new StorePayTypeSwitchVO();
                StorePayTypeSwitch storePayTypeSwitch = storePayTypeSwitchList.stream().filter(a -> a.getPayType().equals(code)).findAny().orElse(null);
                storePayTypeSwitchVO.setAccountStyle(dictValue.getExtend2());
                if (null != storePayTypeSwitch) {
                    BeanUtils.copyProperties((Object)storePayTypeSwitch, (Object)storePayTypeSwitchVO);
                    storePayTypeSwitchVO.setPayTypeName(dictValue.getName());
                    storePayTypeSwitchVO.setShowName(StringUtils.isNotEmpty((CharSequence)storePayTypeSwitch.getShowName()) ? storePayTypeSwitch.getShowName() : dictValue.getName());
                    storePayTypeSwitchVOList.add(storePayTypeSwitchVO);
                    continue;
                }
                storePayTypeSwitchVO.setPsStoreId(storeId);
                storePayTypeSwitchVO.setPayType(Integer.valueOf(Integer.parseInt(String.valueOf(dictValue.getValueCode()))));
                storePayTypeSwitchVO.setIsOpen(Integer.valueOf(0));
                storePayTypeSwitchVO.setPayTypeName(dictValue.getName());
                storePayTypeSwitchVOList.add(storePayTypeSwitchVO);
            }
        }
        return storePayTypeSwitchVOList;
    }

    private void getDefaultSwitchVOList(Long storeId, List<DictValue> dictValueList, List<StorePayTypeSwitchVO> storePayTypeSwitchVOList) {
        for (DictValue dictValue : dictValueList) {
            StorePayTypeSwitchVO storePayTypeSwitchVO = new StorePayTypeSwitchVO();
            storePayTypeSwitchVO.setPayType(Integer.valueOf(Integer.parseInt(String.valueOf(dictValue.getValueCode()))));
            storePayTypeSwitchVO.setIsOpen(Integer.valueOf(0));
            storePayTypeSwitchVO.setPayTypeName(dictValue.getName());
            storePayTypeSwitchVO.setAccountStyle(dictValue.getExtend2());
            storePayTypeSwitchVO.setPsStoreId(storeId);
            storePayTypeSwitchVOList.add(storePayTypeSwitchVO);
        }
    }

    public List<StorePayTypeSwitchVO> getStorePayTypeSwitchVOList(Long storeId, Boolean isPc) {
        ArrayList storePayTypeSwitchVOList = Lists.newArrayList();
        List storePayTypeSwitchList = this.payTypeSwitchService.selectStorePayTypeSwitchByStoreId(storeId);
        List<DictValue> dictValueList = this.mdmAdapter.selectDictByCode("STORE_PAY_TYPE_SWITCH");
        if (CollUtil.isEmpty(dictValueList)) {
            if (null != isPc && isPc.booleanValue()) {
                return storePayTypeSwitchVOList;
            }
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u5e97\u94fa\u652f\u4ed8\u7c7b\u578b\u662f\u5426\u914d\u7f6e");
        }
        if (CollUtil.isNotEmpty((Collection)storePayTypeSwitchList)) {
            for (DictValue dictValue : dictValueList) {
                Integer code = Integer.parseInt(String.valueOf(dictValue.getValueCode()));
                StorePayTypeSwitchVO storePayTypeSwitchVO = new StorePayTypeSwitchVO();
                StorePayTypeSwitch storePayTypeSwitch = storePayTypeSwitchList.stream().filter(a -> a.getPayType().equals(code)).findAny().orElse(null);
                storePayTypeSwitchVO.setAccountStyle(dictValue.getExtend2());
                if (null != storePayTypeSwitch) {
                    BeanUtils.copyProperties((Object)storePayTypeSwitch, (Object)storePayTypeSwitchVO);
                    storePayTypeSwitchVO.setPayTypeName(dictValue.getName());
                    storePayTypeSwitchVO.setShowName(StringUtils.isNotEmpty((CharSequence)storePayTypeSwitch.getShowName()) ? storePayTypeSwitch.getShowName() : dictValue.getName());
                    storePayTypeSwitchVOList.add(storePayTypeSwitchVO);
                    continue;
                }
                storePayTypeSwitchVO.setPayType(Integer.valueOf(Integer.parseInt(String.valueOf(dictValue.getValueCode()))));
                storePayTypeSwitchVO.setIsOpen(Integer.valueOf(0));
                storePayTypeSwitchVO.setPayTypeName(dictValue.getName());
                storePayTypeSwitchVOList.add(storePayTypeSwitchVO);
            }
        } else {
            this.getDefaultSwitchVOList(null, dictValueList, storePayTypeSwitchVOList);
        }
        if (null != isPc && isPc.booleanValue()) {
            return storePayTypeSwitchVOList.stream().filter(a -> Integer.valueOf(1).equals(a.getIsOpen())).collect(Collectors.toList());
        }
        return storePayTypeSwitchVOList;
    }

    public StorePayTypeSwitchBiz(StorePayTypeSwitchService payTypeSwitchService, BaseDaoInitialService baseDaoInitialService, IdSequenceGenerator idSequence, MdmAdapter mdmAdapter) {
        this.payTypeSwitchService = payTypeSwitchService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.idSequence = idSequence;
        this.mdmAdapter = mdmAdapter;
    }
}

