/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.dao.repository.PsStorePlatformAccountService;
import com.xinqiyi.ps.model.dto.store.PsStorePlatformAccountDTO;
import com.xinqiyi.ps.model.dto.store.StoreDTO;
import com.xinqiyi.ps.model.entity.PsStorePlatform;
import com.xinqiyi.ps.model.entity.PsStorePlatformAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class StorePlatformAccountBiz {
    @Autowired
    private PsStorePlatformAccountService psStorePlatformAccountService;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private IdSequenceGenerator idSequence;

    public List<PsStorePlatformAccount> covert(StoreDTO dto, PsStorePlatform psStorePlatform, Long storeId) {
        List dtos = dto.getStorePlatformAccountList();
        Map<String, List<PsStorePlatformAccountDTO>> map = dtos.stream().collect(Collectors.groupingBy(PsStorePlatformAccountDTO::getType));
        Assert.isTrue((map.size() == dtos.size() ? 1 : 0) != 0, (String)"\u6536\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u91cd\u590d");
        List idList = dtos.stream().filter(item -> item.getId() != null).map(PsStorePlatformAccountDTO::getId).collect(Collectors.toList());
        List psStorePlatformAccountList = CollUtil.newArrayList((Object[])new PsStorePlatformAccount[0]);
        if (CollUtil.isNotEmpty(idList)) {
            psStorePlatformAccountList = this.psStorePlatformAccountService.listByIds(idList);
        }
        ArrayList psStorePlatformAccounts = CollUtil.newArrayList((Object[])new PsStorePlatformAccount[0]);
        for (PsStorePlatformAccountDTO psStorePlatformAccountDTO : dtos) {
            PsStorePlatformAccount psStorePlatformAccount;
            if (psStorePlatformAccountDTO.getId() != null) {
                psStorePlatformAccount = psStorePlatformAccountList.stream().filter(item -> ObjectUtil.equal((Object)psStorePlatformAccountDTO.getId(), (Object)item.getId())).findAny().orElse(null);
                Assert.notNull((Object)psStorePlatformAccount, (String)"\u5e97\u94fa\u5e73\u53f0\u6536\u6b3e\u8d26\u53f7\u4e0d\u5b58\u5728");
                this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)psStorePlatformAccount);
            } else {
                psStorePlatformAccount = new PsStorePlatformAccount();
                psStorePlatformAccount.setId(this.idSequence.generateId(PsStorePlatformAccount.class));
                psStorePlatformAccount.setPsStoreId(storeId);
                psStorePlatformAccount.setPsStorePlatformId(psStorePlatform.getId());
            }
            psStorePlatformAccount.setAccount(psStorePlatformAccountDTO.getAccount());
            psStorePlatformAccount.setBankName(psStorePlatformAccountDTO.getBankName());
            psStorePlatformAccount.setIsEnable(psStorePlatformAccountDTO.getIsEnable());
            psStorePlatformAccount.setType(psStorePlatformAccountDTO.getType());
            psStorePlatformAccounts.add(psStorePlatformAccount);
        }
        return psStorePlatformAccounts;
    }
}

