/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Sets;
import com.xinqiyi.fc.model.enums.FcCommonEnum;
import com.xinqiyi.framework.bizlog.entity.BizLogInfo;
import com.xinqiyi.framework.bizlog.service.BizLogWrapperService;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.framework.util.BigDecimalUtil;
import com.xinqiyi.ps.api.model.vo.StorePointManagementConfigCusTagVO;
import com.xinqiyi.ps.api.model.vo.StorePointManagementConfigVO;
import com.xinqiyi.ps.dao.repository.PsStorePointManagementConfigCusTagService;
import com.xinqiyi.ps.dao.repository.PsStorePointManagementConfigService;
import com.xinqiyi.ps.dao.repository.PsTagService;
import com.xinqiyi.ps.dao.repository.StoreService;
import com.xinqiyi.ps.model.dto.enums.PointManagementCusTagTypeEnum;
import com.xinqiyi.ps.model.dto.enums.StoreTypeEnum;
import com.xinqiyi.ps.model.dto.store.StorePointManagementConfigDTO;
import com.xinqiyi.ps.model.entity.PsTag;
import com.xinqiyi.ps.model.entity.Store;
import com.xinqiyi.ps.model.entity.StorePointManagementConfig;
import com.xinqiyi.ps.model.entity.StorePointManagementConfigCusTag;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Component
public class StorePointManagementBiz {
    private final PsStorePointManagementConfigService storePointManagementConfigService;
    private final PsStorePointManagementConfigCusTagService storePointManagementConfigCusTagService;
    private final BaseDaoInitialService baseDaoInitialService;
    private final IdSequenceGenerator idSequence;
    private final BizLogWrapperService bizLogWrapperService;
    private final PsTagService tagService;
    private final StoreService storeService;

    @Transactional(rollbackFor={Exception.class})
    public Long save(StorePointManagementConfigDTO dto) {
        Assert.notNull((Object)dto.getPsStoreId(), (String)"\u5e97\u94faid\u4e0d\u5f97\u4e3a\u7a7a");
        Store store = (Store)this.storeService.getById((Serializable)dto.getPsStoreId());
        Assert.notNull((Object)store, (String)"\u5e97\u94fa\u4e0d\u5b58\u5728");
        if (FcCommonEnum.YesOrNoEnum.YES.getValue().equals(dto.getEnablePointsSystem())) {
            if (!StrUtil.equals((CharSequence)StoreTypeEnum.ONE.getCode(), (CharSequence)store.getStoreType()) && BigDecimalUtil.compareZero((BigDecimal)dto.getPointsPerCashPayment()) <= 0) {
                throw new IllegalArgumentException("\u6bcf\u7b14\u8ba2\u5355\u73b0\u91d1\u652f\u4ed8\u91d1\u989d\u6bcf\u6ee1\u3010\u3011\u5143\u83b7\u53d61\u79ef\u5206,\u53d6\u503c\u5fc5\u987b\u5927\u4e8e0");
            }
            if (BigDecimalUtil.compareZero((BigDecimal)dto.getOrderPointsUsageRatio()) <= 0) {
                throw new IllegalArgumentException("\u8ba2\u5355\u53ef\u7528\u79ef\u5206\u6bd4\u4f8b\u3010\u3011%,\u53d6\u503c\u5fc5\u987b\u5927\u4e8e0");
            }
            if (BigDecimalUtil.compareZero((BigDecimal)dto.getPointsPerCurrency()) <= 0) {
                throw new IllegalArgumentException("\u79ef\u5206\u5151\u6362\u6bd4\u4f8b:\u6bcf\u3010\u3011\u79ef\u5206\u5151\u63621\u5143,\u53d6\u503c\u5fc5\u987b\u5927\u4e8e0");
            }
        }
        StorePointManagementConfig storePointManagementConfig = new StorePointManagementConfig();
        List<StorePointManagementConfigCusTag> cusTagList = this.getPsStorePointManagementCusTags(dto);
        BeanUtils.copyProperties((Object)dto, (Object)storePointManagementConfig);
        ArrayList logList = Lists.newArrayList();
        this.buildTagLog(dto, logList);
        if (Objects.nonNull(dto.getId())) {
            this.storePointManagementConfigCusTagService.remove((Wrapper)Wrappers.lambdaQuery(StorePointManagementConfigCusTag.class).eq(StorePointManagementConfigCusTag::getPsStoreId, (Object)dto.getPsStoreId()));
            this.baseDaoInitialService.initialUpdateBaseDaoSystemValue((BaseDo)storePointManagementConfig);
            if (FcCommonEnum.YesOrNoEnum.YES.getValue().equals(storePointManagementConfig.getEnablePointsSystem())) {
                StorePointManagementConfig config = (StorePointManagementConfig)this.storePointManagementConfigService.getById((Serializable)dto.getId());
                if (FcCommonEnum.YesOrNoEnum.NO.getValue().equals(config.getEnablePointsSystem())) {
                    storePointManagementConfig.setEnablePointsSystemTime((Date)DateUtil.date());
                }
            }
        } else {
            storePointManagementConfig.setId(this.idSequence.generateId(StorePointManagementConfig.class));
            dto.setId(storePointManagementConfig.getId());
            if (FcCommonEnum.YesOrNoEnum.YES.getValue().equals(storePointManagementConfig.getEnablePointsSystem())) {
                storePointManagementConfig.setEnablePointsSystemTime((Date)DateUtil.date());
            }
            this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)storePointManagementConfig);
        }
        if (CollUtil.isNotEmpty((Collection)logList)) {
            this.bizLogWrapperService.manualSaveOperateLog("ps_log", (List)logList);
        }
        this.storePointManagementConfigService.saveOrUpdate((Object)storePointManagementConfig);
        if (CollUtil.isNotEmpty(cusTagList)) {
            this.storePointManagementConfigCusTagService.saveBatch(cusTagList);
        }
        return storePointManagementConfig.getId();
    }

    private void buildTagLog(StorePointManagementConfigDTO dto, List<BizLogInfo> logList) {
        List storePointManagementConfigCusTagsInDb = this.storePointManagementConfigCusTagService.listCustomerTagIdAndStoreId(null, dto.getPsStoreId());
        Set selfTagIdInDb = CollUtil.newHashSet((Object[])new Long[0]);
        Set selfManualTagIdInDb = CollUtil.newHashSet((Object[])new Long[0]);
        if (CollUtil.isNotEmpty((Collection)storePointManagementConfigCusTagsInDb)) {
            Map typeTagIdMap = storePointManagementConfigCusTagsInDb.stream().collect(Collectors.groupingBy(StorePointManagementConfigCusTag::getType, Collectors.mapping(StorePointManagementConfigCusTag::getCustomerTagId, Collectors.toSet())));
            selfManualTagIdInDb = typeTagIdMap.getOrDefault(PointManagementCusTagTypeEnum.SELF_MANUAL_ORDER.getCode(), CollUtil.newHashSet((Object[])new Long[0]));
            selfTagIdInDb = typeTagIdMap.getOrDefault(PointManagementCusTagTypeEnum.SELF_ORDER.getCode(), CollUtil.newHashSet((Object[])new Long[0]));
        }
        ChangeTagInfo selfManualChangeTagInfo = this.getChangeTagNameList(selfManualTagIdInDb, CollUtil.newHashSet((Collection)dto.getSelfManualOrderCustomerTagIdList()));
        this.getOperLog(PointManagementCusTagTypeEnum.SELF_MANUAL_ORDER, dto.getId(), selfManualChangeTagInfo, logList);
        ChangeTagInfo selfChangeTagInfo = this.getChangeTagNameList(selfTagIdInDb, CollUtil.newHashSet((Collection)dto.getSelfOrderCustomerTagIdList()));
        this.getOperLog(PointManagementCusTagTypeEnum.SELF_ORDER, dto.getId(), selfChangeTagInfo, logList);
    }

    private ChangeTagInfo getChangeTagNameList(Set<Long> tagIdInDb, Set<Long> tagIdInDto) {
        ArrayList allTagIdList = Lists.newArrayList();
        if (CollUtil.isEmpty(tagIdInDb) && CollUtil.isEmpty(tagIdInDto)) {
            return null;
        }
        if (this.checkListEqual(tagIdInDto, tagIdInDb)) {
            return null;
        }
        if (CollUtil.isNotEmpty(tagIdInDb)) {
            allTagIdList.addAll(tagIdInDb);
        }
        if (CollUtil.isNotEmpty(tagIdInDto)) {
            allTagIdList.addAll(tagIdInDto);
        }
        List psTagList = this.tagService.listByIds((Collection)allTagIdList);
        ArrayList beforeTagNameList = Lists.newArrayList();
        ArrayList afterTagNameList = Lists.newArrayList();
        for (PsTag tag : psTagList) {
            if (tagIdInDb.contains(tag.getId())) {
                beforeTagNameList.add(tag.getName());
            }
            if (!tagIdInDto.contains(tag.getId())) continue;
            afterTagNameList.add(tag.getName());
        }
        return new ChangeTagInfo(CollUtil.newArrayList(tagIdInDb), CollUtil.newArrayList(tagIdInDto), beforeTagNameList, afterTagNameList);
    }

    public boolean checkListEqual(Collection<Long> param1, Collection<Long> param2) {
        if (param2 == null && param1 == null) {
            return true;
        }
        if (param1 == null || param2 == null) {
            return false;
        }
        HashSet<Long> paramSet1 = new HashSet<Long>(param1);
        HashSet<Long> paramSet2 = new HashSet<Long>(param2);
        return paramSet1.equals(paramSet2);
    }

    private void getOperLog(PointManagementCusTagTypeEnum cusTagTypeEnum, Long masterTableId, ChangeTagInfo tagInfo, List<BizLogInfo> logList) {
        if (masterTableId == null || tagInfo == null) {
            return;
        }
        BizLogInfo bizLogInfo = new BizLogInfo();
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)bizLogInfo);
        bizLogInfo.setId(this.idSequence.generateId("ps_log"));
        bizLogInfo.setOperateDataId(masterTableId);
        if (CollUtil.isNotEmpty(tagInfo.getBeforeTagNameList())) {
            bizLogInfo.setOperateTypeCode("UPDATE");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u66f4\u6539");
            bizLogInfo.setOperateTableDesc("ITEM_UPDATE");
            bizLogInfo.setBeforeUpdateValue(tagInfo.getBeforeTagIdList().stream().map(String::valueOf).collect(Collectors.joining(",")));
            bizLogInfo.setBeforeUpdateValueDesc(String.join((CharSequence)",", tagInfo.getBeforeTagNameList()));
        } else {
            bizLogInfo.setOperateTypeCode("INSERT");
            bizLogInfo.setOperateTypeDesc("\u660e\u7ec6\u65b0\u589e");
            bizLogInfo.setOperateTableDesc("ITEM_INSERT");
        }
        bizLogInfo.setAfterUpdateValue(tagInfo.getAfterTagIdList().stream().map(String::valueOf).collect(Collectors.joining(",")));
        bizLogInfo.setAfterUpdateValueDesc(String.join((CharSequence)",", tagInfo.getAfterTagNameList()));
        bizLogInfo.setOperateTableName("ps_store_point_management_config");
        bizLogInfo.setOperateTableDesc("\u5546\u57ce\u5e73\u53f0-\u79ef\u5206\u7ba1\u7406\u914d\u7f6eid:" + masterTableId);
        bizLogInfo.setOperateColumnName("customer_tag_id");
        bizLogInfo.setOperateColumnDesc(cusTagTypeEnum.getDesc() + "\u5ba2\u6237\u6807\u7b7e");
        logList.add(bizLogInfo);
    }

    private List<StorePointManagementConfigCusTag> getPsStorePointManagementCusTags(StorePointManagementConfigDTO dto) {
        ArrayList cusTagList = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)dto.getSelfOrderCustomerTagIdList())) {
            dto.getSelfOrderCustomerTagIdList().forEach(item -> {
                StorePointManagementConfigCusTag pointManagementCusTag = new StorePointManagementConfigCusTag();
                pointManagementCusTag.setId(this.idSequence.generateId(StorePointManagementConfigCusTag.class));
                pointManagementCusTag.setPsStoreId(dto.getPsStoreId());
                pointManagementCusTag.setCustomerTagId(item);
                pointManagementCusTag.setType(PointManagementCusTagTypeEnum.SELF_ORDER.getCode());
                cusTagList.add(pointManagementCusTag);
            });
        }
        if (CollUtil.isNotEmpty((Collection)dto.getSelfManualOrderCustomerTagIdList())) {
            dto.getSelfManualOrderCustomerTagIdList().forEach(item -> {
                StorePointManagementConfigCusTag pointManagementCusTag = new StorePointManagementConfigCusTag();
                pointManagementCusTag.setId(this.idSequence.generateId(StorePointManagementConfigCusTag.class));
                pointManagementCusTag.setPsStoreId(dto.getPsStoreId());
                pointManagementCusTag.setCustomerTagId(item);
                pointManagementCusTag.setType(PointManagementCusTagTypeEnum.SELF_MANUAL_ORDER.getCode());
                cusTagList.add(pointManagementCusTag);
            });
        }
        return cusTagList;
    }

    public StorePointManagementConfigVO getByStoreIdWithTagName(Long storeId) {
        HashSet selfManualOrderCustomerTagIdSet;
        StorePointManagementConfigVO config = this.getByStoreId(storeId);
        if (Objects.isNull(config)) {
            return null;
        }
        ArrayList cusTagIdList = Lists.newArrayList();
        HashSet selfOrderCustomerTagIdSet = Sets.newHashSet((Iterable)config.getSelfOrderCustomerTagIdList());
        if (CollUtil.isNotEmpty((Collection)selfOrderCustomerTagIdSet)) {
            cusTagIdList.addAll(selfOrderCustomerTagIdSet);
        }
        if (CollUtil.isNotEmpty((Collection)(selfManualOrderCustomerTagIdSet = Sets.newHashSet((Iterable)config.getSelfManualOrderCustomerTagIdList())))) {
            cusTagIdList.addAll(selfManualOrderCustomerTagIdSet);
        }
        if (CollUtil.isEmpty((Collection)cusTagIdList)) {
            return config;
        }
        List cusTagList = this.tagService.listByIds((Collection)cusTagIdList);
        ArrayList selfOrderCustomerTagNameList = Lists.newArrayList();
        ArrayList selfManualOrderCustomerTagNameList = Lists.newArrayList();
        for (PsTag tag : cusTagList) {
            if (selfOrderCustomerTagIdSet.contains(tag.getId())) {
                selfOrderCustomerTagNameList.add(tag.getName());
            }
            if (!selfManualOrderCustomerTagIdSet.contains(tag.getId())) continue;
            selfManualOrderCustomerTagNameList.add(tag.getName());
        }
        config.setSelfOrderCustomerTagNameList((List)selfOrderCustomerTagNameList);
        config.setSelfManualOrderCustomerTagNameList((List)selfManualOrderCustomerTagNameList);
        return config;
    }

    public StorePointManagementConfigVO getByStoreId(Long storeId) {
        List tagIdList;
        Assert.notNull((Object)storeId, (String)"\u5e97\u94faid\u4e0d\u5f97\u4e3a\u7a7a");
        StorePointManagementConfig storePointManagement = (StorePointManagementConfig)this.storePointManagementConfigService.getOne((Wrapper)Wrappers.lambdaQuery(StorePointManagementConfig.class).eq(StorePointManagementConfig::getPsStoreId, (Object)storeId));
        if (Objects.isNull(storePointManagement)) {
            return null;
        }
        StorePointManagementConfigVO storePointManagementConfigVO = new StorePointManagementConfigVO();
        BeanUtils.copyProperties((Object)storePointManagement, (Object)storePointManagementConfigVO);
        List storePointManagementCusTagList = this.storePointManagementConfigCusTagService.listCustomerTagIdAndStoreId(null, storeId);
        Map<Integer, List<StorePointManagementConfigCusTag>> cusTagMap = storePointManagementCusTagList.stream().collect(Collectors.groupingBy(StorePointManagementConfigCusTag::getType));
        List<StorePointManagementConfigCusTag> selfOrderCustomerTagList = cusTagMap.get(PointManagementCusTagTypeEnum.SELF_ORDER.getCode());
        List<StorePointManagementConfigCusTag> selfManualOrderCustomerTagList = cusTagMap.get(PointManagementCusTagTypeEnum.SELF_MANUAL_ORDER.getCode());
        if (CollUtil.isNotEmpty(selfOrderCustomerTagList)) {
            tagIdList = selfOrderCustomerTagList.stream().map(StorePointManagementConfigCusTag::getCustomerTagId).collect(Collectors.toList());
            storePointManagementConfigVO.setSelfOrderCustomerTagIdList(tagIdList);
        }
        if (CollUtil.isNotEmpty(selfManualOrderCustomerTagList)) {
            tagIdList = selfManualOrderCustomerTagList.stream().map(StorePointManagementConfigCusTag::getCustomerTagId).collect(Collectors.toList());
            storePointManagementConfigVO.setSelfManualOrderCustomerTagIdList(tagIdList);
        }
        return storePointManagementConfigVO;
    }

    public List<StorePointManagementConfigCusTagVO> queryStoreTagList(StorePointManagementConfigDTO dto) {
        Assert.notEmpty((Collection)dto.getCustomerTagIdList(), (String)"\u5ba2\u6237\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a");
        List list = this.storePointManagementConfigCusTagService.listCustomerTagIdAndStoreId(dto.getCustomerTagIdList(), null);
        ArrayList result = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)list)) {
            BeanUtils.copyProperties((Object)list, (Object)result);
        }
        return result;
    }

    public StorePointManagementBiz(PsStorePointManagementConfigService storePointManagementConfigService, PsStorePointManagementConfigCusTagService storePointManagementConfigCusTagService, BaseDaoInitialService baseDaoInitialService, IdSequenceGenerator idSequence, BizLogWrapperService bizLogWrapperService, PsTagService tagService, StoreService storeService) {
        this.storePointManagementConfigService = storePointManagementConfigService;
        this.storePointManagementConfigCusTagService = storePointManagementConfigCusTagService;
        this.baseDaoInitialService = baseDaoInitialService;
        this.idSequence = idSequence;
        this.bizLogWrapperService = bizLogWrapperService;
        this.tagService = tagService;
        this.storeService = storeService;
    }

    public static class ChangeTagInfo {
        List<Long> beforeTagIdList;
        List<Long> afterTagIdList;
        List<String> beforeTagNameList;
        List<String> afterTagNameList;

        public List<Long> getBeforeTagIdList() {
            return this.beforeTagIdList;
        }

        public List<Long> getAfterTagIdList() {
            return this.afterTagIdList;
        }

        public List<String> getBeforeTagNameList() {
            return this.beforeTagNameList;
        }

        public List<String> getAfterTagNameList() {
            return this.afterTagNameList;
        }

        public void setBeforeTagIdList(List<Long> beforeTagIdList) {
            this.beforeTagIdList = beforeTagIdList;
        }

        public void setAfterTagIdList(List<Long> afterTagIdList) {
            this.afterTagIdList = afterTagIdList;
        }

        public void setBeforeTagNameList(List<String> beforeTagNameList) {
            this.beforeTagNameList = beforeTagNameList;
        }

        public void setAfterTagNameList(List<String> afterTagNameList) {
            this.afterTagNameList = afterTagNameList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangeTagInfo)) {
                return false;
            }
            ChangeTagInfo other = (ChangeTagInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Long> this$beforeTagIdList = this.getBeforeTagIdList();
            List<Long> other$beforeTagIdList = other.getBeforeTagIdList();
            if (this$beforeTagIdList == null ? other$beforeTagIdList != null : !((Object)this$beforeTagIdList).equals(other$beforeTagIdList)) {
                return false;
            }
            List<Long> this$afterTagIdList = this.getAfterTagIdList();
            List<Long> other$afterTagIdList = other.getAfterTagIdList();
            if (this$afterTagIdList == null ? other$afterTagIdList != null : !((Object)this$afterTagIdList).equals(other$afterTagIdList)) {
                return false;
            }
            List<String> this$beforeTagNameList = this.getBeforeTagNameList();
            List<String> other$beforeTagNameList = other.getBeforeTagNameList();
            if (this$beforeTagNameList == null ? other$beforeTagNameList != null : !((Object)this$beforeTagNameList).equals(other$beforeTagNameList)) {
                return false;
            }
            List<String> this$afterTagNameList = this.getAfterTagNameList();
            List<String> other$afterTagNameList = other.getAfterTagNameList();
            return !(this$afterTagNameList == null ? other$afterTagNameList != null : !((Object)this$afterTagNameList).equals(other$afterTagNameList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChangeTagInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Long> $beforeTagIdList = this.getBeforeTagIdList();
            result = result * 59 + ($beforeTagIdList == null ? 43 : ((Object)$beforeTagIdList).hashCode());
            List<Long> $afterTagIdList = this.getAfterTagIdList();
            result = result * 59 + ($afterTagIdList == null ? 43 : ((Object)$afterTagIdList).hashCode());
            List<String> $beforeTagNameList = this.getBeforeTagNameList();
            result = result * 59 + ($beforeTagNameList == null ? 43 : ((Object)$beforeTagNameList).hashCode());
            List<String> $afterTagNameList = this.getAfterTagNameList();
            result = result * 59 + ($afterTagNameList == null ? 43 : ((Object)$afterTagNameList).hashCode());
            return result;
        }

        public String toString() {
            return "StorePointManagementBiz.ChangeTagInfo(beforeTagIdList=" + String.valueOf(this.getBeforeTagIdList()) + ", afterTagIdList=" + String.valueOf(this.getAfterTagIdList()) + ", beforeTagNameList=" + String.valueOf(this.getBeforeTagNameList()) + ", afterTagNameList=" + String.valueOf(this.getAfterTagNameList()) + ")";
        }

        public ChangeTagInfo(List<Long> beforeTagIdList, List<Long> afterTagIdList, List<String> beforeTagNameList, List<String> afterTagNameList) {
            this.beforeTagIdList = beforeTagIdList;
            this.afterTagIdList = afterTagIdList;
            this.beforeTagNameList = beforeTagNameList;
            this.afterTagNameList = afterTagNameList;
        }
    }
}

