/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xinqiyi.framework.auth.GateWayWebAuthService;
import com.xinqiyi.framework.auth.model.LoginUserInfo;
import com.xinqiyi.framework.business.service.BaseDaoInitialService;
import com.xinqiyi.framework.model.BaseDo;
import com.xinqiyi.framework.sequence.IdSequenceGenerator;
import com.xinqiyi.ps.api.model.vo.unit.UnitVO;
import com.xinqiyi.ps.dao.mapper.mysql.UnitMapper;
import com.xinqiyi.ps.dao.repository.impl.SpuServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.UnitServiceImpl;
import com.xinqiyi.ps.model.dto.page.PageResult;
import com.xinqiyi.ps.model.dto.unit.UnitAddDTO;
import com.xinqiyi.ps.model.dto.unit.UnitOprDTO;
import com.xinqiyi.ps.model.dto.unit.UnitQueryDTO;
import com.xinqiyi.ps.model.dto.unit.UnitUpdateDTO;
import com.xinqiyi.ps.model.entity.Unit;
import com.xinqiyi.ps.service.util.BeanConvertUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class UnitBiz {
    private static final Logger log = LoggerFactory.getLogger(UnitBiz.class);
    @Autowired
    private UnitServiceImpl unitService;
    @Autowired
    private IdSequenceGenerator idSequenceGenerator;
    @Autowired
    private BaseDaoInitialService baseDaoInitialService;
    @Autowired
    private GateWayWebAuthService gateWayWebAuthService;
    @Autowired
    private SpuServiceImpl spuService;

    public Long saveUnit(UnitAddDTO dto) {
        Unit unit = this.unitService.getUnitByName(dto.getName());
        if (unit != null) {
            return unit.getId();
        }
        Assert.isTrue((boolean)ObjectUtil.isNull((Object)unit), (String)"\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        unit = new Unit();
        Long unitId = this.idSequenceGenerator.generateId(Unit.class);
        unit.setId(unitId);
        unit.setCode(dto.getCode());
        unit.setName(dto.getName());
        unit.setStatus(Integer.valueOf(1));
        this.baseDaoInitialService.initialInsertBaseDaoSystemValue((BaseDo)unit);
        this.unitService.save((Object)unit);
        return unitId;
    }

    public void updateUnit(UnitUpdateDTO dto) {
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        Unit unit = (Unit)this.unitService.getById((Serializable)dto.getId());
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)unit), (String)"\u5355\u4f4d\u6570\u636e\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)Integer.valueOf(1).equals(unit.getStatus()), (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91");
        Unit unitByName = this.unitService.getUnitByName(dto.getName());
        if (null != unitByName && !dto.getId().equals(unitByName.getId())) {
            throw new IllegalArgumentException("\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        unit.setName(dto.getName());
        unit.setUpdateTime(new Date());
        unit.setUpdateUserName(userInfo.getName());
        this.unitService.updateById((Object)unit);
    }

    public UnitVO selectUnitDetails(Long id) {
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)id), (String)"\u5355\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        Unit unit = (Unit)this.unitService.getById((Serializable)id);
        Assert.isTrue((boolean)ObjectUtil.isNotNull((Object)unit), (String)"\u5355\u4f4d\u6570\u636e\u4e0d\u5b58\u5728");
        UnitVO vo = new UnitVO();
        BeanUtils.copyProperties((Object)unit, (Object)vo);
        return vo;
    }

    public UnitVO selectUnitByName(String unitName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Unit::getName, (Object)unitName);
        Unit unit = (Unit)((UnitMapper)this.unitService.getBaseMapper()).selectOne((Wrapper)queryWrapper);
        if (unit == null) {
            return null;
        }
        UnitVO vo = new UnitVO();
        BeanUtils.copyProperties((Object)unit, (Object)vo);
        return vo;
    }

    public UnitVO selectUnitByCode(String unitCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Unit::getCode, (Object)unitCode);
        Unit unit = (Unit)((UnitMapper)this.unitService.getBaseMapper()).selectOne((Wrapper)queryWrapper);
        if (unit == null) {
            return null;
        }
        UnitVO vo = new UnitVO();
        BeanUtils.copyProperties((Object)unit, (Object)vo);
        return vo;
    }

    public PageResult selectUnitList(UnitQueryDTO dto) {
        Page page = new Page((long)dto.getPageNum(), (long)dto.getPageSize());
        IPage iPage = this.unitService.selectUnitList(page, dto);
        List<UnitVO> list = BeanConvertUtil.convertList(iPage.getRecords(), UnitVO.class);
        return new PageResult(dto.getPageNum(), dto.getPageSize(), page.getTotal()).setData(list);
    }

    public List<UnitVO> selectAllUnitList(UnitQueryDTO dto) {
        List unitList = this.unitService.selectAllUnitList(dto);
        return BeanConvertUtil.convertList(unitList, UnitVO.class);
    }

    public void updateBatchUnitStatus(UnitOprDTO dto) {
        ArrayList unitList = new ArrayList();
        LoginUserInfo userInfo = this.gateWayWebAuthService.getCurrentLoginUserInfo();
        Assert.isTrue((null != userInfo ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u83b7\u53d6\u5931\u8d25");
        dto.getIdList().forEach(id -> {
            Unit unit = (Unit)this.unitService.getById((Serializable)id);
            Assert.isTrue((null != unit ? 1 : 0) != 0, (String)("\u5355\u4f4d\u6570\u636e\u4e0d\u5b58\u5728,id\u4e3a\uff1a" + id));
            if (Integer.valueOf(3).equals(dto.getType())) {
                List spuList = this.spuService.selectSpuByUnitId(id);
                if (CollUtil.isNotEmpty((Collection)spuList)) {
                    throw new IllegalArgumentException("\u5355\u4f4d\u5df2\u88ab\u5546\u54c1\u4f7f\u7528,\u65e0\u6cd5\u5220\u9664,id\u4e3a\uff1a" + id);
                }
                unit.setIsDelete(Integer.valueOf(1));
            } else if (Integer.valueOf(1).equals(dto.getType())) {
                unit.setStatus(Integer.valueOf(2));
            } else if (Integer.valueOf(2).equals(dto.getType())) {
                List spuList = this.spuService.selectSpuByUnitId(id);
                if (CollUtil.isNotEmpty((Collection)spuList)) {
                    throw new IllegalArgumentException("\u5355\u4f4d\u5df2\u88ab\u5546\u54c1\u4f7f\u7528,\u65e0\u6cd5\u505c\u7528,id\u4e3a\uff1a" + id);
                }
                unit.setStatus(Integer.valueOf(3));
            } else {
                throw new IllegalArgumentException("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
            }
            unit.setUpdateTime(new Date());
            unit.setUpdateUserName(userInfo.getName());
            unitList.add(unit);
        });
        this.unitService.updateBatchById(unitList);
    }
}

