/*
 * Decompiled with CFR 0.152.
 */
package com.xinqiyi.ps.service.business.mall4j;

import cn.hutool.core.collection.CollUtil;
import com.xinqiyi.ps.dao.repository.impl.BrandClassServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.BrandServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.CategoryServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.SpecServiceImpl;
import com.xinqiyi.ps.dao.repository.impl.SpecValueServiceImpl;
import com.xinqiyi.ps.model.dto.sku.SpecDTO;
import com.xinqiyi.ps.model.dto.spec.SpecQueryDTO;
import com.xinqiyi.ps.model.entity.SpecValue;
import com.xinqiyi.ps.service.adapter.mall4j.MallFourJAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushMallFourJBiz {
    @Autowired
    private MallFourJAdapter mallFourJAdapter;
    @Autowired
    private CategoryServiceImpl categoryService;
    @Autowired
    private BrandClassServiceImpl brandClassService;
    @Autowired
    private BrandServiceImpl brandService;
    @Autowired
    private SpecServiceImpl specService;
    @Autowired
    private SpecValueServiceImpl specValueService;

    public void pushCategory() {
        List categoryList = this.categoryService.getAllCategory(null, "", null);
        if (CollUtil.isNotEmpty((Collection)categoryList)) {
            this.mallFourJAdapter.psCategorySaveToMallFourJ(categoryList);
        }
    }

    public void pushBrandClass() {
        List brandClassList = this.brandClassService.queryAllBrandClassList();
        if (CollUtil.isNotEmpty((Collection)brandClassList)) {
            this.mallFourJAdapter.brandCategorySaveToMallFourJ(brandClassList);
        }
    }

    public void pushBrand() {
        List brandList = this.brandService.selectAllBrand();
        if (CollUtil.isNotEmpty((Collection)brandList)) {
            this.mallFourJAdapter.brandSaveToMallFourJ(brandList);
        }
    }

    public void pushSpec() {
        SpecQueryDTO dto = new SpecQueryDTO();
        List specList = this.specService.selectAllSpecList(dto);
        if (CollUtil.isNotEmpty((Collection)specList)) {
            ArrayList<SpecDTO> specDTOList = new ArrayList<SpecDTO>();
            specList.stream().forEach(a -> {
                SpecDTO specDTO = new SpecDTO();
                specDTO.setPsSpecId(a.getId());
                specDTO.setPsSpecName(a.getName());
                List valueList = this.specValueService.getSpecValueListBySpecId(a.getId());
                if (CollUtil.isNotEmpty((Collection)valueList)) {
                    specDTO.setSpecValueNameList(valueList.stream().map(SpecValue::getValue).collect(Collectors.toList()));
                }
                specDTOList.add(specDTO);
            });
            this.mallFourJAdapter.saveSpecToMallFourJ(specDTOList);
        }
    }
}

